/*
 * Decompiled with CFR 0.152.
 */
package net.iakovlev.timeshape;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorContains;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.QuadTree;
import com.esri.core.geometry.SpatialReference;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.iakovlev.timeshape.SameZoneSpan;
import net.iakovlev.timeshape.proto.Geojson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Index {
    private static final int WGS84_WKID = 4326;
    private final ArrayList<Entry> zoneIds;
    private static final SpatialReference spatialReference = SpatialReference.create((int)4326);
    private final QuadTree quadTree;
    private static final Logger log = LoggerFactory.getLogger(Index.class);

    private Index(QuadTree quadTree, ArrayList<Entry> arrayList) {
        log.info("Initialized index with {} time zones", (Object)arrayList.size());
        this.quadTree = quadTree;
        this.zoneIds = arrayList;
    }

    List<ZoneId> getKnownZoneIds() {
        return this.zoneIds.stream().map(entry -> entry.zoneId).collect(Collectors.toList());
    }

    List<ZoneId> query(double d, double d2) {
        ArrayList<ZoneId> arrayList = new ArrayList<ZoneId>(2);
        Point point = new Point(d2, d);
        QuadTree.QuadTreeIterator quadTreeIterator = this.quadTree.getIterator((Geometry)point, 0.0);
        int n = quadTreeIterator.next();
        while (n >= 0) {
            int n2 = this.quadTree.getElement(n);
            Entry entry = this.zoneIds.get(n2);
            if (GeometryEngine.contains((Geometry)entry.geometry, (Geometry)point, (SpatialReference)spatialReference)) {
                arrayList.add(entry.zoneId);
            }
            n = quadTreeIterator.next();
        }
        return arrayList;
    }

    List<SameZoneSpan> queryPolyline(double[] dArray) {
        Object object;
        int n;
        Polyline polyline = new Polyline();
        ArrayList<Point> arrayList = new ArrayList<Point>(dArray.length / 2);
        for (n = 0; n < dArray.length - 1; n += 2) {
            object = new Point(dArray[n + 1], dArray[n]);
            arrayList.add((Point)object);
        }
        polyline.startPath((Point)arrayList.get(0));
        for (n = 1; n < arrayList.size(); ++n) {
            polyline.lineTo((Point)arrayList.get(n));
        }
        QuadTree.QuadTreeIterator quadTreeIterator = this.quadTree.getIterator((Geometry)polyline, 0.0);
        object = new ArrayList();
        int n2 = quadTreeIterator.next();
        while (n2 >= 0) {
            int n3 = this.quadTree.getElement(n2);
            Entry entry2 = this.zoneIds.get(n3);
            ((ArrayList)object).add(entry2);
            n2 = quadTreeIterator.next();
        }
        ArrayList<SameZoneSpan> arrayList2 = new ArrayList<SameZoneSpan>();
        List<Entry> list = null;
        int n4 = 0;
        boolean bl = false;
        while (n4 < arrayList.size()) {
            Point point = (Point)arrayList.get(n4);
            if (list == null) {
                list = object.stream().filter(entry -> GeometryEngine.contains((Geometry)entry.geometry, (Geometry)point, (SpatialReference)spatialReference)).collect(Collectors.toList());
            }
            if (list.isEmpty()) {
                list = null;
                bl = true;
                ++n4;
                continue;
            }
            if (bl) {
                bl = false;
                arrayList2.add(SameZoneSpan.fromIndexEntries(Collections.emptyList(), (n4 - 1) * 2 + 1));
                continue;
            }
            if (list.stream().allMatch(entry -> GeometryEngine.contains((Geometry)entry.geometry, (Geometry)point, (SpatialReference)spatialReference))) {
                if (n4 == arrayList.size() - 1) {
                    arrayList2.add(SameZoneSpan.fromIndexEntries(list, n4 * 2 + 1));
                }
                ++n4;
                continue;
            }
            arrayList2.add(SameZoneSpan.fromIndexEntries(list, (n4 - 1) * 2 + 1));
            list = null;
        }
        return arrayList2;
    }

    private static Polygon buildPoly(Geojson.Polygon polygon) {
        Polygon polygon2 = new Polygon();
        polygon.getCoordinatesList().stream().map(Geojson.LineString::getCoordinatesList).forEachOrdered(list -> {
            polygon2.startPath((double)((Geojson.Position)list.get(0)).getLon(), (double)((Geojson.Position)list.get(0)).getLat());
            list.subList(1, list.size()).forEach(position -> polygon2.lineTo((double)position.getLon(), (double)position.getLat()));
        });
        return polygon2;
    }

    static Index build(Stream<Geojson.Feature> stream, int n, Envelope envelope) {
        return Index.build(stream, n, envelope, false);
    }

    private static Stream<Polygon> getPolygons(Geojson.Feature feature) {
        if (feature.getGeometry().hasPolygon()) {
            return Stream.of(Index.buildPoly(feature.getGeometry().getPolygon()));
        }
        if (feature.getGeometry().hasMultiPolygon()) {
            Geojson.MultiPolygon multiPolygon = feature.getGeometry().getMultiPolygon();
            return multiPolygon.getCoordinatesList().stream().map(Index::buildPoly);
        }
        throw new RuntimeException("Unknown geometry type");
    }

    static Index build(Stream<Geojson.Feature> stream, int n2, Envelope envelope, boolean bl) {
        Envelope2D envelope2D = new Envelope2D();
        envelope.queryEnvelope2D(envelope2D);
        QuadTree quadTree = new QuadTree(envelope2D, 8);
        Envelope2D envelope2D2 = new Envelope2D();
        ArrayList<Entry> arrayList = new ArrayList<Entry>(n2);
        PrimitiveIterator.OfInt ofInt = IntStream.iterate(0, n -> n + 1).iterator();
        ArrayList arrayList2 = new ArrayList();
        OperatorContains operatorContains = (OperatorContains)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Contains);
        stream.forEach(feature -> {
            String string = feature.getProperties(0).getValueString();
            try {
                ZoneId zoneId = ZoneId.of(string);
                Index.getPolygons(feature).forEach(polygon -> {
                    if (bl) {
                        operatorContains.accelerateGeometry((Geometry)polygon, spatialReference, Geometry.GeometryAccelerationDegree.enumMild);
                    }
                    if (GeometryEngine.contains((Geometry)envelope, (Geometry)polygon, (SpatialReference)spatialReference)) {
                        log.debug("Adding zone {} to index", (Object)string);
                        polygon.queryEnvelope2D(envelope2D2);
                        int n = ofInt.next();
                        quadTree.insert(n, envelope2D2);
                        arrayList.add(n, new Entry(zoneId, (Geometry)polygon));
                    } else {
                        log.debug("Not adding zone {} to index because it's out of provided boundaries", (Object)string);
                    }
                });
            }
            catch (Exception exception) {
                arrayList2.add(string);
            }
        });
        if (arrayList2.size() != 0) {
            String string = String.join((CharSequence)", ", arrayList2);
            log.error("Some of the zone ids were not recognized by the Java runtime and will be ignored. The most probable reason for this is outdated Java runtime version. The following zones were not recognized: " + string);
        }
        return new Index(quadTree, arrayList);
    }

    static final class Entry {
        final ZoneId zoneId;
        final Geometry geometry;

        Entry(ZoneId zoneId, Geometry geometry) {
            this.zoneId = zoneId;
            this.geometry = geometry;
        }
    }
}

