/*
 * Decompiled with CFR 0.152.
 */
package net.iakovlev.timeshape;

import com.esri.core.geometry.Envelope;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.iakovlev.timeshape.Index;
import net.iakovlev.timeshape.SameZoneSpan;
import net.iakovlev.timeshape.proto.Geojson;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeZoneEngine
implements Serializable {
    private final Index index;
    private static final double MIN_LAT = -90.0;
    private static final double MIN_LON = -180.0;
    private static final double MAX_LAT = 90.0;
    private static final double MAX_LON = 180.0;
    private static final Logger log = LoggerFactory.getLogger(TimeZoneEngine.class);

    private TimeZoneEngine(Index index) {
        this.index = index;
    }

    private static void validateCoordinates(double d, double d2, double d3, double d4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (d < -90.0 || d > 90.0) {
            arrayList.add(String.format(Locale.ROOT, "minimum latitude %f is out of range: must be -90 <= latitude <= 90;", d));
        }
        if (d3 < -90.0 || d3 > 90.0) {
            arrayList.add(String.format(Locale.ROOT, "maximum latitude %f is out of range: must be -90 <= latitude <= 90;", d3));
        }
        if (d2 < -180.0 || d2 > 180.0) {
            arrayList.add(String.format(Locale.ROOT, "minimum longitude %f is out of range: must be -180 <= longitude <= 180;", d2));
        }
        if (d4 < -180.0 || d4 > 180.0) {
            arrayList.add(String.format(Locale.ROOT, "maximum longitude %f is out of range: must be -180 <= longitude <= 180;", d4));
        }
        if (d > d3) {
            arrayList.add(String.format(Locale.ROOT, "maximum latitude %f is less than minimum latitude %f;", d3, d));
        }
        if (d2 > d4) {
            arrayList.add(String.format(Locale.ROOT, "maximum longitude %f is less than minimum longitude %f;", d4, d2));
        }
        if (!arrayList.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)" ", arrayList));
        }
    }

    private static Spliterator<TarArchiveEntry> makeSpliterator(final TarArchiveInputStream tarArchiveInputStream) {
        return new Spliterators.AbstractSpliterator<TarArchiveEntry>(Long.MAX_VALUE, 0){

            @Override
            public boolean tryAdvance(Consumer<? super TarArchiveEntry> consumer) {
                try {
                    TarArchiveEntry tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
                    if (tarArchiveEntry != null) {
                        consumer.accept((TarArchiveEntry)tarArchiveEntry);
                        return true;
                    }
                    return false;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        };
    }

    public List<ZoneId> queryAll(double d, double d2) {
        return this.index.query(d, d2);
    }

    public Optional<ZoneId> query(double d, double d2) {
        List<ZoneId> list = this.index.query(d, d2);
        return list.size() > 0 ? Optional.of(list.get(0)) : Optional.empty();
    }

    public List<SameZoneSpan> queryPolyline(double[] dArray) {
        return this.index.queryPolyline(dArray);
    }

    public List<ZoneId> getKnownZoneIds() {
        return this.index.getKnownZoneIds();
    }

    public static TimeZoneEngine initialize(boolean bl) {
        return TimeZoneEngine.initialize(-90.0, -180.0, 90.0, 180.0, bl);
    }

    public static TimeZoneEngine initialize() {
        return TimeZoneEngine.initialize(-90.0, -180.0, 90.0, 180.0, false);
    }

    public static TimeZoneEngine initialize(TarArchiveInputStream tarArchiveInputStream) {
        return TimeZoneEngine.initialize(-90.0, -180.0, 90.0, 180.0, false, tarArchiveInputStream);
    }

    public static TimeZoneEngine initialize(double d, double d2, double d3, double d4, boolean bl, TarArchiveInputStream tarArchiveInputStream) {
        log.info("Initializing with bounding box: {}, {}, {}, {}", new Object[]{d, d2, d3, d4});
        TimeZoneEngine.validateCoordinates(d, d2, d3, d4);
        Spliterator<TarArchiveEntry> spliterator = TimeZoneEngine.makeSpliterator(tarArchiveInputStream);
        Stream<Geojson.Feature> stream = StreamSupport.stream(spliterator, false).map(tarArchiveEntry -> {
            try {
                if (tarArchiveEntry != null) {
                    log.debug("Processing archive entry {}", (Object)tarArchiveEntry.getName());
                    byte[] byArray = new byte[(int)tarArchiveEntry.getSize()];
                    tarArchiveInputStream.read(byArray);
                    return Geojson.Feature.parseFrom((byte[])byArray);
                }
                throw new RuntimeException("Data entry is not found in file");
            }
            catch (IOException | NullPointerException exception) {
                throw new RuntimeException(exception);
            }
        });
        int n = 449;
        Envelope envelope = new Envelope(d2, d, d4, d3);
        return new TimeZoneEngine(Index.build(stream, n, envelope, bl));
    }

    /*
     * Exception decompiling
     */
    public static TimeZoneEngine initialize(double var0, double var2_2, double var4_3, double var6_4, boolean var8_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

