/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.OtherInstance;
import ij.Prefs;
import ij.RecentOpener;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.plugin.JavaProperties;
import ij.plugin.MacroInstaller;
import ij.plugin.Orthogonal_Views;
import ij.plugin.Startup;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Editor;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener,
Runnable {
    public static final String VERSION = "1.49k";
    public static final String BUILD = "";
    public static Color backgroundColor = new Color(237, 237, 237);
    public static final Font SansSerif12 = new Font("SansSerif", 0, 12);
    public static final int DEFAULT_PORT = 57294;
    public static final int STANDALONE = 0;
    public static final int EMBEDDED = 1;
    public static final int NO_SHOW = 2;
    public static final int DEBUG = 256;
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static int port = 57294;
    private static String[] arguments;
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private boolean exitWhenQuitting;
    private boolean quitting;
    private long keyPressedTime;
    private long actionPerformedTime;
    private String lastKeyCommand;
    private boolean embedded;
    private boolean windowClosed;
    private static String commandName;
    boolean hotkey;

    public ImageJ() {
        this(null, 0);
    }

    public ImageJ(int mode) {
        this(null, mode);
    }

    public ImageJ(Applet applet) {
        this(applet, 0);
    }

    public ImageJ(Applet applet, int mode) {
        super("ImageJ");
        if ((mode & 0x100) != 0) {
            IJ.setDebugMode(true);
        }
        mode &= 0xFF;
        if (IJ.debugMode) {
            IJ.log("ImageJ starting in debug mode: " + mode);
        }
        this.embedded = applet == null && (mode == 1 || mode == 2);
        this.applet = applet;
        String err1 = Prefs.load(this, applet);
        this.setBackground(backgroundColor);
        Menus m = new Menus(this, applet);
        String err2 = m.addMenuBar();
        m.installPopupMenu(this);
        this.setLayout(new BorderLayout());
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.add("Center", this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(backgroundColor);
        this.statusLine = new Label();
        this.statusLine.setFont(new Font("SansSerif", 0, 13));
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(120, 20);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        this.add("South", this.statusBar);
        IJ.init(this, applet);
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.setFocusTraversalKeysEnabled(false);
        m.installStartupMacroSet();
        this.runStartupMacro();
        Point loc = this.getPreferredLocation();
        Dimension tbSize = this.toolbar.getPreferredSize();
        this.setCursor(Cursor.getDefaultCursor());
        if (mode != 2) {
            if (IJ.isWindows()) {
                try {
                    this.setIcon();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.setLocation(loc.x, loc.y);
            this.setResizable(!IJ.isMacOSX());
            this.pack();
            this.setVisible(true);
        }
        if (err1 != null) {
            IJ.error(err1);
        }
        if (err2 != null) {
            IJ.error(err2);
            IJ.runPlugIn("ij.plugin.ClassChecker", BUILD);
        }
        if (IJ.isMacintosh() && applet == null) {
            Object qh = null;
            qh = IJ.runPlugIn("MacAdapter", BUILD);
            if (qh == null) {
                IJ.runPlugIn("QuitHandler", BUILD);
            }
        }
        if (applet == null) {
            IJ.runPlugIn("ij.plugin.DragAndDrop", BUILD);
        }
        String str = m.getMacroCount() == 1 ? " macro" : " macros";
        IJ.showStatus(this.version() + m.getPluginCount() + " commands; " + m.getMacroCount() + str);
        this.configureProxy();
        if (applet == null) {
            this.loadCursors();
        }
    }

    private void runStartupMacro() {
        String macro = new Startup().getStartupMacro();
        if (macro != null && macro.length() > 4) {
            new MacroRunner(macro);
        }
    }

    private void loadCursors() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String path = Prefs.getImageJDir() + "images/crosshair-cursor.gif";
        File f = new File(path);
        if (!f.exists()) {
            return;
        }
        ImageIcon icon = new ImageIcon(path);
        Image image = icon.getImage();
        if (image == null) {
            return;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        Point hotSpot = new Point(width / 2, height / 2);
        Cursor crosshairCursor = toolkit.createCustomCursor(image, hotSpot, "crosshair-cursor.gif");
        ImageCanvas.setCursor(crosshairCursor, 0);
    }

    void configureProxy() {
        if (Prefs.useSystemProxies) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (Exception e) {}
        } else {
            String server = Prefs.get("proxy.server", null);
            if (server == null || server.equals(BUILD)) {
                return;
            }
            int port = (int)Prefs.get("proxy.port", 0.0);
            if (port == 0) {
                return;
            }
            Properties props = System.getProperties();
            props.put("proxySet", "true");
            props.put("http.proxyHost", server);
            props.put("http.proxyPort", BUILD + port);
        }
    }

    void setIcon() throws Exception {
        URL url = this.getClass().getResource("/microscope.gif");
        if (url == null) {
            return;
        }
        Image img = this.createImage((ImageProducer)url.getContent());
        if (img != null) {
            this.setIconImage(img);
        }
    }

    public Point getPreferredLocation() {
        int ijWidth;
        Rectangle maxBounds = GUI.getMaxWindowBounds();
        int ijX = Prefs.getInt(IJ_X, -99);
        int ijY = Prefs.getInt(IJ_Y, -99);
        if (ijX >= maxBounds.x && ijY >= maxBounds.y && ijX < maxBounds.x + maxBounds.width - 75) {
            return new Point(ijX, ijY);
        }
        Dimension tbsize = this.toolbar.getPreferredSize();
        double percent = maxBounds.width > 832 ? 0.8 : 0.9;
        ijX = (int)(percent * (double)(maxBounds.width - (ijWidth = tbsize.width + 10)));
        if (ijX < 10) {
            ijX = 10;
        }
        return new Point(ijX, maxBounds.y);
    }

    void showStatus(String s) {
        this.statusLine.setText(s);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public Panel getStatusBar() {
        return this.statusBar;
    }

    void doCommand(String name) {
        new Executer(name, null);
    }

    public void runFilterPlugIn(Object theFilter, String cmd, String arg) {
        new PlugInFilterRunner(theFilter, cmd, arg);
    }

    public Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        return IJ.runUserPlugIn(commandName, className, arg, createNewLoader);
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return BUILD;
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        s = s + "] ";
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuContainer parent;
            String cmd;
            MenuItem item = (MenuItem)e.getSource();
            commandName = cmd = e.getActionCommand();
            ImagePlus imp = null;
            if (item.getParent() == Menus.getOpenRecentMenu()) {
                new RecentOpener(cmd);
                return;
            }
            if (item.getParent() == Menus.getPopupMenu() && (parent = Menus.getPopupMenu().getParent()) instanceof ImageCanvas) {
                imp = ((ImageCanvas)parent).getImage();
            }
            int flags = e.getModifiers();
            this.hotkey = false;
            this.actionPerformedTime = System.currentTimeMillis();
            long ellapsedTime = this.actionPerformedTime - this.keyPressedTime;
            if (!(cmd == null || ellapsedTime < 200L && cmd.equals(this.lastKeyCommand))) {
                if ((flags & 8) != 0) {
                    IJ.setKeyDown(18);
                }
                if ((flags & 1) != 0) {
                    IJ.setKeyDown(16);
                }
                new Executer(cmd, imp);
            }
            this.lastKeyCommand = null;
            if (IJ.debugMode) {
                IJ.log("actionPerformed: time=" + ellapsedTime + ", " + e);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        MenuComponent parent = (MenuComponent)((Object)item.getParent());
        String cmd = e.getItem().toString();
        if ((Menu)parent == Menus.window) {
            WindowManager.activateWindow(cmd, item);
        } else {
            this.doCommand(cmd);
        }
    }

    public void mousePressed(MouseEvent e) {
        Undo.reset();
        if (!Prefs.noClickToGC) {
            System.gc();
        }
        IJ.showStatus(this.version() + IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.log("Windows: " + WindowManager.getWindowCount());
        }
    }

    public String getInfo() {
        return this.version() + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; " + IJ.freeMemory();
    }

    private String version() {
        return "ImageJ 1.49k; Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " [64-bit]; " : " [32-bit]; ");
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Hashtable macroShortcuts;
        Roi roi;
        boolean isStack;
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        this.hotkey = false;
        if (keyCode == 17 || keyCode == 16) {
            return;
        }
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyPressed: code=" + keyCode + " (" + KeyEvent.getKeyText(keyCode) + "), char=\"" + keyChar + "\" (" + keyChar + "), flags=" + KeyEvent.getKeyModifiersText(flags));
        }
        boolean shift = (flags & 1) != 0;
        boolean control = (flags & 2) != 0;
        boolean alt = (flags & 8) != 0;
        boolean meta = (flags & 4) != 0;
        String cmd = null;
        ImagePlus imp = WindowManager.getCurrentImage();
        boolean bl = isStack = imp != null && imp.getStackSize() > 1;
        if (imp != null && !control && (keyChar >= ' ' && keyChar <= '\u00ff' || keyChar == '\b' || keyChar == '\n') && (roi = imp.getRoi()) instanceof TextRoi) {
            if ((flags & 4) != 0 && IJ.isMacOSX()) {
                return;
            }
            if (alt) {
                switch (keyChar) {
                    case 'm': 
                    case 'u': {
                        keyChar = '\u00b5';
                        break;
                    }
                    case 'A': {
                        keyChar = '\u00c5';
                        break;
                    }
                }
            }
            ((TextRoi)roi).addChar(keyChar);
            return;
        }
        if (!control && !meta && (macroShortcuts = Menus.getMacroShortcuts()).size() > 0 && (cmd = shift ? (String)macroShortcuts.get(new Integer(keyCode + 200)) : (String)macroShortcuts.get(new Integer(keyCode))) != null) {
            commandName = cmd;
            MacroInstaller.runMacroShortcut(cmd);
            return;
        }
        if ((!Prefs.requireControlKey || control || meta) && keyChar != '+') {
            Hashtable shortcuts = Menus.getShortcuts();
            cmd = shift ? (String)shortcuts.get(new Integer(keyCode + 200)) : (String)shortcuts.get(new Integer(keyCode));
        }
        if (cmd == null) {
            switch (keyChar) {
                case ',': 
                case '<': {
                    if (!isStack) break;
                    cmd = "Previous Slice [<]";
                    break;
                }
                case '.': 
                case ';': 
                case '>': {
                    if (!isStack) break;
                    cmd = "Next Slice [>]";
                    break;
                }
                case '+': 
                case '=': {
                    cmd = "In [+]";
                    break;
                }
                case '-': {
                    cmd = "Out [-]";
                    break;
                }
                case '/': {
                    cmd = "Reslice [/]...";
                    break;
                }
            }
        }
        if (cmd == null) {
            switch (keyCode) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    if (this.deleteOverlayRoi(imp)) {
                        return;
                    }
                    cmd = "Clear";
                    this.hotkey = true;
                    break;
                }
                case 61: {
                    cmd = "In [+]";
                    break;
                }
                case 45: {
                    cmd = "Out [-]";
                    break;
                }
                case 47: 
                case 191: {
                    cmd = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    if (!isStack) break;
                    cmd = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    if (!isStack) break;
                    cmd = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    boolean zoomKey;
                    if (imp == null) {
                        return;
                    }
                    roi = imp.getRoi();
                    if (IJ.shiftKeyDown() && imp == Orthogonal_Views.getImage()) {
                        return;
                    }
                    boolean stackKey = imp.getStackSize() > 1 && (roi == null || IJ.shiftKeyDown());
                    boolean bl2 = zoomKey = roi == null || IJ.shiftKeyDown() || IJ.controlKeyDown();
                    if (stackKey && keyCode == 39) {
                        cmd = "Next Slice [>]";
                        break;
                    }
                    if (stackKey && keyCode == 37) {
                        cmd = "Previous Slice [<]";
                        break;
                    }
                    if (zoomKey && keyCode == 40 && !this.ignoreArrowKeys(imp) && Toolbar.getToolId() < 19) {
                        cmd = "Out [-]";
                        break;
                    }
                    if (zoomKey && keyCode == 38 && !this.ignoreArrowKeys(imp) && Toolbar.getToolId() < 19) {
                        cmd = "In [+]";
                        break;
                    }
                    if (roi == null) break;
                    if ((flags & 8) != 0) {
                        roi.nudgeCorner(keyCode);
                    } else {
                        roi.nudge(keyCode);
                    }
                    return;
                }
                case 27: {
                    this.abortPluginOrMacro(imp);
                    return;
                }
                case 10: {
                    WindowManager.toFront(this);
                    return;
                }
            }
        }
        if (cmd != null && !cmd.equals(BUILD)) {
            commandName = cmd;
            if (cmd.equals("Fill") || cmd.equals("Draw")) {
                this.hotkey = true;
            }
            if (cmd.charAt(0) == '^') {
                MacroInstaller.runMacroShortcut(cmd);
            } else {
                this.doCommand(cmd);
                this.keyPressedTime = System.currentTimeMillis();
                this.lastKeyCommand = cmd;
            }
        }
    }

    private boolean deleteOverlayRoi(ImagePlus imp) {
        if (imp == null) {
            return false;
        }
        Overlay overlay = null;
        ImageCanvas ic = imp.getCanvas();
        if (ic != null) {
            overlay = ic.getShowAllList();
        }
        if (overlay == null) {
            overlay = imp.getOverlay();
        }
        if (overlay == null) {
            return false;
        }
        Roi roi = imp.getRoi();
        for (int i = 0; i < overlay.size(); ++i) {
            Roi roi2 = overlay.get(i);
            if (roi2 != roi) continue;
            overlay.remove(i);
            imp.deleteRoi();
            ic = imp.getCanvas();
            if (ic != null) {
                ic.roiManagerSelect(roi, true);
            }
            return true;
        }
        return false;
    }

    private boolean ignoreArrowKeys(ImagePlus imp) {
        Frame frame = WindowManager.getFrontWindow();
        String title = frame.getTitle();
        if (title != null && title.equals("ROI Manager")) {
            return true;
        }
        if (frame != null && frame instanceof JFrame) {
            return true;
        }
        ImageWindow win = imp.getWindow();
        return imp.getStackSize() > 1 && win != null && win.getClass().getName().startsWith("loci");
    }

    public void keyTyped(KeyEvent e) {
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.log("keyTyped: char=\"" + keyChar + "\" (" + keyChar + "), flags= " + Integer.toHexString(flags) + " (" + KeyEvent.getKeyModifiersText(flags) + ")");
        }
        if (keyChar == '\\' || keyChar == '\u00ab' || keyChar == '\u00df') {
            if ((flags & 8) != 0) {
                this.doCommand("Animation Options...");
            } else {
                this.doCommand("Start Animation [\\]");
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        IJ.setKeyUp(e.getKeyCode());
    }

    void abortPluginOrMacro(ImagePlus imp) {
        ImageWindow win;
        if (imp != null && (win = imp.getWindow()) != null) {
            win.running = false;
            win.running2 = false;
        }
        Macro.abort();
        Interpreter.abort();
        if (Interpreter.getInstance() != null) {
            IJ.beep();
        }
    }

    public void windowClosing(WindowEvent e) {
        if (Executer.getListenerCount() > 0) {
            this.doCommand("Quit");
        } else {
            this.quit();
            this.windowClosed = true;
        }
    }

    public void windowActivated(WindowEvent e) {
        if (IJ.isMacintosh() && !this.quitting) {
            IJ.wait(10);
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void register(Class c) {
        if (!this.classes.contains(c)) {
            this.classes.addElement(c);
        }
    }

    public void quit() {
        Thread thread = new Thread((Runnable)this, "Quit");
        thread.setPriority(5);
        thread.start();
        IJ.wait(10);
    }

    public boolean quitting() {
        return this.quitting;
    }

    public void savePreferences(Properties prefs) {
        Point loc = this.getLocation();
        prefs.put(IJ_X, Integer.toString(loc.x));
        prefs.put(IJ_Y, Integer.toString(loc.y));
    }

    public static void main(String[] args) {
        boolean passArgs;
        if (System.getProperty("java.version").substring(0, 3).compareTo("1.5") < 0) {
            JOptionPane.showMessageDialog(null, "ImageJ 1.49k requires Java 1.5 or later.");
            System.exit(0);
        }
        boolean noGUI = false;
        int mode = 0;
        arguments = args;
        int nArgs = args != null ? args.length : 0;
        boolean commandLine = false;
        for (int i = 0; i < nArgs; ++i) {
            String arg = args[i];
            if (arg == null || !args[i].startsWith("-")) continue;
            if (args[i].startsWith("-batch")) {
                noGUI = true;
                continue;
            }
            if (args[i].startsWith("-debug")) {
                IJ.setDebugMode(true);
                continue;
            }
            if (args[i].startsWith("-ijpath") && i + 1 < nArgs) {
                if (IJ.debugMode) {
                    IJ.log("-ijpath: " + args[i + 1]);
                }
                Prefs.setHomeDir(args[i + 1]);
                commandLine = true;
                args[i + 1] = null;
                continue;
            }
            if (!args[i].startsWith("-port")) continue;
            int delta = (int)Tools.parseDouble(args[i].substring(5, args[i].length()), 0.0);
            commandLine = true;
            if (delta == 0) {
                mode = 1;
                continue;
            }
            if (delta <= 0 || 57294 + delta >= 65536) continue;
            port = 57294 + delta;
        }
        boolean bl = passArgs = mode == 0 && !noGUI;
        if (IJ.isMacOSX() && !commandLine) {
            passArgs = false;
        }
        if (passArgs && ImageJ.isRunning(args)) {
            return;
        }
        ImageJ ij = IJ.getInstance();
        if (!noGUI && (ij == null || ij != null && !ij.isShowing())) {
            ij = new ImageJ(null, mode);
            ij.exitWhenQuitting = true;
        }
        int macros = 0;
        for (int i = 0; i < nArgs; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.startsWith("-")) {
                if ((arg.startsWith("-macro") || arg.startsWith("-batch")) && i + 1 < nArgs) {
                    String arg2 = i + 2 < nArgs ? args[i + 2] : null;
                    Prefs.commandLineMacro = true;
                    if (noGUI && args[i + 1].endsWith(".js")) {
                        Interpreter.batchMode = true;
                    }
                    IJ.runMacroFile(args[i + 1], arg2);
                    break;
                }
                if (arg.startsWith("-eval") && i + 1 < nArgs) {
                    String rtn = IJ.runMacro(args[i + 1]);
                    if (rtn != null) {
                        System.out.print(rtn);
                    }
                    args[i + 1] = null;
                    continue;
                }
                if (!arg.startsWith("-run") || i + 1 >= nArgs) continue;
                IJ.run(args[i + 1]);
                args[i + 1] = null;
                continue;
            }
            if (macros == 0 && (arg.endsWith(".ijm") || arg.endsWith(".txt"))) {
                IJ.runMacroFile(arg);
                ++macros;
                continue;
            }
            if (arg.length() <= 0 || arg.indexOf("ij.ImageJ") != -1) continue;
            File file = new File(arg);
            IJ.open(file.getAbsolutePath());
        }
        if (IJ.debugMode && IJ.getInstance() == null) {
            new JavaProperties().run(BUILD);
        }
        if (noGUI) {
            System.exit(0);
        }
    }

    static boolean isRunning(String[] args) {
        return OtherInstance.sendArguments(args);
    }

    public static int getPort() {
        return port;
    }

    public static String[] getArgs() {
        return arguments;
    }

    public void exitWhenQuitting(boolean ewq) {
        this.exitWhenQuitting = ewq;
    }

    public void run() {
        Frame[] frames;
        this.quitting = true;
        boolean changes = false;
        int[] wList = WindowManager.getIDList();
        if (wList != null) {
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                if (imp == null || !imp.changes) continue;
                changes = true;
                break;
            }
        }
        if ((frames = WindowManager.getNonImageWindows()) != null) {
            for (int i = 0; i < frames.length; ++i) {
                if (frames[i] == null || !(frames[i] instanceof Editor) || !((Editor)frames[i]).fileChanged()) continue;
                changes = true;
                break;
            }
        }
        if (!(!this.windowClosed || changes || Menus.window.getItemCount() <= 6 || IJ.macroRunning() && WindowManager.getImageCount() == 0)) {
            GenericDialog gd = new GenericDialog("ImageJ", this);
            gd.addMessage("Are you sure you want to quit ImageJ?");
            gd.showDialog();
            this.quitting = !gd.wasCanceled();
            this.windowClosed = false;
        }
        if (!this.quitting) {
            return;
        }
        if (!WindowManager.closeAllWindows()) {
            this.quitting = false;
            return;
        }
        if (this.applet == null) {
            this.saveWindowLocations();
            Prefs.savePreferences();
        }
        IJ.cleanup();
        this.dispose();
        if (this.exitWhenQuitting) {
            System.exit(0);
        }
    }

    void saveWindowLocations() {
        Dimension d;
        Window win = WindowManager.getWindow("B&C");
        if (win != null) {
            Prefs.saveLocation("b&c.loc", win.getLocation());
        }
        if ((win = WindowManager.getWindow("Threshold")) != null) {
            Prefs.saveLocation("threshold.loc", win.getLocation());
        }
        if ((win = WindowManager.getWindow("Results")) != null) {
            Prefs.saveLocation("results.loc", win.getLocation());
            d = win.getSize();
            Prefs.set("results.width", d.width);
            Prefs.set("results.height", d.height);
        }
        if ((win = WindowManager.getWindow("Log")) != null) {
            Prefs.saveLocation("log.loc", win.getLocation());
            d = win.getSize();
            Prefs.set("log.width", d.width);
            Prefs.set("log.height", d.height);
        }
        if ((win = WindowManager.getWindow("ROI Manager")) != null) {
            Prefs.saveLocation("manager.loc", win.getLocation());
        }
    }

    public static String getCommandName() {
        return commandName != null ? commandName : "null";
    }

    public static void setCommandName(String name) {
        commandName = name;
    }
}

