/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.PlotMaker;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Plot {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int DOT = 6;
    public static final int LINE = 2;
    public static final int X_NUMBERS = 1;
    public static final int Y_NUMBERS = 2;
    public static final int X_TICKS = 4;
    public static final int Y_TICKS = 8;
    public static final int X_GRID = 16;
    public static final int Y_GRID = 32;
    public static final int X_FORCE2GRID = 64;
    public static final int Y_FORCE2GRID = 128;
    public static final int X_MINOR_TICKS = 256;
    public static final int Y_MINOR_TICKS = 512;
    public static final int X_LOG_NUMBERS = 1024;
    public static final int Y_LOG_NUMBERS = 2048;
    public static final int DEFAULT_FLAGS = 51;
    public static final int LEFT_MARGIN = 60;
    public static final int RIGHT_MARGIN = 18;
    public static final int TOP_MARGIN = 15;
    public static final int BOTTOM_MARGIN = 40;
    private static int MAX_INTERVALS = 12;
    private static final int MIN_X_GRIDWIDTH = 60;
    private static final int MIN_Y_GRIDWIDTH = 40;
    private static int TICK_LENGTH = 6;
    private static int MINOR_TICK_LENGTH = 4;
    private final Color gridColor = new Color(0xC0C0C0);
    private int frameWidth;
    private int frameHeight;
    Rectangle frame = null;
    float[] xValues;
    float[] yValues;
    float[] errorBars;
    float[] xErrorBars;
    int nPoints;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    private double xScale;
    private double yScale;
    private static String defaultDirectory = null;
    private String xLabel;
    private String yLabel;
    private int flags;
    private Font font = new Font("Helvetica", 0, 12);
    private Font fontMedium = new Font("Helvetica", 0, 10);
    private Font fontSmall = new Font("Helvetica", 0, 9);
    private Font xLabelFont = this.font;
    private Font yLabelFont = this.font;
    private boolean fixedYScale;
    private int lineWidth = 1;
    private int markSize = 5;
    private int minimalArrowSize = 5;
    private ImageProcessor ip;
    private String title;
    private boolean initialized;
    private boolean plotDrawn;
    private int plotWidth = PlotWindow.plotWidth;
    private int plotHeight = PlotWindow.plotHeight;
    private boolean multiplePlots;
    private boolean drawPending;
    private PlotMaker plotMaker;
    private float[] previousYValues;
    ArrayList storedData;

    public Plot(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        this(title, xLabel, yLabel, xValues, yValues, 51);
    }

    public Plot(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, xValues != null ? Tools.toFloat(xValues) : null, yValues != null ? Tools.toFloat(yValues) : null, 51);
    }

    public Plot(String dummy, String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        this(title, xLabel, yLabel, xValues, yValues, 51);
    }

    public Plot(String title, String xLabel, String yLabel) {
        this(title, xLabel, yLabel, (float[])null, (float[])null, 51);
    }

    public Plot(String title, String xLabel, String yLabel, int flags) {
        this(title, xLabel, yLabel, (float[])null, (float[])null, flags);
    }

    public Plot(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, int flags) {
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.flags = flags;
        this.storedData = new ArrayList();
        if ((xValues == null || xValues.length == 0) && yValues != null) {
            xValues = new float[yValues.length];
            for (int i = 0; i < yValues.length; ++i) {
                xValues[i] = i;
            }
        }
        if (xValues == null) {
            xValues = new float[]{};
            yValues = new float[]{};
        } else {
            this.store(xValues, yValues);
        }
        this.xValues = xValues;
        this.yValues = yValues;
        double[] a = Tools.getMinMax(xValues);
        this.xMin = a[0];
        this.xMax = a[1];
        a = Tools.getMinMax(yValues);
        this.yMin = a[0];
        this.yMax = a[1];
        this.fixedYScale = false;
        this.nPoints = Math.min(xValues.length, yValues.length);
        this.drawPending = true;
    }

    private float[] arrayToLog(float[] val) {
        float[] newVal = new float[val.length];
        for (int i = 0; i < newVal.length; ++i) {
            newVal[i] = (float)Math.log10(val[i]);
        }
        return newVal;
    }

    public Plot(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, int flags) {
        this(title, xLabel, yLabel, xValues != null ? Tools.toFloat(xValues) : null, yValues != null ? Tools.toFloat(yValues) : null, flags);
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        if ((this.flags & 0x400) != 0) {
            xMin = Math.log10(xMin);
            xMax = Math.log10(xMax);
        }
        if ((this.flags & 0x800) != 0) {
            yMin = Math.log10(yMin);
            yMax = Math.log10(yMax);
        }
        if (!Double.isNaN(xMin)) {
            this.xMin = xMin;
        }
        if (!Double.isNaN(xMax)) {
            this.xMax = xMax;
        }
        if (!Double.isNaN(yMin)) {
            this.yMin = yMin;
        }
        if (!Double.isNaN(yMax)) {
            this.yMax = yMax;
        }
        this.fixedYScale = true;
        if (this.initialized) {
            this.ip.setColor(Color.white);
            this.ip.resetRoi();
            this.ip.fill();
            this.ip.setColor(Color.black);
            this.setScaleAndDrawAxisLabels();
        }
    }

    public void setSize(int width, int height) {
        if (!this.initialized && width > 98 && height > 75) {
            this.plotWidth = width - 60 - 18;
            this.plotHeight = height - 15 - 40;
        }
    }

    public void setFrameSize(int width, int height) {
        this.plotWidth = width;
        this.plotHeight = height;
    }

    public void setMaxIntervals(int intervals) {
        MAX_INTERVALS = intervals;
    }

    public void setTickLength(int tickLength) {
        TICK_LENGTH = tickLength;
    }

    public void setMinorTickLength(int minorTickLength) {
        MINOR_TICK_LENGTH = minorTickLength;
    }

    public void setAxisXLog(boolean axisXLog) {
        if (axisXLog && (this.flags & 0x400) == 0) {
            this.flags += 1024;
            if ((this.flags & 1) != 0) {
                --this.flags;
            }
        } else if (!axisXLog && (this.flags & 0x400) != 0) {
            this.flags -= 1024;
            if ((this.flags & 1) == 0) {
                ++this.flags;
            }
        }
    }

    public void setAxisYLog(boolean axisYLog) {
        if (axisYLog && (this.flags & 0x800) == 0) {
            this.flags += 2048;
            if ((this.flags & 2) != 0) {
                this.flags -= 2;
            }
        } else if (!axisYLog && (this.flags & 0x800) != 0) {
            this.flags -= 2048;
            if ((this.flags & 2) == 0) {
                this.flags += 2;
            }
        }
    }

    public void setXTicks(boolean XTicks) {
        if (XTicks && (this.flags & 4) == 0) {
            this.flags += 4;
        } else if (!XTicks && (this.flags & 4) != 0) {
            this.flags -= 4;
        }
    }

    public void setYTicks(boolean YTicks) {
        if (YTicks && (this.flags & 8) == 0) {
            this.flags += 8;
        } else if (!YTicks && (this.flags & 8) != 0) {
            this.flags -= 8;
        }
    }

    public void setXMinorTicks(boolean XMinorTicks) {
        if (XMinorTicks && (this.flags & 0x100) == 0) {
            this.flags += 256;
            if ((this.flags & 4) == 0) {
                this.flags += 4;
            }
        } else if (!XMinorTicks && (this.flags & 0x100) != 0) {
            this.flags -= 256;
        }
    }

    public void setYMinorTicks(boolean YMinorTicks) {
        if (YMinorTicks && (this.flags & 0x200) == 0) {
            this.flags += 512;
            if ((this.flags & 8) == 0) {
                this.flags += 8;
            }
        } else if (!YMinorTicks && (this.flags & 0x200) != 0) {
            this.flags -= 512;
        }
    }

    public void setAxes(boolean xLog, boolean yLog, boolean xTicks, boolean yTicks, boolean xMinorTicks, boolean yMinorTicks, int tickLenght, int minorTickLenght) {
        this.setAxisXLog(xLog);
        this.setAxisYLog(yLog);
        this.setXMinorTicks(xMinorTicks);
        this.setYMinorTicks(yMinorTicks);
        this.setXTicks(xTicks);
        this.setYTicks(yTicks);
        this.setTickLength(tickLenght);
        this.setMinorTickLength(minorTickLenght);
    }

    public void setLogScaleX() {
        this.setAxisXLog(true);
        this.setXMinorTicks(true);
        this.setYMinorTicks(true);
        this.setTickLength(8);
    }

    public void setLogScaleY() {
        this.setAxisYLog(true);
        this.setXMinorTicks(true);
        this.setYMinorTicks(true);
        this.setTickLength(8);
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.setup();
        switch (shape) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.ip.setClipRect(this.frame);
                for (int i = 0; i < x.length; ++i) {
                    this.drawShape(shape, this.scaleX(x[i]), this.scaleY(y[i]), this.markSize);
                }
                this.ip.setClipRect(null);
                break;
            }
            case 2: {
                this.drawFloatPolyline(this.ip, (this.flags & 0x400) != 0 ? this.arrayToLog(x) : x, (this.flags & 0x800) != 0 ? this.arrayToLog(y) : y, x.length);
            }
        }
        this.multiplePlots = true;
        if (this.xValues == null || this.xValues.length == 0) {
            this.xValues = x;
            this.yValues = y;
            this.nPoints = x.length;
            this.drawPending = false;
        }
        if (shape == 6 || shape == 2 || !this.duplicate(y, this.previousYValues)) {
            this.store(x, y);
        }
        this.previousYValues = y;
    }

    private boolean duplicate(float[] current, float[] previous) {
        if (current == null || previous == null || current.length != previous.length) {
            return false;
        }
        for (int i = 0; i < current.length; ++i) {
            if (current[i] == previous[i]) continue;
            return false;
        }
        return true;
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addPoints(String dummy, float[] x, float[] y, int shape) {
        this.addPoints(x, y, shape);
    }

    public void addPoints(ArrayList x, ArrayList y, int shape) {
        this.addPoints(this.getDoubleFromArrayList(x), this.getDoubleFromArrayList(y), shape);
    }

    public void addPoints(double[] x, double[] y, double[] errorBars, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
        this.drawVerticalErrorBars(Tools.toFloat(x), Tools.toFloat(y), Tools.toFloat(errorBars));
    }

    public void addPoints(ArrayList x, ArrayList y, ArrayList z, int shape) {
        this.addPoints(this.getDoubleFromArrayList(x), this.getDoubleFromArrayList(y), this.getDoubleFromArrayList(z), shape);
    }

    public double[] getDoubleFromArrayList(ArrayList list) {
        double[] targ = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            targ[i] = (Double)list.get(i);
        }
        return targ;
    }

    void drawShape(int shape, int x, int y, int size) {
        int xbase = x - size / 2;
        int ybase = y - size / 2;
        switch (shape) {
            case 1: {
                this.ip.drawLine(xbase, ybase, xbase + size, ybase + size);
                this.ip.drawLine(xbase + size, ybase, xbase, ybase + size);
                break;
            }
            case 3: {
                this.ip.drawLine(xbase, ybase, xbase + size, ybase);
                this.ip.drawLine(xbase + size, ybase, xbase + size, ybase + size);
                this.ip.drawLine(xbase + size, ybase + size, xbase, ybase + size);
                this.ip.drawLine(xbase, ybase + size, xbase, ybase);
                break;
            }
            case 4: {
                this.ip.drawLine(x, ybase, xbase + size, ybase + size);
                this.ip.drawLine(xbase + size, ybase + size, xbase, ybase + size);
                this.ip.drawLine(xbase, ybase + size, x, ybase);
                break;
            }
            case 5: {
                this.ip.drawLine(xbase, y, xbase + size, y);
                this.ip.drawLine(x, ybase, x, ybase + size);
                break;
            }
            case 6: {
                this.ip.drawDot(x, y);
                break;
            }
            default: {
                this.ip.drawLine(x - 1, y - 2, x + 1, y - 2);
                this.ip.drawLine(x - 1, y + 2, x + 1, y + 2);
                this.ip.drawLine(x + 2, y + 1, x + 2, y - 1);
                this.ip.drawLine(x - 2, y + 1, x - 2, y - 1);
            }
        }
    }

    public void drawVectors(double[] x1, double[] y1, double[] x2, double[] y2) {
        this.setup();
        this.ip.setClipRect(this.frame);
        int arrowSize = 5;
        for (int i = 0; i < x1.length; ++i) {
            int xt1 = 60 + (int)((x1[i] - this.xMin) * this.xScale);
            int yt1 = 15 + this.frameHeight - (int)((y1[i] - this.yMin) * this.yScale);
            int xt2 = 60 + (int)((x2[i] - this.xMin) * this.xScale);
            int yt2 = 15 + this.frameHeight - (int)((y2[i] - this.yMin) * this.yScale);
            double dist = this.calculateDistance(xt1, yt1, xt2, yt2);
            if (xt1 == xt2 && yt1 == yt2) {
                this.ip.drawDot(xt1, yt1);
                continue;
            }
            if (dist > (double)arrowSize) {
                if (dist > (double)this.minimalArrowSize) {
                    this.drawArrow(xt1, yt1, xt2, yt2, dist / (double)this.minimalArrowSize);
                    continue;
                }
                this.drawArrow(xt1, yt1, xt2, yt2, this.minimalArrowSize);
                continue;
            }
            this.ip.drawLine(xt1, yt1, xt2, yt2);
        }
        this.ip.setClipRect(null);
        this.multiplePlots = true;
        if (this.xValues == null || this.xValues.length == 0) {
            this.xValues = Tools.toFloat(x1);
            this.yValues = Tools.toFloat(y1);
            this.nPoints = x1.length;
            this.drawPending = false;
        }
        this.store(Tools.toFloat(x1), Tools.toFloat(y1));
    }

    public double calculateDistance(int x1, int y1, int x2, int y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public void drawArrow(int x1, int y1, int x2, int y2, double size) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double ra = Math.sqrt(dx * dx + dy * dy);
        int x3 = (int)Math.round((double)x2 - (dx /= ra) * size);
        int y3 = (int)Math.round((double)y2 - (dy /= ra) * size);
        double r = 0.3 * size;
        int x4 = (int)Math.round((double)x3 + dy * r);
        int y4 = (int)Math.round((double)y3 - dx * r);
        int x5 = (int)Math.round((double)x3 - dy * r);
        int y5 = (int)Math.round((double)y3 + dx * r);
        this.ip.moveTo(x1, y1);
        this.ip.lineTo(x2, y2);
        this.ip.moveTo(x4, y4);
        this.ip.lineTo(x2, y2);
        this.ip.lineTo(x5, y5);
    }

    public void drawVectors(ArrayList x1, ArrayList y1, ArrayList x2, ArrayList y2) {
        this.drawVectors(this.getDoubleFromArrayList(x1), this.getDoubleFromArrayList(y1), this.getDoubleFromArrayList(x2), this.getDoubleFromArrayList(y2));
    }

    public void addErrorBars(float[] errorBars) {
        if (!this.drawPending && this.xValues != null && this.yValues != null) {
            this.drawVerticalErrorBars(this.xValues, this.yValues, errorBars);
        } else {
            this.errorBars = errorBars;
        }
    }

    public void addErrorBars(double[] errorBars) {
        this.addErrorBars(Tools.toFloat(errorBars));
    }

    public void addErrorBars(String dummy, float[] errorBars) {
        this.addErrorBars(errorBars);
    }

    public void addHorizontalErrorBars(double[] errorBars) {
        if (!this.drawPending && this.xValues != null && this.yValues != null) {
            this.drawHorizontalErrorBars(this.xValues, this.yValues, Tools.toFloat(errorBars));
        } else {
            this.xErrorBars = Tools.toFloat(errorBars);
        }
    }

    public void addLabel(double x, double y, String label) {
        this.setup();
        int xt = 60 + (int)(x * (double)this.frameWidth);
        int yt = 15 + (int)(y * (double)this.frameHeight);
        this.ip.drawString(label, xt, yt);
    }

    public void setJustification(int justification) {
        this.setup();
        this.ip.setJustification(justification);
    }

    public void setColor(Color c) {
        this.setup();
        if (!(this.ip instanceof ColorProcessor)) {
            this.ip = this.ip.convertToRGB();
            this.ip.setLineWidth(this.lineWidth);
            this.ip.setFont(this.font);
            this.ip.setAntialiasedText(true);
        }
        this.ip.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 1) {
            lineWidth = 1;
        }
        this.setup();
        this.ip.setLineWidth(lineWidth);
        this.lineWidth = lineWidth;
        this.markSize = lineWidth == 1 ? 5 : 7;
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.setup();
        this.ip.drawLine(this.scaleX(x1), this.scaleY(y1), this.scaleX(x2), this.scaleY(y2));
    }

    public void drawNormalizedLine(double x1, double y1, double x2, double y2) {
        this.setup();
        int ix1 = 60 + (int)(x1 * (double)this.frameWidth);
        int iy1 = 15 + (int)(y1 * (double)this.frameHeight);
        int ix2 = 60 + (int)(x2 * (double)this.frameWidth);
        int iy2 = 15 + (int)(y2 * (double)this.frameHeight);
        this.ip.drawLine(ix1, iy1, ix2, iy2);
    }

    public void drawDottedLine(double x1, double y1, double x2, double y2, int step) {
        this.setup();
        int ix1 = this.scaleX(x1);
        int iy1 = this.scaleY(y1);
        int ix2 = this.scaleX(x2);
        int iy2 = this.scaleY(y2);
        for (int i = ix1; i <= ix2; i += step) {
            for (int j = iy1; j <= iy2; j += step) {
                this.ip.drawDot(i, j);
            }
        }
    }

    private int scaleX(double x) {
        if ((this.flags & 0x400) != 0) {
            return 60 + (int)Math.round((Math.log10(x) - this.xMin) * this.xScale);
        }
        return 60 + (int)Math.round((x - this.xMin) * this.xScale);
    }

    private int scaleY(double y) {
        if ((this.flags & 0x800) != 0) {
            return 15 + this.frameHeight - (int)Math.round((Math.log10(y) - this.yMin) * this.yScale);
        }
        return 15 + this.frameHeight - (int)Math.round((y - this.yMin) * this.yScale);
    }

    public void setFont(Font font) {
        this.setup();
        this.ip.setFont(font);
        this.font = font;
    }

    public void setXLabelFont(Font font) {
        this.xLabelFont = font;
    }

    public void setYLabelFont(Font font) {
        this.yLabelFont = font;
    }

    public void changeFont(Font font) {
        this.setFont(font);
    }

    void setup() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.createImage();
        this.ip.setColor(Color.black);
        if (this.lineWidth > 3) {
            this.lineWidth = 3;
        }
        this.ip.setLineWidth(this.lineWidth);
        this.ip.setFont(this.font);
        this.ip.setAntialiasedText(true);
        if (this.frameWidth == 0) {
            this.frameWidth = this.plotWidth;
            this.frameHeight = this.plotHeight;
        }
        this.frame = new Rectangle(60, 15, this.frameWidth, this.frameHeight);
        this.setScaleAndDrawAxisLabels();
    }

    void setScaleAndDrawAxisLabels() {
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
        if (PlotWindow.noGridLines) {
            this.drawAxisLabels();
        } else {
            this.drawTicksEtc();
        }
    }

    void drawAxisLabels() {
        String t;
        int digits = this.getDigits(this.yMin, this.xMax, 0.001 * (this.yMax - this.yMin), 8);
        String s = IJ.d2s(this.yMax, digits);
        int sw = this.ip.getStringWidth(s);
        if ((this.flags & 0x800) != 0) {
            if (sw + 4 > 60) {
                this.ip.setFont(this.fontSmall);
                this.ip.drawString(s, 4 - this.ip.getStringWidth(s) / 2 + 6, 4);
                this.ip.setFont(this.font);
                t = "10";
                this.ip.drawString(t, -6, 13);
            } else {
                this.ip.setFont(this.fontSmall);
                this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4 - this.ip.getStringWidth(s) / 2 + 6, 18);
                this.ip.setFont(this.font);
                t = "10";
                this.ip.drawString(t, 60 - this.ip.getStringWidth(s) - 4 - 10, 27);
            }
        } else if (sw + 4 > 60) {
            this.ip.drawString(s, 4, 11);
        } else {
            this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4, 25);
        }
        s = IJ.d2s(this.yMin, digits);
        sw = this.ip.getStringWidth(s);
        if ((this.flags & 0x800) != 0) {
            if (sw + 4 > 60) {
                this.ip.setFont(this.fontSmall);
                this.ip.drawString(s, 4 - this.ip.getStringWidth(s) / 2 + 6, 15 + this.frame.height - 7);
                this.ip.setFont(this.font);
                t = "10";
                this.ip.drawString(t, -6, 15 + this.frame.height + 2);
            } else {
                this.ip.setFont(this.fontSmall);
                this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4 - this.ip.getStringWidth(s) / 2 + 6, 15 + this.frame.height - 7);
                this.ip.setFont(this.font);
                t = "10";
                this.ip.drawString(t, 60 - this.ip.getStringWidth(s) - 4 - 10, 15 + this.frame.height + 2);
            }
        } else if (sw + 4 > 60) {
            this.ip.drawString(s, 4, 15 + this.frame.height);
        } else {
            this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4, 15 + this.frame.height);
        }
        FontMetrics fm = this.ip.getFontMetrics();
        int x = 60;
        int y = 15 + this.frame.height + fm.getAscent() + 6;
        digits = this.getDigits(this.xMin, this.xMax, 0.001 * (this.xMax - this.xMin), 8);
        if ((this.flags & 0x400) != 0) {
            this.ip.setFont(this.fontSmall);
            this.ip.drawString(IJ.d2s(this.xMin, digits), x - this.ip.getStringWidth(s) / 2 + 6, y - 7);
            this.ip.drawString(IJ.d2s(this.xMax, digits), x + this.frame.width - this.ip.getStringWidth(s) * 3 / 2 + 12, y - 7);
            this.ip.setFont(this.font);
            String t2 = "10";
            this.ip.drawString(t2, x - 10, y + 2);
            this.ip.drawString(t2, x + this.frame.width - this.ip.getStringWidth(s) - 10, y + 2);
        } else {
            this.ip.drawString(IJ.d2s(this.xMin, digits), x, y);
            this.ip.drawString(IJ.d2s(this.xMax, digits), x + this.frame.width - this.ip.getStringWidth(s) + 6, y);
        }
        if (this.xLabelFont != this.font) {
            this.ip.setFont(this.xLabelFont);
            this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 3);
            this.ip.setFont(this.font);
        } else {
            this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 3);
        }
        if (this.yLabelFont != this.font) {
            this.ip.setFont(this.yLabelFont);
            this.drawYLabel(this.yLabel, 56, 15, this.frame.height, fm);
            this.ip.setFont(this.font);
        } else {
            this.drawYLabel(this.yLabel, 56, 15, this.frame.height, fm);
        }
    }

    void drawTicksEtc() {
        int diff;
        int digits;
        int fontAscent = this.ip.getFontMetrics().getAscent();
        int fontMaxAscent = this.ip.getFontMetrics().getMaxAscent();
        if ((this.flags & 0x15) != 0) {
            int x;
            double v;
            int i;
            int i2;
            int i1;
            double step = Math.abs((double)Math.max(this.frame.width / MAX_INTERVALS, 60) / this.xScale);
            step = this.niceNumber(step);
            if ((this.flags & 0x40) != 0) {
                i1 = (int)Math.floor(Math.min(this.xMin, this.xMax) / step + 1.0E-10);
                i2 = (int)Math.ceil(Math.max(this.xMin, this.xMax) / step - 1.0E-10);
                this.xMin = (double)i1 * step;
                this.xMax = (double)i2 * step;
                this.xScale = (double)this.frame.width / (this.xMax - this.xMin);
            } else {
                i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / step - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
            }
            digits = this.getDigits(this.xMin, this.xMax, step, 7);
            int y1 = 15;
            int y2 = 15 + this.frame.height;
            int yNumbers = y2 + fontAscent + 7;
            for (i = 0; i <= i2 - i1; ++i) {
                String s;
                v = (double)(i + i1) * step;
                x = (int)Math.round((v - this.xMin) * this.xScale) + 60;
                if ((this.flags & 0x10) != 0) {
                    this.ip.setColor(this.gridColor);
                    this.ip.drawLine(x, y1, x, y2);
                    this.ip.setColor(Color.black);
                }
                if ((this.flags & 4) != 0) {
                    this.ip.drawLine(x, y1, x, y1 + TICK_LENGTH);
                    this.ip.drawLine(x, y2, x, y2 - TICK_LENGTH);
                }
                if ((this.flags & 1) != 0) {
                    s = IJ.d2s(v, digits);
                    this.ip.drawString(s, x - this.ip.getStringWidth(s) / 2, yNumbers);
                }
                if ((this.flags & 0x400) == 0) continue;
                this.ip.setFont(this.fontSmall);
                s = IJ.d2s(v, digits);
                this.ip.drawString(s, x - this.ip.getStringWidth(s) / 4 + 9, yNumbers - 7);
                this.ip.setFont(this.font);
                String t = "10";
                this.ip.drawString(t, x - this.ip.getStringWidth(t) / 2, yNumbers + 2);
            }
            if ((this.flags & 0x100) != 0 && (this.flags & 0x400) == 0) {
                i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / (step /= 10.0) - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
                for (i = 0; i <= i2 - i1; ++i) {
                    v = (double)(i + i1) * step;
                    x = (int)Math.round((v - this.xMin) * this.xScale) + 60;
                    this.ip.drawLine(x, y1, x, y1 + MINOR_TICK_LENGTH);
                    this.ip.drawLine(x, y2, x, y2 - MINOR_TICK_LENGTH);
                }
            }
            if ((this.flags & 0x100) != 0 && (this.flags & 0x400) != 0) {
                int i10 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / step - 1.0E-10);
                i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / (step /= 10.0) - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
                for (int i3 = 0; i3 <= i2 - i1; ++i3) {
                    double v2;
                    int x2;
                    diff = i1 + (1 - i10) * 10;
                    if ((i3 + diff) % 10 <= 1 || (x2 = (int)Math.round(((v2 = ((double)(i3 - (i3 + diff) % 10) + 10.0 * Math.log10((i3 + diff) % 10) + (double)i1) * step) - this.xMin) * this.xScale) + 60) >= this.frame.width + 60) continue;
                    this.ip.drawLine(x2, y1, x2, y1 + MINOR_TICK_LENGTH);
                    this.ip.drawLine(x2, y2, x2, y2 - MINOR_TICK_LENGTH);
                }
            }
        }
        int maxNumWidth = 0;
        if ((this.flags & 0x2A) != 0) {
            int i2;
            int i1;
            double step = Math.abs((double)Math.max(this.frame.height / MAX_INTERVALS, 40) / this.yScale);
            step = this.niceNumber(step);
            if ((this.flags & 0x80) != 0) {
                i1 = (int)Math.floor(Math.min(this.yMin, this.yMax) / step + 1.0E-10);
                i2 = (int)Math.ceil(Math.max(this.yMin, this.yMax) / step - 1.0E-10);
                this.yMin = (double)i1 * step;
                this.yMax = (double)i2 * step;
                this.yScale = (double)this.frame.height / (this.yMax - this.yMin);
            } else {
                i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / step - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
            }
            int digits2 = this.getDigits(this.yMin, this.yMax, step, 5);
            int x1 = 60;
            int x2 = 60 + this.frame.width;
            if (this.yMin == this.yMax && (this.flags & 2) != 0) {
                String s = IJ.d2s(this.yMin, this.getDigits(this.yMin, 0.001 * this.yMin, 5));
                int w = this.ip.getStringWidth(s);
                if (w > maxNumWidth) {
                    maxNumWidth = w;
                }
                int y = 15 + this.frame.height;
                this.ip.drawString(s, 60 - w - 4, y + fontMaxAscent / 2 + 1);
                this.drawYLabel(this.yLabel, 60 - maxNumWidth - 4, 15, this.frame.height, this.ip.getFontMetrics());
            } else {
                this.ip.setFont(this.font);
                int w1 = this.ip.getStringWidth(IJ.d2s(this.yMin, digits2));
                int w2 = this.ip.getStringWidth(IJ.d2s(this.yMax, digits2));
                int wMax = Math.max(w1, w2);
                if ((this.flags & 2) != 0 && (this.flags & 0x800) == 0 && wMax > 56) {
                    this.ip.setFont(this.fontMedium);
                }
                for (int i = 0; i <= i2 - i1; ++i) {
                    String s;
                    double v = step == 0.0 ? this.yMin : (double)(i + i1) * step;
                    int y = 15 + this.frame.height - (int)Math.round((v - this.yMin) * this.yScale);
                    if ((this.flags & 0x20) != 0) {
                        this.ip.setColor(this.gridColor);
                        this.ip.drawLine(x1, y, x2, y);
                        this.ip.setColor(Color.black);
                    }
                    if ((this.flags & 8) != 0) {
                        this.ip.drawLine(x1, y, x1 + TICK_LENGTH, y);
                        this.ip.drawLine(x2, y, x2 - TICK_LENGTH, y);
                    }
                    if ((this.flags & 2) != 0) {
                        s = IJ.d2s(v, digits2);
                        int w = this.ip.getStringWidth(s);
                        if (w > maxNumWidth) {
                            maxNumWidth = w;
                        }
                        this.ip.drawString(s, 60 - w - 4, y + fontMaxAscent / 2 + 1);
                    }
                    if ((this.flags & 0x800) == 0) continue;
                    this.ip.setFont(this.fontSmall);
                    s = IJ.d2s(v, digits2);
                    int ws = this.ip.getStringWidth(s);
                    if (ws > maxNumWidth) {
                        maxNumWidth = ws;
                    }
                    this.ip.drawString(s, 60 - ws - 1, y + fontMaxAscent / 2 - 8);
                    this.ip.setFont(this.font);
                    String t = "10";
                    int w = this.ip.getStringWidth(t);
                    if (w > maxNumWidth) {
                        maxNumWidth = w;
                    }
                    this.ip.drawString(t, 60 - w - 11, y + fontMaxAscent / 2 + 2);
                }
            }
            this.ip.setFont(this.font);
            if ((this.flags & 0x200) != 0 && (this.flags & 0x800) == 0) {
                i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / (step /= 10.0) - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
                for (int i = 0; i <= i2 - i1; ++i) {
                    double v = (double)(i + i1) * step;
                    int y = 15 + this.frame.height - (int)Math.round((v - this.yMin) * this.yScale);
                    this.ip.drawLine(x1, y, x1 + MINOR_TICK_LENGTH, y);
                    this.ip.drawLine(x2, y, x2 - MINOR_TICK_LENGTH, y);
                }
            }
            if ((this.flags & 0x200) != 0 && (this.flags & 0x800) != 0) {
                int i10 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / step - 1.0E-10);
                i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / (step /= 10.0) - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
                for (int i = 0; i <= i2 - i1; ++i) {
                    double v;
                    int y;
                    diff = i1 + (1 - i10) * 10;
                    if (i % 10 <= 1 || (y = 15 + this.frame.height - (int)Math.round(((v = ((double)(i - (i + diff) % 10) + 10.0 * Math.log10((i + diff) % 10) + (double)i1) * step) - this.yMin) * this.yScale)) <= 15) continue;
                    this.ip.drawLine(x1, y, x1 + MINOR_TICK_LENGTH, y);
                    this.ip.drawLine(x2, y, x2 - MINOR_TICK_LENGTH, y);
                }
            }
        }
        if ((this.flags & 0x802) == 0) {
            int digits3 = this.getDigits(this.yMin, this.yMax, 0.001 * (this.yMax - this.yMin), 6);
            String s = IJ.d2s(this.yMax, digits3);
            int sw = this.ip.getStringWidth(s);
            if (sw + 4 > 60) {
                this.ip.drawString(s, 4, 11);
            } else {
                this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4, 25);
            }
            s = IJ.d2s(this.yMin, digits3);
            sw = this.ip.getStringWidth(s);
            if (sw + 4 > 60) {
                this.ip.drawString(s, 4, 15 + this.frame.height);
            } else {
                this.ip.drawString(s, 60 - this.ip.getStringWidth(s) - 4, 15 + this.frame.height);
            }
        }
        FontMetrics fm = this.ip.getFontMetrics();
        int x = 60;
        int y = 15 + this.frame.height + fm.getAscent() + 6;
        if ((this.flags & 0x401) == 0) {
            digits = this.getDigits(this.xMin, this.xMax, 0.001 * (this.xMax - this.xMin), 7);
            this.ip.drawString(IJ.d2s(this.xMin, digits), x, y);
            String s = IJ.d2s(this.xMax, digits);
            this.ip.drawString(s, x + this.frame.width - this.ip.getStringWidth(s) + 6, y);
        } else {
            y += fm.getAscent();
        }
        if (this.xLabelFont != this.font) {
            this.ip.setFont(this.xLabelFont);
            this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 6);
            this.ip.setFont(this.font);
        } else {
            this.ip.drawString(this.xLabel, 60 + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + 6);
        }
        if (this.xLabelFont != this.font) {
            this.ip.setFont(this.xLabelFont);
            if ((this.flags & 0x800) != 0) {
                this.drawYLabel(this.yLabel, 60 - maxNumWidth - 20, 15, this.frame.height, fm);
            } else {
                this.drawYLabel(this.yLabel, 60 - maxNumWidth - 4, 15, this.frame.height, fm);
            }
            this.ip.setFont(this.font);
        } else if ((this.flags & 0x800) != 0) {
            this.drawYLabel(this.yLabel, 60 - maxNumWidth - 20, 15, this.frame.height, fm);
        } else {
            this.drawYLabel(this.yLabel, 60 - maxNumWidth - 4, 15, this.frame.height, fm);
        }
    }

    double niceNumber(double v) {
        double base = Math.pow(10.0, Math.floor(Math.log10(v) - 1.0E-6));
        if (v > 5.0000001 * base) {
            return 10.0 * base;
        }
        if (v > 2.0000001 * base) {
            return 5.0 * base;
        }
        return 2.0 * base;
    }

    void createImage() {
        if (this.ip != null) {
            return;
        }
        int width = this.plotWidth + 60 + 18;
        int height = this.plotHeight + 15 + 40;
        byte[] pixels = new byte[width * height];
        for (int i = 0; i < width * height; ++i) {
            pixels[i] = -1;
        }
        this.ip = new ByteProcessor(width, height, pixels, null);
    }

    int getDigits(double n, double resolution, int maxDigits) {
        if (this.isInteger(n) && Math.abs(n) < Math.pow(10.0, maxDigits - 1) - 1.0) {
            return 0;
        }
        return this.getDigits2(n, resolution, maxDigits);
    }

    int getDigits(double n1, double n2, double resolution, int maxDigits) {
        if (n1 == 0.0 && n2 == 0.0) {
            return 0;
        }
        return this.getDigits2(Math.max(Math.abs(n1), Math.abs(n2)), resolution, maxDigits);
    }

    int getDigits2(double n, double resolution, int maxDigits) {
        int log10ofN = (int)Math.floor(Math.log10(Math.abs(n)) + 1.0E-7);
        int digits = resolution != 0.0 ? -((int)Math.floor(Math.log10(Math.abs(resolution)) + 1.0E-7)) : Math.max(0, -log10ofN + maxDigits - 2);
        int sciDigits = -Math.max(log10ofN + digits, 1);
        if (digits < -2 && log10ofN >= maxDigits) {
            digits = sciDigits;
        } else if (digits < 0) {
            digits = 0;
        } else if (digits > maxDigits - 1 && log10ofN < -2) {
            digits = sciDigits;
        }
        return digits;
    }

    boolean isInteger(double n) {
        return n == (double)Math.round(n);
    }

    public void draw() {
        if (this.plotDrawn) {
            return;
        }
        this.plotDrawn = true;
        this.createImage();
        this.setup();
        if (this.drawPending) {
            this.drawFloatPolyline(this.ip, (this.flags & 0x400) != 0 ? this.arrayToLog(this.xValues) : this.xValues, (this.flags & 0x800) != 0 ? this.arrayToLog(this.yValues) : this.yValues, this.nPoints);
            if (this.yMin == this.yMax) {
                int yy = this.frame.y + this.frame.height - 1;
                this.ip.drawLine(this.frame.x, yy, this.frame.x + this.frame.width, yy);
            }
            if (this.errorBars != null) {
                this.drawVerticalErrorBars(this.xValues, this.yValues, this.errorBars);
            }
            if (this.xErrorBars != null) {
                this.drawHorizontalErrorBars(this.xValues, this.yValues, this.xErrorBars);
            }
        }
        if (this.ip instanceof ColorProcessor) {
            this.ip.setColor(Color.black);
        }
        if (this.lineWidth > 5) {
            this.ip.setLineWidth(5);
        }
        this.ip.drawRect(this.frame.x, this.frame.y, this.frame.width + 1, this.frame.height + 1);
        this.ip.setLineWidth(this.lineWidth);
    }

    private void drawVerticalErrorBars(float[] x, float[] y, float[] e) {
        int nPoints2 = this.nPoints;
        if (e.length < this.nPoints) {
            nPoints2 = e.length;
        }
        int[] xpoints = new int[2];
        int[] ypoints = new int[2];
        for (int i = 0; i < nPoints2; ++i) {
            xpoints[0] = xpoints[1] = 60 + (int)((((this.flags & 0x400) != 0 ? Math.log10(x[i]) : (double)x[i]) - this.xMin) * this.xScale + 0.5);
            ypoints[0] = 15 + this.frame.height - (int)((((this.flags & 0x800) != 0 ? Math.log10(y[i]) : (double)y[i]) - this.yMin - ((this.flags & 0x800) != 0 ? Math.log10(e[i]) : (double)e[i])) * this.yScale + 0.5);
            ypoints[1] = 15 + this.frame.height - (int)((((this.flags & 0x800) != 0 ? Math.log10(y[i]) : (double)y[i]) - this.yMin + ((this.flags & 0x800) != 0 ? Math.log10(e[i]) : (double)e[i])) * this.yScale + 0.5);
            ypoints[0] = ypoints[0] > 15 + this.frame.height ? 15 + this.frame.height : ypoints[0];
            ypoints[1] = ypoints[1] < 15 ? 15 : ypoints[1];
            this.drawPolyline(this.ip, xpoints, ypoints, 2, false);
        }
    }

    private void drawHorizontalErrorBars(float[] x, float[] y, float[] e) {
        int nPoints2 = this.nPoints;
        if (e.length < this.nPoints) {
            nPoints2 = e.length;
        }
        int[] xpoints = new int[2];
        int[] ypoints = new int[2];
        for (int i = 0; i < nPoints2; ++i) {
            xpoints[0] = 60 + (int)((((this.flags & 0x400) != 0 ? Math.log10(x[i]) : (double)x[i]) - this.xMin - ((this.flags & 0x400) != 0 ? Math.log10(e[i]) : (double)e[i])) * this.xScale + 0.5);
            xpoints[1] = 60 + (int)((((this.flags & 0x400) != 0 ? Math.log10(x[i]) : (double)x[i]) - this.xMin + ((this.flags & 0x400) != 0 ? Math.log10(e[i]) : (double)e[i])) * this.xScale + 0.5);
            ypoints[0] = ypoints[1] = 15 + this.frame.height - (int)((((this.flags & 0x800) != 0 ? Math.log10(y[i]) : (double)y[i]) - this.yMin) * this.yScale + 0.5);
            xpoints[0] = xpoints[0] < 60 ? 60 : xpoints[0];
            xpoints[1] = xpoints[1] > 60 + this.frame.width ? 60 + this.frame.width : xpoints[1];
            this.drawPolyline(this.ip, xpoints, ypoints, 2, false);
        }
    }

    void drawPolyline(ImageProcessor ip, int[] x, int[] y, int n, boolean clip) {
        if (clip) {
            ip.setClipRect(this.frame);
        }
        ip.moveTo(x[0], y[0]);
        for (int i = 0; i < n; ++i) {
            ip.lineTo(x[i], y[i]);
        }
        if (clip) {
            ip.setClipRect(null);
        }
    }

    void drawFloatPolyline(ImageProcessor ip, float[] x, float[] y, int n) {
        if (x == null || x.length == 0) {
            return;
        }
        ip.setClipRect(this.frame);
        int x2 = 60 + (int)(((double)x[0] - this.xMin) * this.xScale);
        int y2 = 15 + this.frame.height - (int)(((double)y[0] - this.yMin) * this.yScale);
        boolean y2IsNaN = Float.isNaN(y[0]);
        for (int i = 1; i < n; ++i) {
            int x1 = x2;
            int y1 = y2;
            boolean y1IsNaN = y2IsNaN;
            x2 = 60 + (int)(((double)x[i] - this.xMin) * this.xScale);
            y2 = 15 + this.frame.height - (int)(((double)y[i] - this.yMin) * this.yScale);
            y2IsNaN = Float.isNaN(y[i]);
            if (y1IsNaN || y2IsNaN) continue;
            ip.drawLine(x1, y1, x2, y2);
        }
        ip.setClipRect(null);
    }

    void drawYLabel(String yLabel, int x, int y, int height, FontMetrics fm) {
        if (yLabel.equals("")) {
            return;
        }
        int w = fm.stringWidth(yLabel) + 5;
        int h = fm.getHeight() + 5;
        ImageProcessor label = new ByteProcessor(w, h);
        ((ImageProcessor)label).setColor(Color.white);
        label.fill();
        ((ImageProcessor)label).setColor(Color.black);
        label.setFont(this.font);
        label.setAntialiasedText(true);
        int descent = fm.getDescent();
        label.drawString(yLabel, 0, h - descent);
        label = label.rotateLeft();
        int y2 = y + (height - this.ip.getStringWidth(yLabel)) / 2;
        if (y2 < y) {
            y2 = y;
        }
        int x2 = Math.max(x - h, 0);
        this.ip.insert(label, x2, y2);
    }

    ImageProcessor getBlankProcessor() {
        this.createImage();
        return this.ip;
    }

    String getCoordinates(int x, int y) {
        String text = "";
        if (!this.frame.contains(x, y)) {
            return text;
        }
        double xv = Double.NaN;
        double yv = Double.NaN;
        if (this.multiplePlots) {
            xv = (double)(x - 60) / this.xScale + this.xMin;
            yv = (double)(15 + this.frameHeight - y) / this.yScale + this.yMin;
        } else {
            int index = (int)((double)(x - this.frame.x) / ((double)this.frame.width / (double)this.nPoints));
            if (index >= 0 && index < this.nPoints) {
                xv = this.xValues[index];
                yv = this.yValues[index];
            }
        }
        if (!Double.isNaN(xv)) {
            xv = (this.flags & 0x400) != 0 ? Math.pow(10.0, xv) : xv;
            yv = (this.flags & 0x800) != 0 ? Math.pow(10.0, yv) : yv;
            text = "X=" + IJ.d2s(xv, this.getDigits(xv, 0.001 * (this.xMax - this.xMin), 6)) + ", Y=" + IJ.d2s(yv, this.getDigits(yv, 0.001 * (this.yMax - this.yMin), 6));
        }
        return text;
    }

    public ImageProcessor getProcessor() {
        this.draw();
        return this.ip;
    }

    public ImagePlus getImagePlus() {
        this.draw();
        ImagePlus img = new ImagePlus(this.title, this.ip);
        Calibration cal = img.getCalibration();
        cal.xOrigin = 60.0 - this.xMin * this.xScale;
        cal.yOrigin = (double)(15 + this.frameHeight) + this.yMin * this.yScale;
        cal.pixelWidth = 1.0 / this.xScale;
        cal.pixelHeight = 1.0 / this.yScale;
        cal.setInvertY(true);
        return img;
    }

    public PlotWindow show() {
        this.draw();
        if (Prefs.useInvertingLut && this.ip instanceof ByteProcessor && !Interpreter.isBatchMode() && IJ.getInstance() != null) {
            this.ip.invertLut();
            this.ip.invert();
        }
        if (IJ.macroRunning() && IJ.getInstance() == null || Interpreter.isBatchMode()) {
            ImagePlus imp = this.getImagePlus();
            WindowManager.setTempCurrentImage(imp);
            imp.setProperty("XValues", this.xValues);
            imp.setProperty("YValues", this.yValues);
            Interpreter.addBatchModeImage(imp);
            return null;
        }
        PlotWindow pw = new PlotWindow(this);
        ImagePlus imp = pw.getImagePlus();
        if (IJ.isMacro() && imp != null) {
            IJ.selectWindow(imp.getID());
        }
        return pw;
    }

    private void store(float[] xvalues, float[] yvalues) {
        this.storedData.add(xvalues);
        this.storedData.add(yvalues);
    }

    public void setPlotMaker(PlotMaker plotMaker) {
        this.plotMaker = plotMaker;
    }

    PlotMaker getPlotMaker() {
        return this.plotMaker;
    }
}

