/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.PlotMaker;
import ij.gui.ProfilePlot;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner,
MouseListener,
MouseMotionListener,
KeyListener,
ImageListener,
Runnable {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int LINE = 2;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private static final int LIST_VALUES = 4;
    private static final int INTERPOLATE = 8;
    private static final int NO_GRID_LINES = 16;
    private Button list;
    private Button save;
    private Button copy;
    private Button live;
    private Label coordinates;
    private static String defaultDirectory = null;
    private static int options;
    private int defaultDigits = -1;
    private int markSize = 5;
    private static Plot staticPlot;
    private Plot plot;
    private String blankLabel = "                      ";
    private PlotMaker plotMaker;
    private ImagePlus srcImp;
    private Thread bgThread;
    private boolean doUpdate;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    public static boolean listValues;
    public static boolean interpolate;
    public static boolean noGridLines;

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        super(PlotWindow.createImage(title, xLabel, yLabel, xValues, yValues));
        this.plot = staticPlot;
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
    }

    PlotWindow(Plot plot) {
        super(plot.getImagePlus());
        this.plot = plot;
        this.draw();
    }

    static ImagePlus createImage(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        staticPlot = new Plot(title, xLabel, yLabel, xValues, yValues);
        return new ImagePlus(title, staticPlot.getBlankProcessor());
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.plot.setLimits(xMin, xMax, yMin, yMax);
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.plot.addPoints(x, y, shape);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addErrorBars(float[] errorBars) {
        this.plot.addErrorBars(errorBars);
    }

    public void addLabel(double x, double y, String label) {
        this.plot.addLabel(x, y, label);
    }

    public void setColor(Color c) {
        this.plot.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        this.plot.setLineWidth(lineWidth);
    }

    public void changeFont(Font font) {
        this.plot.changeFont(font);
    }

    public void draw() {
        Panel buttons = new Panel();
        int hgap = IJ.isMacOSX() ? 1 : 5;
        buttons.setLayout(new FlowLayout(2, hgap, 0));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        if (this.plot != null && this.plot.getPlotMaker() != null) {
            this.live = new Button("Live");
            this.live.addActionListener(this);
            buttons.add(this.live);
        }
        this.coordinates = new Label("X=12345678, Y=12345678");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        this.coordinates.setBackground(new Color(220, 220, 220));
        buttons.add(this.coordinates);
        this.add(buttons);
        this.plot.draw();
        this.pack();
        this.coordinates.setText(this.blankLabel);
        ImageProcessor ip = this.plot.getProcessor();
        if (ip instanceof ColorProcessor && this.imp.getProcessor() instanceof ByteProcessor) {
            this.imp.setProcessor(null, ip);
        } else {
            this.imp.updateAndDraw();
        }
        if (listValues) {
            this.showList();
        }
    }

    int getDigits(double n1, double n2) {
        if ((double)Math.round(n1) == n1 && (double)Math.round(n2) == n2) {
            return 0;
        }
        double n = (n1 = Math.abs(n1)) < (n2 = Math.abs(n2)) && n1 > 0.0 ? n1 : n2;
        double diff = Math.abs(n2 - n1);
        if (diff > 0.0 && diff < n) {
            n = diff;
        }
        int digits = 1;
        if (n < 10.0) {
            digits = 2;
        }
        if (n < 0.01) {
            digits = 3;
        }
        if (n < 0.001) {
            digits = 4;
        }
        if (n < 1.0E-4) {
            digits = 5;
        }
        return digits;
    }

    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        if (this.plot != null && this.plot.frame != null && this.coordinates != null) {
            String coords = this.plot.getCoordinates(x, y) + this.blankLabel;
            this.coordinates.setText(coords.substring(0, this.blankLabel.length()));
        }
    }

    void showList() {
        ResultsTable rt = this.getResultsTable();
        rt.show("Plot Values");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public ResultsTable getResultsTable() {
        float[] column;
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(false);
        String[] headings = this.getHeadings();
        int max = 0;
        for (int i = 0; i < this.plot.storedData.size(); i += 2) {
            column = (float[])this.plot.storedData.get(i);
            int s = column.length;
            max = s > max ? s : max;
        }
        ArrayList<float[]> data = new ArrayList<float[]>(this.plot.storedData);
        boolean ex_test = false;
        boolean ey_test = false;
        if (this.plot.errorBars != null) {
            data.add(2, this.plot.errorBars);
        }
        if (this.plot.xErrorBars != null) {
            data.add(3, this.plot.xErrorBars);
        }
        boolean skipDuplicates = this.skipDuplicateXColumns();
        int n = data.size();
        for (int i = 0; i < max; ++i) {
            ey_test = this.plot.errorBars != null;
            ex_test = this.plot.xErrorBars != null;
            int j = 0;
            while (j < n) {
                if (saveXValues && (j <= 1 || !skipDuplicates)) {
                    column = (float[])data.get(j);
                    if (i < column.length) {
                        rt.setValue(headings[j], i, (double)column[i]);
                    } else {
                        rt.setValue(headings[j], i, "");
                    }
                }
                if (i < (column = (float[])data.get(++j)).length) {
                    rt.setValue(headings[j], i, (double)column[i]);
                } else {
                    rt.setValue(headings[j], i, "");
                }
                ++j;
                if (ey_test) {
                    column = (float[])data.get(j);
                    if (i < column.length) {
                        rt.setValue(headings[j], i, (double)column[i]);
                    } else {
                        rt.setValue(headings[j], i, "");
                    }
                    ++j;
                    ey_test = false;
                }
                if (!ex_test) continue;
                column = (float[])data.get(j);
                if (i < column.length) {
                    rt.setValue(headings[j], i, (double)column[i]);
                } else {
                    rt.setValue(headings[j], i, "");
                }
                ++j;
                ex_test = false;
            }
        }
        int nColumns = rt.getLastColumn() + 1;
        for (int i = 0; i < nColumns; ++i) {
            rt.setDecimalPlaces(i, this.getPrecision(rt.getColumn(i)));
        }
        return rt;
    }

    private boolean skipDuplicateXColumns() {
        ArrayList data = this.plot.storedData;
        int sets = data.size() / 2;
        if (sets < 2) {
            return false;
        }
        float[] x0 = (float[])data.get(0);
        for (int i = 1; i < sets; ++i) {
            if (this.equals(x0, (float[])data.get(i * 2))) continue;
            return false;
        }
        return true;
    }

    private boolean equals(float[] a1, float[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private String[] getHeadings() {
        ArrayList<String> headings = new ArrayList<String>();
        int sets = this.plot.storedData.size() / 2;
        if (saveXValues || sets > 1) {
            if (sets == 1) {
                headings.add("X");
                headings.add("Y");
            } else {
                headings.add("X0");
                headings.add("Y0");
            }
        } else {
            headings.add("X0");
            headings.add("Y0");
        }
        if (this.plot.errorBars != null) {
            if (this.plot.xErrorBars != null) {
                headings.add("Y_ERR");
            } else {
                headings.add("ERR");
            }
        }
        if (this.plot.xErrorBars != null) {
            headings.add("X_ERR");
        }
        for (int j = 1; j < sets; ++j) {
            if (saveXValues || sets > 1) {
                headings.add("X" + j);
                headings.add("Y" + j);
                continue;
            }
            headings.add("Y" + j);
        }
        return headings.toArray(new String[headings.size()]);
    }

    private String getValuesAsString() {
        ResultsTable rt = this.getResultsTable();
        int n = rt.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rt.size(); ++i) {
            sb.append(rt.getRowAsString(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    void saveAsText() {
        SaveDialog sd = new SaveDialog("Save as Text", "Values", ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        pw.print(this.getValuesAsString());
        pw.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        int ydigits;
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        int xdigits = 0;
        if (saveXValues) {
            xdigits = this.getPrecision(this.plot.xValues);
        }
        if ((ydigits = xdigits) == 0) {
            ydigits = this.getPrecision(this.plot.yValues);
        }
        CharArrayWriter aw = new CharArrayWriter(this.plot.nPoints * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.plot.nPoints; ++i) {
            if (saveXValues) {
                pw.print(IJ.d2s(this.plot.xValues[i], xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], ydigits) + "\n");
                continue;
            }
            pw.print(IJ.d2s(this.plot.yValues[i], ydigits) + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    int getPrecision(float[] values) {
        int setDigits = Analyzer.getPrecision();
        int measurements = Analyzer.getMeasurements();
        boolean scientificNotation = (measurements & 0x200000) != 0;
        int minDecimalPlaces = 4;
        if (scientificNotation) {
            if (setDigits < minDecimalPlaces) {
                setDigits = minDecimalPlaces;
            }
            return -setDigits;
        }
        int digits = minDecimalPlaces;
        if (setDigits > digits) {
            digits = setDigits;
        }
        boolean realValues = false;
        for (int i = 0; i < values.length; ++i) {
            if ((float)((int)values[i]) == values[i] || Float.isNaN(values[i])) continue;
            realValues = true;
            break;
        }
        if (!realValues) {
            digits = 0;
        }
        return digits;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.live) {
            this.toggleLiveProfiling();
        } else if (b == this.list) {
            this.showList();
        } else if (b == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public float[] getXValues() {
        return this.plot.xValues;
    }

    public float[] getYValues() {
        return this.plot.yValues;
    }

    public void drawPlot(Plot plot) {
        this.plot = plot;
        if (this.imp != null) {
            this.imp.setProcessor(null, plot.getProcessor());
            ImagePlus plotImp = plot.getImagePlus();
            Calibration plotCal = plotImp.getCalibration();
            this.imp.setCalibration(plotCal);
        }
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if (plotWidth != 450 || plotHeight != 200) {
            prefs.put(PLOT_WIDTH, Integer.toString(plotWidth));
            prefs.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose && !listValues) {
            options |= 2;
        }
        if (listValues) {
            options |= 4;
        }
        if (!interpolate) {
            options |= 8;
        }
        if (noGridLines) {
            options |= 0x10;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    private void toggleLiveProfiling() {
        boolean liveMode;
        boolean bl = liveMode = this.live.getForeground() == Color.red;
        if (liveMode) {
            this.removeListeners();
        } else {
            this.enableLiveProfiling();
        }
    }

    private void enableLiveProfiling() {
        if (this.plotMaker == null) {
            PlotMaker plotMaker = this.plotMaker = this.plot != null ? this.plot.getPlotMaker() : null;
        }
        if (this.plotMaker != null && this.bgThread == null) {
            this.srcImp = this.plotMaker.getSourceImage();
            if (this.srcImp == null) {
                return;
            }
            this.bgThread = new Thread((Runnable)this, "Live Profiler");
            this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
            this.bgThread.start();
            this.imageUpdated(this.srcImp);
        }
        this.createListeners();
        if (this.srcImp != null) {
            this.imageUpdated(this.srcImp);
        }
    }

    public synchronized void mousePressed(MouseEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public synchronized void mouseDragged(MouseEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public synchronized void mouseClicked(MouseEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public synchronized void keyPressed(KeyEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void imageOpened(ImagePlus imp) {
    }

    public synchronized void imageUpdated(ImagePlus imp) {
        if (imp == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    public void imageClosed(ImagePlus imp) {
        if (imp == this.srcImp || imp == this.imp) {
            if (this.bgThread != null) {
                this.bgThread.interrupt();
            }
            this.bgThread = null;
            this.removeListeners();
            this.srcImp = null;
            this.plotMaker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            IJ.wait(50);
            Plot plot = this.plotMaker.getPlot();
            if (this.doUpdate && plot != null) {
                this.plot = plot;
                ImageProcessor ip = plot.getProcessor();
                if (ip != null && this.imp != null) {
                    this.imp.setProcessor(null, ip);
                }
            }
            PlotWindow plotWindow = this;
            synchronized (plotWindow) {
                if (this.doUpdate) {
                    this.doUpdate = false;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

    private void createListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImageCanvas ic = this.srcImp.getCanvas();
        if (ic == null) {
            return;
        }
        ic.addMouseListener(this);
        ic.addMouseMotionListener(this);
        ic.addKeyListener(this);
        ImagePlus.addImageListener(this);
        Font font = this.live.getFont();
        this.live.setFont(new Font(font.getName(), 1, font.getSize()));
        this.live.setForeground(Color.red);
    }

    private void removeListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImageCanvas ic = this.srcImp.getCanvas();
        if (ic != null) {
            ic.removeMouseListener(this);
            ic.removeMouseMotionListener(this);
            ic.removeKeyListener(this);
        }
        ImagePlus.removeImageListener(this);
        Font font = this.live.getFont();
        this.live.setFont(new Font(font.getName(), 0, font.getSize()));
        this.live.setForeground(Color.black);
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        listValues = (options & 4) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
        interpolate = (options & 8) == 0;
        noGridLines = (options & 0x10) != 0;
    }
}

