/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;

public class PointRoi
extends PolygonRoi {
    public static final String[] sizes = new String[]{"Tiny", "Small", "Medium", "Large", "Extra Large"};
    public static final String[] types = new String[]{"Hybrid", "Crosshair", "Dot", "Circle"};
    private static final String TYPE_KEY = "point.type";
    private static final String SIZE_KEY = "point.size";
    private static final String CROSS_COLOR_KEY = "point.cross.color";
    private static final int TINY = 1;
    private static final int SMALL = 3;
    private static final int MEDIUM = 5;
    private static final int LARGE = 7;
    private static final int EXTRA_LARGE = 11;
    private static final int HYBRID = 0;
    private static final int CROSSHAIR = 1;
    private static final int DOT = 2;
    private static final int CIRCLE = 3;
    private static final BasicStroke twoPixelsWide = new BasicStroke(2.0f);
    private static final BasicStroke threePixelsWide = new BasicStroke(3.0f);
    private static int defaultType = 0;
    private static int defaultSize = 3;
    private static Font font;
    private static Color defaultCrossColor;
    private static int fontSize;
    private double saveMag;
    private boolean showLabels;
    private int type = 0;
    private int size = 3;

    public PointRoi(int[] ox, int[] oy, int points) {
        super(PointRoi.itof(ox), PointRoi.itof(oy), points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(float[] ox, float[] oy, int points) {
        super(ox, oy, points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(float[] ox, float[] oy) {
        this(ox, oy, ox.length);
    }

    public PointRoi(FloatPolygon poly) {
        this(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public PointRoi(Polygon poly) {
        this(PointRoi.itof(poly.xpoints), PointRoi.itof(poly.ypoints), poly.npoints);
    }

    public PointRoi(int ox, int oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(double ox, double oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(int sx, int sy, ImagePlus imp) {
        super(PointRoi.makeXArray(sx, imp), PointRoi.makeYArray(sy, imp), 1, 10);
        this.setImage(imp);
        this.width = 1;
        this.height = 1;
        this.type = defaultType;
        this.size = defaultSize;
        boolean bl = this.showLabels = !Prefs.noPointLabels;
        if (imp != null) {
            imp.draw(this.x - 10, this.y - 10, 20, 20);
        }
        if (Recorder.record && !Recorder.scriptMode()) {
            Recorder.record("makePoint", this.x, this.y);
        }
    }

    static float[] itof(int[] arr) {
        if (arr == null) {
            return null;
        }
        int n = arr.length;
        float[] temp = new float[n];
        for (int i = 0; i < n; ++i) {
            temp[i] = arr[i];
        }
        return temp;
    }

    static float[] makeXArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenXD((int)value) : value)};
        return array;
    }

    static float[] makeYArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenYD((int)value) : value)};
        return array;
    }

    void handleMouseMove(int ox, int oy) {
    }

    protected void handleMouseUp(int sx, int sy) {
        super.handleMouseUp(sx, sy);
        this.modifyRoi();
    }

    public void draw(Graphics g) {
        this.updatePolygon();
        if (this.ic != null) {
            this.mag = this.ic.getMagnification();
        }
        if (this.showLabels && this.nPoints > 1) {
            fontSize = 9;
            if (this.mag > 1.0) {
                fontSize = (int)(((this.mag - 1.0) / 3.0 + 1.0) * 9.0);
            }
            if (fontSize > 18) {
                fontSize = 18;
            }
            if (font == null || this.mag != this.saveMag) {
                font = new Font("SansSerif", 0, fontSize);
            }
            g.setFont(font);
            if (fontSize > 9) {
                Java2.setAntialiasedText(g, true);
            }
            this.saveMag = this.mag;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.drawPoint(g, this.xp2[i], this.yp2[i], i + 1);
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawPoint(Graphics g, int x, int y, int n) {
        Color color;
        int size2 = this.size / 2;
        boolean colorSet = false;
        Graphics2D g2d = (Graphics2D)g;
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (!this.overlay && this.isActiveOverlayRoi()) {
            color = color == Color.cyan ? Color.magenta : Color.cyan;
        }
        if (this.type == 0 || this.type == 1) {
            if (this.type == 0) {
                g.setColor(Color.white);
            } else {
                g.setColor(color);
                colorSet = true;
            }
            if (this.size > 7) {
                g2d.setStroke(threePixelsWide);
            }
            g.drawLine(x - (this.size + 2), y, x + this.size + 2, y);
            g.drawLine(x, y - (this.size + 2), x, y + this.size + 2);
        }
        if (this.type != 1 && this.size > 3) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.type == 0 || this.type == 2) {
            if (!colorSet) {
                g.setColor(color);
                colorSet = true;
            }
            if (this.size > 7) {
                g2d.setStroke(onePixelWide);
            }
            if (this.size > 7 && this.type == 2) {
                g.fillOval(x - size2, y - size2, this.size, this.size);
            } else if (this.size > 7 && this.type == 0) {
                g.fillRect(x - (size2 - 2), y - (size2 - 2), this.size - 4, this.size - 4);
            } else if (this.size > 3 && this.type == 0) {
                g.fillRect(x - (size2 - 1), y - (size2 - 1), this.size - 2, this.size - 2);
            } else {
                g.fillRect(x - size2, y - size2, this.size, this.size);
            }
        }
        if (this.showLabels && this.nPoints > 1) {
            if (!colorSet) {
                g.setColor(color);
            }
            g.drawString("" + n, x + 4, y + fontSize + 2);
        }
        if (!(this.size <= 1 && this.type != 2 || this.type != 0 && this.type != 2)) {
            g.setColor(Color.black);
            if (this.size > 7 && this.type == 0) {
                g.drawOval(x - (size2 - 1), y - (size2 - 1), this.size - 3, this.size - 3);
            } else if (this.size > 3 && this.type == 0) {
                g.drawOval(x - size2, y - size2, this.size - 1, this.size - 1);
            } else {
                g.drawOval(x - (size2 + 1), y - (size2 + 1), this.size + 1, this.size + 1);
            }
        }
        if (this.type == 3) {
            int csize = this.size + 2;
            int csize2 = csize / 2;
            g.setColor(color);
            if (this.size > 7) {
                g2d.setStroke(twoPixelsWide);
            }
            g.drawOval(x - (csize2 + 1), y - (csize2 + 1), csize + 1, csize + 1);
        }
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(Analyzer.markWidth);
        for (int i = 0; i < this.nPoints; ++i) {
            ip.moveTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
            ip.lineTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
        }
    }

    public PointRoi addPoint(double x, double y) {
        FloatPolygon poly = this.getFloatPolygon();
        poly.addPoint(x, y);
        PointRoi p = new PointRoi(poly.xpoints, poly.ypoints, poly.npoints);
        p.setShowLabels(this.showLabels);
        IJ.showStatus("count=" + poly.npoints);
        p.setStrokeColor(this.getStrokeColor());
        p.setFillColor(this.getFillColor());
        p.setPointType(this.getPointType());
        p.setSize(this.getSize());
        return p;
    }

    public PointRoi addPoint(int x, int y) {
        return this.addPoint((double)x, (double)y);
    }

    public PointRoi subtractPoints(Roi roi) {
        Polygon points = this.getPolygon();
        Polygon poly = roi.getPolygon();
        Polygon points2 = new Polygon();
        for (int i = 0; i < points.npoints; ++i) {
            if (poly.contains(points.xpoints[i], points.ypoints[i])) continue;
            points2.addPoint(points.xpoints[i], points.ypoints[i]);
        }
        if (points2.npoints == 0) {
            return null;
        }
        return new PointRoi(points2.xpoints, points2.ypoints, points2.npoints);
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        for (int i = 0; i < this.nPoints; ++i) {
            ((ImageProcessor)mask).putPixel((int)this.xpf[i], (int)this.ypf[i], 255);
        }
        this.cachedMask = mask;
        return mask;
    }

    public boolean contains(int x, int y) {
        for (int i = 0; i < this.nPoints; ++i) {
            if ((float)x != (float)this.x + this.xpf[i] || (float)y != (float)this.y + this.ypf[i]) continue;
            return true;
        }
        return false;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public static void setDefaultType(int type) {
        if (type >= 0 && type < types.length) {
            defaultType = type;
            PointRoi instance = PointRoi.getPointRoiInstance();
            if (instance != null) {
                instance.setPointType(defaultType);
            }
            Prefs.set(TYPE_KEY, type);
        }
    }

    public static int getDefaultType() {
        return defaultType;
    }

    public void setPointType(int type) {
        if (type >= 0 && type < types.length) {
            this.type = type;
        }
    }

    public int getPointType() {
        return this.type;
    }

    public static void setDefaultSize(int index) {
        if (index >= 0 && index < sizes.length) {
            defaultSize = PointRoi.convertIndexToSize(index);
            PointRoi instance = PointRoi.getPointRoiInstance();
            if (instance != null) {
                instance.setSize(index);
            }
            Prefs.set(SIZE_KEY, index);
        }
    }

    public static int getDefaultSize() {
        return PointRoi.convertSizeToIndex(defaultSize);
    }

    public void setSize(int index) {
        if (index >= 0 && index < sizes.length) {
            this.size = PointRoi.convertIndexToSize(index);
        }
    }

    public int getSize() {
        return PointRoi.convertSizeToIndex(this.size);
    }

    private static int convertSizeToIndex(int size) {
        switch (size) {
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 11: {
                return 4;
            }
        }
        return 1;
    }

    private static int convertIndexToSize(int index) {
        switch (index) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 11;
            }
        }
        return 3;
    }

    public static void setDefaultCrossColor(Color color) {
    }

    public static Color getDefaultCrossColor() {
        return null;
    }

    public boolean subPixelResolution() {
        return true;
    }

    private static PointRoi getPointRoiInstance() {
        Roi roi;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) != null && roi instanceof PointRoi) {
            return (PointRoi)roi;
        }
        return null;
    }

    public String toString() {
        if (this.nPoints > 1) {
            return "Roi[Points, count=" + this.nPoints + "]";
        }
        return "Roi[Point, x=" + this.x + ", y=" + this.y + "]";
    }

    public void setHideLabels(boolean hideLabels) {
        this.showLabels = !hideLabels;
    }

    public static void setDefaultMarkerSize(String size) {
    }

    public static String getDefaultMarkerSize() {
        return sizes[defaultSize];
    }

    static {
        defaultCrossColor = Color.white;
        fontSize = 9;
        PointRoi.setDefaultType((int)Prefs.get(TYPE_KEY, 0.0));
        PointRoi.setDefaultSize((int)Prefs.get(SIZE_KEY, 1.0));
    }
}

