/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.BitBuffer;
import ij.io.ByteVector;
import ij.io.FileInfo;
import ij.io.RandomAccessStream;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.ImageIO;

public class ImageReader {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private FileInfo fi;
    private int width;
    private int height;
    private long skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int nPixels;
    private long byteCount;
    private boolean showProgressBar = true;
    private int eofErrorCount;
    private long startTime;
    public double min;
    public double max;

    public ImageReader(FileInfo fi) {
        this.fi = fi;
        this.width = fi.width;
        this.height = fi.height;
        this.skipCount = fi.getOffset();
    }

    void eofError() {
        ++this.eofErrorCount;
    }

    byte[] read8bitImage(InputStream in) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressed8bitImage(in);
        }
        byte[] pixels = new byte[this.nPixels];
        int totalRead = 0;
        while ((long)totalRead < this.byteCount) {
            int count = (long)(totalRead + this.bufferSize) > this.byteCount ? (int)(this.byteCount - (long)totalRead) : this.bufferSize;
            int actuallyRead = in.read(pixels, totalRead, count);
            if (actuallyRead == -1) {
                this.eofError();
                break;
            }
            this.showProgress((long)(totalRead += actuallyRead), this.byteCount);
        }
        return pixels;
    }

    byte[] readCompressed8bitImage(InputStream in) throws IOException {
        byte[] pixels = new byte[this.nPixels];
        int current = 0;
        byte last = 0;
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            int r;
            long skip;
            if (in instanceof RandomAccessStream) {
                ((RandomAccessStream)in).seek(this.fi.stripOffsets[i]);
            } else if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[i]];
            int read = 0;
            for (int left = byteArray.length; left > 0; left -= r) {
                r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
            }
            byteArray = this.uncompress(byteArray);
            int length = byteArray.length;
            length -= length % this.fi.width;
            if (this.fi.compression == 3) {
                for (int b = 0; b < length; ++b) {
                    int n = b;
                    byteArray[n] = (byte)(byteArray[n] + last);
                    last = b % this.fi.width == this.fi.width - 1 ? (byte)0 : byteArray[b];
                }
            }
            if (current + length > pixels.length) {
                length = pixels.length - current;
            }
            System.arraycopy(byteArray, 0, pixels, current, length);
            current += length;
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        return pixels;
    }

    short[] read16bitImage(InputStream in) throws IOException {
        if (this.fi.compression > 1 || this.fi.stripOffsets != null && this.fi.stripOffsets.length > 1) {
            return this.readCompressed16bitImage(in);
        }
        byte[] buffer = new byte[this.bufferSize];
        short[] pixels = new short[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            int j;
            int i;
            int count;
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            for (int bufferCount = 0; bufferCount < this.bufferSize; bufferCount += count) {
                count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count != -1) continue;
                if (bufferCount > 0) {
                    for (i = bufferCount; i < this.bufferSize; ++i) {
                        buffer[i] = 0;
                    }
                }
                totalRead = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)(((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF) + 32768);
                        ++i;
                        j += 2;
                    }
                } else {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                        ++i;
                        j += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)(((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF) + 32768);
                    ++i;
                    j += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    short[] readCompressed16bitImage(InputStream in) throws IOException {
        if (IJ.debugMode) {
            IJ.log("ImageReader.read16bit, offset=" + this.fi.stripOffsets[0]);
        }
        short[] pixels = new short[this.nPixels];
        int base = 0;
        short last = 0;
        for (int k = 0; k < this.fi.stripOffsets.length; ++k) {
            int j;
            int i;
            int pmax;
            int r;
            long skip;
            if (in instanceof RandomAccessStream) {
                ((RandomAccessStream)in).seek(this.fi.stripOffsets[k]);
            } else if (k > 0 && (skip = ((long)this.fi.stripOffsets[k] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[k - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[k - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[k]];
            int read = 0;
            for (int left = byteArray.length; left > 0; left -= r) {
                r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
            }
            byteArray = this.uncompress(byteArray);
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            if ((pmax = base + (pixelsRead -= pixelsRead % this.fi.width)) > this.nPixels) {
                pmax = this.nPixels;
            }
            if (this.fi.intelByteOrder) {
                i = base;
                j = 0;
                while (i < pmax) {
                    pixels[i] = (short)((byteArray[j + 1] & 0xFF) << 8 | byteArray[j] & 0xFF);
                    ++i;
                    j += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < pmax) {
                    pixels[i] = (short)((byteArray[j] & 0xFF) << 8 | byteArray[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            if (this.fi.compression == 3) {
                for (int b = base; b < pmax; ++b) {
                    int n = b;
                    pixels[n] = (short)(pixels[n] + last);
                    last = b % this.fi.width == this.fi.width - 1 ? (short)0 : pixels[b];
                }
            }
            base += pixelsRead;
            this.showProgress(k + 1, this.fi.stripOffsets.length);
        }
        if (this.fi.fileType == 1) {
            for (int i = 0; i < this.nPixels; ++i) {
                pixels[i] = (short)(pixels[i] + 32768);
            }
        }
        return pixels;
    }

    float[] read32bitImage(InputStream in) throws IOException {
        if (this.fi.compression > 1 || this.fi.stripOffsets != null && this.fi.stripOffsets.length > 1) {
            return this.readCompressed32bitImage(in);
        }
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            int tmp;
            int i;
            int count;
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            for (int bufferCount = 0; bufferCount < this.bufferSize; bufferCount += count) {
                count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count != -1) continue;
                if (bufferCount > 0) {
                    for (int i2 = bufferCount; i2 < this.bufferSize; ++i2) {
                        buffer[i2] = 0;
                    }
                }
                totalRead = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int pmax = base + pixelsRead;
            if (pmax > this.nPixels) {
                pmax = this.nPixels;
            }
            int j = 0;
            if (this.fi.intelByteOrder) {
                for (i = base; i < pmax; ++i) {
                    tmp = (buffer[j + 3] & 0xFF) << 24 | (buffer[j + 2] & 0xFF) << 16 | (buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                }
            } else {
                for (i = base; i < pmax; ++i) {
                    tmp = (buffer[j] & 0xFF) << 24 | (buffer[j + 1] & 0xFF) << 16 | (buffer[j + 2] & 0xFF) << 8 | buffer[j + 3] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    float[] readCompressed32bitImage(InputStream in) throws IOException {
        float[] pixels = new float[this.nPixels];
        int base = 0;
        float last = 0.0f;
        for (int k = 0; k < this.fi.stripOffsets.length; ++k) {
            int tmp;
            int j;
            int i;
            int pmax;
            int r;
            long skip;
            if (in instanceof RandomAccessStream) {
                ((RandomAccessStream)in).seek(this.fi.stripOffsets[k]);
            } else if (k > 0 && (skip = ((long)this.fi.stripOffsets[k] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[k - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[k - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[k]];
            int read = 0;
            for (int left = byteArray.length; left > 0; left -= r) {
                r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
            }
            byteArray = this.uncompress(byteArray);
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            if ((pmax = base + (pixelsRead -= pixelsRead % this.fi.width)) > this.nPixels) {
                pmax = this.nPixels;
            }
            if (this.fi.intelByteOrder) {
                i = base;
                j = 0;
                while (i < pmax) {
                    tmp = (byteArray[j + 3] & 0xFF) << 24 | (byteArray[j + 2] & 0xFF) << 16 | (byteArray[j + 1] & 0xFF) << 8 | byteArray[j] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    ++i;
                    j += 4;
                }
            } else {
                i = base;
                j = 0;
                while (i < pmax) {
                    tmp = (byteArray[j] & 0xFF) << 24 | (byteArray[j + 1] & 0xFF) << 16 | (byteArray[j + 2] & 0xFF) << 8 | byteArray[j + 3] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    ++i;
                    j += 4;
                }
            }
            if (this.fi.compression == 3) {
                for (int b = base; b < pmax; ++b) {
                    int n = b;
                    pixels[n] = pixels[n] + last;
                    last = b % this.fi.width == this.fi.width - 1 ? 0.0f : pixels[b];
                }
            }
            base += pixelsRead;
            this.showProgress(k + 1, this.fi.stripOffsets.length);
        }
        return pixels;
    }

    float[] read64bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            int count;
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            for (int bufferCount = 0; bufferCount < this.bufferSize; bufferCount += count) {
                count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count != -1) continue;
                if (bufferCount > 0) {
                    for (int i = bufferCount; i < this.bufferSize; ++i) {
                        buffer[i] = 0;
                    }
                }
                totalRead = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int j = 0;
            for (int i = base; i < base + pixelsRead; ++i) {
                long b1 = buffer[j + 7] & 0xFF;
                long b2 = buffer[j + 6] & 0xFF;
                long b3 = buffer[j + 5] & 0xFF;
                long b4 = buffer[j + 4] & 0xFF;
                long b5 = buffer[j + 3] & 0xFF;
                long b6 = buffer[j + 2] & 0xFF;
                long b7 = buffer[j + 1] & 0xFF;
                long b8 = buffer[j] & 0xFF;
                long tmp = this.fi.intelByteOrder ? b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 : b8 << 56 | b7 << 48 | b6 << 40 | b5 << 32 | b4 << 24 | b3 << 16 | b2 << 8 | b1;
                pixels[i] = (float)Double.longBitsToDouble(tmp);
                j += 8;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readChunkyRGB(InputStream in) throws IOException {
        if (this.fi.compression == 4) {
            return this.readJPEG(in);
        }
        if (this.fi.compression > 1) {
            return this.readCompressedChunkyRGB(in);
        }
        this.bufferSize = 24 * this.width;
        byte[] buffer = new byte[this.bufferSize];
        int[] pixels = new int[this.nPixels];
        long totalRead = 0L;
        int base = 0;
        while (totalRead < this.byteCount) {
            int count;
            if (totalRead + (long)this.bufferSize > this.byteCount) {
                this.bufferSize = (int)(this.byteCount - totalRead);
            }
            for (int bufferCount = 0; bufferCount < this.bufferSize; bufferCount += count) {
                count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count != -1) continue;
                if (bufferCount > 0) {
                    for (int i = bufferCount; i < this.bufferSize; ++i) {
                        buffer[i] = 0;
                    }
                }
                totalRead = this.byteCount;
                this.eofError();
                break;
            }
            this.showProgress(totalRead += (long)this.bufferSize, this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            boolean bgr = this.fi.fileType == 10;
            int j = 0;
            for (int i = base; i < base + pixelsRead; ++i) {
                int g;
                int r;
                int b;
                if (this.bytesPerPixel == 4) {
                    if (this.fi.fileType == 15) {
                        b = buffer[j++] & 0xFF;
                        int n = ++j;
                        r = buffer[n] & 0xFF;
                        int n2 = ++j;
                        ++j;
                        g = buffer[n2] & 0xFF;
                    } else if (this.fi.fileType == 18) {
                        b = buffer[j++] & 0xFF;
                        g = buffer[j++] & 0xFF;
                        r = buffer[j++] & 0xFF;
                        ++j;
                    } else if (this.fi.fileType == 19) {
                        int a;
                        r = buffer[j++] & 0xFF;
                        g = buffer[j++] & 0xFF;
                        b = buffer[j++] & 0xFF;
                        if ((a = buffer[j++] & 0xFF) > 0) {
                            r = (r * (256 - a) >> 8) + a;
                            g = (g * (256 - a) >> 8) + a;
                            b = (b * (256 - a) >> 8) + a;
                        }
                    } else {
                        r = buffer[j++] & 0xFF;
                        g = buffer[j++] & 0xFF;
                        b = buffer[j++] & 0xFF;
                        ++j;
                    }
                } else {
                    r = buffer[j++] & 0xFF;
                    g = buffer[j++] & 0xFF;
                    b = buffer[j++] & 0xFF;
                }
                pixels[i] = bgr ? 0xFF000000 | b << 16 | g << 8 | r : 0xFF000000 | r << 16 | g << 8 | b;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readCompressedChunkyRGB(InputStream in) throws IOException {
        int[] pixels = new int[this.nPixels];
        int base = 0;
        boolean lastRed = false;
        boolean lastGreen = false;
        boolean lastBlue = false;
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        boolean bgr = this.fi.fileType == 10;
        boolean cmyk = this.fi.fileType == 19;
        boolean differencing = this.fi.compression == 3;
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            int pmax;
            int r;
            long skip;
            if (in instanceof RandomAccessStream) {
                ((RandomAccessStream)in).seek(this.fi.stripOffsets[i]);
            } else if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[i]];
            int read = 0;
            for (int left = byteArray.length; left > 0; left -= r) {
                r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
            }
            byteArray = this.uncompress(byteArray);
            if (differencing) {
                for (int b = 0; b < byteArray.length; ++b) {
                    if (b / this.bytesPerPixel % this.fi.width == 0) continue;
                    int n = b;
                    byteArray[n] = (byte)(byteArray[n] + byteArray[b - this.bytesPerPixel]);
                }
            }
            int k = 0;
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            if ((pmax = base + (pixelsRead -= pixelsRead % this.fi.width)) > this.nPixels) {
                pmax = this.nPixels;
            }
            for (int j = base; j < pmax; ++j) {
                if (this.bytesPerPixel == 4) {
                    red = byteArray[k++] & 0xFF;
                    green = byteArray[k++] & 0xFF;
                    blue = byteArray[k++] & 0xFF;
                    alpha = byteArray[k++] & 0xFF;
                    if (cmyk && alpha > 0) {
                        red = (red * (256 - alpha) >> 8) + alpha;
                        green = (green * (256 - alpha) >> 8) + alpha;
                        blue = (blue * (256 - alpha) >> 8) + alpha;
                    }
                } else {
                    red = byteArray[k++] & 0xFF;
                    green = byteArray[k++] & 0xFF;
                    blue = byteArray[k++] & 0xFF;
                }
                pixels[j] = bgr ? 0xFF000000 | blue << 16 | green << 8 | red : 0xFF000000 | red << 16 | green << 8 | blue;
            }
            base += pixelsRead;
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        return pixels;
    }

    int[] readJPEG(InputStream in) throws IOException {
        BufferedImage bi = ImageIO.read(in);
        ColorProcessor ip = new ColorProcessor(bi);
        return (int[])((ImageProcessor)ip).getPixels();
    }

    int[] readPlanarRGB(InputStream in) throws IOException {
        int i;
        if (this.fi.compression > 1) {
            return this.readCompressedPlanarRGBImage(in);
        }
        DataInputStream dis = new DataInputStream(in);
        int planeSize = this.nPixels;
        byte[] buffer = new byte[planeSize];
        int[] pixels = new int[this.nPixels];
        this.startTime = 0L;
        this.showProgress(10, 100);
        dis.readFully(buffer);
        for (i = 0; i < planeSize; ++i) {
            int r = buffer[i] & 0xFF;
            pixels[i] = 0xFF000000 | r << 16;
        }
        this.showProgress(40, 100);
        dis.readFully(buffer);
        i = 0;
        while (i < planeSize) {
            int g = buffer[i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | g << 8;
        }
        this.showProgress(70, 100);
        dis.readFully(buffer);
        i = 0;
        while (i < planeSize) {
            int b = buffer[i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | b;
        }
        this.showProgress(90, 100);
        return pixels;
    }

    int[] readCompressedPlanarRGBImage(InputStream in) throws IOException {
        int i;
        int[] pixels = new int[this.nPixels];
        this.nPixels *= 3;
        byte[] buffer = this.readCompressed8bitImage(in);
        this.nPixels /= 3;
        for (i = 0; i < this.nPixels; ++i) {
            int r = buffer[i] & 0xFF;
            pixels[i] = 0xFF000000 | r << 16;
        }
        i = 0;
        while (i < this.nPixels) {
            int g = buffer[this.nPixels + i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | g << 8;
        }
        i = 0;
        while (i < this.nPixels) {
            int b = buffer[this.nPixels * 2 + i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | b;
        }
        return pixels;
    }

    private void showProgress(int current, int last) {
        if (this.showProgressBar && System.currentTimeMillis() - this.startTime > 500L) {
            IJ.showProgress(current, last);
        }
    }

    private void showProgress(long current, long last) {
        this.showProgress((int)(current / 10L), (int)(last / 10L));
    }

    Object readRGB48(InputStream in) throws IOException {
        if (this.fi.compression > 1) {
            return this.readCompressedRGB48(in);
        }
        int channels = this.fi.samplesPerPixel;
        short[][] stack = new short[channels][this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        int pixel = 0;
        int min = 65535;
        int max = 0;
        if (this.fi.stripLengths == null) {
            this.fi.stripLengths = new int[this.fi.stripOffsets.length];
            this.fi.stripLengths[0] = this.width * this.height * this.bytesPerPixel;
        }
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            int bytesToGo;
            int len;
            long skip;
            if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                dis.skip(skip);
            }
            if ((len = this.fi.stripLengths[i]) > (bytesToGo = (this.nPixels - pixel) * channels * 2)) {
                len = bytesToGo;
            }
            byte[] buffer = new byte[len];
            dis.readFully(buffer);
            int channel = 0;
            boolean intel = this.fi.intelByteOrder;
            for (int base = 0; base < len; base += 2) {
                int value = intel ? (buffer[base + 1] & 0xFF) << 8 | buffer[base] & 0xFF : (buffer[base] & 0xFF) << 8 | buffer[base + 1] & 0xFF;
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
                stack[channel][pixel] = (short)value;
                if (++channel != channels) continue;
                channel = 0;
                ++pixel;
            }
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        this.min = min;
        this.max = max;
        return stack;
    }

    Object readCompressedRGB48(InputStream in) throws IOException {
        if (this.fi.compression == 3) {
            throw new IOException("ImageJ cannot open 48-bit LZW compressed TIFFs with predictor");
        }
        int channels = 3;
        short[][] stack = new short[channels][this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        int pixel = 0;
        int min = 65535;
        int max = 0;
        for (int i = 0; i < this.fi.stripOffsets.length; ++i) {
            long skip;
            if (i > 0 && (skip = ((long)this.fi.stripOffsets[i] & 0xFFFFFFFFL) - ((long)this.fi.stripOffsets[i - 1] & 0xFFFFFFFFL) - (long)this.fi.stripLengths[i - 1]) > 0L) {
                dis.skip(skip);
            }
            int len = this.fi.stripLengths[i];
            byte[] buffer = new byte[len];
            dis.readFully(buffer);
            buffer = this.uncompress(buffer);
            len = buffer.length;
            if (len % 2 != 0) {
                --len;
            }
            int channel = 0;
            boolean intel = this.fi.intelByteOrder;
            for (int base = 0; base < len && pixel < this.nPixels; base += 2) {
                int value = intel ? (buffer[base + 1] & 0xFF) << 8 | buffer[base] & 0xFF : (buffer[base] & 0xFF) << 8 | buffer[base + 1] & 0xFF;
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
                stack[channel][pixel] = (short)value;
                if (++channel != channels) continue;
                channel = 0;
                ++pixel;
            }
            this.showProgress(i + 1, this.fi.stripOffsets.length);
        }
        this.min = min;
        this.max = max;
        return stack;
    }

    Object readRGB48Planar(InputStream in) throws IOException {
        short[] red = this.read16bitImage(in);
        short[] green = this.read16bitImage(in);
        short[] blue = this.read16bitImage(in);
        Object[] stack = new Object[]{red, green, blue};
        return stack;
    }

    short[] read12bitImage(InputStream in) throws IOException {
        int bytesPerLine = (int)((double)this.width * 1.5);
        if ((this.width & 1) == 1) {
            ++bytesPerLine;
        }
        byte[] buffer = new byte[bytesPerLine * this.height];
        short[] pixels = new short[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(buffer);
        block0: for (int y = 0; y < this.height; ++y) {
            int index1 = y * bytesPerLine;
            int index2 = y * this.width;
            int count = 0;
            while (count < this.width) {
                pixels[index2 + count] = (short)((buffer[index1] & 0xFF) * 16 + (buffer[index1 + 1] >> 4 & 0xF));
                if (++count == this.width) continue block0;
                pixels[index2 + count] = (short)((buffer[index1 + 1] & 0xF) * 256 + (buffer[index1 + 2] & 0xFF));
                ++count;
                index1 += 3;
            }
        }
        return pixels;
    }

    float[] read24bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.width * 3];
        float[] pixels = new float[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        for (int y = 0; y < this.height; ++y) {
            dis.readFully(buffer);
            int b = 0;
            for (int x = 0; x < this.width; ++x) {
                int b1 = buffer[b++] & 0xFF;
                int b2 = buffer[b++] & 0xFF;
                int b3 = buffer[b++] & 0xFF;
                pixels[x + y * this.width] = b3 << 16 | b2 << 8 | b1;
            }
        }
        return pixels;
    }

    byte[] read1bitImage(InputStream in) throws IOException {
        if (this.fi.compression == 2) {
            throw new IOException("ImageJ cannot open 1-bit LZW compressed TIFFs");
        }
        int scan = (int)Math.ceil((double)this.width / 8.0);
        int len = scan * this.height;
        byte[] buffer = new byte[len];
        byte[] pixels = new byte[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(buffer);
        for (int y = 0; y < this.height; ++y) {
            int offset = y * scan;
            int index = y * this.width;
            for (int x = 0; x < scan; ++x) {
                int value1 = buffer[offset + x] & 0xFF;
                for (int i = 7; i >= 0; --i) {
                    int value2;
                    int n = value2 = (value1 & 1 << i) != 0 ? 255 : 0;
                    if (index >= pixels.length) continue;
                    pixels[index++] = (byte)value2;
                }
            }
        }
        return pixels;
    }

    void skip(InputStream in) throws IOException {
        if (this.skipCount > 0L) {
            long count;
            int skipAttempts = 0;
            for (long bytesRead = 0L; bytesRead < this.skipCount && (count = in.skip(this.skipCount - bytesRead)) != -1L && ++skipAttempts <= 5; bytesRead += count) {
            }
        }
        this.byteCount = (long)this.width * (long)this.height * (long)this.bytesPerPixel;
        if (this.fi.fileType == 8) {
            int scan = this.width / 8;
            int pad = this.width % 8;
            if (pad > 0) {
                ++scan;
            }
            this.byteCount = scan * this.height;
        }
        this.nPixels = this.width * this.height;
        this.bufferSize = (int)(this.byteCount / 25L);
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream in) {
        this.startTime = System.currentTimeMillis();
        try {
            Object pixels;
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    pixels = this.read8bitImage(in);
                    break;
                }
                case 1: 
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(in);
                    pixels = this.read16bitImage(in);
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    this.bytesPerPixel = 4;
                    this.skip(in);
                    pixels = this.read32bitImage(in);
                    break;
                }
                case 16: {
                    this.bytesPerPixel = 8;
                    this.skip(in);
                    pixels = this.read64bitImage(in);
                    break;
                }
                case 6: 
                case 9: 
                case 10: 
                case 15: 
                case 18: 
                case 19: {
                    this.bytesPerPixel = this.fi.getBytesPerPixel();
                    this.skip(in);
                    pixels = this.readChunkyRGB(in);
                    break;
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(in);
                    pixels = this.readPlanarRGB(in);
                    break;
                }
                case 8: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    pixels = this.read1bitImage(in);
                    break;
                }
                case 12: {
                    this.bytesPerPixel = 6;
                    this.skip(in);
                    pixels = this.readRGB48(in);
                    break;
                }
                case 17: {
                    this.bytesPerPixel = 2;
                    this.skip(in);
                    pixels = this.readRGB48Planar(in);
                    break;
                }
                case 13: {
                    this.skip(in);
                    short[] data = this.read12bitImage(in);
                    pixels = data;
                    break;
                }
                case 14: {
                    this.skip(in);
                    pixels = this.read24bitImage(in);
                    break;
                }
                default: {
                    pixels = null;
                }
            }
            this.showProgress(1, 1);
            return pixels;
        }
        catch (IOException e) {
            IJ.log("" + e);
            return null;
        }
    }

    public Object readPixels(InputStream in, long skipCount) {
        this.skipCount = skipCount;
        this.showProgressBar = false;
        Object pixels = this.readPixels(in);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return pixels;
    }

    public Object readPixels(String url) {
        InputStream is;
        URL theURL;
        try {
            theURL = new URL(url);
        }
        catch (MalformedURLException e) {
            IJ.log("" + e);
            return null;
        }
        try {
            is = theURL.openStream();
        }
        catch (IOException e) {
            IJ.log("" + e);
            return null;
        }
        return this.readPixels(is);
    }

    byte[] uncompress(byte[] input) {
        if (this.fi.compression == 5) {
            return this.packBitsUncompress(input, this.fi.rowsPerStrip * this.fi.width * this.fi.getBytesPerPixel());
        }
        if (this.fi.compression == 2 || this.fi.compression == 3) {
            return this.lzwUncompress(input);
        }
        if (this.fi.compression == 6) {
            return this.zipUncompress(input);
        }
        return input;
    }

    public byte[] zipUncompress(byte[] input) {
        ByteArrayOutputStream imageBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        try {
            while (!decompressor.finished()) {
                int rlen = decompressor.inflate(buffer);
                imageBuffer.write(buffer, 0, rlen);
            }
        }
        catch (DataFormatException e) {
            IJ.log(e.toString());
        }
        decompressor.end();
        return imageBuffer.toByteArray();
    }

    public byte[] lzwUncompress(byte[] input) {
        int code;
        if (input == null || input.length == 0) {
            return input;
        }
        byte[][] symbolTable = new byte[4096][1];
        int bitsToRead = 9;
        int nextSymbol = 258;
        int oldCode = -1;
        ByteVector out = new ByteVector(8192);
        BitBuffer bb = new BitBuffer(input);
        byte[] byteBuffer1 = new byte[16];
        byte[] byteBuffer2 = new byte[16];
        while ((long)out.size() < this.byteCount && (code = bb.getBits(bitsToRead)) != 257 && code != -1) {
            ByteVector symbol;
            if (code == 256) {
                for (int i = 0; i < 256; ++i) {
                    symbolTable[i][0] = (byte)i;
                }
                nextSymbol = 258;
                bitsToRead = 9;
                code = bb.getBits(bitsToRead);
                if (code == 257 || code == -1) break;
                out.add(symbolTable[code]);
                oldCode = code;
                continue;
            }
            if (code < nextSymbol) {
                out.add(symbolTable[code]);
                symbol = new ByteVector(byteBuffer1);
                symbol.add(symbolTable[oldCode]);
                symbol.add(symbolTable[code][0]);
                symbolTable[nextSymbol] = symbol.toByteArray();
                oldCode = code;
                ++nextSymbol;
            } else {
                symbol = new ByteVector(byteBuffer2);
                symbol.add(symbolTable[oldCode]);
                symbol.add(symbolTable[oldCode][0]);
                byte[] outString = symbol.toByteArray();
                out.add(outString);
                symbolTable[nextSymbol] = outString;
                oldCode = code;
                ++nextSymbol;
            }
            if (nextSymbol == 511) {
                bitsToRead = 10;
            }
            if (nextSymbol == 1023) {
                bitsToRead = 11;
            }
            if (nextSymbol != 2047) continue;
            bitsToRead = 12;
        }
        return out.toByteArray();
    }

    public byte[] packBitsUncompress(byte[] input, int expected) {
        if (expected == 0) {
            expected = Integer.MAX_VALUE;
        }
        ByteVector output = new ByteVector(1024);
        int index = 0;
        while (output.size() < expected && index < input.length) {
            byte n;
            if ((n = input[index++]) >= 0) {
                byte[] b = new byte[n + 1];
                for (int i = 0; i < n + 1; ++i) {
                    b[i] = input[index++];
                }
                output.add(b);
                b = null;
                continue;
            }
            if (n == -128) continue;
            int len = -n + 1;
            byte inp = input[index++];
            for (int i = 0; i < len; ++i) {
                output.add(inp);
            }
        }
        return output.toByteArray();
    }
}

