/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.IJ;
import ij.measure.UserFunction;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;

public class Minimizer {
    public static final int SUCCESS = 0;
    public static final int INITIALIZATION_FAILURE = 1;
    public static final int ABORTED = 2;
    public static final int REINITIALIZATION_FAILURE = 3;
    public static final int MAX_ITERATIONS_EXCEEDED = 4;
    public static final int MAX_RESTARTS_EXCEEDED = 5;
    public static final String[] STATUS_STRING = new String[]{"Success", "Initialization failure; no result", "Aborted", "Re-initialization failure (inaccurate result?)", "Max. no. of iterations reached (inaccurate result?)", "Max. no. of restarts reached (inaccurate result?)"};
    private static final double C_REFLECTION = 1.0;
    private static final double C_CONTRACTION = 0.5;
    private static final double C_EXPANSION = 2.0;
    private static final double C_SHRINK = 0.5;
    private static final int ITER_FACTOR = 750;
    private static final int WORST = 0;
    private static final int NEXT_WORST = 1;
    private static final int BEST = 2;
    private int numParams;
    private int numVertices;
    private int numExtraArrayElements;
    private UserFunction userFunction;
    private double maxRelError = 1.0E-10;
    private double maxAbsError = 1.0E-100;
    private double[] paramResolutions;
    private int maxIter;
    private int totalNumIter;
    private int numCompletedMinimizations;
    private int maxRestarts = 2;
    private int randomSeed;
    private boolean useSingleThread = Runtime.getRuntime().availableProcessors() <= 1;
    private int status;
    private boolean wasInitialized;
    private double[] result;
    private Vector<double[]> resultsVector;
    private String ijStatusString = null;
    private boolean checkEscape;
    private int nextIterationForStatus = 10;
    private long startTime;

    public void setFunction(UserFunction userFunction, int numParams) {
        if (this.maxIter <= 0) {
            this.maxIter = 750 * numParams * numParams;
            if (this.maxRestarts > 0) {
                this.maxIter *= 2;
            }
        }
        this.userFunction = userFunction;
        this.numParams = numParams;
        this.numVertices = numParams + 1;
    }

    public int minimize(final double[] initialParams, final double[] initialParamVariations) {
        this.status = 0;
        this.resultsVector = new Vector();
        int maxLoopCount = this.maxRestarts + 1;
        if (this.useSingleThread) {
            maxLoopCount *= 2;
        }
        for (int i = 0; i < maxLoopCount; ++i) {
            Thread secondThread = null;
            if (this.maxRestarts > 0 && !this.useSingleThread) {
                final int seed = this.randomSeed + 1000000 + i;
                Thread thread = new Thread(new Runnable(){

                    public final void run() {
                        Minimizer.this.minimizeOnce(initialParams, initialParamVariations, seed);
                    }
                }, "Minimizer-1");
                thread.setPriority(Thread.currentThread().getPriority());
                thread.start();
                secondThread = thread;
            }
            this.minimizeOnce(initialParams, initialParamVariations, this.randomSeed + i);
            if (secondThread != null) {
                try {
                    secondThread.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.resultsVector.size() == 0 && this.result == null) {
                return this.status;
            }
            if (this.result == null) {
                this.result = this.resultsVector.get(0);
            }
            for (double[] r : this.resultsVector) {
                if (!(this.value(r) < this.value(this.result))) continue;
                this.result = r;
            }
            if (this.status != 0 && this.status != 3 && this.status != 4) {
                return this.status;
            }
            if (this.totalNumIter >= this.maxIter) {
                return 4;
            }
            for (int ir = 0; ir < this.resultsVector.size(); ++ir) {
                if (this.belowErrorLimit(this.value(this.resultsVector.get(ir)), this.value(this.result), 1.0)) continue;
                this.resultsVector.remove(ir);
                --ir;
            }
            if (this.resultsVector.size() < 2) continue;
            return 0;
        }
        if (this.ijStatusString != null) {
            IJ.showStatus("");
        }
        return this.maxRestarts > 0 ? 5 : this.status;
    }

    public int minimizeOnce(double[] initialParams, double[] initialParamVariations) {
        this.status = 0;
        this.minimizeOnce(initialParams, initialParamVariations, this.randomSeed);
        return this.status;
    }

    public double[] getParams() {
        if (this.result == null) {
            this.result = new double[this.numParams + 1 + this.numExtraArrayElements];
            Arrays.fill(this.result, Double.NaN);
        }
        return this.result;
    }

    public double getFunctionValue() {
        if (this.result == null) {
            this.result = new double[this.numParams + 1];
            Arrays.fill(this.result, Double.NaN);
        }
        return this.value(this.result);
    }

    public int getIterations() {
        return this.totalNumIter;
    }

    public void setMaxIterations(int x) {
        this.maxIter = x;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxRestarts(int n) {
        this.maxRestarts = n;
    }

    public int getMaxRestarts() {
        return this.maxRestarts;
    }

    public int getCompletedMinimizations() {
        return this.numCompletedMinimizations;
    }

    public void setRandomSeed(int n) {
        this.randomSeed = n;
    }

    public void setMaxError(double maxRelError) {
        this.maxRelError = maxRelError;
    }

    public void setMaxError(double maxRelError, double maxAbsError) {
        this.maxRelError = maxRelError;
        this.maxAbsError = maxAbsError;
    }

    public void setParamResolutions(double[] paramResolutions) {
        this.paramResolutions = paramResolutions;
    }

    public void setMaximumThreads(int numThreads) {
        this.useSingleThread = numThreads <= 1;
    }

    public void abort() {
        this.status = 2;
    }

    public void setStatusAndEsc(String ijStatusString, boolean checkEscape) {
        this.ijStatusString = ijStatusString;
        this.checkEscape = checkEscape;
    }

    public void setExtraArrayElements(int numExtraArrayElements) {
        this.numExtraArrayElements = numExtraArrayElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minimizeOnce(double[] initialParams, double[] initialParamVariations, int seed) {
        Random random = new Random(seed);
        double[][] simp = this.makeSimplex(initialParams, initialParamVariations, random);
        if (simp == null) {
            this.status = this.wasInitialized ? 3 : 1;
            return;
        }
        this.wasInitialized = true;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        int bestVertexNumber = this.minimize(simp);
        double bestValueSoFar = this.value(simp[bestVertexNumber]);
        boolean reinitialisationFailure = false;
        while (this.status == 0 || this.status == 3) {
            double[] paramVariations = this.makeNewParamVariations(simp, bestVertexNumber, initialParams, initialParamVariations);
            if (!this.reInitializeSimplex(simp, bestVertexNumber, paramVariations, random)) {
                reinitialisationFailure = true;
                break;
            }
            bestVertexNumber = this.minimize(simp);
            if (this.belowErrorLimit(this.value(simp[bestVertexNumber]), bestValueSoFar, 2.0)) break;
            bestValueSoFar = this.value(simp[bestVertexNumber]);
        }
        if (reinitialisationFailure) {
            this.status = 3;
        } else if (this.status == 0 || this.status == 3) {
            ++this.numCompletedMinimizations;
        }
        if (this.resultsVector != null) {
            Vector<double[]> vector = this.resultsVector;
            synchronized (vector) {
                this.resultsVector.add(simp[bestVertexNumber]);
            }
        } else {
            this.result = simp[bestVertexNumber];
        }
    }

    /*
     * Unable to fully structure code
     */
    private int minimize(double[][] simp) {
        worstNextBestArray = new int[3];
        center = new double[this.numParams + 1 + this.numExtraArrayElements];
        reflected = new double[this.numParams + 1 + this.numExtraArrayElements];
        secondTry = new double[this.numParams + 1 + this.numExtraArrayElements];
        this.order(simp, worstNextBestArray);
        worst = worstNextBestArray[0];
        nextWorst = worstNextBestArray[1];
        best = worstNextBestArray[2];
        thisNumIter = 0;
        while (true) {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            ++this.totalNumIter;
                            ++thisNumIter;
                            this.getCenter(simp, worst, center);
                            this.getVertexAndEvaluate(center, simp[worst], -1.0, reflected);
                            if (!(this.value(reflected) <= this.value(simp[best]))) break block8;
                            this.getVertexAndEvaluate(center, simp[worst], -2.0, secondTry);
                            if (!(this.value(secondTry) <= this.value(reflected))) break block8;
                            this.copyVertex(secondTry, simp[worst]);
                            break block9;
                        }
                        if (!(this.value(reflected) < this.value(simp[nextWorst]))) break block10;
                        this.copyVertex(reflected, simp[worst]);
                        break block9;
                    }
                    if (!(this.value(reflected) < this.value(simp[worst]))) break block11;
                    this.getVertexAndEvaluate(center, simp[worst], -0.5, secondTry);
                    if (!(this.value(secondTry) <= this.value(reflected))) ** GOTO lbl-1000
                    this.copyVertex(secondTry, simp[worst]);
                    break block9;
                }
                if (!(this.value(reflected) > this.value(simp[worst])) && !Double.isNaN(this.value(reflected))) ** GOTO lbl-1000
                this.getVertexAndEvaluate(center, simp[worst], 0.5, secondTry);
                if (this.value(secondTry) < this.value(simp[worst])) {
                    this.copyVertex(secondTry, simp[worst]);
                } else lbl-1000:
                // 3 sources

                {
                    this.shrinkSimplexAndEvaluate(simp, best);
                }
            }
            checkParamResolution = this.paramResolutions != null && this.belowResolutionLimit(simp[worst], simp[best]) != false;
            this.order(simp, worstNextBestArray);
            worst = worstNextBestArray[0];
            nextWorst = worstNextBestArray[1];
            best = worstNextBestArray[2];
            if (checkParamResolution && this.belowResolutionLimit(simp, best)) break;
            if (this.belowErrorLimit(this.value(simp[best]), this.value(simp[worst]), 4.0)) {
                this.getCenter(simp, -1, secondTry);
                this.evaluate(secondTry);
                if (this.value(secondTry) < this.value(simp[best])) {
                    this.copyVertex(secondTry, simp[best]);
                }
            }
            if (this.belowErrorLimit(this.value(simp[best]), this.value(simp[worst]), 4.0)) break;
            if (this.totalNumIter > this.maxIter || thisNumIter > 4 * (this.maxIter / 10)) {
                this.status = 4;
            }
            if (this.status != 0) break;
            if (this.ijStatusString == null && !this.checkEscape || this.totalNumIter <= this.nextIterationForStatus) continue;
            time = System.currentTimeMillis();
            this.nextIterationForStatus = this.totalNumIter + (int)((long)this.totalNumIter * 500L / (time - this.startTime + 1L));
            if (time - this.startTime <= 1000L) continue;
            if (this.checkEscape && IJ.escapePressed()) {
                this.status = 2;
                IJ.resetEscape();
                IJ.showStatus(this.ijStatusString + " ABORTED");
                break;
            }
            if (this.ijStatusString == null) continue;
            statusString = this.ijStatusString + this.totalNumIter + " (" + this.maxIter + " max)";
            if (this.checkEscape) {
                statusString = statusString + " ESC to stop";
            }
            IJ.showStatus(statusString);
        }
        return best;
    }

    private void getVertexAndEvaluate(double[] center, double[] worstVertex, double howFar, double[] newVertex) {
        for (int i = 0; i < this.numParams; ++i) {
            newVertex[i] = (1.0 - howFar) * center[i] + howFar * worstVertex[i];
        }
        this.evaluate(newVertex);
    }

    private void getCenter(double[][] simp, int excludeVertex, double[] center) {
        Arrays.fill(center, 0.0);
        int nV = 0;
        for (int v = 0; v < this.numVertices; ++v) {
            if (v == excludeVertex) continue;
            for (int i = 0; i < this.numParams; ++i) {
                int n = i;
                center[n] = center[n] + simp[v][i];
            }
            ++nV;
        }
        double norm = 1.0 / (double)nV;
        int i = 0;
        while (i < this.numParams) {
            int n = i++;
            center[n] = center[n] * norm;
        }
    }

    private void shrinkSimplexAndEvaluate(double[][] simp, int best) {
        for (int v = 0; v < this.numVertices; ++v) {
            if (v == best) continue;
            for (int i = 0; i < this.numParams; ++i) {
                simp[v][i] = 0.5 * simp[v][i] + 0.5 * simp[best][i];
            }
            this.evaluate(simp[v]);
        }
    }

    private boolean belowErrorLimit(double highest, double lowest, double sensitivity) {
        double absError = sensitivity * Math.abs(highest - lowest);
        double relError = absError / (Math.max(Math.abs(highest), Math.abs(lowest)) + 1.0E-100);
        return relError < this.maxRelError || absError < this.maxAbsError;
    }

    private double[][] makeSimplex(double[] initialParams, double[] initialParamVariations, Random random) {
        double[][] simp = new double[this.numVertices][this.numParams + 1 + this.numExtraArrayElements];
        if (initialParams != null) {
            for (int i = 0; i < this.numParams; ++i) {
                if (!Double.isNaN(initialParams[i]) || !IJ.debugMode) continue;
                IJ.log("Warning: Initial Parameter[" + i + "] is NaN");
            }
            System.arraycopy(initialParams, 0, simp[0], 0, Math.min(initialParams.length, this.numParams));
        }
        this.evaluate(simp[0]);
        if (Double.isNaN(this.value(simp[0]))) {
            if (IJ.debugMode) {
                this.showVertex(simp[0], "Warning: Initial Parameters yield NaN:");
            }
            this.findValidInitalParams(simp[0], initialParamVariations, random);
        }
        if (Double.isNaN(this.value(simp[0]))) {
            if (IJ.debugMode) {
                IJ.log("Error: Could not find initial parameters not yielding NaN:");
            }
            return null;
        }
        if (this.initializeSimplex(simp, initialParamVariations, random)) {
            return simp;
        }
        if (IJ.debugMode) {
            this.showSimplex(simp, "Error: Could not make simplex vertices not yielding NaN");
        }
        return null;
    }

    private boolean belowResolutionLimit(double[][] simp, int best) {
        for (int v = 0; v < this.numVertices; ++v) {
            if (v == best || this.belowResolutionLimit(simp[v], simp[best])) continue;
            return false;
        }
        return true;
    }

    private boolean belowResolutionLimit(double[] vertex1, double[] vertex2) {
        for (int i = 0; i < this.numParams; ++i) {
            if (!(Math.abs(vertex1[i] - vertex2[i]) >= this.paramResolutions[i])) continue;
            return false;
        }
        return true;
    }

    private void findValidInitalParams(double[] params, double[] initialParamVariations, Random random) {
        int maxAttempts = 50 * this.numParams * this.numParams;
        double rangeFactor = 1.0;
        double rangeMultiplyLog = Math.log(1.0E20) / (double)(maxAttempts - 1);
        double[] firstParams = new double[this.numParams];
        double[] variations = new double[this.numParams];
        for (int i = 0; i < this.numParams; ++i) {
            firstParams[i] = Double.isNaN(params[i]) ? 0.0 : params[i];
            double d = variations[i] = initialParamVariations != null ? initialParamVariations[i] : 0.1 * firstParams[i];
            if (!Double.isNaN(variations[i]) && !(Math.abs(variations[i]) < 1.0E-10) && !(Math.abs(variations[i]) > 1.0E10)) continue;
            variations[i] = 0.1;
        }
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            for (int i = 0; i < this.numParams; ++i) {
                double multiplier = attempt < maxAttempts / 10 ? 1.0 : Math.exp(rangeMultiplyLog * (double)attempt * 2.0 * (random.nextDouble() - 0.5));
                params[i] = multiplier * (firstParams[i] + 2.0 * (random.nextDouble() - 0.5) * variations[i]);
            }
            this.evaluate(params);
            if (Double.isNaN(this.value(params))) continue;
            return;
        }
    }

    private boolean reInitializeSimplex(double[][] simp, int bestVertexNumber, double[] paramVariations, Random random) {
        if (bestVertexNumber != 0) {
            double[] swap = simp[0];
            simp[0] = simp[bestVertexNumber];
            simp[bestVertexNumber] = swap;
        }
        return this.initializeSimplex(simp, paramVariations, random);
    }

    private boolean initializeSimplex(double[][] simp, double[] paramVariations, Random random) {
        double[] variations = new double[this.numParams];
        for (int i = 0; i < this.numParams; ++i) {
            double range;
            double d = range = paramVariations != null && i < paramVariations.length ? paramVariations[i] : 0.1 * Math.abs(simp[0][i]);
            if (range < 1.0E-100 || Double.isNaN(range)) {
                range = 0.01;
            }
            if (Math.abs(range / simp[0][i]) < 1.0E-10) {
                range = Math.abs(simp[0][i] * 1.0E-10);
            }
            variations[i] = range;
        }
        int maxAttempts = 100 * this.numParams;
        for (int v = 1; v < this.numVertices; ++v) {
            int numTries = 0;
            do {
                int i;
                if (numTries++ > maxAttempts) {
                    return false;
                }
                for (int i2 = 0; i2 < this.numParams; ++i2) {
                    simp[v][i2] = (double)(2.0f * random.nextFloat()) - 1.0;
                }
                if (numTries < maxAttempts / 3) {
                    for (int v2 = 1; v2 < v; ++v2) {
                        int i3;
                        double lengthSqr = 0.0;
                        double innerProduct = 0.0;
                        for (i3 = 0; i3 < this.numParams; ++i3) {
                            double x2 = (simp[v2][i3] - simp[0][i3]) / variations[i3];
                            lengthSqr += x2 * x2;
                            innerProduct += x2 * simp[v][i3];
                        }
                        for (i3 = 0; i3 < this.numParams; ++i3) {
                            double[] dArray = simp[v];
                            int n = i3;
                            dArray[n] = dArray[n] - (simp[v2][i3] - simp[0][i3]) / variations[i3] * (innerProduct / lengthSqr);
                        }
                    }
                }
                double sumSqr = 0.0;
                for (i = 0; i < this.numParams; ++i) {
                    sumSqr += simp[v][i] * simp[v][i];
                }
                if (sumSqr < 1.0E-14) continue;
                if (numTries > 2 && sumSqr > 1.0E-6) {
                    sumSqr = 1.0;
                }
                for (i = 0; i < this.numParams; ++i) {
                    simp[v][i] = simp[0][i] + simp[v][i] / Math.sqrt(sumSqr) * variations[i];
                }
                this.evaluate(simp[v]);
            } while (Double.isNaN(this.value(simp[v])) && (this.status == 0 || this.status == 3));
        }
        return true;
    }

    private double[] makeNewParamVariations(double[][] simp, int bestVertexNumber, double[] initialParams, double[] initialParamVariations) {
        double[] paramVariations = new double[this.numParams];
        double[] relatedTo = new double[this.numParams];
        double logTypicalRelativeVariation = 0.0;
        for (int i = 0; i < this.numParams; ++i) {
            double variation = 0.0;
            for (int v = 0; v < this.numVertices; ++v) {
                if (v == bestVertexNumber) continue;
                double delta = Math.abs(simp[v][i] - simp[bestVertexNumber][i]);
                int n = i;
                paramVariations[n] = paramVariations[n] + delta * delta;
            }
            paramVariations[i] = 10.0 * Math.sqrt(paramVariations[i]);
            relatedTo[i] = initialParamVariations != null && initialParamVariations.length >= this.numParams ? initialParamVariations[i] : Math.max(Math.abs(initialParams[i]), Math.abs(simp[bestVertexNumber][i]));
            double logRelativeVariation = paramVariations[i] > relatedTo[i] ? 0.0 : Math.log(paramVariations[i] / relatedTo[i]);
            logTypicalRelativeVariation += logRelativeVariation;
        }
        double typicalRelativeVariation = Math.exp(logTypicalRelativeVariation /= (double)this.numParams);
        double WORST_RATIO = 0.001;
        for (int i = 0; i < this.numParams; ++i) {
            if (paramVariations[i] < relatedTo[i] && paramVariations[i] / relatedTo[i] < typicalRelativeVariation * 0.001) {
                paramVariations[i] = relatedTo[i] * typicalRelativeVariation * 0.001;
            }
            if (this.paramResolutions == null || !(paramVariations[i] < 10.0 * this.paramResolutions[i])) continue;
            paramVariations[i] = 10.0 * this.paramResolutions[i];
        }
        return paramVariations;
    }

    private void evaluate(double[] vertex) {
        vertex[this.numParams] = this.userFunction.userFunction(vertex, 0.0);
    }

    private double value(double[] vertex) {
        return vertex[this.numParams];
    }

    void copyVertex(double[] newVertex, double[] vertex) {
        System.arraycopy(newVertex, 0, vertex, 0, newVertex.length);
    }

    private void order(double[][] simp, int[] worstNextBestArray) {
        int i;
        int worst = 0;
        int nextWorst = 0;
        int best = 0;
        for (i = 0; i < this.numVertices; ++i) {
            if (this.value(simp[i]) < this.value(simp[best])) {
                best = i;
            }
            if (!(this.value(simp[i]) > this.value(simp[worst]))) continue;
            worst = i;
        }
        nextWorst = best;
        for (i = 0; i < this.numVertices; ++i) {
            if (i == worst || !(this.value(simp[i]) > this.value(simp[nextWorst]))) continue;
            nextWorst = i;
        }
        worstNextBestArray[0] = worst;
        worstNextBestArray[1] = nextWorst;
        worstNextBestArray[2] = best;
    }

    private synchronized void showSimplex(double[][] simp, String heading) {
        IJ.log("Minimizer: " + heading);
        for (int i = 0; i < this.numVertices; ++i) {
            this.showVertex(simp[i], null);
        }
    }

    private synchronized void showVertex(double[] vertex, String heading) {
        if (heading != null) {
            IJ.log(heading);
        }
        String s = "";
        for (int j = 0; j < this.numParams; ++j) {
            s = s + "  " + IJ.d2s(vertex[j], 8, 12);
        }
        s = s + " -> " + IJ.d2s(this.value(vertex), 8, 12);
        IJ.log(s);
    }
}

