/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.GifDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class GIF_Reader
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open GIF...", arg);
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String dir = od.getDirectory();
        GifDecoder d = new GifDecoder();
        int status = d.read(dir + name);
        int n = d.getFrameCount();
        ImageStack stack = null;
        for (int i = 0; i < n; ++i) {
            ImageProcessor frame = d.getFrame(i);
            if (i == 0) {
                stack = new ImageStack(frame.getWidth(), frame.getHeight());
            }
            int t = d.getDelay(i);
            stack.addSlice(null, frame);
        }
        if (stack != null) {
            this.setStack(name, stack);
            if (this.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(this);
            }
            FileInfo fi = new FileInfo();
            fi.fileFormat = 3;
            fi.fileName = name;
            fi.directory = dir;
            this.setFileInfo(fi);
        }
    }
}

