/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;

public class PointToolOptions
implements PlugIn,
DialogListener {
    boolean multipointTool;

    public void run(String arg) {
        this.showDialog();
    }

    void showDialog() {
        String options;
        String string = options = IJ.isMacro() ? Macro.getOptions() : null;
        if (options != null) {
            options = options.replace("selection=", "color=");
            options = options.replace("marker=", "size=");
            Macro.setOptions(options);
        }
        this.multipointTool = IJ.getToolName().equals("multipoint");
        Color sc = Roi.getColor();
        String sname = Colors.getColorName(sc, "Yellow");
        Color cc = PointRoi.getDefaultCrossColor();
        String cname = Colors.getColorName(cc, "None");
        String type = PointRoi.types[PointRoi.getDefaultType()];
        String size = PointRoi.sizes[PointRoi.getDefaultSize()];
        GenericDialog gd = new GenericDialog("Point Tool");
        gd.setInsets(5, 0, 2);
        gd.addChoice("Type:", PointRoi.types, type);
        gd.addChoice("Color:", Colors.getColors(new String[0]), sname);
        gd.addChoice("Size:", PointRoi.sizes, size);
        if (!this.multipointTool) {
            gd.addCheckbox("Auto-measure", Prefs.pointAutoMeasure);
            gd.addCheckbox("Auto-next slice", Prefs.pointAutoNextSlice);
            gd.addCheckbox("Add_to overlay", Prefs.pointAddToOverlay);
            gd.addCheckbox("Add to ROI Manager", Prefs.pointAddToManager);
        }
        gd.addCheckbox("Label points", !Prefs.noPointLabels);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            // empty if block
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        ImagePlus imp;
        boolean noPointLabels;
        String selectionColor;
        Color sc;
        boolean redraw = false;
        int index = gd.getNextChoiceIndex();
        if (index != PointRoi.getDefaultType()) {
            PointRoi.setDefaultType(index);
            redraw = true;
        }
        if ((sc = Colors.getColor(selectionColor = gd.getNextChoice(), Color.yellow)) != Roi.getColor()) {
            Roi.setColor(sc);
            redraw = true;
            Toolbar.getInstance().repaint();
        }
        if ((index = gd.getNextChoiceIndex()) != PointRoi.getDefaultSize()) {
            PointRoi.setDefaultSize(index);
            redraw = true;
        }
        if (!this.multipointTool) {
            Prefs.pointAutoMeasure = gd.getNextBoolean();
            Prefs.pointAutoNextSlice = gd.getNextBoolean();
            Prefs.pointAddToOverlay = gd.getNextBoolean();
            Prefs.pointAddToManager = gd.getNextBoolean();
            if (Prefs.pointAddToOverlay) {
                Prefs.pointAddToManager = false;
            }
            if (Prefs.pointAutoNextSlice && !Prefs.pointAddToManager) {
                Prefs.pointAutoMeasure = true;
            }
        }
        boolean bl = noPointLabels = !gd.getNextBoolean();
        if (noPointLabels != Prefs.noPointLabels) {
            redraw = true;
        }
        Prefs.noPointLabels = noPointLabels;
        if (redraw && (imp = WindowManager.getCurrentImage()) != null) {
            Roi roi = imp.getRoi();
            if (roi instanceof PointRoi) {
                ((PointRoi)roi).setShowLabels(!Prefs.noPointLabels);
            }
            imp.draw();
        }
        return true;
    }
}

