/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class ScreenGrabber
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp2 = null;
        imp2 = arg.equals("image") || arg.equals("flatten") ? this.captureImage() : this.captureScreen();
        if (imp2 != null) {
            imp2.show();
        }
    }

    public ImagePlus captureScreen() {
        ImagePlus imp = null;
        try {
            Robot robot = new Robot();
            Dimension dimension = IJ.getScreenSize();
            Rectangle r = new Rectangle(dimension);
            BufferedImage img = robot.createScreenCapture(r);
            if (img != null) {
                imp = new ImagePlus("Screenshot", img);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imp;
    }

    public ImagePlus captureImage() {
        ImagePlus imp = IJ.getImage();
        if (imp == null) {
            IJ.noImage();
            return null;
        }
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return null;
        }
        win.toFront();
        IJ.wait(500);
        Point loc = win.getLocation();
        ImageCanvas ic = win.getCanvas();
        Rectangle bounds = ic.getBounds();
        loc.x += bounds.x;
        loc.y += bounds.y;
        Rectangle r = new Rectangle(loc.x, loc.y, bounds.width, bounds.height);
        ImagePlus imp2 = null;
        BufferedImage img = null;
        boolean wasHidden = ic.hideZoomIndicator(true);
        try {
            Robot robot = new Robot();
            img = robot.createScreenCapture(r);
        }
        catch (Exception e) {
            // empty catch block
        }
        ic.hideZoomIndicator(wasHidden);
        if (img != null) {
            String title = WindowManager.getUniqueName(imp.getTitle());
            imp2 = new ImagePlus(title, img);
        }
        return imp2;
    }
}

