/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.MeasurementsWriter;
import ij.plugin.Straightener;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Properties;

public class Analyzer
implements PlugInFilter,
Measurements {
    private String arg;
    private ImagePlus imp;
    private ResultsTable rt;
    private int measurements;
    private StringBuffer min;
    private StringBuffer max;
    private StringBuffer mean;
    private StringBuffer sd;
    private static final int[] list = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 512, 2048, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 256, 1024, 4096, 0x200000, 0x400000};
    private static final String MEASUREMENTS = "measurements";
    private static final String MARK_WIDTH = "mark.width";
    private static final String PRECISION = "precision";
    private static boolean unsavedMeasurements;
    public static Color darkBlue;
    private static int systemMeasurements;
    public static int markWidth;
    public static int precision;
    private static float[] umeans;
    private static ResultsTable systemRT;
    private static int redirectTarget;
    private static String redirectTitle;
    private static ImagePlus redirectImage;
    static int firstParticle;
    static int lastParticle;
    private static boolean summarized;
    private static boolean switchingModes;
    private static boolean showMin;
    private static boolean showAngle;

    public Analyzer() {
        this.rt = systemRT;
        this.rt.showRowNumbers(true);
        this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
        this.measurements = systemMeasurements;
    }

    public Analyzer(ImagePlus imp) {
        this();
        this.imp = imp;
    }

    public Analyzer(ImagePlus imp, int measurements, ResultsTable rt) {
        this.imp = imp;
        this.measurements = measurements;
        if (rt == null) {
            rt = new ResultsTable();
        }
        rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
        this.rt = rt;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(Analyzer.class);
        if (arg.equals("set")) {
            this.doSetDialog();
            return 4096;
        }
        if (arg.equals("sum")) {
            this.summarize();
            return 4096;
        }
        if (arg.equals("clear")) {
            if (IJ.macroRunning()) {
                unsavedMeasurements = false;
            }
            Analyzer.resetCounter();
            return 4096;
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.measure();
        this.displayResults();
        if ((this.measurements & 0x400000) != 0) {
            this.addToOverlay();
        }
    }

    void addToOverlay() {
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return;
        }
        roi = (Roi)roi.clone();
        if (this.imp.getStackSize() > 1) {
            if (this.imp.isHyperStack() || this.imp.isComposite()) {
                roi.setPosition(0, this.imp.getSlice(), this.imp.getFrame());
            } else {
                roi.setPosition(this.imp.getCurrentSlice());
            }
        }
        if (roi.getName() == null) {
            roi.setName("" + this.rt.size());
        }
        roi.setIgnoreClipRect(true);
        Overlay overlay = this.imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
        }
        if (!overlay.getDrawNames()) {
            overlay.drawNames(true);
        }
        overlay.setLabelColor(Color.white);
        overlay.drawBackgrounds(true);
        overlay.add(roi);
        this.imp.setOverlay(overlay);
        if (roi.getType() == 9 && Toolbar.getToolId() == 1 && Toolbar.getBrushSize() > 0) {
            this.imp.deleteRoi();
        }
    }

    void doSetDialog() {
        boolean notationChanged;
        String[] titles;
        String NONE = "None";
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            titles = new String[]{NONE};
        } else {
            titles = new String[wList.length + 1];
            titles[0] = NONE;
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                titles[i + 1] = imp != null ? imp.getTitle() : "";
            }
        }
        ImagePlus tImp = WindowManager.getImage(redirectTarget);
        String target = tImp != null ? tImp.getTitle() : NONE;
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && macroOptions.indexOf("circularity ") != -1) {
            Macro.setOptions(macroOptions.replaceAll("circularity ", "shape "));
        }
        if (macroOptions != null && macroOptions.indexOf("slice ") != -1) {
            Macro.setOptions(macroOptions.replaceAll("slice ", "stack "));
        }
        GenericDialog gd = new GenericDialog("Set Measurements", IJ.getInstance());
        String[] labels = new String[18];
        boolean[] states = new boolean[18];
        labels[0] = "Area";
        states[0] = (systemMeasurements & 1) != 0;
        labels[1] = "Mean gray value";
        states[1] = (systemMeasurements & 2) != 0;
        labels[2] = "Standard deviation";
        states[2] = (systemMeasurements & 4) != 0;
        labels[3] = "Modal gray value";
        states[3] = (systemMeasurements & 8) != 0;
        labels[4] = "Min & max gray value";
        states[4] = (systemMeasurements & 0x10) != 0;
        labels[5] = "Centroid";
        states[5] = (systemMeasurements & 0x20) != 0;
        labels[6] = "Center of mass";
        states[6] = (systemMeasurements & 0x40) != 0;
        labels[7] = "Perimeter";
        states[7] = (systemMeasurements & 0x80) != 0;
        labels[8] = "Bounding rectangle";
        states[8] = (systemMeasurements & 0x200) != 0;
        labels[9] = "Fit ellipse";
        states[9] = (systemMeasurements & 0x800) != 0;
        labels[10] = "Shape descriptors";
        states[10] = (systemMeasurements & 0x2000) != 0;
        labels[11] = "Feret's diameter";
        states[11] = (systemMeasurements & 0x4000) != 0;
        labels[12] = "Integrated density";
        states[12] = (systemMeasurements & 0x8000) != 0;
        labels[13] = "Median";
        states[13] = (systemMeasurements & 0x10000) != 0;
        labels[14] = "Skewness";
        states[14] = (systemMeasurements & 0x20000) != 0;
        labels[15] = "Kurtosis";
        states[15] = (systemMeasurements & 0x40000) != 0;
        labels[16] = "Area_fraction";
        states[16] = (systemMeasurements & 0x80000) != 0;
        labels[17] = "Stack position";
        states[17] = (systemMeasurements & 0x100000) != 0;
        gd.setInsets(0, 0, 0);
        gd.addCheckboxGroup(10, 2, labels, states);
        labels = new String[5];
        states = new boolean[5];
        labels[0] = "Limit to threshold";
        states[0] = (systemMeasurements & 0x100) != 0;
        labels[1] = "Display label";
        states[1] = (systemMeasurements & 0x400) != 0;
        labels[2] = "Invert Y coordinates";
        states[2] = (systemMeasurements & 0x1000) != 0;
        labels[3] = "Scientific notation";
        states[3] = (systemMeasurements & 0x200000) != 0;
        labels[4] = "Add to overlay";
        states[4] = (systemMeasurements & 0x400000) != 0;
        gd.setInsets(0, 0, 0);
        gd.addCheckboxGroup(3, 2, labels, states);
        gd.setInsets(15, 0, 0);
        gd.addChoice("Redirect to:", titles, target);
        gd.setInsets(5, 0, 0);
        gd.addNumericField("Decimal places (0-9):", precision, 0, 2, "");
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/analyze.html#set");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int oldMeasurements = systemMeasurements;
        this.setOptions(gd);
        int index = gd.getNextChoiceIndex();
        redirectTarget = index == 0 ? 0 : wList[index - 1];
        redirectTitle = titles[index];
        ImagePlus imp = WindowManager.getImage(redirectTarget);
        redirectImage = imp != null && imp.getWindow() == null ? imp : null;
        int prec = (int)gd.getNextNumber();
        if (prec < 0) {
            prec = 0;
        }
        if (prec > 9) {
            prec = 9;
        }
        boolean bl = notationChanged = (oldMeasurements & 0x200000) != (systemMeasurements & 0x200000);
        if (prec != precision || notationChanged) {
            precision = prec;
            this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
            if (this.rt.size() > 0) {
                this.rt.show("Results");
            }
        }
    }

    void setOptions(GenericDialog gd) {
        int oldMeasurements = systemMeasurements;
        int previous = 0;
        boolean b = false;
        for (int i = 0; i < list.length; ++i) {
            b = gd.getNextBoolean();
            previous = list[i];
            if (b) {
                systemMeasurements |= list[i];
                continue;
            }
            systemMeasurements &= ~list[i];
        }
        if ((oldMeasurements & 0xFFFFFEFF & 0xFFDFFFFF) != (systemMeasurements & 0xFFFFFEFF & 0xFFDFFFFF) && IJ.isResultsWindow()) {
            this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
            this.clearSummary();
            this.rt.update(systemMeasurements, this.imp, null);
        }
        if ((systemMeasurements & 0x400) == 0) {
            systemRT.disableRowLabels();
        }
    }

    public void measure() {
        ImageStatistics stats;
        String lastHdr = this.rt.getColumnHeading(35);
        if (!(lastHdr != null && lastHdr.charAt(0) == 'S' || this.reset())) {
            return;
        }
        lastParticle = 0;
        firstParticle = 0;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            this.measurePoint(roi);
            return;
        }
        if (roi != null && roi.isLine()) {
            this.measureLength(roi);
            return;
        }
        if (roi != null && roi.getType() == 8) {
            this.measureAngle(roi);
            return;
        }
        if (Analyzer.isRedirectImage()) {
            stats = this.getRedirectStats(this.measurements, roi);
            if (stats == null) {
                return;
            }
        } else {
            stats = this.imp.getStatistics(this.measurements);
        }
        if (!IJ.isResultsWindow() && IJ.getInstance() != null) {
            this.reset();
        }
        this.saveResults(stats, roi);
    }

    boolean reset() {
        boolean ok = true;
        if (this.rt.size() > 0) {
            ok = Analyzer.resetCounter();
        }
        if (ok && this.rt.getColumnHeading(35) == null) {
            this.rt.setDefaultHeadings();
        }
        return ok;
    }

    public static boolean isRedirectImage() {
        return redirectTarget != 0;
    }

    public static void setRedirectImage(ImagePlus imp) {
        if (imp == null) {
            redirectTarget = 0;
            redirectTitle = null;
            redirectImage = null;
        } else {
            redirectTarget = imp.getID();
            redirectTitle = imp.getTitle();
            if (imp.getWindow() == null) {
                redirectImage = imp;
            }
        }
    }

    private ImagePlus getRedirectImageOrStack(ImagePlus cimp) {
        int depth;
        ImagePlus rimp = Analyzer.getRedirectImage(cimp);
        if (rimp != null && (depth = rimp.getStackSize()) > 1 && depth == cimp.getStackSize() && rimp.getCurrentSlice() != cimp.getCurrentSlice()) {
            rimp.setSlice(cimp.getCurrentSlice());
        }
        return rimp;
    }

    public static ImagePlus getRedirectImage(ImagePlus cimp) {
        ImagePlus rimp = WindowManager.getImage(redirectTarget);
        if (rimp == null) {
            rimp = redirectImage;
        }
        if (rimp == null) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\")\n" + "not found.");
            redirectTarget = 0;
            Macro.abort();
            return null;
        }
        if (rimp.getWidth() != cimp.getWidth() || rimp.getHeight() != cimp.getHeight()) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\") \n" + "is not the same size as the current image.");
            Macro.abort();
            return null;
        }
        return rimp;
    }

    ImageStatistics getRedirectStats(int measurements, Roi roi) {
        ImagePlus redirectImp = this.getRedirectImageOrStack(this.imp);
        if (redirectImp == null) {
            return null;
        }
        ImageProcessor ip = redirectImp.getProcessor();
        if (this.imp.getTitle().equals("mask") && this.imp.getBitDepth() == 8) {
            ip.setMask(this.imp.getProcessor());
            ip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else {
            ip.setRoi(roi);
        }
        return ImageStatistics.getStatistics(ip, measurements, redirectImp.getCalibration());
    }

    void measurePoint(Roi roi) {
        ImagePlus imp2;
        if (this.rt.size() > 0) {
            int index;
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            if ((index = this.rt.getColumnIndex("X")) < 0 || !this.rt.columnExists(index)) {
                this.clearSummary();
                this.rt.update(this.measurements, this.imp, roi);
            }
        }
        FloatPolygon p = roi.getFloatPolygon();
        ImagePlus imagePlus = imp2 = Analyzer.isRedirectImage() ? this.getRedirectImageOrStack(this.imp) : null;
        if (imp2 == null) {
            imp2 = this.imp;
        }
        for (int i = 0; i < p.npoints; ++i) {
            ImageProcessor ip = imp2.getProcessor();
            ip.setRoi((int)p.xpoints[i], (int)p.ypoints[i], 1, 1);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, this.measurements, imp2.getCalibration());
            this.saveResults(stats, new PointRoi(p.xpoints[i], p.ypoints[i]));
            if (i == p.npoints - 1) continue;
            this.displayResults();
        }
    }

    void measureAngle(Roi roi) {
        if (this.rt.size() > 0) {
            int index;
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            if ((index = this.rt.getColumnIndex("Angle")) < 0 || !this.rt.columnExists(index)) {
                this.clearSummary();
                this.rt.update(this.measurements, this.imp, roi);
            }
        }
        ImageProcessor ip = this.imp.getProcessor();
        ip.setRoi(roi.getPolygon());
        ImageStatistics stats = new ImageStatistics();
        this.saveResults(stats, roi);
    }

    /*
     * Enabled aggressive block sorting
     */
    void measureLength(Roi roi) {
        ImageProcessor ip2;
        ImagePlus imp2;
        ImagePlus imagePlus = imp2 = Analyzer.isRedirectImage() ? this.getRedirectImageOrStack(this.imp) : null;
        if (imp2 != null) {
            imp2.setRoi(roi);
        } else {
            imp2 = this.imp;
        }
        if (this.rt.size() > 0) {
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            boolean update = false;
            int index = this.rt.getColumnIndex("Length");
            if (index < 0 || !this.rt.columnExists(index)) {
                update = true;
            }
            if (!(roi.getType() != 5 || (index = this.rt.getColumnIndex("Angle")) >= 0 && this.rt.columnExists(index))) {
                update = true;
            }
            if (update) {
                this.clearSummary();
                this.rt.update(this.measurements, imp2, roi);
            }
        }
        boolean straightLine = roi.getType() == 5;
        int lineWidth = Math.round(roi.getStrokeWidth());
        Rectangle saveR = null;
        if (straightLine && lineWidth > 1) {
            ip2 = imp2.getProcessor();
            saveR = ip2.getRoi();
            ip2.setRoi(roi.getPolygon());
        } else if (lineWidth > 1) {
            if ((this.measurements & 1) == 0 && (this.measurements & 2) == 0) {
                this.saveResults(new ImageStatistics(), roi);
                return;
            }
            ip2 = new Straightener().straightenLine(imp2, lineWidth);
        } else {
            ProfilePlot profile = new ProfilePlot(imp2);
            double[] values = profile.getProfile();
            if (values == null) {
                return;
            }
            ip2 = new FloatProcessor(values.length, 1, values);
        }
        ImageStatistics stats = ImageStatistics.getStatistics(ip2, 31, imp2.getCalibration());
        if (saveR != null) {
            ip2.setRoi(saveR);
        }
        if (roi instanceof Line && (this.measurements & 0x20) != 0) {
            FloatPolygon p = ((Line)roi).getFloatPoints();
            stats.xCentroid = (double)p.xpoints[0] + (double)(p.xpoints[1] - p.xpoints[0]) / 2.0;
            stats.yCentroid = (double)p.ypoints[0] + (double)(p.ypoints[1] - p.ypoints[0]) / 2.0;
            if (imp2 != null) {
                Calibration cal = this.imp.getCalibration();
                stats.xCentroid = cal.getX(stats.xCentroid);
                stats.yCentroid = cal.getY(stats.yCentroid);
            }
        }
        this.saveResults(stats, roi);
    }

    public void saveResults(ImageStatistics stats, Roi roi) {
        if (this.rt.getColumnHeading(35) == null) {
            this.reset();
        }
        this.clearSummary();
        this.incrementCounter();
        int counter = this.rt.getCounter();
        if (counter <= 20 && (stats.umean != 0.0 || counter != 1 || umeans == null || umeans[0] == 0.0f)) {
            if (umeans == null) {
                umeans = new float[20];
            }
            Analyzer.umeans[counter - 1] = (float)stats.umean;
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Label", this.getFileName());
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, stats.area);
        }
        if ((this.measurements & 2) != 0) {
            this.rt.addValue(1, stats.mean);
        }
        if ((this.measurements & 4) != 0) {
            this.rt.addValue(2, stats.stdDev);
        }
        if ((this.measurements & 8) != 0) {
            this.rt.addValue(3, stats.dmode);
        }
        if ((this.measurements & 0x10) != 0) {
            if (showMin) {
                this.rt.addValue(4, stats.min);
            }
            this.rt.addValue(5, stats.max);
        }
        if ((this.measurements & 0x20) != 0) {
            this.rt.addValue(6, stats.xCentroid);
            this.rt.addValue(7, stats.yCentroid);
        }
        if ((this.measurements & 0x40) != 0) {
            this.rt.addValue(8, stats.xCenterOfMass);
            this.rt.addValue(9, stats.yCenterOfMass);
        }
        if ((this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0) {
            double perimeter;
            if (roi != null) {
                perimeter = roi.getLength();
            } else {
                double d = perimeter = this.imp != null ? (double)(this.imp.getWidth() * 2 + this.imp.getHeight() * 2) : 0.0;
            }
            if ((this.measurements & 0x80) != 0) {
                this.rt.addValue(10, perimeter);
            }
            if ((this.measurements & 0x2000) != 0) {
                double circularity;
                double d = circularity = perimeter == 0.0 ? 0.0 : Math.PI * 4 * (stats.area / (perimeter * perimeter));
                if (circularity > 1.0) {
                    circularity = 1.0;
                }
                this.rt.addValue(18, circularity);
                Object ch = null;
                boolean isArea = roi == null || roi.isArea();
                double convexArea = roi != null ? this.getArea(roi.getConvexHull()) : (double)stats.pixelCount;
                this.rt.addValue(33, isArea ? stats.major / stats.minor : 0.0);
                this.rt.addValue(34, isArea ? 4.0 * stats.area / (Math.PI * stats.major * stats.major) : 0.0);
                this.rt.addValue(35, isArea ? (double)stats.pixelCount / convexArea : Double.NaN);
                if (this.rt.size() == 1) {
                    this.rt.setDecimalPlaces(18, precision);
                    this.rt.setDecimalPlaces(33, precision);
                    this.rt.setDecimalPlaces(34, precision);
                    this.rt.setDecimalPlaces(35, precision);
                }
            }
        }
        if ((this.measurements & 0x200) != 0) {
            if (roi != null && roi.isLine()) {
                Calibration cal;
                Rectangle bounds = roi.getBounds();
                double rx = bounds.x;
                double ry = bounds.y;
                double rw = bounds.width;
                double rh = bounds.height;
                Calibration calibration = cal = this.imp != null ? this.imp.getCalibration() : null;
                if (cal != null) {
                    rx = cal.getX(rx);
                    ry = cal.getY(ry);
                    rw *= cal.pixelWidth;
                    rh *= cal.pixelHeight;
                }
                this.rt.addValue(11, rx);
                this.rt.addValue(12, ry);
                this.rt.addValue(13, rw);
                this.rt.addValue(14, rh);
            } else {
                this.rt.addValue(11, stats.roiX);
                this.rt.addValue(12, stats.roiY);
                this.rt.addValue(13, stats.roiWidth);
                this.rt.addValue(14, stats.roiHeight);
            }
        }
        if ((this.measurements & 0x800) != 0) {
            this.rt.addValue(15, stats.major);
            this.rt.addValue(16, stats.minor);
            this.rt.addValue(17, stats.angle);
        }
        if ((this.measurements & 0x4000) != 0) {
            double[] a;
            boolean extras = true;
            double FeretDiameter = Double.NaN;
            double feretAngle = Double.NaN;
            double minFeret = Double.NaN;
            double feretX = Double.NaN;
            double feretY = Double.NaN;
            Roi roi2 = roi;
            if (roi2 == null && this.imp != null) {
                roi2 = new Roi(0, 0, this.imp.getWidth(), this.imp.getHeight());
            }
            if (roi2 != null && (a = roi2.getFeretValues()) != null) {
                FeretDiameter = a[0];
                feretAngle = a[1];
                minFeret = a[2];
                feretX = a[3];
                feretY = a[4];
            }
            this.rt.addValue(19, FeretDiameter);
            this.rt.addValue(29, feretX);
            this.rt.addValue(30, feretY);
            this.rt.addValue(31, feretAngle);
            this.rt.addValue(32, minFeret);
        }
        if ((this.measurements & 0x8000) != 0) {
            this.rt.addValue(20, stats.area * stats.mean);
            this.rt.addValue(25, (double)stats.pixelCount * stats.umean);
        }
        if ((this.measurements & 0x10000) != 0) {
            this.rt.addValue(21, stats.median);
        }
        if ((this.measurements & 0x20000) != 0) {
            this.rt.addValue(22, stats.skewness);
        }
        if ((this.measurements & 0x40000) != 0) {
            this.rt.addValue(23, stats.kurtosis);
        }
        if ((this.measurements & 0x80000) != 0) {
            this.rt.addValue(24, stats.areaFraction);
        }
        if ((this.measurements & 0x100000) != 0) {
            boolean update = false;
            if (this.imp != null && (this.imp.isHyperStack() || this.imp.isComposite())) {
                int[] position = this.imp.convertIndexToPosition(this.imp.getCurrentSlice());
                if (this.imp.getNChannels() > 1) {
                    int index = this.rt.getColumnIndex("Ch");
                    if (index < 0 || !this.rt.columnExists(index)) {
                        update = true;
                    }
                    this.rt.addValue("Ch", (double)position[0]);
                }
                if (this.imp.getNSlices() > 1) {
                    int index = this.rt.getColumnIndex("Slice");
                    if (index < 0 || !this.rt.columnExists(index)) {
                        update = true;
                    }
                    this.rt.addValue("Slice", (double)position[1]);
                }
                if (this.imp.getNFrames() > 1) {
                    int index = this.rt.getColumnIndex("Frame");
                    if (index < 0 || !this.rt.columnExists(index)) {
                        update = true;
                    }
                    this.rt.addValue("Frame", (double)position[2]);
                }
            } else {
                int index = this.rt.getColumnIndex("Slice");
                if (index < 0 || !this.rt.columnExists(index)) {
                    update = true;
                }
                this.rt.addValue("Slice", this.imp != null ? (double)this.imp.getCurrentSlice() : 1.0);
            }
            if (update && this.rt == systemRT && IJ.isResultsWindow()) {
                this.rt.update(this.measurements, this.imp, roi);
            }
        }
        if (roi != null) {
            if (roi.isLine()) {
                this.rt.addValue("Length", roi.getLength());
                if (roi.getType() == 5 && showAngle) {
                    double angle = 0.0;
                    Line l = (Line)roi;
                    angle = roi.getAngle(l.x1, l.y1, l.x2, l.y2);
                    this.rt.addValue("Angle", angle);
                }
            } else if (roi.getType() == 8) {
                double angle = ((PolygonRoi)roi).getAngle();
                if (Prefs.reflexAngle) {
                    angle = 360.0 - angle;
                }
                this.rt.addValue("Angle", angle);
            } else if (roi.getType() == 10) {
                this.savePoints(roi);
            }
        }
    }

    private void clearSummary() {
        if (summarized && this.rt.size() >= 4 && "Max".equals(this.rt.getLabel(this.rt.size() - 1))) {
            for (int i = 0; i < 4; ++i) {
                this.rt.deleteRow(this.rt.size() - 1);
            }
            this.rt.show("Results");
            summarized = false;
        }
    }

    final double getArea(Polygon p) {
        if (p == null) {
            return Double.NaN;
        }
        int carea = 0;
        for (int i = 0; i < p.npoints; ++i) {
            int iminus1 = i - 1;
            if (iminus1 < 0) {
                iminus1 = p.npoints - 1;
            }
            carea += (p.xpoints[i] + p.xpoints[iminus1]) * (p.ypoints[i] - p.ypoints[iminus1]);
        }
        return Math.abs((double)carea / 2.0);
    }

    void savePoints(Roi roi) {
        if (this.imp == null) {
            this.rt.addValue("X", 0.0);
            this.rt.addValue("Y", 0.0);
            if (this.imp.getStackSize() > 1) {
                this.rt.addValue("Slice", 0.0);
            }
            return;
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, 0.0);
        }
        FloatPolygon p = roi.getFloatPolygon();
        ImageProcessor ip = this.imp.getProcessor();
        Calibration cal = this.imp.getCalibration();
        double x = p.xpoints[0];
        double y = p.ypoints[0];
        int ix = (int)x;
        int iy = (int)y;
        double value = ip.getPixelValue(ix, iy);
        if (markWidth > 0 && !Toolbar.getMultiPointMode()) {
            ip.setColor(Toolbar.getForegroundColor());
            ip.setLineWidth(markWidth);
            ip.moveTo(ix, iy);
            ip.lineTo(ix, iy);
            this.imp.updateAndDraw();
            ip.setLineWidth(Line.getWidth());
        }
        this.rt.addValue("X", cal.getX(x));
        this.rt.addValue("Y", cal.getY(y, this.imp.getHeight()));
        if (this.imp.isHyperStack() || this.imp.isComposite()) {
            if (this.imp.getNChannels() > 1) {
                this.rt.addValue("Ch", (double)this.imp.getChannel());
            }
            if (this.imp.getNSlices() > 1) {
                this.rt.addValue("Slice", (double)this.imp.getSlice());
            }
            if (this.imp.getNFrames() > 1) {
                this.rt.addValue("Frame", (double)this.imp.getFrame());
            }
        } else if (this.imp.getStackSize() > 1) {
            this.rt.addValue("Slice", cal.getZ(this.imp.getCurrentSlice()));
        }
        if (this.imp.getProperty("FHT") != null) {
            double center = (double)this.imp.getWidth() / 2.0;
            double r = Math.sqrt((x - center) * (x - center) + ((y = (double)this.imp.getHeight() - y - 1.0) - center) * (y - center));
            if (r < 1.0) {
                r = 1.0;
            }
            double theta = Math.atan2(y - center, x - center);
            if ((theta = theta * 180.0 / Math.PI) < 0.0) {
                theta = 360.0 + theta;
            }
            this.rt.addValue("R", (double)this.imp.getWidth() / r * cal.pixelWidth);
            this.rt.addValue("Theta", theta);
        }
    }

    String getFileName() {
        String s = "";
        if (this.imp != null) {
            String roiName;
            if (redirectTarget != 0) {
                ImagePlus rImp = WindowManager.getImage(redirectTarget);
                if (rImp == null) {
                    rImp = redirectImage;
                }
                if (rImp != null) {
                    s = rImp.getTitle();
                }
            } else {
                s = this.imp.getTitle();
            }
            Roi roi = this.imp.getRoi();
            String string = roiName = roi != null ? roi.getName() : null;
            if (roiName != null && !roiName.contains(".")) {
                if (roiName.length() > 30) {
                    roiName = roiName.substring(0, 27) + "...";
                }
                s = s + ":" + roiName;
            }
            if (this.imp.getStackSize() > 1) {
                ImageStack stack = this.imp.getStack();
                int currentSlice = this.imp.getCurrentSlice();
                String label = stack.getShortSliceLabel(currentSlice);
                String colon = s.equals("") ? "" : ":";
                s = label != null && !label.equals("") ? s + colon + label : s + colon + currentSlice;
            }
        }
        return s;
    }

    public void displayResults() {
        int lineCount;
        int counter = this.rt.getCounter();
        if (counter == 1) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        TextPanel tp = IJ.isResultsWindow() ? IJ.getTextPanel() : null;
        int n = lineCount = tp != null ? IJ.getTextPanel().getLineCount() : 0;
        if (counter > lineCount + 1) {
            int n2 = counter - lineCount - 1;
            int index = lineCount;
            for (int i = 0; i < n2; ++i) {
                this.rt.deleteRow(index);
            }
            counter = this.rt.getCounter();
        }
        IJ.write(this.rt.getRowAsString(counter - 1));
    }

    public void updateHeadings() {
        this.rt.show("Results");
    }

    public String n(double n) {
        String s = (double)Math.round(n) == n ? ResultsTable.d2s(n, 0) : ResultsTable.d2s(n, precision);
        return s + "\t";
    }

    void incrementCounter() {
        if (this.rt == null) {
            this.rt = systemRT;
        }
        this.rt.incrementCounter();
        unsavedMeasurements = true;
    }

    public void summarize() {
        if (summarized) {
            return;
        }
        int n = this.rt.size();
        if (n < 2) {
            return;
        }
        String[] headings = this.rt.getHeadings();
        int columns = headings.length;
        if (columns == 0) {
            return;
        }
        int first = "Label".equals(headings[0]) ? 1 : 0;
        double[] min = new double[columns];
        double[] max = new double[columns];
        double[] sum = new double[columns];
        double[] sum2 = new double[columns];
        for (int i = 0; i < columns; ++i) {
            min[i] = Double.MAX_VALUE;
            max[i] = -1.7976931348623157E308;
        }
        for (int row = 0; row < n; ++row) {
            int col = first;
            while (col < columns) {
                double v = this.rt.getValue(headings[col], row);
                if (v < min[col]) {
                    min[col] = v;
                }
                if (v > max[col]) {
                    max[col] = v;
                }
                int n2 = col;
                sum[n2] = sum[n2] + v;
                int n3 = col++;
                sum2[n3] = sum2[n3] + v * v;
            }
        }
        this.rt.incrementCounter();
        this.rt.setLabel("Mean", n + 0);
        this.rt.incrementCounter();
        this.rt.setLabel("SD", n + 1);
        this.rt.incrementCounter();
        this.rt.setLabel("Min", n + 2);
        this.rt.incrementCounter();
        this.rt.setLabel("Max", n + 3);
        for (int col = first; col < columns; ++col) {
            this.rt.setValue(headings[col], n + 0, sum[col] / (double)n);
            this.rt.setValue(headings[col], n + 1, Math.sqrt((sum2[col] - sum[col] * sum[col] / (double)n) / (double)(n - 1)));
            this.rt.setValue(headings[col], n + 2, min[col]);
            this.rt.setValue(headings[col], n + 3, max[col]);
        }
        this.rt.show("Results");
        summarized = true;
    }

    public static int getCounter() {
        return systemRT.size();
    }

    public static synchronized boolean resetCounter() {
        TextPanel tp = IJ.isResultsWindow() ? IJ.getTextPanel() : null;
        int counter = systemRT.getCounter();
        int lineCount = tp != null ? IJ.getTextPanel().getLineCount() : 0;
        ImageJ ij = IJ.getInstance();
        boolean macro = IJ.macroRunning() && !switchingModes || Interpreter.isBatchMode();
        switchingModes = false;
        if (counter > 0 && lineCount > 0 && unsavedMeasurements && !macro && ij != null && !ij.quitting()) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)ij, "ImageJ", "Save " + counter + " measurements?");
            if (d.cancelPressed()) {
                return false;
            }
            if (d.yesPressed() && !new MeasurementsWriter().save("")) {
                return false;
            }
        }
        umeans = null;
        systemRT.reset();
        unsavedMeasurements = false;
        if (tp != null) {
            tp.clear();
        }
        summarized = false;
        return true;
    }

    public static void setUnsavedMeasurements(boolean b) {
        unsavedMeasurements = b;
    }

    public static int getMeasurements() {
        return systemMeasurements;
    }

    public static void setMeasurements(int measurements) {
        systemMeasurements = measurements;
    }

    public static void setMeasurement(int option, boolean state) {
        systemMeasurements = state ? (systemMeasurements |= option) : (systemMeasurements &= ~option);
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(MEASUREMENTS, Integer.toString(systemMeasurements));
        prefs.put(PRECISION, Integer.toString(precision));
    }

    public static float[] getUMeans() {
        return umeans;
    }

    public static ResultsTable getResultsTable() {
        return systemRT;
    }

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int decimalPlaces) {
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (decimalPlaces > 9) {
            decimalPlaces = 9;
        }
        precision = decimalPlaces;
    }

    public static int updateY(int y, int imageHeight) {
        if ((systemMeasurements & 0x1000) != 0) {
            y = imageHeight - y - 1;
        }
        return y;
    }

    public static double updateY(double y, int imageHeight) {
        if ((systemMeasurements & 0x1000) != 0) {
            y = (double)imageHeight - y - 1.0;
        }
        return y;
    }

    public static void setDefaultHeadings() {
        systemRT.setDefaultHeadings();
    }

    public static void setOption(String option, boolean b) {
        if (option.contains("min")) {
            showMin = b;
        } else if (option.contains("angle")) {
            showAngle = b;
        }
    }

    public static void setResultsTable(ResultsTable rt) {
        TextPanel tp;
        TextPanel textPanel = tp = IJ.isResultsWindow() ? IJ.getTextPanel() : null;
        if (tp != null) {
            tp.clear();
        }
        if (rt == null) {
            rt = new ResultsTable();
        }
        rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
        systemRT = rt;
        summarized = false;
        umeans = null;
        unsavedMeasurements = false;
    }

    static {
        darkBlue = new Color(0, 0, 160);
        systemMeasurements = Prefs.getInt(MEASUREMENTS, 19);
        precision = Prefs.getInt(PRECISION, 3);
        umeans = new float[20];
        systemRT = new ResultsTable();
        redirectTitle = "";
        showMin = true;
        showAngle = true;
    }
}

