/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.measure.CurveFitter;
import ij.plugin.Colors;
import ij.plugin.NewPlugin;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.PlugInFrame;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.StringTokenizer;

public class Recorder
extends PlugInFrame
implements PlugIn,
ActionListener,
ImageListener,
ItemListener {
    public static boolean record;
    public static boolean recordInMacros;
    private static final int MACRO = 0;
    private static final int JAVASCRIPT = 1;
    private static final int BEANSHELL = 2;
    private static final int JAVA = 3;
    private static final String[] modes;
    private Choice mode;
    private Button makeMacro;
    private Button help;
    private TextField fileName;
    private String fitTypeStr = CurveFitter.fitList[0];
    private static TextArea textArea;
    private static Recorder instance;
    private static String commandName;
    private static String commandOptions;
    private static String defaultName;
    private static boolean recordPath;
    private static boolean scriptMode;
    private static boolean imageUpdated;
    private static int imageID;
    private static boolean fgColorSet;
    private static boolean bgColorSet;
    private static boolean bbSet;

    public Recorder() {
        this(true);
    }

    public Recorder(boolean showFrame) {
        super("Recorder");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        record = true;
        scriptMode = false;
        recordInMacros = false;
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        panel.add(new Label("  Record:"));
        this.mode = new Choice();
        for (int i = 0; i < modes.length; ++i) {
            this.mode.addItem(modes[i]);
        }
        this.mode.addItemListener(this);
        String m = Prefs.get("recorder.mode", modes[0]);
        if (m.equals("Plugin")) {
            m = modes[3];
        }
        this.mode.select(m);
        panel.add(this.mode);
        panel.add(new Label("    Name:"));
        this.fileName = new TextField(defaultName, 15);
        this.setFileName();
        panel.add(this.fileName);
        panel.add(new Label("   "));
        this.makeMacro = new Button("Create");
        this.makeMacro.addActionListener(this);
        panel.add(this.makeMacro);
        panel.add(new Label("   "));
        this.help = new Button("?");
        this.help.addActionListener(this);
        panel.add(this.help);
        this.add("North", panel);
        textArea = new TextArea("", 15, 80, 1);
        textArea.setFont(new Font("Monospaced", 0, 12));
        if (IJ.isLinux()) {
            textArea.setBackground(Color.white);
        }
        this.add("Center", textArea);
        this.pack();
        GUI.center(this);
        if (showFrame) {
            this.show();
        }
        IJ.register(Recorder.class);
        bgColorSet = false;
        fgColorSet = false;
        bbSet = false;
    }

    public static void record(String method) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "();\n");
    }

    public static void setCommand(String command) {
        boolean isMacro = Thread.currentThread().getName().startsWith("Run$_");
        if (textArea == null || isMacro && !recordInMacros) {
            return;
        }
        commandName = command;
        commandOptions = null;
        recordPath = true;
        imageUpdated = false;
        imageID = 0;
        if (scriptMode) {
            ImagePlus imp = WindowManager.getCurrentImage();
            int n = imageID = imp != null ? imp.getID() : 0;
            if (imageID != 0) {
                ImagePlus.addImageListener(instance);
            }
        }
    }

    public static String getCommand() {
        return commandName;
    }

    static String fixPath(String path) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            sb.append(c);
            if (c != '\\') continue;
            sb.append("\\");
        }
        return new String(sb);
    }

    public static void record(String method, String arg) {
        if (IJ.debugMode) {
            IJ.log("record: " + method + "  " + arg);
        }
        boolean sw = method.equals("selectWindow");
        if (!(textArea == null || scriptMode && sw || commandName != null && sw)) {
            if (scriptMode && method.equals("roiManager")) {
                textArea.append("rm.runCommand(\"" + arg + "\");\n");
            } else if (scriptMode && method.equals("run")) {
                textArea.append("IJ." + method + "(\"" + arg + "\");\n");
            } else {
                if (method.equals("setTool")) {
                    method = "//" + (scriptMode ? "IJ." : "") + method;
                }
                textArea.append(method + "(\"" + arg + "\");\n");
            }
        }
    }

    public static void record(String method, String arg1, String arg2) {
        if (textArea == null) {
            return;
        }
        if (arg1.equals("Open") || arg1.equals("Save") || method.equals("saveAs")) {
            arg2 = Recorder.fixPath(arg2);
        }
        if (scriptMode && method.equals("roiManager")) {
            textArea.append("rm.runCommand(\"" + arg1 + "\", \"" + arg2 + "\");\n");
        } else {
            if (scriptMode && method.equals("saveAs")) {
                method = "IJ." + method;
            }
            textArea.append(method + "(\"" + arg1 + "\", \"" + arg2 + "\");\n");
        }
    }

    public static void record(String method, String arg1, String arg2, String arg3) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(\"" + arg1 + "\", \"" + arg2 + "\",\"" + arg3 + "\");\n");
    }

    public static void record(String method, int a1) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(" + a1 + ");\n");
    }

    public static void record(String method, int a1, int a2) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(" + a1 + ", " + a2 + ");\n");
    }

    public static void record(String method, double a1, double a2) {
        if (textArea == null) {
            return;
        }
        int places = Math.abs(a1) < 1.0E-4 || Math.abs(a2) < 1.0E-4 ? 9 : 4;
        textArea.append(method + "(" + IJ.d2s(a1, places) + ", " + IJ.d2s(a2, places) + ");\n");
    }

    public static void record(String method, int a1, int a2, int a3) {
        if (textArea == null) {
            return;
        }
        if (scriptMode && method.endsWith("groundColor")) {
            method = "IJ." + method;
        }
        textArea.append(method + "(" + a1 + ", " + a2 + ", " + a3 + ");\n");
    }

    public static void record(String method, String a1, int a2) {
        textArea.append(method + "(\"" + a1 + "\", " + a2 + ");\n");
    }

    public static void record(String method, String args, int a1, int a2) {
        if (textArea == null) {
            return;
        }
        textArea.append(method + "(\"" + args + "\", " + a1 + ", " + a2 + ");\n");
    }

    public static void record(String method, int a1, int a2, int a3, int a4) {
        if (textArea == null) {
            return;
        }
        if (scriptMode && method.startsWith("make")) {
            if (method.equals("makeRectangle")) {
                Recorder.recordString("imp.setRoi(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ");\n");
            } else if (method.equals("makeOval")) {
                Recorder.recordString("imp.setRoi(new OvalRoi(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + "));\n");
            } else if (method.equals("makeLine")) {
                Recorder.recordString("imp.setRoi(new Line(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + "));\n");
            } else if (method.equals("makeArrow")) {
                Recorder.recordString("imp.setRoi(new Arrow(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + "));\n");
            }
        } else {
            if (method.equals("makeArrow")) {
                Roi roi;
                ImagePlus imp = WindowManager.getCurrentImage();
                Roi roi2 = roi = imp != null ? imp.getRoi() : null;
                if (roi != null && roi instanceof Line) {
                    Color color;
                    Arrow arrow = (Arrow)roi;
                    String options = Arrow.styles[arrow.getStyle()];
                    if (arrow.getOutline()) {
                        options = options + " outline";
                    }
                    if (arrow.getDoubleHeaded()) {
                        options = options + " double";
                    }
                    if (arrow.getHeadSize() <= 5.0) {
                        options = options + " small";
                    } else if (arrow.getHeadSize() >= 15.0) {
                        options = options + " large";
                    }
                    options = options.toLowerCase();
                    int strokeWidth = (int)arrow.getStrokeWidth();
                    textArea.append(method + "(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ", \"" + options + "\");\n");
                    if (strokeWidth != 1) {
                        textArea.append("Roi.setStrokeWidth(" + strokeWidth + ");\n");
                    }
                    if ((color = arrow.getStrokeColor()) != null) {
                        textArea.append("Roi.setStrokeColor(\"" + Colors.colorToString(color) + "\");\n");
                    }
                    return;
                }
            }
            textArea.append(method + "(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ");\n");
        }
    }

    public static void record(String method, int a1, int a2, int a3, int a4, int a5) {
        textArea.append(method + "(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ", " + a5 + ");\n");
    }

    public static void record(String method, int a1, int a2, int a3, int a4, double a5) {
        textArea.append(method + "(" + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ", " + IJ.d2s(a5, 2) + ");\n");
    }

    public static void record(String method, String path, String args, int a1, int a2, int a3, int a4, int a5) {
        if (textArea == null) {
            return;
        }
        path = Recorder.fixPath(path);
        method = "//" + method;
        textArea.append(method + "(\"" + path + "\", " + "\"" + args + "\", " + a1 + ", " + a2 + ", " + a3 + ", " + a4 + ", " + a5 + ");\n");
    }

    public static void recordString(String str) {
        if (textArea != null) {
            textArea.append(str);
        }
    }

    public static void recordCall(String call) {
        boolean isMacro;
        if (IJ.debugMode) {
            IJ.log("recordCall: " + call + "  " + commandName);
        }
        boolean bl = isMacro = Thread.currentThread().getName().endsWith("Macro$") && !recordInMacros;
        if (textArea != null && scriptMode && !IJ.macroRunning() && !isMacro) {
            if (Recorder.javaMode() && call.startsWith("rm.setSelected")) {
                call = call.replace("[", "new int[]{");
                call = call.replace("])", "})");
            }
            if (Recorder.javaMode() && call.startsWith("rt = ")) {
                call = "ResultTable " + call;
            }
            textArea.append(call + "\n");
            commandName = null;
        }
    }

    public static void recordCall(String className, String call) {
        Recorder.recordCall(Recorder.javaMode() ? className + " " + call : call);
    }

    public static void recordRoi(Polygon p, int type) {
        if (textArea == null) {
            return;
        }
        if (scriptMode) {
            Recorder.recordScriptRoi(p, type);
            return;
        }
        if (type == 8 || type == 10) {
            String xarr = "newArray(";
            String yarr = "newArray(";
            xarr = xarr + p.xpoints[0] + ",";
            yarr = yarr + p.ypoints[0] + ",";
            xarr = xarr + p.xpoints[1] + ",";
            yarr = yarr + p.ypoints[1] + ",";
            xarr = xarr + p.xpoints[2] + ")";
            yarr = yarr + p.ypoints[2] + ")";
            String typeStr = type == 8 ? "angle" : "point";
            textArea.append("makeSelection(\"" + typeStr + "\"," + xarr + "," + yarr + ");\n");
        } else {
            String method = type == 2 ? "makePolygon" : "makeLine";
            StringBuffer args = new StringBuffer();
            for (int i = 0; i < p.npoints; ++i) {
                args.append(p.xpoints[i] + ",");
                args.append("" + p.ypoints[i]);
                if (i == p.npoints - 1) continue;
                args.append(",");
            }
            textArea.append(method + "(" + args.toString() + ");\n");
        }
    }

    public static void recordScriptRoi(Polygon p, int type) {
        StringBuffer x = new StringBuffer();
        for (int i = 0; i < p.npoints; ++i) {
            x.append(p.xpoints[i]);
            if (i == p.npoints - 1) continue;
            x.append(",");
        }
        String xpoints = x.toString();
        StringBuffer y = new StringBuffer();
        for (int i = 0; i < p.npoints; ++i) {
            y.append(p.ypoints[i]);
            if (i == p.npoints - 1) continue;
            y.append(",");
        }
        String ypoints = y.toString();
        if (Recorder.javaMode()) {
            textArea.append("int[] xpoints = {" + xpoints + "};\n");
            textArea.append("int[] ypoints = {" + ypoints + "};\n");
        } else {
            textArea.append("xpoints = [" + xpoints + "];\n");
            textArea.append("ypoints = [" + ypoints + "];\n");
        }
        String typeStr = "POLYGON";
        switch (type) {
            case 6: {
                typeStr = "POLYLINE";
                break;
            }
            case 8: {
                typeStr = "ANGLE";
            }
        }
        typeStr = "Roi." + typeStr;
        if (Recorder.javaMode()) {
            if (type == 10) {
                textArea.append("imp.setRoi(new PointRoi(xpoints,ypoints," + p.npoints + "));\n");
            } else {
                textArea.append("imp.setRoi(new PolygonRoi(xpoints,ypoints," + p.npoints + "," + typeStr + "));\n");
            }
        } else if (type == 10) {
            textArea.append("imp.setRoi(new PointRoi(xpoints,ypoints));\n");
        } else {
            textArea.append("imp.setRoi(new PolygonRoi(xpoints,ypoints," + typeStr + "));\n");
        }
    }

    private static boolean javaMode() {
        if (instance == null) {
            return false;
        }
        String m = Recorder.instance.mode.getSelectedItem();
        return m.equals(modes[2]) || m.equals(modes[3]);
    }

    public static void recordOption(String key, String value) {
        if (key == null) {
            return;
        }
        key = Recorder.trimKey(key);
        value = Recorder.addQuotes(value);
        Recorder.checkForDuplicate(key + "=", value);
        commandOptions = commandOptions == null ? key + "=" + value : commandOptions + " " + key + "=" + value;
    }

    public static void recordPath(String key, String path) {
        if (key == null || !recordPath) {
            recordPath = true;
            return;
        }
        key = Recorder.trimKey(key);
        path = Recorder.fixPath(path);
        path = Recorder.addQuotes(path);
        if (commandOptions != null && commandOptions.contains(key + "=" + path)) {
            return;
        }
        Recorder.checkForDuplicate(key + "=", path);
        commandOptions = commandOptions == null || commandOptions == " " ? key + "=" + path : commandOptions + " " + key + "=" + path;
    }

    public static void recordOption(String key) {
        if (key == null) {
            return;
        }
        if (commandOptions == null && key.equals(" ")) {
            commandOptions = " ";
        } else {
            key = Recorder.trimKey(key);
            Recorder.checkForDuplicate(" " + key, "");
            commandOptions = commandOptions == null || commandOptions == " " ? key : commandOptions + " " + key;
        }
    }

    static void checkForDuplicate(String key, String value) {
        if (commandOptions != null && commandName != null && commandOptions.indexOf(key) != -1 && (value.equals("") || commandOptions.indexOf(value) == -1)) {
            if (key.endsWith("=")) {
                key = key.substring(0, key.length() - 1);
            }
            IJ.showMessage("Recorder", "Duplicate keyword:\n \n    Command: \"" + commandName + "\"\n" + "    Keyword: " + "\"" + key + "\"\n" + "    Value: " + value + "\n \n" + "Add an underscore to the corresponding label\n" + "in the dialog to make the first word unique.");
        }
    }

    static String trimKey(String key) {
        int index = key.indexOf(" ");
        if (index > -1) {
            key = key.substring(0, index);
        }
        if ((index = key.indexOf(":")) > -1) {
            key = key.substring(0, index);
        }
        key = key.toLowerCase(Locale.US);
        return key;
    }

    public static void saveCommand() {
        String name = commandName;
        if (name != null) {
            if (commandOptions == null && (name.equals("Fill") || name.equals("Clear"))) {
                commandOptions = "slice";
            }
            if (!fgColorSet && (name.equals("Fill") || name.equals("Draw"))) {
                Recorder.setForegroundColor(Toolbar.getForegroundColor());
            } else if (!bgColorSet && (name.equals("Clear") || name.equals("Clear Outside"))) {
                Recorder.setBackgroundColor(Toolbar.getBackgroundColor());
            }
            if (!bbSet && (name.equals("Make Binary") || name.equals("Convert to Mask") || name.equals("Erode") || name.equals("Dilate") || name.equals("Skeletonize"))) {
                Recorder.setBlackBackground();
            }
            if (commandOptions != null) {
                if (name.equals("Open...") || name.equals("URL...")) {
                    String s;
                    String string = s = scriptMode ? "imp = IJ.openImage" : "open";
                    if (scriptMode && Recorder.isTextOrTable(commandOptions)) {
                        s = "IJ.open";
                    }
                    textArea.append(s + "(\"" + Recorder.strip(commandOptions) + "\");\n");
                } else if (Recorder.isSaveAs()) {
                    if (name.endsWith("...")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    String path = Recorder.strip(commandOptions);
                    String s = scriptMode ? "IJ.saveAs(imp, " : "saveAs(";
                    textArea.append(s + "\"" + name + "\", \"" + path + "\");\n");
                } else if (name.equals("Image...")) {
                    Recorder.appendNewImage(false);
                } else if (name.equals("Hyperstack...") || name.equals("New Hyperstack...")) {
                    Recorder.appendNewImage(true);
                } else if (name.equals("Set Slice...")) {
                    textArea.append((scriptMode ? "imp." : "") + "setSlice(" + Recorder.strip(commandOptions) + ");\n");
                } else if (name.equals("Rename...")) {
                    textArea.append((scriptMode ? "imp.setTitle" : "rename") + "(\"" + Recorder.strip(commandOptions) + "\");\n");
                } else if (name.equals("Wand Tool...")) {
                    textArea.append("//run(\"" + name + "\", \"" + commandOptions + "\");\n");
                } else if (name.equals("Results... ") && commandOptions.indexOf(".txt") == -1) {
                    textArea.append((scriptMode ? "IJ." : "") + "open(\"" + Recorder.strip(commandOptions) + "\");\n");
                } else if (!name.equals("Results...") && !name.equals("Run...")) {
                    String prefix = "run(";
                    if (scriptMode) {
                        boolean addImp;
                        boolean bl = addImp = imageUpdated || WindowManager.getCurrentImage() != null && (name.equals("Properties... ") || name.equals("Fit Spline") || commandOptions.contains("save="));
                        if (commandOptions.contains("open=")) {
                            addImp = false;
                        }
                        prefix = addImp ? "IJ.run(imp, " : "IJ.run(";
                    }
                    textArea.append(prefix + "\"" + name + "\", \"" + commandOptions + "\");\n");
                    if (Recorder.nonAscii(commandOptions)) {
                        textArea.append("  <<warning: the options string contains one or more non-ascii characters>>\n");
                    }
                }
            } else {
                Roi roi;
                ImagePlus imp = WindowManager.getCurrentImage();
                Roi roi2 = roi = imp != null ? imp.getRoi() : null;
                if (name.equals("Threshold...") || name.equals("Fonts...") || name.equals("Brightness/Contrast...")) {
                    textArea.append((scriptMode ? "//IJ." : "//") + "run(\"" + name + "\");\n");
                } else if (name.equals("Start Animation [\\]")) {
                    textArea.append("doCommand(\"Start Animation [\\\\]\");\n");
                } else if (!name.equals("Add to Manager")) {
                    if (roi != null && roi instanceof TextRoi && (name.equals("Draw") || name.equals("Add Selection..."))) {
                        textArea.append(((TextRoi)roi).getMacroCode(name, imp));
                    } else {
                        if (IJ.altKeyDown() && (name.equals("Open Next") || name.equals("Plot Profile"))) {
                            textArea.append("setKeyDown(\"alt\"); ");
                        }
                        if (scriptMode) {
                            boolean addImp = imageUpdated || imp != null && (name.equals("Select None") || name.equals("Draw") || name.equals("Fit Spline") || name.equals("Add Selection..."));
                            String prefix = addImp ? "IJ.run(imp, " : "IJ.run(";
                            textArea.append(prefix + "\"" + name + "\", \"\");\n");
                        } else {
                            textArea.append("run(\"" + name + "\");\n");
                        }
                    }
                }
            }
        }
        commandName = null;
        commandOptions = null;
        if (imageID != 0) {
            ImagePlus.removeImageListener(instance);
            imageID = 0;
        }
    }

    private static boolean nonAscii(String s) {
        int len = s != null ? s.length() : 0;
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    static boolean isTextOrTable(String path) {
        return path.endsWith(".txt") || path.endsWith(".csv") || path.endsWith(".xls");
    }

    static boolean isSaveAs() {
        return commandName.equals("Tiff...") || commandName.equals("Gif...") || commandName.equals("Jpeg...") || commandName.equals("Text Image...") || commandName.equals("ZIP...") || commandName.equals("Raw Data...") || commandName.equals("BMP...") || commandName.equals("PNG...") || commandName.equals("PGM...") || commandName.equals("FITS...") || commandName.equals("LUT...") || commandName.equals("Selection...") || commandName.equals("XY Coordinates...") || commandName.equals("Text... ");
    }

    static void appendNewImage(boolean hyperstack) {
        String options = Recorder.getCommandOptions() + " ";
        String title = Macro.getValue(options, "name", "Untitled");
        String type = Macro.getValue(options, "type", "8-bit");
        String fill = Macro.getValue(options, "fill", "");
        if (!fill.equals("")) {
            type = type + " " + fill.toLowerCase();
        }
        if (hyperstack) {
            String mode = Macro.getValue(options, "display", "");
            if (!mode.equals("")) {
                type = type + " " + mode.toLowerCase() + "-mode";
            }
            if (options.contains(" label")) {
                type = type + " label";
            }
        }
        int width = (int)Tools.parseDouble(Macro.getValue(options, "width", "512"));
        int height = (int)Tools.parseDouble(Macro.getValue(options, "height", "512"));
        String d1 = ", " + (int)Tools.parseDouble(Macro.getValue(options, "slices", "1"));
        String d2 = "";
        String d3 = "";
        if (hyperstack) {
            d1 = ", " + (int)Tools.parseDouble(Macro.getValue(options, "channels", "1"));
            d2 = ", " + (int)Tools.parseDouble(Macro.getValue(options, "slices", "1"));
            d3 = ", " + (int)Tools.parseDouble(Macro.getValue(options, "frames", "1"));
        }
        textArea.append((scriptMode ? "imp = IJ.createImage" : "newImage") + "(\"" + title + "\", " + "\"" + type + "\", " + width + ", " + height + d1 + d2 + d3 + ");\n");
    }

    static String strip(String value) {
        int index = value.indexOf(61);
        if (index >= 0) {
            value = value.substring(index + 1);
        }
        if (value.startsWith("[")) {
            int index2 = value.indexOf(93);
            if (index2 == -1) {
                index2 = value.length();
            }
            value = value.substring(1, index2);
        } else {
            index = value.indexOf(32);
            if (index != -1) {
                value = value.substring(0, index);
            }
        }
        return value;
    }

    static String addQuotes(String value) {
        int index = value.indexOf(32);
        if (index > -1) {
            value = "[" + value + "]";
        }
        return value;
    }

    public static String getCommandOptions() {
        return commandOptions;
    }

    void createMacro() {
        String text = textArea.getText();
        if (text == null || text.equals("")) {
            IJ.showMessage("Recorder", "A macro cannot be created until at least\none command has been recorded.");
            return;
        }
        Editor ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (ed == null) {
            return;
        }
        boolean java = this.mode.getSelectedItem().equals(modes[3]);
        boolean beanshell = this.mode.getSelectedItem().equals(modes[2]);
        String name = this.fileName.getText();
        int dotIndex = name.lastIndexOf(".");
        if (scriptMode) {
            if (dotIndex >= 0) {
                name = name.substring(0, dotIndex);
            }
            if (text.indexOf("rm.") != -1) {
                text = (java ? "RoiManager " : "") + "rm = RoiManager.getInstance();\n" + "if (rm==null) rm = new RoiManager();\n" + text;
            }
            if (text.contains("overlay.add")) {
                text = (java ? "Overlay " : "") + "overlay = new Overlay();\n" + text;
            }
            if ((text.contains("imp.") || text.contains("(imp") || text.contains("overlay.add")) && !text.contains("IJ.openImage") && !text.contains("IJ.createImage")) {
                text = (java ? "ImagePlus " : "") + "imp = IJ.getImage();\n" + text;
            }
            if (text.contains("overlay.add")) {
                text = text + "imp.setOverlay(overlay);\n";
            }
            if (text.indexOf("imp =") != -1 && text.indexOf("IJ.getImage") == -1 && text.indexOf("IJ.saveAs") == -1 && text.indexOf("imp.close") == -1) {
                text = text + "imp.show();\n";
            }
            if (java) {
                name = name + ".java";
                this.createPlugin(text, name);
                return;
            }
            name = beanshell ? name + ".bsh" : name + ".js";
        } else if (!name.endsWith(".txt")) {
            if (dotIndex >= 0) {
                name = name.substring(0, dotIndex);
            }
            name = name + ".ijm";
        }
        ed.createMacro(name, text);
        bgColorSet = false;
        fgColorSet = false;
        bbSet = false;
    }

    void createPlugin(String text, String name) {
        StringTokenizer st = new StringTokenizer(text, "\n");
        int n = st.countTokens();
        boolean impDeclared = false;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String line = st.nextToken();
            if (line == null || line.length() <= 3) continue;
            sb.append("\t\t");
            if (line.startsWith("imp =") && !impDeclared) {
                sb.append("ImagePlus ");
                impDeclared = true;
            }
            sb.append(line);
            sb.append('\n');
        }
        String text2 = new String(sb);
        text2 = text2.replaceAll("print", "IJ.log");
        NewPlugin np = (NewPlugin)IJ.runPlugIn("ij.plugin.NewPlugin", text2);
        Editor ed = np.getEditor();
        ed.updateClassName(ed.getTitle(), name);
        ed.setTitle(name);
    }

    public static void disablePathRecording() {
        recordPath = false;
    }

    public static boolean scriptMode() {
        return scriptMode;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.makeMacro) {
            this.createMacro();
        } else if (e.getSource() == this.help) {
            this.showHelp();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.setFileName();
        Prefs.set("recorder.mode", this.mode.getSelectedItem());
    }

    void setFileName() {
        String name = this.mode.getSelectedItem();
        boolean bl = scriptMode = !name.equals(modes[0]);
        if (name.equals(modes[0])) {
            this.fileName.setText("Macro.ijm");
        } else if (name.equals(modes[1])) {
            this.fileName.setText("Script.js");
        } else if (name.equals(modes[2])) {
            this.fileName.setText("Script.bsh");
        } else {
            this.fileName.setText("My_Plugin.java");
        }
        bgColorSet = false;
        fgColorSet = false;
        bbSet = false;
    }

    public void imageUpdated(ImagePlus imp) {
        if (imp.getID() == imageID) {
            imageUpdated = true;
        }
    }

    public void imageOpened(ImagePlus imp) {
    }

    public void imageClosed(ImagePlus imp) {
    }

    void showHelp() {
        IJ.showMessage("Recorder", "Click \"Create\" to open recorded commands\nas a macro in an editor window.\n \nIn the editor:\n \n    Type ctrl+R (Macros>Run Macro) to\n    run the macro.\n \n    Use File>Save As to save it and\n    ImageJ's Open command to open it.\n \n    To create a command, save in the plugins\n    folder and run Help>Refresh Menus.\n");
    }

    public void close() {
        super.close();
        record = false;
        textArea = null;
        commandName = null;
        instance = null;
    }

    public String getText() {
        if (textArea == null) {
            return "";
        }
        return textArea.getText();
    }

    public static Recorder getInstance() {
        return instance;
    }

    public static void setForegroundColor(Color c) {
        Recorder.record("setForegroundColor", c.getRed(), c.getGreen(), c.getBlue());
        fgColorSet = true;
    }

    public static void setBackgroundColor(Color c) {
        Recorder.record("setBackgroundColor", c.getRed(), c.getGreen(), c.getBlue());
        bgColorSet = true;
    }

    public static void setBlackBackground() {
        String bb;
        String string = bb = Prefs.blackBackground ? "true" : "false";
        if (scriptMode) {
            Recorder.recordString("Prefs.blackBackground = " + bb + ";\n");
        } else {
            Recorder.recordString("setOption(\"BlackBackground\", " + bb + ");\n");
        }
        bbSet = true;
    }

    static {
        modes = new String[]{"Macro", "JavaScript", "BeanShell", "Java"};
        defaultName = "Macro.ijm";
        recordPath = true;
    }
}

