/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorBlitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ColorProcessor
extends ImageProcessor {
    protected int[] pixels;
    protected int[] snapshotPixels = null;
    private int bgColor = -1;
    private int min = 0;
    private int max = 255;
    private WritableRaster rgbRaster;
    private SampleModel rgbSampleModel;
    private static double rWeight = 0.3333333333333333;
    private static double gWeight = 0.3333333333333333;
    private static double bWeight = 0.3333333333333333;
    private double[] weights;
    public static final int RGB_NOISE = 0;
    public static final int RGB_MEDIAN = 1;
    public static final int RGB_FIND_EDGES = 2;
    public static final int RGB_ERODE = 3;
    public static final int RGB_DILATE = 4;
    public static final int RGB_THRESHOLD = 5;
    public static final int RGB_ROTATE = 6;
    public static final int RGB_SCALE = 7;
    public static final int RGB_RESIZE = 8;
    public static final int RGB_TRANSLATE = 9;

    public ColorProcessor(Image img) {
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        this.pixels = new int[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
    }

    public ColorProcessor(int width, int height) {
        this(width, height, new int[width * height]);
    }

    public ColorProcessor(int width, int height, int[] pixels) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = width;
        this.height = height;
        this.createColorModel();
        this.fgColor = -16777216;
        this.resetRoi();
        this.pixels = pixels;
    }

    void createColorModel() {
        this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }

    public Image createImage() {
        if (IJ.isJava16()) {
            return this.createBufferedImage();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    Image createBufferedImage() {
        if (this.rgbSampleModel == null) {
            this.rgbSampleModel = this.getRGBSampleModel();
        }
        if (this.rgbRaster == null) {
            DataBufferInt dataBuffer = new DataBufferInt(this.pixels, this.width * this.height, 0);
            this.rgbRaster = Raster.createWritableRaster(this.rgbSampleModel, dataBuffer, null);
        }
        if (this.image == null) {
            this.image = new BufferedImage(this.cm, this.rgbRaster, false, null);
        }
        return this.image;
    }

    SampleModel getRGBSampleModel() {
        WritableRaster wr = this.cm.createCompatibleWritableRaster(1, 1);
        SampleModel sampleModel = wr.getSampleModel();
        sampleModel = sampleModel.createCompatibleSampleModel(this.width, this.height);
        return sampleModel;
    }

    public void setColorModel(ColorModel cm) {
        if (cm != null && cm instanceof IndexColorModel) {
            throw new IllegalArgumentException("DirectColorModel required");
        }
        this.cm = cm;
        this.newPixels = true;
        this.source = null;
        this.rgbSampleModel = null;
        this.rgbRaster = null;
    }

    public ImageProcessor createProcessor(int width, int height) {
        ColorProcessor ip2 = new ColorProcessor(width, height);
        ip2.setInterpolationMethod(this.interpolationMethod);
        return ip2;
    }

    public Color getColor(int x, int y) {
        int c = this.pixels[y * this.width + x];
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        return new Color(r, g, b);
    }

    public void setColor(Color color) {
        this.fgColor = color.getRGB();
        this.drawingColor = color;
    }

    public void setColor(int color) {
        this.fgColor = color;
    }

    public void setValue(double value) {
        this.fgColor = (int)value;
    }

    public void setBackgroundValue(double value) {
        this.bgColor = (int)value;
    }

    public double getBackgroundValue() {
        return this.bgColor;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double min, double max) {
        this.setMinAndMax(min, max, 7);
    }

    public void setMinAndMax(double min, double max, int channels) {
        if (max < min) {
            return;
        }
        this.min = (int)min;
        this.max = (int)max;
        int[] lut = new int[256];
        for (int i = 0; i < 256; ++i) {
            int v = i - this.min;
            if ((v = (int)(256.0 * (double)v / (max - min))) < 0) {
                v = 0;
            }
            if (v > 255) {
                v = 255;
            }
            lut[i] = v;
        }
        this.reset();
        if (channels == 7) {
            this.applyTable(lut);
        } else {
            this.applyTable(lut, channels);
        }
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new int[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    public void reset(ImageProcessor mask) {
        if (mask == null || this.snapshotPixels == null) {
            return;
        }
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                if (mpixels[mi++] == 0) {
                    this.pixels[i] = this.snapshotPixels[i];
                }
                ++i;
            }
            ++y;
            ++my;
        }
    }

    public void swapPixelArrays() {
        if (this.snapshotPixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            int pixel = this.pixels[i];
            this.pixels[i] = this.snapshotPixels[i];
            this.snapshotPixels[i] = pixel;
        }
    }

    public void setSnapshotPixels(Object pixels) {
        this.snapshotPixels = (int[])pixels;
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
    }

    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    public void fill(ImageProcessor mask) {
        if (mask == null) {
            this.fill();
            return;
        }
        int roiWidth = this.roiWidth;
        int roiHeight = this.roiHeight;
        int roiX = this.roiX;
        int roiY = this.roiY;
        if (mask.getWidth() != roiWidth || mask.getHeight() != roiHeight) {
            return;
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = roiY;
        int my = 0;
        while (y < roiY + roiHeight) {
            int i = y * this.width + roiX;
            int mi = my * roiWidth;
            for (int x = roiX; x < roiX + roiWidth; ++x) {
                if (mpixels[mi++] != 0) {
                    this.pixels[i] = this.fgColor;
                }
                ++i;
            }
            ++y;
            ++my;
        }
    }

    public Object getPixelsCopy() {
        if (this.snapshotPixels != null && this.snapshotCopyMode) {
            this.snapshotCopyMode = false;
            return this.snapshotPixels;
        }
        int[] pixels2 = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return pixels2;
    }

    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x];
        }
        return 0;
    }

    public final int get(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    public final void set(int x, int y, int value) {
        this.pixels[y * this.width + x] = value;
    }

    public final int get(int index) {
        return this.pixels[index];
    }

    public final void set(int index, int value) {
        this.pixels[index] = value;
    }

    public final float getf(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    public final void setf(int x, int y, float value) {
        this.pixels[y * this.width + x] = (int)value;
    }

    public final float getf(int index) {
        return this.pixels[index];
    }

    public final void setf(int index, float value) {
        this.pixels[index] = (int)value;
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        if (iArray == null) {
            iArray = new int[3];
        }
        int c = this.getPixel(x, y);
        iArray[0] = (c & 0xFF0000) >> 16;
        iArray[1] = (c & 0xFF00) >> 8;
        iArray[2] = c & 0xFF;
        return iArray;
    }

    public final void putPixel(int x, int y, int[] iArray) {
        int r = iArray[0];
        int g = iArray[1];
        int b = iArray[2];
        this.putPixel(x, y, (r << 16) + (g << 8) + b);
    }

    public double getInterpolatedPixel(double x, double y) {
        int ix = (int)(x + 0.5);
        int iy = (int)(y + 0.5);
        if (ix < 0) {
            ix = 0;
        }
        if (ix >= this.width) {
            ix = this.width - 1;
        }
        if (iy < 0) {
            iy = 0;
        }
        if (iy >= this.height) {
            iy = this.height - 1;
        }
        return this.getPixelValue(ix, iy);
    }

    public final int getPixelInterpolated(double x, double y) {
        if (x < 0.0 || y < 0.0 || x >= (double)(this.width - 1) || y >= (double)(this.height - 1)) {
            return 0;
        }
        return this.getInterpolatedPixel(x, y, this.pixels);
    }

    public final void putPixel(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = value;
        }
    }

    public void putPixelValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (value > 255.0) {
                value = 255.0;
            } else if (value < 0.0) {
                value = 0.0;
            }
            int gray = (int)(value + 0.5);
            this.pixels[y * this.width + x] = -16777216 + (gray << 16) + (gray << 8) + gray;
        }
    }

    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            int c = this.pixels[y * this.width + x];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            if (this.weights != null) {
                return (float)((double)r * this.weights[0] + (double)g * this.weights[1] + (double)b * this.weights[2]);
            }
            return (float)((double)r * rWeight + (double)g * gWeight + (double)b * bWeight);
        }
        return 0.0f;
    }

    public void drawPixel(int x, int y) {
        if (x >= this.clipXMin && x <= this.clipXMax && y >= this.clipYMin && y <= this.clipYMax) {
            this.pixels[y * this.width + x] = this.fgColor;
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public void setPixels(Object pixels) {
        this.pixels = (int[])pixels;
        this.resetPixels(pixels);
        if (pixels == null) {
            this.snapshotPixels = null;
        }
        this.rgbRaster = null;
        this.image = null;
    }

    public void getHSB(byte[] H, byte[] S, byte[] B) {
        float[] hsb = new float[3];
        for (int i = 0; i < this.width * this.height; ++i) {
            int c = this.pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            hsb = Color.RGBtoHSB(r, g, b, hsb);
            H[i] = (byte)((double)hsb[0] * 255.0);
            S[i] = (byte)((double)hsb[1] * 255.0);
            B[i] = (byte)((double)hsb[2] * 255.0);
        }
    }

    public ImageStack getHSBStack() {
        int width = this.getWidth();
        int height = this.getHeight();
        byte[] H = new byte[width * height];
        byte[] S = new byte[width * height];
        byte[] B = new byte[width * height];
        this.getHSB(H, S, B);
        IndexColorModel cm = this.getDefaultColorModel();
        ImageStack stack = new ImageStack(width, height, cm);
        stack.addSlice("Hue", H);
        stack.addSlice("Saturation", S);
        stack.addSlice("Brightness", B);
        return stack;
    }

    public FloatProcessor getBrightness() {
        int size = this.width * this.height;
        float[] brightness = new float[size];
        float[] hsb = new float[3];
        for (int i = 0; i < size; ++i) {
            int c = this.pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            hsb = Color.RGBtoHSB(r, g, b, hsb);
            brightness[i] = hsb[2];
        }
        return new FloatProcessor(this.width, this.height, brightness, null);
    }

    public void getRGB(byte[] R, byte[] G, byte[] B) {
        for (int i = 0; i < this.width * this.height; ++i) {
            int c = this.pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            R[i] = (byte)r;
            G[i] = (byte)g;
            B[i] = (byte)b;
        }
    }

    public byte[] getChannel(int channel) {
        ByteProcessor bp = this.getChannel(channel, null);
        return (byte[])bp.getPixels();
    }

    public ByteProcessor getChannel(int channel, ByteProcessor bp) {
        int size = this.width * this.height;
        if (bp == null || bp.getWidth() != this.width || bp.getHeight() != this.height) {
            bp = new ByteProcessor(this.width, this.height);
        }
        byte[] bPixels = (byte[])bp.getPixels();
        int shift = 16 - 8 * (channel - 1);
        if (channel == 4) {
            shift = 24;
        }
        for (int i = 0; i < size; ++i) {
            bPixels[i] = (byte)(this.pixels[i] >> shift);
        }
        return bp;
    }

    public void setChannel(int channel, ByteProcessor bp) {
        byte[] bPixels = (byte[])bp.getPixels();
        int size = this.width * this.height;
        int shift = 16 - 8 * (channel - 1);
        if (channel == 4) {
            shift = 24;
        }
        int resetMask = 0xFFFFFFFF ^ 255 << shift;
        for (int i = 0; i < size; ++i) {
            this.pixels[i] = this.pixels[i] & resetMask | (bPixels[i] & 0xFF) << shift;
        }
    }

    public void setRGB(byte[] R, byte[] G, byte[] B) {
        for (int i = 0; i < this.width * this.height; ++i) {
            this.pixels[i] = 0xFF000000 | (R[i] & 0xFF) << 16 | (G[i] & 0xFF) << 8 | B[i] & 0xFF;
        }
    }

    public void setHSB(byte[] H, byte[] S, byte[] B) {
        for (int i = 0; i < this.width * this.height; ++i) {
            float hue = (float)((double)(H[i] & 0xFF) / 255.0);
            float saturation = (float)((double)(S[i] & 0xFF) / 255.0);
            float brightness = (float)((double)(B[i] & 0xFF) / 255.0);
            this.pixels[i] = Color.HSBtoRGB(hue, saturation, brightness);
        }
    }

    public void setBrightness(FloatProcessor fp) {
        int size = this.width * this.height;
        float[] hsb = new float[3];
        float[] brightness = (float[])fp.getPixels();
        if (brightness.length != size) {
            throw new IllegalArgumentException("fp is wrong size");
        }
        for (int i = 0; i < size; ++i) {
            int c = this.pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            hsb = Color.RGBtoHSB(r, g, b, hsb);
            float bvalue = brightness[i];
            if (bvalue < 0.0f) {
                bvalue = 0.0f;
            }
            if (bvalue > 1.0f) {
                bvalue = 1.0f;
            }
            this.pixels[i] = Color.HSBtoRGB(hsb[0], hsb[1], bvalue);
        }
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        ip = ip.convertToRGB();
        new ColorBlitter(this).copyBits(ip, xloc, yloc, mode);
    }

    public void applyTable(int[] lut) {
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                int c = this.pixels[i];
                int r = lut[(c & 0xFF0000) >> 16];
                int g = lut[(c & 0xFF00) >> 8];
                int b = lut[c & 0xFF];
                this.pixels[i] = -16777216 + (r << 16) + (g << 8) + b;
                ++i;
            }
        }
    }

    public void applyTable(int[] lut, int channels) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                int c = this.pixels[i];
                if (channels == 4) {
                    r = lut[(c & 0xFF0000) >> 16];
                    g = (c & 0xFF00) >> 8;
                    b = c & 0xFF;
                } else if (channels == 2) {
                    r = (c & 0xFF0000) >> 16;
                    g = lut[(c & 0xFF00) >> 8];
                    b = c & 0xFF;
                } else if (channels == 1) {
                    r = (c & 0xFF0000) >> 16;
                    g = (c & 0xFF00) >> 8;
                    b = lut[c & 0xFF];
                } else if ((channels & 6) == 6) {
                    r = lut[(c & 0xFF0000) >> 16];
                    g = lut[(c & 0xFF00) >> 8];
                    b = c & 0xFF;
                } else if ((channels & 5) == 5) {
                    r = lut[(c & 0xFF0000) >> 16];
                    g = (c & 0xFF00) >> 8;
                    b = lut[c & 0xFF];
                } else if ((channels & 3) == 3) {
                    r = (c & 0xFF0000) >> 16;
                    g = lut[(c & 0xFF00) >> 8];
                    b = lut[c & 0xFF];
                }
                this.pixels[i] = -16777216 + (r << 16) + (g << 8) + b;
                ++i;
            }
        }
    }

    public void fill() {
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                this.pixels[i++] = this.fgColor;
            }
        }
    }

    public void filterRGB(int type, double arg) {
        this.filterRGB(type, arg, 0.0);
    }

    final ImageProcessor filterRGB(int type, double arg, double arg2) {
        this.showProgress(0.01);
        byte[] R = new byte[this.width * this.height];
        byte[] G = new byte[this.width * this.height];
        byte[] B = new byte[this.width * this.height];
        this.getRGB(R, G, B);
        Rectangle roi = new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
        ByteProcessor r = new ByteProcessor(this.width, this.height, R, null);
        r.setRoi(roi);
        ByteProcessor g = new ByteProcessor(this.width, this.height, G, null);
        g.setRoi(roi);
        ByteProcessor b = new ByteProcessor(this.width, this.height, B, null);
        b.setRoi(roi);
        r.setBackgroundValue((this.bgColor & 0xFF0000) >> 16);
        g.setBackgroundValue((this.bgColor & 0xFF00) >> 8);
        b.setBackgroundValue(this.bgColor & 0xFF);
        r.setInterpolationMethod(this.interpolationMethod);
        g.setInterpolationMethod(this.interpolationMethod);
        b.setInterpolationMethod(this.interpolationMethod);
        this.showProgress(0.15);
        switch (type) {
            case 0: {
                r.noise(arg);
                this.showProgress(0.4);
                g.noise(arg);
                this.showProgress(0.65);
                b.noise(arg);
                this.showProgress(0.9);
                break;
            }
            case 1: {
                r.medianFilter();
                this.showProgress(0.4);
                g.medianFilter();
                this.showProgress(0.65);
                b.medianFilter();
                this.showProgress(0.9);
                break;
            }
            case 2: {
                r.findEdges();
                this.showProgress(0.4);
                g.findEdges();
                this.showProgress(0.65);
                b.findEdges();
                this.showProgress(0.9);
                break;
            }
            case 3: {
                r.erode();
                this.showProgress(0.4);
                g.erode();
                this.showProgress(0.65);
                b.erode();
                this.showProgress(0.9);
                break;
            }
            case 4: {
                r.dilate();
                this.showProgress(0.4);
                g.dilate();
                this.showProgress(0.65);
                b.dilate();
                this.showProgress(0.9);
                break;
            }
            case 5: {
                r.autoThreshold();
                this.showProgress(0.4);
                g.autoThreshold();
                this.showProgress(0.65);
                b.autoThreshold();
                this.showProgress(0.9);
                break;
            }
            case 6: {
                IJ.showStatus("Rotating red");
                r.rotate(arg);
                this.showProgress(0.4);
                IJ.showStatus("Rotating green");
                g.rotate(arg);
                this.showProgress(0.65);
                IJ.showStatus("Rotating blue");
                b.rotate(arg);
                this.showProgress(0.9);
                break;
            }
            case 7: {
                IJ.showStatus("Scaling red");
                r.scale(arg, arg2);
                this.showProgress(0.4);
                IJ.showStatus("Scaling green");
                g.scale(arg, arg2);
                this.showProgress(0.65);
                IJ.showStatus("Scaling blue");
                b.scale(arg, arg2);
                this.showProgress(0.9);
                break;
            }
            case 8: {
                int w = (int)arg;
                int h = (int)arg2;
                IJ.showStatus("Resizing red");
                ImageProcessor r2 = r.resize(w, h);
                this.showProgress(0.4);
                IJ.showStatus("Resizing green");
                ImageProcessor g2 = g.resize(w, h);
                this.showProgress(0.65);
                IJ.showStatus("Resizing blue");
                ImageProcessor b2 = b.resize(w, h);
                this.showProgress(0.9);
                R = (byte[])r2.getPixels();
                G = (byte[])g2.getPixels();
                B = (byte[])b2.getPixels();
                ColorProcessor ip2 = new ColorProcessor(w, h);
                ip2.setRGB(R, G, B);
                this.showProgress(1.0);
                return ip2;
            }
            case 9: {
                IJ.showStatus("Translating red");
                r.translate(arg, arg2);
                this.showProgress(0.4);
                IJ.showStatus("Translating green");
                g.translate(arg, arg2);
                this.showProgress(0.65);
                IJ.showStatus("Translating blue");
                b.translate(arg, arg2);
                this.showProgress(0.9);
            }
        }
        R = (byte[])r.getPixels();
        G = (byte[])g.getPixels();
        B = (byte[])b.getPixels();
        this.setRGB(R, G, B);
        this.showProgress(1.0);
        return null;
    }

    public void noise(double range) {
        this.filterRGB(0, range);
    }

    public void medianFilter() {
        this.filterRGB(1, 0.0);
    }

    public void findEdges() {
        this.filterRGB(2, 0.0);
    }

    public void erode() {
        this.filterRGB(3, 0.0);
    }

    public void dilate() {
        this.filterRGB(4, 0.0);
    }

    public void autoThreshold() {
        this.filterRGB(5, 0.0);
    }

    public void scale(double xScale, double yScale) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        if (this.interpolationMethod == 2) {
            this.filterRGB(7, xScale, yScale);
            return;
        }
        double xCenter = (double)this.roiX + (double)this.roiWidth / 2.0;
        double yCenter = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (xScale > 1.0 && yScale > 1.0) {
            xmin = (int)(xCenter - (xCenter - (double)this.roiX) * xScale);
            if (xmin < 0) {
                xmin = 0;
            }
            if ((xmax = xmin + (int)((double)this.roiWidth * xScale) - 1) >= this.width) {
                xmax = this.width - 1;
            }
            if ((ymin = (int)(yCenter - (yCenter - (double)this.roiY) * yScale)) < 0) {
                ymin = 0;
            }
            if ((ymax = ymin + (int)((double)this.roiHeight * yScale) - 1) >= this.height) {
                ymax = this.height - 1;
            }
        } else {
            xmin = this.roiX;
            xmax = this.roiX + this.roiWidth - 1;
            ymin = this.roiY;
            ymax = this.roiY + this.roiHeight - 1;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        boolean checkCoordinates = xScale < 1.0 || yScale < 1.0;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        for (int y = ymin; y <= ymax; ++y) {
            double ys = ((double)y - yCenter) / yScale + yCenter;
            int ysi = (int)ys;
            if (ys < 0.0) {
                ys = 0.0;
            }
            if (ys >= ylimit) {
                ys = ylimit2;
            }
            int index1 = y * this.width + xmin;
            int index2 = this.width * (int)ys;
            for (int x = xmin; x <= xmax; ++x) {
                double xs = ((double)x - xCenter) / xScale + xCenter;
                int xsi = (int)xs;
                if (checkCoordinates && (xsi < xmin || xsi > xmax || ysi < ymin || ysi > ymax)) {
                    this.pixels[index1++] = this.bgColor;
                    continue;
                }
                if (this.interpolationMethod == 1) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    this.pixels[index1++] = this.getInterpolatedPixel(xs, ys, pixels2);
                    continue;
                }
                this.pixels[index1++] = pixels2[index2 + xsi];
            }
            if (y % 20 != 0) continue;
            this.showProgress((double)(y - ymin) / (double)this.height);
        }
        this.showProgress(1.0);
    }

    public ImageProcessor crop() {
        int[] pixels2 = new int[this.roiWidth * this.roiHeight];
        for (int ys = this.roiY; ys < this.roiY + this.roiHeight; ++ys) {
            int offset1 = (ys - this.roiY) * this.roiWidth;
            int offset2 = ys * this.width + this.roiX;
            for (int xs = 0; xs < this.roiWidth; ++xs) {
                pixels2[offset1++] = this.pixels[offset2++];
            }
        }
        ColorProcessor cp2 = new ColorProcessor(this.roiWidth, this.roiHeight, pixels2);
        return cp2;
    }

    public ImageProcessor duplicate() {
        int[] pixels2 = new int[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return new ColorProcessor(this.width, this.height, pixels2);
    }

    public int getInterpolatedRGBPixel(double x, double y) {
        if (this.width == 1 || this.height == 1) {
            return this.getPixel((int)x, (int)y);
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)this.width - 1.0) {
            x = (double)this.width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)this.height - 1.0) {
            y = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(x, y, this.pixels);
    }

    private final int getInterpolatedPixel(double x, double y, int[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        int lowerLeft = pixels[offset];
        int rll = (lowerLeft & 0xFF0000) >> 16;
        int gll = (lowerLeft & 0xFF00) >> 8;
        int bll = lowerLeft & 0xFF;
        int lowerRight = pixels[offset + 1];
        int rlr = (lowerRight & 0xFF0000) >> 16;
        int glr = (lowerRight & 0xFF00) >> 8;
        int blr = lowerRight & 0xFF;
        int upperRight = pixels[offset + this.width + 1];
        int rur = (upperRight & 0xFF0000) >> 16;
        int gur = (upperRight & 0xFF00) >> 8;
        int bur = upperRight & 0xFF;
        int upperLeft = pixels[offset + this.width];
        int rul = (upperLeft & 0xFF0000) >> 16;
        int gul = (upperLeft & 0xFF00) >> 8;
        int bul = upperLeft & 0xFF;
        double upperAverage = (double)rul + xFraction * (double)(rur - rul);
        double lowerAverage = (double)rll + xFraction * (double)(rlr - rll);
        int r = (int)(lowerAverage + yFraction * (upperAverage - lowerAverage) + 0.5);
        upperAverage = (double)gul + xFraction * (double)(gur - gul);
        lowerAverage = (double)gll + xFraction * (double)(glr - gll);
        int g = (int)(lowerAverage + yFraction * (upperAverage - lowerAverage) + 0.5);
        upperAverage = (double)bul + xFraction * (double)(bur - bul);
        lowerAverage = (double)bll + xFraction * (double)(blr - bll);
        int b = (int)(lowerAverage + yFraction * (upperAverage - lowerAverage) + 0.5);
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public ImageProcessor resize(int dstWidth, int dstHeight) {
        if (this.roiWidth == dstWidth && this.roiHeight == dstHeight) {
            return this.crop();
        }
        if (this.interpolationMethod != 0 && (this.width == 1 || this.height == 1)) {
            ByteProcessor r2 = (ByteProcessor)this.getChannel(1, null).resizeLinearly(dstWidth, dstHeight);
            ByteProcessor g2 = (ByteProcessor)this.getChannel(2, null).resizeLinearly(dstWidth, dstHeight);
            ByteProcessor b2 = (ByteProcessor)this.getChannel(3, null).resizeLinearly(dstWidth, dstHeight);
            ColorProcessor ip2 = new ColorProcessor(dstWidth, dstHeight);
            ip2.setChannel(1, r2);
            ip2.setChannel(2, g2);
            ip2.setChannel(3, b2);
            return ip2;
        }
        if (this.interpolationMethod == 2) {
            return this.filterRGB(8, dstWidth, dstHeight);
        }
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        if (this.interpolationMethod == 1) {
            dstCenterX += xScale / 2.0;
            dstCenterY += yScale / 2.0;
        }
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        int[] pixels2 = (int[])ip2.getPixels();
        for (int y = 0; y <= dstHeight - 1; ++y) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            if (this.interpolationMethod == 1) {
                if (ys < 0.0) {
                    ys = 0.0;
                }
                if (ys >= ylimit) {
                    ys = ylimit2;
                }
            }
            int index1 = this.width * (int)ys;
            int index2 = y * dstWidth;
            for (int x = 0; x <= dstWidth - 1; ++x) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                if (this.interpolationMethod == 1) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    pixels2[index2++] = this.getInterpolatedPixel(xs, ys, this.pixels);
                    continue;
                }
                pixels2[index2++] = this.pixels[index1 + (int)xs];
            }
            if (y % 20 != 0) continue;
            this.showProgress((double)y / (double)dstHeight);
        }
        this.showProgress(1.0);
        return ip2;
    }

    public ImageProcessor makeThumbnail(int width2, int height2, double smoothFactor) {
        return this.resize(width2, height2, true);
    }

    public void rotate(double angle) {
        if (angle % 360.0 == 0.0) {
            return;
        }
        if (this.interpolationMethod == 2) {
            this.filterRGB(6, angle);
            return;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        double centerX = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double centerY = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int xMax = this.roiX + this.roiWidth - 1;
        double angleRadians = -angle / 57.29577951308232;
        double ca = Math.cos(angleRadians);
        double sa = Math.sin(angleRadians);
        double tmp1 = centerY * sa - centerX * ca;
        double tmp2 = -centerX * sa - centerY * ca;
        double dwidth = this.width;
        double dheight = this.height;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int index = y * this.width + this.roiX;
            double tmp3 = tmp1 - (double)y * sa + centerX;
            double tmp4 = tmp2 + (double)y * ca + centerY;
            for (int x = this.roiX; x <= xMax; ++x) {
                double xs = (double)x * ca + tmp3;
                double ys = (double)x * sa + tmp4;
                if (xs >= -0.01 && xs < dwidth && ys >= -0.01 && ys < dheight) {
                    if (this.interpolationMethod == 1) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        if (ys < 0.0) {
                            ys = 0.0;
                        }
                        if (ys >= ylimit) {
                            ys = ylimit2;
                        }
                        this.pixels[index++] = this.getInterpolatedPixel(xs, ys, pixels2);
                        continue;
                    }
                    int ixs = (int)(xs + 0.5);
                    int iys = (int)(ys + 0.5);
                    if (ixs >= this.width) {
                        ixs = this.width - 1;
                    }
                    if (iys >= this.height) {
                        iys = this.height - 1;
                    }
                    this.pixels[index++] = pixels2[this.width * iys + ixs];
                    continue;
                }
                this.pixels[index++] = this.bgColor;
            }
            if (y % 30 != 0) continue;
            this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void flipVertical() {
        for (int y = 0; y < this.roiHeight / 2; ++y) {
            int index1 = (this.roiY + y) * this.width + this.roiX;
            int index2 = (this.roiY + this.roiHeight - 1 - y) * this.width + this.roiX;
            for (int i = 0; i < this.roiWidth; ++i) {
                int tmp = this.pixels[index1];
                this.pixels[index1++] = this.pixels[index2];
                this.pixels[index2++] = tmp;
            }
        }
    }

    public void convolve3x3(int[] kernel) {
        int inc;
        int k1 = kernel[0];
        int k2 = kernel[1];
        int k3 = kernel[2];
        int k4 = kernel[3];
        int k5 = kernel[4];
        int k6 = kernel[5];
        int k7 = kernel[6];
        int k8 = kernel[7];
        int k9 = kernel[8];
        int scale = 0;
        for (int i = 0; i < kernel.length; ++i) {
            scale += kernel[i];
        }
        if (scale == 0) {
            scale = 1;
        }
        if ((inc = this.roiHeight / 25) < 1) {
            inc = 1;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int rowOffset = this.width;
        for (int y = this.yMin; y <= this.yMax; ++y) {
            int offset = this.xMin + y * this.width;
            int p1 = 0;
            int p2 = pixels2[offset - rowOffset - 1];
            int p3 = pixels2[offset - rowOffset];
            int p4 = 0;
            int p5 = pixels2[offset - 1];
            int p6 = pixels2[offset];
            int p7 = 0;
            int p8 = pixels2[offset + rowOffset - 1];
            int p9 = pixels2[offset + rowOffset];
            for (int x = this.xMin; x <= this.xMax; ++x) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1];
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1];
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1];
                rsum = k1 * ((p1 & 0xFF0000) >> 16) + k2 * ((p2 & 0xFF0000) >> 16) + k3 * ((p3 & 0xFF0000) >> 16) + k4 * ((p4 & 0xFF0000) >> 16) + k5 * ((p5 & 0xFF0000) >> 16) + k6 * ((p6 & 0xFF0000) >> 16) + k7 * ((p7 & 0xFF0000) >> 16) + k8 * ((p8 & 0xFF0000) >> 16) + k9 * ((p9 & 0xFF0000) >> 16);
                if ((rsum /= scale) > 255) {
                    rsum = 255;
                }
                if (rsum < 0) {
                    rsum = 0;
                }
                gsum = k1 * ((p1 & 0xFF00) >> 8) + k2 * ((p2 & 0xFF00) >> 8) + k3 * ((p3 & 0xFF00) >> 8) + k4 * ((p4 & 0xFF00) >> 8) + k5 * ((p5 & 0xFF00) >> 8) + k6 * ((p6 & 0xFF00) >> 8) + k7 * ((p7 & 0xFF00) >> 8) + k8 * ((p8 & 0xFF00) >> 8) + k9 * ((p9 & 0xFF00) >> 8);
                if ((gsum /= scale) > 255) {
                    gsum = 255;
                } else if (gsum < 0) {
                    gsum = 0;
                }
                bsum = k1 * (p1 & 0xFF) + k2 * (p2 & 0xFF) + k3 * (p3 & 0xFF) + k4 * (p4 & 0xFF) + k5 * (p5 & 0xFF) + k6 * (p6 & 0xFF) + k7 * (p7 & 0xFF) + k8 * (p8 & 0xFF) + k9 * (p9 & 0xFF);
                if ((bsum /= scale) > 255) {
                    bsum = 255;
                }
                if (bsum < 0) {
                    bsum = 0;
                }
                this.pixels[offset++] = 0xFF000000 | rsum << 16 & 0xFF0000 | gsum << 8 & 0xFF00 | bsum & 0xFF;
            }
            if (y % inc != 0) continue;
            this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void filter(int type) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        int[] pixels2 = (int[])this.getPixelsCopy();
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int rowOffset = this.width;
        for (int y = this.yMin; y <= this.yMax; ++y) {
            int offset = this.xMin + y * this.width;
            int p1 = 0;
            int p2 = pixels2[offset - rowOffset - 1];
            int p3 = pixels2[offset - rowOffset];
            int p4 = 0;
            int p5 = pixels2[offset - 1];
            int p6 = pixels2[offset];
            int p7 = 0;
            int p8 = pixels2[offset + rowOffset - 1];
            int p9 = pixels2[offset + rowOffset];
            for (int x = this.xMin; x <= this.xMax; ++x) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1];
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1];
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1];
                rsum = (p1 & 0xFF0000) + (p2 & 0xFF0000) + (p3 & 0xFF0000) + (p4 & 0xFF0000) + (p5 & 0xFF0000) + (p6 & 0xFF0000) + (p7 & 0xFF0000) + (p8 & 0xFF0000) + (p9 & 0xFF0000);
                gsum = (p1 & 0xFF00) + (p2 & 0xFF00) + (p3 & 0xFF00) + (p4 & 0xFF00) + (p5 & 0xFF00) + (p6 & 0xFF00) + (p7 & 0xFF00) + (p8 & 0xFF00) + (p9 & 0xFF00);
                bsum = (p1 & 0xFF) + (p2 & 0xFF) + (p3 & 0xFF) + (p4 & 0xFF) + (p5 & 0xFF) + (p6 & 0xFF) + (p7 & 0xFF) + (p8 & 0xFF) + (p9 & 0xFF);
                this.pixels[offset++] = 0xFF000000 | rsum / 9 & 0xFF0000 | gsum / 9 & 0xFF00 | bsum / 9;
            }
            if (y % inc != 0) continue;
            this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        double rw = rWeight;
        double gw = gWeight;
        double bw = bWeight;
        if (this.weights != null) {
            rw = this.weights[0];
            gw = this.weights[1];
            bw = this.weights[2];
        }
        int[] histogram = new int[256];
        for (int y = this.roiY; y < this.roiY + this.roiHeight; ++y) {
            int i = y * this.width + this.roiX;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                int v;
                int c = this.pixels[i++];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                int n = v = (int)((double)r * rw + (double)g * gw + (double)b * bw + 0.5);
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public int[] getHistogram(ImageProcessor mask) {
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        double rw = rWeight;
        double gw = gWeight;
        double bw = bWeight;
        if (this.weights != null) {
            rw = this.weights[0];
            gw = this.weights[1];
            bw = this.weights[2];
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int[] histogram = new int[256];
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            for (int x = this.roiX; x < this.roiX + this.roiWidth; ++x) {
                if (mpixels[mi++] != 0) {
                    int v;
                    int c = this.pixels[i];
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    int n = v = (int)((double)r * rw + (double)g * gw + (double)b * bw + 0.5);
                    histogram[n] = histogram[n] + 1;
                }
                ++i;
            }
            ++y;
            ++my;
        }
        return histogram;
    }

    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        int size = this.width * this.height;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        this.getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(this.width, this.height, r, null);
        ByteProcessor gip = new ByteProcessor(this.width, this.height, g, null);
        ByteProcessor bip = new ByteProcessor(this.width, this.height, b, null);
        ImageProcessor ip2 = rip.convertToFloat();
        Rectangle roi = this.getRoi();
        ip2.setRoi(roi);
        ip2.convolve(kernel, kernelWidth, kernelHeight);
        ImageProcessor r2 = ip2.convertToByte(false);
        ip2 = gip.convertToFloat();
        ip2.setRoi(roi);
        ip2.convolve(kernel, kernelWidth, kernelHeight);
        ImageProcessor g2 = ip2.convertToByte(false);
        ip2 = bip.convertToFloat();
        ip2.setRoi(roi);
        ip2.convolve(kernel, kernelWidth, kernelHeight);
        ImageProcessor b2 = ip2.convertToByte(false);
        this.setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    public static void setWeightingFactors(double rFactor, double gFactor, double bFactor) {
        rWeight = rFactor;
        gWeight = gFactor;
        bWeight = bFactor;
    }

    public static double[] getWeightingFactors() {
        double[] weights = new double[]{rWeight, gWeight, bWeight};
        return weights;
    }

    public void setRGBWeights(double rweight, double gweight, double bweight) {
        this.weights = new double[3];
        this.weights[0] = rweight;
        this.weights[1] = gweight;
        this.weights[2] = bweight;
    }

    public double[] getRGBWeights() {
        return this.weights;
    }

    public boolean isInvertedLut() {
        return false;
    }

    public final boolean isGrayscale() {
        for (int i = 0; i < this.pixels.length; ++i) {
            int c = this.pixels[i];
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            if (r == g && r == b) continue;
            return false;
        }
        return true;
    }

    public int getBestIndex(Color c) {
        return 0;
    }

    public void invertLut() {
    }

    public void updateComposite(int[] rgbPixels, int channel) {
    }

    public void threshold(int level) {
    }

    public int getNChannels() {
        return 3;
    }

    public FloatProcessor toFloat(int channelNumber, FloatProcessor fp) {
        int size = this.width * this.height;
        if (fp == null || fp.getWidth() != this.width || fp.getHeight() != this.height) {
            fp = new FloatProcessor(this.width, this.height, new float[size], null);
        }
        float[] fPixels = (float[])fp.getPixels();
        int shift = 16 - 8 * channelNumber;
        int byteMask = 255 << shift;
        for (int i = 0; i < size; ++i) {
            fPixels[i] = (this.pixels[i] & byteMask) >> shift;
        }
        fp.setRoi(this.getRoi());
        fp.setMask(this.mask);
        fp.setMinAndMax(0.0, 255.0);
        return fp;
    }

    public void setPixels(int channelNumber, FloatProcessor fp) {
        float[] fPixels = (float[])fp.getPixels();
        int size = this.width * this.height;
        int shift = 16 - 8 * channelNumber;
        int resetMask = 0xFFFFFFFF ^ 255 << shift;
        for (int i = 0; i < size; ++i) {
            float value = fPixels[i] + 0.5f;
            if (value < 0.0f) {
                value = 0.0f;
            }
            if (value > 255.0f) {
                value = 255.0f;
            }
            this.pixels[i] = this.pixels[i] & resetMask | (int)value << shift;
        }
    }

    public int getBitDepth() {
        return 24;
    }
}

