/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.RoiManager;
import ij.process.BinaryInterpolator;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;

public class RoiInterpolator
implements PlugIn {
    int[][] idt;
    int w;
    int h;

    @Override
    public void run(String arg) {
        Rectangle bounds;
        RoiManager roiman = RoiManager.getInstance();
        if (roiman == null || roiman.getCount() < 2) {
            IJ.error("RoiInterpolator", "Please populate the ROI Manager with at least two ROIs");
            return;
        }
        Roi[] rois = roiman.getRoisAsArray();
        int xmax = 0;
        int xmin = Integer.MAX_VALUE;
        int ymax = 0;
        int ymin = Integer.MAX_VALUE;
        int zmax = 1;
        int zmin = Integer.MAX_VALUE;
        ArrayList<Integer> templateSlices = new ArrayList<Integer>();
        for (Roi roi : rois) {
            int slice = roiman.getSliceNumber(roi.getName());
            if (!templateSlices.contains(new Integer(slice))) {
                templateSlices.add(new Integer(slice));
            }
            if (slice == 0) continue;
            zmin = Math.min(slice, zmin);
            zmax = Math.max(slice, zmax);
            Rectangle bounds2 = roi.getBounds();
            xmin = Math.min(xmin, bounds2.x);
            ymin = Math.min(ymin, bounds2.y);
            xmax = Math.max(xmax, bounds2.x + bounds2.width);
            ymax = Math.max(ymax, bounds2.y + bounds2.height);
        }
        if (templateSlices.size() < 2) {
            IJ.error("RoiInterpolator", "ROIs are all on the same slice, nothing to interpolate");
            return;
        }
        int stackW = xmax - xmin + 1;
        int stackH = ymax - ymin + 1;
        int nSlices = zmax - zmin + 1;
        ImageStack stack = new ImageStack(stackW, stackH);
        for (int s = 0; s < nSlices; ++s) {
            ByteProcessor bp = new ByteProcessor(stackW, stackH);
            bp.setColor(255);
            for (Roi roi : rois) {
                int slice = roiman.getSliceNumber(roi.getName());
                if (slice != zmin + s) continue;
                bounds = roi.getBounds();
                roi.setLocation(bounds.x - xmin, bounds.y - ymin);
                bp.setRoi(roi);
                if (roi.getType() == 0) {
                    bp.fill();
                    continue;
                }
                bp.fill(roi);
            }
            stack.addSlice("" + s, bp);
        }
        BinaryInterpolator bi = new BinaryInterpolator();
        bi.run(stack);
        ImagePlus binary = new ImagePlus("interpolated", stack);
        ThresholdToSelection ts = new ThresholdToSelection();
        ts.setup("", binary);
        for (int s = 0; s < nSlices; ++s) {
            if (templateSlices.contains(new Integer(s + zmin))) continue;
            ImageProcessor bp = stack.getProcessor(s + 1);
            int threshold = 255;
            bp.setThreshold(threshold, threshold, 2);
            Roi roi = ts.convert(bp);
            roi.setPosition(s + zmin);
            bounds = roi.getBounds();
            roi.setLocation(bounds.x + xmin, bounds.y + ymin);
            roiman.addRoi(roi);
        }
        for (Roi roi : rois) {
            bounds = roi.getBounds();
            roi.setLocation(bounds.x + xmin, bounds.y + ymin);
        }
        roiman.runCommand("sort");
        IJ.showStatus("ROIs interpolated");
    }
}

