/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ColorSpaceConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ColorThresholder
extends PlugInFrame
implements PlugIn,
Measurements,
ActionListener,
AdjustmentListener,
FocusListener,
ItemListener,
Runnable {
    private static final int HSB = 0;
    private static final int RGB = 1;
    private static final int LAB = 2;
    private static final int YUV = 3;
    private static final String[] colorSpaces = new String[]{"HSB", "RGB", "Lab", "YUV"};
    private boolean flag = false;
    private int colorSpace = 0;
    private Thread thread;
    private static Frame instance;
    private BandPlot plot = new BandPlot();
    private BandPlot splot = new BandPlot();
    private BandPlot bplot = new BandPlot();
    private int sliderRange = 256;
    private Panel panel;
    private Panel panelt;
    private Button originalB;
    private Button filteredB;
    private Button stackB;
    private Button helpB;
    private Button sampleB;
    private Button resetallB;
    private Button newB;
    private Button macroB;
    private Button selectB;
    private Checkbox bandPassH;
    private Checkbox bandPassS;
    private Checkbox bandPassB;
    private Checkbox darkBackground;
    private CheckboxGroup colourMode;
    private Choice colorSpaceChoice;
    private Choice methodChoice;
    private Choice modeChoice;
    private int previousImageID = -1;
    private int previousSlice = -1;
    private ImageJ ij;
    private int minHue = 0;
    private int minSat = 0;
    private int minBri = 0;
    private int maxHue = 255;
    private int maxSat = 255;
    private int maxBri = 255;
    private Scrollbar minSlider;
    private Scrollbar maxSlider;
    private Scrollbar minSlider2;
    private Scrollbar maxSlider2;
    private Scrollbar minSlider3;
    private Scrollbar maxSlider3;
    private Label label1;
    private Label label2;
    private Label label3;
    private Label label4;
    private Label label5;
    private Label label6;
    private Label labelh;
    private Label labels;
    private Label labelb;
    private Label labelf;
    private boolean done;
    private byte[] hSource;
    private byte[] sSource;
    private byte[] bSource;
    private boolean applyingStack;
    private static final int DEFAULT = 0;
    private static String[] methodNames;
    private static String method;
    private static AutoThresholder thresholder;
    private static final int RED = 0;
    private static final int WHITE = 1;
    private static final int BLACK = 2;
    private static final int BLACK_AND_WHITE = 3;
    private static final String[] modes;
    private static int mode;
    private int numSlices;
    private ImageStack stack;
    private int width;
    private int height;
    private int numPixels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorThresholder() {
        super("Threshold Color");
        int i;
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        this.thread = new Thread((Runnable)this, "BandAdjuster");
        WindowManager.addWindow(this);
        instance = this;
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.labelh = new Label("Hue", 1);
        this.add((Component)this.labelh, c);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(7, 0, 0, 0);
        this.labelf = new Label("", 2);
        this.add((Component)this.labelf, c);
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.plot, c);
        this.bandPassH = new Checkbox("Pass");
        this.bandPassH.addItemListener(this);
        this.bandPassH.setState(true);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bandPassH, c);
        this.minSlider = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider, c);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label1 = new Label("       ", 0);
        this.label1.setFont(font);
        this.add((Component)this.label1, c);
        this.maxSlider = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider, c);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridy = y++;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label2 = new Label("       ", 0);
        this.label2.setFont(font);
        this.add((Component)this.label2, c);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.labels = new Label("Saturation", 1);
        this.add((Component)this.labels, c);
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.splot, c);
        this.bandPassS = new Checkbox("Pass");
        this.bandPassS.addItemListener(this);
        this.bandPassS.setState(true);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bandPassS, c);
        this.minSlider2 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider2, c);
        this.minSlider2.addAdjustmentListener(this);
        this.minSlider2.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label3 = new Label("       ", 0);
        this.label3.setFont(font);
        this.add((Component)this.label3, c);
        this.maxSlider2 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider2, c);
        this.maxSlider2.addAdjustmentListener(this);
        this.maxSlider2.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label4 = new Label("       ", 0);
        this.label4.setFont(font);
        this.add((Component)this.label4, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = y++;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.labelb = new Label("Brightness", 1);
        this.add((Component)this.labelb, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = y;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.bplot, c);
        this.bandPassB = new Checkbox("Pass");
        this.bandPassB.addItemListener(this);
        this.bandPassB.setState(true);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bandPassB, c);
        this.minSlider3 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider3, c);
        this.minSlider3.addAdjustmentListener(this);
        this.minSlider3.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label5 = new Label("       ", 0);
        this.label5.setFont(font);
        this.add((Component)this.label5, c);
        this.maxSlider3 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider3, c);
        this.maxSlider3.addAdjustmentListener(this);
        this.maxSlider3.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label6 = new Label("       ", 0);
        this.label6.setFont(font);
        this.add((Component)this.label6, c);
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        int y2 = 0;
        Panel panel = new Panel();
        panel.setLayout(gridbag2);
        c2.gridx = 0;
        c2.gridy = y2;
        c2.anchor = 13;
        c2.gridwidth = 1;
        c2.insets = new Insets(5, 0, 0, 0);
        Label theLabel = new Label("Thresholding method:");
        gridbag2.setConstraints(theLabel, c2);
        panel.add(theLabel);
        this.methodChoice = new Choice();
        for (i = 0; i < methodNames.length; ++i) {
            this.methodChoice.addItem(methodNames[i]);
        }
        this.methodChoice.select(method);
        this.methodChoice.addItemListener(this);
        c2.gridx = 1;
        c2.gridy = y2++;
        c2.anchor = 17;
        gridbag2.setConstraints(this.methodChoice, c2);
        panel.add(this.methodChoice);
        c2.gridx = 0;
        c2.gridy = y2;
        c2.anchor = 13;
        c2.insets = new Insets(0, 0, 0, 0);
        theLabel = new Label("Threshold color:");
        gridbag2.setConstraints(theLabel, c2);
        panel.add(theLabel);
        this.modeChoice = new Choice();
        for (i = 0; i < modes.length; ++i) {
            this.modeChoice.addItem(modes[i]);
        }
        this.modeChoice.select(mode);
        this.modeChoice.addItemListener(this);
        c2.gridx = 1;
        c2.gridy = y2++;
        c2.anchor = 17;
        gridbag2.setConstraints(this.modeChoice, c2);
        panel.add(this.modeChoice);
        c2.gridx = 0;
        c2.gridy = y2;
        c2.anchor = 13;
        theLabel = new Label("Color space:");
        gridbag2.setConstraints(theLabel, c2);
        panel.add(theLabel);
        this.colorSpaceChoice = new Choice();
        for (i = 0; i < colorSpaces.length; ++i) {
            this.colorSpaceChoice.addItem(colorSpaces[i]);
        }
        this.colorSpaceChoice.select(0);
        this.colorSpaceChoice.addItemListener(this);
        c2.gridx = 1;
        c2.gridy = y2++;
        c2.anchor = 17;
        gridbag2.setConstraints(this.colorSpaceChoice, c2);
        panel.add(this.colorSpaceChoice);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 0, 0, 0);
        c.anchor = 10;
        c.fill = 0;
        this.add((Component)panel, c);
        this.panelt = new Panel();
        boolean db = Prefs.get("cthresholder.dark", true);
        this.darkBackground = new Checkbox("Dark background", db);
        this.darkBackground.addItemListener(this);
        this.panelt.add(this.darkBackground);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.panelt, c);
        int trim = IJ.isMacOSX() ? 10 : 0;
        panel = new Panel();
        panel.setLayout(new GridLayout(0, 4, 0, 0));
        this.originalB = new TrimmedButton("Original", trim);
        this.originalB.addActionListener(this);
        this.originalB.addKeyListener(this.ij);
        panel.add(this.originalB);
        this.filteredB = new TrimmedButton("Filtered", trim);
        this.filteredB.setEnabled(false);
        this.filteredB.addActionListener(this);
        this.filteredB.addKeyListener(this.ij);
        panel.add(this.filteredB);
        this.selectB = new TrimmedButton("Select", trim);
        this.selectB.addActionListener(this);
        this.selectB.addKeyListener(this.ij);
        panel.add(this.selectB);
        this.sampleB = new TrimmedButton("Sample", trim);
        this.sampleB.addActionListener(this);
        this.sampleB.addKeyListener(this.ij);
        panel.add(this.sampleB);
        this.stackB = new TrimmedButton("Stack", trim);
        this.stackB.addActionListener(this);
        this.stackB.addKeyListener(this.ij);
        panel.add(this.stackB);
        this.macroB = new TrimmedButton("Macro", trim);
        this.macroB.addActionListener(this);
        this.macroB.addKeyListener(this.ij);
        panel.add(this.macroB);
        this.helpB = new TrimmedButton("Help", trim);
        this.helpB.addActionListener(this);
        this.helpB.addKeyListener(this.ij);
        panel.add(this.helpB);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 10, 5);
        gridbag.setConstraints(panel, c);
        this.add(panel);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.setVisible(true);
        this.thread.start();
        if (!this.checkImage()) {
            return;
        }
        ColorThresholder colorThresholder = this;
        synchronized (colorThresholder) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            ColorThresholder colorThresholder = this;
            synchronized (colorThresholder) {
                ImagePlus imp;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.done && (imp = WindowManager.getCurrentImage()) != null) {
                    this.reset(imp);
                    this.apply(imp);
                    imp.updateAndDraw();
                }
            }
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.adjustmentValueChanged ");
        }
        if (!this.checkImage()) {
            return;
        }
        if (e.getSource() == this.minSlider) {
            this.adjustMinHue(this.minSlider.getValue());
        } else if (e.getSource() == this.maxSlider) {
            this.adjustMaxHue(this.maxSlider.getValue());
        } else if (e.getSource() == this.minSlider2) {
            this.adjustMinSat(this.minSlider2.getValue());
        } else if (e.getSource() == this.maxSlider2) {
            this.adjustMaxSat(this.maxSlider2.getValue());
        } else if (e.getSource() == this.minSlider3) {
            this.adjustMinBri(this.minSlider3.getValue());
        } else if (e.getSource() == this.maxSlider3) {
            this.adjustMaxBri(this.maxSlider3.getValue());
        }
        this.updateLabels();
        this.updatePlot();
        this.notify();
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        ImagePlus imp;
        if (IJ.debugMode) {
            IJ.log("ColorThresolder.itemStateChanged");
        }
        if ((imp = WindowManager.getCurrentImage()) == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this.methodChoice) {
            method = this.methodChoice.getSelectedItem();
        } else if (source == this.modeChoice) {
            mode = this.modeChoice.getSelectedIndex();
        } else if (source == this.colorSpaceChoice) {
            this.colorSpace = ((Choice)source).getSelectedIndex();
            this.flag = true;
            this.filteredB.setEnabled(false);
            this.minBri = 0;
            this.minSat = 0;
            this.minHue = 0;
            this.maxBri = 255;
            this.maxSat = 255;
            this.maxHue = 255;
            this.bandPassH.setState(true);
            this.bandPassS.setState(true);
            this.bandPassB.setState(true);
        } else if (source == this.darkBackground) {
            // empty if block
        }
        this.reset(imp);
        if (source == this.methodChoice || source == this.colorSpaceChoice || source == this.darkBackground) {
            this.autoSetThreshold();
        }
        this.checkImage();
        this.updateNames();
        this.notify();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (IJ.debugMode) {
            IJ.log("ColorThresolder.focusGained");
        }
        this.checkImage();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean imageThere;
        Button b;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.actionPerformed");
        }
        if ((b = (Button)e.getSource()) == null) {
            return;
        }
        boolean bl = imageThere = b == this.sampleB || this.checkImage();
        if (imageThere) {
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp == null) {
                return;
            }
            if (b == this.originalB) {
                this.reset(imp);
                imp.setProperty("OriginalImage", null);
                this.filteredB.setEnabled(true);
            } else if (b == this.filteredB) {
                this.reset(imp);
                this.apply(imp);
            } else if (b == this.sampleB) {
                this.sample();
                this.apply(imp);
            } else if (b == this.selectB) {
                this.createSelection();
            } else if (b == this.stackB) {
                this.applyStack();
            } else {
                if (b == this.macroB) {
                    this.generateMacro();
                    return;
                }
                if (b == this.helpB) {
                    this.showHelp();
                    return;
                }
            }
            this.updatePlot();
            this.updateLabels();
            imp.updateAndDraw();
        } else {
            IJ.beep();
            IJ.showStatus("No Image");
        }
    }

    void createSelection() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        int saveMode = mode;
        mode = 3;
        this.apply(imp);
        mode = saveMode;
        ImageProcessor ip = imp.getProcessor().convertToByte(false);
        int fg = Prefs.blackBackground ? 255 : 0;
        ip.setThreshold(fg, fg, 2);
        Roi roi = new ThresholdToSelection().convert(ip);
        this.reset(imp);
        imp.setRoi(roi);
    }

    void generateMacro() {
        if (!Recorder.record) {
            IJ.error("Threshold Color", "Command recorder is not running");
            return;
        }
        Recorder.recordString("// Color Thresholder " + IJ.getVersion() + "\n");
        Recorder.recordString("// Autogenerated macro, single images only!\n");
        Recorder.recordString("min=newArray(3);\n");
        Recorder.recordString("max=newArray(3);\n");
        Recorder.recordString("filter=newArray(3);\n");
        Recorder.recordString("a=getTitle();\n");
        if (this.colorSpace == 0) {
            Recorder.recordString("run(\"HSB Stack\");\n");
            Recorder.recordString("run(\"Convert Stack to Images\");\n");
            Recorder.recordString("selectWindow(\"Hue\");\n");
            Recorder.recordString("rename(\"0\");\n");
            Recorder.recordString("selectWindow(\"Saturation\");\n");
            Recorder.recordString("rename(\"1\");\n");
            Recorder.recordString("selectWindow(\"Brightness\");\n");
            Recorder.recordString("rename(\"2\");\n");
        } else {
            if (this.colorSpace == 2) {
                Recorder.recordString("call(\"ij.plugin.frame.ColorThresholder.RGBtoLab\");\n");
            }
            if (this.colorSpace == 3) {
                Recorder.recordString("call(\"ij.plugin.frame.ColorThresholder.RGBtoYUV\");\n");
            }
            Recorder.recordString("run(\"RGB Stack\");\n");
            Recorder.recordString("run(\"Convert Stack to Images\");\n");
            Recorder.recordString("selectWindow(\"Red\");\n");
            Recorder.recordString("rename(\"0\");\n");
            Recorder.recordString("selectWindow(\"Green\");\n");
            Recorder.recordString("rename(\"1\");\n");
            Recorder.recordString("selectWindow(\"Blue\");\n");
            Recorder.recordString("rename(\"2\");\n");
        }
        Recorder.recordString("min[0]=" + this.minSlider.getValue() + ";\n");
        Recorder.recordString("max[0]=" + this.maxSlider.getValue() + ";\n");
        if (this.bandPassH.getState()) {
            Recorder.recordString("filter[0]=\"pass\";\n");
        } else {
            Recorder.recordString("filter[0]=\"stop\";\n");
        }
        Recorder.recordString("min[1]=" + this.minSlider2.getValue() + ";\n");
        Recorder.recordString("max[1]=" + this.maxSlider2.getValue() + ";\n");
        if (this.bandPassS.getState()) {
            Recorder.recordString("filter[1]=\"pass\";\n");
        } else {
            Recorder.recordString("filter[1]=\"stop\";\n");
        }
        Recorder.recordString("min[2]=" + this.minSlider3.getValue() + ";\n");
        Recorder.recordString("max[2]=" + this.maxSlider3.getValue() + ";\n");
        if (this.bandPassB.getState()) {
            Recorder.recordString("filter[2]=\"pass\";\n");
        } else {
            Recorder.recordString("filter[2]=\"stop\";\n");
        }
        Recorder.recordString("for (i=0;i<3;i++){\n");
        Recorder.recordString("  selectWindow(\"\"+i);\n");
        Recorder.recordString("  setThreshold(min[i], max[i]);\n");
        Recorder.recordString("  run(\"Convert to Mask\");\n");
        Recorder.recordString("  if (filter[i]==\"stop\")  run(\"Invert\");\n");
        Recorder.recordString("}\n");
        Recorder.recordString("imageCalculator(\"AND create\", \"0\",\"1\");\n");
        Recorder.recordString("imageCalculator(\"AND create\", \"Result of 0\",\"2\");\n");
        Recorder.recordString("for (i=0;i<3;i++){\n");
        Recorder.recordString("  selectWindow(\"\"+i);\n");
        Recorder.recordString("  close();\n");
        Recorder.recordString("}\n");
        Recorder.recordString("selectWindow(\"Result of 0\");\n");
        Recorder.recordString("close();\n");
        Recorder.recordString("selectWindow(\"Result of Result of 0\");\n");
        Recorder.recordString("rename(a);\n");
        Recorder.recordString("// Colour Thresholding-------------\n");
    }

    void showHelp() {
        IJ.showMessage("Help", "Color Thresholder\n \nModification of Bob Dougherty's BandPass2 plugin by G.Landini\nto threshold 24 bit RGB images based on HSB, RGB, CIE Lab \nor YUV components.\n \n[Pass]: Everything within range is thresholded, otherwise,\neverything outside range is thresholded.\n \n[Default] [Huang] [Intermodes] [etc.]: Selects the automatic\nthresholding method.\n \n[Red] [White] [Black] [B&W]: Selects the threshold color.\n \n[Dark background]: Auto-thresholding methods assume\nlight features and dark background.\n \n[Original]: Shows the original image and updates the buffer\nwhen switching to another image.\n \n[Filtered]: Shows the filtered image.\n \n[Stack]: Processes the rest of the slices in the stack (if any)\nusing the current settings.\n \n[Macro]: Creates a macro based on the current settings which\nis sent to the macro Recorder window, if open.\n \n[Sample]: (experimental) Sets the ranges of the filters based\non the pixel value components in a user-defined ROI.\n \n[HSB] [RGB] [CIE Lab] [YUV]: Selects the color space.\n \n");
    }

    void sample() {
        int i;
        int j;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getBitDepth() != 24) {
            return;
        }
        this.reset(imp);
        int[] bin = new int[256];
        int counter = 0;
        boolean pi = false;
        int rangePassH = 0;
        boolean rangeStopH = false;
        int rangePassL = 0;
        boolean rangeStopL = false;
        int snumPixels = 0;
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.error("Selection required");
            return;
        }
        ImageProcessor mask = roi.getMask();
        Rectangle r = roi.getBoundingRect();
        ImageProcessor ip = imp.getProcessor();
        if (mask == null) {
            snumPixels = r.width * r.height;
        } else {
            snumPixels = 0;
            for (j = 0; j < r.height; ++j) {
                for (i = 0; i < r.width; ++i) {
                    if (mask.getPixel(i, j) == 0) continue;
                    ++snumPixels;
                }
            }
        }
        byte[] hsSource = new byte[snumPixels];
        byte[] ssSource = new byte[snumPixels];
        byte[] bsSource = new byte[snumPixels];
        int[] pixs = new int[snumPixels];
        if (mask == null) {
            for (j = 0; j < r.height; ++j) {
                for (i = 0; i < r.width; ++i) {
                    pixs[counter++] = ip.getPixel(i + r.x, j + r.y);
                }
            }
        } else {
            for (j = 0; j < r.height; ++j) {
                for (i = 0; i < r.width; ++i) {
                    if (mask.getPixel(i, j) == 0) continue;
                    pixs[counter++] = ip.getPixel(i + r.x, j + r.y);
                }
            }
        }
        imp.deleteRoi();
        ColorProcessor cp2 = new ColorProcessor(1, snumPixels, pixs);
        int iminhue = 256;
        int imaxhue = -1;
        int iminsat = 256;
        int imaxsat = -1;
        int iminbri = 256;
        int imaxbri = -1;
        int iminred = 256;
        int imaxred = -1;
        int imingre = 256;
        int imaxgre = -1;
        int iminblu = 256;
        int imaxblu = -1;
        if (this.colorSpace == 1) {
            cp2.getRGB(hsSource, ssSource, bsSource);
        } else if (this.colorSpace == 0) {
            cp2.getHSB(hsSource, ssSource, bsSource);
        } else if (this.colorSpace == 2) {
            ColorThresholder.getLab(cp2, hsSource, ssSource, bsSource);
        } else if (this.colorSpace == 3) {
            this.getYUV(cp2, hsSource, ssSource, bsSource);
        }
        for (i = 0; i < snumPixels; ++i) {
            bin[hsSource[i] & 0xFF] = 1;
            if ((hsSource[i] & 0xFF) > imaxhue) {
                imaxhue = hsSource[i] & 0xFF;
            }
            if ((hsSource[i] & 0xFF) < iminhue) {
                iminhue = hsSource[i] & 0xFF;
            }
            if ((ssSource[i] & 0xFF) > imaxsat) {
                imaxsat = ssSource[i] & 0xFF;
            }
            if ((ssSource[i] & 0xFF) < iminsat) {
                iminsat = ssSource[i] & 0xFF;
            }
            if ((bsSource[i] & 0xFF) > imaxbri) {
                imaxbri = bsSource[i] & 0xFF;
            }
            if ((bsSource[i] & 0xFF) >= iminbri) continue;
            iminbri = bsSource[i] & 0xFF;
        }
        if (this.colorSpace == 0) {
            int gap = 0;
            int maxgap = 0;
            int maxgapst = -1;
            int maxgapen = -1;
            int gapst = 0;
            if (bin[0] == 0) {
                gapst = 0;
                gap = 1;
            }
            for (i = 1; i < 256; ++i) {
                if (bin[i] != 0) continue;
                if (bin[i - 1] > 0) {
                    gap = 1;
                    gapst = i;
                } else {
                    ++gap;
                }
                if (gap <= maxgap) continue;
                maxgap = gap;
                maxgapst = gapst;
                maxgapen = i;
            }
            for (i = 0; i < 256; ++i) {
                if (bin[i] <= 0) continue;
                rangePassL = i;
                break;
            }
            for (i = 255; i >= 0; --i) {
                if (bin[i] <= 0) continue;
                rangePassH = i;
                break;
            }
            if (rangePassH - rangePassL < maxgap) {
                this.bandPassH.setState(true);
                iminhue = rangePassL;
                imaxhue = rangePassH;
            } else {
                this.bandPassH.setState(false);
                iminhue = maxgapst;
                imaxhue = maxgapen;
            }
        } else {
            this.bandPassH.setState(true);
        }
        this.adjustMinHue(iminhue);
        this.minSlider.setValue(iminhue);
        this.adjustMaxHue(imaxhue);
        this.maxSlider.setValue(imaxhue);
        this.adjustMinSat(iminsat);
        this.minSlider2.setValue(iminsat);
        this.adjustMaxSat(imaxsat);
        this.maxSlider2.setValue(imaxsat);
        this.adjustMinBri(iminbri);
        this.minSlider3.setValue(iminbri);
        this.adjustMaxBri(imaxbri);
        this.maxSlider3.setValue(imaxbri);
    }

    private boolean checkImage() {
        ImagePlus imp;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.checkImage");
        }
        if ((imp = WindowManager.getCurrentImage()) == null || imp.getBitDepth() != 24) {
            IJ.beep();
            IJ.showStatus("No RGB image");
            return false;
        }
        imp.deleteRoi();
        boolean ok = this.setup(imp);
        return ok;
    }

    boolean setup(ImagePlus imp) {
        int type;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.setup");
        }
        if ((type = imp.getType()) != 4) {
            return false;
        }
        ImageProcessor ip = imp.getProcessor();
        int id = imp.getID();
        int slice = imp.getCurrentSlice();
        if (id != this.previousImageID || slice != this.previousSlice || this.flag) {
            Undo.reset();
            this.flag = false;
            this.numSlices = imp.getStackSize();
            this.stack = imp.getStack();
            this.width = this.stack.getWidth();
            this.height = this.stack.getHeight();
            this.numPixels = this.width * this.height;
            this.hSource = new byte[this.numPixels];
            this.sSource = new byte[this.numPixels];
            this.bSource = new byte[this.numPixels];
            ByteProcessor mask = new ByteProcessor(this.width, this.height);
            imp.setProperty("Mask", mask);
            ColorProcessor cp = (ColorProcessor)ip;
            IJ.showStatus("Converting colour space...");
            if (this.colorSpace == 1) {
                cp.getRGB(this.hSource, this.sSource, this.bSource);
            } else if (this.colorSpace == 0) {
                cp.getHSB(this.hSource, this.sSource, this.bSource);
            } else if (this.colorSpace == 2) {
                ColorThresholder.getLab(cp, this.hSource, this.sSource, this.bSource);
            } else if (this.colorSpace == 3) {
                this.getYUV(cp, this.hSource, this.sSource, this.bSource);
            }
            IJ.showStatus("");
            byte[] reds = new byte[256];
            byte[] greens = new byte[256];
            byte[] blues = new byte[256];
            for (int i = 0; i < 256; ++i) {
                Color c = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
                reds[i] = (byte)c.getRed();
                greens[i] = (byte)c.getGreen();
                blues[i] = (byte)c.getBlue();
            }
            IndexColorModel cm = new IndexColorModel(8, 256, reds, greens, blues);
            ByteProcessor bpHue = new ByteProcessor(this.width, this.height, this.hSource, cm);
            ImagePlus impHue = new ImagePlus("Hue", bpHue);
            ByteProcessor bpSat = new ByteProcessor(this.width, this.height, this.sSource, cm);
            ImagePlus impSat = new ImagePlus("Sat", bpSat);
            ByteProcessor bpBri = new ByteProcessor(this.width, this.height, this.bSource, cm);
            ImagePlus impBri = new ImagePlus("Bri", bpBri);
            this.plot.setHistogram(impHue, 0);
            this.splot.setHistogram(impSat, 1);
            this.bplot.setHistogram(impBri, 2);
            if (!this.applyingStack) {
                this.autoSetThreshold();
            }
            imp.updateAndDraw();
        }
        this.previousImageID = id;
        this.previousSlice = slice;
        return ip != null;
    }

    void autoSetThreshold() {
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.autoSetThreshold");
        }
        boolean darkb = this.darkBackground != null && this.darkBackground.getState();
        switch (this.colorSpace) {
            case 0: {
                int[] histogram = this.bplot.getHistogram();
                if (histogram == null) {
                    return;
                }
                int threshold = thresholder.getThreshold(method, histogram);
                if (darkb) {
                    this.minBri = threshold + 1;
                    this.maxBri = 255;
                    break;
                }
                this.minBri = 0;
                this.maxBri = threshold;
                break;
            }
            case 1: {
                int[] rhistogram = this.plot.getHistogram();
                int threshold = thresholder.getThreshold(method, rhistogram);
                if (darkb) {
                    this.minHue = threshold + 1;
                    this.maxHue = 255;
                } else {
                    this.minHue = 0;
                    this.maxHue = threshold;
                }
                int[] ghistogram = this.splot.getHistogram();
                threshold = thresholder.getThreshold(method, ghistogram);
                if (darkb) {
                    this.minSat = threshold + 1;
                    this.maxSat = 255;
                } else {
                    this.minSat = 0;
                    this.maxSat = threshold;
                }
                int[] bhistogram = this.bplot.getHistogram();
                threshold = thresholder.getThreshold(method, bhistogram);
                if (darkb) {
                    this.minBri = threshold + 1;
                    this.maxBri = 255;
                    break;
                }
                this.minBri = 0;
                this.maxBri = threshold;
                break;
            }
            case 2: 
            case 3: {
                int[] histogram = this.plot.getHistogram();
                int threshold = thresholder.getThreshold(method, histogram);
                if (darkb) {
                    this.minHue = threshold + 1;
                    this.maxHue = 255;
                    break;
                }
                this.minHue = 0;
                this.maxHue = threshold;
            }
        }
        this.updateScrollBars();
        this.updateLabels();
        this.updatePlot();
    }

    void updatePlot() {
        this.plot.minHue = this.minHue;
        this.plot.maxHue = this.maxHue;
        this.plot.repaint();
        this.splot.minHue = this.minSat;
        this.splot.maxHue = this.maxSat;
        this.splot.repaint();
        this.bplot.minHue = this.minBri;
        this.bplot.maxHue = this.maxBri;
        this.bplot.repaint();
    }

    void updateLabels() {
        this.label1.setText("" + this.minHue);
        this.label2.setText("" + this.maxHue);
        this.label3.setText("" + this.minSat);
        this.label4.setText("" + this.maxSat);
        this.label5.setText("" + this.minBri);
        this.label6.setText("" + this.maxBri);
    }

    void updateNames() {
        if (this.colorSpace == 1) {
            this.labelh.setText("Red");
            this.labels.setText("Green");
            this.labelb.setText("Blue");
        } else if (this.colorSpace == 0) {
            this.labelh.setText("Hue");
            this.labels.setText("Saturation");
            this.labelb.setText("Brightness");
        } else if (this.colorSpace == 2) {
            this.labelh.setText("L*");
            this.labels.setText("a*");
            this.labelb.setText("b*");
        } else if (this.colorSpace == 3) {
            this.labelh.setText("Y");
            this.labels.setText("U");
            this.labelb.setText("V");
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue(this.minHue);
        this.maxSlider.setValue(this.maxHue);
        this.minSlider2.setValue(this.minSat);
        this.maxSlider2.setValue(this.maxSat);
        this.minSlider3.setValue(this.minBri);
        this.maxSlider3.setValue(this.maxBri);
    }

    void adjustMinHue(int value) {
        this.minHue = value;
        if (this.maxHue < this.minHue) {
            this.maxHue = this.minHue;
            this.maxSlider.setValue(this.maxHue);
        }
    }

    void adjustMaxHue(int value) {
        this.maxHue = value;
        if (this.minHue > this.maxHue) {
            this.minHue = this.maxHue;
            this.minSlider.setValue(this.minHue);
        }
    }

    void adjustMinSat(int value) {
        this.minSat = value;
        if (this.maxSat < this.minSat) {
            this.maxSat = this.minSat;
            this.maxSlider2.setValue(this.maxSat);
        }
    }

    void adjustMaxSat(int value) {
        this.maxSat = value;
        if (this.minSat > this.maxSat) {
            this.minSat = this.maxSat;
            this.minSlider2.setValue(this.minSat);
        }
    }

    void adjustMinBri(int value) {
        this.minBri = value;
        if (this.maxBri < this.minBri) {
            this.maxBri = this.minBri;
            this.maxSlider3.setValue(this.maxBri);
        }
    }

    void adjustMaxBri(int value) {
        this.maxBri = value;
        if (this.minBri > this.maxBri) {
            this.minBri = this.maxBri;
            this.minSlider3.setValue(this.minBri);
        }
    }

    void apply(ImagePlus imp) {
        ImageProcessor ip;
        int bri;
        int sat;
        int hue;
        int j;
        ImageProcessor fillMaskIP;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.apply");
        }
        if ((fillMaskIP = (ImageProcessor)imp.getProperty("Mask")) == null) {
            return;
        }
        byte[] fillMask = (byte[])fillMaskIP.getPixels();
        int fill = -1;
        int keep = 0;
        if (this.bandPassH.getState() && this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue < this.minHue || hue > this.maxHue || sat < this.minSat || sat > this.maxSat || bri < this.minBri || bri > this.maxBri ? keep : fill;
            }
        } else if (!(this.bandPassH.getState() || this.bandPassS.getState() || this.bandPassB.getState())) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri >= this.minBri && bri <= this.maxBri ? keep : fill;
            }
        } else if (this.bandPassH.getState() && this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue < this.minHue || hue > this.maxHue || sat < this.minSat || sat > this.maxSat || bri >= this.minBri && bri <= this.maxBri ? keep : fill;
            }
        } else if (!this.bandPassH.getState() && !this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri < this.minBri || bri > this.maxBri ? keep : fill;
            }
        } else if (this.bandPassH.getState() && !this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue < this.minHue || hue > this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri >= this.minBri && bri <= this.maxBri ? keep : fill;
            }
        } else if (!this.bandPassH.getState() && this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat < this.minSat || sat > this.maxSat || bri < this.minBri || bri > this.maxBri ? keep : fill;
            }
        } else if (!this.bandPassH.getState() && this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat < this.minSat || sat > this.maxSat || bri >= this.minBri && bri <= this.maxBri ? keep : fill;
            }
        } else if (this.bandPassH.getState() && !this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                fillMask[j] = hue < this.minHue || hue > this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri < this.minBri || bri > this.maxBri ? keep : fill;
            }
        }
        if ((ip = imp.getProcessor()) == null) {
            return;
        }
        if (mode == 3) {
            int[] pixels = (int[])ip.getPixels();
            int fcolor = Prefs.blackBackground ? -1 : -16777216;
            int bcolor = Prefs.blackBackground ? -16777216 : -1;
            for (int i = 0; i < this.numPixels; ++i) {
                pixels[i] = fillMask[i] != 0 ? fcolor : bcolor;
            }
        } else {
            ip.setColor(this.thresholdColor());
            ip.fill(fillMaskIP);
        }
    }

    Color thresholdColor() {
        Color color = null;
        switch (mode) {
            case 0: {
                color = Color.red;
                break;
            }
            case 1: {
                color = Color.white;
                break;
            }
            case 2: {
                color = Color.black;
                break;
            }
            case 3: {
                color = Color.black;
            }
        }
        return color;
    }

    void applyStack() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        this.applyingStack = true;
        for (int i = 1; i <= this.numSlices; ++i) {
            imp.setSlice(i);
            if (!this.checkImage()) {
                return;
            }
            this.apply(imp);
        }
        this.applyingStack = false;
    }

    void reset(ImagePlus imp) {
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.reset");
        }
        ImageProcessor ip = imp.getProcessor();
        ImagePlus originalImage = (ImagePlus)imp.getProperty("OriginalImage");
        if (originalImage == null) {
            originalImage = imp.createImagePlus();
            originalImage.setTitle(imp.getTitle() + " (Original)");
            originalImage.setProcessor(ip.duplicate());
            imp.setProperty("OriginalImage", originalImage);
        }
        if (originalImage.getBitDepth() == 24) {
            int[] restore = (int[])originalImage.getProcessor().getPixels();
            int[] pixels = (int[])ip.getPixels();
            for (int i = 0; i < this.numPixels; ++i) {
                pixels[i] = restore[i];
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        ImagePlus imp;
        if (IJ.debugMode) {
            IJ.log("ColorThresholder.windowActivated ");
        }
        if ((imp = WindowManager.getCurrentImage()) == null || imp.getBitDepth() != 24) {
            IJ.beep();
            IJ.showStatus("No RGB image");
        } else {
            this.setup(imp);
            this.filteredB.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        Prefs.set("cthresholder.dark", this.darkBackground.getState());
        ColorThresholder colorThresholder = this;
        synchronized (colorThresholder) {
            this.notify();
        }
    }

    public static void getLab(ImageProcessor ip, byte[] L, byte[] a, byte[] b) {
        ColorSpaceConverter converter = new ColorSpaceConverter();
        int[] pixels = (int[])ip.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            double[] values = converter.RGBtoLAB(pixels[i]);
            int L1 = (int)(values[0] * 2.55);
            int a1 = (int)Math.floor(1.0625 * values[1] + 128.0 + 0.5);
            int b1 = (int)Math.floor(1.0625 * values[2] + 128.0 + 0.5);
            L[i] = (byte)((L1 < 0 ? 0 : (L1 > 255 ? 255 : L1)) & 0xFF);
            a[i] = (byte)((a1 < 0 ? 0 : (a1 > 255 ? 255 : a1)) & 0xFF);
            b[i] = (byte)((b1 < 0 ? 0 : (b1 > 255 ? 255 : b1)) & 0xFF);
        }
    }

    public void getYUV(ImageProcessor ip, byte[] Y, byte[] U, byte[] V) {
        int i = 0;
        int width = ip.getWidth();
        int height = ip.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int c = ip.getPixel(x, y);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                double yf = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
                Y[i] = (byte)Math.floor(yf + 0.5);
                U[i] = (byte)(128 + (int)Math.floor(0.493 * ((double)b - yf) + 0.5));
                V[i] = (byte)(128 + (int)Math.floor(0.877 * ((double)r - yf) + 0.5));
                ++i;
            }
        }
    }

    public static void RGBtoLab() {
        ImagePlus imp = IJ.getImage();
        if (imp.getBitDepth() == 24) {
            imp.setProcessor(ColorThresholder.RGBtoLab(imp.getProcessor()));
        }
    }

    private static ImageProcessor RGBtoLab(ImageProcessor ip) {
        int n = ip.getPixelCount();
        byte[] L = new byte[n];
        byte[] a = new byte[n];
        byte[] b = new byte[n];
        ColorThresholder.getLab(ip, L, a, b);
        ColorProcessor cp = new ColorProcessor(ip.getWidth(), ip.getHeight());
        cp.setRGB(L, a, b);
        return cp;
    }

    public static void RGBtoYUV() {
        ImagePlus imp = IJ.getImage();
        if (imp.getBitDepth() == 24) {
            ColorThresholder.RGBtoLab(imp.getProcessor());
            imp.updateAndDraw();
        }
    }

    static void RGBtoYUV(ImageProcessor ip) {
        int xe = ip.getWidth();
        int ye = ip.getHeight();
        boolean i = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        for (int y = 0; y < ye; ++y) {
            for (int x = 0; x < xe; ++x) {
                int c = ip.getPixel(x, y);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                double yf = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
                int Y = (int)Math.floor(yf + 0.5);
                int U = 128 + (int)Math.floor(0.493 * ((double)b - yf) + 0.5);
                int V = 128 + (int)Math.floor(0.877 * ((double)r - yf) + 0.5);
                ip.putPixel(x, y, (((Y < 0 ? 0 : (Y > 255 ? 255 : Y)) & 0xFF) << 16) + (((U < 0 ? 0 : (U > 255 ? 255 : U)) & 0xFF) << 8) + ((V < 0 ? 0 : (V > 255 ? 255 : V)) & 0xFF));
                ip.putPixel(x, y, ((Y & 0xFF) << 16) + ((U & 0xFF) << 8) + (V & 0xFF));
            }
        }
    }

    static {
        methodNames = AutoThresholder.getMethods();
        method = methodNames[0];
        thresholder = new AutoThresholder();
        modes = new String[]{"Red", "White", "Black", "B&W"};
        mode = 0;
    }

    class BandPlot
    extends Canvas
    implements Measurements,
    MouseListener {
        final int WIDTH = 256;
        final int HEIGHT = 64;
        double minHue = 0.0;
        double minSat = 0.0;
        double minBri = 0.0;
        double maxHue = 255.0;
        double maxSat = 255.0;
        double maxBri = 255.0;
        int[] histogram;
        Color[] hColors;
        int hmax;
        Image os;
        Graphics osg;

        public BandPlot() {
            this.addMouseListener(this);
            this.setSize(257, 65);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(257, 65);
        }

        void setHistogram(ImagePlus imp, int j) {
            block23: {
                block28: {
                    block30: {
                        block29: {
                            block25: {
                                block27: {
                                    block26: {
                                        byte[] b;
                                        byte[] g;
                                        byte[] r;
                                        block21: {
                                            block24: {
                                                block22: {
                                                    ImageProcessor ip = imp.getProcessor();
                                                    ImageStatistics stats = ImageStatistics.getStatistics(ip, 9, null);
                                                    int maxCount2 = 0;
                                                    this.histogram = stats.histogram;
                                                    for (int i = 0; i < stats.nBins; ++i) {
                                                        if (this.histogram[i] <= maxCount2) continue;
                                                        maxCount2 = this.histogram[i];
                                                    }
                                                    this.hmax = (int)((double)maxCount2 * 1.15);
                                                    this.os = null;
                                                    ColorModel cm = ip.getColorModel();
                                                    if (!(cm instanceof IndexColorModel)) {
                                                        return;
                                                    }
                                                    IndexColorModel icm = (IndexColorModel)cm;
                                                    int mapSize = icm.getMapSize();
                                                    if (mapSize != 256) {
                                                        return;
                                                    }
                                                    r = new byte[256];
                                                    g = new byte[256];
                                                    b = new byte[256];
                                                    icm.getReds(r);
                                                    icm.getGreens(g);
                                                    icm.getBlues(b);
                                                    this.hColors = new Color[256];
                                                    if (ColorThresholder.this.colorSpace != 1) break block21;
                                                    if (j != 0) break block22;
                                                    for (int i = 0; i < 256; ++i) {
                                                        this.hColors[i] = new Color(i & 0xFF, 0, 0);
                                                    }
                                                    break block23;
                                                }
                                                if (j != 1) break block24;
                                                for (int i = 0; i < 256; ++i) {
                                                    this.hColors[i] = new Color(0, i & 0xFF, 0);
                                                }
                                                break block23;
                                            }
                                            if (j != 2) break block23;
                                            for (int i = 0; i < 256; ++i) {
                                                this.hColors[i] = new Color(0, 0, i & 0xFF);
                                            }
                                            break block23;
                                        }
                                        if (ColorThresholder.this.colorSpace != 0) break block25;
                                        if (j != 0) break block26;
                                        for (int i = 0; i < 256; ++i) {
                                            this.hColors[i] = new Color(r[i] & 0xFF, g[i] & 0xFF, b[i] & 0xFF);
                                        }
                                        break block23;
                                    }
                                    if (j != 1) break block27;
                                    for (int i = 0; i < 256; ++i) {
                                        this.hColors[i] = new Color(255, 255 - i & 0xFF, 255 - i & 0xFF);
                                    }
                                    break block23;
                                }
                                if (j != 2) break block23;
                                for (int i = 0; i < 256; ++i) {
                                    this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                                }
                                break block23;
                            }
                            if (ColorThresholder.this.colorSpace != 2) break block28;
                            if (j != 0) break block29;
                            for (int i = 0; i < 256; ++i) {
                                this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                            }
                            break block23;
                        }
                        if (j != 1) break block30;
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, 255 - i & 0xFF, 0);
                        }
                        break block23;
                    }
                    if (j != 2) break block23;
                    for (int i = 0; i < 256; ++i) {
                        this.hColors[i] = new Color(i & 0xFF, i & 0xFF, 255 - i & 0xFF);
                    }
                    break block23;
                }
                if (ColorThresholder.this.colorSpace == 3) {
                    if (j == 0) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                        }
                    } else if (j == 1) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color((int)(36.0 + (double)(255 - i) / 1.4) & 0xFF, 255 - i & 0xFF, i & 0xFF);
                        }
                    } else if (j == 2) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, 255 - i & 0xFF, (int)(83.0 + (double)(255 - i) / 2.87) & 0xFF);
                        }
                    }
                }
            }
        }

        int[] getHistogram() {
            return this.histogram;
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            int hHist = 0;
            if (this.histogram != null) {
                if (this.os == null) {
                    this.os = this.createImage(256, 64);
                    this.osg = this.os.getGraphics();
                    this.osg.setColor(new Color(140, 152, 144));
                    this.osg.fillRect(0, 0, 256, 64);
                    for (int i = 0; i < 256; ++i) {
                        if (this.hColors != null) {
                            this.osg.setColor(this.hColors[i]);
                        }
                        hHist = 64 - 64 * this.histogram[i] / this.hmax - 6;
                        this.osg.drawLine(i, 64, i, hHist);
                        this.osg.setColor(Color.black);
                        this.osg.drawLine(i, hHist, i, hHist);
                    }
                    this.osg.dispose();
                }
                if (this.os != null) {
                    g.drawImage(this.os, 0, 0, this);
                }
            } else {
                g.setColor(Color.white);
                g.fillRect(0, 0, 256, 64);
            }
            g.setColor(Color.black);
            g.drawLine(0, 58, 256, 58);
            g.drawRect(0, 0, 256, 64);
            g.drawRect((int)this.minHue, 1, (int)(this.maxHue - this.minHue), 57);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }
}

