/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.plugin.frame.Recorder;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;

public class PlotDialog
implements DialogListener {
    public static final int SET_RANGE = 0;
    public static final int AXIS_OPTIONS = 1;
    public static final int LEGEND = 2;
    public static final int HI_RESOLUTION = 3;
    public static final int TEMPLATE = 4;
    public static final int X_LEFT = 10;
    public static final int X_RIGHT = 11;
    public static final int Y_BOTTOM = 12;
    public static final int Y_TOP = 13;
    public static final int X_AXIS = 14;
    public static final int Y_AXIS = 15;
    private static final String[] HEADINGS = new String[]{"Plot Range", "Axis Options", "Add Legend", "High-Resolution Plot", "Use Template", null, null, null, null, null, "X Left", "X Right", "Y Bottom", "Y Top", "X Axis", "Y Axis"};
    private static final String[] LEGEND_POSITIONS = new String[]{"Auto", "Top-Left", "Top-Right", "Bottom-Left", "Bottom-Right", "No Legend"};
    private static final int[] LEGEND_POSITION_N = new int[]{128, 144, 160, 176, 192, 0};
    private static final String[] TEMPLATE_FLAG_NAMES = new String[]{"X Range", "Y Range", "Axis Style", "Labels", "Legend", "Contents Style", "Extra Objects (Curves...)", "Window Size"};
    private static final int[] TEMPLATE_FLAGS = new int[]{1, 2, 128, 32, 64, 256, 512, 16};
    private Plot plot;
    private int dialogType;
    private boolean minMaxSaved;
    private boolean dialogShowing;
    private Plot[] templatePlots;
    private Checkbox xLogCheckbox;
    private Checkbox yLogCheckbox;
    private static int legendPosNumber = 0;
    private static boolean bottomUp;
    private static boolean transparentBackground;
    private static String lastXLabel;
    private static String lastYLabel;
    private static float plotFontSize;
    private static float hiResFactor;
    private static boolean hiResAntiAliased;
    private static int templateID;
    private static int lastTemplateFlags;

    public PlotDialog(Plot plot, int dialogType) {
        this.plot = plot;
        this.dialogType = dialogType;
    }

    public void showDialog(Frame parent) {
        ImagePlus imp;
        ImageWindow win;
        GenericDialog gd;
        if (this.dialogType == 3) {
            this.doHighResolutionDialog(parent);
            return;
        }
        this.plot.savePlotPlotProperties();
        if (this.dialogType == 4) {
            this.plot.savePlotObjects();
        }
        String dialogTitle = this.dialogType >= 10 && this.dialogType <= 13 ? "Set Axis Limit..." : HEADINGS[this.dialogType] + "...";
        GenericDialog genericDialog = gd = parent == null ? new GenericDialog(dialogTitle) : new GenericDialog(dialogTitle, parent);
        if (!this.setupDialog(gd)) {
            return;
        }
        gd.addDialogListener(this);
        this.dialogItemChanged(gd, null);
        this.dialogShowing = true;
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.plot.restorePlotProperties();
            if (this.dialogType == 4) {
                this.plot.restorePlotObjects();
            }
            this.plot.update();
        } else {
            if (Recorder.record) {
                this.record();
            }
            String xAxisLabel = this.plot.getLabel('x');
            if ((this.dialogType == 1 || this.dialogType == 14) && xAxisLabel != null && xAxisLabel.length() > 0) {
                lastXLabel = xAxisLabel;
            }
            String yAxisLabel = this.plot.getLabel('y');
            if ((this.dialogType == 1 || this.dialogType == 15) && yAxisLabel != null && yAxisLabel.length() > 0) {
                lastYLabel = yAxisLabel;
            }
            if (this.dialogType == 0 || this.dialogType == 14 || this.dialogType == 15) {
                this.plot.makeLimitsDefault();
            }
            if (this.dialogType == 4) {
                lastTemplateFlags = this.plot.templateFlags;
            }
        }
        this.plot.killPlotPropertiesSnapshot();
        if (this.dialogType == 4) {
            this.plot.killPlotObjectsSnapshot();
        }
        ImageWindow imageWindow = win = (imp = this.plot.getImagePlus()) == null ? null : imp.getWindow();
        if (win instanceof PlotWindow) {
            ((PlotWindow)win).hideRangeArrows();
        }
        if (!gd.wasCanceled() && !gd.wasOKed()) {
            int newDialogType = this.dialogType == 0 ? 1 : 0;
            new PlotDialog(this.plot, newDialogType).showDialog(parent);
        }
    }

    private boolean setupDialog(GenericDialog gd) {
        int yDigits;
        int xDigits;
        double[] currentMinMax = this.plot.getLimits();
        boolean livePlot = this.plot.plotMaker != null;
        int n = xDigits = this.plot.logXAxis ? -2 : Plot.getDigits(currentMinMax[0], currentMinMax[1], 0.005 * Math.abs(currentMinMax[1] - currentMinMax[0]), 6, 0);
        if (this.dialogType == 0 || this.dialogType == 14) {
            gd.addNumericField("X_From", currentMinMax[0], xDigits, 6, "*");
            gd.addToSameRow();
            gd.addNumericField("To", currentMinMax[1], xDigits, 6, "*");
            gd.setInsets(0, 20, 0);
            if (livePlot) {
                gd.addCheckbox("Fix_X Range While Live", (this.plot.templateFlags & 1) != 0);
            }
            gd.addCheckbox("Log_X Axis  **", this.plot.hasFlag(1024));
            this.xLogCheckbox = this.lastCheckboxAdded(gd);
            this.enableDisableLogCheckbox(this.xLogCheckbox, currentMinMax[0], currentMinMax[1]);
        }
        int n2 = yDigits = this.plot.logYAxis ? -2 : Plot.getDigits(currentMinMax[2], currentMinMax[3], 0.005 * Math.abs(currentMinMax[3] - currentMinMax[2]), 6, 0);
        if (this.dialogType == 0 || this.dialogType == 15) {
            gd.setInsets(20, 0, 3);
            gd.addNumericField("Y_From", currentMinMax[2], yDigits, 6, "*");
            gd.addToSameRow();
            gd.addNumericField("To", currentMinMax[3], yDigits, 6, "*");
            if (livePlot) {
                gd.addCheckbox("Fix_Y Range While Live", (this.plot.templateFlags & 2) != 0);
            }
            gd.addCheckbox("Log_Y Axis  **", this.plot.hasFlag(2048));
            this.yLogCheckbox = this.lastCheckboxAdded(gd);
            this.enableDisableLogCheckbox(this.yLogCheckbox, currentMinMax[2], currentMinMax[3]);
        }
        if (this.dialogType >= 10 && this.dialogType <= 13) {
            int digits = this.dialogType < 12 ? xDigits : yDigits;
            gd.addNumericField(HEADINGS[this.dialogType], currentMinMax[this.dialogType - 10], digits, 6, "*");
        }
        if (this.dialogType == 1 || this.dialogType == 14 || this.dialogType == 15) {
            String[] stringArray;
            int flags = this.plot.getFlags();
            String[] labels = new String[]{" Draw Grid", " Major Ticks", " Minor Ticks", " Ticks if Logarithmic", " Numbers"};
            int[] xFlags = new int[]{16, 4, 256, 4096, 1};
            int rows = xFlags.length;
            int columns = this.dialogType == 1 ? 2 : 1;
            String[] allLabels = new String[rows * columns];
            boolean[] defaultValues = new boolean[rows * columns];
            if (this.dialogType == 1) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "X Axis";
                stringArray = stringArray2;
                stringArray2[1] = "Y Axis";
            } else {
                stringArray = null;
            }
            String[] headings = stringArray;
            int i = 0;
            for (int l = 0; l < xFlags.length; ++l) {
                String label = labels[l];
                boolean xFlag = this.getFlag(flags, xFlags[l]);
                boolean yFlag = this.getFlag(flags, xFlags[l] << 1);
                if (this.dialogType == 1 || this.dialogType == 14) {
                    allLabels[i] = labels[l];
                    defaultValues[i++] = xFlag;
                }
                if (this.dialogType != 1 && this.dialogType != 15) continue;
                allLabels[i] = labels[l];
                defaultValues[i++] = yFlag;
            }
            if (this.dialogType == 14 || this.dialogType == 15) {
                gd.setInsets(15, 20, 0);
            }
            gd.addCheckboxGroup(rows, columns, allLabels, defaultValues, headings);
            if (this.dialogType == 1) {
                gd.setInsets(15, 0, 5);
            }
            String plotXLabel = this.plot.getLabel('x');
            String plotYLabel = this.plot.getLabel('y');
            if ((plotXLabel == null || plotXLabel.equals("Distance (pixels)") || plotXLabel.equals("Distance ( )")) && lastXLabel != null) {
                plotXLabel = lastXLabel;
            }
            if ((plotYLabel == null || plotYLabel.equals("Gray Value")) && lastYLabel != null) {
                plotYLabel = lastYLabel;
            }
            int nChars = 20;
            if (plotXLabel != null && plotXLabel.startsWith("{") || plotYLabel != null && plotYLabel.startsWith("{")) {
                nChars = Math.max(nChars, plotXLabel.length());
                nChars = Math.max(nChars, plotYLabel.length());
            }
            if (nChars > 80) {
                nChars = 80;
            }
            if (this.dialogType == 1 || this.dialogType == 14) {
                gd.addStringField("X Axis Label", plotXLabel, nChars);
            }
            if (this.dialogType == 1 || this.dialogType == 15) {
                gd.addStringField("Y Axis Label", plotYLabel, nChars);
            }
        }
        if (this.dialogType == 0 || this.dialogType == 14 || this.dialogType == 15) {
            Font smallFont = new Font("SansSerif", 0, (int)(10.0 * Prefs.getGuiScale()));
            gd.setInsets(10, 0, 0);
            gd.addMessage("*   Leave empty for automatic range", smallFont, Color.gray);
            gd.setInsets(0, 0, 0);
            gd.addMessage("** Requires limits > 0 and max/min > 3", smallFont, Color.gray);
            if (this.dialogType == 14 || this.dialogType == 15) {
                gd.setInsets(0, 0, 0);
                gd.addMessage("    Label supports !!sub-!! and ^^superscript^^", smallFont, Color.gray);
            }
        }
        if (this.dialogType == 1) {
            Font numberFont;
            Font plotFont = this.plot.currentFont != null ? this.plot.currentFont : this.plot.defaultFont;
            Font labelFont = this.plot.getFont('x');
            if (labelFont == null) {
                labelFont = plotFont;
            }
            if ((numberFont = this.plot.getFont('f')) == null) {
                numberFont = plotFont;
            }
            gd.addNumericField("Number Font Size", numberFont.getSize2D(), 1);
            gd.addNumericField("Label Font Size", labelFont.getSize2D(), 1);
            gd.addToSameRow();
            gd.addCheckbox("Bold", labelFont.isBold());
        }
        if (this.dialogType == 2) {
            int lFlags;
            String labels = this.plot.getDataLabels();
            int nLines = labels.split("\n", -1).length;
            Font legendFont = this.plot.getFont('l');
            if (legendFont == null) {
                Font font = legendFont = this.plot.currentFont != null ? this.plot.currentFont : this.plot.defaultFont;
            }
            if ((lFlags = this.plot.getObjectFlags('l')) != -1) {
                for (int i = 0; i < LEGEND_POSITION_N.length; ++i) {
                    if ((lFlags & 0xF0) != LEGEND_POSITION_N[i]) continue;
                    legendPosNumber = i;
                    break;
                }
                transparentBackground = this.getFlag(lFlags, 512);
                bottomUp = this.getFlag(lFlags, 256);
            }
            gd.addMessage("Enter Labels for the datasets, one per line.\n");
            gd.addTextAreas(labels, null, Math.min(nLines + 1, 20), 40);
            gd.addChoice("Legend position", LEGEND_POSITIONS, LEGEND_POSITIONS[legendPosNumber]);
            gd.addNumericField("Font Size", legendFont.getSize2D(), 1);
            gd.addCheckbox("Transparent background", transparentBackground);
            gd.addCheckbox("Bottom-to-top", bottomUp);
        }
        if (this.dialogType == 4) {
            int i;
            int[] idList = WindowManager.getIDList();
            int[] plotIdList = new int[idList.length];
            this.templatePlots = new Plot[idList.length];
            int nPlots = 0;
            for (int id : idList) {
                Plot impPlot;
                ImagePlus imp = WindowManager.getImage(id);
                if (imp == null || (impPlot = (Plot)imp.getProperty("thePlot")) == null || impPlot == this.plot) continue;
                this.templatePlots[nPlots] = impPlot;
                plotIdList[nPlots++] = id;
            }
            if (nPlots == 0) {
                IJ.error("No plot to use as template");
                return false;
            }
            String[] plotImpTitles = new String[nPlots];
            int defaultTemplateIndex = 0;
            for (i = 0; i < nPlots; ++i) {
                ImagePlus imp = WindowManager.getImage(plotIdList[i]);
                String string = plotImpTitles[i] = imp == null ? "" : imp.getTitle();
                if (imp.getID() != templateID) continue;
                defaultTemplateIndex = i;
            }
            gd.addChoice("Template Plot", plotImpTitles, plotImpTitles[defaultTemplateIndex]);
            gd.setInsets(10, 0, 0);
            gd.addMessage("Copy From Template:");
            gd.setInsets(5, 20, 0);
            if (lastTemplateFlags == 0) {
                lastTemplateFlags = 384;
            }
            for (i = 0; i < TEMPLATE_FLAGS.length; ++i) {
                boolean flag = this.getFlag(lastTemplateFlags, TEMPLATE_FLAGS[i]);
                gd.addCheckbox(TEMPLATE_FLAG_NAMES[i], flag);
            }
        }
        if (this.dialogType >= 10 && this.dialogType <= 13) {
            gd.enableYesNoCancel("OK", "Set All Limits...");
        } else if (this.dialogType == 1) {
            gd.enableYesNoCancel("OK", "Set Range...");
        } else if (this.dialogType == 0) {
            gd.enableYesNoCancel("OK", "Set Axis Options...");
        }
        return true;
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        double[] currentMinMax;
        boolean livePlot;
        if (this.dialogShowing && e == null) {
            return true;
        }
        boolean bl = livePlot = this.plot.plotMaker != null;
        if (this.dialogType == 0 || this.dialogType == 14) {
            double linXMax;
            currentMinMax = this.plot.getLimits();
            double linXMin = gd.getNextNumber();
            if (linXMin == (linXMax = gd.getNextNumber())) {
                return false;
            }
            if (!this.minMaxSaved) {
                this.plot.saveMinMax();
                this.minMaxSaved = true;
            }
            if (livePlot) {
                this.plot.templateFlags = this.setFlag(this.plot.templateFlags, 1, gd.getNextBoolean());
            }
            boolean xLog = gd.getNextBoolean();
            this.plot.setAxisXLog(xLog);
            this.plot.setLimitsNoUpdate(linXMin, linXMax, currentMinMax[2], currentMinMax[3]);
            currentMinMax = this.plot.getLimits();
            this.enableDisableLogCheckbox(this.xLogCheckbox, currentMinMax[0], currentMinMax[1]);
        }
        if (this.dialogType == 0 || this.dialogType == 15) {
            double linYMax;
            currentMinMax = this.plot.getLimits();
            double linYMin = gd.getNextNumber();
            if (linYMin == (linYMax = gd.getNextNumber())) {
                return false;
            }
            if (!this.minMaxSaved) {
                this.plot.saveMinMax();
                this.minMaxSaved = true;
            }
            if (livePlot) {
                this.plot.templateFlags = this.setFlag(this.plot.templateFlags, 2, gd.getNextBoolean());
            }
            boolean yLog = gd.getNextBoolean();
            this.plot.setAxisYLog(yLog);
            this.plot.setLimitsNoUpdate(currentMinMax[0], currentMinMax[1], linYMin, linYMax);
            currentMinMax = this.plot.getLimits();
            this.enableDisableLogCheckbox(this.yLogCheckbox, currentMinMax[2], currentMinMax[3]);
        }
        if (this.dialogType >= 10 && this.dialogType <= 13) {
            double newLimit = gd.getNextNumber();
            double[] minMaxCopy = (double[])this.plot.getLimits().clone();
            minMaxCopy[this.dialogType - 10] = newLimit;
            this.plot.setLimitsNoUpdate(minMaxCopy[0], minMaxCopy[1], minMaxCopy[2], minMaxCopy[3]);
        }
        if (this.dialogType == 1 || this.dialogType == 14 || this.dialogType == 15) {
            int[] xFlags = new int[]{16, 4, 256, 4096, 1};
            int rows = xFlags.length;
            int columns = this.dialogType == 1 ? 2 : 1;
            int flags = 0;
            if (this.dialogType == 14) {
                flags = this.plot.getFlags() & 0xAAAAAAAA;
            }
            if (this.dialogType == 15) {
                flags = this.plot.getFlags() & 0x55555555;
            }
            for (int l = 0; l < xFlags.length; ++l) {
                if ((this.dialogType == 1 || this.dialogType == 14) && gd.getNextBoolean()) {
                    flags |= xFlags[l];
                }
                if (this.dialogType != 1 && this.dialogType != 15 || !gd.getNextBoolean()) continue;
                flags |= xFlags[l] << 1;
            }
            this.plot.setFormatFlags(flags);
            String xAxisLabel = this.plot.getLabel('x');
            String yAxisLabel = this.plot.getLabel('y');
            if (this.dialogType == 1 || this.dialogType == 14) {
                xAxisLabel = gd.getNextString();
            }
            if (this.dialogType == 1 || this.dialogType == 15) {
                yAxisLabel = gd.getNextString();
            }
            this.plot.setXYLabels(xAxisLabel, yAxisLabel);
        }
        if (this.dialogType == 1) {
            Font numberFont;
            Font plotFont = this.plot.currentFont != null ? this.plot.currentFont : this.plot.defaultFont;
            Font labelFont = this.plot.getFont('x');
            if (labelFont == null) {
                labelFont = plotFont;
            }
            if ((numberFont = this.plot.getFont('f')) == null) {
                numberFont = plotFont;
            }
            float numberFontSize = (float)gd.getNextNumber();
            if (gd.invalidNumber()) {
                numberFontSize = numberFont.getSize2D();
            }
            if (numberFontSize < 9.0f) {
                numberFontSize = 9.0f;
            }
            if (numberFontSize > 24.0f) {
                numberFontSize = 24.0f;
            }
            float labelFontSize = (float)gd.getNextNumber();
            if (gd.invalidNumber()) {
                labelFontSize = labelFont.getSize2D();
            }
            boolean axisLabelBold = gd.getNextBoolean();
            this.plot.setFont('f', numberFont.deriveFont(numberFont.getStyle(), numberFontSize));
            this.plot.setAxisLabelFont(axisLabelBold ? 1 : 0, labelFontSize);
            Font smallFont = new Font("SansSerif", 0, (int)(10.0 * Prefs.getGuiScale()));
            gd.addMessage("Labels support !!sub-!! and ^^superscript^^", smallFont, Color.gray);
        }
        if (this.dialogType == 2) {
            Font legendFont = this.plot.getFont('l');
            if (legendFont == null) {
                legendFont = this.plot.currentFont != null ? this.plot.currentFont : this.plot.defaultFont;
            }
            String labels = gd.getNextText();
            legendPosNumber = gd.getNextChoiceIndex();
            int lFlags = LEGEND_POSITION_N[legendPosNumber];
            float legendFontSize = (float)gd.getNextNumber();
            transparentBackground = gd.getNextBoolean();
            bottomUp = gd.getNextBoolean();
            if (bottomUp) {
                lFlags |= 0x100;
            }
            if (transparentBackground) {
                lFlags |= 0x200;
            }
            this.plot.setColor(Color.black);
            this.plot.setLineWidth(1);
            this.plot.setLegend(labels, lFlags);
            this.plot.setFont('l', legendFont.deriveFont(legendFont.getStyle(), legendFontSize));
        }
        if (this.dialogType == 4) {
            Plot templatePlot = this.templatePlots[gd.getNextChoiceIndex()];
            ImagePlus imp = templatePlot.getImagePlus();
            if (imp != null) {
                templateID = imp.getID();
            }
            int templateFlags = 0;
            for (int i = 0; i < TEMPLATE_FLAGS.length; ++i) {
                if (!gd.getNextBoolean()) continue;
                templateFlags |= TEMPLATE_FLAGS[i];
            }
            this.plot.restorePlotProperties();
            this.plot.restorePlotObjects();
            this.plot.useTemplate(templatePlot, templateFlags);
        }
        this.plot.updateImage();
        return true;
    }

    private void record() {
        String plotDot;
        if (Recorder.scriptMode()) {
            Recorder.recordCall("//plot = IJ.getImage().getProperty(Plot.PROPERTY_KEY);");
        }
        String string = plotDot = Recorder.scriptMode() ? "plot." : "Plot.";
        if (this.dialogType == 0 || this.dialogType == 14) {
            Recorder.recordString(plotDot + (Recorder.scriptMode() ? "setAxisXLog(" : "setLogScaleX(") + this.plot.hasFlag(1024) + ");\n");
        }
        if (this.dialogType == 0 || this.dialogType == 15) {
            Recorder.recordString(plotDot + (Recorder.scriptMode() ? "setAxisYLog(" : "setLogScaleY(") + this.plot.hasFlag(2048) + ");\n");
        }
        if (this.dialogType == 0 || this.dialogType == 14 || this.dialogType == 15) {
            double[] currentMinMax = this.plot.getLimits();
            int xDigits = this.plot.logXAxis ? -2 : Plot.getDigits(currentMinMax[0], currentMinMax[1], 0.005 * Math.abs(currentMinMax[1] - currentMinMax[0]), 6, 0);
            int yDigits = this.plot.logYAxis ? -2 : Plot.getDigits(currentMinMax[2], currentMinMax[3], 0.005 * Math.abs(currentMinMax[3] - currentMinMax[2]), 6, 0);
            Recorder.recordString(plotDot + "setLimits(" + IJ.d2s(currentMinMax[0], xDigits) + "," + IJ.d2s(currentMinMax[1], xDigits) + "," + IJ.d2s(currentMinMax[2], yDigits) + "," + IJ.d2s(currentMinMax[3], yDigits) + ");\n");
        }
        if (this.dialogType == 1 || this.dialogType == 14 || this.dialogType == 15) {
            int flags = this.plot.getFlags();
            String xAxisLabel = Recorder.fixString(this.plot.getLabel('x'));
            String yAxisLabel = Recorder.fixString(this.plot.getLabel('y'));
            Font labelFont = this.plot.getFont('x');
            Font numberFont = this.plot.getFont('f');
            if (labelFont != null) {
                if (Recorder.scriptMode()) {
                    Recorder.recordString("plot.setAxisLabelFont(" + (labelFont.isBold() ? "Font.BOLD," : "Font.PLAIN,") + IJ.d2s(labelFont.getSize2D(), 1) + ");\n");
                } else {
                    Recorder.recordString("Plot.setAxisLabelSize(" + IJ.d2s(labelFont.getSize2D(), 1) + ", \"" + (labelFont.isBold() ? "bold" : "plain") + "\");\n");
                }
            }
            if (numberFont != null) {
                Recorder.recordString(plotDot + (Recorder.scriptMode() ? "setFont(-1, " : "setFontSize(") + IJ.d2s(numberFont.getSize2D(), 1) + ");\n");
            }
            Recorder.recordString(plotDot + "setXYLabels(\"" + xAxisLabel + "\", \"" + yAxisLabel + "\");\n");
            Recorder.recordString(plotDot + "setFormatFlags(" + (Recorder.scriptMode() ? "0x" + Integer.toHexString(flags) : '\"' + Integer.toString(flags, 2) + '\"') + ");\n");
        }
        if (this.dialogType == 2) {
            String labels = Recorder.fixString(this.plot.getDataLabels());
            int lFlags = this.plot.getObjectFlags('l');
            if (Recorder.scriptMode()) {
                Recorder.recordCall("plot.setColor(Color.black);");
                Recorder.recordCall("plot.setLineWidth(1);");
                Recorder.recordCall("plot.addLegend(\"" + labels + "\", 0x" + Integer.toHexString(lFlags) + ");");
            } else {
                String options = LEGEND_POSITIONS[legendPosNumber];
                if (this.getFlag(lFlags, 256)) {
                    options = options + " Bottom-To-Top";
                }
                if (this.getFlag(lFlags, 512)) {
                    options = options + " Transparent";
                }
                Recorder.recordString("Plot.addLegend(\"" + labels + "\", \"" + options + "\");\n");
            }
        }
        if (Recorder.scriptMode()) {
            Recorder.recordCall("plot.update();");
        }
    }

    private void doHighResolutionDialog(Frame parent) {
        GenericDialog gd = parent == null ? new GenericDialog(HEADINGS[this.dialogType]) : new GenericDialog(HEADINGS[this.dialogType], parent);
        String title = this.plot.getTitle() + "_HiRes";
        title = WindowManager.makeUniqueName(title);
        gd.addStringField("Title: ", title, 20);
        gd.addNumericField("Scale factor", hiResFactor, 1);
        gd.addCheckbox("Disable anti-aliased text", !hiResAntiAliased);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        title = gd.getNextString();
        double scale = gd.getNextNumber();
        if (!gd.invalidNumber() && scale > 0.0) {
            hiResFactor = (float)scale;
        }
        hiResAntiAliased = !gd.getNextBoolean();
        final ImagePlus hiresImp = this.plot.makeHighResolution(title, hiResFactor, hiResAntiAliased, true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IJ.selectWindow(hiresImp.getID());
            }
        });
        if (Recorder.record) {
            String options;
            String string = options = !hiResAntiAliased ? "disable" : "";
            if (options.length() > 0) {
                options = ",\"" + options + "\"";
            }
            Recorder.recordString("Plot.makeHighResolution(\"" + title + "\"," + hiResFactor + options + ");\n");
        }
    }

    void enableDisableLogCheckbox(Checkbox checkbox, double limit1, double limit2) {
        boolean logPossible = limit1 > 0.0 && limit2 > 0.0 && (limit1 > 3.0 * limit2 || limit2 > 3.0 * limit1);
        checkbox.setEnabled(logPossible);
    }

    boolean getFlag(int flags, int bitMask) {
        return (flags & bitMask) != 0;
    }

    int setFlag(int flags, int bitMask, boolean state) {
        flags &= ~bitMask;
        if (state) {
            flags |= bitMask;
        }
        return flags;
    }

    Checkbox lastCheckboxAdded(GenericDialog gd) {
        Vector checkboxes = gd.getCheckboxes();
        return (Checkbox)checkboxes.get(checkboxes.size() - 1);
    }

    static {
        hiResFactor = 4.0f;
        hiResAntiAliased = true;
        lastTemplateFlags = 384;
    }
}

