/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.EllipseRoi;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.RoiListener;
import ij.gui.RotatedRectRoi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.LutLoader;
import ij.plugin.RectToolOptions;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.PolygonFiller;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public class Roi
implements Cloneable,
Serializable,
Iterable<Point> {
    public static final int CONSTRUCTING = 0;
    public static final int MOVING = 1;
    public static final int RESIZING = 2;
    public static final int NORMAL = 3;
    public static final int MOVING_HANDLE = 4;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int TRACED_ROI = 4;
    public static final int LINE = 5;
    public static final int POLYLINE = 6;
    public static final int FREELINE = 7;
    public static final int ANGLE = 8;
    public static final int COMPOSITE = 9;
    public static final int POINT = 10;
    public static final int HANDLE_SIZE = 5;
    public static final int NOT_PASTING = -1;
    public static final int FERET_ARRAYSIZE = 16;
    public static final int FERET_ARRAY_POINTOFFSET = 8;
    static final int NO_MODS = 0;
    static final int ADD_TO_ROI = 1;
    static final int SUBTRACT_FROM_ROI = 2;
    int startX;
    int startY;
    int x;
    int y;
    int width;
    int height;
    double startXD;
    double startYD;
    Rectangle2D.Double bounds;
    int activeHandle;
    int state;
    int modState = 0;
    int cornerDiameter;
    int previousSX;
    int previousSY;
    public static Roi previousRoi;
    public static final BasicStroke onePixelWide;
    protected static Color ROIColor;
    protected static int pasteMode;
    protected static int lineWidth;
    protected static Color defaultFillColor;
    private static Vector listeners;
    private static LUT glasbeyLut;
    private static int defaultGroup;
    private static Color groupColor;
    private static double defaultStrokeWidth;
    protected int type;
    protected int xMax;
    protected int yMax;
    protected ImagePlus imp;
    private int imageID;
    protected ImageCanvas ic;
    protected int oldX;
    protected int oldY;
    protected int oldWidth;
    protected int oldHeight;
    protected int clipX;
    protected int clipY;
    protected int clipWidth;
    protected int clipHeight;
    protected ImagePlus clipboard;
    protected boolean constrain;
    protected boolean center;
    protected boolean aspect;
    protected boolean updateFullWindow;
    protected double mag = 1.0;
    protected double asp_bk;
    protected ImageProcessor cachedMask;
    protected Color handleColor = Color.white;
    protected Color strokeColor;
    protected Color instanceColor;
    protected Color fillColor;
    protected BasicStroke stroke;
    protected boolean nonScalable;
    protected boolean overlay;
    protected boolean wideLine;
    protected boolean ignoreClipRect;
    protected double flattenScale = 1.0;
    protected static Color defaultColor;
    private String name;
    private int position;
    private int channel;
    private int slice;
    private int frame;
    private boolean hyperstackPosition;
    private Overlay prototypeOverlay;
    private boolean subPixel;
    private boolean activeOverlayRoi;
    private Properties props;
    private boolean isCursor;
    private double xcenter = Double.NaN;
    private double ycenter;
    private boolean listenersNotified;
    private boolean antiAlias = true;
    private int group;
    private boolean usingDefaultStroke;
    private static int defaultHandleSize;
    private int handleSize = -1;
    private boolean scaleStrokeWidth;

    public Roi(int x, int y, int width, int height) {
        this(x, y, width, height, 0);
    }

    public Roi(double x, double y, double width, double height) {
        this(x, y, width, height, 0);
    }

    public Roi(int x, int y, int width, int height, int cornerDiameter) {
        double defaultWidth;
        this.setImage(null);
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        if (width > this.xMax) {
            width = this.xMax;
        }
        if (height > this.yMax) {
            height = this.yMax;
        }
        this.cornerDiameter = cornerDiameter;
        this.x = x;
        this.y = y;
        this.startX = x;
        this.startY = y;
        this.oldX = x;
        this.oldY = y;
        this.oldWidth = 0;
        this.oldHeight = 0;
        this.width = width;
        this.height = height;
        this.oldWidth = width;
        this.oldHeight = height;
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
        this.state = 3;
        this.type = 0;
        if (this.ic != null) {
            Graphics g = this.ic.getGraphics();
            this.draw(g);
            g.dispose();
        }
        if ((defaultWidth = Roi.defaultStrokeWidth()) > 0.0) {
            this.stroke = new BasicStroke((float)defaultWidth);
            this.usingDefaultStroke = true;
        }
        this.fillColor = defaultFillColor;
        this.group = defaultGroup;
        if (defaultGroup > 0) {
            this.strokeColor = groupColor;
        }
    }

    public Roi(double x, double y, double width, double height, int cornerDiameter) {
        this((int)x, (int)y, (int)Math.ceil(width), (int)Math.ceil(height), cornerDiameter);
        this.bounds = new Rectangle2D.Double(x, y, width, height);
        this.subPixel = true;
    }

    public Roi(Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Roi(int sx, int sy, ImagePlus imp) {
        this(sx, sy, imp, 0);
    }

    public Roi(int sx, int sy, ImagePlus imp, int cornerDiameter) {
        double defaultWidth;
        this.setImage(imp);
        int ox = sx;
        int oy = sy;
        if (this.ic != null) {
            ox = this.ic.offScreenX2(sx);
            oy = this.ic.offScreenY2(sy);
        }
        this.setLocation(ox, oy);
        this.cornerDiameter = cornerDiameter;
        this.width = 0;
        this.height = 0;
        this.state = 0;
        this.type = 0;
        if (cornerDiameter > 0) {
            Color scolor;
            double swidth = RectToolOptions.getDefaultStrokeWidth();
            if (swidth > 0.0) {
                this.setStrokeWidth(swidth);
            }
            if ((scolor = RectToolOptions.getDefaultStrokeColor()) != null) {
                this.setStrokeColor(scolor);
            }
        }
        if ((defaultWidth = Roi.defaultStrokeWidth()) > 0.0) {
            this.stroke = new BasicStroke((float)defaultWidth);
            this.usingDefaultStroke = true;
        }
        this.fillColor = defaultFillColor;
        this.group = defaultGroup;
        if (defaultGroup > 0) {
            this.strokeColor = groupColor;
        }
    }

    public static Roi create(double x, double y, double width, double height) {
        return new Roi(x, y, width, height);
    }

    public static Roi create(double x, double y, double width, double height, int cornerDiameter) {
        return new Roi(x, y, width, height, cornerDiameter);
    }

    public Roi(int x, int y, int width, int height, ImagePlus imp) {
        this(x, y, width, height);
        this.setImage(imp);
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        this.startX = x;
        this.startY = y;
        this.oldX = x;
        this.oldY = y;
        this.oldWidth = 0;
        this.oldHeight = 0;
        if (this.bounds != null) {
            if (!Roi.isInteger(this.bounds.x) || !Roi.isInteger(this.bounds.y)) {
                this.cachedMask = null;
                this.width = (int)Math.ceil(this.bounds.width);
                this.height = (int)Math.ceil(this.bounds.height);
            }
            this.bounds.x = x;
            this.bounds.y = y;
        }
    }

    public void setLocation(double x, double y) {
        this.setLocation((int)x, (int)y);
        if (Roi.isInteger(x) && Roi.isInteger(y)) {
            return;
        }
        if (this.bounds != null) {
            if (!Roi.isInteger(x - this.bounds.x) || !Roi.isInteger(y - this.bounds.y)) {
                this.cachedMask = null;
                this.width = (int)Math.ceil(this.bounds.x + this.bounds.width) - this.x;
                this.height = (int)Math.ceil(this.bounds.y + this.bounds.height) - this.y;
            }
            this.bounds.x = x;
            this.bounds.y = y;
        } else {
            this.cachedMask = null;
            this.bounds = new Rectangle2D.Double(x, y, this.width, this.height);
        }
        this.subPixel = true;
    }

    public void setImage(ImagePlus imp) {
        this.imp = imp;
        this.cachedMask = null;
        if (imp == null) {
            this.ic = null;
            this.clipboard = null;
            this.yMax = Integer.MAX_VALUE;
            this.xMax = Integer.MAX_VALUE;
        } else {
            this.ic = imp.getCanvas();
            this.xMax = imp.getWidth();
            this.yMax = imp.getHeight();
        }
    }

    public ImagePlus getImage() {
        return this.imp;
    }

    public int getImageID() {
        return this.imp != null ? this.imp.getID() : this.imageID;
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public double getLength() {
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        double perimeter = 2.0 * (double)this.width * pw + 2.0 * (double)this.height * ph;
        if (this.cornerDiameter > 0) {
            double a = 0.5 * (double)Math.min(this.cornerDiameter, this.width) * pw;
            double b = 0.5 * (double)Math.min(this.cornerDiameter, this.height) * ph;
            perimeter += Math.PI * (3.0 * (a + b) - Math.sqrt((3.0 * a + b) * (a + 3.0 * b))) - 4.0 * (a + b);
        }
        return perimeter;
    }

    public double getFeretsDiameter() {
        double[] a = this.getFeretValues();
        return a != null ? a[0] : 0.0;
    }

    public double[] getFeretValues() {
        double xf1;
        double xf2;
        double yf2;
        double yf1;
        double angle;
        FloatPolygon poly;
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        if ((poly = this.getFloatConvexHull()) == null || poly.npoints == 0) {
            return null;
        }
        double[] a = new double[16];
        int p1 = 0;
        int p2 = 0;
        double diameterSqr = 0.0;
        for (int i = 0; i < poly.npoints; ++i) {
            for (int j = i + 1; j < poly.npoints; ++j) {
                double dx = (double)(poly.xpoints[i] - poly.xpoints[j]) * pw;
                double dy = (double)(poly.ypoints[i] - poly.ypoints[j]) * ph;
                double dsqr = dx * dx + dy * dy;
                if (!(dsqr > diameterSqr)) continue;
                diameterSqr = dsqr;
                p1 = i;
                p2 = j;
            }
        }
        if (poly.xpoints[p1] > poly.xpoints[p2]) {
            int p2swap = p1;
            p1 = p2;
            p2 = p2swap;
        }
        if ((angle = 57.29577951308232 * Math.atan2(((yf1 = (double)poly.ypoints[p1]) - (yf2 = (double)poly.ypoints[p2])) * ph, ((xf2 = (double)poly.xpoints[p2]) - (xf1 = (double)poly.xpoints[p1])) * pw)) < 0.0) {
            angle += 180.0;
        }
        a[0] = Math.sqrt(diameterSqr);
        a[1] = angle;
        a[3] = xf1;
        a[4] = yf1;
        int i = 8;
        a[i++] = poly.xpoints[p1];
        a[i++] = poly.ypoints[p1];
        a[i++] = poly.xpoints[p2];
        a[i++] = poly.ypoints[p2];
        double x0 = poly.xpoints[poly.npoints - 1];
        double y0 = poly.ypoints[poly.npoints - 1];
        double minFeret = Double.MAX_VALUE;
        double[] xyEnd = new double[4];
        double[] xyEi = new double[4];
        for (int i2 = 0; i2 < poly.npoints; ++i2) {
            double xprev = x0;
            double yprev = y0;
            x0 = poly.xpoints[i2];
            y0 = poly.ypoints[i2];
            double xnorm = (y0 - yprev) * ph;
            double ynorm = (xprev - x0) * pw;
            double normalizationFactor = 1.0 / Math.sqrt(xnorm * xnorm + ynorm * ynorm);
            xnorm *= normalizationFactor * pw;
            ynorm *= normalizationFactor * ph;
            double maxDist = 0.0;
            for (int j = 0; j < poly.npoints; ++j) {
                double x1 = poly.xpoints[j];
                double dx = x1 - x0;
                double y1 = poly.ypoints[j];
                double dy = y1 - y0;
                double dist = dx * xnorm + dy * ynorm;
                if (!(dist > maxDist)) continue;
                maxDist = dist;
                xyEi[0] = x1;
                xyEi[1] = y1;
                xyEi[2] = xyEi[0] - xnorm / pw * dist / pw;
                xyEi[3] = xyEi[1] - ynorm / ph * dist / ph;
            }
            if (!(maxDist < minFeret)) continue;
            minFeret = maxDist;
            System.arraycopy(xyEi, 0, xyEnd, 0, 4);
        }
        a[2] = minFeret;
        System.arraycopy(xyEnd, 0, a, 12, 4);
        return a;
    }

    public Polygon getConvexHull() {
        FloatPolygon fp = this.getFloatConvexHull();
        return new Polygon(Roi.toIntR(fp.xpoints), Roi.toIntR(fp.ypoints), fp.npoints);
    }

    public FloatPolygon getFloatConvexHull() {
        FloatPolygon fp = this.getFloatPolygon("");
        return fp == null ? null : fp.getConvexHull();
    }

    double getFeretBreadth(Shape shape, double angle, double x1, double y1, double x2, double y2) {
        double cx = x1 + (x2 - x1) / 2.0;
        double cy = y1 + (y2 - y1) / 2.0;
        AffineTransform at = new AffineTransform();
        at.rotate(angle * Math.PI / 180.0, cx, cy);
        Shape s = at.createTransformedShape(shape);
        Rectangle2D r = s.getBounds2D();
        return Math.min(r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D.Double getFloatBounds() {
        if (this.bounds != null) {
            return new Rectangle2D.Double(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle2D.Double b) {
        if (this.type != 0 && this.type != 1 && !(this instanceof TextRoi)) {
            return;
        }
        this.x = (int)b.x;
        this.y = (int)b.y;
        this.width = (int)Math.ceil(b.width);
        this.height = (int)Math.ceil(b.height);
        this.bounds = new Rectangle2D.Double(b.x, b.y, b.width, b.height);
        this.cachedMask = null;
    }

    public Rectangle getBoundingRect() {
        return this.getBounds();
    }

    public Polygon getPolygon() {
        int[] xpoints = new int[4];
        int[] ypoints = new int[4];
        xpoints[0] = this.x;
        ypoints[0] = this.y;
        xpoints[1] = this.x + this.width;
        ypoints[1] = this.y;
        xpoints[2] = this.x + this.width;
        ypoints[2] = this.y + this.height;
        xpoints[3] = this.x;
        ypoints[3] = this.y + this.height;
        return new Polygon(xpoints, ypoints, 4);
    }

    public FloatPolygon getFloatPolygon() {
        if (this.cornerDiameter > 0) {
            ShapeRoi s = new ShapeRoi(this);
            return s.getFloatPolygon();
        }
        if (this.subPixelResolution() && this.bounds != null) {
            float[] xpoints = new float[4];
            float[] ypoints = new float[4];
            xpoints[0] = (float)this.bounds.x;
            ypoints[0] = (float)this.bounds.y;
            xpoints[1] = (float)(this.bounds.x + this.bounds.width);
            ypoints[1] = (float)this.bounds.y;
            xpoints[2] = (float)(this.bounds.x + this.bounds.width);
            ypoints[2] = (float)(this.bounds.y + this.bounds.height);
            xpoints[3] = (float)this.bounds.x;
            ypoints[3] = (float)(this.bounds.y + this.bounds.height);
            return new FloatPolygon(xpoints, ypoints);
        }
        Polygon p = this.getPolygon();
        return new FloatPolygon(Roi.toFloat(p.xpoints), Roi.toFloat(p.ypoints), p.npoints);
    }

    public FloatPolygon getFloatPolygon(String options) {
        boolean addPointForClose = (options = options.toLowerCase()).indexOf("close") >= 0;
        FloatPolygon fp = this.getFloatPolygon();
        int n = fp.npoints;
        if (this.isArea() && n > 1) {
            boolean isClosed;
            boolean bl = isClosed = fp.xpoints[0] == fp.xpoints[n - 1] && fp.ypoints[0] == fp.ypoints[n - 1];
            if (addPointForClose && !isClosed) {
                fp.addPoint(fp.xpoints[0], fp.ypoints[0]);
            } else if (!addPointForClose && isClosed) {
                --fp.npoints;
            }
        }
        return fp;
    }

    public FloatPolygon getInterpolatedPolygon() {
        return this.getInterpolatedPolygon(1.0, false);
    }

    public FloatPolygon getInterpolatedPolygon(double interval, boolean smooth) {
        FloatPolygon p = this instanceof Line ? ((Line)this).getFloatPoints() : this.getFloatPolygon();
        return this.getInterpolatedPolygon(p, interval, smooth);
    }

    protected FloatPolygon getInterpolatedPolygon(FloatPolygon p, double interval, boolean smooth) {
        boolean allowToAdjust = interval < 0.0;
        interval = Math.abs(interval);
        boolean isLine = this.isLine();
        double length = p.getLength(isLine);
        int npoints = p.npoints;
        if (!isLine) {
            p.xpoints = Arrays.copyOf(p.xpoints, ++npoints);
            p.xpoints[npoints - 1] = p.xpoints[0];
            p.ypoints = Arrays.copyOf(p.ypoints, npoints);
            p.ypoints[npoints - 1] = p.ypoints[0];
        }
        int npoints2 = (int)(10.0 + length * 1.5 / interval);
        double tryInterval = interval;
        double minDiff = 1.0E9;
        double bestInterval = 0.0;
        int srcPtr = 0;
        int destPtr = 0;
        double[] destXArr = new double[npoints2];
        double[] destYArr = new double[npoints2];
        int nTrials = 50;
        int trial = 0;
        while (trial <= nTrials) {
            double feedBackFactor;
            destXArr[0] = p.xpoints[0];
            destYArr[0] = p.ypoints[0];
            srcPtr = 0;
            destPtr = 0;
            double xA = p.xpoints[0];
            double yA = p.ypoints[0];
            while (srcPtr < npoints - 1) {
                double xB = p.xpoints[srcPtr + 1];
                double yB = p.ypoints[srcPtr + 1];
                double xC = destXArr[destPtr];
                double yC = destYArr[destPtr];
                double[] intersections = Roi.lineCircleIntersection(xA, yA, xB, yB, xC, yC, tryInterval, true);
                if (intersections.length >= 2) {
                    xA = intersections[0];
                    yA = intersections[1];
                    destXArr[++destPtr] = xA;
                    destYArr[destPtr] = yA;
                    continue;
                }
                xA = p.xpoints[++srcPtr];
                yA = p.ypoints[srcPtr];
            }
            destXArr[++destPtr] = p.xpoints[npoints - 1];
            destYArr[destPtr] = p.ypoints[npoints - 1];
            ++destPtr;
            if (!allowToAdjust) {
                if (!isLine) break;
                --destPtr;
                break;
            }
            int nSegments = destPtr - 1;
            double dx = destXArr[destPtr - 2] - destXArr[destPtr - 1];
            double dy = destYArr[destPtr - 2] - destYArr[destPtr - 1];
            double lastSeg = Math.sqrt(dx * dx + dy * dy);
            double diff = lastSeg - tryInterval;
            if (Math.abs(diff) < minDiff) {
                minDiff = Math.abs(diff);
                bestInterval = tryInterval;
            }
            if (((tryInterval += (feedBackFactor = 0.66) * diff / (double)nSegments) < 0.8 * interval || Math.abs(diff) < 0.05 || trial == nTrials - 1) && trial < nTrials) {
                trial = nTrials;
                tryInterval = bestInterval;
                continue;
            }
            ++trial;
        }
        if (!isLine) {
            --destPtr;
        }
        float[] xPoints = new float[destPtr];
        float[] yPoints = new float[destPtr];
        for (int jj = 0; jj < destPtr; ++jj) {
            xPoints[jj] = (float)destXArr[jj];
            yPoints[jj] = (float)destYArr[jj];
        }
        FloatPolygon fPoly = new FloatPolygon(xPoints, yPoints);
        return fPoly;
    }

    public Point[] getContainedPoints() {
        Roi roi = this;
        if (this.isLine()) {
            roi = Roi.convertLineToArea(this);
        }
        ImageProcessor mask = roi.getMask();
        Rectangle bounds = roi.getBounds();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int y = 0; y < bounds.height; ++y) {
            for (int x = 0; x < bounds.width; ++x) {
                if (mask != null && mask.getPixel(x, y) == 0) continue;
                points.add(new Point(roi.x + x, roi.y + y));
            }
        }
        return points.toArray(new Point[points.size()]);
    }

    public FloatPolygon getContainedFloatPoints() {
        Roi roi2 = this;
        if (this.isLine()) {
            if (this.getStrokeWidth() <= 1.0f) {
                return roi2.getInterpolatedPolygon();
            }
            roi2 = Roi.convertLineToArea(this);
        }
        ImageProcessor mask = roi2.getMask();
        Rectangle bounds = roi2.getBounds();
        FloatPolygon points = new FloatPolygon();
        for (int y = 0; y < bounds.height; ++y) {
            for (int x = 0; x < bounds.width; ++x) {
                if (mask != null && mask.getPixel(x, y) == 0) continue;
                points.addPoint(bounds.x + x, bounds.y + y);
            }
        }
        return points;
    }

    public static double[] lineCircleIntersection(double ax, double ay, double bx, double by, double cx, double cy, double rad, boolean ignoreOutside) {
        double dxAC = cx - ax;
        double dyAC = cy - ay;
        double lenAC = Math.sqrt(dxAC * dxAC + dyAC * dyAC);
        double dxAB = bx - ax;
        double dyAB = by - ay;
        double xB2 = Math.sqrt(dxAB * dxAB + dyAB * dyAB);
        double phi1 = Math.atan2(dyAB, dxAB);
        double phi2 = Math.atan2(dyAC, dxAC);
        double phi3 = phi1 - phi2;
        double xC2 = lenAC * Math.cos(phi3);
        double yC2 = lenAC * Math.sin(phi3);
        if (Math.abs(yC2) > rad) {
            return new double[0];
        }
        double halfChord = Math.sqrt(rad * rad - yC2 * yC2);
        double sectOne = xC2 - halfChord;
        double sectTwo = xC2 + halfChord;
        double[] xyCoords = new double[4];
        int ptr = 0;
        if (sectOne >= 0.0 && sectOne <= xB2 || !ignoreOutside) {
            double sectOneX = Math.cos(phi1) * sectOne + ax;
            double sectOneY = Math.sin(phi1) * sectOne + ay;
            xyCoords[ptr++] = sectOneX;
            xyCoords[ptr++] = sectOneY;
        }
        if (sectTwo >= 0.0 && sectTwo <= xB2 || !ignoreOutside) {
            double sectTwoX = Math.cos(phi1) * sectTwo + ax;
            double sectTwoY = Math.sin(phi1) * sectTwo + ay;
            xyCoords[ptr++] = sectTwoX;
            xyCoords[ptr++] = sectTwoY;
        }
        if (halfChord == 0.0 && ptr > 2) {
            ptr = 2;
        }
        xyCoords = Arrays.copyOf(xyCoords, ptr);
        return xyCoords;
    }

    public synchronized Object clone() {
        try {
            Roi r = (Roi)super.clone();
            r.setImage(null);
            if (!this.usingDefaultStroke) {
                r.setStroke(this.getStroke());
            }
            r.setFillColor(this.getFillColor());
            r.imageID = this.getImageID();
            r.listenersNotified = false;
            if (this.bounds != null) {
                r.bounds = (Rectangle2D.Double)this.bounds.clone();
            }
            return r;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void abortModification(ImagePlus imp) {
        if (this.state == 0) {
            this.setImage(null);
            Roi savedPreviousRoi = previousRoi;
            imp.setRoi(previousRoi != null && previousRoi.getImage() == imp ? previousRoi : null);
            previousRoi = savedPreviousRoi;
        } else if (this.state == 1) {
            this.move(this.previousSX, this.previousSY);
        } else if (this.state == 4) {
            this.moveHandle(this.previousSX, this.previousSY);
        }
        this.state = 3;
    }

    protected void grow(int sx, int sy) {
        if (this.clipboard != null) {
            return;
        }
        int xNew = this.ic.offScreenX2(sx);
        int yNew = this.ic.offScreenY2(sy);
        if (this.type == 0) {
            if (xNew < 0) {
                xNew = 0;
            }
            if (yNew < 0) {
                yNew = 0;
            }
        }
        if (this.constrain) {
            if (!this.center) {
                this.growConstrained(xNew, yNew);
                return;
            }
            int dx = xNew - this.x;
            int dy = yNew - this.y;
            int d = dx < dy ? dx : dy;
            xNew = this.x + d;
            yNew = this.y + d;
        }
        if (this.center) {
            this.width = Math.abs(xNew - this.startX) * 2;
            this.height = Math.abs(yNew - this.startY) * 2;
            this.x = this.startX - this.width / 2;
            this.y = this.startY - this.height / 2;
        } else {
            this.width = Math.abs(xNew - this.startX);
            this.height = Math.abs(yNew - this.startY);
            this.x = xNew >= this.startX ? this.startX : this.startX - this.width;
            int n = this.y = yNew >= this.startY ? this.startY : this.startY - this.height;
            if (this.type == 0) {
                if (this.x + this.width > this.xMax) {
                    this.width = this.xMax - this.x;
                }
                if (this.y + this.height > this.yMax) {
                    this.height = this.yMax - this.y;
                }
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.bounds = null;
    }

    private void growConstrained(int xNew, int yNew) {
        int dx = xNew - this.startX;
        int dy = yNew - this.startY;
        this.width = this.height = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        if (this.type == 0) {
            this.x = xNew >= this.startX ? this.startX : this.startX - this.width;
            int n = this.y = yNew >= this.startY ? this.startY : this.startY - this.height;
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x + this.width > this.xMax) {
                this.width = this.xMax - this.x;
            }
            if (this.y + this.height > this.yMax) {
                this.height = this.yMax - this.y;
            }
        } else {
            this.x = this.startX + dx / 2 - this.width / 2;
            this.y = this.startY + dy / 2 - this.height / 2;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int sx, int sy) {
        double asp;
        if (this.clipboard != null) {
            return;
        }
        int ox = this.ic.offScreenX2(sx);
        int oy = this.ic.offScreenY2(sy);
        if (ox < 0) {
            ox = 0;
        }
        if (oy < 0) {
            oy = 0;
        }
        if (ox > this.xMax) {
            ox = this.xMax;
        }
        if (oy > this.yMax) {
            oy = this.yMax;
        }
        int x1 = this.x;
        int y1 = this.y;
        int x2 = x1 + this.width;
        int y2 = this.y + this.height;
        int xc = this.x + this.width / 2;
        int yc = this.y + this.height / 2;
        if (this.width > 7 && this.height > 7) {
            this.asp_bk = asp = (double)this.width / (double)this.height;
        } else {
            asp = this.asp_bk;
        }
        switch (this.activeHandle) {
            case 0: {
                this.x = ox;
                this.y = oy;
                break;
            }
            case 1: {
                this.y = oy;
                break;
            }
            case 2: {
                x2 = ox;
                this.y = oy;
                break;
            }
            case 3: {
                x2 = ox;
                break;
            }
            case 4: {
                x2 = ox;
                y2 = oy;
                break;
            }
            case 5: {
                y2 = oy;
                break;
            }
            case 6: {
                this.x = ox;
                y2 = oy;
                break;
            }
            case 7: {
                this.x = ox;
            }
        }
        if (this.x < x2) {
            this.width = x2 - this.x;
        } else {
            this.width = 1;
            this.x = x2;
        }
        if (this.y < y2) {
            this.height = y2 - this.y;
        } else {
            this.height = 1;
            this.y = y2;
        }
        if (this.center) {
            switch (this.activeHandle) {
                case 0: {
                    this.width = (xc - this.x) * 2;
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 1: {
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 2: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    this.height = (yc - this.y) * 2;
                    break;
                }
                case 3: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    break;
                }
                case 4: {
                    this.width = (x2 - xc) * 2;
                    this.x = x2 - this.width;
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 5: {
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 6: {
                    this.width = (xc - this.x) * 2;
                    this.height = (y2 - yc) * 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 7: {
                    this.width = (xc - this.x) * 2;
                }
            }
            if (this.x >= x2) {
                this.width = 1;
                this.x = x2 = xc;
            }
            if (this.y >= y2) {
                this.height = 1;
                this.y = y2 = yc;
            }
            this.bounds = null;
        }
        if (this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = this.height;
            } else {
                this.height = this.width;
            }
            if (this.x >= x2) {
                this.width = 1;
                this.x = x2 = xc;
            }
            if (this.y >= y2) {
                this.height = 1;
                this.y = y2 = yc;
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = x2 - this.width;
                    this.y = y2 - this.height;
                    break;
                }
                case 1: {
                    this.x = xc - this.width / 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 2: {
                    this.y = y2 - this.height;
                    break;
                }
                case 3: {
                    this.y = yc - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = xc - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = x2 - this.width;
                    break;
                }
                case 7: {
                    this.y = yc - this.height / 2;
                    this.x = x2 - this.width;
                }
            }
            if (this.center) {
                this.x = xc - this.width / 2;
                this.y = yc - this.height / 2;
            }
        }
        if (this.aspect && !this.constrain) {
            if (this.activeHandle == 1 || this.activeHandle == 5) {
                this.width = (int)Math.rint((double)this.height * asp);
            } else {
                this.height = (int)Math.rint((double)this.width / asp);
            }
            switch (this.activeHandle) {
                case 0: {
                    this.x = x2 - this.width;
                    this.y = y2 - this.height;
                    break;
                }
                case 1: {
                    this.x = xc - this.width / 2;
                    this.y = y2 - this.height;
                    break;
                }
                case 2: {
                    this.y = y2 - this.height;
                    break;
                }
                case 3: {
                    this.y = yc - this.height / 2;
                    break;
                }
                case 5: {
                    this.x = xc - this.width / 2;
                    break;
                }
                case 6: {
                    this.x = x2 - this.width;
                    break;
                }
                case 7: {
                    this.y = yc - this.height / 2;
                    this.x = x2 - this.width;
                }
            }
            if (this.center) {
                this.x = xc - this.width / 2;
                this.y = yc - this.height / 2;
            }
            if (this.width < 8) {
                if (this.width < 1) {
                    this.width = 1;
                }
                this.height = (int)Math.rint((double)this.width / this.asp_bk);
            }
            if (this.height < 8) {
                if (this.height < 1) {
                    this.height = 1;
                }
                this.width = (int)Math.rint((double)this.height * this.asp_bk);
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.bounds = null;
        this.subPixel = false;
    }

    void move(int sx, int sy) {
        if (this.constrain) {
            int dx = sx - this.previousSX;
            int dy = sy - this.previousSY;
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
            sx = this.previousSX + dx;
            sy = this.previousSY + dy;
        }
        int xNew = this.ic.offScreenX(sx);
        int yNew = this.ic.offScreenY(sy);
        int dx = xNew - this.startX;
        int dy = yNew - this.startY;
        if (dx == 0 && dy == 0) {
            return;
        }
        this.x += dx;
        this.y += dy;
        if (this.bounds != null) {
            this.setLocation(this.bounds.x + (double)dx, this.bounds.y + (double)dy);
        }
        boolean isImageRoi = this instanceof ImageRoi;
        if (this.clipboard == null && this.type == 0 && !isImageRoi) {
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.x + this.width > this.xMax) {
                this.x = this.xMax - this.width;
            }
            if (this.y + this.height > this.yMax) {
                this.y = this.yMax - this.height;
            }
        }
        this.startX = xNew;
        this.startY = yNew;
        if (this.type == 10 || this instanceof TextRoi && ((TextRoi)this).getAngle() != 0.0) {
            this.ignoreClipRect = true;
        }
        this.updateClipRect();
        if (lineWidth > 1 && this.isLine() || this.ignoreClipRect || this instanceof PolygonRoi && ((PolygonRoi)this).isSplineFit()) {
            this.imp.draw();
        } else {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        if (isImageRoi) {
            this.showStatus();
        }
    }

    public void nudge(int key) {
        if (WindowManager.getActiveWindow() instanceof RoiManager) {
            return;
        }
        if (!(this.bounds == null || Roi.isInteger(this.bounds.x) && Roi.isInteger(this.bounds.y))) {
            this.cachedMask = null;
        }
        switch (key) {
            case 38: {
                --this.y;
                if (this.y >= 0 || this.type == 0 && this.clipboard != null) break;
                this.y = 0;
                break;
            }
            case 40: {
                ++this.y;
                if (this.y + this.height < this.yMax || this.type == 0 && this.clipboard != null) break;
                this.y = this.yMax - this.height;
                break;
            }
            case 37: {
                --this.x;
                if (this.x >= 0 || this.type == 0 && this.clipboard != null) break;
                this.x = 0;
                break;
            }
            case 39: {
                ++this.x;
                if (this.x + this.width < this.xMax || this.type == 0 && this.clipboard != null) break;
                this.x = this.xMax - this.width;
            }
        }
        this.updateClipRect();
        if (this.type == 10) {
            this.imp.draw();
        } else {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.bounds = null;
        this.showStatus();
        this.notifyListeners(2);
    }

    public void nudgeCorner(int key) {
        if (this.type > 1 || this.clipboard != null) {
            return;
        }
        switch (key) {
            case 38: {
                --this.height;
                if (this.height < 1) {
                    this.height = 1;
                }
                this.notifyListeners(3);
                break;
            }
            case 40: {
                ++this.height;
                if (this.y + this.height > this.yMax) {
                    this.height = this.yMax - this.y;
                }
                this.notifyListeners(3);
                break;
            }
            case 37: {
                --this.width;
                if (this.width < 1) {
                    this.width = 1;
                }
                this.notifyListeners(3);
                break;
            }
            case 39: {
                ++this.width;
                if (this.x + this.width > this.xMax) {
                    this.width = this.xMax - this.x;
                }
                this.notifyListeners(3);
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.cachedMask = null;
        this.showStatus();
        this.notifyListeners(2);
    }

    protected void updateClipRect() {
        this.clipX = this.x <= this.oldX ? this.x : this.oldX;
        this.clipY = this.y <= this.oldY ? this.y : this.oldY;
        this.clipWidth = (this.x + this.width >= this.oldX + this.oldWidth ? this.x + this.width : this.oldX + this.oldWidth) - this.clipX + 1;
        this.clipHeight = (this.y + this.height >= this.oldY + this.oldHeight ? this.y + this.height : this.oldY + this.oldHeight) - this.clipY + 1;
        int handleSize = this.getHandleSize();
        double mag = this.ic != null ? this.ic.getMagnification() : 1.0;
        int m = mag < 1.0 ? (int)((double)handleSize / mag) : handleSize;
        m += this.clipRectMargin();
        double strokeWidth = this.getStrokeWidth();
        if (strokeWidth == 0.0) {
            strokeWidth = Roi.defaultStrokeWidth();
        }
        m = (int)((double)m + strokeWidth * 2.0);
        this.clipX -= m;
        this.clipY -= m;
        this.clipWidth += m * 2;
        this.clipHeight += m * 2;
    }

    protected int clipRectMargin() {
        return 0;
    }

    protected void handleMouseDrag(int sx, int sy, int flags) {
        if (this.ic == null) {
            return;
        }
        this.constrain = (flags & 1) != 0;
        this.center = (flags & 2) != 0 || IJ.isMacintosh() && (flags & 4) != 0;
        this.aspect = (flags & 8) != 0;
        switch (this.state) {
            case 0: {
                this.grow(sx, sy);
                break;
            }
            case 1: {
                this.move(sx, sy);
                break;
            }
            case 4: {
                this.moveHandle(sx, sy);
                break;
            }
        }
        this.notifyListeners(this.state == 1 ? 2 : 3);
    }

    public void draw(Graphics g) {
        Color color;
        Color color2 = color = this.strokeColor != null ? this.strokeColor : ROIColor;
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        if (Interpreter.isBatchMode() && this.imp != null && this.imp.getOverlay() != null && this.strokeColor == null && this.fillColor == null) {
            return;
        }
        g.setColor(color);
        this.mag = this.getMagnification();
        int sw = (int)((double)this.width * this.mag);
        int sh = (int)((double)this.height * this.mag);
        int sx1 = this.screenX(this.x);
        int sy1 = this.screenY(this.y);
        if (this.subPixelResolution() && this.bounds != null) {
            sw = (int)(this.bounds.width * this.mag);
            sh = (int)(this.bounds.height * this.mag);
            sx1 = this.screenXD(this.bounds.x);
            sy1 = this.screenYD(this.bounds.y);
        }
        int sx2 = sx1 + sw / 2;
        int sy2 = sy1 + sh / 2;
        int sx3 = sx1 + sw;
        int sy3 = sy1 + sh;
        Graphics2D g2d = (Graphics2D)g;
        if (this.stroke != null) {
            g2d.setStroke(this.getScaledStroke());
        }
        this.setRenderingHint(g2d);
        if (this.cornerDiameter > 0) {
            int sArcSize = (int)Math.round((double)this.cornerDiameter * this.mag);
            if (this.fillColor != null) {
                g.fillRoundRect(sx1, sy1, sw, sh, sArcSize, sArcSize);
            } else {
                g.drawRoundRect(sx1, sy1, sw, sh, sArcSize, sArcSize);
            }
        } else if (this.fillColor != null) {
            if (!this.overlay && this.isActiveOverlayRoi()) {
                g.setColor(Color.cyan);
                g.drawRect(sx1, sy1, sw, sh);
            } else if (!(this instanceof TextRoi)) {
                g.fillRect(sx1, sy1, sw, sh);
            } else {
                g.drawRect(sx1, sy1, sw, sh);
            }
        } else {
            g.drawRect(sx1, sy1, sw, sh);
        }
        if (this.clipboard == null && !this.overlay) {
            this.drawHandle(g, sx1, sy1);
            this.drawHandle(g, sx2, sy1);
            this.drawHandle(g, sx3, sy1);
            this.drawHandle(g, sx3, sy2);
            this.drawHandle(g, sx3, sy3);
            this.drawHandle(g, sx2, sy3);
            this.drawHandle(g, sx1, sy3);
            this.drawHandle(g, sx1, sy2);
        }
        this.drawPreviousRoi(g);
        if (this.state != 3) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public void drawOverlay(Graphics g) {
        this.overlay = true;
        this.draw(g);
        this.overlay = false;
    }

    void drawPreviousRoi(Graphics g) {
        if (previousRoi != null && previousRoi != this && Roi.previousRoi.modState != 0) {
            if (this.type != 10 && previousRoi.getType() == 10 && Roi.previousRoi.modState != 2) {
                return;
            }
            previousRoi.setImage(this.imp);
            previousRoi.draw(g);
        }
    }

    private static double defaultStrokeWidth() {
        double defaultWidth = defaultStrokeWidth;
        double guiScale = Prefs.getGuiScale();
        if (defaultWidth <= 1.0 && guiScale > 1.0 && (defaultWidth = guiScale) < 1.5) {
            defaultWidth = 1.5;
        }
        return defaultWidth;
    }

    public int getHandleSize() {
        if (this.handleSize >= 0) {
            return this.handleSize;
        }
        return Roi.getDefaultHandleSize();
    }

    public void setHandleSize(int size) {
        if (size >= 0 && (size & 1) == 0) {
            ++size;
        }
        this.handleSize = size;
        if (this.imp != null) {
            this.imp.draw();
        }
    }

    public static int getDefaultHandleSize() {
        if (defaultHandleSize > 0) {
            return defaultHandleSize;
        }
        double defaultWidth = Roi.defaultStrokeWidth();
        int size = 7;
        if (defaultWidth > 1.5) {
            size = 9;
        }
        if (defaultWidth >= 3.0) {
            size = 11;
        }
        if (defaultWidth >= 4.0) {
            size = 13;
        }
        if (defaultWidth >= 5.0) {
            size = 15;
        }
        if (defaultWidth >= 11.0) {
            size = (int)defaultWidth;
        }
        defaultHandleSize = size;
        return defaultHandleSize;
    }

    public static void resetDefaultHandleSize() {
        defaultHandleSize = 0;
    }

    void drawHandle(Graphics g, int x, int y) {
        int threshold1 = 7500;
        int threshold2 = 1500;
        double size = (double)(this.width * this.height) * this.mag * this.mag;
        if (this instanceof Line) {
            size = ((Line)this).getLength() * this.mag;
            threshold1 = 150;
            threshold2 = 50;
        } else if (this.state == 0 && this.type != 0 && this.type != 1) {
            size = threshold1 + 1;
        }
        int width = 7;
        int x0 = x--;
        int y0 = y--;
        if (size > (double)threshold1) {
            x -= 3;
            y -= 3;
        } else if (size > (double)threshold2) {
            x -= 2;
            y -= 2;
            width = 5;
        } else {
            width = 3;
        }
        int inc = this.getHandleSize() - 7;
        x -= inc / 2;
        y -= inc / 2;
        g.setColor(Color.black);
        if ((width += inc) < 3) {
            g.fillRect(x0, y0, 1, 1);
            return;
        }
        g.fillRect(x++, y++, width, width);
        g.setColor(this.handleColor);
        g.fillRect(x, y, width -= 2, width);
    }

    public void drawPixels() {
        if (this.imp != null) {
            this.drawPixels(this.imp.getProcessor());
        }
    }

    public void drawPixels(ImageProcessor ip) {
        this.endPaste();
        int saveWidth = ip.getLineWidth();
        if (this.getStrokeWidth() > 1.0f) {
            ip.setLineWidth(Math.round(this.getStrokeWidth()));
        }
        if (this.cornerDiameter > 0) {
            this.drawRoundedRect(ip);
        } else if (ip.getLineWidth() == 1) {
            ip.drawRect(this.x, this.y, this.width + 1, this.height + 1);
        } else {
            ip.drawRect(this.x, this.y, this.width, this.height);
        }
        ip.setLineWidth(saveWidth);
        if (Line.getWidth() > 1 || this.getStrokeWidth() > 1.0f) {
            this.updateFullWindow = true;
        }
    }

    private void drawRoundedRect(ImageProcessor ip) {
        int margin = (int)this.getStrokeWidth() / 2;
        BufferedImage bi = new BufferedImage(this.width + margin * 2 + 1, this.height + margin * 2 + 1, 10);
        Graphics2D g = bi.createGraphics();
        if (this.stroke != null) {
            g.setStroke(this.stroke);
        }
        g.drawRoundRect(margin, margin, this.width, this.height, this.cornerDiameter, this.cornerDiameter);
        ByteProcessor mask = new ByteProcessor(bi);
        ip.setRoi(this.x - margin, this.y - margin, this.width + margin * 2 + 1, this.height + margin * 2 + 1);
        ip.fill(mask);
    }

    public boolean contains(int x, int y) {
        Rectangle r = new Rectangle(this.x, this.y, this.width, this.height);
        boolean contains = r.contains(x, y);
        if (this.cornerDiameter == 0 || !contains) {
            return contains;
        }
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(this.x, this.y, this.width, this.height, this.cornerDiameter, this.cornerDiameter);
        return rr.contains((double)x + 0.4999, (double)y + 0.4999);
    }

    public boolean containsPoint(double x, double y) {
        boolean contains = false;
        if (this.bounds == null) {
            boolean bl = contains = x >= (double)this.x && y >= (double)this.y && x < (double)(this.x + this.width) && y < (double)(this.y + this.height);
        }
        if (this.cornerDiameter == 0 || !contains) {
            return contains;
        }
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(this.x, this.y, this.width, this.height, this.cornerDiameter, this.cornerDiameter);
        return rr.contains(x, y);
    }

    public Roi getInverse(ImagePlus imp) {
        ShapeRoi s;
        if (!this.isArea()) {
            return null;
        }
        Roi fullImage = imp == null ? new Roi(0, 0, 2000000000, 2000000000) : new Roi(0, 0, imp.getWidth(), imp.getHeight());
        ShapeRoi shapeRoi = s = this instanceof ShapeRoi ? (ShapeRoi)this.clone() : new ShapeRoi(this);
        if (s == null) {
            return null;
        }
        ShapeRoi inverse = s.xor(new ShapeRoi(fullImage));
        return inverse.trySimplify();
    }

    public int isHandle(int sx, int sy) {
        if (this.clipboard != null || this.ic == null) {
            return -1;
        }
        double mag = this.ic.getMagnification();
        int margin = IJ.getScreenSize().width > 1280 ? 5 : 3;
        int size = this.getHandleSize() + margin;
        int halfSize = size / 2;
        double x = this.getXBase();
        double y = this.getYBase();
        double width = this.getFloatWidth();
        double height = this.getFloatHeight();
        int sx1 = this.screenXD(x) - halfSize;
        int sy1 = this.screenYD(y) - halfSize;
        int sx3 = this.screenXD(x + width) - halfSize;
        int sy3 = this.screenYD(y + height) - halfSize;
        int sx2 = sx1 + (sx3 - sx1) / 2;
        int sy2 = sy1 + (sy3 - sy1) / 2;
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy1 && sy <= sy1 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy1 && sy <= sy1 + size) {
            return 1;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy1 && sy <= sy1 + size) {
            return 2;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy2 && sy <= sy2 + size) {
            return 3;
        }
        if (sx >= sx3 && sx <= sx3 + size && sy >= sy3 && sy <= sy3 + size) {
            return 4;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy3 && sy <= sy3 + size) {
            return 5;
        }
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy3 && sy <= sy3 + size) {
            return 6;
        }
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy2 && sy <= sy2 + size) {
            return 7;
        }
        return -1;
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        this.state = 4;
        this.previousSX = sx;
        this.previousSY = sy;
        this.activeHandle = handle;
    }

    protected void handleMouseDown(int sx, int sy) {
        if (this.state == 3 && this.ic != null) {
            this.state = 1;
            this.previousSX = sx;
            this.previousSY = sy;
            this.startX = this.offScreenX(sx);
            this.startY = this.offScreenY(sy);
            this.startXD = this.offScreenXD(sx);
            this.startYD = this.offScreenYD(sy);
        }
    }

    protected void handleMouseUp(int screenX, int screenY) {
        this.state = 3;
        if (this.imp == null) {
            return;
        }
        this.imp.draw(this.clipX - 5, this.clipY - 5, this.clipWidth + 10, this.clipHeight + 10);
        if (Recorder.record) {
            if (this.type == 1) {
                Recorder.record("makeOval", this.x, this.y, this.width, this.height);
            } else if (!(this instanceof TextRoi)) {
                if (this.cornerDiameter == 0) {
                    Recorder.record("makeRectangle", this.x, this.y, this.width, this.height);
                } else if (Recorder.scriptMode()) {
                    Recorder.recordCall("imp.setRoi(new Roi(" + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.cornerDiameter + "));");
                } else {
                    Recorder.record("makeRectangle", this.x, this.y, this.width, this.height, this.cornerDiameter);
                }
            }
        }
        if (Toolbar.getToolId() == 1 && Toolbar.getBrushSize() > 0) {
            int flags;
            int n = flags = this.ic != null ? this.ic.getModifiers() : 16;
            if ((flags & 0x10) == 0) {
                this.imp.draw();
                return;
            }
        }
        this.modifyRoi();
    }

    void modifyRoi() {
        if (previousRoi == null || Roi.previousRoi.modState == 0 || this.imp == null) {
            return;
        }
        if (this.type == 10 || previousRoi.getType() == 10) {
            if (this.type == 10 && previousRoi.getType() == 10) {
                this.addPoint();
            } else if (this.isArea() && previousRoi.getType() == 10 && Roi.previousRoi.modState == 2) {
                this.subtractPoints();
            }
            return;
        }
        Roi previous = (Roi)previousRoi.clone();
        previous.modState = 0;
        ShapeRoi s1 = null;
        ShapeRoi s2 = null;
        s1 = previousRoi instanceof ShapeRoi ? (ShapeRoi)previousRoi : new ShapeRoi(previousRoi);
        s2 = this instanceof ShapeRoi ? (ShapeRoi)this : new ShapeRoi(this);
        if (Roi.previousRoi.modState == 1) {
            s1.or(s2);
        } else {
            s1.not(s2);
        }
        Roi.previousRoi.modState = 0;
        Roi roi2 = s1.trySimplify();
        if (roi2 == null) {
            return;
        }
        if (roi2 != null) {
            roi2.copyAttributes(previousRoi);
        }
        this.imp.setRoi(roi2);
        previousRoi = previous;
    }

    void addPoint() {
        if (this.type != 10 || previousRoi.getType() != 10) {
            this.modState = 0;
            this.imp.draw();
            return;
        }
        Roi.previousRoi.modState = 0;
        PointRoi p1 = (PointRoi)previousRoi;
        FloatPolygon poly = this.getFloatPolygon();
        p1.addPoint(this.imp, poly.xpoints[0], poly.ypoints[0]);
        this.imp.setRoi(p1);
    }

    void subtractPoints() {
        Roi.previousRoi.modState = 0;
        PointRoi p1 = (PointRoi)previousRoi;
        PointRoi p2 = p1.subtractPoints(this);
        if (p2 != null) {
            this.imp.setRoi(p1.subtractPoints(this));
        } else {
            this.imp.deleteRoi();
        }
    }

    public void update(boolean add, boolean subtract) {
        if (previousRoi == null) {
            return;
        }
        if (add) {
            Roi.previousRoi.modState = 1;
            this.modifyRoi();
        } else if (subtract) {
            Roi.previousRoi.modState = 2;
            this.modifyRoi();
        } else {
            Roi.previousRoi.modState = 0;
        }
    }

    public void showStatus() {
        String value;
        if (this.imp == null) {
            return;
        }
        if (this.state != 0 && (this.type == 0 || this.type == 10) && this.width <= 25 && this.height <= 25) {
            ImageProcessor ip = this.imp.getProcessor();
            double v = ip.getPixelValue(this.x, this.y);
            int digits = this.imp.getType() == 0 || this.imp.getType() == 1 ? 0 : 2;
            value = ", value=" + IJ.d2s(v, digits);
        } else {
            value = "";
        }
        Calibration cal = this.imp.getCalibration();
        String size = cal.scaled() ? ", w=" + IJ.d2s((double)this.width * cal.pixelWidth) + " (" + this.width + "), h=" + IJ.d2s((double)this.height * cal.pixelHeight) + " (" + this.height + ")" : ", w=" + this.width + ", h=" + this.height;
        IJ.showStatus(this.imp.getLocationAsString(this.x, this.y) + size + value);
    }

    public ImageProcessor getMask() {
        if (this.cornerDiameter > 0) {
            return new ShapeRoi(new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.cornerDiameter, this.cornerDiameter)).getMask();
        }
        return null;
    }

    public void startPaste(ImagePlus clipboard) {
        IJ.showStatus("Pasting...");
        IJ.wait(10);
        this.clipboard = clipboard;
        this.imp.getProcessor().snapshot();
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    void updatePaste() {
        if (this.clipboard != null) {
            this.imp.getMask();
            ImageProcessor ip = this.imp.getProcessor();
            ip.reset();
            int xoffset = 0;
            int yoffset = 0;
            Roi croi = this.clipboard.getRoi();
            if (croi != null) {
                Rectangle r = croi.getBounds();
                if (r.x < 0) {
                    xoffset = -r.x;
                }
                if (r.y < 0) {
                    yoffset = -r.y;
                }
            }
            ip.copyBits(this.clipboard.getProcessor(), this.x + xoffset, this.y + yoffset, pasteMode);
            if (this.type != 0) {
                ip.reset(ip.getMask());
            }
            if (this.ic != null) {
                this.ic.setImageUpdated();
            }
        }
    }

    public void endPaste() {
        if (this.clipboard != null) {
            this.updatePaste();
            this.clipboard = null;
            Undo.setup(1, this.imp);
        }
        this.activeOverlayRoi = false;
    }

    public void abortPaste() {
        this.clipboard = null;
        this.imp.getProcessor().reset();
        this.imp.updateAndDraw();
    }

    public static double getDefaultStrokeWidth() {
        return defaultStrokeWidth;
    }

    public static void setDefaultStrokeWidth(double width) {
        defaultStrokeWidth = width < 0.0 ? 0.0 : width;
        Roi.resetDefaultHandleSize();
    }

    public static int getDefaultGroup() {
        return defaultGroup;
    }

    public static void setDefaultGroup(int group) {
        if (group < 0 || group > 255) {
            throw new IllegalArgumentException("Invalid group: " + group);
        }
        defaultGroup = group;
        groupColor = Roi.getGroupColor(group);
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        if (group < 0 || group > 255) {
            throw new IllegalArgumentException("Invalid group: " + group);
        }
        this.group = group;
        Color color = this.strokeColor = group > 0 ? Roi.getGroupColor(group) : null;
        if (this.imp != null) {
            this.imp.draw();
        }
    }

    private static Color getGroupColor(int group) {
        Color color = ROIColor;
        if (group > 0) {
            if (glasbeyLut == null) {
                String path = IJ.getDir("luts") + "Glasbey.lut";
                glasbeyLut = LutLoader.openLut("noerror:" + path);
                if (glasbeyLut == null) {
                    IJ.log("LUT not found: " + path);
                }
            }
            if (glasbeyLut != null) {
                color = new Color(glasbeyLut.getRGB(group));
            }
        }
        return color;
    }

    public double getAngle(int x1, int y1, int x2, int y2) {
        return this.getFloatAngle(x1, y1, x2, y2);
    }

    public double getFloatAngle(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y1 - y2;
        if (this.imp != null && !IJ.altKeyDown()) {
            Calibration cal = this.imp.getCalibration();
            dx *= cal.pixelWidth;
            dy *= cal.pixelHeight;
        }
        return 57.29577951308232 * Math.atan2(dy, dx);
    }

    public static void setColor(Color c) {
        ROIColor = c;
    }

    public static Color getColor() {
        return ROIColor;
    }

    public void setStrokeColor(Color c) {
        this.strokeColor = c;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public static void setDefaultColor(Color color) {
        defaultColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public static void setDefaultFillColor(Color color) {
        defaultFillColor = color;
    }

    public static Color getDefaultFillColor() {
        return defaultFillColor;
    }

    public void setAntiAlias(boolean antiAlias) {
        this.antiAlias = antiAlias;
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    protected void setRenderingHint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void copyAttributes(Roi roi2) {
        this.strokeColor = roi2.strokeColor;
        this.fillColor = roi2.fillColor;
        this.setStrokeWidth(roi2.getStrokeWidth());
        this.setName(roi2.getName());
        this.group = roi2.group;
    }

    public void setInstanceColor(Color c) {
        this.strokeColor = c;
    }

    public void setLineWidth(int width) {
        this.setStrokeWidth(width);
    }

    public void updateWideLine(float width) {
        if (this.isLine()) {
            this.wideLine = true;
            this.setStrokeWidth(width);
            if (this.getStrokeColor() == null) {
                Color c = Roi.getColor();
                this.setStrokeColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 77));
            }
        }
    }

    public void setNonScalable(boolean nonScalable) {
        this.nonScalable = nonScalable;
    }

    public void setStrokeWidth(float strokeWidth) {
        boolean notify;
        if (strokeWidth < 0.0f) {
            strokeWidth = 0.0f;
        }
        if (strokeWidth == 0.0f && this.usingDefaultStroke) {
            return;
        }
        if (strokeWidth > 0.0f) {
            this.scaleStrokeWidth = true;
            this.usingDefaultStroke = false;
        }
        boolean bl = notify = listeners.size() > 0 && this.isLine() && this.getStrokeWidth() != strokeWidth;
        this.stroke = strokeWidth == 0.0f ? null : (this.wideLine ? new BasicStroke(strokeWidth, 0, 2) : new BasicStroke(strokeWidth));
        if (strokeWidth > 1.0f) {
            this.fillColor = null;
        }
        if (notify) {
            this.notifyListeners(3);
        }
    }

    public void setStrokeWidth(double strokeWidth) {
        this.setStrokeWidth((float)strokeWidth);
    }

    public void setUnscalableStrokeWidth(double strokeWidth) {
        this.setStrokeWidth((float)strokeWidth);
        this.scaleStrokeWidth = false;
    }

    public float getStrokeWidth() {
        return this.stroke != null && !this.usingDefaultStroke ? this.stroke.getLineWidth() : 0.0f;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        if (stroke != null) {
            this.usingDefaultStroke = false;
        }
    }

    public BasicStroke getStroke() {
        if (this.usingDefaultStroke) {
            return null;
        }
        return this.stroke;
    }

    public boolean getScaleStrokeWidth() {
        return this.scaleStrokeWidth;
    }

    protected BasicStroke getScaledStroke() {
        if (this.ic == null || this.usingDefaultStroke || !this.scaleStrokeWidth) {
            return this.stroke;
        }
        double mag = this.ic.getMagnification();
        if (mag != 1.0) {
            float width = (float)((double)this.stroke.getLineWidth() * mag);
            return new BasicStroke(width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        }
        return this.stroke;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static void setPasteMode(int transferMode) {
        if (transferMode == pasteMode) {
            return;
        }
        pasteMode = transferMode;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.updateAndDraw();
        }
    }

    public void setCornerDiameter(int cornerDiameter) {
        if (cornerDiameter < 0) {
            cornerDiameter = 0;
        }
        this.cornerDiameter = cornerDiameter;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && this == imp.getRoi()) {
            imp.updateAndDraw();
        }
    }

    public int getCornerDiameter() {
        return this.cornerDiameter;
    }

    public void setRoundRectArcSize(int cornerDiameter) {
        this.setCornerDiameter(cornerDiameter);
    }

    public int getRoundRectArcSize() {
        return this.cornerDiameter;
    }

    public void setPosition(int n) {
        if (n < 0) {
            n = 0;
        }
        this.position = n;
        this.frame = 0;
        this.slice = 0;
        this.channel = 0;
        this.hyperstackPosition = false;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int channel, int slice, int frame) {
        if (channel < 0) {
            channel = 0;
        }
        this.channel = channel;
        if (slice < 0) {
            slice = 0;
        }
        this.slice = slice;
        if (frame < 0) {
            frame = 0;
        }
        this.frame = frame;
        this.position = 0;
        this.hyperstackPosition = true;
    }

    public boolean hasHyperStackPosition() {
        return this.hyperstackPosition;
    }

    public void setPosition(ImagePlus imp) {
        if (imp == null) {
            return;
        }
        if (imp.isHyperStack()) {
            int channel = imp.getDisplayMode() == 1 ? 0 : imp.getChannel();
            this.setPosition(channel, imp.getSlice(), imp.getFrame());
        } else if (imp.getStackSize() > 1) {
            this.setPosition(imp.getCurrentSlice());
        } else {
            this.setPosition(0);
        }
    }

    public final int getCPosition() {
        return this.channel;
    }

    public final int getZPosition() {
        return this.slice == 0 && !this.hyperstackPosition ? this.position : this.slice;
    }

    public final int getTPosition() {
        return this.frame;
    }

    public void setPrototypeOverlay(Overlay overlay) {
        this.prototypeOverlay = new Overlay();
        this.prototypeOverlay.drawLabels(overlay.getDrawLabels());
        this.prototypeOverlay.drawNames(overlay.getDrawNames());
        this.prototypeOverlay.drawBackgrounds(overlay.getDrawBackgrounds());
        this.prototypeOverlay.setLabelColor(overlay.getLabelColor());
        this.prototypeOverlay.setLabelFont(overlay.getLabelFont(), overlay.scalableLabels());
    }

    public Overlay getPrototypeOverlay() {
        if (this.prototypeOverlay != null) {
            return this.prototypeOverlay;
        }
        return new Overlay();
    }

    public int getPasteMode() {
        if (this.clipboard == null) {
            return -1;
        }
        return pasteMode;
    }

    public static int getCurrentPasteMode() {
        return pasteMode;
    }

    public boolean isArea() {
        return this.type >= 0 && this.type <= 4 || this.type == 9;
    }

    public boolean isLine() {
        return this.type >= 5 && this.type <= 7;
    }

    protected boolean isLineOrPoint() {
        return this.isLine() || this.type == 10;
    }

    public boolean isDrawingTool() {
        return false;
    }

    protected double getMagnification() {
        return this.ic != null ? this.ic.getMagnification() : 1.0;
    }

    public String getTypeAsString() {
        String s = "";
        switch (this.type) {
            case 2: {
                s = "Polygon";
                if (this instanceof EllipseRoi) {
                    s = "Ellipse";
                }
                if (!(this instanceof RotatedRectRoi)) break;
                s = "Rotated Rectangle";
                break;
            }
            case 3: {
                s = "Freehand";
                break;
            }
            case 4: {
                s = "Traced";
                break;
            }
            case 6: {
                s = "Polyline";
                break;
            }
            case 7: {
                s = "Freeline";
                break;
            }
            case 8: {
                s = "Angle";
                break;
            }
            case 5: {
                s = this instanceof Arrow ? "Arrow" : "Straight Line";
                break;
            }
            case 1: {
                s = "Oval";
                break;
            }
            case 9: {
                s = "Composite";
                break;
            }
            case 10: {
                s = "Point";
                break;
            }
            default: {
                s = this instanceof TextRoi ? "Text" : (this instanceof ImageRoi ? "Image" : "Rectangle");
            }
        }
        return s;
    }

    public boolean isVisible() {
        return this.ic != null;
    }

    public boolean subPixelResolution() {
        return this.subPixel;
    }

    @Deprecated
    public boolean getDrawOffset() {
        return false;
    }

    @Deprecated
    public void setDrawOffset(boolean drawOffset) {
    }

    public void setIgnoreClipRect(boolean ignoreClipRect) {
        this.ignoreClipRect = ignoreClipRect;
    }

    public final boolean isActiveOverlayRoi() {
        if (this.imp == null || this != this.imp.getRoi()) {
            return false;
        }
        Overlay overlay = this.imp.getOverlay();
        if (overlay != null && overlay.contains(this)) {
            return true;
        }
        ImageCanvas ic = this.imp.getCanvas();
        overlay = ic != null ? ic.getShowAllList() : null;
        return overlay != null && overlay.contains(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Roi) {
            Roi roi2 = (Roi)obj;
            if (this.type != roi2.getType()) {
                return false;
            }
            if (!this.getBounds().equals(roi2.getBounds())) {
                return false;
            }
            return this.getLength() == roi2.getLength();
        }
        return false;
    }

    protected int offScreenX(int sx) {
        if (this.ic == null) {
            return sx;
        }
        return this.useLineSubpixelConvention() ? this.ic.offScreenX(sx) : this.ic.offScreenX2(sx);
    }

    protected int offScreenY(int sy) {
        if (this.ic == null) {
            return sy;
        }
        return this.useLineSubpixelConvention() ? this.ic.offScreenY(sy) : this.ic.offScreenY2(sy);
    }

    protected double offScreenXD(int sx) {
        if (this.ic == null) {
            return sx;
        }
        double offScreenValue = this.ic.offScreenXD(sx);
        if (this.useLineSubpixelConvention()) {
            offScreenValue -= 0.5;
        }
        return offScreenValue;
    }

    protected double offScreenYD(int sy) {
        if (this.ic == null) {
            return sy;
        }
        double offScreenValue = this.ic.offScreenYD(sy);
        if (this.useLineSubpixelConvention()) {
            offScreenValue -= 0.5;
        }
        return offScreenValue;
    }

    protected boolean useLineSubpixelConvention() {
        return this.isLineOrPoint();
    }

    protected boolean magnificationForSubPixel() {
        return Roi.magnificationForSubPixel(this.getMagnification());
    }

    protected static boolean magnificationForSubPixel(double magnification) {
        return magnification > 1.5;
    }

    protected int screenXD(double ox) {
        if (this.ic == null) {
            return (int)ox;
        }
        if (this.useLineSubpixelConvention()) {
            ox += 0.5;
        }
        return this.ic.screenXD(ox);
    }

    protected int screenYD(double oy) {
        if (this.ic == null) {
            return (int)oy;
        }
        if (this.useLineSubpixelConvention()) {
            oy += 0.5;
        }
        return this.ic.screenYD(oy);
    }

    protected int screenX(int ox) {
        return this.screenXD(ox);
    }

    protected int screenY(int oy) {
        return this.screenYD(oy);
    }

    public static int[] toInt(float[] arr) {
        return Roi.toInt(arr, null, arr.length);
    }

    public static int[] toInt(float[] arr, int[] arr2, int size) {
        int[] temp;
        int n = arr.length;
        if (size > n) {
            size = n;
        }
        if ((temp = arr2) == null || temp.length < n) {
            temp = new int[n];
        }
        for (int i = 0; i < size; ++i) {
            temp[i] = (int)arr[i];
        }
        return temp;
    }

    public static int[] toIntR(float[] arr) {
        int n = arr.length;
        int[] temp = new int[n];
        for (int i = 0; i < n; ++i) {
            temp[i] = (int)Math.floor((double)arr[i] + 0.5);
        }
        return temp;
    }

    public static float[] toFloat(int[] arr) {
        int n = arr.length;
        float[] temp = new float[n];
        for (int i = 0; i < n; ++i) {
            temp[i] = arr[i];
        }
        return temp;
    }

    public static boolean isInteger(double x) {
        return x == (double)((int)x);
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.props == null) {
            this.props = new Properties();
        }
        if (value == null || value.length() == 0) {
            this.props.remove(key);
        } else {
            this.props.setProperty(key, value);
        }
    }

    public String getProperty(String property) {
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty(property);
    }

    public void setProperties(String properties) {
        if (this.props == null) {
            this.props = new Properties();
        } else {
            this.props.clear();
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(properties.getBytes("utf-8"));
            this.props.load(is);
        }
        catch (Exception e) {
            IJ.error("" + e);
        }
    }

    public String getProperties() {
        if (this.props == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>();
        Enumeration<Object> en = this.props.keys();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
        Object[] keys = new String[v.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)v.elementAt(i);
        }
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            sb.append((String)keys[i]);
            sb.append(": ");
            sb.append(this.props.get(keys[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getPropertyCount() {
        if (this.props == null) {
            return 0;
        }
        return this.props.size();
    }

    public String toString() {
        return "Roi[" + this.getTypeAsString() + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public void temporarilyHide() {
    }

    public void mouseDragged(MouseEvent e) {
        this.handleMouseDrag(e.getX(), e.getY(), e.getModifiers());
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.handleMouseUp(e.getX(), e.getY());
    }

    public double getXBase() {
        if (this.bounds != null) {
            return this.bounds.x;
        }
        return this.x;
    }

    public double getYBase() {
        if (this.bounds != null) {
            return this.bounds.y;
        }
        return this.y;
    }

    public double getFloatWidth() {
        if (this.bounds != null) {
            return this.bounds.width;
        }
        return this.width;
    }

    public double getFloatHeight() {
        if (this.bounds != null) {
            return this.bounds.height;
        }
        return this.height;
    }

    public double getAngle() {
        return 0.0;
    }

    public void enableSubPixelResolution() {
        this.bounds = new Rectangle2D.Double(this.getXBase(), this.getYBase(), this.getFloatWidth(), this.getFloatHeight());
        this.subPixel = true;
    }

    public void setIsCursor(boolean isCursor) {
        this.isCursor = isCursor;
    }

    public boolean isCursor() {
        return this.isCursor;
    }

    public String getDebugInfo() {
        return "";
    }

    public ImageStatistics getStatistics() {
        Roi roi = this;
        ImageProcessor ip = null;
        if (this.imp != null) {
            ip = this.imp.getProcessor();
        }
        boolean noImage = ip == null;
        Rectangle bounds = null;
        if (noImage) {
            roi = (Roi)this.clone();
            bounds = roi.getBounds();
            ip = new ByteProcessor(bounds.width, bounds.height);
            roi.setLocation(0, 0);
        }
        if (roi.isLine()) {
            roi = null;
        }
        ip.setRoi(roi);
        ImageStatistics stats = ip.getStatistics();
        if (noImage) {
            stats.max = Double.NaN;
            stats.min = Double.NaN;
            stats.mean = Double.NaN;
            stats.xCentroid += (double)bounds.x;
            stats.yCentroid += (double)bounds.y;
        }
        ip.resetRoi();
        return stats;
    }

    public FloatPolygon getRotationCenter() {
        FloatPolygon p = new FloatPolygon();
        Rectangle2D.Double r = this.getFloatBounds();
        if (Double.isNaN(this.xcenter)) {
            this.xcenter = ((RectangularShape)r).getX() + ((RectangularShape)r).getWidth() / 2.0;
            this.ycenter = ((RectangularShape)r).getY() + ((RectangularShape)r).getHeight() / 2.0;
        }
        p.addPoint(this.xcenter, this.ycenter);
        return p;
    }

    public void setRotationCenter(double x, double y) {
        this.xcenter = x;
        this.ycenter = y;
    }

    public int size() {
        return this.getFloatPolygon().npoints;
    }

    public double[] getContourCentroid() {
        double xC = 0.0;
        double yC = 0.0;
        double lSum = 0.0;
        FloatPolygon poly = this.getFloatPolygon();
        int nPoints = poly.npoints;
        int n2 = nPoints - 1;
        int n1 = 0;
        while (n1 < nPoints) {
            double dx = poly.xpoints[n1] - poly.xpoints[n2];
            double dy = poly.ypoints[n1] - poly.ypoints[n2];
            double x = (double)poly.xpoints[n2] + dx / 2.0;
            double y = (double)poly.ypoints[n2] + dy / 2.0;
            double l = Math.sqrt(dx * dx + dy * dy);
            xC += x * l;
            yC += y * l;
            lSum += l;
            n2 = n1++;
        }
        return new double[]{xC /= lSum, yC /= lSum};
    }

    public Roi convertToPolygon() {
        return Roi.convertLineToArea(this);
    }

    public static Roi convertLineToArea(Roi line) {
        if (line == null || !line.isLine()) {
            throw new IllegalArgumentException("Line selection required");
        }
        double lineWidth = line.getStrokeWidth();
        Roi roi2 = null;
        if (line.getType() == 5) {
            if (lineWidth <= 1.0) {
                lineWidth = 1.0000001;
            }
            FloatPolygon p = ((Line)line).getFloatPolygon(lineWidth);
            roi2 = new PolygonRoi(p, 2);
            line.setStrokeWidth(lineWidth);
        } else {
            if (lineWidth < 1.0) {
                lineWidth = 1.0;
            }
            Rectangle bounds = line.getBounds();
            double width = (double)(bounds.x + bounds.width) + lineWidth;
            double height = (double)(bounds.y + bounds.height) + lineWidth;
            ByteProcessor ip = new ByteProcessor((int)Math.round(width), (int)Math.round(height));
            PolygonFiller polygonFiller = new PolygonFiller();
            double radius = lineWidth / 2.0;
            FloatPolygon p = line.getFloatPolygon();
            int n = p.npoints;
            float[] xv = new float[4];
            float[] yv = new float[4];
            float[] xt = new float[3];
            float[] yt = new float[3];
            double dx1 = p.xpoints[1] - p.xpoints[0];
            double dy1 = p.ypoints[1] - p.ypoints[0];
            double l = Roi.length(dx1, dy1);
            double dx0 = dx1 /= l;
            double dy0 = dy1 /= l;
            double xfrom = (double)p.xpoints[0] - 0.5 * dx1;
            double yfrom = (double)p.ypoints[0] - 0.5 * dy1;
            for (int i = 1; i < n; ++i) {
                double xto = p.xpoints[i];
                double yto = p.ypoints[i];
                if (i == n - 1) {
                    xto += 0.5 * dx1;
                    yto += 0.5 * dy1;
                }
                xv[0] = (float)(xfrom + radius * dy1);
                yv[0] = (float)(yfrom - radius * dx1);
                xv[1] = (float)(xfrom - radius * dy1);
                yv[1] = (float)(yfrom + radius * dx1);
                xv[2] = (float)(xto - radius * dy1);
                yv[2] = (float)(yto + radius * dx1);
                xv[3] = (float)(xto + radius * dy1);
                yv[3] = (float)(yto - radius * dx1);
                polygonFiller.setPolygon(xv, yv, 4, 0.5, 0.5);
                polygonFiller.fillByteProcessorMask(ip);
                if (i > 1) {
                    boolean rightTurn = dx1 * dy0 > dx0 * dy1;
                    xt[0] = (float)xfrom;
                    yt[0] = (float)yfrom;
                    if (rightTurn) {
                        xt[1] = (float)(xfrom - radius * dy0);
                        yt[1] = (float)(yfrom + radius * dx0);
                        xt[2] = (float)(xfrom - radius * dy1);
                        yt[2] = (float)(yfrom + radius * dx1);
                        xt[0] = xt[0] + (float)(0.5 * (radius * dy0 + radius * dy1));
                        yt[0] = yt[0] - (float)(0.5 * (radius * dx0 + radius * dx1));
                    } else {
                        xt[1] = (float)(xfrom + radius * dy0);
                        yt[1] = (float)(yfrom - radius * dx0);
                        xt[2] = (float)(xfrom + radius * dy1);
                        yt[2] = (float)(yfrom - radius * dx1);
                        xt[0] = xt[0] - (float)(0.5 * (radius * dy0 + radius * dy1));
                        yt[0] = yt[0] + (float)(0.5 * (radius * dx0 + radius * dx1));
                    }
                    polygonFiller.setPolygon(xt, yt, 3, 0.5, 0.5);
                    polygonFiller.fillByteProcessorMask(ip);
                }
                dx0 = dx1;
                dy0 = dy1;
                xfrom = xto;
                yfrom = yto;
                if (i >= n - 1) continue;
                dx1 = p.xpoints[i + 1] - p.xpoints[i];
                dy1 = p.ypoints[i + 1] - p.ypoints[i];
                l = Roi.length(dx1, dy1);
                dx1 /= l;
                dy1 /= l;
            }
            ip.setThreshold(255.0, 255.0, 2);
            ThresholdToSelection tts = new ThresholdToSelection();
            roi2 = tts.convert(ip);
        }
        if (roi2 == null) {
            return null;
        }
        Roi.transferProperties(line, roi2);
        roi2.setStrokeWidth(0.0f);
        Color c = roi2.getStrokeColor();
        if (c != null) {
            roi2.setStrokeColor(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        }
        return roi2;
    }

    static double length(double dx, double dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    static double sqr(double x) {
        return x * x;
    }

    private static void transferProperties(Roi roi1, Roi roi2) {
        if (roi1 == null || roi2 == null) {
            return;
        }
        roi2.setStrokeColor(roi1.getStrokeColor());
        if (roi1.getStroke() != null) {
            roi2.setStroke(roi1.getStroke());
        }
        roi2.setDrawOffset(roi1.getDrawOffset());
    }

    public int getHashCode() {
        return this.hashCode() ^ new Double(this.getXBase()).hashCode() ^ Integer.rotateRight(new Double(this.getYBase()).hashCode(), 16);
    }

    public void setFlattenScale(double scale) {
        this.flattenScale = scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(int id) {
        if (id == 1) {
            if (this.listenersNotified) {
                return;
            }
            this.listenersNotified = true;
        }
        Vector vector = listeners;
        synchronized (vector) {
            for (int i = 0; i < listeners.size(); ++i) {
                RoiListener listener = (RoiListener)listeners.elementAt(i);
                listener.roiModified(this.imp, id);
            }
        }
    }

    public static void addRoiListener(RoiListener listener) {
        listeners.addElement(listener);
    }

    public static void removeRoiListener(RoiListener listener) {
        listeners.removeElement(listener);
    }

    @Override
    public Iterator<Point> iterator() {
        return new RoiPointsIteratorMask();
    }

    static {
        onePixelWide = new BasicStroke(1.0f);
        ROIColor = Prefs.getColor("roicolor", Color.yellow);
        pasteMode = 0;
        lineWidth = 1;
        listeners = new Vector();
    }

    private class RoiPointsIteratorMask
    implements Iterator<Point> {
        private ImageProcessor mask;
        private final Rectangle bounds;
        private final int xbase;
        private final int ybase;
        private final int n;
        private int next;

        RoiPointsIteratorMask() {
            if (Roi.this.isLine()) {
                Roi roi2 = Roi.convertLineToArea(Roi.this);
                this.mask = roi2.getMask();
                this.xbase = roi2.x;
                this.ybase = roi2.y;
            } else {
                this.mask = Roi.this.getMask();
                if (this.mask == null && Roi.this.type == 0) {
                    this.mask = new ByteProcessor(Roi.this.width, Roi.this.height);
                    this.mask.invert();
                }
                this.xbase = Roi.this.x;
                this.ybase = Roi.this.y;
            }
            this.bounds = new Rectangle(this.mask.getWidth(), this.mask.getHeight());
            this.n = this.bounds.width * this.bounds.height;
            this.findNext(0);
        }

        @Override
        public boolean hasNext() {
            return this.next < this.n;
        }

        @Override
        public Point next() {
            if (this.next >= this.n) {
                throw new NoSuchElementException();
            }
            int x = this.next % this.bounds.width;
            int y = this.next / this.bounds.width;
            this.findNext(this.next + 1);
            return new Point(this.xbase + x, this.ybase + y);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext(int start) {
            if (this.mask == null) {
                this.next = start;
            } else {
                this.next = this.n;
                for (int i = start; i < this.n; ++i) {
                    if (this.mask.get(i) == 0) continue;
                    this.next = i;
                    break;
                }
            }
        }
    }
}

