/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.ImageJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.plugin.frame.PlugInFrame;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Commands
extends PlugInFrame
implements ActionListener,
ItemListener,
CommandListener {
    public static final String LOC_KEY = "commands.loc";
    public static final String CMDS_KEY = "commands.cmds";
    public static final int MAX_COMMANDS = 20;
    private static Frame instance;
    private static final String divider = "---------------";
    private static final String[] commands;
    private List list;
    private String command;
    private Button button;

    public Commands() {
        super("Commands");
        if (instance != null) {
            WindowManager.toFront(instance);
            return;
        }
        instance = this;
        WindowManager.addWindow(this);
        this.list = new List(20);
        this.list.addItemListener(this);
        String cmds = Prefs.get(CMDS_KEY, null);
        if (cmds != null) {
            int i;
            String[] cmd = cmds.split(",");
            int len = cmd.length <= 20 ? cmd.length : 20;
            boolean isDivider = false;
            for (i = 0; i < len; ++i) {
                if (!divider.equals(cmd[i])) continue;
                isDivider = true;
                break;
            }
            if (isDivider) {
                for (i = 0; i < len; ++i) {
                    this.list.add(cmd[i]);
                }
            } else {
                cmds = null;
            }
        }
        if (cmds == null) {
            this.list.add(divider);
            int len = commands.length < 20 ? commands.length : 19;
            for (int i = 0; i < len; ++i) {
                this.list.add(commands[i]);
            }
        }
        ImageJ ij = IJ.getInstance();
        this.addKeyListener(ij);
        Executer.addCommandListener(this);
        GUI.scale(this.list);
        this.list.addKeyListener(ij);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.add((Component)this.list, c);
        this.button = new Button("Edit");
        this.button.addActionListener(this);
        this.button.addKeyListener(ij);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 10;
        this.add((Component)this.button, c);
        this.pack();
        Dimension size = this.getSize();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        GenericDialog gd = new GenericDialog("Commands");
        int dividerIndex = this.getDividerIndex();
        StringBuilder sb = new StringBuilder(200);
        sb.append("| ");
        for (int i2 = 0; i2 < dividerIndex; ++i2) {
            String cmd = this.list.getItem(i2);
            sb.append(cmd);
            sb.append(" | ");
        }
        sb.append("Debug Mode | Hyperstack |");
        String recentCommands = sb.toString();
        gd.setInsets(5, 0, 0);
        gd.addTextAreas(recentCommands, null, 5, 28);
        int index = dividerIndex + 1;
        int n = 1;
        for (i = index; i < this.list.getItemCount(); ++i) {
            gd.setInsets(2, 8, 0);
            gd.addStringField("Cmd" + IJ.pad(n++, 2) + ":", this.list.getItem(i), 20);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        for (i = index; i < this.list.getItemCount(); ++i) {
            this.list.replaceItem(gd.getNextString(), i);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.command = this.list.getItem(index);
            if (!this.command.equals(divider)) {
                if (this.command.equals("Debug Mode")) {
                    IJ.runMacro("setOption('DebugMode')");
                } else if (this.command.equals("Hyperstack")) {
                    IJ.runMacro("newImage('HyperStack', '8-bit color label', 400, 300, 3, 4, 25)");
                } else {
                    IJ.doCommand(this.command);
                }
            }
            this.list.deselect(index);
        }
    }

    @Override
    public String commandExecuting(String cmd2) {
        if ("Quit".equals(cmd2)) {
            return cmd2;
        }
        String cmd1 = this.command;
        if (cmd1 == null || !cmd1.equals(cmd2)) {
            try {
                this.list.remove(cmd2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.list.getItemCount() >= 20) {
                this.list.remove(this.getDividerIndex() - 1);
            }
            this.list.add(cmd2, 0);
        }
        this.command = null;
        return cmd2;
    }

    private int getDividerIndex() {
        int index = 0;
        for (int i = 0; i < 20; ++i) {
            String cmd = this.list.getItem(i);
            if (!divider.equals(cmd)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void close() {
        super.close();
        instance = null;
        Executer.removeCommandListener(this);
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        StringBuilder sb = new StringBuilder(200);
        for (int i = 0; i < this.list.getItemCount(); ++i) {
            String cmd = this.list.getItem(i);
            sb.append(cmd);
            sb.append(",");
        }
        String cmds = sb.toString();
        cmds = cmds.substring(0, cmds.length() - 1);
        Prefs.set(CMDS_KEY, cmds);
    }

    static {
        commands = new String[]{"Blobs (25K)", "Open...", "Show Info...", "Close", "Close All", "Histogram", "Find Maxima...", "Gaussian Blur...", "Record...", "Capture Screen", "Find Commands..."};
    }
}

