/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.plugin.frame.Commands;
import ij.plugin.frame.Editor;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.CheckboxMenuItem;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.MenuItem;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class WindowManager {
    public static boolean checkForDuplicateName;
    private static Vector imageList;
    private static Vector activations;
    private static Vector nonImageList;
    private static ImageWindow currentWindow;
    private static Window frontWindow;
    private static Frame frontFrame;
    private static Hashtable tempImageTable;

    private WindowManager() {
    }

    public static void setCurrentWindow(ImageWindow win) {
        ImagePlus imp;
        if (win == null || win.isClosed() || win.getImagePlus() == null) {
            return;
        }
        WindowManager.setWindow(win);
        tempImageTable.remove(Thread.currentThread());
        if (win == currentWindow || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imp = currentWindow.getImagePlus()) != null) {
            if (!Prefs.keepUndoBuffers) {
                imp.trimProcessor();
            }
            imp.saveRoi();
        }
        Undo.reset();
        currentWindow = win;
        activations.remove(win);
        activations.add(win);
        Menus.updateMenus();
        if (Recorder.record && !IJ.isMacro()) {
            Recorder.record("selectWindow", win.getImagePlus().getTitle());
        }
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static ImagePlus getCurrentImage() {
        ImagePlus img = (ImagePlus)tempImageTable.get(Thread.currentThread());
        if (img == null) {
            img = WindowManager.getActiveImage();
        }
        return img;
    }

    public static void setTempCurrentImage(ImagePlus img) {
        if (img == null) {
            tempImageTable.remove(Thread.currentThread());
        } else {
            tempImageTable.put(Thread.currentThread(), img);
        }
    }

    public static void setTempCurrentImage(Thread thread, ImagePlus img) {
        if (thread == null) {
            throw new RuntimeException("thread==null");
        }
        if (img == null) {
            tempImageTable.remove(thread);
        } else {
            tempImageTable.put(thread, img);
        }
    }

    private static ImagePlus getActiveImage() {
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        if (frontWindow != null && frontWindow instanceof ImageWindow) {
            return frontWindow != null ? ((ImageWindow)frontWindow).getImagePlus() : null;
        }
        if (imageList.size() > 0) {
            ImagePlus imp = WindowManager.getFocusManagerActiveImage();
            if (imp != null) {
                return imp;
            }
            ImageWindow win = (ImageWindow)imageList.get(imageList.size() - 1);
            return win.getImagePlus();
        }
        return Interpreter.getLastBatchModeImage();
    }

    private static ImagePlus getFocusManagerActiveImage() {
        if (IJ.isMacro()) {
            return null;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window win = kfm.getActiveWindow();
        ImagePlus imp = null;
        if (win != null && win instanceof ImageWindow) {
            imp = ((ImageWindow)win).getImagePlus();
        }
        return imp;
    }

    public static int getWindowCount() {
        int count = imageList.size();
        return count;
    }

    public static int getImageCount() {
        int count = imageList.size();
        if ((count += Interpreter.getBatchModeImageCount()) == 0 && WindowManager.getCurrentImage() != null) {
            count = 1;
        }
        return count;
    }

    public static Window getActiveWindow() {
        return frontWindow;
    }

    public static Frame getFrontWindow() {
        return frontFrame;
    }

    public static synchronized int[] getIDList() {
        int[] batchModeImages;
        int nBatchImages;
        int nWindows = imageList.size();
        if (nWindows + (nBatchImages = (batchModeImages = Interpreter.getBatchModeImageIDs()).length) == 0) {
            return null;
        }
        int[] list = new int[nWindows + nBatchImages];
        for (int i = 0; i < nBatchImages; ++i) {
            list[i] = batchModeImages[i];
        }
        int index = 0;
        for (int i = nBatchImages; i < nBatchImages + nWindows; ++i) {
            ImageWindow win = (ImageWindow)imageList.get(index++);
            list[i] = win.getImagePlus().getID();
        }
        return list;
    }

    public static synchronized String[] getImageTitles() {
        int[] list = WindowManager.getIDList();
        if (list == null) {
            return new String[0];
        }
        String[] titles = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            ImagePlus img = WindowManager.getImage(list[i]);
            titles[i] = img.getTitle();
        }
        return titles;
    }

    public static synchronized Frame[] getNonImageWindows() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < nonImageList.size(); ++i) {
            Object win = nonImageList.get(i);
            if (!(win instanceof Frame)) continue;
            list.add(win);
        }
        Frame[] frames = new Frame[list.size()];
        list.toArray(frames);
        return frames;
    }

    public static synchronized Window[] getAllNonImageWindows() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < nonImageList.size(); ++i) {
            Object win = nonImageList.get(i);
            if (!(win instanceof Window)) continue;
            list.add(win);
        }
        Window[] windows = new Window[list.size()];
        list.toArray(windows);
        return windows;
    }

    public static synchronized String[] getNonImageTitles() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nonImageList.size(); ++i) {
            Object win = nonImageList.get(i);
            String title = win instanceof Frame ? ((Frame)win).getTitle() : ((Dialog)win).getTitle();
            list.add(title);
        }
        String[] titles = new String[list.size()];
        list.toArray(titles);
        return titles;
    }

    public static synchronized ImagePlus getImage(int imageID) {
        if (imageID > 0) {
            imageID = WindowManager.getNthImageID(imageID);
        }
        if (imageID == 0 || WindowManager.getImageCount() == 0) {
            return null;
        }
        ImagePlus imp2 = Interpreter.getBatchModeImage(imageID);
        if (imp2 != null) {
            return imp2;
        }
        ImagePlus imp = null;
        for (int i = 0; i < imageList.size(); ++i) {
            ImageWindow win = (ImageWindow)imageList.get(i);
            imp2 = win.getImagePlus();
            if (imageID != imp2.getID()) continue;
            imp = imp2;
            break;
        }
        imp2 = WindowManager.getCurrentImage();
        if (imp == null && imp2 != null && imp2.getID() == imageID) {
            return imp2;
        }
        return imp;
    }

    public static synchronized int getNthImageID(int n) {
        if (n <= 0) {
            return 0;
        }
        if (Interpreter.isBatchMode()) {
            int[] list = WindowManager.getIDList();
            if (n > list.length) {
                return 0;
            }
            return list[n - 1];
        }
        if (n > imageList.size()) {
            return 0;
        }
        ImageWindow win = (ImageWindow)imageList.get(n - 1);
        if (win != null) {
            return win.getImagePlus().getID();
        }
        return 0;
    }

    public static synchronized ImagePlus getImage(String title) {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            return null;
        }
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp == null || !imp.getTitle().equals(title)) continue;
            return imp;
        }
        return null;
    }

    public static synchronized void addWindow(Window win) {
        if (win == null) {
            return;
        }
        if (win instanceof ImageWindow) {
            WindowManager.addImageWindow((ImageWindow)win);
        } else {
            Menus.insertWindowMenuItem(win);
            nonImageList.add(win);
        }
    }

    public static void addWindow(Frame win) {
        WindowManager.addWindow((Window)win);
    }

    private static void addImageWindow(ImageWindow win) {
        ImagePlus imp = win.getImagePlus();
        if (imp == null) {
            return;
        }
        WindowManager.checkForDuplicateName(imp);
        imageList.add(win);
        Menus.addWindowMenuItem(imp);
        WindowManager.setCurrentWindow(win);
    }

    static void checkForDuplicateName(ImagePlus imp) {
        String name;
        if (checkForDuplicateName && WindowManager.isDuplicateName(name = imp.getTitle())) {
            imp.setTitle(WindowManager.getUniqueName(name));
        }
        checkForDuplicateName = false;
    }

    static boolean isDuplicateName(String name) {
        int n = imageList.size();
        for (int i = 0; i < n; ++i) {
            ImageWindow win = (ImageWindow)imageList.get(i);
            String name2 = win.getImagePlus().getTitle();
            if (!name.equals(name2)) continue;
            return true;
        }
        return false;
    }

    public static String getUniqueName(String name) {
        String name2 = name;
        String extension = "";
        int len = name2.length();
        int lastDot = name2.lastIndexOf(".");
        if (lastDot != -1 && len - lastDot < 6 && lastDot != len - 1) {
            extension = name2.substring(lastDot, len);
            name2 = name2.substring(0, lastDot);
        }
        int lastDash = name2.lastIndexOf("-");
        len = name2.length();
        if (lastDash != -1 && len - lastDash < 4 && lastDash < len - 1 && Character.isDigit(name2.charAt(lastDash + 1)) && name2.charAt(lastDash + 1) != '0') {
            name2 = name2.substring(0, lastDash);
        }
        for (int i = 1; i <= 99; ++i) {
            String name3 = name2 + "-" + i + extension;
            if (WindowManager.isDuplicateName(name3)) continue;
            return name3;
        }
        return name;
    }

    public static String makeUniqueName(String name) {
        return WindowManager.isDuplicateName(name) ? WindowManager.getUniqueName(name) : name;
    }

    public static void removeWindow(Window win) {
        if (win instanceof ImageWindow) {
            WindowManager.removeImageWindow((ImageWindow)win);
        } else {
            int index = nonImageList.indexOf(win);
            ImageJ ij = IJ.getInstance();
            if (index >= 0) {
                Menus.removeWindowMenuItem(index);
                nonImageList.removeElement(win);
            }
        }
        WindowManager.setWindow(null);
    }

    public static void removeWindow(Frame win) {
        WindowManager.removeWindow((Window)win);
    }

    private static void removeImageWindow(ImageWindow win) {
        int index = imageList.indexOf(win);
        if (index == -1) {
            return;
        }
        try {
            imageList.remove(win);
            activations.remove(win);
            if (imageList.size() > 1 && !Prefs.closingAll) {
                ImageWindow win2 = activations.size() > 0 ? (ImageWindow)activations.get(activations.size() - 1) : null;
                WindowManager.setCurrentWindow(win2);
            } else {
                currentWindow = null;
            }
            WindowManager.setTempCurrentImage(null);
            int nonImageCount = nonImageList.size();
            if (nonImageCount > 0) {
                ++nonImageCount;
            }
            Menus.removeWindowMenuItem(nonImageCount + index);
            Menus.updateMenus();
            Undo.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setWindow(Window win) {
        frontWindow = win;
        if (win instanceof Frame) {
            frontFrame = (Frame)win;
        }
    }

    public static void setWindow(Frame win) {
        frontWindow = win;
        frontFrame = win;
    }

    public static synchronized boolean closeAllWindows() {
        Prefs.closingAll = true;
        while (imageList.size() > 0) {
            if (!((ImageWindow)imageList.get(0)).close()) {
                Prefs.closingAll = false;
                return false;
            }
            if (WindowManager.quittingViaMacro()) continue;
            IJ.wait(100);
        }
        Prefs.closingAll = false;
        Frame[] nonImages = WindowManager.getNonImageWindows();
        for (int i = 0; i < nonImages.length; ++i) {
            Frame frame = nonImages[i];
            if (frame != null && frame instanceof Commands) {
                ((Commands)frame).close();
                continue;
            }
            if (frame == null || !(frame instanceof Editor)) continue;
            ((Editor)frame).close();
            if (((Editor)frame).fileChanged()) {
                return false;
            }
            if (WindowManager.quittingViaMacro()) continue;
            IJ.wait(100);
        }
        ImageJ ij = IJ.getInstance();
        if (ij != null && ij.quitting() && IJ.getApplet() == null) {
            return true;
        }
        for (int i = 0; i < nonImages.length; ++i) {
            Frame frame = nonImages[i];
            if (frame instanceof PlugInFrame && !(frame instanceof Editor)) {
                ((PlugInFrame)frame).close();
                continue;
            }
            if (frame instanceof TextWindow) {
                ((TextWindow)frame).close();
                continue;
            }
            frame.dispose();
        }
        return true;
    }

    private static boolean quittingViaMacro() {
        ImageJ ij = IJ.getInstance();
        return ij != null && ij.quittingViaMacro();
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.log("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int index = imageList.indexOf(currentWindow);
        ImageWindow win = null;
        int count = 0;
        do {
            if (--index < 0) {
                index = imageList.size() - 1;
            }
            win = (ImageWindow)imageList.get(index);
            if (++count != imageList.size()) continue;
            return;
        } while (win instanceof HistogramWindow || win instanceof PlotWindow);
        if (win == null) {
            return;
        }
        ImagePlus imp = win.getImagePlus();
        if (imp != null) {
            IJ.selectWindow(imp.getID());
        }
    }

    public static ImagePlus getTempCurrentImage() {
        return (ImagePlus)tempImageTable.get(Thread.currentThread());
    }

    public static Window getWindow(String title) {
        for (int i = 0; i < nonImageList.size(); ++i) {
            String winTitle;
            Object win = nonImageList.get(i);
            String string = winTitle = win instanceof Frame ? ((Frame)win).getTitle() : ((Dialog)win).getTitle();
            if (!title.equals(winTitle)) continue;
            return (Window)win;
        }
        return WindowManager.getImageWindow(title);
    }

    public static Frame getFrame(String title) {
        Object win;
        for (int i = 0; i < nonImageList.size(); ++i) {
            String winTitle;
            win = nonImageList.get(i);
            String string = winTitle = win instanceof Frame ? ((Frame)win).getTitle() : null;
            if (!title.equals(winTitle)) continue;
            return (Frame)win;
        }
        Frame frame = WindowManager.getImageWindow(title);
        if (frame == null && (win = WindowManager.getWindow(title)) != null) {
            frame = new Frame("Proxy");
        }
        return frame;
    }

    private static Frame getImageWindow(String title) {
        int[] wList = WindowManager.getIDList();
        int len = wList != null ? wList.length : 0;
        for (int i = 0; i < len; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp == null || !imp.getTitle().equals(title)) continue;
            return imp.getWindow();
        }
        return null;
    }

    static synchronized void activateWindow(String menuItemLabel, MenuItem item) {
        int start;
        String idString;
        int id;
        ImagePlus imp;
        for (int i = 0; i < nonImageList.size(); ++i) {
            String title;
            Object win = nonImageList.get(i);
            String string = title = win instanceof Frame ? ((Frame)win).getTitle() : ((Dialog)win).getTitle();
            if (!menuItemLabel.equals(title)) continue;
            if (win instanceof Frame) {
                WindowManager.toFront((Frame)win);
            } else {
                ((Dialog)win).toFront();
            }
            ((CheckboxMenuItem)item).setState(false);
            if (Recorder.record && !IJ.isMacro()) {
                Recorder.record("selectWindow", title);
            }
            return;
        }
        int lastSpace = menuItemLabel.lastIndexOf(32);
        if (lastSpace > 0) {
            menuItemLabel = menuItemLabel.substring(0, lastSpace);
        }
        if ((imp = WindowManager.getImage(id = (int)Tools.parseDouble(idString = item.getActionCommand(), 0.0))) == null) {
            return;
        }
        ImageWindow win1 = imp.getWindow();
        if (win1 == null) {
            return;
        }
        WindowManager.setCurrentWindow(win1);
        WindowManager.toFront(win1);
        int index = imageList.indexOf(win1);
        int n = Menus.window.getItemCount();
        for (int j = start = 6 + Menus.windowMenuItems2; j < n; ++j) {
            MenuItem mi = Menus.window.getItem(j);
            if (!(mi instanceof CheckboxMenuItem)) continue;
            ((CheckboxMenuItem)mi).setState(j - start == index);
        }
    }

    public static synchronized void repaintImageWindows() {
        int[] list = WindowManager.getIDList();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            ImagePlus imp2 = WindowManager.getImage(list[i]);
            if (imp2 == null) continue;
            imp2.setTitle(imp2.getTitle());
            ImageWindow win = imp2.getWindow();
            if (win == null) continue;
            win.repaint();
        }
    }

    public static void showList() {
        ImagePlus imp;
        ImageWindow win;
        int i;
        for (i = 0; i < imageList.size(); ++i) {
            win = (ImageWindow)imageList.get(i);
            imp = win.getImagePlus();
            IJ.log(i + " " + imp.getTitle() + (win == currentWindow ? "*" : "") + " " + imp.getID());
        }
        for (i = 0; i < activations.size(); ++i) {
            win = (ImageWindow)activations.get(i);
            imp = win.getImagePlus();
            IJ.log(i + " " + imp.getTitle() + " " + imp.getID());
        }
        if (imageList.size() == 0) {
            IJ.log("imageList is empty");
        }
        if (activations.size() == 0) {
            IJ.log("activations list is empty");
        }
        IJ.log(" ");
    }

    public static void toFront(Frame frame) {
        if (frame == null) {
            return;
        }
        if (frame.getState() == 1) {
            frame.setState(0);
        }
        frame.toFront();
    }

    public static void toFront(Window window) {
        if (window == null) {
            return;
        }
        if (window instanceof Frame && ((Frame)window).getState() == 1) {
            ((Frame)window).setState(0);
        }
        window.toFront();
    }

    static {
        imageList = new Vector();
        activations = new Vector();
        nonImageList = new Vector();
        tempImageTable = new Hashtable();
    }
}

