/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackReducer
implements PlugIn {
    ImagePlus imp;
    private static int factor = 2;
    private boolean hyperstack;
    private boolean reduceSlices;

    @Override
    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        ImageStack stack = this.imp.getStack();
        int size = stack.size();
        if (size == 1 || this.imp.getNChannels() == size && this.imp.isComposite()) {
            IJ.error("Stack or hyperstack required");
            return;
        }
        if (!this.showDialog(stack)) {
            return;
        }
        if (this.hyperstack) {
            this.reduceHyperstack(this.imp, factor, this.reduceSlices);
        } else {
            this.reduceStack(this.imp, factor);
        }
    }

    public boolean showDialog(ImageStack stack) {
        this.hyperstack = this.imp.isHyperStack();
        boolean showCheckbox = false;
        if (this.hyperstack && this.imp.getNSlices() > 1 && this.imp.getNFrames() > 1) {
            showCheckbox = true;
        } else if (this.hyperstack && this.imp.getNSlices() > 1) {
            this.reduceSlices = true;
        }
        int n = stack.size();
        GenericDialog gd = new GenericDialog("Reduce Size");
        gd.addNumericField("Reduction Factor:", factor, 0);
        if (showCheckbox) {
            gd.addCheckbox("Reduce in Z-Dimension", false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        factor = (int)gd.getNextNumber();
        if (showCheckbox) {
            this.reduceSlices = gd.getNextBoolean();
        }
        return true;
    }

    public void reduceStack(ImagePlus imp, int factor) {
        Calibration cal;
        ImageStack stack = imp.getStack();
        boolean virtual = stack.isVirtual();
        int n = stack.size();
        ImageStack stack2 = new ImageStack(stack.getWidth(), stack.getHeight());
        for (int i = 1; i <= n; i += factor) {
            if (virtual) {
                IJ.showProgress(i, n);
            }
            stack2.addSlice(stack.getSliceLabel(i), stack.getProcessor(i));
        }
        imp.setStack(null, stack2);
        if (virtual) {
            IJ.showProgress(1.0);
            imp.setTitle(imp.getTitle());
        }
        if ((cal = imp.getCalibration()).scaled()) {
            cal.pixelDepth *= (double)factor;
        }
    }

    public void reduceHyperstack(ImagePlus imp, int factor, boolean reduceSlices) {
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int zfactor = reduceSlices ? factor : 1;
        int tfactor = reduceSlices ? 1 : factor;
        ImageStack stack = imp.getStack();
        ImageStack stack2 = new ImageStack(imp.getWidth(), imp.getHeight());
        boolean virtual = stack.isVirtual();
        int slices2 = slices / zfactor + (slices % zfactor != 0 ? 1 : 0);
        int frames2 = frames / tfactor + (frames % tfactor != 0 ? 1 : 0);
        int n = channels * slices2 * frames2;
        boolean count = true;
        for (int t = 1; t <= frames; t += tfactor) {
            for (int z = 1; z <= slices; z += zfactor) {
                for (int c = 1; c <= channels; ++c) {
                    int i = imp.getStackIndex(c, z, t);
                    IJ.showProgress(i, n);
                    ImageProcessor ip = stack.getProcessor(imp.getStackIndex(c, z, t));
                    stack2.addSlice(stack.getSliceLabel(i), ip);
                }
            }
        }
        imp.setStack(stack2, channels, slices2, frames2);
        Calibration cal = imp.getCalibration();
        if (cal.scaled()) {
            cal.pixelDepth *= (double)zfactor;
        }
        if (virtual) {
            imp.setTitle(imp.getTitle());
        }
        IJ.showProgress(1.0);
    }
}

