/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;

public class Translator
implements ExtendedPlugInFilter,
DialogListener {
    private int flags = 32799;
    private static double xOffset = 15.0;
    private static double yOffset = 15.0;
    private ImagePlus imp;
    private GenericDialog gd;
    private PlugInFilterRunner pfr;
    private static int interpolationMethod = 0;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private boolean previewing;
    private Overlay origOverlay;
    private boolean overlayOnly;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp != null) {
            this.origOverlay = imp.getOverlay();
        }
        return this.flags;
    }

    @Override
    public void run(ImageProcessor ip) {
        ip.setInterpolationMethod(interpolationMethod);
        if (!this.overlayOnly || this.origOverlay == null) {
            ip.translate(xOffset, yOffset);
        }
        if (this.origOverlay != null) {
            Overlay overlay = this.origOverlay.duplicate();
            overlay.translate(xOffset, yOffset);
            this.imp.setOverlay(overlay);
        }
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        int digits;
        this.pfr = pfr;
        int n = digits = xOffset == (double)((int)xOffset) && yOffset == (double)((int)yOffset) ? 1 : 3;
        if (IJ.isMacro()) {
            interpolationMethod = 0;
        }
        this.gd = new GenericDialog("Translate");
        this.gd.addSlider("X offset:", -100.0, 100.0, xOffset, 0.1);
        this.gd.addSlider("Y offset:", -100.0, 100.0, xOffset, 0.1);
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        this.gd.addCheckbox("Overlay only", false);
        this.gd.addPreviewCheckbox(pfr);
        this.gd.addDialogListener(this);
        this.previewing = true;
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            imp.setOverlay(this.origOverlay);
            return 4096;
        }
        this.previewing = false;
        return IJ.setupDialog(imp, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        xOffset = gd.getNextNumber();
        yOffset = gd.getNextNumber();
        interpolationMethod = gd.getNextChoiceIndex();
        this.overlayOnly = gd.getNextBoolean();
        if (gd.invalidNumber()) {
            if (gd.wasOKed()) {
                IJ.error("Offset is invalid.");
            }
            return false;
        }
        return true;
    }

    @Override
    public void setNPasses(int nPasses) {
    }
}

