/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.gui.ColorChooser;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.frame.ColorGenerator;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ColorCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    Rectangle flipperRect = new Rectangle(86, 268, 18, 18);
    Rectangle resetRect = new Rectangle(86, 294, 18, 18);
    Rectangle foreground1Rect = new Rectangle(9, 266, 45, 10);
    Rectangle foreground2Rect = new Rectangle(9, 276, 23, 25);
    Rectangle background1Rect = new Rectangle(33, 302, 45, 10);
    Rectangle background2Rect = new Rectangle(56, 277, 23, 25);
    int width;
    int height;
    Vector colors;
    boolean background;
    long mouseDownTime;
    ColorGenerator ip;
    Frame frame;
    double scale;
    String status = "";

    public ColorCanvas(int width, int height, Frame frame, ColorGenerator ip, double scale) {
        this.width = width;
        this.height = height;
        this.ip = ip;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(IJ.getInstance());
        this.setSize(width, height);
        this.scale = scale;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.ip.createImage(), 0, 0, (int)((double)this.ip.getWidth() * this.scale), (int)((double)this.ip.getHeight() * this.scale), null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.ip.setLineWidth(1);
        if (Toolbar.getToolId() == 13) {
            IJ.setTool(0);
        }
        int x = (int)((double)e.getX() / this.scale);
        int y = (int)((double)e.getY() / this.scale);
        long difference = System.currentTimeMillis() - this.mouseDownTime;
        boolean doubleClick = difference <= 250L;
        this.mouseDownTime = System.currentTimeMillis();
        if (this.flipperRect.contains(x, y)) {
            Color c = Toolbar.getBackgroundColor();
            Toolbar.setBackgroundColor(Toolbar.getForegroundColor());
            Toolbar.setForegroundColor(c);
        } else if (this.resetRect.contains(x, y)) {
            Toolbar.setForegroundColor(Color.white);
            Toolbar.setBackgroundColor(Color.black);
        } else if (this.background1Rect.contains(x, y) || this.background2Rect.contains(x, y)) {
            this.background = true;
            if (doubleClick) {
                this.editColor();
            }
            this.ip.refreshForeground(this.background);
            this.ip.refreshBackground(this.background);
        } else if (this.foreground1Rect.contains(x, y) || this.foreground2Rect.contains(x, y)) {
            this.background = false;
            if (doubleClick) {
                this.editColor();
            }
            this.ip.refreshBackground(this.background);
            this.ip.refreshForeground(this.background);
        } else if (doubleClick) {
            this.editColor();
        } else {
            this.setDrawingColor(x, y, this.background);
            this.showStatus(" ", Toolbar.getForegroundColor().getRGB());
        }
        if (this.background) {
            this.ip.refreshForeground(this.background);
            this.ip.refreshBackground(this.background);
        } else {
            this.ip.refreshBackground(this.background);
            this.ip.refreshForeground(this.background);
        }
        this.showStatus(" ", Toolbar.getForegroundColor().getRGB());
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y;
        int x = (int)((double)e.getX() / this.scale);
        if (this.flipperRect.contains(x, y = (int)((double)e.getY() / this.scale))) {
            this.showStatus("Click to flip foreground and background colors", 0);
        } else if (this.resetRect.contains(x, y)) {
            this.showStatus("Click to reset foreground to white, background to black", 0);
        } else if (!this.background && (this.background1Rect.contains(x, y) || this.background2Rect.contains(x, y))) {
            this.showStatus("Click to switch to background selection mode ", 0);
        } else if (this.background && (this.foreground1Rect.contains(x, y) || this.foreground2Rect.contains(x, y))) {
            this.showStatus("Click to switch to foreground selection mode", 0);
        } else {
            this.showStatus("", this.ip.getPixel(x, y));
        }
    }

    String pad(int n) {
        String str = "" + n;
        while (str.length() < 3) {
            str = "0" + str;
        }
        return str;
    }

    void setDrawingColor(int x, int y, boolean setBackground) {
        int p = this.ip.getPixel(x, y);
        int r = (p & 0xFF0000) >> 16;
        int g = (p & 0xFF00) >> 8;
        int b = p & 0xFF;
        Color c = new Color(r, g, b);
        if (setBackground) {
            Toolbar.setBackgroundColor(c);
            if (Recorder.record) {
                Recorder.setBackgroundColor(c);
            }
        } else {
            Toolbar.setForegroundColor(c);
            if (Recorder.record) {
                Recorder.setForegroundColor(c);
            }
        }
    }

    void editColor() {
        Color c = this.background ? Toolbar.getBackgroundColor() : Toolbar.getForegroundColor();
        ColorChooser cc = new ColorChooser((this.background ? "Background" : "Foreground") + " Color", c, false);
        c = cc.getColor();
        if (this.background) {
            Toolbar.setBackgroundColor(c);
        } else {
            Toolbar.setForegroundColor(c);
        }
    }

    public void refreshColors() {
        this.ip.refreshBackground(false);
        this.ip.refreshForeground(false);
        this.repaint();
    }

    private void showStatus(String msg, int rgb) {
        if (msg.length() > 1) {
            IJ.showStatus(msg);
        } else {
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            String hex = Colors.colorToString(new Color(r, g, b));
            IJ.showStatus("red=" + this.pad(r) + ", green=" + this.pad(g) + ", blue=" + this.pad(b) + " (" + hex + ") " + msg);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

