/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;

public class GUI {
    private static final Font DEFAULT_FONT = IJ.font12;
    private static Color lightGray = new Color(240, 240, 240);
    private static boolean isWindows8;
    private static Color scrollbarBackground;
    private static Frame frame;

    public static void center(Window win, Component target) {
        if (win == null) {
            return;
        }
        Rectangle bounds = GUI.getMaxWindowBounds(target);
        Dimension window = win.getSize();
        if (window.width == 0) {
            return;
        }
        int left = bounds.x + Math.max(0, (bounds.width - window.width) / 2);
        int top = bounds.y + Math.max(0, (bounds.height - window.height) / 4);
        win.setLocation(left, top);
    }

    public static void centerOnImageJScreen(Window win) {
        GUI.center(win, IJ.getInstance());
    }

    public static void center(Window win) {
        GUI.center(win, win);
    }

    private static List<GraphicsConfiguration> getScreenConfigs() {
        ArrayList<GraphicsConfiguration> configs = new ArrayList<GraphicsConfiguration>();
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            configs.add(device.getDefaultConfiguration());
        }
        return configs;
    }

    public static Rectangle getScreenBounds(Point point, boolean accountForInsets) {
        if (GraphicsEnvironment.isHeadless()) {
            return new Rectangle(0, 0, 0, 0);
        }
        for (GraphicsConfiguration config : GUI.getScreenConfigs()) {
            Rectangle bounds = config.getBounds();
            if (bounds == null || !bounds.contains(point)) continue;
            Insets insets = accountForInsets ? Toolkit.getDefaultToolkit().getScreenInsets(config) : null;
            return GUI.shrinkByInsets(bounds, insets);
        }
        return null;
    }

    public static Rectangle getScreenBounds(Component component, boolean accountForInsets) {
        if (GraphicsEnvironment.isHeadless()) {
            return new Rectangle(0, 0, 0, 0);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = component == null ? ge.getDefaultScreenDevice().getDefaultConfiguration() : component.getGraphicsConfiguration();
        Insets insets = accountForInsets ? Toolkit.getDefaultToolkit().getScreenInsets(gc) : null;
        return GUI.shrinkByInsets(gc.getBounds(), insets);
    }

    public static Rectangle getScreenBounds(Point point) {
        return GUI.getScreenBounds(point, false);
    }

    public static Rectangle getScreenBounds(Component component) {
        return GUI.getScreenBounds(component, false);
    }

    public static Rectangle getScreenBounds() {
        return GUI.getScreenBounds((Component)null);
    }

    public static Rectangle getMaxWindowBounds(Point point) {
        return GUI.getScreenBounds(point, true);
    }

    public static Rectangle getMaxWindowBounds(Component component) {
        return GUI.getScreenBounds(component, true);
    }

    public static Rectangle getMaxWindowBounds() {
        return GUI.getMaxWindowBounds((Component)null);
    }

    private static Rectangle shrinkByInsets(Rectangle bounds, Insets insets) {
        Rectangle shrunk = new Rectangle(bounds);
        if (insets == null) {
            return shrunk;
        }
        shrunk.x += insets.left;
        shrunk.y += insets.top;
        shrunk.width -= insets.left + insets.right;
        shrunk.height -= insets.top + insets.bottom;
        return shrunk;
    }

    public static Rectangle getZeroBasedMaxBounds() {
        for (GraphicsConfiguration config : GUI.getScreenConfigs()) {
            Rectangle bounds = config.getBounds();
            if (bounds == null || bounds.x != 0 || bounds.y != 0) continue;
            return bounds;
        }
        return null;
    }

    public static Rectangle getUnionOfBounds() {
        Rectangle unionOfBounds = new Rectangle();
        for (GraphicsConfiguration config : GUI.getScreenConfigs()) {
            unionOfBounds = unionOfBounds.union(config.getBounds());
        }
        return unionOfBounds;
    }

    public static Image createBlankImage(int width, int height) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("");
        }
        if (frame == null) {
            frame = new Frame();
            frame.pack();
            frame.setBackground(Color.white);
        }
        Image img = frame.createImage(width, height);
        return img;
    }

    public static void fix(Scrollbar sb) {
    }

    public static boolean showCompositeAdvisory(ImagePlus imp, String title) {
        if (imp == null || imp.getCompositeMode() != 1 || imp.getNChannels() == 1 || IJ.macroRunning()) {
            return true;
        }
        String msg = "Channel " + imp.getC() + " of this color composite image will be processed.";
        GenericDialog gd = new GenericDialog(title);
        gd.addMessage(msg);
        gd.showDialog();
        return !gd.wasCanceled();
    }

    public static void scale(Component component) {
        float scale = (float)Prefs.getGuiScale();
        if (scale == 1.0f) {
            return;
        }
        if (component instanceof Container) {
            GUI.scaleComponents((Container)component, scale);
        } else {
            GUI.scaleComponent(component, scale);
        }
    }

    private static void scaleComponents(Container container, float scale) {
        for (Component child : container.getComponents()) {
            if (child instanceof Container) {
                GUI.scaleComponents((Container)child, scale);
                continue;
            }
            GUI.scaleComponent(child, scale);
        }
    }

    private static void scaleComponent(Component component, float scale) {
        Font font = component.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        font = font.deriveFont(scale * (float)font.getSize());
        component.setFont(font);
    }

    public static void scalePopupMenu(PopupMenu popup) {
        float scale = (float)Prefs.getGuiScale();
        if (scale == 1.0f) {
            return;
        }
        Font font = popup.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        font = font.deriveFont(scale * (float)font.getSize());
        popup.setFont(font);
    }

    public static boolean scale(JComponent component) {
        double guiScale = Prefs.getGuiScale();
        if (guiScale == 1.0) {
            return false;
        }
        Font font = component.getFont();
        if (font == null && component instanceof JList) {
            font = UIManager.getFont("List.font");
        } else if (font == null && component instanceof JTable) {
            font = UIManager.getFont("Table.font");
        } else if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        if (font.getSize() > DEFAULT_FONT.getSize()) {
            return false;
        }
        if (component instanceof JTable) {
            ((JTable)component).setRowHeight((int)((double)((JTable)component).getRowHeight() * guiScale * 0.9));
        } else if (component instanceof JList) {
            ((JList)component).setFixedCellHeight((int)((double)((JList)component).getFixedCellHeight() * guiScale * 0.9));
        }
        component.setFont(font.deriveFont((float)guiScale * (float)font.getSize()));
        return true;
    }

    public static final void fixScrollbar(Scrollbar sb) {
        if (IJ.isWindows()) {
            sb.setBackground(scrollbarBackground);
        }
    }

    static {
        scrollbarBackground = new Color(245, 245, 245);
        if (IJ.isWindows()) {
            String osname = System.getProperty("os.name");
            isWindows8 = osname.contains("unknown") || osname.contains("8");
        }
    }
}

