/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.TextRoi;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;

public class HyperStackMaker
implements PlugIn {
    private static String defaults = "8-bit Color 400 300 3 4 5 1";
    private static String[] types = new String[]{"8-bit", "16-bit", "32-bit", "RGB"};
    private static String[] modes = new String[]{"Composite", "Color", "Grayscale"};
    private static String title = "HyperStack";
    private String type;
    private String mode;
    private int width;
    private int height;
    private int c;
    private int z;
    private int t;
    private boolean label;

    @Override
    public void run(String arg) {
        String[] prefs;
        String defaults2 = Prefs.get("hyperstack.new", defaults);
        if (Macro.getOptions() != null) {
            defaults2 = defaults;
        }
        if ((prefs = Tools.split(defaults2)).length < 8) {
            prefs = Tools.split(defaults);
        }
        this.type = prefs[0];
        this.mode = prefs[1];
        this.width = (int)Tools.parseDouble(prefs[2], 400.0);
        this.height = (int)Tools.parseDouble(prefs[3], 300.0);
        this.c = (int)Tools.parseDouble(prefs[4], 3.0);
        this.z = (int)Tools.parseDouble(prefs[5], 4.0);
        this.t = (int)Tools.parseDouble(prefs[6], 5.0);
        int labelInt = (int)Tools.parseDouble(prefs[7], 1.0);
        boolean bl = this.label = labelInt == 1;
        if (!this.showDialog()) {
            return;
        }
        String type2 = this.type;
        if (this.label) {
            type2 = type2 + " ramp label";
        }
        if (this.mode.equals("Composite")) {
            type2 = type2 + " composite";
        } else if (this.mode.equals("Color")) {
            type2 = type2 + " color";
        } else if (this.mode.equals("Grayscale")) {
            type2 = type2 + " grayscale";
        }
        ImagePlus imp = IJ.createImage(title, type2, this.width, this.height, this.c, this.z, this.t);
        WindowManager.checkForDuplicateName = true;
        imp.show();
        if (Macro.getOptions() == null) {
            defaults2 = this.type + " " + this.mode + " " + this.width + " " + this.height + " " + this.c + " " + this.z + " " + this.t + " " + (this.label ? "1" : "0");
            Prefs.set("hyperstack.new", defaults2);
        }
    }

    private boolean showDialog() {
        String options;
        String string = options = IJ.isMacro() ? Macro.getOptions() : null;
        if (options != null && options.contains("title=")) {
            Macro.setOptions(options.replace("title=", "name="));
        }
        GenericDialog gd = new GenericDialog("New Hyperstack...");
        gd.addStringField("Name:", title, 12);
        gd.addChoice("Type:", types, this.type);
        gd.addChoice("Display mode:", modes, this.mode);
        gd.addNumericField("Width:", this.width, 0, 5, "pixels");
        gd.addNumericField("Height:", this.height, 0, 5, "pixels");
        gd.addNumericField("Channels (c):", this.c, 0, 5, "");
        gd.addNumericField("Slices (z):", this.z, 0, 5, "");
        gd.addNumericField("Frames (t):", this.t, 0, 5, "");
        gd.addCheckbox("Label images", this.label);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        title = gd.getNextString();
        this.type = gd.getNextChoice();
        this.mode = gd.getNextChoice();
        this.width = (int)gd.getNextNumber();
        this.height = (int)gd.getNextNumber();
        this.c = (int)gd.getNextNumber();
        if (this.c < 1) {
            this.c = 1;
        }
        this.z = (int)gd.getNextNumber();
        if (this.z < 1) {
            this.z = 1;
        }
        this.t = (int)gd.getNextNumber();
        if (this.t < 1) {
            this.t = 1;
        }
        this.label = gd.getNextBoolean();
        if (this.width < 1 || this.height < 1) {
            IJ.error("New Image", "Width and height must be >0");
            return false;
        }
        return true;
    }

    public static void labelHyperstack(ImagePlus imp) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        int c = imp.getNChannels();
        int z = imp.getNSlices();
        int t = imp.getNFrames();
        ImageStack stack = imp.getStack();
        Overlay overlay = new Overlay();
        int n = stack.size();
        int channel = 1;
        int slice = 1;
        int frame = 1;
        boolean hyperstack = imp.isHyperStack();
        for (int i = 1; i <= n; ++i) {
            int yloc = 30;
            IJ.showProgress(i, n);
            ImageProcessor ip = stack.getProcessor(i);
            ip.setAntialiasedText(true);
            ip.setColor(Color.black);
            ip.setRoi(0, 0, width, yloc);
            ip.fill();
            ip.setRoi(0, yloc + 25, width, height - (yloc + 25));
            ip.fill();
            ip.setColor(Color.white);
            Font font = new Font("SansSerif", 0, 24);
            ip.setFont(font);
            String text = "c=" + IJ.pad(channel, 3) + ", z=" + IJ.pad(slice, 3) + ", t=" + IJ.pad(frame, 3) + ", i=" + IJ.pad(i, 4);
            if (!hyperstack) {
                text = IJ.pad(i, 4);
            }
            TextRoi roi = new TextRoi(5, yloc - 28, text, font);
            roi.setStrokeColor(Color.white);
            if (hyperstack || c > 1) {
                roi.setPosition(channel, slice, frame);
            } else {
                roi.setPosition(i);
            }
            overlay.add(roi);
            ip.drawString(text, 5, yloc + 27);
            int size = 20;
            ip.setValue(channel);
            ip.setRoi(size, yloc += 30, size, size);
            ip.fill();
            ip.setColor(Color.white);
            ip.drawRect(size, yloc, size, size);
            ip.setValue(slice);
            ip.setRoi(size * 3, yloc, size, size);
            ip.fill();
            ip.setColor(Color.white);
            ip.drawRect(size * 3, yloc, size, size);
            ip.setValue(frame);
            ip.setRoi(size * 5, yloc, size, size);
            ip.fill();
            ip.setColor(Color.white);
            ip.drawRect(size * 5, yloc, size, size);
            ip.setValue(i);
            ip.setRoi(size * 7, yloc, size, size);
            ip.fill();
            ip.setColor(Color.white);
            ip.drawRect(size * 7, yloc, size, size);
            yloc = 90;
            if (i == 1 && hyperstack) {
                String msg = "Press shift-z (Image>Color>Channels Tool)\nto open the \"Channels\" window, which will\nallow you switch to composite color mode\nand to enable/disable channels.\n";
                font = new Font("SansSerif", 0, imp.getWidth() > 399 ? 14 : 12);
                roi = new TextRoi(25, yloc, msg, font);
                roi.setStrokeColor(Color.white);
                roi.setPosition(0, 1, 1);
                overlay.add(roi);
            }
            if (++channel <= c) continue;
            channel = 1;
            if (++slice <= z) continue;
            slice = 1;
            if (++frame <= t) continue;
            frame = 1;
        }
        imp.setOverlay(overlay);
    }
}

