/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Overlay;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;

public class Benchmark
implements PlugIn {
    private String[] results = new String[]{"10.9|MacBook Air (M1, 2020, Native)", "17.2|iMac Pro (2017)", "18.1|MacBook Air (M1, 2020, Rosetta)", "22.8|Dell T7920 (Dual Xeon, 282GB RAM, 2018)", "24.7|27\" iMac (Early 2015)", "29.7|13\" MacBook Pro (Late 2015)", "29.7|15\" MacBook Pro (Early 2013)", "62.3|Acer Aspire laptop (Core i5, 2014)"};
    private int size = 5000;
    private int ops = 62;
    private int counter;

    @Override
    public void run(String arg) {
        int i;
        int i2;
        ImagePlus cImp = WindowManager.getCurrentImage();
        if (cImp != null && cImp.getWidth() == 512 && cImp.getHeight() == 512 && cImp.getBitDepth() == 24) {
            IJ.runPlugIn(cImp, "ij.plugin.filter.Benchmark", "");
            return;
        }
        IJ.showStatus("Creating " + this.size + "x" + this.size + " 16-bit image");
        long t0 = System.currentTimeMillis();
        ImageProcessor.setRandomSeed(12345.0);
        ImagePlus imp = IJ.createImage("Untitled", "16-bit noise", this.size, this.size, 1);
        ImageProcessor.setRandomSeed(Double.NaN);
        imp.copy();
        for (i2 = 0; i2 < 3; ++i2) {
            this.analyzeParticles(imp);
        }
        for (i2 = 0; i2 < 3; ++i2) {
            IJ.run(imp, "Median...", "radius=2");
            this.showProgress("Median");
        }
        for (i2 = 0; i2 < 12; ++i2) {
            IJ.run(imp, "Unsharp Mask...", "radius=1 mask=0.60");
            this.showProgress("Unsharp Mask");
        }
        ImageProcessor ip = imp.getProcessor();
        ip.snapshot();
        for (i = 0; i < 12; ++i) {
            ip.blurGaussian(40.0);
            this.showProgress("Gaussian blur");
        }
        ip.reset();
        for (i = 0; i < 360; i += 20) {
            ip.reset();
            ip.rotate(i);
            this.showProgress("Rotate");
        }
        double scale = 1.2;
        for (int i3 = 0; i3 < 14; ++i3) {
            ip.reset();
            ip.scale(scale, scale);
            this.showProgress("Scale");
            scale *= 1.2;
        }
        double time = (double)(System.currentTimeMillis() - t0) / 1000.0;
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(true);
        for (int i4 = 0; i4 < this.results.length; ++i4) {
            String[] columns = Tools.split(this.results[i4], "|");
            rt.addRow();
            rt.addValue("Time", columns[0]);
            rt.addValue("Computer", columns[1]);
        }
        rt.addRow();
        String t = IJ.d2s(time, 1);
        if (t.length() < 4) {
            t = " " + t;
        }
        rt.addValue("Time", t);
        rt.addValue("Computer", "<<THIS MACHINE (" + Prefs.getThreads() + " THREADS)>>");
        rt.sort("Time");
        rt.show("Benchmark Results");
        IJ.showStatus("!" + IJ.d2s(time, 1) + " seconds to perform " + this.counter + " operations on a " + this.size + "x" + this.size + " 16-bit image");
    }

    void analyzeParticles(ImagePlus imp) {
        this.showProgress("Particle analyzer");
        imp.paste();
        IJ.setAutoThreshold(imp, "Default");
        IJ.run(imp, "Gaussian Blur...", "sigma=10");
        IJ.setAutoThreshold(imp, "Default");
        IJ.run(imp, "Analyze Particles...", "clear overlay composite");
        Overlay overlay = imp.getOverlay();
        int n = overlay.size();
        double sumArea = 0.0;
        double sumMean = 0.0;
        for (int i = 0; i < n; ++i) {
            imp.setRoi(overlay.get(i));
            ImageStatistics stats = imp.getStatistics();
            sumArea += stats.area;
            sumMean += stats.mean;
        }
        imp.resetRoi();
        if (this.counter == 1 && (n != 1886 || sumArea / (double)n != 5843.324496288441 || sumMean / (double)n != 32637.72733693335)) {
            IJ.log(n + " " + sumArea / (double)n + " " + sumMean / (double)n);
            this.error("Particle analyzer");
        }
    }

    void showProgress(String msg) {
        ++this.counter;
        msg = msg.length() > 1 ? " (" + msg + ")" : "";
        IJ.showStatus("!" + this.counter + "/" + this.ops + msg);
        IJ.showProgress(-this.counter, this.ops);
    }

    void error(String msg) {
        IJ.log("Benchmark: " + msg + " regression");
    }
}

