/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import java.awt.Choice;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;

public class Colors
implements PlugIn,
ItemListener {
    public static final String[] colors = new String[]{"red", "green", "blue", "magenta", "cyan", "yellow", "orange", "black", "white", "gray", "lightgray", "darkgray", "pink"};
    private static final String[] colors2 = new String[]{"Red", "Green", "Blue", "Magenta", "Cyan", "Yellow", "Orange", "Black", "White", "Gray", "lightGray", "darkGray", "Pink"};
    private Choice fchoice;
    private Choice bchoice;
    private Choice schoice;
    private Color fc2;
    private Color bc2;
    private Color sc2;

    @Override
    public void run(String arg) {
        this.showDialog();
    }

    void showDialog() {
        Color fc = Toolbar.getForegroundColor();
        String fname = Colors.getColorName(fc, "black");
        Color bc = Toolbar.getBackgroundColor();
        String bname = Colors.getColorName(bc, "white");
        Color sc = Roi.getColor();
        String sname = Colors.getColorName(sc, "yellow");
        GenericDialog gd = new GenericDialog("Colors");
        gd.addChoice("Foreground:", colors, fname);
        gd.addChoice("Background:", colors, bname);
        gd.addChoice("Selection:", colors, sname);
        Vector choices = gd.getChoices();
        if (choices != null) {
            this.fchoice = (Choice)choices.elementAt(0);
            this.bchoice = (Choice)choices.elementAt(1);
            this.schoice = (Choice)choices.elementAt(2);
            this.fchoice.addItemListener(this);
            this.bchoice.addItemListener(this);
            this.schoice.addItemListener(this);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (this.fc2 != fc) {
                Toolbar.setForegroundColor(fc);
            }
            if (this.bc2 != bc) {
                Toolbar.setBackgroundColor(bc);
            }
            if (this.sc2 != sc) {
                Roi.setColor(sc);
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null && imp.getRoi() != null) {
                    imp.draw();
                }
            }
            return;
        }
        fname = gd.getNextChoice();
        bname = gd.getNextChoice();
        sname = gd.getNextChoice();
        this.fc2 = Colors.getColor(fname, Color.black);
        this.bc2 = Colors.getColor(bname, Color.white);
        this.sc2 = Colors.getColor(sname, Color.yellow);
        if (this.fc2 != fc) {
            Toolbar.setForegroundColor(this.fc2);
        }
        if (this.bc2 != bc) {
            Toolbar.setBackgroundColor(this.bc2);
        }
        if (this.sc2 != sc) {
            Toolbar tb;
            Roi.setColor(this.sc2);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.draw();
            }
            if ((tb = Toolbar.getInstance()) != null) {
                tb.repaint();
            }
        }
    }

    public static String getColorName(Color c, String defaultName) {
        if (c == null) {
            return defaultName;
        }
        String name = defaultName;
        if (name != null && name.length() > 0 && Character.isUpperCase(name.charAt(0))) {
            if (c.equals(Color.red)) {
                name = colors2[0];
            } else if (c.equals(Color.green)) {
                name = colors2[1];
            } else if (c.equals(Color.blue)) {
                name = colors2[2];
            } else if (c.equals(Color.magenta)) {
                name = colors2[3];
            } else if (c.equals(Color.cyan)) {
                name = colors2[4];
            } else if (c.equals(Color.yellow)) {
                name = colors2[5];
            } else if (c.equals(Color.orange)) {
                name = colors2[6];
            } else if (c.equals(Color.black)) {
                name = colors2[7];
            } else if (c.equals(Color.white)) {
                name = colors2[8];
            } else if (c.equals(Color.gray)) {
                name = colors2[9];
            } else if (c.equals(Color.lightGray)) {
                name = colors2[10];
            } else if (c.equals(Color.darkGray)) {
                name = colors2[11];
            } else if (c.equals(Color.pink)) {
                name = colors2[12];
            }
        } else if (c.equals(Color.red)) {
            name = colors[0];
        } else if (c.equals(Color.green)) {
            name = colors[1];
        } else if (c.equals(Color.blue)) {
            name = colors[2];
        } else if (c.equals(Color.magenta)) {
            name = colors[3];
        } else if (c.equals(Color.cyan)) {
            name = colors[4];
        } else if (c.equals(Color.yellow)) {
            name = colors[5];
        } else if (c.equals(Color.orange)) {
            name = colors[6];
        } else if (c.equals(Color.black)) {
            name = colors[7];
        } else if (c.equals(Color.white)) {
            name = colors[8];
        } else if (c.equals(Color.gray)) {
            name = colors[9];
        } else if (c.equals(Color.lightGray)) {
            name = colors[10];
        } else if (c.equals(Color.darkGray)) {
            name = colors[11];
        } else if (c.equals(Color.pink)) {
            name = colors[12];
        }
        return name;
    }

    public static Color getColor(String name, Color defaultColor) {
        if (name == null) {
            return defaultColor;
        }
        name = name.toLowerCase(Locale.US);
        Color c = defaultColor;
        if (name.contains(colors[7])) {
            c = Color.black;
        } else if (name.contains(colors[8])) {
            c = Color.white;
        } else if (name.contains(colors[0])) {
            c = Color.red;
        } else if (name.contains(colors[2])) {
            c = Color.blue;
        } else if (name.contains(colors[5])) {
            c = Color.yellow;
        } else if (name.contains(colors[1])) {
            c = Color.green;
        } else if (name.contains(colors[3])) {
            c = Color.magenta;
        } else if (name.contains(colors[4])) {
            c = Color.cyan;
        } else if (name.contains(colors[6])) {
            c = Color.orange;
        } else if (name.contains(colors[9])) {
            c = Color.gray;
        } else if (name.contains(colors[10])) {
            c = Color.lightGray;
        } else if (name.contains(colors[11])) {
            c = Color.darkGray;
        } else if (name.contains(colors[12])) {
            c = Color.pink;
        }
        return c;
    }

    public static Color decode(String hexColor) {
        return Colors.decode(hexColor, Color.gray);
    }

    public static Color decode(String hexColor, Color defaultColor) {
        Color color = Colors.getColor(hexColor, null);
        if (color == null) {
            float alpha;
            int len;
            if (hexColor.startsWith("#")) {
                hexColor = hexColor.substring(1);
            }
            if ((len = hexColor.length()) != 6 && len != 8) {
                return defaultColor;
            }
            float f = alpha = len == 8 ? Colors.parseHex(hexColor.substring(0, 2)) : 1.0f;
            if (len == 8) {
                hexColor = hexColor.substring(2);
            }
            float red = Colors.parseHex(hexColor.substring(0, 2));
            float green = Colors.parseHex(hexColor.substring(2, 4));
            float blue = Colors.parseHex(hexColor.substring(4, 6));
            color = new Color(red, green, blue, alpha);
        }
        return color;
    }

    public static int getRed(String hexColor) {
        return Colors.decode(hexColor, Color.black).getRed();
    }

    public static int getGreen(String hexColor) {
        return Colors.decode(hexColor, Color.black).getGreen();
    }

    public static int getBlue(String hexColor) {
        return Colors.decode(hexColor, Color.black).getBlue();
    }

    public static String hexToColor(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        String color = null;
        if (hex.equals("ff0000")) {
            color = "red";
        } else if (hex.equals("00ff00")) {
            color = "green";
        } else if (hex.equals("0000ff")) {
            color = "blue";
        } else if (hex.equals("000000")) {
            color = "black";
        } else if (hex.equals("ffffff")) {
            color = "white";
        } else if (hex.equals("ffff00")) {
            color = "yellow";
        } else if (hex.equals("00ffff")) {
            color = "cyan";
        } else if (hex.equals("ff00ff")) {
            color = "magenta";
        } else if (hex.equals("ffc800")) {
            color = "orange";
        } else if (hex.equals("808080")) {
            color = "gray";
        }
        return color;
    }

    public static String hexToColor2(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        String color = null;
        if (hex.equals("ff0000")) {
            color = "Red";
        } else if (hex.equals("00ff00")) {
            color = "Green";
        } else if (hex.equals("0000ff")) {
            color = "Blue";
        } else if (hex.equals("000000")) {
            color = "Black";
        } else if (hex.equals("ffffff")) {
            color = "White";
        } else if (hex.equals("ffff00")) {
            color = "Yellow";
        } else if (hex.equals("00ffff")) {
            color = "Cyan";
        } else if (hex.equals("ff00ff")) {
            color = "Magenta";
        } else if (hex.equals("ffc800")) {
            color = "Orange";
        } else if (hex.equals("808080")) {
            color = "Gray";
        }
        return color;
    }

    public static String colorToString(Color color) {
        String str2;
        String str;
        String string = str = color != null ? "#" + Integer.toHexString(color.getRGB()) : "none";
        if (str.length() == 9 && str.startsWith("#ff")) {
            str = "#" + str.substring(3);
        }
        return (str2 = Colors.hexToColor(str)) != null ? str2 : str;
    }

    public static String colorToString2(Color color) {
        String str2;
        String str;
        String string = str = color != null ? "#" + Integer.toHexString(color.getRGB()) : "None";
        if (str.length() == 9 && str.startsWith("#ff")) {
            str = "#" + str.substring(3);
        }
        return (str2 = Colors.hexToColor2(str)) != null ? str2 : str;
    }

    public static Color toColor(int red, int green, int blue) {
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return new Color(red, green, blue);
    }

    private static float parseHex(String hex) {
        float value = 0.0f;
        try {
            value = Integer.parseInt(hex, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value / 255.0f;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Choice choice = (Choice)e.getSource();
        String item = choice.getSelectedItem();
        Color color = Colors.getColor(item, Color.black);
        if (choice == this.fchoice) {
            Toolbar.setForegroundColor(color);
        } else if (choice == this.bchoice) {
            Toolbar.setBackgroundColor(color);
        } else if (choice == this.schoice) {
            Roi.setColor(color);
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null && imp.getRoi() != null) {
                imp.draw();
            }
            Toolbar.getInstance().repaint();
        }
    }

    public static String[] getColors(String ... moreColors) {
        ArrayList<String> names = new ArrayList<String>();
        for (String arg : moreColors) {
            if (arg == null || arg.length() <= 0 || Character.isLetter(arg.charAt(0)) && !arg.equals("None")) continue;
            names.add(arg);
        }
        for (String arg : colors2) {
            names.add(arg);
        }
        return names.toArray(new String[names.size()]);
    }
}

