/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import java.awt.Choice;
import java.awt.Font;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class Startup
implements PlugIn,
ItemListener {
    private static String NAME = "RunAtStartup.ijm";
    private GenericDialog gd;
    private static final String[] code = new String[]{"[Select from list]", "Black background", "Set default directory", "Debug mode", "10-bit (0-1023) range", "12-bit (0-4095) range", "Splash Screen", "Bolder selections", "Add to overlay"};
    private String macro = "";
    private int originalLength;

    @Override
    public void run(String arg) {
        String macro2 = this.macro = this.getStartupMacro();
        if (!this.showDialog()) {
            return;
        }
        if (!this.macro.equals(macro2)) {
            if (!this.runMacro(this.macro)) {
                return;
            }
            this.saveStartupMacro(this.macro);
        }
    }

    public String getStartupMacro() {
        String macro = IJ.openAsString(IJ.getDirectory("macros") + NAME);
        if (macro == null || macro.startsWith("Error:")) {
            return null;
        }
        return macro;
    }

    private void saveStartupMacro(String macro) {
        IJ.saveString(macro, IJ.getDirectory("macros") + NAME);
    }

    private boolean showDialog() {
        this.gd = new GenericDialog("Startup Macro");
        String text = "Macro code contained in this text area\nexecutes when ImageJ starts up.";
        Font font = new Font("SansSerif", 0, 14);
        this.gd.setInsets(5, 15, 0);
        this.gd.addMessage(text, font);
        this.gd.setInsets(5, 10, 0);
        this.gd.addTextAreas(this.macro, null, 15, 50);
        this.gd.addChoice("Add code:", code, code[0]);
        Vector choices = this.gd.getChoices();
        if (choices != null) {
            Choice choice = (Choice)choices.elementAt(0);
            choice.addItemListener(this);
        }
        this.gd.showDialog();
        this.macro = this.gd.getNextText();
        return !this.gd.wasCanceled();
    }

    private boolean runMacro(String macro) {
        Interpreter interp = new Interpreter();
        interp.run(macro, null);
        return !interp.wasError();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Choice choice = (Choice)e.getSource();
        String item = choice.getSelectedItem();
        String statement = null;
        if (item.equals(code[1])) {
            statement = "setOption(\"BlackBackground\", true);\n";
        } else if (item.equals(code[2])) {
            statement = "File.setDefaultDir(getDir(\"downloads\"));\n";
        } else if (item.equals(code[3])) {
            statement = "setOption(\"DebugMode\", true);\n";
        } else if (item.equals(code[4])) {
            statement = "call(\"ij.ImagePlus.setDefault16bitRange\", 10);\n";
        } else if (item.equals(code[5])) {
            statement = "call(\"ij.ImagePlus.setDefault16bitRange\", 12);\n";
        } else if (item.equals(code[6])) {
            statement = "run(\"About ImageJ...\");\nwait(3000);\nclose(\"About ImageJ\");\n";
        } else if (item.equals(code[7])) {
            statement = "Roi.setDefaultStrokeWidth(2);\n";
        } else if (item.equals(code[8])) {
            statement = "setOption(\"Add to overlay\", true);\n";
        }
        if (statement != null) {
            TextArea ta = this.gd.getTextArea1();
            ta.insert(statement, ta.getCaretPosition());
            if (IJ.isMacOSX()) {
                ta.requestFocus();
            }
        }
    }
}

