/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;

public class ImageCalculator
implements PlugIn {
    private static String[] operators = new String[]{"Add", "Subtract", "Multiply", "Divide", "AND", "OR", "XOR", "Min", "Max", "Average", "Difference", "Copy", "Transparent-zero"};
    private static String[] lcOperators = new String[]{"add", "sub", "mul", "div", "and", "or", "xor", "min", "max", "ave", "diff", "copy", "zero"};
    private static int operator;
    private static String title1;
    private static String title2;
    private static boolean createWindow;
    private static boolean floatResult;
    private boolean processStack;
    private boolean macroCall;

    @Override
    public void run(String arg) {
        ImagePlus img2;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.noImage();
            return;
        }
        IJ.register(ImageCalculator.class);
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        GenericDialog gd = new GenericDialog("Image Calculator");
        String defaultItem = title1.equals("") ? titles[0] : title1;
        gd.addChoice("Image1:", titles, defaultItem);
        gd.addChoice("Operation:", operators, operators[operator]);
        defaultItem = title2.equals("") ? titles[0] : title2;
        gd.addChoice("Image2:", titles, defaultItem);
        gd.addCheckbox("Create new window", createWindow);
        gd.addCheckbox("32-bit (float) result", floatResult);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#calculator");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int index1 = gd.getNextChoiceIndex();
        title1 = titles[index1];
        operator = gd.getNextChoiceIndex();
        int index2 = gd.getNextChoiceIndex();
        createWindow = gd.getNextBoolean();
        floatResult = gd.getNextBoolean();
        title2 = titles[index2];
        ImagePlus img1 = WindowManager.getImage(wList[index1]);
        ImagePlus img3 = this.calculate(img1, img2 = WindowManager.getImage(wList[index2]), false);
        if (img3 != null) {
            img3.show();
        }
    }

    public static ImagePlus run(ImagePlus img1, ImagePlus img2, String operation) {
        ImageCalculator ic = new ImageCalculator();
        return ic.run(operation, img1, img2);
    }

    public ImagePlus run(String operation, ImagePlus img1, ImagePlus img2) {
        if (img1 == null || img2 == null || operation == null) {
            return null;
        }
        operator = this.getOperator(operation);
        if (operator == -1) {
            throw new IllegalArgumentException("No valid operator");
        }
        createWindow = operation.indexOf("create") != -1;
        floatResult = operation.indexOf("32") != -1 || operation.indexOf("float") != -1;
        this.processStack = operation.indexOf("stack") != -1;
        return this.calculate(img1, img2, true);
    }

    public void calculate(String operation, ImagePlus img1, ImagePlus img2) {
        if (img1 == null || img2 == null || operation == null) {
            return;
        }
        operator = this.getOperator(operation);
        if (operator == -1) {
            IJ.error("Image Calculator", "No valid operator");
            return;
        }
        createWindow = operation.indexOf("create") != -1;
        floatResult = operation.indexOf("32") != -1 || operation.indexOf("float") != -1;
        this.processStack = operation.indexOf("stack") != -1;
        this.macroCall = true;
        ImagePlus img3 = this.calculate(img1, img2, true);
        if (img3 != null) {
            img3.show();
        }
    }

    int getOperator(String options) {
        options = options.toLowerCase();
        int op = -1;
        if (options.indexOf("xor") != -1) {
            op = 6;
        }
        if (op == -1) {
            for (int i = 0; i < lcOperators.length; ++i) {
                if (options.indexOf(lcOperators[i]) == -1) continue;
                op = i;
                break;
            }
        }
        return op;
    }

    ImagePlus calculate(ImagePlus img1, ImagePlus img2, boolean apiCall) {
        ImagePlus img3 = null;
        if (img1.getCalibration().isSigned16Bit() || img2.getCalibration().isSigned16Bit()) {
            floatResult = true;
        }
        if (floatResult && (img1.getBitDepth() != 32 || img2.getBitDepth() != 32)) {
            createWindow = true;
        }
        int size1 = img1.getStackSize();
        int size2 = img2.getStackSize();
        if (apiCall) {
            img3 = this.processStack && (size1 > 1 || size2 > 1) ? this.doStackOperation(img1, img2) : this.doOperation(img1, img2);
            if (img3 == null && !this.macroCall && img1.getWindow() == null) {
                img3 = img1;
            }
            return img3;
        }
        boolean stackOp = false;
        if (size1 > 1) {
            int result = IJ.setupDialog(img1, 128);
            if (result == 4096) {
                return null;
            }
            boolean bl = this.processStack = (result & 0x20) != 0;
            if (this.processStack) {
                if (img1.getStack().isVirtual()) {
                    createWindow = true;
                }
                img3 = this.doStackOperation(img1, img2);
                stackOp = true;
            } else {
                img3 = this.doOperation(img1, img2);
            }
        } else {
            img3 = this.doOperation(img1, img2);
        }
        if (Recorder.record) {
            String options = operators[operator];
            if (createWindow) {
                options = options + " create";
            }
            if (floatResult) {
                options = options + " 32-bit";
            }
            if (stackOp) {
                options = options + " stack";
            }
            if (Recorder.scriptMode()) {
                Recorder.recordCall("ImagePlus", "imp1 = WindowManager.getImage(\"" + img1.getTitle() + "\");");
                Recorder.recordCall("ImagePlus", "imp2 = WindowManager.getImage(\"" + img2.getTitle() + "\");");
                Recorder.recordCall("ImagePlus", "imp3 = ImageCalculator.run(imp1, imp2, \"" + options + "\");");
                Recorder.recordCall("imp3.show();");
            } else {
                Recorder.record("imageCalculator", options, img1.getTitle(), img2.getTitle());
            }
            Recorder.setCommand(null);
        }
        return img3;
    }

    ImagePlus doStackOperation(ImagePlus img1, ImagePlus img2) {
        ImagePlus img3 = null;
        int size1 = img1.getStackSize();
        int size2 = img2.getStackSize();
        if (size1 > 1 && size2 > 1 && size1 != size2) {
            IJ.error("Image Calculator", "'Image1' and 'image2' must be stacks with the same\nnumber of slices, or 'image2' must be a single image.");
            return null;
        }
        if (createWindow) {
            if ((img1 = this.duplicateStack(img1)) == null) {
                IJ.error("Calculator", "Out of memory");
                return null;
            }
            img3 = img1;
        }
        int mode = this.getBlitterMode();
        ImageWindow win = img1.getWindow();
        if (win != null) {
            WindowManager.setCurrentWindow(win);
        } else if (Interpreter.isBatchMode() && !createWindow && WindowManager.getImage(img1.getID()) != null) {
            IJ.selectWindow(img1.getID());
        }
        Undo.reset();
        ImageStack stack1 = img1.getStack();
        StackProcessor sp = new StackProcessor(stack1, img1.getProcessor());
        try {
            if (size2 == 1) {
                sp.copyBits(img2.getProcessor(), 0, 0, mode);
            } else {
                sp.copyBits(img2.getStack(), 0, 0, mode);
            }
        }
        catch (IllegalArgumentException e) {
            IJ.error("\"" + img1.getTitle() + "\": " + e.getMessage());
            return null;
        }
        img1.setStack(null, stack1);
        if (img1.getType() != 0) {
            img1.getProcessor().resetMinAndMax();
        }
        if (img3 == null) {
            img1.updateAndDraw();
        }
        return img3;
    }

    ImagePlus doOperation(ImagePlus img1, ImagePlus img2) {
        ImagePlus img3 = null;
        int mode = this.getBlitterMode();
        ImageProcessor ip1 = img1.getProcessor();
        ImageProcessor ip2 = img2.getProcessor();
        Calibration cal1 = img1.getCalibration();
        Calibration cal2 = img2.getCalibration();
        if (createWindow) {
            ip1 = this.createNewImage(ip1, ip2);
        } else {
            ImageWindow win = img1.getWindow();
            if (win != null) {
                WindowManager.setCurrentWindow(win);
            } else if (Interpreter.isBatchMode() && !createWindow && WindowManager.getImage(img1.getID()) != null) {
                IJ.selectWindow(img1.getID());
            }
            ip1.snapshot();
            Undo.setup(1, img1);
        }
        boolean rgb = ip2 instanceof ColorProcessor;
        if (floatResult && !rgb) {
            ip2 = ip2.convertToFloat();
        }
        try {
            ip1.copyBits(ip2, 0, 0, mode);
        }
        catch (IllegalArgumentException e) {
            IJ.error("\"" + img1.getTitle() + "\": " + e.getMessage());
            return null;
        }
        if (floatResult && rgb) {
            ip1 = ip1.convertToFloat();
        }
        if (!(ip1 instanceof ByteProcessor)) {
            ip1.resetMinAndMax();
        }
        if (createWindow) {
            img3 = new ImagePlus("Result of " + img1.getTitle(), ip1);
            img3.setCalibration(cal1);
        } else {
            img1.updateAndDraw();
        }
        return img3;
    }

    ImageProcessor createNewImage(ImageProcessor ip1, ImageProcessor ip2) {
        int width = Math.min(ip1.getWidth(), ip2.getWidth());
        int height = Math.min(ip1.getHeight(), ip2.getHeight());
        ImageProcessor ip3 = ip1.createProcessor(width, height);
        if (floatResult && !(ip1 instanceof ColorProcessor)) {
            ip1 = ip1.convertToFloat();
            ip3 = ip3.convertToFloat();
        }
        ip3.insert(ip1, 0, 0);
        return ip3;
    }

    private int getBlitterMode() {
        int mode = 0;
        switch (operator) {
            case 0: {
                mode = 3;
                break;
            }
            case 1: {
                mode = 4;
                break;
            }
            case 2: {
                mode = 5;
                break;
            }
            case 3: {
                mode = 6;
                break;
            }
            case 4: {
                mode = 9;
                break;
            }
            case 5: {
                mode = 10;
                break;
            }
            case 6: {
                mode = 11;
                break;
            }
            case 7: {
                mode = 12;
                break;
            }
            case 8: {
                mode = 13;
                break;
            }
            case 9: {
                mode = 7;
                break;
            }
            case 10: {
                mode = 8;
                break;
            }
            case 11: {
                mode = 0;
                break;
            }
            case 12: {
                mode = 14;
            }
        }
        return mode;
    }

    ImagePlus duplicateStack(ImagePlus img1) {
        Calibration cal = img1.getCalibration();
        ImageStack stack1 = img1.getStack();
        int width = stack1.getWidth();
        int height = stack1.getHeight();
        int n = stack1.getSize();
        ImageStack stack2 = img1.createEmptyStack();
        try {
            for (int i = 1; i <= n; ++i) {
                ImageProcessor ip1 = stack1.getProcessor(i);
                ip1.resetRoi();
                ImageProcessor ip2 = ip1.crop();
                if (floatResult) {
                    ip2.setCalibrationTable(cal.getCTable());
                    ip2 = ip2.convertToFloat();
                }
                stack2.addSlice(stack1.getSliceLabel(i), ip2);
            }
        }
        catch (OutOfMemoryError e) {
            stack2.trim();
            stack2 = null;
            return null;
        }
        ImagePlus img3 = new ImagePlus("Result of " + img1.getTitle(), stack2);
        img3.setCalibration(cal);
        if (img3.getStackSize() == n) {
            int[] dim = img1.getDimensions();
            img3.setDimensions(dim[2], dim[3], dim[4]);
            if (img1.isComposite()) {
                img3 = new CompositeImage(img3, 0);
                ((CompositeImage)img3).copyLuts(img1);
            }
            if (img1.isHyperStack()) {
                img3.setOpenAsHyperStack(true);
            }
        }
        return img3;
    }

    static {
        title1 = "";
        title2 = "";
        createWindow = true;
    }
}

