/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class NonBlockingGenericDialog
extends GenericDialog {
    ImagePlus imp;
    WindowListener windowListener;

    public NonBlockingGenericDialog(String title) {
        super(title, null);
        this.setModal(false);
        IJ.protectStatusBar(false);
        instance = this;
    }

    @Override
    public synchronized void showDialog() {
        ImageWindow win;
        super.showDialog();
        if (this.isMacro()) {
            return;
        }
        if (!IJ.macroRunning()) {
            final NonBlockingGenericDialog thisDialog = this;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManager.addWindow(thisDialog);
                }
            });
        }
        if (this.imp != null && (win = this.imp.getWindow()) != null) {
            NonBlockingGenericDialog gd = this;
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    NonBlockingGenericDialog.this.cancelDialogAndClose();
                }
            };
            win.addWindowListener(this.windowListener);
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void cancelDialogAndClose() {
        super.windowClosing(null);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!this.isVisible()) {
            this.notify();
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (this.wasOKed() || this.wasCanceled()) {
            this.notify();
        }
    }

    @Override
    public synchronized void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        if (this.wasOKed() || this.wasCanceled()) {
            this.notify();
        }
    }

    @Override
    public void dispose() {
        ImageWindow win;
        super.dispose();
        WindowManager.removeWindow(this);
        if (this.imp != null && (win = this.imp.getWindow()) != null && this.windowListener != null) {
            win.removeWindowListener(this.windowListener);
        }
    }

    public static GenericDialog newDialog(String title, ImagePlus imp) {
        return GUI.newNonBlockingDialog(title, imp);
    }

    public static GenericDialog newDialog(String title) {
        return GUI.newNonBlockingDialog(title);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (e.getWindow() instanceof ImageWindow && e.getOppositeWindow() != this) {
            this.toFront();
        }
        WindowManager.setWindow(this);
    }
}

