/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PlotCanvas;
import ij.gui.PlotDialog;
import ij.gui.PlotMaker;
import ij.gui.PlotObject;
import ij.gui.PlotProperties;
import ij.gui.PlotVirtualStack;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.FontUtil;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;

public class Plot
implements Cloneable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP_LEFT = 144;
    public static final int TOP_RIGHT = 160;
    public static final int BOTTOM_LEFT = 176;
    public static final int BOTTOM_RIGHT = 192;
    public static final int AUTO_POSITION = 128;
    static final int LEGEND_POSITION_MASK = 240;
    public static final int LEGEND_BOTTOM_UP = 256;
    public static final int LEGEND_TRANSPARENT = 512;
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int LINE = 2;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int DOT = 6;
    public static final int CONNECTED_CIRCLES = 7;
    public static final int DIAMOND = 8;
    public static final int CUSTOM = 9;
    public static final int FILLED = 10;
    public static final int BAR = 11;
    public static final int SEPARATED_BAR = 12;
    static final String[] SHAPE_NAMES = new String[]{"Circle", "X", "Line", "Box", "Triangle", "+", "Dot", "Connected Circles", "Diamond", "Custom", "Filled", "Bar", "Separated Bars"};
    static final String[] SORTED_SHAPES = new String[]{SHAPE_NAMES[2], SHAPE_NAMES[7], SHAPE_NAMES[10], SHAPE_NAMES[11], SHAPE_NAMES[12], SHAPE_NAMES[0], SHAPE_NAMES[3], SHAPE_NAMES[4], SHAPE_NAMES[5], SHAPE_NAMES[8], SHAPE_NAMES[1], SHAPE_NAMES[6]};
    public static final int X_NUMBERS = 1;
    public static final int Y_NUMBERS = 2;
    public static final int X_TICKS = 4;
    public static final int Y_TICKS = 8;
    public static final int X_GRID = 16;
    public static final int Y_GRID = 32;
    public static final int X_FORCE2GRID = 64;
    public static final int Y_FORCE2GRID = 128;
    public static final int X_MINOR_TICKS = 256;
    public static final int Y_MINOR_TICKS = 512;
    public static final int X_LOG_NUMBERS = 1024;
    public static final int Y_LOG_NUMBERS = 2048;
    public static final int X_LOG_TICKS = 4096;
    public static final int Y_LOG_TICKS = 8192;
    public static final int DEFAULT_FLAGS = 12339;
    public static final int X_RANGE = 1;
    public static final int Y_RANGE = 2;
    static final int ALL_AXES_RANGE = 3;
    public static final int COPY_SIZE = 16;
    public static final int COPY_LABELS = 32;
    public static final int COPY_LEGEND = 64;
    public static final int COPY_AXIS_STYLE = 128;
    public static final int COPY_CONTENTS_STYLE = 256;
    public static final int COPY_EXTRA_OBJECTS = 512;
    public static final int LEFT_MARGIN = 65;
    public static final int RIGHT_MARGIN = 18;
    public static final int TOP_MARGIN = 15;
    public static final int BOTTOM_MARGIN = 40;
    public static final int MIN_FRAMEWIDTH = 160;
    public static final int MIN_FRAMEHEIGHT = 90;
    public static final String PROPERTY_KEY = "thePlot";
    static final float DEFAULT_FRAME_LINE_WIDTH = 1.0001f;
    private static final int MIN_X_GRIDSPACING = 45;
    private static final int MIN_Y_GRIDSPACING = 30;
    private final double MIN_LOG_RATIO = 3.0;
    private static final int LEGEND_PADDING = 4;
    private static final int LEGEND_LINELENGTH = 20;
    private static final int USUALLY_ENLARGE = 1;
    private static final int ALWAYS_ENLARGE = 2;
    private static final double RELATIVE_ARROWHEAD_SIZE = 0.2;
    private static final int MIN_ARROWHEAD_LENGTH = 3;
    private static final int MAX_ARROWHEAD_LENGTH = 20;
    private static final String MULTIPLY_SYMBOL = "\u00b7";
    PlotProperties pp = new PlotProperties();
    PlotProperties ppSnapshot;
    Vector<PlotObject> allPlotObjects = new Vector();
    Vector<PlotObject> allPlotObjectsSnapshot;
    private PlotVirtualStack stack;
    float scale = 1.0f;
    Rectangle frame = null;
    int leftMargin = 65;
    int rightMargin = 18;
    int topMargin = 15;
    int bottomMargin = 40;
    int frameWidth;
    int frameHeight;
    int preferredPlotWidth = PlotWindow.plotWidth;
    int preferredPlotHeight = PlotWindow.plotHeight;
    double xMin = Double.NaN;
    double xMax;
    double yMin;
    double yMax;
    double[] currentMinMax = new double[]{Double.NaN, 0.0, Double.NaN, 0.0};
    double[] defaultMinMax = new double[]{Double.NaN, 0.0, Double.NaN, 0.0};
    double[] savedMinMax = new double[]{Double.NaN, 0.0, Double.NaN, 0.0};
    int[] enlargeRange;
    boolean logXAxis;
    boolean logYAxis;
    int templateFlags = 496;
    private int dsize = PlotWindow.getDefaultFontSize();
    Font defaultFont;
    Font currentFont = this.defaultFont = FontUtil.getFont("Arial", 0, (float)this.dsize);
    private double xScale;
    private double yScale;
    private int xBasePxl;
    private int yBasePxl;
    private int maxIntervals = 12;
    private int tickLength = 7;
    private int minorTickLength = 3;
    private Color gridColor = new Color(0xC0C0C0);
    private ImageProcessor ip;
    private ImagePlus imp;
    private String title;
    private boolean invertedLut;
    private boolean plotDrawn;
    PlotMaker plotMaker;
    private Color currentColor;
    private Color currentColor2;
    float currentLineWidth;
    private int currentJustification = 0;
    private boolean ignoreForce2Grid;
    private static double SEPARATED_BAR_WIDTH = 0.5;
    double[] steps;
    private int objectToReplace = -1;
    private Point2D.Double textLoc;
    private int textIndex;
    static final int MIN_SCIENTIFIC_DIGITS = 4;
    static final double MIN_FLOAT_PRECISION = 1.0E-5;

    public Plot(String title, String xLabel, String yLabel) {
        this(title, xLabel, yLabel, (float[])null, (float[])null, Plot.getDefaultFlags());
    }

    public Plot(String title, String xLabel, String yLabel, float[] x, float[] y) {
        this(title, xLabel, yLabel, x, y, Plot.getDefaultFlags());
    }

    public Plot(String title, String xLabel, String yLabel, double[] x, double[] y) {
        this(title, xLabel, yLabel, x != null ? Tools.toFloat(x) : null, y != null ? Tools.toFloat(y) : null, Plot.getDefaultFlags());
    }

    public Plot(String title, String xLabel, String yLabel, int flags) {
        this(title, xLabel, yLabel, (float[])null, (float[])null, flags);
    }

    public Plot(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, int flags) {
        this.title = title;
        this.pp.axisFlags = flags;
        this.setXYLabels(xLabel, yLabel);
        if (yValues != null && yValues.length > 0) {
            this.addPoints(xValues, yValues, null, 2, null);
            this.allPlotObjects.get((int)0).flags = 4096;
        }
    }

    public Plot(String title, String xLabel, String yLabel, double[] x, double[] y, int flags) {
        this(title, xLabel, yLabel, x != null ? Tools.toFloat(x) : null, y != null ? Tools.toFloat(y) : null, flags);
    }

    public Plot(ImagePlus imp, InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(is);
        this.pp = (PlotProperties)in.readObject();
        this.allPlotObjects = (Vector)in.readObject();
        in.close();
        if (this.pp.xLabel.type == 8) {
            this.pp.xLabel.updateType();
            this.pp.yLabel.updateType();
            this.pp.frame.updateType();
            if (this.pp.legend != null) {
                this.pp.legend.updateType();
            }
            for (PlotObject plotObject : this.allPlotObjects) {
                plotObject.updateType();
            }
        }
        this.defaultMinMax = this.pp.rangeMinMax;
        this.currentFont = this.nonNullFont(this.pp.frame.getFont(), this.currentFont);
        this.getProcessor();
        String string = this.title = imp != null ? imp.getTitle() : "Untitled Plot";
        if (imp != null) {
            this.imp = imp;
            this.ip = imp.getProcessor();
            imp.setIgnoreGlobalCalibration(true);
            this.adjustCalibration(imp.getCalibration());
            imp.setProperty(PROPERTY_KEY, this);
        }
    }

    public Plot(String dummy, String title, String xLabel, String yLabel, float[] x, float[] y) {
        this(title, xLabel, yLabel, x, y, Plot.getDefaultFlags());
    }

    void toStream(OutputStream os) throws IOException {
        for (PlotObject plotObject : this.pp.getAllPlotObjects()) {
            if (plotObject == null) continue;
            plotObject.setFont(this.nonNullFont(plotObject.getFont(), this.currentFont));
        }
        this.pp.rangeMinMax = this.currentMinMax;
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.pp);
        out.writeObject(this.allPlotObjects);
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.toStream(bos);
            bos.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            IJ.handleException(e);
            return null;
        }
    }

    public String getTitle() {
        return this.imp == null ? this.title : this.imp.getTitle();
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.setLimitsNoUpdate(xMin, xMax, yMin, yMax);
        this.makeLimitsDefault();
        this.ignoreForce2Grid = true;
        if (this.plotDrawn) {
            this.setLimitsToDefaults(true);
        }
    }

    void setLimitsNoUpdate(double xMin, double xMax, double yMin, double yMax) {
        boolean containsNaN = Double.isNaN(xMin + xMax + yMin + yMax);
        if (containsNaN && this.getNumPlotObjects(3, false) == 0) {
            return;
        }
        double[] range = new double[]{xMin, xMax, yMin, yMax};
        if (containsNaN) {
            int i;
            double[] extrema = this.getMinAndMax(true, 3);
            boolean[] auto = new boolean[range.length];
            for (i = 0; i < range.length; ++i) {
                if (!Double.isNaN(range[i])) continue;
                auto[i] = true;
                range[i] = extrema[i];
            }
            for (int a = 0; a < range.length; a += 2) {
                boolean currentAxisReverse;
                if (auto[a] == auto[a + 1]) continue;
                boolean bl = currentAxisReverse = this.defaultMinMax[a + 1] < this.defaultMinMax[a];
                if (!(!currentAxisReverse && range[a + 1] <= range[a]) && (!currentAxisReverse || !(range[a] <= range[a + 1]))) continue;
                auto[a] = true;
                auto[a + 1] = true;
                range[a] = extrema[a];
                range[a + 1] = extrema[a + 1];
            }
            for (i = 0; i < range.length; ++i) {
                if (auto[i]) continue;
                this.enlargeRange[i] = 0;
            }
            this.enlargeRange(range);
        }
        System.arraycopy(range, 0, this.currentMinMax, 0, Math.min(range.length, this.currentMinMax.length));
        this.ignoreForce2Grid = true;
    }

    void makeLimitsDefault() {
        System.arraycopy(this.currentMinMax, 0, this.defaultMinMax, 0, Math.min(this.currentMinMax.length, this.defaultMinMax.length));
    }

    public double[] getLimits() {
        return (double[])this.currentMinMax.clone();
    }

    public void setLimits(double[] limits) {
        System.arraycopy(limits, 0, this.currentMinMax, 0, Math.min(limits.length, this.defaultMinMax.length));
    }

    public void setOptions(String options) {
        this.pp.frame.options = options.toLowerCase();
    }

    public void setSize(int width, int height) {
        if (this.ip != null && width == this.ip.getWidth() && height == this.ip.getHeight()) {
            return;
        }
        Dimension minSize = this.getMinimumSize();
        this.pp.width = Math.max(width, minSize.width);
        this.pp.height = Math.max(height, minSize.height);
        this.scale = 1.0f;
        this.ip = null;
        if (this.plotDrawn) {
            this.updateImage();
        }
    }

    public Dimension getSize() {
        if (this.ip == null) {
            this.getBlankProcessor();
        }
        return new Dimension(this.ip.getWidth(), this.ip.getHeight());
    }

    public void setFrameSize(int width, int height) {
        if (this.pp.width <= 0) {
            this.preferredPlotWidth = width;
            this.preferredPlotHeight = height;
            this.scale = 1.0f;
        } else {
            this.makeMarginValues();
            this.setSize(width += this.leftMargin + this.rightMargin, height += this.topMargin + this.bottomMargin);
        }
    }

    public void setWindowSize(int width, int height) {
        this.scale = 1.0f;
        this.makeMarginValues();
        int titleBarHeight = 22;
        int infoHeight = 11;
        double scale = Prefs.getGuiScale();
        if (scale > 1.0) {
            infoHeight = (int)((double)infoHeight * scale);
        }
        int buttonPanelHeight = 45;
        if (this.pp.width <= 0) {
            int extraWidth = this.leftMargin + this.rightMargin + 10;
            int extraHeight = this.topMargin + this.bottomMargin + titleBarHeight + infoHeight + buttonPanelHeight;
            if (extraWidth < width) {
                width -= extraWidth;
            }
            if (extraHeight < height) {
                height -= extraHeight;
            }
            this.preferredPlotWidth = width;
            this.preferredPlotHeight = height;
        } else {
            int extraWidth = 10;
            int extraHeight = titleBarHeight + infoHeight + buttonPanelHeight;
            if (extraWidth < width) {
                width -= extraWidth;
            }
            if (extraHeight < height) {
                height -= extraHeight;
            }
            this.setSize(width, height);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(160 + this.leftMargin + this.rightMargin, 90 + this.topMargin + this.bottomMargin);
    }

    public void useTemplate(Plot plot) {
        this.useTemplate(plot, this.templateFlags);
    }

    public void useTemplate(Plot plot, int templateFlags) {
        if (plot == null) {
            return;
        }
        this.defaultFont = plot.defaultFont;
        this.currentFont = plot.currentFont;
        this.currentLineWidth = plot.currentLineWidth;
        this.currentColor = plot.currentColor;
        if ((templateFlags & 0x80) != 0) {
            this.pp.axisFlags = plot.pp.axisFlags;
            this.pp.frame = plot.pp.frame.deepClone();
        }
        if ((templateFlags & 0x20) != 0) {
            this.pp.xLabel.label = plot.pp.xLabel.label;
            this.pp.yLabel.label = plot.pp.yLabel.label;
            this.pp.xLabel.setFont(plot.pp.xLabel.getFont());
            this.pp.yLabel.setFont(plot.pp.yLabel.getFont());
        }
        for (int i = 0; i < this.currentMinMax.length; ++i) {
            if ((templateFlags >> i / 2 & 1) == 0) continue;
            this.currentMinMax[i] = plot.currentMinMax[i];
            if (this.plotDrawn) continue;
            this.defaultMinMax[i] = plot.currentMinMax[i];
        }
        if ((templateFlags & 0x40) != 0 && plot.pp.legend != null) {
            this.pp.legend = plot.pp.legend.deepClone();
        }
        if ((templateFlags & 0x140) != 0) {
            int plotPObjectIndex = 0;
            int plotPObjectsSize = plot.allPlotObjects.size();
            for (PlotObject plotObject : this.allPlotObjects) {
                if (plotObject.type != 1 || plotObject.hasFlag(8192)) continue;
                while (plotPObjectIndex < plotPObjectsSize && (plot.allPlotObjects.get((int)plotPObjectIndex).type != 1 || plot.allPlotObjects.get(plotPObjectIndex).hasFlag(8192))) {
                    ++plotPObjectIndex;
                }
                if (plotPObjectIndex >= plotPObjectsSize) break;
                if ((templateFlags & 0x40) != 0) {
                    plotObject.label = plot.allPlotObjects.get((int)plotPObjectIndex).label;
                }
                if ((templateFlags & 0x100) != 0) {
                    this.setPlotObjectStyle(plotObject, this.getPlotObjectStyle(plot.allPlotObjects.get(plotPObjectIndex)));
                }
                ++plotPObjectIndex;
            }
        }
        if ((templateFlags & 0x10) != 0) {
            this.setSize(plot.pp.width, plot.pp.height);
        }
        if ((templateFlags & 0x200) != 0) {
            for (int p = this.allPlotObjects.size(); p < plot.allPlotObjects.size(); ++p) {
                this.allPlotObjects.add(plot.allPlotObjects.get(p));
            }
        }
        this.templateFlags = templateFlags;
    }

    public void setScale(float scale) {
        this.scale = scale;
        if (scale > 20.0f) {
            scale = 20.0f;
        }
        if (scale < 0.7f) {
            scale = 0.7f;
        }
        this.pp.width = this.sc(this.pp.width);
        this.pp.height = this.sc(this.pp.height);
        this.plotDrawn = false;
    }

    public void setXYLabels(String xLabel, String yLabel) {
        this.pp.xLabel.label = xLabel != null ? xLabel : "";
        this.pp.yLabel.label = yLabel != null ? yLabel : "";
    }

    public void setMaxIntervals(int intervals) {
        this.maxIntervals = intervals;
    }

    public void setTickLength(int tickLength) {
    }

    public void setMinorTickLength(int minorTickLength) {
    }

    public void setFormatFlags(int flags) {
        int unchangedFlags = 3264;
        this.pp.axisFlags = this.pp.axisFlags & unchangedFlags | (flags &= ~unchangedFlags);
    }

    public int getFlags() {
        return this.pp.axisFlags;
    }

    public void setAxisXLog(boolean axisXLog) {
        this.pp.axisFlags = axisXLog ? this.pp.axisFlags | 0x400 : this.pp.axisFlags & 0xFFFFFBFF;
    }

    public void setAxisYLog(boolean axisYLog) {
        this.pp.axisFlags = axisYLog ? this.pp.axisFlags | 0x800 : this.pp.axisFlags & 0xFFFFF7FF;
    }

    public void setXTicks(boolean xTicks) {
        this.pp.axisFlags = xTicks ? this.pp.axisFlags | 4 : this.pp.axisFlags & 0xFFFFFFFB;
    }

    public void setYTicks(boolean yTicks) {
        this.pp.axisFlags = yTicks ? this.pp.axisFlags | 8 : this.pp.axisFlags & 0xFFFFFFF7;
    }

    public void setXMinorTicks(boolean xMinorTicks) {
        int n = this.pp.axisFlags = xMinorTicks ? this.pp.axisFlags | 0x100 : this.pp.axisFlags & 0xFFFFFEFF;
        if (xMinorTicks && !this.hasFlag(16)) {
            this.pp.axisFlags |= 4;
        }
    }

    public void setYMinorTicks(boolean yMinorTicks) {
        int n = this.pp.axisFlags = yMinorTicks ? this.pp.axisFlags | 0x200 : this.pp.axisFlags & 0xFFFFFDFF;
        if (yMinorTicks && !this.hasFlag(32)) {
            this.pp.axisFlags |= 8;
        }
    }

    public void setAxes(boolean xLog, boolean yLog, boolean xTicks, boolean yTicks, boolean xMinorTicks, boolean yMinorTicks, int tickLenght, int minorTickLenght) {
        this.setAxisXLog(xLog);
        this.setAxisYLog(yLog);
        this.setXMinorTicks(xMinorTicks);
        this.setYMinorTicks(yMinorTicks);
        this.setXTicks(xTicks);
        this.setYTicks(yTicks);
        this.setTickLength(tickLenght);
        this.setMinorTickLength(minorTickLenght);
    }

    public void setLogScaleX() {
        this.setAxisXLog(true);
    }

    public void setLogScaleY() {
        this.setAxisYLog(true);
    }

    public static int getDefaultFlags() {
        int defaultFlags = 0;
        if (!PlotWindow.noGridLines) {
            defaultFlags |= 0x3033;
        }
        if (!PlotWindow.noTicks) {
            defaultFlags |= 0x330F;
        }
        return defaultFlags;
    }

    public void add(String type, double[] xvalues, double[] yvalues) {
        int iShape = Plot.toShape(type);
        this.addPoints(Tools.toFloat(xvalues), Tools.toFloat(yvalues), null, iShape, iShape == 9 ? type.substring(5, type.length()) : null);
    }

    public void replace(int index, String type, double[] xvalues, double[] yvalues) {
        if (index >= 0 && index < this.allPlotObjects.size()) {
            this.objectToReplace = this.allPlotObjects.size() > 0 ? index : -1;
            this.add(type, xvalues, yvalues);
        }
    }

    public void add(String type, double[] yvalues) {
        int iShape = Plot.toShape(type);
        if (iShape == -1) {
            this.addErrorBars(yvalues);
        } else if (iShape == -2) {
            this.addHorizontalErrorBars(yvalues);
        } else {
            this.addPoints(null, Tools.toFloat(yvalues), null, iShape, iShape == 9 ? type.substring(5, type.length()) : null);
        }
    }

    public void addPoints(float[] xValues, float[] yValues, float[] yErrorBars, int shape, String label) {
        if (xValues == null || xValues.length == 0) {
            xValues = new float[yValues.length];
            for (int i = 0; i < yValues.length; ++i) {
                xValues[i] = i;
            }
        }
        if (this.objectToReplace >= 0) {
            this.allPlotObjects.set(this.objectToReplace, new PlotObject(xValues, yValues, yErrorBars, shape, this.currentLineWidth, this.currentColor, this.currentColor2, label));
        } else {
            this.allPlotObjects.add(new PlotObject(xValues, yValues, yErrorBars, shape, this.currentLineWidth, this.currentColor, this.currentColor2, label));
        }
        this.objectToReplace = -1;
        if (this.plotDrawn) {
            this.updateImage();
        }
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.addPoints(x, y, null, shape, null);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public static int toShape(String str) {
        str = str.toLowerCase(Locale.US);
        int shape = 0;
        if (str.contains("curve") || str.contains("line")) {
            shape = 2;
        } else if (str.contains("connected")) {
            shape = 7;
        } else if (str.contains("filled")) {
            shape = 10;
        } else if (str.contains("circle")) {
            shape = 0;
        } else if (str.contains("box")) {
            shape = 3;
        } else if (str.contains("triangle")) {
            shape = 4;
        } else if (str.contains("cross") || str.contains("+")) {
            shape = 5;
        } else if (str.contains("diamond")) {
            shape = 8;
        } else if (str.contains("dot")) {
            shape = 6;
        } else if (str.contains("xerror")) {
            shape = -2;
        } else if (str.contains("error")) {
            shape = -1;
        } else if (str.contains("x")) {
            shape = 1;
        } else if (str.contains("separate")) {
            shape = 12;
        } else if (str.contains("bar")) {
            shape = 11;
        }
        if (str.startsWith("code:")) {
            shape = 9;
        }
        return shape;
    }

    public void addPoints(ArrayList x, ArrayList y, int shape) {
        this.addPoints(this.getDoubleFromArrayList(x), this.getDoubleFromArrayList(y), shape);
    }

    public void addPoints(double[] x, double[] y, double[] errorBars, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), Tools.toFloat(errorBars), shape, null);
    }

    public void addPoints(ArrayList x, ArrayList y, ArrayList errorBars, int shape) {
        this.addPoints(this.getDoubleFromArrayList(x), this.getDoubleFromArrayList(y), this.getDoubleFromArrayList(errorBars), shape);
    }

    public double[] getDoubleFromArrayList(ArrayList list) {
        if (list == null) {
            return null;
        }
        double[] targ = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            targ[i] = (Double)list.get(i);
        }
        return targ;
    }

    public void drawVectors(double[] x1, double[] y1, double[] x2, double[] y2) {
        this.allPlotObjects.add(new PlotObject(Tools.toFloat(x1), Tools.toFloat(y1), Tools.toFloat(x2), Tools.toFloat(y2), this.currentLineWidth, this.currentColor));
    }

    public void drawShapes(String shapeType, ArrayList floatCoords) {
        this.allPlotObjects.add(new PlotObject(shapeType, floatCoords, this.currentLineWidth, this.currentColor, this.currentColor2));
    }

    public static double calculateDistance(int x1, int y1, int x2, int y2) {
        return Math.sqrt((double)(x2 - x1) * (double)(x2 - x1) + (double)(y2 - y1) * (double)(y2 - y1));
    }

    public void drawVectors(ArrayList x1, ArrayList y1, ArrayList x2, ArrayList y2) {
        this.drawVectors(this.getDoubleFromArrayList(x1), this.getDoubleFromArrayList(y1), this.getDoubleFromArrayList(x2), this.getDoubleFromArrayList(y2));
    }

    public void addErrorBars(float[] errorBars) {
        PlotObject mainObject = this.getLastCurveObject();
        if (mainObject == null) {
            throw new RuntimeException("Plot can't add y error bars without data");
        }
        mainObject.yEValues = errorBars;
    }

    public void addErrorBars(double[] errorBars) {
        this.addErrorBars(Tools.toFloat(errorBars));
    }

    public void addHorizontalErrorBars(float[] xErrorBars) {
        PlotObject mainObject = this.getLastCurveObject();
        if (mainObject == null) {
            throw new RuntimeException("Plot can't add x error bars without data");
        }
        mainObject.xEValues = xErrorBars;
    }

    public void addHorizontalErrorBars(double[] xErrorBars) {
        this.addHorizontalErrorBars(Tools.toFloat(xErrorBars));
    }

    public void addLabel(double x, double y, String label) {
        if (this.textLoc != null && x == this.textLoc.getX() && y == this.textLoc.getY()) {
            this.allPlotObjects.set(this.textIndex, new PlotObject(label, x, y, this.currentJustification, this.currentFont, this.currentColor, 64));
        } else {
            this.allPlotObjects.add(new PlotObject(label, x, y, this.currentJustification, this.currentFont, this.currentColor, 64));
            this.textLoc = new Point2D.Double(x, y);
            this.textIndex = this.allPlotObjects.size() - 1;
        }
    }

    public void addText(String label, double x, double y) {
        this.allPlotObjects.add(new PlotObject(label, x, y, this.currentJustification, this.currentFont, this.currentColor, 32));
    }

    public void addLegend(String labels) {
        this.addLegend(labels, "auto");
    }

    public void addLegend(String labels, String options) {
        int flags = 0;
        if (options != null) {
            if ((options = options.toLowerCase()).contains("top-left")) {
                flags |= 0x90;
            } else if (options.contains("top-right")) {
                flags |= 0xA0;
            } else if (options.contains("bottom-left")) {
                flags |= 0xB0;
            } else if (options.contains("bottom-right")) {
                flags |= 0xC0;
            } else if (!options.contains("off") && !options.contains("no")) {
                flags |= 0x80;
            }
            if (options.contains("bottom-to-top")) {
                flags |= 0x100;
            }
            if (options.contains("transparent")) {
                flags |= 0x200;
            }
        }
        this.setLegend(labels, flags);
    }

    public void setLegend(String labels, int flags) {
        if (labels != null && labels.length() > 0) {
            String[] allLabels = labels.split("[\n\t]");
            int iPart = 0;
            for (PlotObject plotObject : this.allPlotObjects) {
                String label;
                if (plotObject.type != 1 || plotObject.hasFlag(8192) || iPart >= allLabels.length || (label = allLabels[iPart++]) == null || label.length() <= 0) continue;
                plotObject.label = label;
            }
        }
        this.pp.legend = new PlotObject(this.currentLineWidth == 0.0f ? 1.0f : this.currentLineWidth, this.currentFont, this.currentColor == null ? Color.black : this.currentColor, flags);
        if (this.plotDrawn) {
            this.updateImage();
        }
    }

    public void setLabel(int index, String label) {
        if (index < 0) {
            index = this.allPlotObjects.size() + index;
        }
        this.allPlotObjects.get((int)index).label = label;
    }

    public void removeNaNs() {
        for (PlotObject plotObj : this.allPlotObjects) {
            if (plotObj == null || plotObj.xValues == null || plotObj.yValues == null) continue;
            int oldSize = plotObj.xValues.length;
            float[] xVals = new float[oldSize];
            float[] yVals = new float[oldSize];
            int newSize = 0;
            for (int kk = 0; kk < oldSize; ++kk) {
                if (Float.isNaN(plotObj.xValues[kk] + plotObj.yValues[kk])) continue;
                xVals[newSize] = plotObj.xValues[kk];
                yVals[newSize] = plotObj.yValues[kk];
                ++newSize;
            }
            if (newSize >= oldSize) continue;
            plotObj.xValues = new float[newSize];
            plotObj.yValues = new float[newSize];
            System.arraycopy(xVals, 0, plotObj.xValues, 0, newSize);
            System.arraycopy(yVals, 0, plotObj.yValues, 0, newSize);
        }
    }

    public String[] getTypes() {
        return SORTED_SHAPES;
    }

    public void setJustification(int justification) {
        this.currentJustification = justification;
    }

    public void setColor(Color c) {
        this.currentColor = c;
        this.currentColor2 = null;
    }

    public void setColor(String color) {
        this.setColor(Colors.decode(color, Color.black));
    }

    public void setColor(Color c, Color c2) {
        this.currentColor = c;
        this.currentColor2 = c2;
    }

    public void setColor(String c1, String c2) {
        this.setColor(Colors.decode(c1, Color.black), Colors.decode(c2, null));
    }

    public void setBackgroundColor(Color c) {
        this.pp.frame.color2 = c;
    }

    public void setBackgroundColor(String c) {
        this.setBackgroundColor(Colors.decode(c, Color.white));
    }

    public void setLineWidth(int lineWidth) {
        this.currentLineWidth = lineWidth > 0 ? (float)lineWidth : 0.01f;
    }

    public void setLineWidth(float lineWidth) {
        this.currentLineWidth = (double)lineWidth > 0.01 ? lineWidth : 0.01f;
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.allPlotObjects.add(new PlotObject(x1, y1, x2, y2, this.currentLineWidth, 0, this.currentColor, 4));
    }

    public void drawNormalizedLine(double x1, double y1, double x2, double y2) {
        this.allPlotObjects.add(new PlotObject(x1, y1, x2, y2, this.currentLineWidth, 0, this.currentColor, 8));
    }

    public void drawDottedLine(double x1, double y1, double x2, double y2, int step) {
        this.allPlotObjects.add(new PlotObject(x1, y1, x2, y2, this.currentLineWidth, step, this.currentColor, 16));
    }

    public void setFontSize(int size) {
        this.setFont(-1, size);
    }

    public void setFont(Font font) {
        if (font == null) {
            font = this.defaultFont;
        }
        this.currentFont = font;
        if (this.plotDrawn) {
            this.pp.frame.setFont(font);
            if (this.pp.legend != null) {
                this.pp.legend.setFont(font);
            }
        }
    }

    public void setFont(int style, float size) {
        if (size < 9.0f) {
            size = 9.0f;
        }
        if (size > 36.0f) {
            size = 36.0f;
        }
        Font previousFont = this.nonNullFont(this.pp.frame.getFont(), this.currentFont);
        if (style < 0) {
            style = previousFont.getStyle();
        }
        this.setFont(previousFont.deriveFont(style, size));
    }

    public void setAxisLabelFont(int style, float size) {
        if (size < 9.0f) {
            size = 9.0f;
        }
        if (size > 33.0f) {
            size = 33.0f;
        }
        this.pp.xLabel.setFont(this.nonNullFont(this.pp.xLabel.getFont(), this.currentFont));
        this.pp.yLabel.setFont(this.nonNullFont(this.pp.yLabel.getFont(), this.currentFont));
        this.setXLabelFont(this.pp.xLabel.getFont().deriveFont(style < 0 ? this.pp.xLabel.getFont().getStyle() : style, size));
        this.setYLabelFont(this.pp.xLabel.getFont().deriveFont(style < 0 ? this.pp.yLabel.getFont().getStyle() : style, size));
    }

    public void setXLabelFont(Font font) {
        this.pp.xLabel.setFont(font);
    }

    public void setYLabelFont(Font font) {
        this.pp.yLabel.setFont(font);
    }

    public void setAntialiasedText(boolean antialiasedText) {
        this.pp.antialiasedText = antialiasedText;
    }

    public Font getCurrentFont() {
        return this.currentFont != null ? this.currentFont : this.defaultFont;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Font getFont(char c) {
        PlotObject plotObject = this.pp.getPlotObject(c);
        if (plotObject != null) {
            return plotObject.getFont();
        }
        return null;
    }

    public void setFont(char c, Font font) {
        PlotObject plotObject = this.pp.getPlotObject(c);
        if (plotObject != null) {
            plotObject.setFont(font);
        }
    }

    public String getLabel(char c) {
        PlotObject plotObject = this.pp.getPlotObject(c);
        if (plotObject != null) {
            return plotObject.label;
        }
        return null;
    }

    public int getObjectFlags(char c) {
        PlotObject plotObject = this.pp.getPlotObject(c);
        if (plotObject != null) {
            return plotObject.flags;
        }
        return -1;
    }

    public float[] getXValues() {
        PlotObject p = this.getMainCurveObject();
        return p == null ? null : p.xValues;
    }

    public float[] getYValues() {
        PlotObject p = this.getMainCurveObject();
        return p == null ? null : p.yValues;
    }

    public float[][] getDataObjectArrays(int index) {
        int i = 0;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 1 || plotObject.hasFlag(8192)) continue;
            if (index == i) {
                return new float[][]{plotObject.xValues, plotObject.yValues, plotObject.xEValues, plotObject.yEValues};
            }
            ++i;
        }
        return null;
    }

    public String[] getPlotObjectDesignations() {
        return this.getPlotObjectDesignations(-1, true);
    }

    public String[] getDataObjectDesignations() {
        return this.getPlotObjectDesignations(1, false);
    }

    public int getNumPlotObjects() {
        return this.allPlotObjects.size();
    }

    int getNumPlotObjects(int mask, boolean includeHidden) {
        int nObjects = 0;
        for (PlotObject plotObject : this.allPlotObjects) {
            if ((plotObject.type & mask) == 0 || !includeHidden && plotObject.hasFlag(8192)) continue;
            ++nObjects;
        }
        return nObjects;
    }

    String[] getPlotObjectDesignations(int mask, boolean includeHidden) {
        int nObjects = this.getNumPlotObjects(mask, includeHidden);
        String[] names = new String[nObjects];
        if (names.length == 0) {
            return names;
        }
        int iData = 1;
        int iArrow = 1;
        int iLine = 1;
        int iText = 1;
        boolean iBox = true;
        int iShape = 1;
        int i = 0;
        for (PlotObject plotObject : this.allPlotObjects) {
            int type = plotObject.type;
            if ((type & mask) == 0 || !includeHidden && plotObject.hasFlag(8192)) continue;
            String label = plotObject.label;
            switch (type) {
                case 1: {
                    names[i] = "Data Set " + iData + ": " + (plotObject.label != null ? plotObject.label : "(" + plotObject.yValues.length + " data points)");
                    ++iData;
                    break;
                }
                case 2: {
                    names[i] = "Arrow Set " + iArrow + " (" + plotObject.xValues.length + ")";
                    ++iArrow;
                    break;
                }
                case 4: 
                case 8: 
                case 16: {
                    String detail = "";
                    if (type == 16) {
                        detail = "dotted ";
                    }
                    if (plotObject.x == plotObject.xEnd) {
                        detail = detail + "vertical";
                    } else if (plotObject.y == plotObject.yEnd) {
                        detail = detail + "horizontal";
                    }
                    if (detail.length() > 0) {
                        detail = " (" + detail.trim() + ")";
                    }
                    names[i] = "Straight Line " + iLine + detail;
                    ++iLine;
                    break;
                }
                case 32: 
                case 64: {
                    String text = plotObject.label.replaceAll("\n", " ");
                    if (text.length() > 45) {
                        text = text.substring(0, 40) + "...";
                    }
                    names[i] = "Text " + iText + ": \"" + text + '\"';
                    ++iText;
                    break;
                }
                case 1024: {
                    String s = plotObject.shapeType;
                    String[] words = s.split(" ");
                    names[i] = "Shapes (" + words[0] + ") " + iShape;
                    ++iShape;
                }
            }
            ++i;
        }
        return names;
    }

    public int addObjectFromPlot(Plot plot, int i) {
        PlotObject plotObject = plot.getPlotObjectDeepClone(i);
        plotObject.unsetFlag(4096);
        this.allPlotObjects.add(plotObject);
        int index = this.allPlotObjects.size() - 1;
        return index;
    }

    public String getPlotObjectStyle(int i) {
        return this.getPlotObjectStyle(this.allPlotObjects.get(i));
    }

    String getPlotObjectStyle(PlotObject plotObject) {
        String styleString = Colors.colorToString(plotObject.color) + "," + Colors.colorToString(plotObject.color2) + "," + plotObject.lineWidth;
        if (plotObject.type == 1) {
            styleString = styleString + "," + SHAPE_NAMES[plotObject.shape];
        }
        if (plotObject.hasFlag(8192)) {
            styleString = styleString + ",hidden";
        }
        return styleString;
    }

    public String getPlotObjectLabel(int i) {
        return this.allPlotObjects.get((int)i).label;
    }

    public void setPlotObjectLabel(int i, String label) {
        this.allPlotObjects.get((int)i).label = label;
    }

    public void setStyle(int index, String style) {
        if (index < 0 || index >= this.allPlotObjects.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        this.setPlotObjectStyle(this.allPlotObjects.get(index), style);
    }

    public void setPlotObjectStyle(int i, String styleString) {
        this.setStyle(i, styleString);
    }

    void setPlotObjectStyle(PlotObject plotObject, String styleString) {
        int nItems;
        String[] items = styleString.split(",");
        if (items[(nItems = items.length) - 1].indexOf("hidden") >= 0) {
            plotObject.setFlag(8192);
            nItems = items.length - 1;
        } else {
            plotObject.unsetFlag(8192);
        }
        plotObject.color = Colors.decode(items[0].trim(), plotObject.color);
        plotObject.color2 = Colors.decode(items[1].trim(), null);
        float lineWidth = plotObject.lineWidth;
        if (items.length >= 3) {
            try {
                plotObject.lineWidth = Float.parseFloat(items[2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (items.length >= 4 && plotObject.shape != 9) {
            plotObject.shape = Plot.toShape(items[3].trim());
        }
        this.updateImage();
    }

    public int getPlotObjectIndex(float[][] values) {
        return this.getPlotObjectIndex(3, values);
    }

    int getPlotObjectIndex(int typeMask, float[][] values) {
        for (int i = 0; i < this.allPlotObjects.size(); ++i) {
            PlotObject plotObject = this.allPlotObjects.get(i);
            if ((plotObject.type & typeMask) == 0) continue;
            float[][] plotObjectArrays = plotObject.getAllDataValues();
            boolean equal = true;
            for (int j = 0; j < Math.min(plotObjectArrays.length, values.length); ++j) {
                if (Arrays.equals(plotObjectArrays[j], values[j])) continue;
                equal = false;
                break;
            }
            if (!equal) continue;
            return i;
        }
        return -1;
    }

    public void savePlotObjects() {
        this.allPlotObjectsSnapshot = new Vector(this.allPlotObjects.size());
        this.copyPlotObjectsVector(this.allPlotObjects, this.allPlotObjectsSnapshot);
    }

    public void restorePlotObjects() {
        if (this.allPlotObjectsSnapshot != null) {
            this.copyPlotObjectsVector(this.allPlotObjectsSnapshot, this.allPlotObjects);
        }
    }

    public void killPlotObjectsSnapshot() {
        this.allPlotObjectsSnapshot = null;
    }

    public void savePlotPlotProperties() {
        this.pp.rangeMinMax = this.currentMinMax;
        this.ppSnapshot = this.pp.deepClone();
    }

    public void restorePlotProperties() {
        this.pp = this.ppSnapshot.deepClone();
        System.arraycopy(this.pp.rangeMinMax, 0, this.currentMinMax, 0, Math.min(this.pp.rangeMinMax.length, this.currentMinMax.length));
    }

    public void killPlotPropertiesSnapshot() {
        this.ppSnapshot = null;
    }

    private void copyPlotObjectsVector(Vector<PlotObject> src, Vector<PlotObject> dest) {
        if (dest.size() > 0) {
            dest.removeAllElements();
        }
        for (PlotObject plotObject : src) {
            dest.add(plotObject.deepClone());
        }
    }

    PlotObject getPlotObjectDeepClone(int i) {
        return this.allPlotObjects.get(i).deepClone();
    }

    public void setLimitsToDefaults(boolean updateImg) {
        this.saveMinMax();
        System.arraycopy(this.defaultMinMax, 0, this.currentMinMax, 0, this.defaultMinMax.length);
        if (this.plotDrawn && updateImg) {
            this.updateImage();
        }
    }

    public void setLimitsToFit(boolean updateImg) {
        this.saveMinMax();
        this.currentMinMax = this.getMinAndMax(true, 3);
        if (Double.isNaN(this.defaultMinMax[0]) && Double.isNaN(this.defaultMinMax[2])) {
            System.arraycopy(this.currentMinMax, 0, this.defaultMinMax, 0, Math.min(this.currentMinMax.length, this.defaultMinMax.length));
        }
        this.enlargeRange(this.currentMinMax);
        if (this.plotDrawn && updateImg) {
            this.updateImage();
        }
    }

    public void setPreviousMinMax() {
        if (Double.isNaN(this.savedMinMax[0])) {
            return;
        }
        double[] swap = new double[this.currentMinMax.length];
        System.arraycopy(this.currentMinMax, 0, swap, 0, this.currentMinMax.length);
        System.arraycopy(this.savedMinMax, 0, this.currentMinMax, 0, this.currentMinMax.length);
        System.arraycopy(swap, 0, this.savedMinMax, 0, this.currentMinMax.length);
        this.updateImage();
    }

    public ImageProcessor getProcessor() {
        this.draw();
        return this.ip;
    }

    public ImagePlus getImagePlus() {
        if (this.stack != null) {
            if (this.imp != null) {
                return this.imp;
            }
            this.imp = new ImagePlus(this.title, this.stack);
            this.adjustCalibration(this.imp.getCalibration());
            return this.imp;
        }
        if (this.plotDrawn) {
            this.updateImage();
        } else {
            this.draw();
        }
        if (this.imp != null) {
            if (this.imp.getProcessor() != this.ip) {
                this.imp.setProcessor(this.ip);
            }
            return this.imp;
        }
        ImagePlus imp = new ImagePlus(this.title, this.ip);
        this.setImagePlus(imp);
        return imp;
    }

    public void setImagePlus(ImagePlus imp) {
        if (imp != null && imp == this.imp && imp.getProcessor() == this.ip) {
            return;
        }
        if (this.stack != null) {
            return;
        }
        if (this.imp != null) {
            this.imp.setProperty(PROPERTY_KEY, null);
        }
        this.imp = imp;
        if (imp != null) {
            imp.setIgnoreGlobalCalibration(true);
            this.adjustCalibration(imp.getCalibration());
            imp.setProperty(PROPERTY_KEY, this);
            if (this.ip != null && imp.getProcessor() != this.ip) {
                imp.setProcessor(this.ip);
            }
        }
    }

    public void adjustCalibration(Calibration cal) {
        if (this.xMin == this.xMax) {
            this.xScale = 1000000.0;
        }
        if (this.yMin == this.yMax) {
            this.yScale = 1000000.0;
        }
        cal.xOrigin = (double)this.xBasePxl - this.xMin * this.xScale;
        cal.pixelWidth = 1.0 / Math.abs(this.xScale);
        cal.yOrigin = (double)this.yBasePxl + this.yMin * this.yScale;
        cal.pixelHeight = 1.0 / Math.abs(this.yScale);
        cal.setInvertY(this.yScale >= 0.0);
        cal.setXUnit(" ");
        if (this.xMin == this.xMax) {
            this.xScale = Double.POSITIVE_INFINITY;
        }
        if (this.yMin == this.yMax) {
            this.yScale = Double.POSITIVE_INFINITY;
        }
    }

    public PlotWindow show() {
        PlotVirtualStack stack = this.getStack();
        if (stack != null) {
            this.getImagePlus().show();
            return null;
        }
        if (IJ.macroRunning() && IJ.getInstance() == null || Interpreter.isBatchMode()) {
            this.imp = this.getImagePlus();
            this.imp.setPlot(this);
            WindowManager.setTempCurrentImage(this.imp);
            if (this.getMainCurveObject() != null) {
                this.imp.setProperty("XValues", this.getXValues());
                this.imp.setProperty("YValues", this.getYValues());
            }
            Interpreter.addBatchModeImage(this.imp);
            return null;
        }
        if (this.imp != null) {
            ImageWindow win = this.imp.getWindow();
            if (win instanceof PlotWindow && win.isVisible()) {
                this.updateImage();
                return (PlotWindow)win;
            }
            this.setImagePlus(null);
        }
        PlotWindow pw = new PlotWindow(this);
        if (IJ.isMacro() && this.imp != null) {
            IJ.selectWindow(this.imp.getID());
        }
        return pw;
    }

    public void addToStack() {
        if (this.stack == null) {
            this.stack = new PlotVirtualStack(this.getSize().width, this.getSize().height);
        }
        this.draw();
        this.stack.addPlot(this);
        IJ.showStatus("addToPlotStack: " + this.stack.size());
        this.allPlotObjects.clear();
        this.textLoc = null;
    }

    public void appendToStack() {
        this.addToStack();
    }

    public PlotVirtualStack getStack() {
        IJ.showStatus("");
        return this.stack;
    }

    public void draw() {
        if (this.plotDrawn) {
            return;
        }
        this.getInitialMinAndMax();
        this.pp.frame.setFont(this.nonNullFont(this.pp.frame.getFont(), this.currentFont));
        this.getBlankProcessor();
        this.drawContents(this.ip);
    }

    public void setFrozen(boolean frozen) {
        this.pp.isFrozen = frozen;
        if (!this.pp.isFrozen) {
            ImageWindow win;
            if (this.imp != null && this.ip != null) {
                ImageCanvas ic = this.imp.getCanvas();
                if (ic instanceof PlotCanvas) {
                    ((PlotCanvas)ic).resetMagnification();
                    this.imp.setTitle(this.imp.getTitle());
                }
                Undo.setup(6, this.imp);
            }
            this.updateImage();
            ImageWindow imageWindow = win = this.imp == null ? null : this.imp.getWindow();
            if (win != null) {
                win.updateImage(this.imp);
            }
        }
    }

    public boolean isFrozen() {
        return this.pp.isFrozen;
    }

    public void update() {
        this.updateImage();
    }

    public void updateImage() {
        if (!this.plotDrawn || this.pp.isFrozen) {
            return;
        }
        this.getBlankProcessor();
        this.drawContents(this.ip);
        if (this.imp == null || this.stack != null) {
            return;
        }
        this.adjustCalibration(this.imp.getCalibration());
        this.imp.updateAndDraw();
        if (this.ip != this.imp.getProcessor()) {
            this.imp.setProcessor(this.ip);
        }
    }

    public Rectangle getDrawingFrame() {
        if (this.frame == null) {
            this.getBlankProcessor();
        }
        return new Rectangle(this.frame.x, this.frame.y, this.frameWidth, this.frameHeight);
    }

    public ImagePlus makeHighResolution(String title, float scale, boolean antialiasedText, boolean showIt) {
        Plot hiresPlot = null;
        try {
            hiresPlot = (Plot)this.clone();
        }
        catch (Exception e) {
            return null;
        }
        hiresPlot.ip = null;
        hiresPlot.imp = null;
        hiresPlot.pp = this.pp.clone();
        if (!this.plotDrawn) {
            hiresPlot.getInitialMinAndMax();
        }
        hiresPlot.setScale(scale);
        hiresPlot.setAntialiasedText(antialiasedText);
        hiresPlot.defaultMinMax = (double[])this.currentMinMax.clone();
        ImageProcessor hiresIp = hiresPlot.getProcessor();
        if (title == null || title.length() == 0) {
            title = this.getTitle() + "_HiRes";
        }
        title = WindowManager.makeUniqueName(title);
        ImagePlus hiresImp = new ImagePlus(title, hiresIp);
        Calibration cal = hiresImp.getCalibration();
        hiresPlot.adjustCalibration(cal);
        if (showIt) {
            hiresImp.setIgnoreGlobalCalibration(true);
            hiresImp.show();
        }
        hiresPlot.dispose();
        return hiresImp;
    }

    public void dispose() {
        if (this.imp != null) {
            this.imp.setProperty(PROPERTY_KEY, null);
        }
        this.imp = null;
        this.ip = null;
    }

    public double descaleX(int x) {
        if (this.xMin == this.xMax) {
            return this.xMin;
        }
        double xv = (double)(x - this.xBasePxl) / this.xScale + this.xMin;
        if (this.logXAxis) {
            xv = Math.pow(10.0, xv);
        }
        return xv;
    }

    public double descaleY(int y) {
        if (this.yMin == this.yMax) {
            return this.yMin;
        }
        double yv = (double)(this.yBasePxl - y) / this.yScale + this.yMin;
        if (this.logYAxis) {
            yv = Math.pow(10.0, yv);
        }
        return yv;
    }

    public double scaleXtoPxl(double x) {
        if (this.xMin == this.xMax) {
            if (x == this.xMin) {
                return this.xBasePxl;
            }
            return x > this.xMin ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (this.logXAxis) {
            return (double)this.xBasePxl + (Math.log10(x) - this.xMin) * this.xScale;
        }
        return (double)this.xBasePxl + (x - this.xMin) * this.xScale;
    }

    public double scaleYtoPxl(double y) {
        if (this.yMin == this.yMax) {
            if (y == this.xMin) {
                return this.yBasePxl;
            }
            return y > this.yMin ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (this.logYAxis) {
            return (double)this.yBasePxl - (Math.log10(y) - this.yMin) * this.yScale;
        }
        return (double)this.yBasePxl - (y - this.yMin) * this.yScale;
    }

    private int scaleX(double x) {
        if (Double.isNaN(x)) {
            return -1;
        }
        if (this.xMin == this.xMax) {
            if (x == this.xMin) {
                return this.xBasePxl;
            }
            return x > this.xMin ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        if (this.logXAxis) {
            return this.xBasePxl + (int)Math.round((Math.log10(x) - this.xMin) * this.xScale);
        }
        return this.xBasePxl + (int)Math.round((x - this.xMin) * this.xScale);
    }

    private int scaleY(double y) {
        if (Double.isNaN(y)) {
            return -1;
        }
        if (this.yMin == this.yMax) {
            if (y == this.yMin) {
                return this.yBasePxl;
            }
            return y > this.yMin ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        if (this.logYAxis) {
            return this.yBasePxl - (int)Math.round((Math.log10(y) - this.yMin) * this.yScale);
        }
        return this.yBasePxl - (int)Math.round((y - this.yMin) * this.yScale);
    }

    private int scaleXWithOverflow(double x) {
        if (!this.logXAxis || x > 0.0) {
            return this.scaleX(x);
        }
        return this.xScale > 0.0 ? -1000000 : 1000000;
    }

    private int scaleYWithOverflow(double y) {
        if (!this.logYAxis || y > 0.0) {
            return this.scaleY(y);
        }
        return this.yScale > 0.0 ? 1000000 : -1000000;
    }

    int sc(float length) {
        int pixels = (int)((double)(length * this.scale) + 0.5);
        if (pixels < 1) {
            pixels = 1;
        }
        return pixels;
    }

    Font scFont(Font font) {
        float size = font.getSize2D();
        return this.scale == 1.0f ? font : font.deriveFont(size * this.scale);
    }

    boolean isColored() {
        for (PlotObject plotObject : this.allPlotObjects) {
            if (!this.isColored(plotObject.color) && !this.isColored(plotObject.color2)) continue;
            return true;
        }
        for (PlotObject plotObject : this.pp.getAllPlotObjects()) {
            if (plotObject == null || !this.isColored(plotObject.color) && !this.isColored(plotObject.color2)) continue;
            return true;
        }
        return false;
    }

    boolean isColored(Color c) {
        if (c == null) {
            return false;
        }
        return c.getRed() != c.getGreen() || c.getGreen() != c.getBlue();
    }

    void drawContents(ImageProcessor ip) {
        this.makeRangeGetSteps();
        ip.setColor(Color.black);
        ip.setLineWidth(this.sc(1.0f));
        float lineWidth = 1.0f;
        Color color = Color.black;
        Font font = this.defaultFont;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.hasFlag(4096)) continue;
            if (plotObject.lineWidth > 0.0f) {
                lineWidth = plotObject.lineWidth;
            } else {
                plotObject.lineWidth = lineWidth;
            }
            if (plotObject.color != null) {
                color = plotObject.color;
            } else {
                plotObject.color = color;
            }
            if (plotObject.getFont() != null) {
                font = plotObject.getFont();
            } else {
                plotObject.setFont(font);
            }
            this.drawPlotObject(plotObject, ip);
        }
        if (this.allPlotObjects.size() > 0 && this.allPlotObjects.get(0).hasFlag(4096)) {
            PlotObject mainPlotObject = this.allPlotObjects.get(0);
            if (mainPlotObject.lineWidth == 0.0f) {
                mainPlotObject.lineWidth = this.currentLineWidth == 0.0f ? 1.0f : this.currentLineWidth;
            }
            lineWidth = mainPlotObject.lineWidth;
            if (mainPlotObject.color == null) {
                mainPlotObject.color = this.currentColor == null ? Color.black : this.currentColor;
            }
            this.drawPlotObject(mainPlotObject, ip);
        } else if (this.currentLineWidth > 0.0f) {
            lineWidth = this.currentLineWidth;
        }
        if (!this.plotDrawn && this.pp.frame.lineWidth == 1.0001f) {
            this.pp.frame.lineWidth = lineWidth;
            if (this.pp.frame.lineWidth == 0.0f) {
                this.pp.frame.lineWidth = 1.0f;
            }
            if (this.pp.frame.lineWidth > 3.0f) {
                this.pp.frame.lineWidth = 3.0f;
            }
        }
        ip.setLineWidth(this.sc(this.pp.frame.lineWidth));
        ip.setColor(this.pp.frame.color);
        int x2 = this.frame.x + this.frame.width - 1;
        int y2 = this.frame.y + this.frame.height - 1;
        ip.moveTo(this.frame.x, this.frame.y);
        ip.lineTo(x2, this.frame.y);
        ip.lineTo(x2, y2);
        ip.lineTo(this.frame.x, y2);
        ip.lineTo(this.frame.x, this.frame.y);
        if (this.pp.legend != null && (this.pp.legend.flags & 0xF0) != 0) {
            this.drawPlotObject(this.pp.legend, ip);
        }
        this.plotDrawn = true;
    }

    ImageProcessor getBlankProcessor() {
        this.makeMarginValues();
        if (this.pp.width <= 0 || this.pp.height <= 0) {
            this.pp.width = this.sc(this.preferredPlotWidth) + this.leftMargin + this.rightMargin;
            this.pp.height = this.sc(this.preferredPlotHeight) + this.topMargin + this.bottomMargin;
        }
        this.frameWidth = this.pp.width - (this.leftMargin + this.rightMargin);
        this.frameHeight = this.pp.height - (this.topMargin + this.bottomMargin);
        boolean isColored = this.isColored();
        if (this.ip == null || this.pp.width != this.ip.getWidth() || this.pp.height != this.ip.getHeight() || isColored != this.ip instanceof ColorProcessor) {
            if (isColored) {
                this.ip = new ColorProcessor(this.pp.width, this.pp.height);
            } else {
                this.ip = new ByteProcessor(this.pp.width, this.pp.height);
                boolean bl = this.invertedLut = Prefs.useInvertingLut && !Interpreter.isBatchMode() && IJ.getInstance() != null;
                if (this.invertedLut) {
                    this.ip.invertLut();
                }
            }
            if (this.imp != null && this.stack == null) {
                this.imp.setProcessor(this.ip);
            }
        }
        if (this.ip instanceof ColorProcessor) {
            Arrays.fill((int[])this.ip.getPixels(), 0xFFFFFF);
        } else {
            Arrays.fill((byte[])this.ip.getPixels(), this.invertedLut ? (byte)0 : -1);
        }
        this.ip.setFont(this.scFont(this.defaultFont));
        this.ip.setLineWidth(this.sc(1.0f));
        this.ip.setAntialiasedText(this.pp.antialiasedText);
        this.frame = new Rectangle(this.leftMargin, this.topMargin, this.frameWidth + 1, this.frameHeight + 1);
        if (this.pp.frame.color2 != null) {
            this.ip.setColor(this.pp.frame.color2);
            this.ip.setRoi(this.frame);
            this.ip.fill();
            this.ip.resetRoi();
        }
        this.ip.setColor(Color.black);
        return this.ip;
    }

    void makeMarginValues() {
        Font font = this.nonNullFont(this.pp.frame.getFont(), this.currentFont);
        float marginScale = 0.1f + 0.9f * font.getSize2D() / 12.0f;
        if (marginScale < 0.7f) {
            marginScale = 0.7f;
        }
        if (marginScale > 2.0f) {
            marginScale = 2.0f;
        }
        int addHspace = (int)Tools.getNumberFromList(this.pp.frame.options, "addhspace=");
        int addVspace = (int)Tools.getNumberFromList(this.pp.frame.options, "addvspace=");
        this.leftMargin = this.sc(65.0f * marginScale + (float)addHspace);
        this.rightMargin = this.sc(18.0f * marginScale + (float)addHspace);
        this.topMargin = this.sc(15.0f * marginScale + (float)addVspace);
        this.bottomMargin = this.sc(40.0f * marginScale + 2.0f + (float)addVspace);
        if (this.pp != null && this.pp.xLabel != null && this.pp.xLabel.getFont() != null) {
            float numberSize = font.getSize2D();
            float labelSize = this.pp.xLabel.getFont().getSize2D();
            float extraHeight = 1.5f * (labelSize - numberSize);
            if (extraHeight > 0.0f) {
                this.bottomMargin += this.sc(extraHeight);
                this.leftMargin += this.sc(extraHeight);
            }
        }
    }

    double[] makeRangeGetSteps() {
        this.steps = new double[2];
        this.logXAxis = this.hasFlag(1024);
        this.logYAxis = this.hasFlag(2048);
        for (int i = 0; i < this.currentMinMax.length; i += 2) {
            double rangeRatio;
            boolean logAxis = this.hasFlag(i == 0 ? 1024 : 2048);
            double range = this.currentMinMax[i + 1] - this.currentMinMax[i];
            double mid = 0.5 * (this.currentMinMax[i + 1] + this.currentMinMax[i]);
            double relativeRange = Math.abs(range / mid);
            if (!logAxis) {
                relativeRange = Math.min(relativeRange, Math.abs(range / (this.defaultMinMax[i + 1] - this.defaultMinMax[i])));
            }
            if (range != 0.0 && relativeRange < 1.0E-4) {
                this.currentMinMax[i + 1] = mid + 0.5 * range * 1.0E-4 / relativeRange;
                this.currentMinMax[i] = mid - 0.5 * range * 1.0E-4 / relativeRange;
            }
            if (!(!logAxis || ((rangeRatio = this.currentMinMax[i + 1] / this.currentMinMax[i]) > 3.0 || 1.0 / rangeRatio > 3.0) && this.currentMinMax[i] > (double)1.4E-44f && this.currentMinMax[i + 1] > (double)1.4E-44f)) {
                logAxis = false;
            }
            if (logAxis) {
                this.currentMinMax[i] = Math.log10(this.currentMinMax[i]);
                this.currentMinMax[i + 1] = Math.log10(this.currentMinMax[i + 1]);
            }
            if (i == 0 && !this.simpleXAxis() || i == 2 && !this.simpleYAxis()) {
                boolean force2grid;
                int minGridspacing = i == 0 ? 45 : 30;
                int frameSize = i == 0 ? this.frameWidth : this.frameHeight;
                double step = Tools.getNumberFromList(this.pp.frame.options, i == 0 ? "xinterval=" : "yinterval=");
                if (!Double.isNaN(step)) {
                    int nSteps = (int)(Math.floor(this.currentMinMax[i + 1] / step + 1.0E-10) - Math.ceil(this.currentMinMax[i] / step - 1.0E-10));
                    if (nSteps < 1) {
                        step = Double.NaN;
                    }
                    if (i == 0 && (double)(nSteps * this.sc(minGridspacing)) * 0.5 > (double)frameSize || i != 0 && nSteps * this.sc(this.pp.frame.getFont().getSize()) > frameSize) {
                        step = Double.NaN;
                    }
                }
                if (Double.isNaN(step)) {
                    step = Math.abs((this.currentMinMax[i + 1] - this.currentMinMax[i]) * Math.max(1.0 / (double)this.maxIntervals, (double)((float)this.sc(minGridspacing) / (float)frameSize) + (this.maxIntervals > 12 ? 0.02 : 0.06)));
                    step = this.niceNumber(step);
                }
                if (logAxis && step < 1.0) {
                    step = 1.0;
                }
                this.steps[i / 2] = step;
                boolean bl = force2grid = this.hasFlag(i == 0 ? 64 : 128) && !this.ignoreForce2Grid;
                if (force2grid) {
                    int i1 = (int)Math.floor(Math.min(this.currentMinMax[i], this.currentMinMax[i + 1]) / step + 1.0E-10);
                    int i2 = (int)Math.ceil(Math.max(this.currentMinMax[i], this.currentMinMax[i + 1]) / step - 1.0E-10);
                    if (this.currentMinMax[i + 1] > this.currentMinMax[i]) {
                        this.currentMinMax[i] = (double)i1 * step;
                        this.currentMinMax[i + 1] = (double)i2 * step;
                    } else {
                        this.currentMinMax[i] = (double)i2 * step;
                        this.currentMinMax[i + 1] = (double)i1 * step;
                    }
                }
            }
            if (i == 0) {
                this.xMin = this.currentMinMax[i];
                this.xMax = this.currentMinMax[i + 1];
                this.logXAxis = logAxis;
            } else {
                this.yMin = this.currentMinMax[i];
                this.yMax = this.currentMinMax[i + 1];
                this.logYAxis = logAxis;
            }
            if (!logAxis) continue;
            this.currentMinMax[i] = Math.pow(10.0, this.currentMinMax[i]);
            this.currentMinMax[i + 1] = Math.pow(10.0, this.currentMinMax[i + 1]);
        }
        this.ignoreForce2Grid = false;
        this.xBasePxl = this.leftMargin;
        this.yBasePxl = this.topMargin + this.frameHeight;
        this.xScale = (double)this.frameWidth / (this.xMax - this.xMin);
        if (this.xMax - this.xMin == 0.0) {
            this.xBasePxl += this.sc(10.0f);
        }
        this.yScale = (double)this.frameHeight / (this.yMax - this.yMin);
        if (this.yMax - this.yMin == 0.0) {
            this.yBasePxl -= this.sc(10.0f);
        }
        this.drawAxesTicksGridNumbers(this.steps);
        return this.steps;
    }

    public void redrawGrid() {
        if (this.ip != null) {
            this.ip.setColor(Color.black);
            this.drawAxesTicksGridNumbers(this.steps);
            this.ip.setColor(Color.black);
        }
    }

    void getInitialMinAndMax() {
        int axisRangeFlags = 0;
        if (Double.isNaN(this.defaultMinMax[0])) {
            axisRangeFlags |= 1;
        }
        if (Double.isNaN(this.defaultMinMax[2])) {
            axisRangeFlags |= 2;
        }
        if (axisRangeFlags != 0) {
            this.defaultMinMax = this.getMinAndMax(false, axisRangeFlags);
            this.enlargeRange(this.defaultMinMax);
        }
        this.setLimitsToDefaults(false);
    }

    double[] getMinAndMax(boolean allObjects, int axisRangeFlags) {
        String[] yCats;
        String[] xCats;
        boolean invertedXAxis = this.currentMinMax[1] < this.currentMinMax[0];
        boolean invertedYAxis = this.currentMinMax[3] < this.currentMinMax[2];
        double xSign = invertedXAxis ? -1.0 : 1.0;
        double ySign = invertedYAxis ? -1.0 : 1.0;
        double[] allMinMax = new double[]{xSign * Double.MAX_VALUE, -xSign * Double.MAX_VALUE, ySign * Double.MAX_VALUE, -ySign * Double.MAX_VALUE};
        for (int i = 0; i < allMinMax.length; ++i) {
            if ((axisRangeFlags >> i / 2 & 1) != 0) continue;
            allMinMax[i] = this.defaultMinMax[i];
        }
        this.enlargeRange = new int[allMinMax.length];
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 1 && plotObject.type != 2 || plotObject.hasFlag(8192)) continue;
            this.getMinAndMax(allMinMax, this.enlargeRange, plotObject, axisRangeFlags);
            if (allObjects) continue;
            break;
        }
        if ((axisRangeFlags & 1) != 0 && (xCats = this.labelsInBraces('x')) != null) {
            allMinMax[0] = Math.min(allMinMax[0], -0.5);
            allMinMax[1] = Math.min(allMinMax[1], (double)xCats.length + 0.5);
        }
        if ((axisRangeFlags & 2) != 0 && (yCats = this.labelsInBraces('y')) != null) {
            allMinMax[2] = Math.min(allMinMax[2], -0.5);
            allMinMax[3] = Math.min(allMinMax[3], (double)yCats.length + 0.5);
        }
        if (allMinMax[0] == Double.MAX_VALUE && allMinMax[1] == -1.7976931348623157E308) {
            allMinMax[0] = this.defaultMinMax[0];
            allMinMax[1] = this.defaultMinMax[1];
        }
        if (allMinMax[2] == Double.MAX_VALUE && allMinMax[3] == -1.7976931348623157E308) {
            allMinMax[2] = this.defaultMinMax[2];
            allMinMax[3] = this.defaultMinMax[3];
        }
        return allMinMax;
    }

    void fitRangeToLastPlotObject() {
        if (this.allPlotObjects.size() < 1) {
            return;
        }
        PlotObject plotObject = this.allPlotObjects.lastElement();
        if (Double.isNaN(this.currentMinMax[0]) || Double.isNaN(this.currentMinMax[2])) {
            this.setLimitsToFit(false);
        } else {
            this.enlargeRange = new int[this.currentMinMax.length];
            this.getMinAndMax(this.currentMinMax, this.enlargeRange, plotObject, 3);
            this.enlargeRange(this.currentMinMax);
        }
    }

    void getMinAndMax(double[] allMinAndMax, int[] enlargeRange, PlotObject plotObject, int axisRangeFlags) {
        boolean invertedYAxis;
        boolean invertedXAxis = this.currentMinMax[1] < this.currentMinMax[0];
        boolean bl = invertedYAxis = this.currentMinMax[3] < this.currentMinMax[2];
        if (plotObject.type == 1) {
            int suggestedEnlarge;
            if ((axisRangeFlags & 1) != 0) {
                suggestedEnlarge = 0;
                if (plotObject.shape != 2 && plotObject.shape != 10 || plotObject.yEValues != null) {
                    suggestedEnlarge = 2;
                }
                this.getMinAndMax(allMinAndMax, enlargeRange, suggestedEnlarge, 0, plotObject.xValues, plotObject.xEValues, invertedXAxis);
                if ((plotObject.shape == 11 || plotObject.shape == 12) && plotObject.xValues.length > 1) {
                    int n = plotObject.xValues.length;
                    allMinAndMax[0] = allMinAndMax[0] - 0.5 * (double)Math.abs(plotObject.xValues[1] - plotObject.xValues[0]);
                    allMinAndMax[1] = allMinAndMax[1] + 0.5 * (double)Math.abs(plotObject.xValues[n - 1] - plotObject.xValues[n - 2]);
                }
            }
            if ((axisRangeFlags & 2) != 0) {
                suggestedEnlarge = 0;
                if (plotObject.shape == 6 || plotObject.xEValues != null) {
                    suggestedEnlarge = 2;
                } else if (plotObject.shape != 2 && plotObject.shape != 10) {
                    suggestedEnlarge = 1;
                }
                this.getMinAndMax(allMinAndMax, enlargeRange, suggestedEnlarge, 2, plotObject.yValues, plotObject.yEValues, invertedYAxis);
                if ((plotObject.shape == 11 || plotObject.shape == 12) && allMinAndMax[2] > 0.0 && allMinAndMax[3] / allMinAndMax[2] >= 2.0 && !this.logYAxis) {
                    allMinAndMax[2] = 0.0;
                }
            }
        } else if (plotObject.type == 2) {
            if ((axisRangeFlags & 1) != 0) {
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 0, plotObject.xValues, null, invertedXAxis);
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 0, plotObject.xEValues, null, invertedXAxis);
            }
            if ((axisRangeFlags & 2) != 0) {
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 2, plotObject.yValues, null, invertedYAxis);
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 2, plotObject.yEValues, null, invertedYAxis);
            }
        }
    }

    void getMinAndMax(double[] allMinAndMax, int[] enlargeRange, int suggestedEnlarge, int axisIndex, float[] data, float[] errorBars, boolean invertedAxis) {
        int nMinEqual = 0;
        int nMaxEqual = 0;
        int minIndex = invertedAxis ? axisIndex + 1 : axisIndex;
        int maxIndex = invertedAxis ? axisIndex : axisIndex + 1;
        for (int i = 0; i < data.length; ++i) {
            double v1 = data[i];
            double v2 = data[i];
            if (errorBars != null && i < errorBars.length) {
                v1 -= (double)errorBars[i];
                v2 += (double)errorBars[i];
            }
            if (v1 < allMinAndMax[minIndex]) {
                allMinAndMax[minIndex] = v1;
                nMinEqual = 1;
                enlargeRange[minIndex] = suggestedEnlarge;
                if (suggestedEnlarge == 0 && (i > 0 && i < data.length - 1 || v2 != v1)) {
                    enlargeRange[minIndex] = 1;
                }
            } else if (v1 == allMinAndMax[minIndex]) {
                ++nMinEqual;
            }
            if (v2 > allMinAndMax[maxIndex]) {
                allMinAndMax[maxIndex] = v2;
                nMaxEqual = 1;
                enlargeRange[maxIndex] = suggestedEnlarge;
                if (suggestedEnlarge != 0 || (i <= 0 || i >= data.length - 1) && v2 == v1) continue;
                enlargeRange[maxIndex] = 1;
                continue;
            }
            if (v2 != allMinAndMax[maxIndex]) continue;
            ++nMaxEqual;
        }
        if (enlargeRange[minIndex] == 0 && nMinEqual > 2 && nMinEqual * 10 > data.length) {
            enlargeRange[minIndex] = 1;
        }
        if (enlargeRange[maxIndex] == 0 && nMaxEqual > 2 && nMaxEqual * 10 > data.length) {
            enlargeRange[maxIndex] = 1;
        }
        if (nMinEqual == data.length) {
            enlargeRange[minIndex] = 2;
        }
        if (nMaxEqual == data.length) {
            enlargeRange[maxIndex] = 2;
        }
        if (nMinEqual > 0 && enlargeRange[minIndex] < suggestedEnlarge) {
            enlargeRange[minIndex] = suggestedEnlarge;
        }
        if (nMaxEqual > 0 && enlargeRange[maxIndex] < suggestedEnlarge) {
            enlargeRange[maxIndex] = suggestedEnlarge;
        }
    }

    void saveMinMax() {
        if (!Arrays.equals(this.currentMinMax, this.savedMinMax)) {
            System.arraycopy(this.currentMinMax, 0, this.savedMinMax, 0, this.currentMinMax.length);
        }
    }

    void enlargeRange(double[] minMax) {
        if (this.enlargeRange == null) {
            return;
        }
        for (int a = 0; a < Math.min(minMax.length, this.enlargeRange.length); a += 2) {
            boolean logAxis;
            boolean bl = logAxis = a == 0 ? this.logXAxis : this.logYAxis;
            if (logAxis) {
                minMax[a] = Math.log10(minMax[a]);
                minMax[a + 1] = Math.log10(minMax[a + 1]);
            }
            double range = minMax[a + 1] - minMax[a];
            double tmpMin = minMax[a] - 0.015 * range;
            if (this.enlargeRange[a] == 1 && !logAxis) {
                minMax[a] = tmpMin * minMax[a] <= 0.0 ? 0.0 : tmpMin;
            } else if (this.enlargeRange[a] == 2) {
                minMax[a] = tmpMin;
            }
            double tmpMax = minMax[a + 1] + 0.015 * range;
            if (this.enlargeRange[a + 1] == 1 && !logAxis) {
                minMax[a + 1] = tmpMax * minMax[a + 1] <= 0.0 ? 0.0 : tmpMax;
            } else if (this.enlargeRange[a + 1] == 2) {
                minMax[a + 1] = tmpMax;
            }
            if (!logAxis) continue;
            minMax[a] = Math.pow(10.0, minMax[a]);
            minMax[a + 1] = Math.pow(10.0, minMax[a + 1]);
        }
    }

    Font nonNullFont(Font font1, Font font2) {
        if (font1 != null) {
            return font1;
        }
        if (font2 != null) {
            return font2;
        }
        return this.defaultFont;
    }

    void zoomToRect(Rectangle r) {
        this.saveMinMax();
        this.currentMinMax[0] = this.descaleX(r.x);
        this.currentMinMax[1] = this.descaleX(r.x + r.width);
        this.currentMinMax[2] = this.descaleY(r.y + r.height);
        this.currentMinMax[3] = this.descaleY(r.y);
        this.updateImage();
    }

    void zoomOnRangeArrow(int arrowIndex) {
        if (arrowIndex < 0) {
            return;
        }
        if (arrowIndex < 8) {
            boolean logAxis;
            int axisIndex = arrowIndex / 4 * 2;
            double min = axisIndex == 0 ? this.xMin : this.yMin;
            double max = axisIndex == 0 ? this.xMax : this.yMax;
            double range = max - min;
            boolean isMin = arrowIndex % 4 < 2;
            boolean shrinkRange = arrowIndex % 4 == 1 || arrowIndex % 4 == 2;
            double factor = Math.sqrt(2.0);
            if (shrinkRange) {
                factor = 1.0 / factor;
            }
            if (isMin) {
                min = max - range * factor;
            } else {
                max = min + range * factor;
            }
            boolean bl = logAxis = axisIndex == 0 ? this.logXAxis : this.logYAxis;
            if (logAxis) {
                min = Math.pow(10.0, min);
                max = Math.pow(10.0, max);
            }
            this.currentMinMax[axisIndex] = min;
            this.currentMinMax[axisIndex + 1] = max;
        } else if (arrowIndex == 8) {
            this.setLimitsToDefaults(false);
        } else if (arrowIndex == 9) {
            this.setLimitsToFit(false);
        } else if (arrowIndex <= 15) {
            int dialogType = arrowIndex;
            new PlotDialog(this, dialogType).showDialog(this.imp.getWindow());
        }
        if (arrowIndex <= 9) {
            this.updateImage();
        }
    }

    void zoom(int x, int y, double zoomFactor) {
        boolean insideY;
        boolean wasLogX = this.logXAxis;
        boolean wasLogY = this.logYAxis;
        double plotX = this.descaleX(x);
        double plotY = this.descaleY(y);
        IJ.showStatus("" + plotX);
        boolean insideX = x > this.frame.x && x < this.frame.x + this.frame.width;
        boolean bl = insideY = y > this.frame.y && y < this.frame.y + this.frame.height;
        if (!insideX && !insideY) {
            insideX = true;
            insideY = true;
            x = this.frame.x + this.frame.width / 2;
            y = this.frame.y + this.frame.height / 2;
        }
        int leftPart = x - this.frame.x;
        int rightPart = this.frame.x + this.frame.width - x;
        int highPart = y - this.frame.y;
        int lowPart = this.frame.y + this.frame.height - y;
        if (insideX) {
            this.currentMinMax[0] = this.descaleX((int)((double)x - (double)leftPart / zoomFactor));
            this.currentMinMax[1] = this.descaleX((int)((double)x + (double)rightPart / zoomFactor));
        }
        if (insideY) {
            this.currentMinMax[2] = this.descaleY((int)((double)y + (double)lowPart / zoomFactor));
            this.currentMinMax[3] = this.descaleY((int)((double)y - (double)highPart / zoomFactor));
        }
        this.updateImage();
        if (wasLogX != this.logXAxis) {
            int changedX = (int)this.scaleXtoPxl(plotX);
            int left = changedX - leftPart;
            int right = changedX + rightPart;
            this.currentMinMax[0] = this.descaleX(left);
            this.currentMinMax[1] = this.descaleX(right);
            this.updateImage();
        }
        if (wasLogY != this.logYAxis) {
            int changedY = (int)this.scaleYtoPxl(plotY);
            int bottom = changedY + lowPart;
            int top = changedY + highPart;
            this.currentMinMax[2] = this.descaleY(bottom);
            this.currentMinMax[3] = this.descaleY(top);
            this.updateImage();
        }
    }

    void scroll(int dx, int dy) {
        if (this.logXAxis) {
            this.currentMinMax[0] = this.currentMinMax[0] / Math.pow(10.0, (double)dx / this.xScale);
            this.currentMinMax[1] = this.currentMinMax[1] / Math.pow(10.0, (double)dx / this.xScale);
        } else {
            this.currentMinMax[0] = this.currentMinMax[0] - (double)dx / this.xScale;
            this.currentMinMax[1] = this.currentMinMax[1] - (double)dx / this.xScale;
        }
        if (this.logYAxis) {
            this.currentMinMax[2] = this.currentMinMax[2] * Math.pow(10.0, (double)dy / this.yScale);
            this.currentMinMax[3] = this.currentMinMax[3] * Math.pow(10.0, (double)dy / this.yScale);
        } else {
            this.currentMinMax[2] = this.currentMinMax[2] + (double)dy / this.yScale;
            this.currentMinMax[3] = this.currentMinMax[3] + (double)dy / this.yScale;
        }
        this.updateImage();
    }

    private boolean simpleXAxis() {
        return !this.hasFlag(4373);
    }

    private boolean simpleYAxis() {
        return !this.hasFlag(8746);
    }

    void drawAxesTicksGridNumbers(double[] steps) {
        if (this.ip == null) {
            return;
        }
        String[] xCats = this.labelsInBraces('x');
        String[] yCats = this.labelsInBraces('y');
        String multiplySymbol = this.getMultiplySymbol();
        Font scFont = this.scFont(this.pp.frame.getFont());
        Font scFontMedium = scFont.deriveFont(scFont.getSize2D() * 10.0f / 12.0f);
        Font scFontSmall = scFont.deriveFont(scFont.getSize2D() * 9.0f / 12.0f);
        this.ip.setFont(scFont);
        FontMetrics fm = this.ip.getFontMetrics();
        int fontAscent = fm.getAscent();
        this.ip.setJustification(0);
        int yOfXAxisNumbers = this.topMargin + this.frameHeight + fm.getHeight() * 5 / 4 + this.sc(2.0f);
        if (this.hasFlag(1 | (this.logXAxis ? 260 : 4096) + 16)) {
            Font baseFont = scFont;
            boolean majorTicks = this.logXAxis ? this.hasFlag(4096) : this.hasFlag(4);
            boolean minorTicks = this.hasFlag(256);
            minorTicks = minorTicks && xCats == null;
            double step = steps[0];
            int i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / step - 1.0E-10);
            int i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
            int suggestedDigits = (int)Tools.getNumberFromList(this.pp.frame.options, "xdecimals=");
            int digits = Plot.getDigits(this.xMin, this.xMax, step, 7, suggestedDigits);
            int y1 = this.topMargin;
            int y2 = this.topMargin + this.frameHeight;
            if (this.xMin == this.xMax) {
                if (this.hasFlag(1)) {
                    String s = IJ.d2s(this.xMin, Plot.getDigits(this.xMin, 0.001 * this.xMin, 5, suggestedDigits));
                    int y = this.yBasePxl;
                    this.ip.drawString(s, this.xBasePxl - this.ip.getStringWidth(s) / 2, yOfXAxisNumbers);
                }
            } else {
                boolean haveMinorLogNumbers;
                int w2;
                int w1;
                int wMax;
                if (this.hasFlag(1) && (double)(wMax = Math.max(w1 = this.ip.getStringWidth(IJ.d2s(this.currentMinMax[0], this.logXAxis ? -1 : digits)), w2 = this.ip.getStringWidth(IJ.d2s(this.currentMinMax[1], this.logXAxis ? -1 : digits)))) > Math.abs(step * this.xScale) - (double)this.sc(8.0f)) {
                    baseFont = scFontMedium;
                    this.ip.setFont(baseFont);
                }
                for (int i = 0; i <= i2 - i1; ++i) {
                    double v = (double)(i + i1) * step;
                    int x = (int)Math.round((v - this.xMin) * this.xScale) + this.leftMargin;
                    if (xCats != null) {
                        int index = (int)v;
                        double remainder = Math.abs(v - (double)Math.round(v));
                        if (index < 0 || index >= xCats.length || !(remainder < 1.0E-9)) continue;
                        String s = xCats[index];
                        String[] parts = s.split("\n");
                        int w = 0;
                        for (int jj = 0; jj < parts.length; ++jj) {
                            w = Math.max(w, this.ip.getStringWidth(parts[jj]));
                        }
                        this.ip.drawString(s, x - w / 2, yOfXAxisNumbers);
                        continue;
                    }
                    if (this.hasFlag(16)) {
                        this.ip.setColor(this.gridColor);
                        this.ip.drawLine(x, y1, x, y2);
                        this.ip.setColor(Color.black);
                    }
                    if (majorTicks) {
                        this.ip.drawLine(x, y1, x, y1 + this.sc(this.tickLength));
                        this.ip.drawLine(x, y2, x, y2 - this.sc(this.tickLength));
                    }
                    if (!this.hasFlag(1)) continue;
                    if (this.logXAxis || digits < 0) {
                        this.drawExpString(this.logXAxis ? Math.pow(10.0, v) : v, this.logXAxis ? -1 : -digits, x, yOfXAxisNumbers - fontAscent / 2, 1, fontAscent, baseFont, scFontSmall, multiplySymbol);
                        continue;
                    }
                    String s = IJ.d2s(v, digits);
                    this.ip.drawString(s, x - this.ip.getStringWidth(s) / 2, yOfXAxisNumbers);
                }
                boolean bl = haveMinorLogNumbers = i2 - i1 < 2;
                if (minorTicks && (!this.logXAxis || step > 1.1)) {
                    double mstep = this.niceNumber(step * 0.19);
                    double minorPerMajor = step / mstep;
                    if (Math.abs(minorPerMajor - (double)Math.round(minorPerMajor)) > 1.0E-10) {
                        mstep = step / 4.0;
                    }
                    if (this.logXAxis && mstep < 1.0) {
                        mstep = 1.0;
                    }
                    i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / mstep - 1.0E-10);
                    i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / mstep + 1.0E-10);
                    for (int i = i1; i <= i2; ++i) {
                        double v = (double)i * mstep;
                        int x = (int)Math.round((v - this.xMin) * this.xScale) + this.leftMargin;
                        this.ip.drawLine(x, y1, x, y1 + this.sc(this.minorTickLength));
                        this.ip.drawLine(x, y2, x, y2 - this.sc(this.minorTickLength));
                    }
                } else if (this.logXAxis && majorTicks && Math.abs(this.xScale) > (double)this.sc(45.0f)) {
                    int minorNumberLimit = haveMinorLogNumbers ? (int)(0.12 * Math.abs(this.xScale) / (double)(fm.charWidth('0') + this.sc(2.0f))) : 0;
                    i1 = (int)Math.floor(Math.min(this.xMin, this.xMax) - 1.0E-10);
                    i2 = (int)Math.ceil(Math.max(this.xMin, this.xMax) + 1.0E-10);
                    for (int i = i1; i <= i2; ++i) {
                        for (int m = 2; m < 10; ++m) {
                            double v = (double)i + Math.log10(m);
                            if (!(v > Math.min(this.xMin, this.xMax)) || !(v < Math.max(this.xMin, this.xMax))) continue;
                            int x = (int)Math.round((v - this.xMin) * this.xScale) + this.leftMargin;
                            this.ip.drawLine(x, y1, x, y1 + this.sc(this.minorTickLength));
                            this.ip.drawLine(x, y2, x, y2 - this.sc(this.minorTickLength));
                            if (m > minorNumberLimit) continue;
                            this.drawExpString(Math.pow(10.0, v), 0, x, yOfXAxisNumbers - fontAscent / 2, 1, fontAscent, baseFont, scFontSmall, multiplySymbol);
                        }
                    }
                }
            }
        }
        this.ip.setFont(scFont);
        int maxNumWidth = 0;
        int xNumberRight = this.leftMargin - this.sc(2.0f) - this.ip.getStringWidth("0") / 2;
        Rectangle rect = this.ip.getStringBounds("0169");
        int yNumberOffset = -rect.y - rect.height / 2;
        if (this.hasFlag(2 | (this.logYAxis ? 520 : 8192) + 32)) {
            this.ip.setJustification(2);
            Font baseFont = scFont;
            boolean majorTicks = this.logYAxis ? this.hasFlag(8192) : this.hasFlag(8);
            boolean minorTicks = this.logYAxis ? this.hasFlag(8192) : this.hasFlag(512);
            minorTicks = minorTicks && yCats == null;
            double step = steps[1];
            int i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / step - 1.0E-10);
            int i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
            int suggestedDigits = (int)Tools.getNumberFromList(this.pp.frame.options, "ydecimals=");
            int digits = Plot.getDigits(this.yMin, this.yMax, step, 5, suggestedDigits);
            int x1 = this.leftMargin;
            int x2 = this.leftMargin + this.frameWidth;
            if (this.yMin == this.yMax) {
                if (this.hasFlag(2)) {
                    String s = IJ.d2s(this.yMin, Plot.getDigits(this.yMin, 0.001 * this.yMin, 5, suggestedDigits));
                    maxNumWidth = this.ip.getStringWidth(s);
                    int y = this.yBasePxl;
                    this.ip.drawString(s, xNumberRight, y + fontAscent / 2 + this.sc(1.0f));
                }
            } else {
                boolean haveMinorLogNumbers;
                int digitsForWidth;
                int n = digitsForWidth = this.logYAxis ? -1 : digits;
                if (digitsForWidth < 0) {
                    --digitsForWidth;
                    xNumberRight += this.sc(1.0f) + this.ip.getStringWidth("0") / 4;
                }
                String str1 = IJ.d2s(this.currentMinMax[2], digitsForWidth);
                String str2 = IJ.d2s(this.currentMinMax[3], digitsForWidth);
                if (digitsForWidth < 0) {
                    str1 = str1.replaceFirst("E", multiplySymbol);
                    str2 = str2.replaceFirst("E", multiplySymbol);
                }
                int w1 = this.ip.getStringWidth(str1);
                int w2 = this.ip.getStringWidth(str2);
                int wMax = Math.max(w1, w2);
                if (this.hasFlag(2) && wMax > xNumberRight - this.sc(4.0f) - (this.pp.yLabel.label.length() > 0 ? fm.getHeight() : 0)) {
                    baseFont = scFontMedium;
                    this.ip.setFont(baseFont);
                }
                for (int i = i1; i <= i2; ++i) {
                    double v = step == 0.0 ? this.yMin : (double)i * step;
                    int y = this.topMargin + this.frameHeight - (int)Math.round((v - this.yMin) * this.yScale);
                    if (yCats != null) {
                        int index = (int)v;
                        double remainder = Math.abs(v - (double)Math.round(v));
                        if (index < 0 || index >= yCats.length || !(remainder < 1.0E-9)) continue;
                        String s = yCats[index];
                        int multiLineOffset = 0;
                        for (int jj = 0; jj < s.length(); ++jj) {
                            if (s.charAt(jj) != '\n') continue;
                            multiLineOffset -= rect.height / 2;
                        }
                        this.ip.drawString(s, xNumberRight, y + yNumberOffset + multiLineOffset);
                        continue;
                    }
                    if (this.hasFlag(32)) {
                        this.ip.setColor(this.gridColor);
                        this.ip.drawLine(x1, y, x2, y);
                        this.ip.setColor(Color.black);
                    }
                    if (majorTicks) {
                        this.ip.drawLine(x1, y, x1 + this.sc(this.tickLength), y);
                        this.ip.drawLine(x2, y, x2 - this.sc(this.tickLength), y);
                    }
                    if (!this.hasFlag(2)) continue;
                    int w = 0;
                    if (this.logYAxis || digits < 0) {
                        w = this.drawExpString(this.logYAxis ? Math.pow(10.0, v) : v, this.logYAxis ? -1 : -digits, xNumberRight, y, 2, fontAscent, baseFont, scFontSmall, multiplySymbol);
                    } else {
                        String s = IJ.d2s(v, digits);
                        w = this.ip.getStringWidth(s);
                        this.ip.drawString(s, xNumberRight, y + yNumberOffset);
                    }
                    if (w <= maxNumWidth) continue;
                    maxNumWidth = w;
                }
                boolean bl = haveMinorLogNumbers = i2 - i1 < 2;
                if (minorTicks && (!this.logYAxis || step > 1.1)) {
                    double mstep = this.niceNumber(step * 0.19);
                    double minorPerMajor = step / mstep;
                    if (Math.abs(minorPerMajor - (double)Math.round(minorPerMajor)) > 1.0E-10) {
                        mstep = step / 4.0;
                    }
                    if (this.logYAxis && step < 1.0) {
                        mstep = 1.0;
                    }
                    i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / mstep - 1.0E-10);
                    i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / mstep + 1.0E-10);
                    for (int i = i1; i <= i2; ++i) {
                        double v = (double)i * mstep;
                        int y = this.topMargin + this.frameHeight - (int)Math.round((v - this.yMin) * this.yScale);
                        this.ip.drawLine(x1, y, x1 + this.sc(this.minorTickLength), y);
                        this.ip.drawLine(x2, y, x2 - this.sc(this.minorTickLength), y);
                    }
                }
                if (this.logYAxis && majorTicks && Math.abs(this.yScale) > (double)this.sc(45.0f)) {
                    int minorNumberLimit = haveMinorLogNumbers ? (int)(0.4 * Math.abs(this.yScale) / (double)fm.getHeight()) : 0;
                    i1 = (int)Math.floor(Math.min(this.yMin, this.yMax) - 1.0E-10);
                    i2 = (int)Math.ceil(Math.max(this.yMin, this.yMax) + 1.0E-10);
                    for (int i = i1; i <= i2; ++i) {
                        for (int m = 2; m < 10; ++m) {
                            int w;
                            double v = (double)i + Math.log10(m);
                            if (!(v > Math.min(this.yMin, this.yMax)) || !(v < Math.max(this.yMin, this.yMax))) continue;
                            int y = this.topMargin + this.frameHeight - (int)Math.round((v - this.yMin) * this.yScale);
                            this.ip.drawLine(x1, y, x1 + this.sc(this.minorTickLength), y);
                            this.ip.drawLine(x2, y, x2 - this.sc(this.minorTickLength), y);
                            if (m > minorNumberLimit || (w = this.drawExpString(Math.pow(10.0, v), 0, xNumberRight, y, 2, fontAscent, baseFont, scFontSmall, multiplySymbol)) <= maxNumWidth) continue;
                            maxNumWidth = w;
                        }
                    }
                }
            }
        }
        this.ip.setFont(scFont);
        this.ip.setJustification(0);
        String xLabelToDraw = this.pp.xLabel.label;
        String yLabelToDraw = this.pp.yLabel.label;
        if (this.simpleYAxis()) {
            int digits = Plot.getDigits(this.yMin, this.yMax, 0.001 * (this.yMax - this.yMin), 6, 0);
            String s = IJ.d2s(this.yMax, digits);
            int sw = this.ip.getStringWidth(s);
            if (sw + this.sc(4.0f) > this.leftMargin) {
                this.ip.drawString(s, this.sc(4.0f), this.topMargin - this.sc(4.0f));
            } else {
                this.ip.drawString(s, this.leftMargin - this.ip.getStringWidth(s) - this.sc(4.0f), this.topMargin + 10);
            }
            s = IJ.d2s(this.yMin, digits);
            sw = this.ip.getStringWidth(s);
            if (sw + 4 > this.leftMargin) {
                this.ip.drawString(s, this.sc(4.0f), this.topMargin + this.frame.height);
            } else {
                this.ip.drawString(s, this.leftMargin - this.ip.getStringWidth(s) - this.sc(4.0f), this.topMargin + this.frame.height);
            }
            if (this.logYAxis) {
                yLabelToDraw = yLabelToDraw + " (LOG)";
            }
        }
        int y = yOfXAxisNumbers;
        if (this.simpleXAxis()) {
            int digits = Plot.getDigits(this.xMin, this.xMax, 0.001 * (this.xMax - this.xMin), 7, 0);
            this.ip.drawString(IJ.d2s(this.xMin, digits), this.leftMargin, y);
            String s = IJ.d2s(this.xMax, digits);
            this.ip.drawString(s, this.leftMargin + this.frame.width - this.ip.getStringWidth(s) + 6, y);
            y -= fm.getHeight();
            if (this.logXAxis) {
                xLabelToDraw = xLabelToDraw + " (LOG)";
            }
        } else {
            y += this.sc(1.0f);
        }
        if (xCats == null) {
            this.ip.setFont(this.pp.xLabel.getFont() == null ? scFont : this.scFont(this.pp.xLabel.getFont()));
            ByteProcessor xLabel = this.stringToPixels(xLabelToDraw);
            if (xLabel != null) {
                int xpos = this.leftMargin + (this.frame.width - xLabel.getWidth()) / 2;
                int ypos = y + scFont.getSize() / 3;
                this.ip.insert(xLabel, xpos, ypos);
            }
        }
        if (yCats == null) {
            this.ip.setFont(this.pp.yLabel.getFont() == null ? scFont : this.scFont(this.pp.yLabel.getFont()));
            ImageProcessor yLabel = this.stringToPixels(yLabelToDraw);
            if (yLabel != null) {
                yLabel = yLabel.rotateLeft();
                int xRightOfYLabel = xNumberRight - maxNumWidth - this.sc(2.0f);
                int xpos = xRightOfYLabel - yLabel.getWidth() - this.sc(2.0f);
                int ypos = this.topMargin + (this.frame.height - yLabel.getHeight()) / 2;
                this.ip.insert(yLabel, xpos, ypos);
            }
        }
    }

    String[] labelsInBraces(char labelCode) {
        String s = this.getLabel(labelCode);
        if (s.startsWith("{") && s.endsWith("}")) {
            String inBraces = s.substring(1, s.length() - 1);
            String[] catLabels = inBraces.split(",");
            return catLabels;
        }
        return null;
    }

    double niceNumber(double v) {
        double base = Math.pow(10.0, Math.floor(Math.log10(v) - 1.0E-6));
        if (v > 5.0000001 * base) {
            return 10.0 * base;
        }
        if (v > 2.0000001 * base) {
            return 5.0 * base;
        }
        return 2.0 * base;
    }

    int drawExpString(double value, int digits, int x, int y, int justification, int fontAscent, Font baseFont, Font smallFont, String multiplySymbol) {
        int ePos;
        String base = "10";
        String exponent = null;
        String s = IJ.d2s(value, digits <= 0 ? -1 : -digits);
        if (Tools.parseDouble(s) == 0.0) {
            s = "0";
        }
        if ((ePos = s.indexOf(69)) < 0) {
            base = s;
        } else {
            if (digits >= 0) {
                base = s.substring(0, ePos);
                if (digits == 0) {
                    base = Integer.toString((int)Math.round(Tools.parseDouble(base)));
                }
                base = base + multiplySymbol + "10";
            }
            exponent = s.substring(ePos + 1);
        }
        this.ip.setJustification(2);
        int width = this.ip.getStringWidth(base);
        if (exponent != null) {
            this.ip.setFont(smallFont);
            int wExponent = this.ip.getStringWidth(exponent);
            width += wExponent;
            if (justification == 1) {
                x += width / 2;
            }
            this.ip.drawString(exponent, x, y + fontAscent * 3 / 10);
            x -= wExponent;
            this.ip.setFont(baseFont);
        }
        this.ip.drawString(base, x, y + fontAscent * 7 / 10);
        return width;
    }

    String getMultiplySymbol() {
        String multiplySymbol = Tools.getStringFromList(this.pp.frame.options, "msymbol=");
        if (multiplySymbol == null) {
            multiplySymbol = Tools.getStringFromList(this.pp.frame.options, "multiplysymbol=");
        }
        return multiplySymbol != null ? multiplySymbol : MULTIPLY_SYMBOL;
    }

    ByteProcessor stringToPixels(String labelStr) {
        Font bigFont = this.ip.getFont();
        Rectangle rect = this.ip.getStringBounds(labelStr);
        int ww = rect.width * 2;
        int hh = rect.height * 3;
        int y0 = rect.height * 2;
        if (ww <= 0 || hh <= 0) {
            return null;
        }
        ByteProcessor box = new ByteProcessor(ww, hh);
        box.setColor(Color.WHITE);
        box.fill();
        box.setColor(Color.black);
        box.setAntialiasedText(this.pp.antialiasedText);
        if (this.invertedLut) {
            box.invertLut();
        }
        box.setFont(bigFont);
        FontMetrics fm = box.getFontMetrics();
        int ascent = fm.getAscent();
        int offSub = ascent / 6;
        int offSuper = -ascent / 2;
        Font smallFont = bigFont.deriveFont((float)((double)bigFont.getSize() * 0.7));
        Rectangle bigBounds = box.getStringBounds(labelStr);
        boolean doParse = labelStr.indexOf("^^") >= 0 || labelStr.indexOf("!!") >= 0;
        boolean bl = doParse = doParse && labelStr.indexOf("^^^") < 0 && labelStr.indexOf("!!!") < 0;
        if (!doParse) {
            box.drawString(labelStr, 0, y0);
            Rectangle cropRect = new Rectangle(bigBounds);
            cropRect.y += y0;
            box.setRoi(cropRect);
            ImageProcessor boxI = box.crop();
            box = boxI.convertToByteProcessor();
            return box;
        }
        if (labelStr.endsWith("^^") || labelStr.endsWith("!!")) {
            labelStr = labelStr.substring(0, labelStr.length() - 2);
        }
        if (labelStr.startsWith("^^") || labelStr.startsWith("!!")) {
            labelStr = " " + labelStr;
        }
        box.setFont(smallFont);
        Rectangle smallBounds = box.getStringBounds(labelStr);
        box.setFont(bigFont);
        int upperBound = y0 + smallBounds.y + offSuper;
        int lowerBound = y0 + smallBounds.y + smallBounds.height + offSub;
        int h = fm.getHeight();
        int len = labelStr.length();
        int[] tags = new int[len];
        int nTags = 0;
        for (int jj = 0; jj < len - 2; ++jj) {
            if (labelStr.substring(jj, jj + 2).equals("^^")) {
                tags[nTags++] = jj;
            }
            if (!labelStr.substring(jj, jj + 2).equals("!!")) continue;
            tags[nTags++] = -jj;
        }
        tags[nTags++] = len;
        tags = Arrays.copyOf(tags, nTags);
        int leftIndex = 0;
        int xRight = 0;
        int y2 = y0;
        boolean subscript = labelStr.startsWith("!!");
        for (int pp = 0; pp < tags.length; ++pp) {
            boolean small;
            int rightIndex = tags[pp];
            rightIndex = Math.abs(rightIndex);
            String part = labelStr.substring(leftIndex, rightIndex);
            boolean bl2 = small = pp % 2 == 1;
            if (small) {
                box.setFont(smallFont);
                y2 = subscript ? y0 + offSub : y0 + offSuper;
            } else {
                box.setFont(bigFont);
                y2 = y0;
            }
            int partWidth = box.getStringWidth(part);
            box.drawString(part, ++xRight, y2);
            leftIndex = rightIndex + 2;
            subscript = tags[pp] < 0;
            xRight += partWidth;
        }
        Rectangle cropRect = new Rectangle(0, upperBound, xRight += h / 4, lowerBound - upperBound);
        box.setRoi(cropRect);
        ImageProcessor boxI = box.crop();
        box = boxI.convertToByteProcessor();
        return box;
    }

    static int getDigits(double n, double resolution, int maxDigits, int suggestedDigits) {
        if (n == (double)Math.round(n) && Math.abs(n) < Math.pow(10.0, maxDigits - 1) - 1.0) {
            return suggestedDigits;
        }
        return Plot.getDigits2(n, resolution, maxDigits, suggestedDigits);
    }

    static int getDigits(double n1, double n2, double resolution, int maxDigits, int suggestedDigits) {
        if (n1 == 0.0 && n2 == 0.0) {
            return suggestedDigits;
        }
        return Plot.getDigits2(Math.max(Math.abs(n1), Math.abs(n2)), resolution, maxDigits, suggestedDigits);
    }

    static int getDigits2(double n, double resolution, int maxDigits, int suggestedDigits) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return 0;
        }
        int log10ofN = (int)Math.floor(Math.log10(Math.abs(n)) + 1.0E-7);
        int digits = resolution != 0.0 ? -((int)Math.floor(Math.log10(Math.abs(resolution)) + 1.0E-7)) : Math.max(0, -log10ofN + maxDigits - 2);
        int sciDigits = -Math.max(log10ofN + digits, 1);
        if (digits < -2 && log10ofN >= maxDigits || suggestedDigits < 0) {
            digits = sciDigits;
        } else if (digits < 0) {
            digits = 0;
        } else if (digits > maxDigits - 1 && log10ofN < -2) {
            digits = sciDigits;
        }
        return digits < 0 ? Math.min(sciDigits, suggestedDigits) : Math.max(digits, suggestedDigits);
    }

    static boolean isInteger(double n) {
        return n == (double)Math.round(n);
    }

    private void drawPlotObject(PlotObject plotObject, ImageProcessor ip) {
        if (plotObject.hasFlag(8192)) {
            return;
        }
        ip.setColor(plotObject.color);
        ip.setLineWidth(this.sc(plotObject.lineWidth));
        int type = plotObject.type;
        switch (type) {
            case 1: {
                int markSize;
                ip.setClipRect(this.frame);
                int nPoints = Math.min(plotObject.xValues.length, plotObject.yValues.length);
                if (plotObject.shape == 11 || plotObject.shape == 12) {
                    this.drawBarChart(plotObject);
                }
                if (plotObject.shape == 10) {
                    ip.setColor(plotObject.color2 != null ? plotObject.color2 : plotObject.color);
                    this.drawFloatPolyLineFilled(ip, plotObject.xValues, plotObject.yValues, nPoints);
                }
                ip.setColor(plotObject.color);
                ip.setLineWidth(this.sc(plotObject.lineWidth));
                if (plotObject.yEValues != null) {
                    this.drawVerticalErrorBars(plotObject.xValues, plotObject.yValues, plotObject.yEValues);
                }
                if (plotObject.xEValues != null) {
                    this.drawHorizontalErrorBars(plotObject.xValues, plotObject.yValues, plotObject.xEValues);
                }
                if (plotObject.hasFilledMarker()) {
                    markSize = plotObject.getMarkerSize();
                    ip.setColor(plotObject.color2);
                    ip.setLineWidth(1);
                    for (int i = 0; i < nPoints; ++i) {
                        if (this.logXAxis && !(plotObject.xValues[i] > 0.0f) || this.logYAxis && !(plotObject.yValues[i] > 0.0f) || Double.isNaN(plotObject.xValues[i]) || Double.isNaN(plotObject.yValues[i])) continue;
                        this.fillShape(plotObject.shape, this.scaleX(plotObject.xValues[i]), this.scaleY(plotObject.yValues[i]), markSize);
                    }
                    ip.setColor(plotObject.color);
                    ip.setLineWidth(this.sc(plotObject.lineWidth));
                }
                if (plotObject.hasCurve()) {
                    if (plotObject.shape == 7) {
                        ip.setColor(plotObject.color2 == null ? Color.black : plotObject.color2);
                    }
                    this.drawFloatPolyline(ip, plotObject.xValues, plotObject.yValues, nPoints);
                    ip.setColor(plotObject.color);
                }
                if (plotObject.hasMarker()) {
                    markSize = plotObject.getMarkerSize();
                    ip.setColor(plotObject.color);
                    Font saveFont = ip.getFont();
                    for (int i = 0; i < Math.min(plotObject.xValues.length, plotObject.yValues.length); ++i) {
                        if (this.logXAxis && !(plotObject.xValues[i] > 0.0f) || this.logYAxis && !(plotObject.yValues[i] > 0.0f) || Double.isNaN(plotObject.xValues[i]) || Double.isNaN(plotObject.yValues[i])) continue;
                        this.drawShape(plotObject, this.scaleX(plotObject.xValues[i]), this.scaleY(plotObject.yValues[i]), plotObject.shape, markSize, i);
                    }
                    if (plotObject.shape == 9) {
                        ip.setFont(saveFont);
                    }
                }
                ip.setClipRect(null);
                break;
            }
            case 2: {
                ip.setClipRect(this.frame);
                for (int i = 0; i < plotObject.xValues.length; ++i) {
                    int xt1 = this.scaleX(plotObject.xValues[i]);
                    int yt1 = this.scaleY(plotObject.yValues[i]);
                    int xt2 = this.scaleX(plotObject.xEValues[i]);
                    int yt2 = this.scaleY(plotObject.yEValues[i]);
                    double dist = Plot.calculateDistance(xt1, yt1, xt2, yt2);
                    if (xt1 == xt2 && yt1 == yt2) {
                        ip.drawDot(xt1, yt1);
                        continue;
                    }
                    if (dist < (double)this.sc(4.5f)) {
                        ip.drawLine(xt1, yt1, xt2, yt2);
                        continue;
                    }
                    int arrowHeadLength = (int)(dist * 0.2 + 0.5);
                    if (arrowHeadLength > this.sc(20.0f)) {
                        arrowHeadLength = this.sc(20.0f);
                    }
                    if (arrowHeadLength < this.sc(3.0f)) {
                        arrowHeadLength = this.sc(3.0f);
                    }
                    this.drawArrow(xt1, yt1, xt2, yt2, arrowHeadLength);
                }
                ip.setClipRect(null);
                break;
            }
            case 1024: {
                int iBoxWidth = 20;
                ip.setClipRect(this.frame);
                String shType = plotObject.shapeType.toLowerCase();
                if (shType.contains("rectangles")) {
                    int nShapes = plotObject.shapeData.size();
                    for (int i = 0; i < nShapes; ++i) {
                        float[] corners = (float[])plotObject.shapeData.get(i);
                        int x1 = this.scaleX(corners[0]);
                        int y1 = this.scaleY(corners[1]);
                        int x2 = this.scaleX(corners[2]);
                        int y2 = this.scaleY(corners[3]);
                        ip.setLineWidth(this.sc(plotObject.lineWidth));
                        int left = Math.min(x1, x2);
                        int right = Math.max(x1, x2);
                        int top = Math.min(y1, y2);
                        int bottom = Math.max(y1, y2);
                        Rectangle r1 = new Rectangle(left, top, right - left, bottom - top);
                        Rectangle cBox = this.frame.intersection(r1);
                        if (plotObject.color2 != null) {
                            ip.setColor(plotObject.color2);
                            ip.fillRect(cBox.x, cBox.y, cBox.width, cBox.height);
                        }
                        ip.setColor(plotObject.color);
                        ip.drawRect(cBox.x, cBox.y, cBox.width, cBox.height);
                    }
                    ip.setClipRect(null);
                    break;
                }
                if (shType.equals("redraw_grid")) {
                    ip.setLineWidth(this.sc(1.0f));
                    this.redrawGrid();
                    ip.setClipRect(null);
                    break;
                }
                if (shType.contains("boxes")) {
                    String[] parts = Tools.split(shType);
                    for (int jj = 0; jj < parts.length; ++jj) {
                        String[] pairs = parts[jj].split("=");
                        if (pairs.length != 2 || !pairs[0].equals("width")) continue;
                        iBoxWidth = Integer.parseInt(pairs[1]);
                    }
                    boolean horizontal = shType.contains("boxesx");
                    int nShapes = plotObject.shapeData.size();
                    int halfWidth = Math.round(this.sc(iBoxWidth / 2));
                    for (int i = 0; i < nShapes; ++i) {
                        Rectangle cBox;
                        Rectangle r1;
                        float[] coords = (float[])plotObject.shapeData.get(i);
                        if (!horizontal) {
                            int x = this.scaleX(coords[0]);
                            int y1 = this.scaleY(coords[1]);
                            int y2 = this.scaleY(coords[2]);
                            int y3 = this.scaleY(coords[3]);
                            int y4 = this.scaleY(coords[4]);
                            int y5 = this.scaleY(coords[5]);
                            ip.setLineWidth(this.sc(plotObject.lineWidth));
                            r1 = new Rectangle(x - halfWidth, y4, halfWidth * 2, y2 - y4);
                            cBox = this.frame.intersection(r1);
                            if (y1 != y2 || y4 != y5) {
                                ip.drawLine(x, y1, x, y5);
                            }
                            if (plotObject.color2 != null) {
                                ip.setColor(plotObject.color2);
                                ip.fillRect(cBox.x, cBox.y, cBox.width, cBox.height);
                            }
                            ip.setColor(plotObject.color);
                            ip.drawRect(cBox.x, cBox.y, cBox.width, cBox.height);
                            ip.setClipRect(this.frame);
                            ip.drawLine(x - halfWidth, y3, x + halfWidth - 1, y3);
                        }
                        if (!horizontal) continue;
                        int y = this.scaleY(coords[0]);
                        int x1 = this.scaleX(coords[1]);
                        int x2 = this.scaleX(coords[2]);
                        int x3 = this.scaleX(coords[3]);
                        int x4 = this.scaleX(coords[4]);
                        int x5 = this.scaleX(coords[5]);
                        ip.setLineWidth(this.sc(plotObject.lineWidth));
                        if (x1 != x2 || x4 != x5) {
                            ip.drawLine(x1, y, x5, y);
                        }
                        r1 = new Rectangle(x2, y - halfWidth, x4 - x2, halfWidth * 2);
                        cBox = this.frame.intersection(r1);
                        if (plotObject.color2 != null) {
                            ip.setColor(plotObject.color2);
                            ip.fillRect(cBox.x, cBox.y, cBox.width, cBox.height);
                        }
                        ip.setColor(plotObject.color);
                        ip.drawRect(cBox.x, cBox.y, cBox.width, cBox.height);
                        ip.setClipRect(this.frame);
                        ip.drawLine(x3, y - halfWidth, x3, y + halfWidth - 1);
                    }
                    ip.setClipRect(null);
                    break;
                }
            }
            case 4: {
                if (Double.isNaN(plotObject.x) || Double.isNaN(plotObject.y)) break;
                ip.setClipRect(this.frame);
                ip.drawLine(this.scaleX(plotObject.x), this.scaleY(plotObject.y), this.scaleX(plotObject.xEnd), this.scaleY(plotObject.yEnd));
                ip.setClipRect(null);
                break;
            }
            case 8: {
                ip.setClipRect(this.frame);
                int ix1 = this.leftMargin + (int)(plotObject.x * (double)this.frameWidth);
                int iy1 = this.topMargin + (int)(plotObject.y * (double)this.frameHeight);
                int ix2 = this.leftMargin + (int)(plotObject.xEnd * (double)this.frameWidth);
                int iy2 = this.topMargin + (int)(plotObject.yEnd * (double)this.frameHeight);
                ip.drawLine(ix1, iy1, ix2, iy2);
                ip.setClipRect(null);
                break;
            }
            case 16: {
                ip.setClipRect(this.frame);
                int ix1 = this.scaleX(plotObject.x);
                int iy1 = this.scaleY(plotObject.y);
                int ix2 = this.scaleX(plotObject.xEnd);
                int iy2 = this.scaleY(plotObject.yEnd);
                double length = Plot.calculateDistance(ix1, ix2, iy1, iy2) + 0.1;
                int n = (int)(length / (double)plotObject.step);
                for (int i = 0; i <= n; ++i) {
                    ip.drawDot(ix1 + (int)Math.round((double)(ix2 - ix1) * (double)i / (double)n), iy1 + (int)Math.round((double)(iy2 - iy1) * (double)i / (double)n));
                }
                ip.setClipRect(null);
                break;
            }
            case 32: 
            case 64: {
                ip.setJustification(plotObject.justification);
                if (plotObject.getFont() != null) {
                    ip.setFont(this.scFont(plotObject.getFont()));
                }
                int xt = type == 32 ? this.scaleX(plotObject.x) : this.leftMargin + (int)(plotObject.x * (double)this.frameWidth);
                int yt = type == 32 ? this.scaleY(plotObject.y) : this.topMargin + (int)(plotObject.y * (double)this.frameHeight);
                ip.drawString(plotObject.label, xt, yt);
                break;
            }
            case 128: {
                this.drawLegend(plotObject, ip);
            }
        }
    }

    void drawBarChart(PlotObject plotObject) {
        int halfBarWidthInPixels;
        int n = Math.min(plotObject.xValues.length, plotObject.yValues.length);
        String[] xCats = this.labelsInBraces('x');
        boolean separatedBars = plotObject.shape == 12 || xCats != null;
        int n2 = halfBarWidthInPixels = n <= 1 ? Math.max(1, this.frameWidth / 2 - 2) : 0;
        if (separatedBars && n > 1) {
            halfBarWidthInPixels = Math.max(1, (int)Math.round(Math.abs(0.5 * (double)(plotObject.xValues[n - 1] - plotObject.xValues[0]) / (double)(n - 1) * this.xScale * SEPARATED_BAR_WIDTH)));
        }
        int y0 = this.scaleYWithOverflow(0.0);
        boolean yZeroInFrame = !this.logYAxis && this.yBasePxl > this.frame.y && this.yBasePxl < this.frame.y + this.frame.height;
        int prevY = y0;
        for (int i = 0; i < n; ++i) {
            int left = 0;
            int right = 0;
            if (halfBarWidthInPixels == 0) {
                left = this.scaleX(i > 0 ? (double)(0.5f * (plotObject.xValues[i - 1] + plotObject.xValues[i])) : (double)(1.5f * plotObject.xValues[i] - 0.5f * plotObject.xValues[i + 1]));
                right = this.scaleX(i < n - 1 ? (double)(0.5f * (plotObject.xValues[i] + plotObject.xValues[i + 1])) : (double)(1.5f * plotObject.xValues[i] - 0.5f * plotObject.xValues[i - 1]));
            } else {
                int x = this.scaleX(plotObject.xValues[i]);
                left = x - halfBarWidthInPixels;
                right = x + halfBarWidthInPixels;
            }
            if (left < this.frame.x) {
                left = this.frame.x;
            }
            if (left > this.frame.x + this.frame.width) {
                left = this.frame.x + this.frame.width;
            }
            if (right < this.frame.x) {
                right = this.frame.x;
            }
            if (right > this.frame.x + this.frame.width) {
                right = this.frame.x + this.frame.width;
            }
            int y = this.scaleYWithOverflow(plotObject.yValues[i]);
            if (plotObject.color2 != null) {
                this.ip.setColor(plotObject.color2);
                for (int x2 = Math.min(left, right); x2 <= Math.max(left, right); ++x2) {
                    this.ip.drawLine(x2, y0, x2, y);
                }
            }
            this.ip.setColor(plotObject.color);
            this.ip.setLineWidth(this.sc(plotObject.lineWidth));
            if (separatedBars) {
                this.ip.drawLine(left, y0, left, y);
                this.ip.drawLine(left, y, right, y);
                this.ip.drawLine(right, y, right, y0);
                if (!yZeroInFrame) continue;
                this.ip.drawLine(left, y0, right, y0);
                continue;
            }
            this.ip.drawLine(left, prevY, left, y);
            this.ip.drawLine(left, y, right, y);
            if (i == n - 1) {
                this.ip.drawLine(right, y, right, y0);
            }
            prevY = y;
        }
    }

    void drawShape(PlotObject plotObject, int x, int y, int shape, int size, int pointIndex) {
        if (shape == 8) {
            size = (int)((double)size * 1.21);
        }
        int xbase = x - this.sc(size / 2);
        int ybase = y - this.sc(size / 2);
        int xend = x + this.sc(size / 2);
        int yend = y + this.sc(size / 2);
        if (this.ip == null) {
            return;
        }
        switch (shape) {
            case 1: {
                this.ip.drawLine(xbase, ybase, xend, yend);
                this.ip.drawLine(xend, ybase, xbase, yend);
                break;
            }
            case 3: {
                this.ip.drawLine(xbase, ybase, xend, ybase);
                this.ip.drawLine(xend, ybase, xend, yend);
                this.ip.drawLine(xend, yend, xbase, yend);
                this.ip.drawLine(xbase, yend, xbase, ybase);
                break;
            }
            case 4: {
                this.ip.drawLine(x, ybase - this.sc(1.0f), xend + this.sc(1.0f), yend);
                this.ip.drawLine(x, ybase - this.sc(1.0f), xbase - this.sc(1.0f), yend);
                this.ip.drawLine(xend + this.sc(1.0f), yend, xbase - this.sc(1.0f), yend);
                break;
            }
            case 5: {
                this.ip.drawLine(xbase, y, xend, y);
                this.ip.drawLine(x, ybase, x, yend);
                break;
            }
            case 8: {
                this.ip.drawLine(xbase, y, x, ybase);
                this.ip.drawLine(x, ybase, xend, y);
                this.ip.drawLine(xend, y, x, yend);
                this.ip.drawLine(x, yend, xbase, y);
                break;
            }
            case 6: {
                this.ip.drawDot(x, y);
                break;
            }
            case 9: {
                String rtn;
                if (plotObject.macroCode == null || this.frame == null || x < this.frame.x || y < this.frame.y || x >= this.frame.x + this.frame.width || y >= this.frame.y + this.frame.height) break;
                ImagePlus imp = new ImagePlus("", this.ip);
                WindowManager.setTempCurrentImage(imp);
                StringBuilder sb = new StringBuilder(140 + plotObject.macroCode.length());
                sb.append("x=");
                sb.append(x);
                sb.append(";y=");
                sb.append(y);
                sb.append(";setColor('");
                sb.append(Tools.c2hex(plotObject.color));
                sb.append("');s=");
                sb.append(this.sc(1.0f));
                boolean drawingLegend = pointIndex < 0;
                double xVal = 0.0;
                double yVal = 0.0;
                if (!drawingLegend) {
                    xVal = plotObject.xValues[pointIndex];
                    yVal = plotObject.yValues[pointIndex];
                }
                sb.append(";i=");
                sb.append(drawingLegend ? 0 : pointIndex);
                sb.append(";xval=" + xVal);
                sb.append(";yval=" + yVal);
                sb.append(";");
                sb.append(plotObject.macroCode);
                if (!(drawingLegend && sb.toString().contains("d2s") || !"[aborted]".equals(rtn = IJ.runMacro(sb.toString())))) {
                    plotObject.macroCode = null;
                }
                WindowManager.setTempCurrentImage(null);
                break;
            }
            default: {
                if ((double)this.sc(size) < 5.01) {
                    this.ip.drawLine(x - 1, y - 2, x + 1, y - 2);
                    this.ip.drawLine(x - 1, y + 2, x + 1, y + 2);
                    this.ip.drawLine(x + 2, y + 1, x + 2, y - 1);
                    this.ip.drawLine(x - 2, y + 1, x - 2, y - 1);
                    break;
                }
                int r = this.sc(0.5f * (float)size - 0.5f);
                this.ip.drawOval(x - r, y - r, 2 * r, 2 * r);
            }
        }
    }

    void fillShape(int shape, int x0, int y0, int size) {
        if (shape == 8) {
            size = (int)((double)size * 1.21);
        }
        int r = this.sc(size / 2) - 1;
        switch (shape) {
            case 3: {
                for (int dy = -r; dy <= r; ++dy) {
                    for (int dx = -r; dx <= r; ++dx) {
                        this.ip.drawDot(x0 + dx, y0 + dy);
                    }
                }
                break;
            }
            case 4: {
                int ybase = y0 - r - this.sc(1.0f);
                int yend = y0 + r;
                double halfWidth = this.sc(size / 2) + this.sc(1.0f) - 1;
                double hwStep = halfWidth / (double)(yend - ybase + 1);
                int y = yend;
                while (y >= ybase) {
                    int dx = (int)Math.round(halfWidth);
                    for (int x = x0 - dx; x <= x0 + dx; ++x) {
                        this.ip.drawDot(x, y);
                    }
                    --y;
                    halfWidth -= hwStep;
                }
                break;
            }
            case 8: {
                int ybase = y0 - r - this.sc(1.0f);
                int yend = y0 + r;
                double halfWidth = this.sc(size / 2) + this.sc(1.0f) - 1;
                double hwStep = halfWidth / (double)(yend - ybase + 1);
                for (int y = yend; y >= ybase; --y) {
                    int dx = (int)Math.round(halfWidth - (hwStep + 1.0) * (double)Math.abs(y - y0));
                    for (int x = x0 - dx; x <= x0 + dx; ++x) {
                        this.ip.drawDot(x, y);
                    }
                }
                break;
            }
            case 0: 
            case 7: {
                int rsquare = (r + 1) * (r + 1);
                for (int dy = -r; dy <= r; ++dy) {
                    for (int dx = -r; dx <= r; ++dx) {
                        if (dx * dx + dy * dy > rsquare) continue;
                        this.ip.drawDot(x0 + dx, y0 + dy);
                    }
                }
                break;
            }
        }
    }

    @Deprecated
    public void drawArrow(int x1, int y1, int x2, int y2, double size) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double ra = Math.sqrt(dx * dx + dy * dy);
        int x3 = (int)Math.round((double)x2 - (dx /= ra) * size);
        int y3 = (int)Math.round((double)y2 - (dy /= ra) * size);
        double r = 0.3 * size;
        int x4 = (int)Math.round((double)x3 + dy * r);
        int y4 = (int)Math.round((double)y3 - dx * r);
        int x5 = (int)Math.round((double)x3 - dy * r);
        int y5 = (int)Math.round((double)y3 + dx * r);
        this.ip.moveTo(x1, y1);
        this.ip.lineTo(x2, y2);
        this.ip.moveTo(x4, y4);
        this.ip.lineTo(x2, y2);
        this.ip.lineTo(x5, y5);
    }

    private void drawVerticalErrorBars(float[] x, float[] y, float[] e) {
        int nPoints = Math.min(Math.min(x.length, y.length), e.length);
        for (int i = 0; i < nPoints; ++i) {
            if (Float.isNaN(x[i]) || Float.isNaN(y[i]) || this.logXAxis && !(x[i] > 0.0f)) continue;
            int x0 = this.scaleX(x[i]);
            int yPlus = this.scaleYWithOverflow(y[i] + e[i]);
            int yMinus = this.scaleYWithOverflow(y[i] - e[i]);
            this.ip.moveTo(x0, yMinus);
            this.ip.lineTo(x0, yPlus);
        }
    }

    private void drawHorizontalErrorBars(float[] x, float[] y, float[] e) {
        int nPoints = Math.min(Math.min(x.length, y.length), e.length);
        float[] xpoints = new float[2];
        float[] ypoints = new float[2];
        for (int i = 0; i < nPoints; ++i) {
            if (Float.isNaN(x[i]) || Float.isNaN(y[i]) || this.logXAxis && !(y[i] > 0.0f)) continue;
            int y0 = this.scaleY(y[i]);
            int xPlus = this.scaleXWithOverflow(x[i] + e[i]);
            int xMinus = this.scaleXWithOverflow(x[i] - e[i]);
            this.ip.moveTo(xMinus, y0);
            this.ip.lineTo(xPlus, y0);
        }
    }

    void drawFloatPolyline(ImageProcessor ip, float[] x, float[] y, int n) {
        if (x == null || x.length == 0) {
            return;
        }
        boolean isNaN1 = true;
        int x2 = this.scaleX(x[0]);
        int y2 = this.scaleY(y[0]);
        boolean isNaN2 = Float.isNaN(x[0]) || Float.isNaN(y[0]) || this.logXAxis && x[0] <= 0.0f || this.logYAxis && y[0] <= 0.0f;
        for (int i = 1; i < n; ++i) {
            int x1 = x2;
            int y1 = y2;
            boolean isNaN0 = isNaN1;
            isNaN1 = isNaN2;
            x2 = this.scaleX(x[i]);
            y2 = this.scaleY(y[i]);
            boolean bl = isNaN2 = Float.isNaN(x[i]) || Float.isNaN(y[i]) || this.logXAxis && x[i] <= 0.0f || this.logYAxis && y[i] <= 0.0f;
            if (!isNaN1 && !isNaN2) {
                ip.drawLine(x1, y1, x2, y2);
                continue;
            }
            if (!isNaN0 || isNaN1 || !isNaN2) continue;
            ip.drawLine(x1, y1, x1, y1);
        }
        if (isNaN1 && !isNaN2) {
            ip.drawLine(x2, y2, x2, y2);
        }
    }

    void drawFloatPolyLineFilled(ImageProcessor ip, float[] xF, float[] yF, int len) {
        if (xF == null || len <= 1) {
            return;
        }
        ip.setLineWidth(1);
        int y0 = this.scaleYWithOverflow(0.0);
        int x2 = this.scaleX(xF[0]);
        int y2 = this.scaleY(yF[0]);
        boolean isNaN2 = Float.isNaN(xF[0]) || Float.isNaN(yF[0]) || this.logXAxis && xF[0] <= 0.0f || this.logYAxis && yF[0] <= 0.0f;
        for (int i = 1; i < len; ++i) {
            boolean isNaN1 = isNaN2;
            isNaN2 = Float.isNaN(xF[i]) || Float.isNaN(yF[i]) || this.logXAxis && xF[i] <= 0.0f || this.logYAxis && yF[i] <= 0.0f;
            int x1 = x2;
            int y1 = y2;
            x2 = this.scaleX(xF[i]);
            y2 = this.scaleY(yF[i]);
            int left = x1;
            int right = x2;
            if (isNaN1 || isNaN2 || left < this.frame.x && right < this.frame.x || left >= this.frame.x + this.frame.width && right >= this.frame.x + this.frame.width) continue;
            if (left < this.frame.x) {
                left = this.frame.x;
            }
            if (left >= this.frame.x + this.frame.width) {
                left = this.frame.x + this.frame.width - 1;
            }
            if (right < this.frame.x) {
                right = this.frame.x;
            }
            if (right >= this.frame.x + this.frame.width) {
                right = this.frame.x + this.frame.width - 1;
            }
            if (left != right) {
                for (int xi = Math.min(left, right); xi <= Math.max(left, right); ++xi) {
                    int yi = (int)Math.round((double)y1 + (double)(y2 - y1) * (double)(xi - x1) / (double)(x2 - x1));
                    ip.drawLine(xi, y0, xi, yi);
                }
                continue;
            }
            ip.drawLine(left, y0, left, y2);
        }
    }

    Vector<PlotObject> getIndexedPlotObjects() {
        boolean withIndex = false;
        int len = this.allPlotObjects.size();
        String[] labels = new String[len];
        Vector<PlotObject> indexedObjects = new Vector<PlotObject>();
        for (int jj = 0; jj < len; ++jj) {
            String label;
            PlotObject plotObject = this.allPlotObjects.get(jj);
            labels[jj] = "";
            if (plotObject.type != 1 || plotObject.hasFlag(8192) || plotObject.label == null || (label = plotObject.label).indexOf("__") < 0 || label.indexOf("__") > 2) continue;
            labels[jj] = plotObject.label;
            withIndex = true;
        }
        int[] ranks = Tools.rank(labels);
        for (int jj = 0; jj < len; ++jj) {
            if (labels[ranks[jj]] == "") continue;
            int index = ranks[jj];
            indexedObjects.add(this.allPlotObjects.get(index));
        }
        if (!withIndex) {
            return null;
        }
        return indexedObjects;
    }

    void drawLegend(PlotObject legendObject, ImageProcessor ip) {
        int y;
        ip.setFont(this.scFont(legendObject.getFont()));
        int nLabels = 0;
        int maxStringWidth = 0;
        float maxLineThickness = 0.0f;
        Vector<PlotObject> usedPlotObjects = this.allPlotObjects;
        Vector<PlotObject> indexedObjects = this.getIndexedPlotObjects();
        if (indexedObjects != null) {
            usedPlotObjects = indexedObjects;
        }
        for (PlotObject plotObject : usedPlotObjects) {
            int w;
            if (plotObject.type != 1 || plotObject.hasFlag(8192) || plotObject.label == null) continue;
            ++nLabels;
            String label = plotObject.label;
            if (indexedObjects != null) {
                label = label.substring(label.indexOf("__") + 2);
            }
            if ((w = ip.getStringWidth(label)) > maxStringWidth) {
                maxStringWidth = w;
            }
            if (!(plotObject.lineWidth > maxLineThickness)) continue;
            maxLineThickness = plotObject.lineWidth;
        }
        if (nLabels == 0) {
            return;
        }
        if (this.pp.antialiasedText && this.scale > 1.0f) {
            maxStringWidth = (int)((1.0 + 0.004 * (double)this.scale) * (double)maxStringWidth);
        }
        int frameThickness = this.sc(legendObject.lineWidth > 0.0f ? legendObject.lineWidth : 1.0f);
        FontMetrics fm = ip.getFontMetrics();
        ip.setJustification(0);
        int lineHeight = fm.getHeight();
        int height = nLabels * lineHeight + 2 * this.sc(4.0f);
        int width = maxStringWidth + this.sc(32.0f + maxLineThickness);
        int positionCode = legendObject.flags & 0xF0;
        if (positionCode == 128) {
            positionCode = this.autoLegendPosition(width, height, frameThickness);
        }
        Rectangle rect = this.legendRect(positionCode, width, height, frameThickness);
        int x0 = rect.x;
        int y0 = rect.y;
        ip.setColor(Color.white);
        ip.setLineWidth(1);
        if (!legendObject.hasFlag(512)) {
            ip.setRoi(x0, y0, width, height);
            ip.fill();
        } else if (this.hasFlag(48)) {
            int grid = ip instanceof ColorProcessor ? this.gridColor.getRGB() & 0xFFFFFF : ip.getBestIndex(this.gridColor);
            for (y = y0; y < y0 + height; ++y) {
                for (int x = x0; x < x0 + width; ++x) {
                    if ((ip.getPixel(x, y) & 0xFFFFFF) != grid) continue;
                    ip.drawPixel(x, y);
                }
            }
        }
        ip.setLineWidth(frameThickness);
        ip.setColor(legendObject.color);
        ip.drawRect(x0 - frameThickness / 2, y0 - frameThickness / 2, width + frameThickness, height);
        boolean bottomUp = legendObject.hasFlag(256);
        y = y0 + frameThickness / 2 + this.sc(4.0f) + lineHeight / 2;
        if (bottomUp) {
            y += (nLabels - 1) * lineHeight;
        }
        int xText = x0 + frameThickness / 2 + this.sc(28.0f + maxLineThickness);
        int xMarker = x0 + frameThickness / 2 + this.sc(4.0f + 0.5f * (20.0f + maxLineThickness));
        int xLine0 = x0 + frameThickness / 2 + this.sc(4.0f) + 1;
        for (PlotObject plotObject : usedPlotObjects) {
            int start;
            if (plotObject.type != 1 || plotObject.hasFlag(8192) || plotObject.label == null) continue;
            int shape = plotObject.shape;
            if (shape == 12) {
                shape = 3;
            }
            int yShiftLine = 0;
            if (shape == 10 || shape == 11 && plotObject.color2 != null) {
                yShiftLine = this.sc(0.1f * legendObject.getFontSize() + 0.3f * plotObject.lineWidth);
            }
            int markerSize = plotObject.getMarkerSize();
            if (plotObject.shape == 12 && (double)markerSize < 0.6 * (double)legendObject.getFontSize()) {
                markerSize = 2 * (int)(0.3 * (double)legendObject.getFontSize()) + 1;
            }
            if (plotObject.hasFilledMarker() || plotObject.shape == 12 && plotObject.color2 != null) {
                ip.setColor(plotObject.color2);
                this.fillShape(shape, xMarker, y, markerSize);
            } else if (yShiftLine != 0) {
                ip.setColor(plotObject.color2 == null ? plotObject.color : plotObject.color2);
                ip.fillRect(xLine0, y - yShiftLine, 2 * (xMarker - xLine0) + 1, yShiftLine + (int)(0.3 * (double)legendObject.getFontSize()));
            }
            int lineWidth = this.sc(plotObject.lineWidth);
            if (lineWidth < 1) {
                lineWidth = 1;
            }
            ip.setLineWidth(lineWidth);
            if (plotObject.hasCurve() || plotObject.shape == 11) {
                Color c = plotObject.shape == 7 ? (plotObject.color2 == null ? Color.black : plotObject.color2) : plotObject.color;
                ip.setColor(c);
                ip.fillRect(xLine0, y - lineWidth / 2 - yShiftLine, 2 * (xMarker - xLine0) + 1, lineWidth);
            }
            if (plotObject.hasMarker() || plotObject.shape == 12) {
                Font saveFont = ip.getFont();
                ip.setColor(plotObject.color);
                this.drawShape(plotObject, xMarker, y, shape, markerSize, -1);
                if (plotObject.shape == 9) {
                    ip.setFont(saveFont);
                }
            }
            ip.setColor(plotObject.color);
            ip.setLineWidth(frameThickness);
            String label = plotObject.label;
            if (indexedObjects != null && (start = label.indexOf("__")) >= 0) {
                label = label.substring(start + 2);
            }
            ip.drawString(label, xText, y + lineHeight / 2);
            y += bottomUp ? -lineHeight : lineHeight;
        }
    }

    Rectangle legendRect(int positionCode, int width, int height, int frameThickness) {
        int y0;
        boolean leftPosition = positionCode == 144 || positionCode == 176;
        boolean topPosition = positionCode == 144 || positionCode == 160;
        int x0 = leftPosition ? this.leftMargin + this.sc(8.0f) + frameThickness / 2 : this.leftMargin + this.frameWidth - width - this.sc(8.0f) - frameThickness / 2;
        int n = y0 = topPosition ? this.topMargin + this.sc(4.0f) + frameThickness / 2 : this.topMargin + this.frameHeight - height - this.sc(4.0f) + frameThickness / 2;
        if (this.hasFlag(8)) {
            x0 += (leftPosition ? 1 : -1) * this.sc(this.tickLength - 4);
        }
        if (this.hasFlag(4)) {
            y0 += (topPosition ? 1 : -1) * this.sc(this.tickLength - 2);
        }
        return new Rectangle(x0, y0, width, height);
    }

    int autoLegendPosition(int width, int height, int frameThickness) {
        int background = this.ip instanceof ColorProcessor ? 0xFFFFFF : (this.ip.isInvertedLut() ? 0 : 255);
        int grid = this.ip instanceof ColorProcessor ? this.gridColor.getRGB() & 0xFFFFFF : this.ip.getBestIndex(this.gridColor);
        int bestPosition = 0;
        int minCoveredPixels = Integer.MAX_VALUE;
        for (int positionCode : new int[]{144, 160, 192, 176}) {
            Rectangle rect = this.legendRect(positionCode, width, height, frameThickness);
            int coveredPixels = 0;
            for (int y = rect.y - frameThickness / 2; y <= rect.y + rect.height + frameThickness / 2; ++y) {
                for (int x = rect.x - frameThickness / 2; x <= rect.x + rect.width + frameThickness / 2; ++x) {
                    int pixel = this.ip.getPixel(x, y) & 0xFFFFFF;
                    if (pixel == background || pixel == grid) continue;
                    ++coveredPixels;
                }
            }
            if (coveredPixels >= minCoveredPixels) continue;
            minCoveredPixels = coveredPixels;
            bestPosition = positionCode;
        }
        return bestPosition;
    }

    String getCoordinates(int x, int y) {
        PlotObject p;
        if (this.frame == null) {
            return "";
        }
        String text = "";
        if (!this.frame.contains(x, y)) {
            return text;
        }
        double xv = this.descaleX(x);
        double yv = this.descaleY(y);
        boolean yIsValue = false;
        if (!this.hasMultiplePlots() && (p = this.getMainCurveObject()) != null) {
            double bestDx = Double.MAX_VALUE;
            double xBest = 0.0;
            double yBest = 0.0;
            for (int i = 0; i < Math.min(p.xValues.length, p.yValues.length); ++i) {
                double xp = p.xValues[i];
                if (!(Math.abs(xp - xv) < bestDx)) continue;
                bestDx = Math.abs(xp - xv);
                xBest = xp;
                yBest = p.yValues[i];
            }
            if (Math.abs(this.scaleXtoPxl(xBest) - (double)x) < 50.0) {
                xv = xBest;
                yv = yBest;
                yIsValue = true;
            }
        }
        if (!Double.isNaN(xv)) {
            int significantDigits = this.logXAxis ? -2 : Plot.getDigits(xv, 0.001 * (this.xMax - this.xMin), 6, 0);
            text = "X=" + IJ.d2s(xv, significantDigits) + ", Y";
            if (yIsValue) {
                text = text + "(X)";
            }
            significantDigits = this.logYAxis ? -2 : Plot.getDigits(yv, 0.001 * (this.yMax - this.yMin), 6, 0);
            text = text + "=" + IJ.d2s(yv, significantDigits);
        }
        return text;
    }

    private PlotObject getMainCurveObject() {
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 1) continue;
            return plotObject;
        }
        return null;
    }

    private PlotObject getLastCurveObject() {
        for (int i = this.allPlotObjects.size() - 1; i >= 0; --i) {
            if (this.allPlotObjects.get((int)i).type != 1) continue;
            return this.allPlotObjects.get(i);
        }
        return null;
    }

    private boolean hasMultiplePlots() {
        int nPlots = 0;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type == 2) {
                return true;
            }
            if (plotObject.type != 1 || ++nPlots <= 1) continue;
            return true;
        }
        return nPlots > 1;
    }

    public void setPlotMaker(PlotMaker plotMaker) {
        this.plotMaker = plotMaker;
    }

    PlotMaker getPlotMaker() {
        return this.plotMaker;
    }

    String getDataLabels() {
        String labels = "";
        boolean first = true;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 1 || plotObject.hasFlag(8192)) continue;
            if (first) {
                first = false;
            } else {
                labels = labels + '\n';
            }
            if (plotObject.label == null) continue;
            labels = labels + plotObject.label;
        }
        return labels;
    }

    public ResultsTable getResultsTable() {
        return this.getResultsTable(true);
    }

    public ResultsTable getResultsTable(boolean writeFirstXColumn) {
        return this.getResultsTable(writeFirstXColumn, false);
    }

    public ResultsTable getResultsTableWithLabels() {
        return this.getResultsTable(true, true);
    }

    ResultsTable getResultsTable(boolean writeFirstXColumn, boolean useLabels) {
        ResultsTable rt = new ResultsTable();
        int nDataSets = 0;
        int tableLength = 0;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.xValues == null) continue;
            ++nDataSets;
            tableLength = Math.max(tableLength, plotObject.xValues.length);
        }
        if (nDataSets == 0) {
            return null;
        }
        ArrayList<String> headings = new ArrayList<String>(2 * nDataSets);
        ArrayList<float[]> data = new ArrayList<float[]>(2 * nDataSets);
        int dataSetNumber = 0;
        int arrowsNumber = 0;
        PlotObject firstXYobject = null;
        boolean allSameLength = true;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 1) continue;
            if (firstXYobject != null && firstXYobject.xValues.length != plotObject.xValues.length) {
                allSameLength = false;
                break;
            }
            if (firstXYobject != null) continue;
            firstXYobject = plotObject;
        }
        firstXYobject = null;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type == 1) {
                boolean sameXY;
                boolean sameX = firstXYobject != null && Arrays.equals(firstXYobject.xValues, plotObject.xValues) && allSameLength;
                boolean bl = sameXY = sameX && Arrays.equals(firstXYobject.yValues, plotObject.yValues);
                boolean writeX = firstXYobject == null ? writeFirstXColumn : !sameX;
                this.addToLists(headings, data, plotObject, dataSetNumber, writeX, !sameXY, nDataSets > 1, useLabels);
                if (firstXYobject == null) {
                    firstXYobject = plotObject;
                }
                ++dataSetNumber;
                continue;
            }
            if (plotObject.type != 2) continue;
            this.addToLists(headings, data, plotObject, arrowsNumber, true, true, nDataSets > 1, false);
            ++arrowsNumber;
        }
        int nColumns = headings.size();
        for (int line = 0; line < tableLength; ++line) {
            for (int col = 0; col < nColumns; ++col) {
                String heading = (String)headings.get(col);
                float[] values = (float[])data.get(col);
                if (line < values.length) {
                    rt.setValue(heading, line, (double)values[line]);
                    continue;
                }
                rt.setValue(heading, line, "");
            }
        }
        nColumns = rt.getLastColumn() + 1;
        for (int i = 0; i < nColumns; ++i) {
            rt.setDecimalPlaces(i, Plot.getPrecision(rt.getColumn(i)));
        }
        return rt;
    }

    void addToLists(ArrayList<String> headings, ArrayList<float[]> data, PlotObject plotObject, int dataSetNumber, boolean writeX, boolean writeY, boolean multipleSets, boolean useLabels) {
        String label;
        String plotObjectLabel;
        String string = plotObjectLabel = useLabels ? Plot.replaceSpacesEtc(plotObject.label) : null;
        if (writeX) {
            label = null;
            if (plotObject.type != 2) {
                String plotXLabel = this.getLabel('x');
                if (dataSetNumber == 0 && plotXLabel != null) {
                    if (useLabels) {
                        label = Plot.replaceSpacesEtc(plotXLabel);
                    } else if (plotXLabel.startsWith(" ") && plotXLabel.endsWith(" ")) {
                        label = plotXLabel.substring(1, plotXLabel.length() - 1);
                    }
                } else if (plotObjectLabel != null && dataSetNumber > 0) {
                    label = "X_" + plotObjectLabel;
                }
                if (label != null && headings.contains(label)) {
                    label = null;
                }
            }
            if (label == null) {
                String string2 = label = plotObject.type == 2 ? "XStart" : "X";
                if (multipleSets) {
                    label = label + dataSetNumber;
                }
            }
            headings.add(label);
            data.add(plotObject.xValues);
        }
        if (writeY) {
            label = null;
            if (plotObject.type != 2) {
                String plotYLabel = this.getLabel('y');
                if (dataSetNumber == 0 && plotYLabel != null) {
                    if (useLabels && plotObjectLabel == null) {
                        label = Plot.replaceSpacesEtc(plotYLabel);
                    } else if (plotYLabel.startsWith(" ") && plotYLabel.endsWith(" ")) {
                        label = plotYLabel.substring(1, plotYLabel.length() - 1);
                    }
                }
                if (plotObjectLabel != null) {
                    label = plotObjectLabel;
                }
                if (label != null && headings.contains(label)) {
                    label = null;
                }
            }
            if (label == null) {
                String string3 = label = plotObject.type == 2 ? "YStart" : "Y";
                if (multipleSets) {
                    label = label + dataSetNumber;
                }
            }
            headings.add(label);
            data.add(plotObject.yValues);
        }
        if (plotObject.xEValues != null) {
            String string4 = label = plotObject.type == 2 ? "XEnd" : "XERR";
            if (multipleSets) {
                label = label + dataSetNumber;
            }
            headings.add(label);
            data.add(plotObject.xEValues);
        }
        if (plotObject.yEValues != null) {
            String string5 = label = plotObject.type == 2 ? "YEnd" : "ERR";
            if (multipleSets) {
                label = label + dataSetNumber;
            }
            headings.add(label);
            data.add(plotObject.yEValues);
        }
    }

    static String replaceSpacesEtc(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim().replaceAll("[\\s,]", "_").replace("\"", "''")).length() == 0) {
            return null;
        }
        return s;
    }

    static int getPrecision(float[] values) {
        int digits;
        boolean scientificNotation;
        int setDigits = Analyzer.getPrecision();
        int measurements = Analyzer.getMeasurements();
        boolean bl = scientificNotation = (measurements & 0x200000) != 0;
        if (scientificNotation) {
            if (setDigits < 4) {
                setDigits = 4;
            }
            return -setDigits;
        }
        boolean allInteger = true;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < values.length; ++i) {
            if ((float)((int)values[i]) == values[i] || Float.isNaN(values[i])) continue;
            allInteger = false;
            if (values[i] < min) {
                min = values[i];
            }
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        if (allInteger) {
            return 0;
        }
        int n = digits = max - min > 0.0f ? Plot.getDigits(min, max, 1.0E-5 * (double)(max - min), 15, 0) : Plot.getDigits(max, 1.0E-5 * (double)Math.abs(max), 15, 0);
        if (setDigits > Math.abs(digits)) {
            digits = setDigits * (digits < 0 ? -1 : 1);
        }
        return digits;
    }

    boolean hasFlag(int what) {
        return (this.pp.axisFlags & what) != 0;
    }

    public void addPoints(String dummy, float[] x, float[] y, int shape) {
        this.addPoints(x, y, shape);
    }

    public void addHistogram(double[] values) {
        this.addHistogram(values, 0.0, 0.0);
    }

    public void addHistogram(double[] values, double binWidth) {
        this.addHistogram(values, binWidth, 0.0);
    }

    public void addHistogram(double[] values, double binWidth, double binCenter) {
        int i;
        int len = values.length;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double[] cleanVals = new double[len];
        int count = 0;
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i2 = 0; i2 < len; ++i2) {
            double val = values[i2];
            if (Double.isNaN(val)) continue;
            cleanVals[count++] = val;
            sum += val;
            sum2 += val * val;
            if (val < min) {
                min = val;
            }
            if (!(val > max)) continue;
            max = val;
        }
        if (binWidth <= 0.0) {
            double stdDev = Math.sqrt(((double)count * sum2 - sum * sum) / (double)count / (double)count);
            binWidth = 3.49 * stdDev * Math.pow(count, -0.3333333333333333);
        }
        double modCenter = binCenter % binWidth;
        double modMin = min % binWidth;
        double diff = modMin - modCenter;
        double firstBin = min - diff;
        while (firstBin - binWidth * 0.499 > min) {
            firstBin -= binWidth;
        }
        int nBins = (int)((max - firstBin) / binWidth);
        double lastBin = firstBin + (double)nBins * binWidth;
        while (lastBin + binWidth * 0.499 < max) {
            lastBin += binWidth;
        }
        nBins = (int)Math.round((lastBin - firstBin) / binWidth) + 1;
        if (nBins == 1) {
            nBins = 2;
        }
        if (nBins > 9999) {
            IJ.error("max bins > 9999");
            return;
        }
        double[] histo = new double[nBins];
        double[] xValues = new double[nBins];
        for (i = 0; i < nBins; ++i) {
            xValues[i] = firstBin + (double)i * binWidth;
        }
        for (i = 0; i < count; ++i) {
            double val = cleanVals[i];
            double indexD = (val - firstBin) / binWidth;
            int index = (int)Math.round(indexD);
            if (index < 0 || index >= nBins) {
                IJ.error("index out of range");
                return;
            }
            int n = index;
            histo[n] = histo[n] + 1.0;
        }
        this.add("bar", xValues, histo);
    }

    public void addErrorBars(String dummy, float[] errorBars) {
        this.addErrorBars(errorBars);
    }

    public void changeFont(Font font) {
        this.setFont(font);
    }
}

