/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.DragAndDropHandler;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.ImageReader;
import ij.io.OpenDialog;
import ij.io.RandomAccessStream;
import ij.io.RoiDecoder;
import ij.io.TiffDecoder;
import ij.macro.Interpreter;
import ij.measure.ResultsTable;
import ij.plugin.AVI_Reader;
import ij.plugin.DICOM;
import ij.plugin.HyperStackConverter;
import ij.plugin.ImageInfo;
import ij.plugin.LutLoader;
import ij.plugin.PluginInstaller;
import ij.plugin.TextReader;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.process.FHT;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.text.TextWindow;
import ij.util.Java2;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;

public class Opener {
    public static final int UNKNOWN = 0;
    public static final int TIFF = 1;
    public static final int DICOM = 2;
    public static final int FITS = 3;
    public static final int PGM = 4;
    public static final int JPEG = 5;
    public static final int GIF = 6;
    public static final int LUT = 7;
    public static final int BMP = 8;
    public static final int ZIP = 9;
    public static final int JAVA_OR_TEXT = 10;
    public static final int ROI = 11;
    public static final int TEXT = 12;
    public static final int PNG = 13;
    public static final int TIFF_AND_DICOM = 14;
    public static final int CUSTOM = 15;
    public static final int AVI = 16;
    public static final int OJJ = 17;
    public static final int TABLE = 18;
    public static final int RAW = 19;
    public static final String[] types = new String[]{"unknown", "tif", "dcm", "fits", "pgm", "jpg", "gif", "lut", "bmp", "zip", "java/txt", "roi", "txt", "png", "t&d", "custom", "ojj", "table", "raw"};
    private static String defaultDirectory = null;
    private int fileType;
    private boolean error;
    private boolean isRGB48;
    private boolean silentMode;
    private String omDirectory;
    private File[] omFiles;
    private static boolean openUsingPlugins;
    private static boolean bioformats;
    private String url;
    private boolean useHandleExtraFileTypes;

    public void open() {
        OpenDialog od = new OpenDialog("Open", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name != null) {
            String path = directory + name;
            this.error = false;
            this.open(path);
            if (!this.error) {
                Menus.addOpenRecentItem(path);
            }
        }
    }

    public void open(String path) {
        boolean isURL;
        boolean bl = isURL = path.contains("://") || path.contains("file:/");
        if (isURL && this.isText(path)) {
            this.openTextURL(path);
            return;
        }
        if (path.endsWith(".jar") || path.endsWith(".class")) {
            new PluginInstaller().install(path);
            return;
        }
        path = Opener.makeFullPath(path);
        if (!this.silentMode) {
            IJ.showStatus("Opening: " + path);
        }
        long start = System.currentTimeMillis();
        ImagePlus imp = null;
        if (path.endsWith(".txt")) {
            this.fileType = 10;
        } else {
            this.useHandleExtraFileTypes = true;
            imp = this.openImage(path);
        }
        if (imp == null && isURL) {
            return;
        }
        if (imp != null) {
            WindowManager.checkForDuplicateName = true;
            if (this.isRGB48) {
                this.openRGB48(imp);
            } else {
                imp.show(Opener.getLoadRate(start, imp));
            }
        } else {
            switch (this.fileType) {
                case 7: {
                    imp = (ImagePlus)IJ.runPlugIn("ij.plugin.LutLoader", path);
                    if (imp.getWidth() == 0) break;
                    imp.show();
                    break;
                }
                case 11: {
                    IJ.runPlugIn("ij.plugin.RoiReader", path);
                    break;
                }
                case 10: 
                case 12: {
                    String osName;
                    if (IJ.altKeyDown()) {
                        new TextWindow(path, 400, 450);
                        IJ.setKeyUp(18);
                        break;
                    }
                    File file = new File(path);
                    int maxSize = 250000;
                    long size = file.length();
                    if (size >= 28000L && ((osName = System.getProperty("os.name")).equals("Windows 95") || osName.equals("Windows 98") || osName.equals("Windows Me"))) {
                        maxSize = 60000;
                    }
                    if (size < (long)maxSize) {
                        Editor ed = new Editor(path);
                        if (ed == null) break;
                        ed.open(this.getDir(path), this.getName(path));
                        break;
                    }
                    new TextWindow(path, 400, 450);
                    break;
                }
                case 17: {
                    IJ.runPlugIn("ObjectJ_", path);
                    break;
                }
                case 18: {
                    Opener.openTable(path);
                    break;
                }
                case 19: {
                    IJ.runPlugIn("ij.plugin.Raw", path);
                    break;
                }
                case 0: {
                    String msg;
                    File f = new File(path);
                    String string = msg = f.exists() ? "Format not supported or reader plugin not found:" : "File not found:";
                    if (path != null) {
                        if (path.length() > 64) {
                            path = new File(path).getName();
                        }
                        if (path.length() <= 64) {
                            msg = msg + " \n" + path;
                        }
                    }
                    if (openUsingPlugins && msg.length() > 20) {
                        msg = msg + "\n \nNOTE: The \"OpenUsingPlugins\" option is set.";
                    }
                    IJ.wait(IJ.isMacro() ? 500 : 100);
                    IJ.error("Opener", msg);
                    this.error = true;
                }
            }
        }
    }

    public void openMultiple() {
        LookAndFeel saveLookAndFeel = Java2.getLookAndFeel();
        Java2.setSystemLookAndFeel();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int returnVal;
                    JFileChooser fc = new JFileChooser();
                    fc.setMultiSelectionEnabled(true);
                    fc.setDragEnabled(true);
                    fc.setTransferHandler(new DragAndDropHandler(fc));
                    File dir = null;
                    String sdir = OpenDialog.getDefaultDirectory();
                    if (sdir != null) {
                        dir = new File(sdir);
                    }
                    if (dir != null) {
                        fc.setCurrentDirectory(dir);
                    }
                    if (IJ.debugMode) {
                        IJ.log("Opener.openMultiple: " + sdir + " " + dir);
                    }
                    if ((returnVal = fc.showOpenDialog(IJ.getInstance())) != 0) {
                        return;
                    }
                    Opener.access$002(Opener.this, fc.getSelectedFiles());
                    if (Opener.this.omFiles.length == 0) {
                        Opener.access$002(Opener.this, new File[1]);
                        ((Opener)Opener.this).omFiles[0] = fc.getSelectedFile();
                    }
                    Opener.this.omDirectory = fc.getCurrentDirectory().getPath() + File.separator;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.omDirectory == null) {
            return;
        }
        OpenDialog.setDefaultDirectory(this.omDirectory);
        for (int i = 0; i < this.omFiles.length; ++i) {
            String path = this.omDirectory + this.omFiles[i].getName();
            this.open(path);
            if (i == 0 && Recorder.record) {
                Recorder.recordPath("open", path);
            }
            if (i != 0 || this.error) continue;
            Menus.addOpenRecentItem(path);
        }
        Java2.setLookAndFeel(saveLookAndFeel);
    }

    public ImagePlus openImage(String path) {
        if (path == null || path.equals("")) {
            path = this.getPath();
        }
        if (path == null) {
            return null;
        }
        ImagePlus img = null;
        img = path.contains("://") || path.contains("file:/") ? this.openURL(path) : this.openImage(this.getDir(path), this.getName(path));
        return img;
    }

    public ImagePlus openImage(String path, int n) {
        if (path == null || path.equals("")) {
            path = this.getPath();
        }
        if (path == null) {
            return null;
        }
        int type = this.getFileType(path);
        if (type != 1) {
            throw new IllegalArgumentException("Opener: TIFF file required");
        }
        return this.openTiff(path, n);
    }

    public static String getLoadRate(double time, ImagePlus imp) {
        time = ((double)System.currentTimeMillis() - time) / 1000.0;
        double mb = imp.getWidth() * imp.getHeight() * imp.getStackSize();
        int bits = imp.getBitDepth();
        if (bits == 16) {
            mb *= 2.0;
        } else if (bits == 24 || bits == 32) {
            mb *= 4.0;
        }
        double rate = (mb /= 1048576.0) / time;
        int digits = rate < 100.0 ? 1 : 0;
        return "" + IJ.d2s(time, 2) + " seconds (" + IJ.d2s(mb / time, digits) + " MB/sec)";
    }

    public static String makeFullPath(String path) {
        if (path == null) {
            return path;
        }
        if (!Opener.isFullPath(path)) {
            String defaultDir = OpenDialog.getDefaultDirectory();
            path = defaultDir != null ? defaultDir + path : new File(path).getAbsolutePath();
        }
        return path;
    }

    public static boolean isFullPath(String path) {
        if (path == null) {
            return false;
        }
        return path.startsWith("/") || path.startsWith("\\") || path.contains(":\\") || path.contains(":/") || path.contains("://");
    }

    private boolean isText(String path) {
        int lastDot;
        if (path.endsWith(".txt") || path.endsWith(".ijm") || path.endsWith(".java") || path.endsWith(".js") || path.endsWith(".html") || path.endsWith(".htm") || path.endsWith(".bsh") || path.endsWith(".py") || path.endsWith("/")) {
            return true;
        }
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash == -1) {
            lastSlash = 0;
        }
        return (lastDot = path.lastIndexOf(".")) == -1 || lastDot < lastSlash || path.length() - lastDot > 6;
    }

    public boolean openAndAddToRecent(String path) {
        this.open(path);
        if (!this.error) {
            Menus.addOpenRecentItem(path);
        }
        return !this.error;
    }

    public ImagePlus openImage(String directory, String name) {
        FileOpener.setSilentMode(this.silentMode);
        if (directory.length() > 0 && !directory.endsWith("/") && !directory.endsWith("\\")) {
            directory = directory + Prefs.separator;
        }
        OpenDialog.setLastDirectory(directory);
        OpenDialog.setLastName(name);
        String path = directory + name;
        this.fileType = this.getFileType(path);
        if (IJ.debugMode) {
            IJ.log("openImage: \"" + types[this.fileType] + "\", " + path);
        }
        switch (this.fileType) {
            case 1: {
                ImagePlus imp = this.openTiff(directory, name);
                return imp;
            }
            case 2: 
            case 14: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 3: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.FITS_Reader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 4: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.PGM_Reader", path);
                if (imp.getWidth() != 0) {
                    if (imp.getStackSize() == 3 && imp.getBitDepth() == 16) {
                        imp = new CompositeImage(imp, 1);
                    }
                    return imp;
                }
                return null;
            }
            case 5: {
                ImagePlus imp = this.openJpegOrGif(directory, name);
                if (imp != null && imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 6: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.GIF_Reader", path);
                if (imp != null && imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 13: {
                ImagePlus imp = Opener.openUsingImageIO(directory + name);
                if (imp != null && imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 8: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP_Reader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 9: {
                return this.openZip(path);
            }
            case 16: {
                AVI_Reader reader = new AVI_Reader();
                reader.setVirtual(true);
                reader.displayDialog(!IJ.macroRunning());
                reader.run(path);
                return reader.getImagePlus();
            }
            case 10: {
                if (name.endsWith(".txt")) {
                    return this.openTextImage(directory, name);
                }
                return null;
            }
            case 0: 
            case 12: {
                ImagePlus imp = null;
                if (name.endsWith(".lsm")) {
                    this.useHandleExtraFileTypes = true;
                }
                if (!this.useHandleExtraFileTypes) {
                    imp = Opener.openUsingBioFormats(path);
                }
                this.useHandleExtraFileTypes = false;
                if (imp != null) {
                    return imp;
                }
                return this.openUsingHandleExtraFileTypes(path);
            }
        }
        return null;
    }

    public ImagePlus openTempImage(String directory, String name) {
        ImagePlus imp = this.openImage(directory, name);
        if (imp != null) {
            imp.setTemporary();
        }
        return imp;
    }

    private ImagePlus openUsingHandleExtraFileTypes(String path) {
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        int nImages = WindowManager.getImageCount();
        int[] wrap = new int[]{this.fileType};
        ImagePlus imp = this.openWithHandleExtraFileTypes(path, wrap);
        if (imp != null && imp.getNChannels() > 1) {
            imp = new CompositeImage(imp, 2);
        }
        this.fileType = wrap[0];
        if (imp == null && (this.fileType == 0 || this.fileType == 1) && WindowManager.getImageCount() == nImages) {
            IJ.error("Opener", "Unsupported format or file not found:\n" + path);
        }
        return imp;
    }

    String getPath() {
        OpenDialog od = new OpenDialog("Open", "");
        String dir = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return null;
        }
        return dir + name;
    }

    public ImagePlus openTextImage(String dir, String name) {
        TextReader tr = new TextReader();
        String path = dir + name;
        ImageProcessor ip = tr.open(path);
        return ip != null ? new ImagePlus(name, ip) : null;
    }

    public ImagePlus openURL(String url) {
        ImagePlus imp;
        url = Opener.updateUrl(url);
        if (IJ.debugMode) {
            IJ.log("OpenURL: " + url);
        }
        if ((imp = this.openCachedImage(url)) != null) {
            return imp;
        }
        try {
            String name = "";
            int index = url.lastIndexOf(47);
            if (index == -1) {
                index = url.lastIndexOf(92);
            }
            if (index <= 0) {
                throw new MalformedURLException("Invalid URL: " + url);
            }
            name = url.substring(index + 1);
            if (url.indexOf(" ") != -1) {
                url = url.replaceAll(" ", "%20");
            }
            URL u = new URL(url);
            IJ.showStatus("" + url);
            String lurl = url.toLowerCase(Locale.US);
            if (lurl.endsWith(".tif")) {
                this.url = url;
                imp = this.openTiff(u.openStream(), name);
            } else if (lurl.endsWith(".zip")) {
                imp = this.openZipUsingUrl(u);
            } else if (lurl.endsWith(".jpg") || lurl.endsWith(".jpeg") || lurl.endsWith(".gif")) {
                imp = this.openJpegOrGifUsingURL(name, u);
            } else if (lurl.endsWith(".dcm") || lurl.endsWith(".ima")) {
                imp = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", url);
                if (imp != null && imp.getWidth() == 0) {
                    imp = null;
                }
            } else {
                URLConnection uc;
                String type;
                imp = lurl.endsWith(".png") ? this.openPngUsingURL(name, u) : ((type = (uc = u.openConnection()).getContentType()) != null && (type.equals("image/jpeg") || type.equals("image/gif")) ? this.openJpegOrGifUsingURL(name, u) : (type != null && type.equals("image/png") ? this.openPngUsingURL(name, u) : this.openWithHandleExtraFileTypes(url, new int[]{0})));
            }
            IJ.showStatus("");
            return imp;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            msg = msg + "\n" + url;
            IJ.error("Open URL", msg);
            return null;
        }
    }

    public static String updateUrl(String url) {
        if (url == null || !url.contains("nih.gov")) {
            return url;
        }
        if (IJ.isJava18()) {
            url = url.replace("http:", "https:");
        } else {
            url = url.replace("imagej.nih.gov/ij", "imagej.net");
            url = url.replace("rsb.info.nih.gov/ij", "imagej.net");
            url = url.replace("rsbweb.nih.gov/ij", "imagej.net");
        }
        return url;
    }

    private ImagePlus openCachedImage(String url) {
        if (url == null) {
            return null;
        }
        String ijDir = IJ.getDirectory("imagej");
        if (ijDir == null) {
            return null;
        }
        int slash = url.lastIndexOf(47);
        File file = new File(ijDir + "samples", url.substring(slash + 1));
        if (!file.exists()) {
            return null;
        }
        if (url.endsWith(".gif")) {
            return this.openJpegOrGif(file.getParent() + File.separator, file.getName());
        }
        return IJ.openImage(file.getPath());
    }

    void openTextURL(String url) {
        int len;
        if (url.endsWith(".pdf") || url.endsWith(".zip")) {
            return;
        }
        String text = IJ.openUrlAsString(url);
        if (text != null && text.startsWith("<Error: ")) {
            IJ.error("Open Text URL", text);
            return;
        }
        String name = url.substring(7);
        int index = name.lastIndexOf("/");
        if (index == (len = name.length()) - 1) {
            name = name.substring(0, len - 1);
        } else if (index != -1 && index < len - 1) {
            name = name.substring(index + 1);
        }
        name = name.replaceAll("%20", " ");
        Editor ed = new Editor(name);
        ed.setSize(600, 300);
        ed.create(name, text);
        IJ.showStatus("");
    }

    public ImagePlus openWithHandleExtraFileTypes(String path, int[] fileTypes) {
        ImagePlus imp = null;
        if (path.endsWith(".db")) {
            fileTypes[0] = 15;
            return null;
        }
        try {
            imp = (ImagePlus)IJ.runPlugIn("HandleExtraFileTypes", path);
        }
        catch (Exception e) {
            if (IJ.debugMode) {
                IJ.log("openWithHandleExtraFileTypes:\n" + path + "\n" + e);
            }
            imp = null;
        }
        if (imp == null) {
            return null;
        }
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi == null) {
            fi = new FileInfo();
            fi.width = imp.getWidth();
            fi.height = imp.getHeight();
            fi.directory = this.getDir(path);
            fi.fileName = this.getName(path);
            imp.setFileInfo(fi);
        }
        if (imp.getWidth() > 0 && imp.getHeight() > 0) {
            fileTypes[0] = 15;
            return imp;
        }
        if (imp.getWidth() == -1) {
            fileTypes[0] = 15;
        }
        return null;
    }

    ImagePlus openZipUsingUrl(URL url) throws IOException {
        URLConnection uc = url.openConnection();
        InputStream in = uc.getInputStream();
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = zis.getNextEntry();
        if (entry == null) {
            zis.close();
            return null;
        }
        String name = entry.getName();
        if (!name.endsWith(".tif") && !name.endsWith(".dcm")) {
            throw new IOException("This ZIP archive does not appear to contain a .tif or .dcm file\n" + name);
        }
        if (name.endsWith(".dcm")) {
            return this.openDicomStack(zis, entry);
        }
        return this.openTiff(zis, name);
    }

    ImagePlus openDicomStack(ZipInputStream zis, ZipEntry entry) throws IOException {
        ImagePlus imp = null;
        int count = 0;
        ImageStack stack = null;
        while (true) {
            if (count > 0) {
                entry = zis.getNextEntry();
            }
            if (entry == null) break;
            String name = entry.getName();
            ImagePlus imp2 = null;
            if (name.endsWith(".dcm")) {
                int len;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                int byteCount = 0;
                boolean progress = false;
                while ((len = zis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                    byteCount += len;
                }
                byte[] bytes = out.toByteArray();
                out.close();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                DICOM dcm = new DICOM(is);
                dcm.run(name);
                imp2 = dcm;
                ((InputStream)is).close();
            }
            zis.closeEntry();
            if (imp2 == null) continue;
            ++count;
            String label = imp2.getTitle();
            String info = (String)imp2.getProperty("Info");
            if (info != null) {
                label = label + "\n" + info;
            }
            if (count == 1) {
                imp = imp2;
                imp.getStack().setSliceLabel(label, 1);
                continue;
            }
            stack = imp.getStack();
            stack.addSlice(label, imp2.getProcessor());
            imp.setStack(stack);
        }
        zis.close();
        IJ.showProgress(1.0);
        if (count == 0) {
            throw new IOException("This ZIP archive does not appear to contain any .dcm files");
        }
        return imp;
    }

    ImagePlus openJpegOrGifUsingURL(String title, URL url) {
        if (url == null) {
            return null;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(url);
        if (img != null) {
            ImagePlus imp = new ImagePlus(title, img);
            return imp;
        }
        return null;
    }

    ImagePlus openPngUsingURL(String title, URL url) {
        if (url == null) {
            return null;
        }
        BufferedImage img = null;
        try {
            InputStream in = url.openStream();
            img = ImageIO.read(in);
        }
        catch (FileNotFoundException e) {
            IJ.error("Open PNG Using URL", "" + e);
        }
        catch (IOException e) {
            IJ.handleException(e);
        }
        if (img != null) {
            ImagePlus imp = new ImagePlus(title, img);
            return imp;
        }
        return null;
    }

    ImagePlus openJpegOrGif(String dir, String name) {
        String exifText;
        ImagePlus imp = null;
        Image img = Toolkit.getDefaultToolkit().createImage(dir + name);
        if (img != null) {
            try {
                imp = new ImagePlus(name, img);
            }
            catch (Exception e) {
                IJ.error("Opener", e.getMessage() + "\n(Note: ImageJ cannot open CMYK JPEGs)\n \n" + dir + name);
                return null;
            }
            if (imp.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imp);
            }
            FileInfo fi = new FileInfo();
            fi.fileFormat = 3;
            fi.fileName = name;
            fi.directory = dir;
            imp.setFileInfo(fi);
        }
        if (imp != null && (exifText = new ImageInfo().getExifData(imp)) != null) {
            String[] lines = exifText.split("\n");
            for (int jj = 0; jj < lines.length; ++jj) {
                int orientationIndex = lines[jj].indexOf("Orientation:");
                int rotateIndex = lines[jj].indexOf("Rotate");
                if (orientationIndex < 0 || rotateIndex < 0) continue;
                String rest = lines[jj].substring(rotateIndex);
                String[] parts = (rest = rest.replace(")", " ")).split(" ");
                if (parts.length < 2) continue;
                ImageProcessor ip = imp.getProcessor();
                double angle = Double.parseDouble(parts[1]);
                ImageProcessor ip2 = null;
                if (angle == 90.0) {
                    ip2 = ip.rotateRight();
                } else if (angle == 180.0) {
                    ip2 = ip.rotateRight();
                    ip2 = ip2.rotateRight();
                } else if (angle == 270.0) {
                    ip2 = ip.rotateLeft();
                }
                if (ip2 == null) break;
                imp.setProcessor(ip2);
                break;
            }
        }
        return imp;
    }

    public static ImagePlus openUsingImageIO(String path) {
        ImagePlus imp = null;
        BufferedImage img = null;
        File f = new File(path);
        try {
            img = ImageIO.read(f);
        }
        catch (Exception e) {
            IJ.error("Open Using ImageIO", "" + e);
        }
        if (img == null) {
            return null;
        }
        if (IJ.debugMode) {
            IJ.log("type=" + img.getType() + ", alpha=" + img.getColorModel().hasAlpha() + ", bands=" + img.getSampleModel().getNumBands());
        }
        if (img.getColorModel().hasAlpha()) {
            int width = img.getWidth();
            int height = img.getHeight();
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics g = bi.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
            g.drawImage(img, 0, 0, null);
            img = bi;
        }
        imp = new ImagePlus(f.getName(), img);
        FileInfo fi = new FileInfo();
        fi.fileFormat = 9;
        fi.fileName = f.getName();
        String parent = f.getParent();
        if (parent != null) {
            fi.directory = parent + File.separator;
        }
        imp.setFileInfo(fi);
        return imp;
    }

    public static void convertGrayJpegTo8Bits(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        if (ip.getBitDepth() == 24 && ip.isGrayscale()) {
            IJ.showStatus("Converting to 8-bit grayscale");
            new ImageConverter(imp).convertToGray8();
        }
    }

    boolean allSameSizeAndType(FileInfo[] info) {
        boolean sameSizeAndType = true;
        boolean contiguous = true;
        long startingOffset = info[0].getOffset();
        int size = info[0].width * info[0].height * info[0].getBytesPerPixel();
        for (int i = 1; i < info.length; ++i) {
            sameSizeAndType &= info[i].fileType == info[0].fileType && info[i].width == info[0].width && info[i].height == info[0].height;
            contiguous &= info[i].getOffset() == startingOffset + (long)(i * size);
        }
        if (contiguous && info[0].fileType != 12) {
            info[0].nImages = info.length;
        }
        return sameSizeAndType;
    }

    public ImagePlus openTiffStack(FileInfo[] info) {
        if (info.length > 1 && !this.allSameSizeAndType(info)) {
            return null;
        }
        FileInfo fi = info[0];
        if (fi.nImages > 1) {
            return new FileOpener(fi).openImage();
        }
        ColorModel cm = this.createColorModel(fi);
        ImageStack stack = new ImageStack(fi.width, fi.height, cm);
        Object pixels = null;
        long skip = fi.getOffset();
        int imageSize = fi.width * fi.height * fi.getBytesPerPixel();
        if (info[0].fileType == 13 && ((imageSize = (int)((double)(fi.width * fi.height) * 1.5)) & 1) == 1) {
            ++imageSize;
        }
        if (info[0].fileType == 8) {
            int scan = (int)Math.ceil((double)fi.width / 8.0);
            imageSize = scan * fi.height;
        }
        long loc = 0L;
        int nChannels = 1;
        try {
            InputStream is = this.createInputStream(fi);
            ImageReader reader = new ImageReader(fi);
            IJ.resetEscape();
            for (int i = 0; i < info.length; ++i) {
                int c;
                nChannels = 1;
                Object[] channels = null;
                if (!this.silentMode) {
                    IJ.showStatus("Reading: " + (i + 1) + "/" + info.length);
                }
                if (IJ.escapePressed()) {
                    IJ.beep();
                    IJ.showProgress(1.0);
                    return null;
                }
                fi.stripOffsets = info[i].stripOffsets;
                fi.stripLengths = info[i].stripLengths;
                int bpp = info[i].getBytesPerPixel();
                if (info[i].samplesPerPixel > 1 && bpp != 3 && bpp != 4 && bpp != 6) {
                    nChannels = fi.samplesPerPixel;
                    channels = new Object[nChannels];
                    for (c = 0; c < nChannels; ++c) {
                        channels[c] = pixels = reader.readPixels(is, c == 0 ? skip : 0L);
                    }
                } else {
                    pixels = reader.readPixels(is, skip);
                }
                if (pixels == null && channels == null) break;
                loc += (long)(imageSize * nChannels) + skip;
                if (i < info.length - 1) {
                    skip = info[i + 1].getOffset() - loc;
                    if (info[i + 1].compression >= 2) {
                        skip = 0L;
                    }
                    if (skip < 0L) {
                        IJ.error("Opener", "Unexpected image offset");
                        break;
                    }
                }
                if (fi.fileType == 12) {
                    Object[] pixels2 = (Object[])pixels;
                    stack.addSlice(null, pixels2[0]);
                    stack.addSlice(null, pixels2[1]);
                    stack.addSlice(null, pixels2[2]);
                    this.isRGB48 = true;
                } else if (nChannels > 1) {
                    for (c = 0; c < nChannels; ++c) {
                        if (channels[c] == null) continue;
                        stack.addSlice(null, channels[c]);
                    }
                } else {
                    stack.addSlice(null, pixels);
                }
                IJ.showProgress(i, info.length);
            }
            is.close();
        }
        catch (Exception e) {
            IJ.handleException(e);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(fi.fileName);
            stack.deleteLastSlice();
            stack.deleteLastSlice();
        }
        IJ.showProgress(1.0);
        if (stack.size() == 0) {
            return null;
        }
        if (fi.fileType == 2 || fi.fileType == 13 || fi.fileType == 4 || fi.fileType == 12) {
            ImageProcessor ip = stack.getProcessor(1);
            ip.resetMinAndMax();
            stack.update(ip);
        }
        ImagePlus imp = new ImagePlus(fi.fileName, stack);
        new FileOpener(fi).setCalibration(imp);
        imp.setFileInfo(fi);
        if (fi.info != null) {
            imp.setProperty("Info", fi.info);
        }
        if (fi.description != null && fi.description.contains("order=zct")) {
            new HyperStackConverter().shuffle(imp, 2);
        }
        int stackSize = stack.size();
        if (nChannels > 1 && stackSize % nChannels == 0) {
            imp.setDimensions(nChannels, stackSize / nChannels, 1);
            imp = new CompositeImage(imp, 1);
            imp.setOpenAsHyperStack(true);
        } else if (imp.getNChannels() > 1) {
            imp = this.makeComposite(imp, fi);
        }
        IJ.showProgress(1.0);
        return imp;
    }

    public ImagePlus openTiff(String directory, String name) {
        TiffDecoder td = new TiffDecoder(directory, name);
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        FileInfo[] info = null;
        try {
            info = td.getTiffInfo();
        }
        catch (IOException e) {
            this.fileType = 1;
            directory = IJ.addSeparator(directory);
            return this.openUsingHandleExtraFileTypes(directory + name);
        }
        if (info == null) {
            return null;
        }
        return this.openTiff2(info);
    }

    public ImagePlus openTiff(String path, int n) {
        TiffDecoder td = new TiffDecoder(this.getDir(path), this.getName(path));
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        FileInfo[] info = null;
        try {
            info = td.getTiffInfo();
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("Open TIFF", msg);
            return null;
        }
        if (info == null) {
            return null;
        }
        FileInfo fi = info[0];
        if (info.length == 1 && fi.nImages > 1) {
            if (n < 1 || n > fi.nImages) {
                throw new IllegalArgumentException("N out of 1-" + fi.nImages + " range");
            }
            long size = fi.width * fi.height * fi.getBytesPerPixel();
            fi.longOffset = fi.getOffset() + (long)(n - 1) * (size + fi.getGap());
            fi.offset = 0;
            fi.nImages = 1;
        } else {
            if (n < 1 || n > info.length) {
                throw new IllegalArgumentException("N out of 1-" + info.length + " range");
            }
            fi.longOffset = info[n - 1].getOffset();
            fi.offset = 0;
            fi.stripOffsets = info[n - 1].stripOffsets;
            fi.stripLengths = info[n - 1].stripLengths;
        }
        FileOpener fo = new FileOpener(fi);
        return fo.openImage();
    }

    public static FileInfo[] getTiffFileInfo(String path) {
        Opener o = new Opener();
        TiffDecoder td = new TiffDecoder(o.getDir(path), o.getName(path));
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        try {
            return td.getTiffInfo();
        }
        catch (IOException e) {
            return null;
        }
    }

    public ImagePlus openTiff(InputStream in, String name) {
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, name);
            if (IJ.debugMode) {
                td.enableDebugging();
            }
            info = td.getTiffInfo();
        }
        catch (FileNotFoundException e) {
            IJ.error("Open TIFF", "File not found: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            IJ.error("Open TIFF", "" + e);
            return null;
        }
        if (this.url != null && info != null && info.length == 1 && info[0].inputStream != null) {
            try {
                info[0].inputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                info[0].inputStream = new URL(this.url).openStream();
            }
            catch (Exception e) {
                IJ.error("Open TIFF", "" + e);
                return null;
            }
        }
        return this.openTiff2(info);
    }

    public ImagePlus openZip(String path) {
        ImagePlus imp = null;
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(path));
            ZipEntry entry = zis.getNextEntry();
            if (entry == null) {
                zis.close();
                return null;
            }
            String name = entry.getName();
            if (name.endsWith(".roi")) {
                zis.close();
                if (!this.silentMode) {
                    if (IJ.isMacro() && Interpreter.isBatchMode() && RoiManager.getInstance() == null) {
                        IJ.log("Use roiManager(\"Open\", path) instead of open(path)\nto open ROI sets in batch mode macros.");
                    } else {
                        IJ.runMacro("roiManager(\"Open\", getArgument());", path);
                    }
                }
                return null;
            }
            if (name.endsWith(".tif")) {
                imp = this.openTiff(zis, name);
            } else if (name.endsWith(".dcm")) {
                DICOM dcm = new DICOM(zis);
                dcm.run(name);
                imp = dcm;
            } else {
                zis.close();
                String msg = "This ZIP archive does not contain a TIFF or DICOM file, or ROIs:\n   " + path;
                if (this.silentMode) {
                    IJ.log(msg);
                } else {
                    IJ.error("Opener", msg);
                }
                return null;
            }
            zis.close();
        }
        catch (Exception e) {
            IJ.error("Opener", "" + e);
            return null;
        }
        File f = new File(path);
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            fi.fileFormat = 7;
            fi.fileName = f.getName();
            String parent = f.getParent();
            if (parent != null) {
                fi.directory = parent + File.separator;
            }
        }
        return imp;
    }

    public ImagePlus deserialize(byte[] bytes) {
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        TiffDecoder decoder = new TiffDecoder(stream, "Untitled");
        if (IJ.debugMode) {
            decoder.enableDebugging();
        }
        FileInfo[] info = null;
        try {
            info = decoder.getTiffInfo();
        }
        catch (IOException e) {
            return null;
        }
        FileOpener opener = new FileOpener(info[0]);
        ImagePlus imp = opener.openImage();
        if (imp == null) {
            return null;
        }
        imp.setTitle(info[0].fileName);
        imp = this.makeComposite(imp, info[0]);
        return imp;
    }

    private ImagePlus makeComposite(ImagePlus imp, FileInfo fi) {
        boolean composite;
        int c = imp.getNChannels();
        boolean bl = composite = c > 1 && fi.description != null && fi.description.indexOf("mode=") != -1;
        if (c > 1 && (imp.getOpenAsHyperStack() || composite) && !imp.isComposite() && imp.getType() != 4) {
            int mode = 2;
            if (fi.description != null) {
                if (fi.description.indexOf("mode=composite") != -1) {
                    mode = 1;
                } else if (fi.description.indexOf("mode=gray") != -1) {
                    mode = 3;
                }
            }
            imp = new CompositeImage(imp, mode);
        }
        return imp;
    }

    public String getName(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(i + 1);
        }
        return path;
    }

    public String getDir(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(0, i + 1);
        }
        return "";
    }

    ImagePlus openTiff2(FileInfo[] info) {
        long firstOffset;
        long lastOffset;
        if (info == null) {
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) {
            IJ.log(info[0].debugInfo);
        }
        if (info.length > 1 && (imp = this.openTiffStack(info)) != null) {
            return imp;
        }
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.openImage();
        if (imp == null) {
            return null;
        }
        int[] offsets = info[0].stripOffsets;
        if (offsets != null && offsets.length > 1 && (lastOffset = (long)offsets[offsets.length - 1] & 0xFFFFFFFFL) < (firstOffset = (long)offsets[0] & 0xFFFFFFFFL)) {
            IJ.run(imp, "Flip Vertically", "stack");
        }
        if ((imp = this.makeComposite(imp, info[0])).getBitDepth() == 32 && imp.getTitle().startsWith("FFT of")) {
            return this.openFFT(imp);
        }
        return imp;
    }

    private ImagePlus openFFT(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        FHT fht = new FHT(ip, true);
        ImageProcessor ps = fht.getPowerSpectrum();
        ImagePlus imp2 = new ImagePlus(imp.getTitle(), ps);
        imp2.setProperty("FHT", fht);
        imp2.setProperty("Info", imp.getInfoProperty());
        fht.originalWidth = (int)imp2.getNumericProperty("width");
        fht.originalHeight = (int)imp2.getNumericProperty("height");
        fht.originalBitDepth = (int)imp2.getNumericProperty("bitdepth");
        fht.originalColorModel = ip.getColorModel();
        imp2.setCalibration(imp.getCalibration());
        return imp2;
    }

    public Roi openRoi(String path) {
        Roi roi = null;
        RoiDecoder rd = new RoiDecoder(path);
        try {
            roi = rd.getRoi();
        }
        catch (IOException e) {
            IJ.error("RoiDecoder", e.getMessage());
            return null;
        }
        return roi;
    }

    public static ImagePlus openUsingBioFormats(String path) {
        String className = "loci.plugins.BF";
        String methodName = "openImagePlus";
        try {
            ImagePlus[] images;
            Class<?> c = IJ.getClassLoader().loadClass(className);
            if (c == null) {
                return null;
            }
            Class[] argClasses = new Class[]{methodName.getClass()};
            Method m = c.getMethod(methodName, argClasses);
            Object[] args = new Object[]{path};
            Object obj = m.invoke(null, args);
            ImagePlus[] imagePlusArray = images = obj != null ? (ImagePlus[])obj : null;
            if (images == null || images.length == 0) {
                return null;
            }
            ImagePlus imp = images[0];
            return imp;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static LUT openLut(String filePathOrUrl) {
        return LutLoader.openLut(filePathOrUrl);
    }

    public static void openResultsTable(String path) {
        try {
            ResultsTable rt = ResultsTable.open(path);
            if (rt != null) {
                rt.showRowNumbers(true);
                rt.show("Results");
            }
        }
        catch (IOException e) {
            IJ.error("Open Results", e.getMessage());
        }
    }

    public static void openTable(String path) {
        String name = "";
        if (path == null || path.equals("")) {
            OpenDialog od = new OpenDialog("Open Table...");
            String dir = od.getDirectory();
            name = od.getFileName();
            if (name == null) {
                return;
            }
            path = dir + name;
        } else {
            name = new Opener().getName(path);
            if (name.startsWith("Results.")) {
                name = "Results";
            }
        }
        try {
            ResultsTable rt = ResultsTable.open(path);
            if (rt != null) {
                rt.show(name);
            }
        }
        catch (IOException e) {
            IJ.error("Open Table", e.getMessage());
        }
    }

    public static String getFileFormat(String path) {
        if (!new File(path).exists()) {
            return "not found";
        }
        return types[new Opener().getFileType(path)];
    }

    public int getFileType(String path) {
        if (openUsingPlugins && !path.endsWith(".txt") && !path.endsWith(".java")) {
            return 0;
        }
        File file = new File(path);
        String name = file.getName();
        byte[] buf = new byte[132];
        try {
            FileInputStream is = new FileInputStream(file);
            ((InputStream)is).read(buf, 0, 132);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            return 0;
        }
        int b0 = buf[0] & 0xFF;
        int b1 = buf[1] & 0xFF;
        int b2 = buf[2] & 0xFF;
        int b3 = buf[3] & 0xFF;
        if (buf[128] == 68 && buf[129] == 73 && buf[130] == 67 && buf[131] == 77 && (b0 == 73 && b1 == 73 || b0 == 77 && b1 == 77)) {
            return 14;
        }
        if (name.endsWith(".lsm")) {
            return 0;
        }
        if (!(b0 != 73 || b1 != 73 || b2 != 42 || b3 != 0 || bioformats && name.endsWith(".flex"))) {
            return 1;
        }
        if (b0 == 77 && b1 == 77 && b2 == 0 && b3 == 42) {
            return 1;
        }
        if (b0 == 255 && b1 == 216 && b2 == 255) {
            return 5;
        }
        if (b0 == 71 && b1 == 73 && b2 == 70 && b3 == 56) {
            return 6;
        }
        name = name.toLowerCase(Locale.US);
        if (buf[128] == 68 && buf[129] == 73 && buf[130] == 67 && buf[131] == 77 || name.endsWith(".dcm")) {
            return 2;
        }
        if (!(b0 != 8 && b0 != 2 || b1 != 0 || b3 != 0 || name.endsWith(".spe") || name.equals("fid"))) {
            return 2;
        }
        if (!(b0 != 80 || b1 != 49 && b1 != 52 && b1 != 50 && b1 != 53 && b1 != 51 && b1 != 54 || b2 != 10 && b2 != 13 && b2 != 32 && b2 != 9)) {
            return 4;
        }
        if (name.endsWith(".lut")) {
            return 7;
        }
        if (b0 == 137 && b1 == 80 && b2 == 78 && b3 == 71) {
            return 13;
        }
        if (name.endsWith(".zip")) {
            return 9;
        }
        if (b0 == 83 && b1 == 73 && b2 == 77 && b3 == 80 || name.endsWith(".fts.gz") || name.endsWith(".fits.gz")) {
            return 3;
        }
        if (name.endsWith(".java") || name.endsWith(".txt") || name.endsWith(".ijm") || name.endsWith(".js") || name.endsWith(".bsh") || name.endsWith(".py") || name.endsWith(".html")) {
            return 10;
        }
        if (b0 == 73 && b1 == 111) {
            return 11;
        }
        if (b0 == 111 && b1 == 106 && b2 == 106 && b3 == 0 || name.endsWith(".ojj")) {
            return 17;
        }
        if (name.endsWith(".xls") || name.endsWith(".csv") || name.endsWith(".tsv")) {
            return 18;
        }
        if (name.endsWith(".avi")) {
            return 16;
        }
        boolean isText = true;
        for (int i = 0; i < 10; ++i) {
            int c = buf[i] & 0xFF;
            if ((c >= 32 || c == 9 || c == 10 || c == 13) && c <= 126) continue;
            isText = false;
            break;
        }
        if (isText) {
            return 12;
        }
        if (b0 == 66 && b1 == 77 || name.endsWith(".dib")) {
            return 8;
        }
        if (name.endsWith(".raw") && !Prefs.skipRawDialog) {
            return 19;
        }
        return 0;
    }

    ColorModel createColorModel(FileInfo fi) {
        if (fi.lutSize > 0) {
            return new IndexColorModel(8, fi.lutSize, fi.reds, fi.greens, fi.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fi.whiteIsZero);
    }

    InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        if (fi.inputStream != null) {
            return fi.inputStream;
        }
        if (fi.url != null && !fi.url.equals("")) {
            return new URL(fi.url + fi.fileName).openStream();
        }
        File f = new File(fi.getFilePath());
        if (f == null || f.isDirectory()) {
            return null;
        }
        InputStream is = new FileInputStream(f);
        if (fi.compression >= 2 || fi.stripOffsets != null && fi.stripOffsets.length > 1) {
            is = new RandomAccessStream(is);
        }
        return is;
    }

    void openRGB48(ImagePlus imp) {
        this.isRGB48 = false;
        int stackSize = imp.getStackSize();
        imp.setDimensions(3, stackSize / 3, 1);
        imp = new CompositeImage(imp, 1);
        imp.show();
    }

    public void setSilentMode(boolean mode) {
        this.silentMode = mode;
    }

    public static void setOpenUsingPlugins(boolean b) {
        openUsingPlugins = b;
    }

    public static boolean getOpenUsingPlugins() {
        return openUsingPlugins;
    }

    static /* synthetic */ File[] access$002(Opener x0, File[] x1) {
        x0.omFiles = x1;
        return x1;
    }

    static {
        Hashtable commands = Menus.getCommands();
        bioformats = commands != null && commands.get("Bio-Formats Importer") != null;
    }
}

