/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.ContrastAdjuster;
import ij.plugin.frame.Recorder;
import ij.process.LUT;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;

public class AppearanceOptions
implements PlugIn,
DialogListener {
    private boolean interpolate = Prefs.interpolateScaledImages;
    private boolean open100 = Prefs.open100Percent;
    private boolean black = Prefs.blackCanvas;
    private boolean noBorder = Prefs.noBorder;
    private boolean inverting = Prefs.useInvertingLut;
    private int rangeIndex = ContrastAdjuster.get16bitRangeIndex();
    private LUT[] luts = this.getLuts();
    private int menuFontSize = Menus.getFontSize();
    private double saveScale = Prefs.getGuiScale();
    private boolean redrawn;
    private boolean repainted;

    @Override
    public void run(String arg) {
        this.showDialog();
    }

    void showDialog() {
        int range;
        boolean fontSizeChanged;
        String[] ranges = ContrastAdjuster.getSixteenBitRanges();
        GenericDialog gd = new GenericDialog("Appearance");
        gd.addCheckbox("Interpolate zoomed images", Prefs.interpolateScaledImages);
        gd.addCheckbox("Open images at 100%", Prefs.open100Percent);
        gd.addCheckbox("Black canvas", Prefs.blackCanvas);
        gd.addCheckbox("No image border", Prefs.noBorder);
        gd.addCheckbox("Use inverting lookup table", Prefs.useInvertingLut);
        gd.addCheckbox("Auto contrast stacks", Prefs.autoContrast);
        gd.addCheckbox("IJ window always on top", Prefs.alwaysOnTop);
        if (IJ.isLinux()) {
            gd.addCheckbox("Cancel button on right", Prefs.dialogCancelButtonOnRight);
        }
        gd.addChoice("16-bit range:", ranges, ranges[this.rangeIndex]);
        Font font = new Font("SansSerif", 0, 9);
        if (!IJ.isMacOSX()) {
            gd.setInsets(0, 0, 0);
            gd.addNumericField("Menu font size:", Menus.getFontSize(), 0, 4, "points");
            if (IJ.isWindows()) {
                gd.setInsets(2, 30, 5);
                gd.addMessage("Setting size>17 may not work on Windows", font);
            }
        }
        gd.setInsets(0, 0, 0);
        gd.addNumericField("GUI scale (0.5-3.0):", Prefs.getGuiScale(), 2, 5, "");
        gd.setInsets(2, 20, 0);
        gd.addMessage("Set to 1.5 to double size of tool icons, or 2.5 to triple", font);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#appearance");
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            Prefs.interpolateScaledImages = this.interpolate;
            Prefs.open100Percent = this.open100;
            Prefs.blackCanvas = this.black;
            Prefs.noBorder = this.noBorder;
            Prefs.useInvertingLut = this.inverting;
            Prefs.setGuiScale(this.saveScale);
            if (this.redrawn) {
                this.draw();
            }
            if (this.repainted) {
                this.repaintWindow();
            }
            Prefs.open100Percent = this.open100;
            if (this.rangeIndex != ContrastAdjuster.get16bitRangeIndex()) {
                Calibration cal;
                ContrastAdjuster.set16bitRange(this.rangeIndex);
                ImagePlus imp = WindowManager.getCurrentImage();
                Calibration calibration = cal = imp != null ? imp.getCalibration() : null;
                if (imp != null && imp.getType() == 1 && !cal.isSigned16Bit()) {
                    imp.resetDisplayRange();
                    if (this.rangeIndex == 0 && imp.isComposite() && this.luts != null) {
                        ((CompositeImage)imp).setLuts(this.luts);
                    }
                    imp.updateAndDraw();
                }
            }
            return;
        }
        boolean messageShown = false;
        double scale = Prefs.getGuiScale();
        if (scale != this.saveScale) {
            if (!IJ.isMacOSX()) {
                IJ.showMessage("Appearance", "Restart ImageJ to resize \"ImageJ\" window");
                messageShown = true;
            } else {
                ImageJ ij = IJ.getInstance();
                if (ij != null) {
                    ij.resize();
                }
            }
        }
        boolean bl = fontSizeChanged = this.menuFontSize != Menus.getFontSize();
        if (fontSizeChanged) {
            Menus.setFontSize(this.menuFontSize);
        }
        if (!messageShown && fontSizeChanged && !IJ.isMacOSX()) {
            IJ.showMessage("Appearance", "Restart ImageJ to use the new font size");
        }
        if (Prefs.useInvertingLut) {
            IJ.showMessage("Appearance", "The \"Use inverting lookup table\" option is set. Newly opened\n8-bit images will use an inverting LUT (white=0, black=255).");
        }
        if ((range = ImagePlus.getDefault16bitRange()) > 0 && Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("ImagePlus.setDefault16bitRange(" + range + ");");
            } else {
                Recorder.recordString("call(\"ij.ImagePlus.setDefault16bitRange\", " + range + ");\n");
            }
        }
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        Calibration cal;
        ImageJ ij;
        if (IJ.isMacOSX()) {
            IJ.wait(100);
        }
        boolean interpolate = gd.getNextBoolean();
        Prefs.open100Percent = gd.getNextBoolean();
        boolean blackCanvas = gd.getNextBoolean();
        boolean noBorder = gd.getNextBoolean();
        Prefs.useInvertingLut = gd.getNextBoolean();
        boolean alwaysOnTop = Prefs.alwaysOnTop;
        Prefs.autoContrast = gd.getNextBoolean();
        Prefs.alwaysOnTop = gd.getNextBoolean();
        if (IJ.isLinux()) {
            Prefs.dialogCancelButtonOnRight = gd.getNextBoolean();
        }
        if (!IJ.isMacOSX()) {
            this.menuFontSize = (int)gd.getNextNumber();
        }
        Prefs.setGuiScale(gd.getNextNumber());
        if (interpolate != Prefs.interpolateScaledImages) {
            Prefs.interpolateScaledImages = interpolate;
            this.draw();
        }
        if (blackCanvas != Prefs.blackCanvas) {
            Prefs.blackCanvas = blackCanvas;
            this.repaintWindow();
        }
        if (noBorder != Prefs.noBorder) {
            Prefs.noBorder = noBorder;
            this.repaintWindow();
        }
        if (alwaysOnTop != Prefs.alwaysOnTop && (ij = IJ.getInstance()) != null) {
            ij.setAlwaysOnTop(Prefs.alwaysOnTop);
        }
        int rangeIndex2 = gd.getNextChoiceIndex();
        int range1 = ImagePlus.getDefault16bitRange();
        int range2 = ContrastAdjuster.set16bitRange(rangeIndex2);
        ImagePlus imp = WindowManager.getCurrentImage();
        Calibration calibration = cal = imp != null ? imp.getCalibration() : null;
        if (range1 != range2 && imp != null && imp.getType() == 1 && !cal.isSigned16Bit()) {
            imp.resetDisplayRange();
            if (rangeIndex2 == 0 && imp.isComposite() && this.luts != null) {
                ((CompositeImage)imp).setLuts(this.luts);
            }
            imp.updateAndDraw();
        }
        return true;
    }

    private LUT[] getLuts() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getBitDepth() != 16 || !imp.isComposite()) {
            return null;
        }
        return ((CompositeImage)imp).getLuts();
    }

    void draw() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.draw();
        }
        this.redrawn = true;
    }

    void repaintWindow() {
        ImageWindow win;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (win = imp.getWindow()) != null) {
            if (Prefs.blackCanvas) {
                win.setForeground(Color.white);
                win.setBackground(Color.black);
            } else {
                win.setForeground(Color.black);
                win.setBackground(Color.white);
            }
            imp.repaintWindow();
        }
        this.repainted = true;
    }
}

