/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.plugin.PluginInstaller;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.awt.Color;
import java.awt.Menu;
import java.awt.MenuItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;

public class URLOpener
implements PlugIn {
    private static String url = "http://imagej.nih.gov/ij/images/clown.gif";

    @Override
    public void run(String urlOrName) {
        if (!urlOrName.equals("")) {
            if (urlOrName.equals("cache")) {
                this.cacheSampleImages();
            } else if (urlOrName.endsWith("StartupMacros.txt")) {
                this.openTextFile(urlOrName, true);
            } else {
                double startTime = System.currentTimeMillis();
                String url = URLOpener.imageURL(urlOrName);
                ImagePlus imp = new ImagePlus(url);
                if (Recorder.record) {
                    Recorder.recordCall("imp = IJ.openImage(\"" + url + "\");");
                }
                if (imp.getType() == 4) {
                    Opener.convertGrayJpegTo8Bits(imp);
                }
                WindowManager.checkForDuplicateName = true;
                FileInfo fi = imp.getOriginalFileInfo();
                if (fi != null && fi.fileType == 12) {
                    imp = new CompositeImage(imp, 1);
                } else if (imp.getNChannels() > 1 && fi != null && fi.description != null && fi.description.indexOf("mode=") != -1) {
                    int mode = 2;
                    if (fi.description.indexOf("mode=composite") != -1) {
                        mode = 1;
                    } else if (fi.description.indexOf("mode=gray") != -1) {
                        mode = 3;
                    }
                    imp = new CompositeImage(imp, mode);
                }
                if (fi != null && (fi.url == null || fi.url.length() == 0)) {
                    fi.url = url;
                    imp.setFileInfo(fi);
                }
                imp.show(Opener.getLoadRate(startTime, imp));
                String title = imp.getTitle();
                if (title != null && (title.startsWith("flybrain") || title.startsWith("t1-head"))) {
                    imp.setSlice(imp.getStackSize() / 2);
                }
            }
            return;
        }
        GenericDialog gd = new GenericDialog("Enter a URL");
        gd.setInsets(10, 32, 0);
        gd.addMessage("Enter URL of an image, macro or web page", null, Color.darkGray);
        gd.addStringField("URL:", url, 45);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        url = gd.getNextString();
        if ((url = url.trim()).indexOf("://") == -1) {
            url = "http://" + url;
        }
        if (url.endsWith("/")) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url.substring(0, url.length() - 1));
        } else if (url.endsWith(".html") || url.endsWith(".htm") || url.endsWith(".pdf") || url.indexOf(".html#") > 0 || this.noExtension(url)) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url);
        } else if (url.endsWith(".txt") || url.endsWith(".ijm") || url.endsWith(".js") || url.endsWith(".java")) {
            this.openTextFile(url, false);
        } else if (url.endsWith(".jar") || url.endsWith(".class")) {
            IJ.open(url);
        } else {
            IJ.showStatus("Opening: " + url);
            double startTime = System.currentTimeMillis();
            ImagePlus imp = new ImagePlus(url);
            WindowManager.checkForDuplicateName = true;
            FileInfo fi = imp.getOriginalFileInfo();
            if (fi != null && fi.fileType == 12) {
                imp = new CompositeImage(imp, 1);
            } else if (imp.getNChannels() > 1 && fi != null && fi.description != null && fi.description.indexOf("mode=") != -1) {
                int mode = 2;
                if (fi.description.indexOf("mode=composite") != -1) {
                    mode = 1;
                } else if (fi.description.indexOf("mode=gray") != -1) {
                    mode = 3;
                }
                imp = new CompositeImage(imp, mode);
            }
            if (fi != null && (fi.url == null || fi.url.length() == 0)) {
                fi.url = url;
                imp.setFileInfo(fi);
            }
            imp.show(Opener.getLoadRate(startTime, imp));
        }
        IJ.register(URLOpener.class);
    }

    private static String imageURL(String urlOrName) {
        return urlOrName.indexOf("://") > 0 ? urlOrName : Prefs.getImagesURL() + urlOrName;
    }

    boolean noExtension(String url) {
        int lastDot;
        int lastSlash = url.lastIndexOf("/");
        if (lastSlash == -1) {
            lastSlash = 0;
        }
        return (lastDot = url.lastIndexOf(".")) == -1 || lastDot < lastSlash || url.length() - lastDot > 6;
    }

    void openTextFile(String urlString, boolean install) {
        StringBuffer sb = null;
        try {
            String line;
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            if (!install || !urlString.endsWith("StartupMacros.txt")) {
                IJ.error("URL Opener", "" + e);
            }
            sb = null;
        }
        if (sb != null) {
            if (install) {
                new MacroInstaller().install(new String(sb));
            } else {
                int index = urlString.lastIndexOf("/");
                if (index != -1 && index <= urlString.length() - 1) {
                    urlString = urlString.substring(index + 1);
                }
                new Editor().create(urlString, new String(sb));
            }
        }
    }

    private void cacheSampleImages() {
        boolean ok;
        String[] names = URLOpener.getSampleImageNames();
        int n = names.length;
        if (n == 0) {
            return;
        }
        String dir = IJ.getDirectory("imagej") + "samples";
        File f = new File(dir);
        if (!f.exists() && !(ok = f.mkdir())) {
            IJ.error("Unable to create directory:\n \n" + dir);
            return;
        }
        IJ.resetEscape();
        for (int i = 0; i < n; ++i) {
            IJ.showStatus(i + 1 + "/" + n + " (" + names[i] + ")");
            String url = URLOpener.imageURL(names[i]);
            byte[] data = PluginInstaller.download(url, null);
            if (data == null) continue;
            f = new File(dir, names[i].substring(names[i].lastIndexOf("/") + 1));
            try {
                FileOutputStream out = new FileOutputStream(f);
                out.write(data, 0, data.length);
                out.close();
            }
            catch (IOException e) {
                IJ.log(names[i] + ": " + e);
            }
            if (!IJ.escapePressed()) continue;
            IJ.beep();
            break;
        }
        IJ.showStatus("");
    }

    public static String[] getSampleImageNames() {
        ArrayList<String> list = new ArrayList<String>();
        Hashtable commands = Menus.getCommands();
        Menu samplesMenu = Menus.getImageJMenu("File>Open Samples");
        if (samplesMenu == null) {
            return new String[0];
        }
        for (int i = 0; i < samplesMenu.getItemCount(); ++i) {
            String[] items;
            String command;
            String label;
            MenuItem menuItem = samplesMenu.getItem(i);
            if (menuItem.getActionListeners().length == 0 || (label = menuItem.getLabel()).contains("Cache Sample Images") || (command = (String)commands.get(label)) == null || (items = command.split("\"")).length != 3) continue;
            String name = items[1];
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }
}

