/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Undo;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Rotator
implements ExtendedPlugInFilter,
DialogListener {
    public static final String GRID = "|GRID|";
    private int flags = 32863;
    private static double angle = 15.0;
    private static boolean fillWithBackground;
    private static boolean enlarge;
    private static int gridLines;
    private ImagePlus imp;
    private int bitDepth;
    private boolean canEnlarge;
    private boolean isEnlarged;
    private GenericDialog gd;
    private PlugInFilterRunner pfr;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private static int interpolationMethod;
    private Overlay overlay;
    private boolean done;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp != null) {
            this.bitDepth = imp.getBitDepth();
            Roi roi = imp.getRoi();
            if (roi != null && roi.isLine()) {
                roi = null;
            }
            this.overlay = imp.getOverlay();
            if (roi != null && this.overlay != null && Macro.getOptions() == null) {
                String msg = "This image has an overlay so the\nselection will be removed.";
                if (!IJ.showMessageWithCancel("Rotator", msg)) {
                    return 4096;
                }
                imp.deleteRoi();
            }
            Rectangle r = roi != null ? roi.getBounds() : null;
            boolean bl = this.canEnlarge = r == null || r.x == 0 && r.y == 0 && r.width == imp.getWidth() && r.height == imp.getHeight();
            if (imp.getDisplayMode() == 1) {
                Undo.setup(6, imp);
                this.flags |= 0x80000;
            }
            Undo.saveOverlay(imp);
            if (this.overlay == null) {
                this.overlay = new Overlay();
            }
        }
        return this.flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ImageProcessor ip) {
        Overlay ovly;
        Overlay overlay2;
        if (enlarge && this.gd.wasOKed()) {
            Rotator rotator = this;
            synchronized (rotator) {
                if (!this.isEnlarged) {
                    this.enlargeCanvas();
                    this.isEnlarged = true;
                }
            }
        }
        if (this.isEnlarged) {
            int slice = this.pfr.getSliceNumber();
            ip = this.imp.getStackSize() == 1 ? this.imp.getProcessor() : this.imp.getStack().getProcessor(slice);
        }
        ip.setInterpolationMethod(interpolationMethod);
        if (fillWithBackground) {
            ip.setBackgroundColor(Toolbar.getBackgroundColor());
        } else {
            ip.setBackgroundValue(0.0);
        }
        ip.rotate(angle);
        if (!this.gd.wasOKed()) {
            this.drawGridLines(gridLines);
        }
        if (this.overlay != null && !this.imp.getHideOverlay() && (overlay2 = this.overlay.rotate(angle, ip.getWidth() / 2, ip.getHeight() / 2)) != null && overlay2.size() > 0) {
            this.imp.setOverlay(overlay2);
        }
        if (this.isEnlarged && this.imp.getStackSize() == 1) {
            this.imp.changes = true;
            this.imp.updateAndDraw();
            Undo.setup(5, this.imp);
        }
        if (this.done && (ovly = this.imp.getOverlay()) != null) {
            ovly.remove(GRID);
            if (ovly.size() == 0) {
                this.imp.setOverlay(null);
            }
        }
    }

    void enlargeCanvas() {
        this.imp.unlock();
        IJ.run(this.imp, "Select All", "");
        IJ.run(this.imp, "Rotate...", "angle=" + angle);
        Roi roi = this.imp.getRoi();
        this.imp.deleteRoi();
        Rectangle2D.Double fb = roi.getFloatBounds();
        Rectangle r = new Rectangle((int)Math.round(fb.x), (int)Math.round(fb.y), (int)Math.round(fb.width), (int)Math.round(fb.height));
        if (r.width < this.imp.getWidth()) {
            r.width = this.imp.getWidth();
        }
        if (r.height < this.imp.getHeight()) {
            r.height = this.imp.getHeight();
        }
        IJ.showStatus("Rotate: Enlarging...");
        if (this.imp.getStackSize() == 1) {
            Undo.setup(4, this.imp);
        }
        IJ.run(this.imp, "Canvas Size...", "width=" + r.width + " height=" + r.height + " position=Center " + (fillWithBackground ? "" : "zero"));
        IJ.showStatus("Rotating...");
    }

    void drawGridLines(int lines) {
        if (this.overlay == null) {
            return;
        }
        this.overlay.remove(GRID);
        if (lines == 0) {
            return;
        }
        GeneralPath path = new GeneralPath();
        float width = this.imp.getWidth();
        float height = this.imp.getHeight();
        float xinc = width / (float)lines;
        float yinc = height / (float)lines;
        float xstart = xinc / 2.0f;
        float ystart = yinc / 2.0f;
        for (int i = 0; i < lines; ++i) {
            path.moveTo(xstart + xinc * (float)i, 0.0f);
            path.lineTo(xstart + xinc * (float)i, height);
            path.moveTo(0.0f, ystart + yinc * (float)i);
            path.lineTo(width, ystart + yinc * (float)i);
        }
        ShapeRoi roi = new ShapeRoi(path);
        roi.setName(GRID);
        roi.setStrokeWidth(0.0f);
        this.overlay.add(roi);
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.pfr = pfr;
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            if (macroOptions.indexOf(" interpolate") != -1) {
                macroOptions.replaceAll(" interpolate", " interpolation=Bilinear");
            } else if (macroOptions.indexOf(" interpolation=") == -1) {
                macroOptions = macroOptions + " interpolation=None";
            }
            Macro.setOptions(macroOptions);
        }
        this.gd = new GenericDialog("Rotate");
        this.gd.addSlider("Angle:", -90.0, 90.0, angle, 0.1);
        this.gd.addNumericField("Grid lines:", gridLines, 0);
        this.gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        this.gd.addCheckbox("Fill with background color", fillWithBackground);
        if (this.canEnlarge) {
            this.gd.addCheckbox("Enlarge image", enlarge);
        } else {
            enlarge = false;
        }
        this.gd.addPreviewCheckbox(pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            if (this.overlay.size() > 0) {
                this.overlay.remove(GRID);
                imp.setOverlay(this.overlay);
            }
            return 4096;
        }
        Overlay ovly = imp.getOverlay();
        if (ovly != null) {
            ovly.remove(GRID);
            if (ovly.size() == 0) {
                imp.setOverlay(null);
            }
        }
        if (enlarge) {
            this.flags |= 0x80;
        } else if (imp.getStackSize() == 1) {
            this.flags |= 0x1000000;
        }
        this.done = true;
        return IJ.setupDialog(imp, this.flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        angle = gd.getNextNumber();
        if (gd.invalidNumber()) {
            if (gd.wasOKed()) {
                IJ.error("Angle is invalid.");
            }
            return false;
        }
        gridLines = (int)gd.getNextNumber();
        interpolationMethod = gd.getNextChoiceIndex();
        fillWithBackground = gd.getNextBoolean();
        if (this.canEnlarge) {
            enlarge = gd.getNextBoolean();
        }
        return true;
    }

    public static double getAngle() {
        return angle;
    }

    @Override
    public void setNPasses(int nPasses) {
    }

    static {
        gridLines = 1;
        interpolationMethod = 1;
    }
}

