/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.text.TextPanel;
import java.awt.CheckboxMenuItem;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class TextWindow
extends Frame
implements ActionListener,
FocusListener,
ItemListener {
    public static final String LOC_KEY = "results.loc";
    public static final String WIDTH_KEY = "results.width";
    public static final String HEIGHT_KEY = "results.height";
    public static final String LOG_LOC_KEY = "log.loc";
    public static final String LOG_WIDTH_KEY = "log.width";
    public static final String LOG_HEIGHT_KEY = "log.height";
    public static final String DEBUG_LOC_KEY = "debug.loc";
    static final String FONT_SIZE = "tw.font.size";
    static final String FONT_ANTI = "tw.font.anti";
    TextPanel textPanel;
    CheckboxMenuItem antialiased;
    int[] sizes = new int[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 36, 48, 60, 72};
    int fontSize = (int)Prefs.get("tw.font.size", 5.0);
    MenuBar mb;
    private static Font font;
    private boolean isResultsTable;

    public TextWindow(String title, String text, int width, int height) {
        this(title, "", text, width, height);
    }

    public TextWindow(String title, String headings, String text, int width, int height) {
        super(title);
        this.textPanel = new TextPanel(title);
        this.textPanel.setColumnHeadings(headings);
        if (text != null && !text.equals("")) {
            this.textPanel.append(text);
        }
        this.create(title, this.textPanel, width, height);
    }

    public TextWindow(String title, String headings, ArrayList text, int width, int height) {
        super(title);
        this.textPanel = new TextPanel(title);
        this.textPanel.setColumnHeadings(headings);
        if (text != null) {
            this.textPanel.append(text);
        }
        this.create(title, this.textPanel, width, height);
    }

    private void create(String title, TextPanel textPanel, int width, int height) {
        this.enableEvents(64L);
        if (IJ.isLinux()) {
            this.setBackground(ImageJ.backgroundColor);
        }
        this.add("Center", textPanel);
        this.addKeyListener(textPanel);
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            Image img;
            textPanel.addKeyListener(ij);
            if (!IJ.isMacOSX() && (img = ij.getIconImage()) != null) {
                try {
                    this.setIconImage(img);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.addFocusListener(this);
        String title2 = this.getTitle();
        this.isResultsTable = title2.equals("Results");
        if (!this.isResultsTable && title2.endsWith("(Results)")) {
            this.isResultsTable = true;
            title2 = title2.substring(0, title2.length() - 9);
            this.setTitle(title2);
            textPanel.title = title2;
        }
        this.addMenuBar();
        this.setFont();
        WindowManager.addWindow(this);
        Point loc = null;
        int w = 0;
        int h = 0;
        if (title.equals("Results")) {
            loc = Prefs.getLocation(LOC_KEY);
            w = (int)Prefs.get(WIDTH_KEY, 0.0);
            h = (int)Prefs.get(HEIGHT_KEY, 0.0);
        } else if (title.equals("Log")) {
            loc = Prefs.getLocation(LOG_LOC_KEY);
            w = (int)Prefs.get(LOG_WIDTH_KEY, 0.0);
            h = (int)Prefs.get(LOG_HEIGHT_KEY, 0.0);
        } else if (title.equals("Debug")) {
            loc = Prefs.getLocation(DEBUG_LOC_KEY);
            w = width;
            h = height;
        }
        if (loc != null && w > 0 && h > 0) {
            this.setSize(w, h);
            this.setLocation(loc);
        } else {
            this.setSize(width, height);
            if (!IJ.debugMode) {
                GUI.centerOnImageJScreen(this);
            }
        }
        this.show();
        WindowManager.setWindow(this);
    }

    public TextWindow(String path, int width, int height) {
        super("");
        this.enableEvents(64L);
        this.textPanel = new TextPanel();
        this.textPanel.addKeyListener(IJ.getInstance());
        this.add("Center", this.textPanel);
        if (this.openFile(path)) {
            WindowManager.addWindow(this);
            this.setSize(width, height);
            this.show();
            WindowManager.setWindow(this);
        } else {
            this.dispose();
        }
    }

    void addMenuBar() {
        this.mb = new MenuBar();
        if (Menus.getFontSize() != 0) {
            this.mb.setFont(Menus.getFont());
        }
        Menu m = new Menu("File");
        m.add(new MenuItem("Save As...", new MenuShortcut(83)));
        if (this.isResultsTable) {
            m.add(new MenuItem("Rename..."));
            m.add(new MenuItem("Duplicate..."));
        }
        m.addActionListener(this);
        this.mb.add(m);
        this.textPanel.fileMenu = m;
        m = new Menu("Edit");
        m.add(new MenuItem("Cut", new MenuShortcut(88)));
        m.add(new MenuItem("Copy", new MenuShortcut(67)));
        m.add(new MenuItem("Clear"));
        m.add(new MenuItem("Select All", new MenuShortcut(65)));
        m.addSeparator();
        m.add(new MenuItem("Find...", new MenuShortcut(70)));
        m.add(new MenuItem("Find Next", new MenuShortcut(71)));
        m.addActionListener(this);
        this.mb.add(m);
        this.textPanel.editMenu = m;
        m = new Menu("Font");
        m.add(new MenuItem("Make Text Smaller"));
        m.add(new MenuItem("Make Text Larger"));
        m.addSeparator();
        this.antialiased = new CheckboxMenuItem("Antialiased", Prefs.get(FONT_ANTI, IJ.isMacOSX()));
        this.antialiased.addItemListener(this);
        m.add(this.antialiased);
        m.add(new MenuItem("Save Settings"));
        m.addActionListener(this);
        this.mb.add(m);
        if (this.isResultsTable) {
            m = new Menu("Results");
            m.add(new MenuItem("Clear Results"));
            m.add(new MenuItem("Summarize"));
            m.add(new MenuItem("Distribution..."));
            m.add(new MenuItem("Set Measurements..."));
            m.add(new MenuItem("Sort..."));
            m.add(new MenuItem("Plot..."));
            m.add(new MenuItem("Options..."));
            m.addActionListener(this);
            this.mb.add(m);
        }
        this.setMenuBar(this.mb);
    }

    public void append(String text) {
        this.textPanel.append(text);
    }

    void setFont() {
        if (font != null) {
            this.textPanel.setFont(font, this.antialiased.getState());
        } else {
            this.textPanel.setFont(new Font("SanSerif", 0, this.sizes[this.fontSize]), this.antialiased.getState());
        }
    }

    boolean openFile(String path) {
        OpenDialog od = new OpenDialog("Open Text File...", path);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return false;
        }
        path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            this.load(r);
            r.close();
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return true;
        }
        this.textPanel.setTitle(name);
        this.setTitle(name);
        IJ.showStatus("");
        return true;
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public ResultsTable getResultsTable() {
        return this.textPanel != null ? this.textPanel.getResultsTable() : null;
    }

    public void load(BufferedReader in) throws IOException {
        String s;
        boolean count = false;
        while ((s = in.readLine()) != null) {
            this.textPanel.appendLine(s);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("Make Text Larger")) {
            this.changeFontSize(true);
        } else if (cmd.equals("Make Text Smaller")) {
            this.changeFontSize(false);
        } else if (cmd.equals("Save Settings")) {
            this.saveSettings();
        } else {
            this.textPanel.doCommand(cmd);
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        int id = e.getID();
        if (id == 201) {
            this.close();
        } else if (id == 205 && !"Log".equals(this.getTitle())) {
            WindowManager.setWindow(this);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setFont();
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean showDialog) {
        if (this.getTitle().equals("Results")) {
            if (showDialog && !Analyzer.resetCounter()) {
                return;
            }
            IJ.setTextPanel(null);
            Prefs.saveLocation(LOC_KEY, this.getLocation());
            Dimension d = this.getSize();
            Prefs.set(WIDTH_KEY, d.width);
            Prefs.set(HEIGHT_KEY, d.height);
        } else if (this.getTitle().equals("Log")) {
            Prefs.saveLocation(LOG_LOC_KEY, this.getLocation());
            Dimension d = this.getSize();
            Prefs.set(LOG_WIDTH_KEY, d.width);
            Prefs.set(LOG_HEIGHT_KEY, d.height);
            IJ.setDebugMode(false);
            IJ.log("\\Closed");
            IJ.notifyEventListeners(3);
        } else if (this.getTitle().equals("Debug")) {
            Prefs.saveLocation(DEBUG_LOC_KEY, this.getLocation());
        } else if (this.textPanel != null && this.textPanel.rt != null && !this.saveContents()) {
            return;
        }
        this.dispose();
        WindowManager.removeWindow(this);
        this.textPanel.flush();
    }

    public void rename(String title) {
        this.textPanel.rename(title);
    }

    boolean saveContents() {
        int lineCount = this.textPanel.getLineCount();
        if (!this.textPanel.unsavedLines) {
            lineCount = 0;
        }
        ImageJ ij = IJ.getInstance();
        boolean macro = IJ.macroRunning() || Interpreter.isBatchMode();
        boolean isResults = this.getTitle().contains("Results");
        if (lineCount > 0 && !macro && ij != null && !ij.quitting() && isResults) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, this.getTitle(), "Save " + lineCount + " measurements?");
            if (d.cancelPressed()) {
                return false;
            }
            if (d.yesPressed() && !this.textPanel.saveAs("")) {
                return false;
            }
        }
        this.textPanel.rt.reset();
        return true;
    }

    void changeFontSize(boolean larger) {
        int in = this.fontSize++;
        if (larger) {
            if (this.fontSize == this.sizes.length) {
                this.fontSize = this.sizes.length - 1;
            }
        } else {
            --this.fontSize;
            if (this.fontSize < 0) {
                this.fontSize = 0;
            }
        }
        IJ.showStatus(this.sizes[this.fontSize] + " point");
        font = null;
        this.setFont();
    }

    public static void setFont(String name, int style, int size) {
        font = new Font(name, style, size);
    }

    void saveSettings() {
        Prefs.set(FONT_SIZE, this.fontSize);
        Prefs.set(FONT_ANTI, this.antialiased.getState());
        IJ.showStatus("Font settings saved (size=" + this.sizes[this.fontSize] + ", antialiased=" + this.antialiased.getState() + ")");
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

