/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.Commands;
import ij.plugin.PlugIn;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class ImageJ_Updater
implements PlugIn {
    private static final String URL = "http://wsr.imagej.net";
    private String notes;

    @Override
    public void run(String arg) {
        File file;
        String ij_jar;
        if (arg.equals("menus")) {
            this.updateMenus();
            return;
        }
        if (IJ.getApplet() != null) {
            return;
        }
        URL url = this.getClass().getResource("/ij/IJ.class");
        String string = ij_jar = url == null ? null : url.toString().replaceAll("%20", " ");
        if (ij_jar == null || !ij_jar.startsWith("jar:file:")) {
            this.error("Could not determine location of ij.jar");
            return;
        }
        int exclamation = ij_jar.indexOf(33);
        ij_jar = ij_jar.substring(9, exclamation);
        if (IJ.debugMode) {
            IJ.log("Updater (jar loc): " + ij_jar);
        }
        if (!(file = new File(ij_jar)).exists()) {
            this.error("File not found: " + file.getPath());
            return;
        }
        if (!file.canWrite()) {
            String path = file.getPath();
            String msg = "No write access: " + path;
            if (IJ.isMacOSX() && path != null && path.startsWith("/private/var/folders/")) {
                msg = "ImageJ is in a read-only folder due to Path Randomization.\nTo work around this problem, drag ImageJ.app to another\nfolder and then (optionally) drag it back.";
            }
            this.error(msg);
            return;
        }
        String[] list = this.openUrlAsList("http://wsr.imagej.net/jars/list.txt");
        if (list == null || list.length == 0) {
            this.error("Error opening http://wsr.imagej.net/jars/list.txt");
            return;
        }
        int count = list.length + 2;
        String[] versions = new String[count];
        String[] urls = new String[count];
        versions[0] = list[0];
        urls[0] = "http://wsr.imagej.net/jars/ij.jar";
        for (int i = 1; i < count - 2; ++i) {
            String version = list[i];
            versions[i] = version.substring(0, version.length() - 1);
            urls[i] = "http://wsr.imagej.net/jars/ij" + version.substring(1, 2) + version.substring(3, 6) + ".jar";
        }
        versions[count - 2] = "daily build";
        urls[count - 2] = "http://wsr.imagej.net/download/daily-build/ij.jar";
        versions[count - 1] = "previous";
        urls[count - 1] = "http://wsr.imagej.net/jars/ij2.jar";
        int choice = this.showDialog(versions);
        if (choice == -1 || !Commands.closeAll()) {
            return;
        }
        byte[] jar = null;
        jar = this.getJar(urls[choice]);
        if (jar == null) {
            this.error("Unable to download ij.jar from " + urls[choice]);
            return;
        }
        Prefs.savePreferences();
        this.saveJar(file, jar);
        if (choice < count - 2) {
            new File(IJ.getDirectory("macros") + "functions.html").delete();
        }
        System.exit(0);
    }

    int showDialog(String[] versions) {
        GenericDialog gd = new GenericDialog("ImageJ Updater");
        gd.addChoice("Upgrade To:", versions, versions[0]);
        String msg = "You are currently running v1.54c.\n \nIf you click \"OK\", ImageJ will quit\nand you will be running the upgraded\nversion after you restart ImageJ.\n";
        gd.addMessage(msg);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -1;
        }
        return gd.getNextChoiceIndex();
    }

    String openUrlAsString(String address, int maxLines) {
        StringBuffer sb;
        try {
            String line;
            URL url = new URL(address);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            int count = 0;
            while ((line = br.readLine()) != null && count++ < maxLines) {
                sb.append(line + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            sb = null;
        }
        return sb != null ? new String(sb) : null;
    }

    byte[] getJar(String address) {
        byte[] data;
        try {
            URL url = new URL(address);
            IJ.showStatus("Connecting to http://imagej.net/ij");
            URLConnection uc = url.openConnection();
            int len = uc.getContentLength();
            if (IJ.debugMode) {
                IJ.log("Updater (url): " + address + " " + len);
            }
            if (len <= 0) {
                return null;
            }
            String name = address.contains("daily") ? "daily build (" : "ij.jar (";
            IJ.showStatus("Downloading " + name + IJ.d2s((double)len / 1048576.0, 1) + "MB)");
            InputStream in = uc.getInputStream();
            data = new byte[len];
            int n = 0;
            while (n < len) {
                int count = in.read(data, n, len - n);
                if (count < 0) {
                    throw new EOFException();
                }
                IJ.showProgress(n += count, len);
            }
            in.close();
        }
        catch (IOException e) {
            if (IJ.debugMode) {
                IJ.log("" + e);
            }
            return null;
        }
        if (IJ.debugMode) {
            IJ.wait(6000);
        }
        return data;
    }

    void saveJar(File f, byte[] data) {
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write(data, 0, data.length);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String[] openUrlAsList(String address) {
        IJ.showStatus("Connecting to http://imagej.net/ij");
        Vector<String> v = new Vector<String>();
        try {
            String line;
            URL url = new URL(address);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                v.addElement(line);
            }
            br.close();
        }
        catch (Exception url) {
            // empty catch block
        }
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        IJ.showStatus("");
        return lines;
    }

    void error(String msg) {
        IJ.error("ImageJ Updater", msg);
    }

    void updateMenus() {
        if (IJ.debugMode) {
            long start = System.currentTimeMillis();
            Menus.updateImageJMenus();
            IJ.log("Refresh Menus: " + (System.currentTimeMillis() - start) + " ms");
        } else {
            Menus.updateImageJMenus();
        }
    }
}

