/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.IntProcessor;

public class ColorStatistics
extends ImageStatistics {
    public ColorStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    public ColorStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        this.setup(ip, cal);
        if (ip instanceof IntProcessor) {
            this.getIntStatistics(ip);
            return;
        }
        ColorProcessor cp = (ColorProcessor)ip;
        this.histogram = cp.getHistogram();
        this.getRawStatistics(0, 255);
        if ((mOptions & 0x10) != 0) {
            this.getRawMinAndMax(0, 255);
        }
        if ((mOptions & 0x800) != 0 || (mOptions & 0x2000) != 0) {
            this.fitEllipse(ip, mOptions);
        } else if ((mOptions & 0x20) != 0) {
            this.getCentroid(ip);
        }
        if ((mOptions & 0x60040) != 0) {
            this.calculateMoments(ip);
        }
        if ((mOptions & 0x10000) != 0) {
            this.calculateMedian(this.histogram, 0, 255, cal);
        }
    }

    void calculateMoments(ImageProcessor ip) {
        byte[] mask = ip.getMaskArray();
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if (mask == null || mask[mi++] != 0) {
                    double v = ip.getPixelValue(x, y);
                    double v2 = v * v;
                    sum1 += v;
                    sum2 += v2;
                    sum3 += v * v2;
                    sum4 += v2 * v2;
                    xsum += (double)x * v;
                    ysum += (double)y * v;
                }
                ++i;
            }
            ++y;
            ++my;
        }
        double mean2 = this.mean * this.mean;
        double variance = sum2 / (double)this.pixelCount - mean2;
        double sDeviation = Math.sqrt(variance);
        this.skewness = ((sum3 - 3.0 * this.mean * sum2) / (double)this.pixelCount + 2.0 * this.mean * mean2) / (variance * sDeviation);
        this.kurtosis = ((sum4 - 4.0 * this.mean * sum3 + 6.0 * mean2 * sum2) / (double)this.pixelCount - 3.0 * mean2 * mean2) / (variance * variance) - 3.0;
        this.xCenterOfMass = xsum / sum1 + 0.5;
        this.yCenterOfMass = ysum / sum1 + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }

    void getIntStatistics(ImageProcessor ip) {
        int v;
        int[] pixels = (int[])ip.getPixels();
        this.nBins = ip.getHistogramSize();
        this.histogram = new int[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        byte[] mask = ip.getMaskArray();
        int roiMin = Integer.MAX_VALUE;
        int roiMax = -2147483647;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if (mask == null || mask[mi++] != 0) {
                    v = pixels[i];
                    if (v < roiMin) {
                        roiMin = v;
                    }
                    if (v > roiMax) {
                        roiMax = v;
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.min = roiMin;
        this.max = roiMax;
        this.binSize = (this.max - this.min) / (double)this.nBins;
        this.histMin = this.min;
        this.histMax = this.max;
        double scale = (double)this.nBins / (this.max - this.min);
        this.pixelCount = 0;
        int y2 = this.ry;
        int my2 = 0;
        while (y2 < this.ry + this.rh) {
            int i = y2 * this.width + this.rx;
            int mi = my2 * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if (mask == null || mask[mi++] != 0) {
                    v = pixels[i];
                    ++this.pixelCount;
                    sum += (double)v;
                    sum2 += (double)(v * v);
                    int index = (int)(scale * ((double)v - this.min));
                    if (index >= this.nBins) {
                        index = this.nBins - 1;
                    }
                    int n = index;
                    this.histogram[n] = this.histogram[n] + 1;
                }
                ++i;
            }
            ++y2;
            ++my2;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int count = this.histogram[i];
            if (count <= this.maxCount) continue;
            this.maxCount = count;
            this.mode = i;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
        if (this.binSize != 1.0) {
            this.dmode += this.binSize / 2.0;
        }
    }
}

