/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.measure.CurveFitter;
import ij.measure.Minimizer;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Frame;
import java.awt.TextField;
import java.util.ArrayList;
import java.util.Vector;

public class PlotContentsDialog
implements DialogListener {
    public static final int ERROR = -1;
    public static final int STYLE = 0;
    public static final int ADD_FROM_PLOT = 1;
    public static final int ADD_FROM_TABLE = 2;
    public static final int ADD_FROM_ARRAYS = 3;
    public static final int ADD_FIT = 4;
    private static final String[] HEADINGS = new String[]{"Plot Contents Style", "Add From Plot", "Plot From Table", "Add Plot Data", "Add Fit"};
    private Plot plot;
    private int dialogType;
    private double[] savedLimits;
    GenericDialog gd;
    private int currentObjectIndex = -1;
    private Choice objectChoice;
    private Choice symbolChoice;
    private TextField colorField;
    private TextField color2Field;
    private TextField labelField;
    private TextField widthField;
    private Checkbox visibleCheckbox;
    private boolean creatingPlot;
    private Choice plotChoice;
    private Plot[] allPlots;
    private String[] allPlotNames;
    private static Plot previousPlot;
    private static int previousPlotObjectIndex;
    private int defaultPlotIndex;
    private int defaultObjectIndex;
    private int currentPlotNumObjects;
    private Choice tableChoice;
    static final int N_COLUMNS = 4;
    private int nColumnsToUse = 4;
    private Choice[] columnChoice = new Choice[4];
    private static final String[] COLUMN_NAMES;
    private static final boolean[] COLUMN_ALLOW_NONE;
    private ResultsTable[] allTables;
    private String[] allTableNames;
    private static String previousTableName;
    private static int[] previousColumns;
    private static int defaultTableIndex;
    private static int[] defaultColumnIndex;
    private String[] arrayHeadings;
    private ArrayList<float[]> arrayData;
    private Choice fitDataChoice;
    private Choice fitFunctionChoice;
    private Thread fittingThread;
    private static String lastFitFunction;
    private String curveFitterStatusString;
    private static String previousColor;
    private static String previousColor2;
    private static String previousSymbol;
    private static double previousLineWidth;
    private static final String[] PLOT_COLORS;

    public PlotContentsDialog(Plot plot, int dialogType) {
        this.plot = plot;
        int n = this.dialogType = plot == null ? -1 : dialogType;
        if (plot != null) {
            this.currentPlotNumObjects = plot.getNumPlotObjects();
        }
    }

    public PlotContentsDialog(String title, ResultsTable rt) {
        this.creatingPlot = true;
        this.dialogType = 2;
        if (rt == null || !PlotContentsDialog.isValid(rt)) {
            IJ.error("Cant Create Plot", "No (results) table or no data in " + title);
            this.dialogType = -1;
        }
        this.plot = new Plot("Plot of " + title, "x", "y");
        this.allTables = new ResultsTable[]{rt};
        this.allTableNames = new String[]{title};
    }

    public PlotContentsDialog(String title, String[] headings, String[] defaultHeadings, ArrayList<float[]> data) {
        this.creatingPlot = true;
        this.dialogType = 3;
        this.arrayHeadings = headings;
        this.arrayData = data;
        this.plot = new Plot(title, "x", "y");
        this.setDefaultColumns(defaultHeadings);
    }

    public PlotContentsDialog(Plot plot, String[] headings, String[] defaultHeadings, ArrayList<float[]> data) {
        this.dialogType = 3;
        this.plot = plot;
        this.arrayHeadings = headings;
        this.arrayData = data;
        this.setDefaultColumns(defaultHeadings);
    }

    public void noErrorBars() {
        this.nColumnsToUse = 2;
    }

    public void showDialog(Frame parent) {
        Vector choices;
        if (this.dialogType == -1) {
            return;
        }
        if (!this.creatingPlot) {
            this.savedLimits = this.plot.getLimits();
        }
        this.plot.savePlotObjects();
        String[] designations = this.plot.getPlotObjectDesignations();
        if (this.dialogType == 0 && designations.length == 0) {
            IJ.error("Empty Plot");
            return;
        }
        if (this.dialogType == 1) {
            this.prepareAddFromPlot();
            if (this.allPlots.length == 0) {
                return;
            }
        } else if (this.dialogType == 2 && !this.creatingPlot) {
            this.prepareAddFromTable();
            if (this.allTables.length == 0) {
                return;
            }
        }
        if (!(this.dialogType != 2 && this.dialogType != 3 || this.creatingPlot)) {
            this.suggestColor();
        }
        if (parent == null && this.plot.getImagePlus() != null) {
            parent = this.plot.getImagePlus().getWindow();
        }
        this.gd = parent == null ? new GenericDialog(HEADINGS[this.dialogType]) : new GenericDialog(HEADINGS[this.dialogType], parent);
        IJ.wait(100);
        if (this.dialogType == 0) {
            this.gd.addChoice("Item:", designations, designations[0]);
            this.objectChoice = (Choice)this.gd.getChoices().get(0);
            this.currentObjectIndex = this.objectChoice.getSelectedIndex();
        } else if (this.dialogType == 1) {
            this.gd.addChoice("Select Plot:", this.allPlotNames, this.allPlotNames[this.defaultPlotIndex]);
            this.gd.addChoice("Item to Add:", new String[]{""}, "");
            Vector choices2 = this.gd.getChoices();
            this.plotChoice = (Choice)choices2.get(0);
            this.objectChoice = (Choice)choices2.get(1);
            this.makeSourcePlotObjects();
        } else if (this.dialogType == 2) {
            this.gd.addChoice("Select Table:", this.allTableNames, this.allTableNames[defaultTableIndex]);
            this.tableChoice = (Choice)this.gd.getChoices().get(0);
            if (this.creatingPlot) {
                this.tableChoice.setEnabled(false);
            }
        } else if (this.dialogType == 4) {
            String[] dataSources = this.plot.getDataObjectDesignations();
            if (dataSources.length == 0) {
                IJ.error("No Data For Fitting");
                return;
            }
            this.gd.addChoice("Fit Data Set:", dataSources, dataSources[0]);
            this.gd.addChoice("Fit Function:", new String[0], "");
            choices = this.gd.getChoices();
            this.fitDataChoice = (Choice)choices.get(0);
            this.fitFunctionChoice = (Choice)choices.get(1);
            if (dataSources.length == 1) {
                this.fitDataChoice.setEnabled(false);
            }
            for (int i = 0; i < CurveFitter.fitList.length; ++i) {
                this.fitFunctionChoice.addItem(CurveFitter.fitList[CurveFitter.sortedTypes[i]]);
            }
            this.fitFunctionChoice.select(lastFitFunction);
        }
        if (this.dialogType == 2 || this.dialogType == 3) {
            for (int i = 0; i < this.nColumnsToUse; ++i) {
                this.gd.addChoice(COLUMN_NAMES[i], new String[]{""}, "");
                choices = this.gd.getChoices();
                this.columnChoice[i] = (Choice)choices.get(choices.size() - 1);
            }
            this.makeSourceColumns();
            if (!this.creatingPlot) {
                this.suggestNewYColumn();
            }
        }
        this.gd.addStringField("Color:", previousColor, 10);
        this.gd.addStringField("Secondary (fill) color:", previousColor2, 10);
        this.gd.addNumericField("Line width: ", previousLineWidth, 1);
        this.gd.addChoice("Symbol:", Plot.SORTED_SHAPES, this.dialogType == 4 ? "line" : previousSymbol);
        this.gd.addStringField("Label:", "", 20);
        this.gd.setInsets(10, 60, 0);
        this.gd.addCheckbox("Visible", true);
        Vector choices3 = this.gd.getChoices();
        this.symbolChoice = (Choice)choices3.get(choices3.size() - 1);
        Vector stringFields = this.gd.getStringFields();
        this.colorField = (TextField)stringFields.get(0);
        this.color2Field = (TextField)stringFields.get(1);
        this.labelField = (TextField)stringFields.get(2);
        this.widthField = (TextField)this.gd.getNumericFields().get(0);
        this.visibleCheckbox = (Checkbox)this.gd.getCheckboxes().get(0);
        this.gd.addDialogListener(this);
        IJ.wait(100);
        if (this.dialogType == 0) {
            this.setDialogStyleFields(this.objectChoice.getSelectedIndex());
        } else if (this.dialogType == 1) {
            this.addObjectFromPlot();
        } else if (this.dialogType == 2 || this.dialogType == 3) {
            this.addObjectFromTable();
        } else if (this.dialogType == 4) {
            this.addFitCurve();
        }
        this.plot.updateImage();
        if (this.creatingPlot) {
            boolean recording = Recorder.record;
            Recorder.record = false;
            this.plot.show();
            if (recording) {
                Recorder.record = true;
            }
        }
        this.gd.showDialog();
        if (this.fittingThread != null) {
            this.fittingThread.interrupt();
            try {
                this.fittingThread.join();
            }
            catch (InterruptedException recording) {
                // empty catch block
            }
        }
        if (this.gd.wasCanceled()) {
            if (this.creatingPlot) {
                ImagePlus imp = this.plot.getImagePlus();
                if (imp != null) {
                    imp.close();
                }
            } else {
                this.plot.restorePlotObjects();
                if (this.savedLimits != null) {
                    this.plot.setLimits(this.savedLimits[0], this.savedLimits[1], this.savedLimits[2], this.savedLimits[3]);
                }
                this.plot.updateImage();
                this.plot.killPlotObjectsSnapshot();
            }
            return;
        }
        this.plot.killPlotObjectsSnapshot();
        if (this.dialogType == 2 || this.dialogType == 3 || this.dialogType == 4) {
            previousColor = this.colorField.getText();
            previousColor2 = this.color2Field.getText();
            previousSymbol = this.symbolChoice.getSelectedItem();
            previousLineWidth = Tools.parseDouble(this.widthField.getText());
        }
        if (this.dialogType == 4) {
            lastFitFunction = this.fitFunctionChoice.getSelectedItem();
            IJ.log(this.curveFitterStatusString);
        }
        if (Recorder.record && !Recorder.scriptMode()) {
            if (this.dialogType == 1) {
                Recorder.recordString("Plot.addFromPlot(\"" + this.plotChoice.getSelectedItem() + "\", " + this.objectChoice.getSelectedIndex() + ");\n");
            } else if (this.dialogType == 2) {
                if (this.creatingPlot) {
                    Recorder.recordString("Plot.create(\"" + this.plot.getTitle() + "\", \"" + this.plot.getLabel('x') + "\", \"" + this.plot.getLabel('y') + "\");\n");
                }
                String xSource = this.columnChoice[0].getSelectedIndex() == 0 ? "" : "Table.getColumn(\"" + this.columnChoice[0].getSelectedItem() + "\", \"" + this.tableChoice.getSelectedItem() + "\"), ";
                String ySource = "Table.getColumn(\"" + this.columnChoice[1].getSelectedItem() + "\", \"" + this.tableChoice.getSelectedItem() + "\")";
                Recorder.recordString("Plot.add(\"" + this.symbolChoice.getSelectedItem() + "\", " + xSource + ySource + ");\n");
                if (this.columnChoice[2].getSelectedIndex() > 0) {
                    Recorder.recordString("Plot.add(\"xerror\", Table.getColumn(\"" + this.columnChoice[2].getSelectedItem() + "\", \"" + this.tableChoice.getSelectedItem() + "\"));\n");
                }
                if (this.columnChoice[3].getSelectedIndex() > 0) {
                    Recorder.recordString("Plot.add(\"error\", Table.getColumn(\"" + this.columnChoice[3].getSelectedItem() + "\", \"" + this.tableChoice.getSelectedItem() + "\"));\n");
                }
            }
            Recorder.recordString("Plot.setStyle(" + this.currentObjectIndex + ", \"" + this.getStyleString() + "\");\n");
        }
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (e == null) {
            return true;
        }
        boolean setStyle = false;
        if (this.dialogType == 0) {
            int objectIndex = this.objectChoice.getSelectedIndex();
            boolean bl = setStyle = e.getSource() != this.objectChoice;
            if (e.getSource() == this.objectChoice) {
                this.setDialogStyleFields(objectIndex);
                this.currentObjectIndex = objectIndex;
            } else {
                setStyle = true;
            }
        } else if (this.dialogType == 1) {
            if (e.getSource() == this.plotChoice) {
                this.makeSourcePlotObjects();
                this.addObjectFromPlot();
            } else if (e.getSource() == this.objectChoice) {
                this.addObjectFromPlot();
            } else {
                setStyle = true;
            }
        } else if (this.dialogType == 2 || this.dialogType == 3) {
            if (e.getSource() == this.tableChoice) {
                this.makeSourceColumns();
                this.addObjectFromTable();
            } else {
                boolean columnChanged = false;
                for (int c = 0; c < this.nColumnsToUse; ++c) {
                    if (e.getSource() != this.columnChoice[c]) continue;
                    columnChanged = true;
                    break;
                }
                if (columnChanged) {
                    this.addObjectFromTable();
                } else {
                    setStyle = true;
                }
            }
        } else if (this.dialogType == 4) {
            if (e.getSource() == this.fitDataChoice || e.getSource() == this.fitFunctionChoice) {
                this.addFitCurve();
            } else {
                setStyle = true;
            }
        }
        if (setStyle) {
            this.setPlotObjectStyle();
        }
        return true;
    }

    private void setPlotObjectStyle() {
        if (this.currentObjectIndex < 0) {
            return;
        }
        String style = this.getStyleString();
        this.plot.setPlotObjectStyle(this.currentObjectIndex, style);
        if (this.labelField.isEnabled()) {
            String label = this.labelField.getText();
            this.plot.setPlotObjectLabel(this.currentObjectIndex, label.length() > 0 ? label : null);
        }
    }

    private String getStyleString() {
        String color = this.colorField.getText();
        String color2 = this.color2Field.getText();
        double width = Tools.parseDouble(this.widthField.getText());
        String symbol = this.symbolChoice.getSelectedItem();
        Boolean visible = this.visibleCheckbox.getState();
        String style = color.trim() + "," + color2.trim() + "," + (float)width + "," + symbol + (visible != false ? "" : "hidden");
        return style;
    }

    private void setDialogStyleFields(int index) {
        if (index < 0) {
            return;
        }
        Checkbox visibleC = (Checkbox)this.gd.getCheckboxes().get(0);
        String styleString = this.plot.getPlotObjectStyle(index);
        String designation = this.plot.getPlotObjectDesignations()[index].toLowerCase();
        boolean isData = designation.startsWith("data");
        boolean isText = designation.startsWith("text");
        boolean isBox = designation.startsWith("shapes") && (designation.contains("boxes") || designation.contains("rectangles"));
        boolean isGrid = designation.startsWith("shapes") && designation.contains("redraw_grid");
        String[] items = styleString.split(",");
        this.colorField.setText(items[0]);
        this.color2Field.setText(items[1]);
        this.widthField.setText(items[2]);
        if (items.length >= 4) {
            this.symbolChoice.select(items[3]);
        }
        this.labelField.setText(isData ? this.plot.getPlotObjectLabel(index) : "");
        visibleC.setState(!styleString.contains("hidden"));
        this.colorField.setEnabled(!isGrid);
        this.color2Field.setEnabled(isData || isBox);
        this.widthField.setEnabled(!isText && !isGrid);
        this.symbolChoice.setEnabled(isData);
        this.labelField.setEnabled(isData);
    }

    private void prepareAddFromPlot() {
        int[] windowIDlist = WindowManager.getIDList();
        ArrayList<ImagePlus> plotImps = new ArrayList<ImagePlus>();
        ImagePlus currentPlotImp = null;
        for (int windowID : windowIDlist) {
            Plot thePlot;
            ImagePlus imp = WindowManager.getImage(windowID);
            if (imp == null || imp.getWindow() == null || (thePlot = (Plot)imp.getProperty("thePlot")) == null) continue;
            if (thePlot == this.plot) {
                currentPlotImp = imp;
                continue;
            }
            plotImps.add(imp);
        }
        if (currentPlotImp != null) {
            plotImps.add(currentPlotImp);
        }
        if (plotImps.size() == 0) {
            return;
        }
        this.allPlots = new Plot[plotImps.size()];
        this.allPlotNames = new String[plotImps.size()];
        this.defaultPlotIndex = 0;
        for (int i = 0; i < this.allPlots.length; ++i) {
            ImagePlus imp = (ImagePlus)plotImps.get(i);
            this.allPlots[i] = (Plot)imp.getProperty("thePlot");
            if (this.allPlots[i] == previousPlot) {
                this.defaultPlotIndex = i;
            }
            this.allPlotNames[i] = imp.getWindow().getTitle();
            if (imp != currentPlotImp) continue;
            this.allPlotNames[i] = "THIS PLOT: " + this.allPlotNames[i];
        }
    }

    private void makeSourcePlotObjects() {
        int plotIndex = this.plotChoice.getSelectedIndex();
        String[] plotObjectNames = this.allPlots[plotIndex].getPlotObjectDesignations();
        this.objectChoice.removeAll();
        int nPlotObjects = this.allPlots[plotIndex] == this.plot ? this.currentPlotNumObjects : plotObjectNames.length;
        for (int i = 0; i < nPlotObjects; ++i) {
            this.objectChoice.addItem(plotObjectNames[i]);
        }
        this.objectChoice.select(Math.min(nPlotObjects - 1, previousPlotObjectIndex));
    }

    private void addObjectFromPlot() {
        int plotIndex = this.plotChoice.getSelectedIndex();
        int objectIndex = this.objectChoice.getSelectedIndex();
        this.plot.restorePlotObjects();
        if (this.savedLimits != null) {
            this.plot.setLimits(this.savedLimits);
        }
        this.currentObjectIndex = this.plot.addObjectFromPlot(this.allPlots[plotIndex], objectIndex);
        this.plot.fitRangeToLastPlotObject();
        this.setDialogStyleFields(this.currentObjectIndex);
        previousPlot = this.allPlots[plotIndex];
        previousPlotObjectIndex = objectIndex;
    }

    private void prepareAddFromTable() {
        Frame[] windows;
        ArrayList<TextWindow> tableWindows = new ArrayList<TextWindow>();
        for (Frame win : windows = WindowManager.getNonImageWindows()) {
            ResultsTable rt;
            if (!(win instanceof TextWindow) || !PlotContentsDialog.isValid(rt = ((TextWindow)win).getResultsTable())) continue;
            tableWindows.add((TextWindow)win);
        }
        this.allTables = new ResultsTable[tableWindows.size()];
        this.allTableNames = new String[tableWindows.size()];
        defaultTableIndex = 0;
        for (int i = 0; i < this.allTables.length; ++i) {
            TextWindow tw = (TextWindow)tableWindows.get(i);
            this.allTables[i] = tw.getResultsTable();
            if (this.allTableNames[i] != null && this.allTableNames[i].equals(previousTableName)) {
                defaultTableIndex = i;
            }
            this.allTableNames[i] = tw.getTitle();
        }
    }

    public static boolean tableWindowExists() {
        Frame[] windows;
        for (Frame win : windows = WindowManager.getNonImageWindows()) {
            ResultsTable rt;
            if (!(win instanceof TextWindow) || !PlotContentsDialog.isValid(rt = ((TextWindow)win).getResultsTable())) continue;
            return true;
        }
        return false;
    }

    private void makeSourceColumns() {
        String[] columnHeadings = null;
        if (this.dialogType == 2) {
            int tableIndex = this.tableChoice.getSelectedIndex();
            ResultsTable rt = this.allTables[tableIndex];
            String columnHeadingStr = rt.getColumnHeadings();
            if (!columnHeadingStr.startsWith(" \t")) {
                columnHeadingStr = " \t" + columnHeadingStr;
            }
            columnHeadings = columnHeadingStr.split("\t");
            int nBadColumns = 0;
            for (int i = 1; i < columnHeadings.length; ++i) {
                int index = rt.getColumnIndex(columnHeadings[i]);
                if (rt.columnExists(index)) continue;
                columnHeadings[i] = null;
                ++nBadColumns;
            }
            if (nBadColumns > 0) {
                String[] newHeadings = new String[columnHeadings.length - nBadColumns];
                int i = 0;
                for (String heading : columnHeadings) {
                    if (heading == null) continue;
                    newHeadings[i++] = heading;
                }
                columnHeadings = newHeadings;
            }
        } else {
            columnHeadings = new String[this.arrayHeadings.length + 1];
            System.arraycopy(this.arrayHeadings, 0, columnHeadings, 1, this.arrayHeadings.length);
        }
        columnHeadings[0] = "---";
        for (int c = 0; c < this.nColumnsToUse; ++c) {
            int i;
            this.columnChoice[c].removeAll();
            int n = i = COLUMN_ALLOW_NONE[c] ? 0 : 1;
            while (i < columnHeadings.length) {
                this.columnChoice[c].addItem(columnHeadings[i]);
                ++i;
            }
            if (this.columnChoice[c].getItemCount() <= 0 || previousColumns[c] < 0) continue;
            this.columnChoice[c].select(Math.min(this.columnChoice[c].getItemCount() - 1, previousColumns[c]));
        }
    }

    private void addObjectFromTable() {
        float[][] data = this.getDataArrays();
        if (data[1] == null) {
            return;
        }
        String label = this.columnChoice[1].getSelectedItem();
        int shape = Plot.toShape(this.symbolChoice.getSelectedItem());
        float lineWidth = (float)Tools.parseDouble(this.widthField.getText());
        if (lineWidth > 0.0f) {
            this.plot.setLineWidth(lineWidth);
        }
        this.plot.restorePlotObjects();
        if (this.savedLimits != null) {
            this.plot.setLimits(this.savedLimits);
        }
        this.plot.setColor(this.colorField.getText(), this.color2Field.getText());
        this.plot.addPoints(data[0], data[1], data[3], shape, label);
        if (data[2] != null) {
            this.plot.addHorizontalErrorBars(data[2]);
        }
        if (this.creatingPlot) {
            this.plot.setXYLabels(data[0] == null ? "x" : this.columnChoice[0].getSelectedItem(), this.columnChoice[1].getSelectedItem());
            this.plot.setLimitsToFit(false);
        } else {
            this.plot.fitRangeToLastPlotObject();
        }
        this.currentObjectIndex = this.plot.getNumPlotObjects() - 1;
        this.setDialogStyleFields(this.currentObjectIndex);
        if (this.dialogType == 2) {
            previousTableName = this.allTableNames[this.tableChoice.getSelectedIndex()];
        }
    }

    private void suggestNewYColumn() {
        int nYcolumns = this.columnChoice[1].getItemCount();
        int currentIndex = this.columnChoice[1].getSelectedIndex();
        for (int i = 0; i < nYcolumns; ++i) {
            if (this.columnChoice[0].getSelectedIndex() == 0 || !this.columnChoice[1].getSelectedItem().equals(this.columnChoice[0].getSelectedItem())) {
                Object data = this.getDataArrays();
                if (this.plot.getPlotObjectIndex((float[][])(data = (Object)new float[][]{data[0], data[1]})) < 0) {
                    return;
                }
            }
            this.columnChoice[1].select((currentIndex + i + 1) % nYcolumns);
        }
    }

    private float[][] getDataArrays() {
        float[][] data = new float[4][];
        if (this.dialogType == 2) {
            ResultsTable rt = this.allTables[this.tableChoice.getSelectedIndex()];
            for (int c = 0; c < 4; ++c) {
                String heading = this.columnChoice[c].getSelectedItem();
                int index = rt.getColumnIndex(heading);
                if (index >= 0) {
                    data[c] = rt.getColumn(index);
                }
                PlotContentsDialog.previousColumns[c] = this.columnChoice[c].getSelectedIndex();
            }
        } else {
            for (int c = 0; c < this.nColumnsToUse; ++c) {
                String heading = this.columnChoice[c].getSelectedItem();
                int index = PlotContentsDialog.getIndex(this.arrayHeadings, heading);
                if (index >= 0) {
                    data[c] = this.arrayData.get(index);
                }
                PlotContentsDialog.previousColumns[c] = this.columnChoice[c].getSelectedIndex();
            }
        }
        return data;
    }

    private void addFitCurve() {
        this.plot.restorePlotObjects();
        if (this.savedLimits != null) {
            this.plot.setLimits(this.savedLimits);
        }
        int dataIndex = this.fitDataChoice.getSelectedIndex();
        float[][] data = this.plot.getDataObjectArrays(dataIndex);
        String fitName = this.fitFunctionChoice.getSelectedItem();
        int fitType = PlotContentsDialog.getIndex(CurveFitter.fitList, fitName);
        CurveFitter cf = new CurveFitter(Tools.toDouble(data[0]), Tools.toDouble(data[1]));
        cf.doFit(fitType);
        String statusString = "Fit: " + Minimizer.STATUS_STRING[cf.getStatus()];
        if (cf.getStatus() == 0) {
            statusString = statusString + ", sum residuals ^2 = " + (float)cf.getSumResidualsSqr();
        }
        IJ.showStatus(statusString);
        this.curveFitterStatusString = "Fit for " + this.plot.getTitle() + ": " + this.fitDataChoice.getSelectedItem() + cf.getResultString();
        double[] plotMinMax = this.plot.getLimits();
        double[] dataMinMax = Tools.getMinMax(data[0]);
        double min = Math.min(plotMinMax[0], dataMinMax[0]);
        double max = Math.max(plotMinMax[1], dataMinMax[1]);
        double plotSpan = Math.abs(plotMinMax[1] - plotMinMax[0]);
        double dataSpan = Math.abs(dataMinMax[1] - dataMinMax[0]);
        double rangeFactor = Math.max(plotSpan / dataSpan, dataSpan / plotSpan);
        if (rangeFactor > 20.0) {
            rangeFactor = 20.0;
        }
        int nPoints = (int)(1000.0 * rangeFactor);
        float[] xFit = new float[nPoints];
        float[] yFit = new float[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            xFit[i] = (float)(min + (double)i * ((max - min) / (double)(nPoints - 1)));
            yFit[i] = (float)cf.f(xFit[i]);
        }
        this.plot.addPoints(xFit, yFit, 2);
        this.currentObjectIndex = this.plot.getNumPlotObjects() - 1;
        this.labelField.setText("Fit: " + fitName);
        this.setPlotObjectStyle();
    }

    private static boolean isValid(ResultsTable rt) {
        if (rt == null) {
            return false;
        }
        String columnHeadingStr = rt.getColumnHeadings();
        if (columnHeadingStr.startsWith(" \t")) {
            return columnHeadingStr.length() >= 3;
        }
        return columnHeadingStr.length() >= 1;
    }

    private void setDefaultColumns(String[] defaultHeadings) {
        if (defaultHeadings == null) {
            return;
        }
        for (int i = 0; i < Math.min(defaultHeadings.length, this.nColumnsToUse); ++i) {
            PlotContentsDialog.previousColumns[i] = defaultHeadings[i] == null || defaultHeadings[i].length() == 0 ? 0 : Math.max(0, PlotContentsDialog.getIndex(this.arrayHeadings, defaultHeadings[i]) + (COLUMN_ALLOW_NONE[i] ? 1 : 0));
        }
    }

    private static int getIndex(String[] strArray, String searchTerm) {
        for (int i = 0; i < strArray.length; ++i) {
            if (!strArray[i].equals(searchTerm)) continue;
            return i;
        }
        return -1;
    }

    private void suggestColor() {
        boolean[] colorUsed = new boolean[PLOT_COLORS.length];
        String[] designations = this.plot.getPlotObjectDesignations();
        for (int i = 0; i < designations.length; ++i) {
            if (!designations[i].toLowerCase().startsWith("data")) continue;
            String styleString = this.plot.getPlotObjectStyle(i);
            for (int j = 0; j < PLOT_COLORS.length; ++j) {
                if (!styleString.startsWith(PLOT_COLORS[j])) continue;
                colorUsed[j] = true;
            }
        }
        String newColor = previousColor;
        for (int j = 0; j < PLOT_COLORS.length; ++j) {
            if (colorUsed[j]) continue;
            newColor = PLOT_COLORS[j];
            break;
        }
        if (previousColor2 != null && previousColor2.equals(previousColor)) {
            previousColor2 = newColor;
        } else if (Colors.decode(previousColor2, null) != null) {
            Color newC = Colors.decode(newColor, Color.BLACK);
            Color newC2 = new Color(PlotContentsDialog.makeBrighter(newC.getRed()), PlotContentsDialog.makeBrighter(newC.getGreen()), PlotContentsDialog.makeBrighter(newC.getBlue()));
            previousColor2 = Colors.colorToString(newC2);
        }
        previousColor = newColor;
    }

    private static int makeBrighter(int v) {
        return v > 190 ? 255 : 255 - (int)(0.4 * (double)(255 - v));
    }

    static {
        COLUMN_NAMES = new String[]{"X:", "Y:", "X Error:", "Y Error:"};
        COLUMN_ALLOW_NONE = new boolean[]{true, false, true, true};
        previousColumns = new int[]{1, 1, 0, 0};
        defaultColumnIndex = new int[4];
        lastFitFunction = CurveFitter.fitList[0];
        previousColor = "blue";
        previousColor2 = "#a0a0ff";
        previousSymbol = "Circle";
        previousLineWidth = 1.0;
        PLOT_COLORS = new String[]{"blue", "red", "black", "#00c0ff", "#00e000", "gray", "#c08060", "magenta"};
    }
}

