/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.process.PolygonFiller;
import ij.util.FloatArray;
import ij.util.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Vector;

public class ShapeRoi
extends Roi {
    static final int NO_TYPE = 128;
    static final double MAXERROR = 0.001;
    static final double FLATNESS = 0.1;
    static final double FILL_FLATNESS = 0.01;
    private static final int MAXPOLY = 10;
    private static final int OR = 0;
    private static final int AND = 1;
    private static final int XOR = 2;
    private static final int NOT = 3;
    private Shape shape;
    private double maxerror = 0.001;
    private double flatness = 0.1;
    private int maxPoly = 10;
    private boolean flatten;
    private boolean forceTrace = false;
    private boolean forceAngle = false;
    private Vector savedRois;
    private static Stroke defaultStroke = new BasicStroke();
    static final int ALL_ROIS = 0;
    static final int ONE_ROI = 1;
    static final int GET_LENGTH = 2;
    static final int NO_SEGMENT_ANY_MORE = -1;

    public ShapeRoi(Roi r) {
        this(r, 0.1, 0.001, false, false, false, 10);
    }

    public ShapeRoi(Shape s) {
        super(s.getBounds());
        AffineTransform at = new AffineTransform();
        at.translate(-this.x, -this.y);
        this.shape = new GeneralPath(at.createTransformedShape(s));
        this.type = 9;
    }

    public ShapeRoi(int x, int y, Shape s) {
        super(x, y, s.getBounds().width, s.getBounds().height);
        this.shape = new GeneralPath(s);
        this.type = 9;
    }

    ShapeRoi(Roi r, double flatness, double maxerror, boolean forceAngle, boolean forceTrace, boolean flatten, int maxPoly) {
        super(r.startX, r.startY, r.width, r.height);
        this.type = 9;
        this.flatness = flatness;
        this.maxerror = maxerror;
        this.forceAngle = forceAngle;
        this.forceTrace = forceTrace;
        this.maxPoly = maxPoly;
        this.flatten = flatten;
        this.shape = this.roiToShape((Roi)r.clone());
    }

    public ShapeRoi(float[] shapeArray) {
        super(0, 0, null);
        this.shape = ShapeRoi.makeShapeFromArray(shapeArray);
        Rectangle r = this.shape.getBounds();
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
        this.state = 3;
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        AffineTransform at = new AffineTransform();
        at.translate(-this.x, -this.y);
        this.shape = new GeneralPath(at.createTransformedShape(this.shape));
        this.flatness = 0.1;
        this.maxerror = 0.001;
        this.maxPoly = 10;
        this.flatten = false;
        this.type = 9;
    }

    @Override
    public synchronized Object clone() {
        ShapeRoi sr = (ShapeRoi)super.clone();
        sr.type = 9;
        sr.flatness = this.flatness;
        sr.maxerror = this.maxerror;
        sr.forceAngle = this.forceAngle;
        sr.forceTrace = this.forceTrace;
        sr.setShape(ShapeRoi.cloneShape(this.shape));
        return sr;
    }

    static Shape cloneShape(Shape rhs) {
        if (rhs == null) {
            return null;
        }
        if (rhs instanceof Rectangle2D.Double) {
            return (Rectangle2D.Double)((Rectangle2D.Double)rhs).clone();
        }
        if (rhs instanceof Ellipse2D.Double) {
            return (Ellipse2D.Double)((Ellipse2D.Double)rhs).clone();
        }
        if (rhs instanceof Line2D.Double) {
            return (Line2D.Double)((Line2D.Double)rhs).clone();
        }
        if (rhs instanceof Polygon) {
            return new Polygon(((Polygon)rhs).xpoints, ((Polygon)rhs).ypoints, ((Polygon)rhs).npoints);
        }
        if (rhs instanceof GeneralPath) {
            return (GeneralPath)((GeneralPath)rhs).clone();
        }
        return ShapeRoi.makeShapeFromArray(ShapeRoi.getShapeAsArray(rhs, 0.0f, 0.0f));
    }

    public ShapeRoi or(ShapeRoi sr) {
        return this.unaryOp(sr, 0);
    }

    public ShapeRoi and(ShapeRoi sr) {
        return this.unaryOp(sr, 1);
    }

    public ShapeRoi xor(ShapeRoi sr) {
        return this.unaryOp(sr, 2);
    }

    public ShapeRoi not(ShapeRoi sr) {
        return this.unaryOp(sr, 3);
    }

    ShapeRoi unaryOp(ShapeRoi sr, int op) {
        AffineTransform at = new AffineTransform();
        at.translate(this.x, this.y);
        Area a1 = new Area(at.createTransformedShape(this.getShape()));
        at = new AffineTransform();
        at.translate(sr.x, sr.y);
        Area a2 = new Area(at.createTransformedShape(sr.getShape()));
        try {
            switch (op) {
                case 0: {
                    a1.add(a2);
                    break;
                }
                case 1: {
                    a1.intersect(a2);
                    break;
                }
                case 2: {
                    a1.exclusiveOr(a2);
                    break;
                }
                case 3: {
                    a1.subtract(a2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle r = a1.getBounds();
        at = new AffineTransform();
        at.translate(-r.x, -r.y);
        this.setShape(new GeneralPath(at.createTransformedShape(a1)));
        this.x = r.x;
        this.y = r.y;
        this.cachedMask = null;
        return this;
    }

    private Shape roiToShape(Roi roi) {
        if (roi.isLine()) {
            roi = Roi.convertLineToArea(roi);
        }
        Shape shape = null;
        Rectangle r = roi.getBounds();
        boolean closeShape = true;
        int roiType = roi.getType();
        switch (roiType) {
            case 5: {
                Line line = (Line)roi;
                shape = new Line2D.Double(line.x1 - r.x, line.y1 - r.y, line.x2 - r.x, line.y2 - r.y);
                break;
            }
            case 0: {
                int arcSize = roi.getCornerDiameter();
                if (arcSize > 0) {
                    shape = new RoundRectangle2D.Double(0.0, 0.0, r.width, r.height, arcSize, arcSize);
                    break;
                }
                shape = new Rectangle2D.Double(0.0, 0.0, r.width, r.height);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                closeShape = false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (roiType == 1) {
                    shape = ((OvalRoi)roi).getPolygon(false);
                    break;
                }
                if (closeShape && !roi.subPixelResolution()) {
                    int nPoints = ((PolygonRoi)roi).getNCoordinates();
                    int[] xCoords = ((PolygonRoi)roi).getXCoordinates();
                    int[] yCoords = ((PolygonRoi)roi).getYCoordinates();
                    shape = new Polygon(xCoords, yCoords, nPoints);
                    break;
                }
                FloatPolygon floatPoly = roi.getFloatPolygon();
                if (floatPoly.npoints <= 1) break;
                shape = new GeneralPath(closeShape ? 0 : 1, floatPoly.npoints);
                ((GeneralPath)shape).moveTo(floatPoly.xpoints[0] - (float)r.x, floatPoly.ypoints[0] - (float)r.y);
                for (int i = 1; i < floatPoly.npoints; ++i) {
                    ((GeneralPath)shape).lineTo(floatPoly.xpoints[i] - (float)r.x, floatPoly.ypoints[i] - (float)r.y);
                }
                if (!closeShape) break;
                ((GeneralPath)shape).closePath();
                break;
            }
            case 10: {
                ImageProcessor mask = roi.getMask();
                byte[] maskPixels = (byte[])mask.getPixels();
                int maskWidth = mask.getWidth();
                Area area = new Area();
                for (int y = 0; y < mask.getHeight(); ++y) {
                    int yOffset = y * maskWidth;
                    for (int x = 0; x < maskWidth; ++x) {
                        if (maskPixels[x + yOffset] == 0) continue;
                        area.add(new Area(new Rectangle(x, y, 1, 1)));
                    }
                }
                shape = area;
                break;
            }
            case 9: {
                shape = ShapeRoi.cloneShape(((ShapeRoi)roi).getShape());
                break;
            }
            default: {
                throw new IllegalArgumentException("Roi type not supported");
            }
        }
        if (shape != null) {
            this.setLocation(r.x, r.y);
            Rectangle2D shapeBounds = shape.getBounds2D();
            Rectangle2D.Double sBounds = null;
            if (shapeBounds instanceof Rectangle2D.Double) {
                sBounds = (Rectangle2D.Double)shapeBounds;
            } else {
                sBounds = new Rectangle2D.Double();
                sBounds.setRect(shapeBounds);
            }
            this.width = (int)(Math.max(sBounds.x, 0.0) + sBounds.width + 0.5);
            this.height = (int)(Math.max(sBounds.y, 0.0) + sBounds.height + 0.5);
            if (this.bounds != null) {
                this.bounds.width = this.width;
                this.bounds.height = this.height;
            }
            this.startX = this.x;
            this.startY = this.y;
        }
        return shape;
    }

    static GeneralPath makeShapeFromArray(float[] array) {
        if (array == null) {
            return null;
        }
        GeneralPath s = new GeneralPath(0);
        int index = 0;
        float[] seg = new float[7];
        while ((index = ShapeRoi.getSegment(array, seg, index)) >= 0) {
            int type = (int)seg[0];
            switch (type) {
                case 0: {
                    s.moveTo(seg[1], seg[2]);
                    break;
                }
                case 1: {
                    s.lineTo(seg[1], seg[2]);
                    break;
                }
                case 2: {
                    s.quadTo(seg[1], seg[2], seg[3], seg[4]);
                    break;
                }
                case 3: {
                    s.curveTo(seg[1], seg[2], seg[3], seg[4], seg[5], seg[6]);
                    break;
                }
                case 4: {
                    s.closePath();
                    break;
                }
            }
        }
        return s;
    }

    private static int getSegment(float[] array, float[] seg, int index) {
        int len = array.length;
        if (index >= len) {
            return -1;
        }
        seg[0] = array[index++];
        int type = (int)seg[0];
        int nCoords = ShapeRoi.nCoords(type);
        if (index + nCoords > len) {
            return -1;
        }
        for (int i = 1; i <= nCoords; ++i) {
            seg[i] = array[index++];
        }
        return index;
    }

    private static int nCoords(int segmentType) {
        switch (segmentType) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 0;
            }
        }
        throw new RuntimeException("Invalid Segment Type: " + segmentType);
    }

    void saveRoi(Roi roi) {
        if (this.savedRois == null) {
            this.savedRois = new Vector();
        }
        this.savedRois.addElement(roi);
    }

    public Roi[] getRois() {
        if (this.shape == null) {
            return new Roi[0];
        }
        if (this.savedRois != null) {
            return this.savedRois.toArray(new Roi[this.savedRois.size()]);
        }
        ArrayList<Roi> rois = new ArrayList<Roi>();
        if (this.shape instanceof Rectangle2D.Double) {
            Roi r = new Roi((int)((Rectangle2D.Double)this.shape).getX(), (int)((Rectangle2D.Double)this.shape).getY(), (int)((Rectangle2D.Double)this.shape).getWidth(), (int)((Rectangle2D.Double)this.shape).getHeight());
            rois.add(r);
        } else if (this.shape instanceof Ellipse2D.Double) {
            OvalRoi r = new OvalRoi((int)((Ellipse2D.Double)this.shape).getX(), (int)((Ellipse2D.Double)this.shape).getY(), (int)((Ellipse2D.Double)this.shape).getWidth(), (int)((Ellipse2D.Double)this.shape).getHeight());
            rois.add(r);
        } else if (this.shape instanceof Line2D.Double) {
            Line r = new Line((int)((Line2D.Double)this.shape).getX1(), (int)((Line2D.Double)this.shape).getY1(), (int)((Line2D.Double)this.shape).getX2(), (int)((Line2D.Double)this.shape).getY2());
            rois.add(r);
        } else if (this.shape instanceof Polygon) {
            PolygonRoi r = new PolygonRoi(((Polygon)this.shape).xpoints, ((Polygon)this.shape).ypoints, ((Polygon)this.shape).npoints, 2);
            rois.add(r);
        } else {
            PathIterator pIter = this.flatten ? this.getFlatteningPathIterator(this.shape, this.flatness) : this.shape.getPathIterator(new AffineTransform());
            this.parsePath(pIter, 0, rois);
        }
        return rois.toArray(new Roi[rois.size()]);
    }

    public Roi shapeToRoi() {
        if (this.shape == null || !(this.shape instanceof GeneralPath)) {
            return null;
        }
        PathIterator pIter = this.shape.getPathIterator(new AffineTransform());
        ArrayList rois = new ArrayList();
        this.parsePath(pIter, 1, rois);
        if (rois.size() == 1) {
            return (Roi)rois.get(0);
        }
        return null;
    }

    public Roi trySimplify() {
        Roi roi = this.shapeToRoi();
        return roi == null ? this : roi;
    }

    private int guessType(int nSegments, double polygonLength, boolean horizontalVerticalIntOnly, boolean forceTrace, boolean closed) {
        int roiType = 0;
        if (Double.isNaN(polygonLength)) {
            roiType = 9;
        } else {
            boolean longEdges;
            boolean bl = longEdges = polygonLength / ((double)nSegments * Math.sqrt(nSegments)) >= 2.0;
            roiType = nSegments < 2 ? 128 : (nSegments == 2 ? (closed ? 128 : 5) : (nSegments == 3 && !closed && this.forceAngle ? 8 : (nSegments == 4 && closed && horizontalVerticalIntOnly && longEdges && !forceTrace && !this.forceTrace ? 0 : (closed && horizontalVerticalIntOnly && (!longEdges || forceTrace || this.forceTrace) ? 4 : (nSegments <= 10 || longEdges ? (closed ? 2 : 6) : (closed ? 3 : 7))))));
        }
        return roiType;
    }

    private Roi createRoi(float[] xPoints, float[] yPoints, int roiType) {
        if (roiType == 128 || roiType == 9) {
            return null;
        }
        Roi roi = null;
        if (xPoints == null || yPoints == null || xPoints.length != yPoints.length || xPoints.length == 0) {
            return null;
        }
        Tools.addToArray(xPoints, (float)this.getXBase());
        Tools.addToArray(yPoints, (float)this.getYBase());
        switch (roiType) {
            case 5: {
                roi = new Line(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
                break;
            }
            case 0: {
                double[] xMinMax = Tools.getMinMax(xPoints);
                double[] yMinMax = Tools.getMinMax(yPoints);
                roi = new Roi((int)xMinMax[0], (int)yMinMax[0], (int)xMinMax[1] - (int)xMinMax[0], (int)yMinMax[1] - (int)yMinMax[0]);
                break;
            }
            case 4: {
                roi = new PolygonRoi(ShapeRoi.toIntR(xPoints), ShapeRoi.toIntR(yPoints), xPoints.length, roiType);
                break;
            }
            default: {
                roi = new PolygonRoi(xPoints, yPoints, xPoints.length, roiType);
            }
        }
        return roi;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null) {
            return false;
        }
        return this.shape.contains((double)(x - this.x) + 0.494, (double)(y - this.y) + 0.49994);
    }

    @Override
    public boolean containsPoint(double x, double y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        return this.shape.contains(x - (double)this.x + 0.001, y - (double)this.y + 1.0E-6);
    }

    @Override
    public double getLength() {
        if (this.width == 0 && this.height == 0) {
            return 0.0;
        }
        return this.parsePath(this.shape.getPathIterator(new AffineTransform()), 2, null);
    }

    PathIterator getFlatteningPathIterator(Shape s, double fl) {
        return s.getPathIterator(new AffineTransform(), fl);
    }

    double cplength(CubicCurve2D.Double c) {
        return Math.sqrt(ShapeRoi.sqr(c.ctrlx1 - c.x1) + ShapeRoi.sqr(c.ctrly1 - c.y1)) + Math.sqrt(ShapeRoi.sqr(c.ctrlx2 - c.ctrlx1) + ShapeRoi.sqr(c.ctrly2 - c.ctrly1)) + Math.sqrt(ShapeRoi.sqr(c.x2 - c.ctrlx2) + ShapeRoi.sqr(c.y2 - c.ctrly2));
    }

    double qplength(QuadCurve2D.Double c) {
        return Math.sqrt(ShapeRoi.sqr(c.ctrlx - c.x1) + ShapeRoi.sqr(c.ctrly - c.y1)) + Math.sqrt(ShapeRoi.sqr(c.x2 - c.ctrlx) + ShapeRoi.sqr(c.y2 - c.ctrly));
    }

    double cclength(CubicCurve2D.Double c) {
        return Math.sqrt(ShapeRoi.sqr(c.x2 - c.x1) + ShapeRoi.sqr(c.y2 - c.y1));
    }

    double qclength(QuadCurve2D.Double c) {
        return Math.sqrt(ShapeRoi.sqr(c.x2 - c.x1) + ShapeRoi.sqr(c.y2 - c.y1));
    }

    double cBezLength(CubicCurve2D.Double c) {
        double l = 0.0;
        double cl = this.cclength(c);
        double pl = this.cplength(c);
        if ((pl - cl) / 2.0 > this.maxerror) {
            CubicCurve2D.Double[] cc = this.cBezSplit(c);
            for (int i = 0; i < 2; ++i) {
                l += this.cBezLength(cc[i]);
            }
            return l;
        }
        l = 0.5 * pl + 0.5 * cl;
        return l;
    }

    double qBezLength(QuadCurve2D.Double c) {
        double l = 0.0;
        double cl = this.qclength(c);
        double pl = this.qplength(c);
        if ((pl - cl) / 2.0 > this.maxerror) {
            QuadCurve2D.Double[] cc = this.qBezSplit(c);
            for (int i = 0; i < 2; ++i) {
                l += this.qBezLength(cc[i]);
            }
            return l;
        }
        l = (2.0 * pl + cl) / 3.0;
        return l;
    }

    CubicCurve2D.Double[] cBezSplit(CubicCurve2D.Double c) {
        CubicCurve2D.Double[] cc = new CubicCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            cc[i] = new CubicCurve2D.Double();
        }
        c.subdivide(cc[0], cc[1]);
        return cc;
    }

    QuadCurve2D.Double[] qBezSplit(QuadCurve2D.Double c) {
        QuadCurve2D.Double[] cc = new QuadCurve2D.Double[2];
        for (int i = 0; i < 2; ++i) {
            cc[i] = new QuadCurve2D.Double();
        }
        c.subdivide(cc[0], cc[1]);
        return cc;
    }

    void scaleCoords(double[] c, int n, double pw, double ph) {
        int i = 0;
        while (i < n) {
            int n2 = i++;
            c[n2] = c[n2] * pw;
            int n3 = i++;
            c[n3] = c[n3] * ph;
        }
    }

    static void addOffset(float[] c, int n, float xBase, float yBase) {
        int i = 0;
        while (i < n) {
            int n2 = i++;
            c[n2] = c[n2] + xBase;
            int n3 = i++;
            c[n3] = c[n3] + yBase;
        }
    }

    public float[] getShapeAsArray() {
        return ShapeRoi.getShapeAsArray(this.shape, (float)this.getXBase(), (float)this.getYBase());
    }

    static float[] getShapeAsArray(Shape shape, float xBase, float yBase) {
        if (shape == null) {
            return null;
        }
        PathIterator pIt = shape.getPathIterator(new AffineTransform());
        FloatArray shapeArray = new FloatArray();
        float[] coords = new float[6];
        while (!pIt.isDone()) {
            int segType = pIt.currentSegment(coords);
            shapeArray.add(segType);
            int nCoords = ShapeRoi.nCoords(segType);
            if (nCoords > 0) {
                ShapeRoi.addOffset(coords, nCoords, xBase, yBase);
                shapeArray.add(coords, nCoords);
            }
            pIt.next();
        }
        return shapeArray.toArray();
    }

    double parsePath(PathIterator pIter, int task, ArrayList rois) {
        if (pIter == null || pIter.isDone()) {
            return 0.0;
        }
        double pw = 1.0;
        double ph = 1.0;
        if (this.imp != null) {
            Calibration cal = this.imp.getCalibration();
            pw = cal.pixelWidth;
            ph = cal.pixelHeight;
        }
        float xbase = (float)this.getXBase();
        float ybase = (float)this.getYBase();
        FloatArray xPoints = new FloatArray();
        FloatArray yPoints = new FloatArray();
        FloatArray shapeArray = new FloatArray();
        boolean getLength = task == 2;
        int nSubPaths = 0;
        boolean horVertOnly = true;
        boolean closed = false;
        float[] fcoords = new float[6];
        double[] coords = new double[6];
        double startCalX = 0.0;
        double startCalY = 0.0;
        double lastCalX = 0.0;
        double lastCalY = 0.0;
        double pathLength = 0.0;
        double totalLength = 0.0;
        double uncalLength = 0.0;
        boolean done = false;
        while (true) {
            int segType = done ? -1 : pIter.currentSegment(fcoords);
            int nCoords = 0;
            if (!done) {
                nCoords = ShapeRoi.nCoords(segType);
                if (getLength) {
                    pIter.currentSegment(coords);
                    this.scaleCoords(coords, nCoords, pw, ph);
                }
                pIter.next();
                done = pIter.isDone();
            }
            if (segType == -1 || segType == 0 && xPoints.size() > 0) {
                closed = closed || xPoints.size() > 0 && xPoints.get(0) == xPoints.getLast() && yPoints.get(0) == yPoints.getLast();
                float[] xpf = xPoints.toArray();
                float[] ypf = yPoints.toArray();
                if (Double.isNaN(uncalLength) || !this.allInteger(xpf) || !this.allInteger(ypf)) {
                    horVertOnly = false;
                }
                boolean forceTrace = getLength && (!done || nSubPaths > 0);
                int roiType = this.guessType(xPoints.size(), uncalLength, horVertOnly, forceTrace, closed);
                Roi roi = null;
                if (roiType == 9 && rois != null) {
                    GeneralPath shape = ShapeRoi.makeShapeFromArray(shapeArray.toArray());
                    FloatPolygon fp = this.getFloatPolygon(shape, 0.1, false, false, false);
                    roi = new PolygonRoi(fp, 3);
                } else if (roiType != 128) {
                    roi = this.createRoi(xpf, ypf, roiType);
                }
                if (rois != null && roi != null) {
                    rois.add(roi);
                }
                if (task == 1 && rois.size() > 1) {
                    rois.clear();
                    rois.add(this);
                    return 0.0;
                }
                if (getLength && roi != null && !Double.isNaN(uncalLength)) {
                    roi.setImage(this.imp);
                    pathLength = roi.getLength();
                    roi.setImage(null);
                }
                totalLength += pathLength;
            }
            if (segType == -1) {
                return getLength ? totalLength : 0.0;
            }
            closed = false;
            switch (segType) {
                case 0: {
                    xPoints.clear();
                    yPoints.clear();
                    shapeArray.clear();
                    ++nSubPaths;
                    pathLength = 0.0;
                    startCalX = coords[0];
                    startCalY = coords[1];
                    closed = false;
                    horVertOnly = true;
                    break;
                }
                case 1: {
                    pathLength += Math.sqrt(ShapeRoi.sqr(lastCalY - coords[1]) + ShapeRoi.sqr(lastCalX - coords[0]));
                    break;
                }
                case 2: {
                    Shape curve;
                    if (getLength) {
                        curve = new QuadCurve2D.Double(lastCalX, lastCalY, coords[0], coords[2], coords[2], coords[3]);
                        pathLength += this.qBezLength((QuadCurve2D.Double)curve);
                    }
                    uncalLength = Double.NaN;
                    break;
                }
                case 3: {
                    Shape curve;
                    if (getLength) {
                        curve = new CubicCurve2D.Double(lastCalX, lastCalY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                        pathLength += this.cBezLength((CubicCurve2D.Double)curve);
                    }
                    uncalLength = Double.NaN;
                    break;
                }
                case 4: {
                    pathLength += Math.sqrt(ShapeRoi.sqr(lastCalX - startCalX) + ShapeRoi.sqr(lastCalY - startCalY));
                    fcoords[0] = xPoints.get(0);
                    fcoords[1] = yPoints.get(0);
                    closed = true;
                    break;
                }
            }
            if (xPoints.size() > 0 && (segType == 1 || segType == 4)) {
                float dx = fcoords[0] - xPoints.getLast();
                float dy = fcoords[1] - yPoints.getLast();
                uncalLength += Math.sqrt(ShapeRoi.sqr(dx) + ShapeRoi.sqr(dy));
                if (dx != 0.0f && dy != 0.0f) {
                    horVertOnly = false;
                }
            }
            if (nCoords > 0) {
                xPoints.add(fcoords[nCoords - 2]);
                yPoints.add(fcoords[nCoords - 1]);
                lastCalX = coords[nCoords - 2];
                lastCalY = coords[nCoords - 1];
            }
            shapeArray.add(segType);
            ShapeRoi.addOffset(fcoords, nCoords, xbase, ybase);
            shapeArray.add(fcoords, ShapeRoi.nCoords(segType));
        }
    }

    @Override
    public void draw(Graphics g) {
        boolean isActiveOverlayRoi;
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        boolean bl = isActiveOverlayRoi = !this.overlay && this.isActiveOverlayRoi();
        if (isActiveOverlayRoi) {
            color = color == Color.cyan ? Color.magenta : Color.cyan;
        }
        if (this.fillColor != null) {
            color = this.fillColor;
        }
        g.setColor(color);
        AffineTransform aTx = ((Graphics2D)g).getDeviceConfiguration().getDefaultTransform();
        Graphics2D g2d = (Graphics2D)g;
        if (this.stroke != null && !isActiveOverlayRoi) {
            g2d.setStroke(this.ic != null && this.ic.getCustomRoi() || this.isCursor() ? this.stroke : this.getScaledStroke());
        }
        this.mag = this.getMagnification();
        int basex = 0;
        int basey = 0;
        if (this.ic != null) {
            Rectangle r = this.ic.getSrcRect();
            basex = r.x;
            basey = r.y;
        }
        aTx.setTransform(this.mag, 0.0, 0.0, this.mag, (double)(-basex) * this.mag, (double)(-basey) * this.mag);
        aTx.translate(this.getXBase(), this.getYBase());
        if (this.fillColor != null) {
            if (isActiveOverlayRoi) {
                g2d.setColor(Color.cyan);
                g2d.draw(aTx.createTransformedShape(this.shape));
            } else {
                g2d.fill(aTx.createTransformedShape(this.shape));
                if (this.strokeColor != null) {
                    g.setColor(this.strokeColor);
                    g2d.draw(aTx.createTransformedShape(this.shape));
                }
            }
        } else {
            g2d.draw(aTx.createTransformedShape(this.shape));
        }
        if (this.stroke != null) {
            g2d.setStroke(defaultStroke);
        }
        if (Toolbar.getToolId() == 1) {
            this.drawRoiBrush(g);
        }
        if (this.state != 3 && this.imp != null && this.imp.getRoi() != null) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public void drawRoiBrush(Graphics g) {
        g.setColor(ROIColor);
        int size = Toolbar.getBrushSize();
        if (size == 0 || this.ic == null) {
            return;
        }
        int flags = this.ic.getModifiers();
        if ((flags & 0x10) == 0) {
            return;
        }
        int osize = size;
        size = (int)((double)size * this.mag);
        Point p = this.ic.getCursorLoc();
        int sx = this.ic.screenX(p.x);
        int sy = this.ic.screenY(p.y);
        int offset = (int)Math.round(this.ic.getMagnification() / 2.0);
        if ((osize & 1) == 0) {
            offset = 0;
        }
        g.drawOval(sx - size / 2 + offset, sy - size / 2 + offset, size, size);
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        PathIterator pIter = this.shape.getPathIterator(new AffineTransform(), this.flatness);
        float[] coords = new float[6];
        float sx = 0.0f;
        float sy = 0.0f;
        while (!pIter.isDone()) {
            int segType = pIter.currentSegment(coords);
            switch (segType) {
                case 0: {
                    sx = coords[0];
                    sy = coords[1];
                    ip.moveTo(this.x + (int)sx, this.y + (int)sy);
                    break;
                }
                case 1: {
                    ip.lineTo(this.x + (int)coords[0], this.y + (int)coords[1]);
                    break;
                }
                case 4: {
                    ip.lineTo(this.x + (int)sx, this.y + (int)sy);
                    break;
                }
            }
            pIter.next();
        }
    }

    @Override
    public ImageProcessor getMask() {
        if (this.shape == null) {
            return null;
        }
        ImageProcessor mask = this.cachedMask;
        if (mask != null && mask.getPixels() != null && mask.getWidth() == this.width && mask.getHeight() == this.height) {
            return mask;
        }
        FloatPolygon fpoly = this.getFloatPolygon(0.01, true, false, false);
        PolygonFiller pf = new PolygonFiller(fpoly.xpoints, fpoly.ypoints, fpoly.npoints, (float)(this.getXBase() - (double)this.x), (float)(this.getYBase() - (double)this.y));
        this.cachedMask = mask = pf.getMask(this.width, this.height);
        return mask;
    }

    public Shape getShape() {
        return this.shape;
    }

    boolean setShape(Shape rhs) {
        boolean result = true;
        if (rhs == null) {
            return false;
        }
        if (this.shape.equals(rhs)) {
            return false;
        }
        this.shape = rhs;
        this.type = 9;
        Rectangle rect = this.shape.getBounds();
        this.width = rect.width;
        this.height = rect.height;
        return true;
    }

    private int min(int[] array) {
        int val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.min(val, array[i]);
        }
        return val;
    }

    private int max(int[] array) {
        int val = array[0];
        for (int i = 1; i < array.length; ++i) {
            val = Math.max(val, array[i]);
        }
        return val;
    }

    static ShapeRoi getCircularRoi(int x, int y, int width) {
        return new ShapeRoi(new OvalRoi(x - width / 2, y - width / 2, width, width));
    }

    @Override
    public int isHandle(int sx, int sy) {
        return -1;
    }

    public FloatPolygon getSelectionCoordinates() {
        return this.getFloatPolygon(0.1, true, false, true);
    }

    public FloatPolygon getFloatPolygon(double flatness, boolean separateSubpaths, boolean addPointForClose, boolean absoluteCoord) {
        return this.getFloatPolygon(this.shape, flatness, separateSubpaths, addPointForClose, absoluteCoord);
    }

    public FloatPolygon getFloatPolygon(Shape shape, double flatness, boolean separateSubpaths, boolean addPointForClose, boolean absoluteCoord) {
        int n;
        if (shape == null) {
            return null;
        }
        PathIterator pIter = this.getFlatteningPathIterator(shape, flatness);
        FloatArray xp = new FloatArray();
        FloatArray yp = new FloatArray();
        float[] coords = new float[6];
        int subPathStart = 0;
        while (!pIter.isDone()) {
            int segType = pIter.currentSegment(coords);
            switch (segType) {
                case 0: {
                    if (separateSubpaths && xp.size() > 0 && !Float.isNaN(xp.get(xp.size() - 1))) {
                        xp.add(Float.NaN);
                        yp.add(Float.NaN);
                    }
                    subPathStart = xp.size();
                }
                case 1: {
                    xp.add(coords[0]);
                    yp.add(coords[1]);
                    break;
                }
                case 4: {
                    boolean isClosed;
                    boolean bl = isClosed = xp.getLast() == xp.get(subPathStart) && yp.getLast() == yp.get(subPathStart);
                    if (addPointForClose && !isClosed) {
                        xp.add(xp.get(subPathStart));
                        yp.add(yp.get(subPathStart));
                    } else if (isClosed) {
                        xp.removeLast(1);
                        yp.removeLast(1);
                    }
                    if (!separateSubpaths || xp.size() <= 0 || Float.isNaN(xp.get(xp.size() - 1))) break;
                    xp.add(Float.NaN);
                    yp.add(Float.NaN);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Segment Type: " + segType);
                }
            }
            pIter.next();
        }
        float[] xpf = xp.toArray();
        float[] ypf = yp.toArray();
        if (absoluteCoord) {
            Tools.addToArray(xpf, (float)this.getXBase());
            Tools.addToArray(ypf, (float)this.getYBase());
        }
        if ((n = xpf.length) > 0 && Float.isNaN(xpf[n - 1])) {
            --n;
        }
        return new FloatPolygon(xpf, ypf, n);
    }

    @Override
    public FloatPolygon getFloatConvexHull() {
        FloatPolygon fp = this.getFloatPolygon(0.1, false, false, true);
        return fp == null ? null : fp.getConvexHull();
    }

    @Override
    public Polygon getPolygon() {
        FloatPolygon fp = this.getFloatPolygon();
        return new Polygon(ShapeRoi.toIntR(fp.xpoints), ShapeRoi.toIntR(fp.ypoints), fp.npoints);
    }

    @Override
    public FloatPolygon getFloatPolygon() {
        return this.getFloatPolygon(0.1, false, false, true);
    }

    @Override
    public FloatPolygon getFloatPolygon(String options) {
        boolean separateSubpaths = (options = options.toLowerCase()).indexOf("separate") >= 0;
        boolean addPointForClose = options.indexOf("close") >= 0;
        return this.getFloatPolygon(0.1, separateSubpaths, addPointForClose, true);
    }

    @Override
    public int size() {
        return this.getPolygon().npoints;
    }

    boolean allInteger(float[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == (float)((int)a[i])) continue;
            return false;
        }
        return true;
    }
}

