/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Arrow;
import ij.gui.EllipseRoi;
import ij.gui.ImageRoi;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.io.Opener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RoiDecoder {
    public static final int VERSION_OFFSET = 4;
    public static final int TYPE = 6;
    public static final int TOP = 8;
    public static final int LEFT = 10;
    public static final int BOTTOM = 12;
    public static final int RIGHT = 14;
    public static final int N_COORDINATES = 16;
    public static final int X1 = 18;
    public static final int Y1 = 22;
    public static final int X2 = 26;
    public static final int Y2 = 30;
    public static final int XD = 18;
    public static final int YD = 22;
    public static final int WIDTHD = 26;
    public static final int HEIGHTD = 30;
    public static final int SIZE = 18;
    public static final int STROKE_WIDTH = 34;
    public static final int SHAPE_ROI_SIZE = 36;
    public static final int STROKE_COLOR = 40;
    public static final int FILL_COLOR = 44;
    public static final int SUBTYPE = 48;
    public static final int OPTIONS = 50;
    public static final int ARROW_STYLE = 52;
    public static final int FLOAT_PARAM = 52;
    public static final int POINT_TYPE = 52;
    public static final int ARROW_HEAD_SIZE = 53;
    public static final int ROUNDED_RECT_ARC_SIZE = 54;
    public static final int POSITION = 56;
    public static final int HEADER2_OFFSET = 60;
    public static final int COORDINATES = 64;
    public static final int C_POSITION = 4;
    public static final int Z_POSITION = 8;
    public static final int T_POSITION = 12;
    public static final int NAME_OFFSET = 16;
    public static final int NAME_LENGTH = 20;
    public static final int OVERLAY_LABEL_COLOR = 24;
    public static final int OVERLAY_FONT_SIZE = 28;
    public static final int GROUP = 30;
    public static final int IMAGE_OPACITY = 31;
    public static final int IMAGE_SIZE = 32;
    public static final int FLOAT_STROKE_WIDTH = 36;
    public static final int ROI_PROPS_OFFSET = 40;
    public static final int ROI_PROPS_LENGTH = 44;
    public static final int COUNTERS_OFFSET = 48;
    public static final int TEXT = 1;
    public static final int ARROW = 2;
    public static final int ELLIPSE = 3;
    public static final int IMAGE = 4;
    public static final int ROTATED_RECT = 5;
    public static final int SPLINE_FIT = 1;
    public static final int DOUBLE_HEADED = 2;
    public static final int OUTLINE = 4;
    public static final int OVERLAY_LABELS = 8;
    public static final int OVERLAY_NAMES = 16;
    public static final int OVERLAY_BACKGROUNDS = 32;
    public static final int OVERLAY_BOLD = 64;
    public static final int SUB_PIXEL_RESOLUTION = 128;
    public static final int DRAW_OFFSET = 256;
    public static final int ZERO_TRANSPARENT = 512;
    public static final int SHOW_LABELS = 1024;
    public static final int SCALE_LABELS = 2048;
    public static final int PROMPT_BEFORE_DELETING = 4096;
    public static final int SCALE_STROKE_WIDTH = 8192;
    private final int polygon = 0;
    private final int rect = 1;
    private final int oval = 2;
    private final int line = 3;
    private final int freeline = 4;
    private final int polyline = 5;
    private final int noRoi = 6;
    private final int freehand = 7;
    private final int traced = 8;
    private final int angle = 9;
    private final int point = 10;
    private byte[] data;
    private String path;
    private InputStream is;
    private String name;
    private int size;

    public RoiDecoder(String path) {
        this.path = path;
    }

    public RoiDecoder(byte[] bytes, String name) {
        this.is = new ByteArrayInputStream(bytes);
        this.name = name;
        this.size = bytes.length;
    }

    public static Roi open(String path) {
        Roi roi = null;
        RoiDecoder rd = new RoiDecoder(path);
        try {
            roi = rd.getRoi();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return roi;
    }

    public Roi getRoi() throws IOException {
        int[] counters;
        String props;
        if (this.path != null) {
            File f = new File(this.path);
            this.size = (int)f.length();
            if (!this.path.endsWith(".roi") && this.size > 0x500000) {
                throw new IOException("This is not an ROI or file size>5MB)");
            }
            this.name = f.getName();
            this.is = new FileInputStream(this.path);
        }
        this.data = new byte[this.size];
        for (int total = 0; total < this.size; total += this.is.read(this.data, total, this.size - total)) {
        }
        this.is.close();
        if (this.getByte(0) != 73 || this.getByte(1) != 111) {
            throw new IOException("This is not an ImageJ ROI");
        }
        int version = this.getShort(4);
        int type = this.getByte(6);
        int subtype = this.getShort(48);
        int top = this.getShort(8);
        int left = this.getShort(10);
        int bottom = this.getShort(12);
        int right = this.getShort(14);
        int width = right - left;
        int height = bottom - top;
        int n = this.getUnsignedShort(16);
        if (n == 0) {
            n = this.getInt(18);
        }
        int options = this.getShort(50);
        int position = this.getInt(56);
        int hdr2Offset = this.getInt(60);
        int channel = 0;
        int slice = 0;
        int frame = 0;
        int overlayLabelColor = 0;
        int overlayFontSize = 0;
        int group = 0;
        int imageOpacity = 0;
        int imageSize = 0;
        boolean subPixelResolution = (options & 0x80) != 0 && version >= 222;
        boolean drawOffset = subPixelResolution && (options & 0x100) != 0;
        boolean scaleStrokeWidth = true;
        if (version >= 228) {
            scaleStrokeWidth = (options & 0x2000) != 0;
        }
        boolean subPixelRect = version >= 223 && subPixelResolution && (type == 1 || type == 2);
        double xd = 0.0;
        double yd = 0.0;
        double widthd = 0.0;
        double heightd = 0.0;
        if (subPixelRect) {
            xd = this.getFloat(18);
            yd = this.getFloat(22);
            widthd = this.getFloat(26);
            heightd = this.getFloat(30);
        }
        if (hdr2Offset > 0 && hdr2Offset + 32 + 4 <= this.size) {
            channel = this.getInt(hdr2Offset + 4);
            slice = this.getInt(hdr2Offset + 8);
            frame = this.getInt(hdr2Offset + 12);
            overlayLabelColor = this.getInt(hdr2Offset + 24);
            overlayFontSize = this.getShort(hdr2Offset + 28);
            imageOpacity = this.getByte(hdr2Offset + 31);
            imageSize = this.getInt(hdr2Offset + 32);
            group = this.getByte(hdr2Offset + 30);
        }
        if (this.name != null && this.name.endsWith(".roi")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        boolean isComposite = this.getInt(36) > 0;
        Roi roi = null;
        if (isComposite) {
            String props2;
            roi = this.getShapeRoi();
            if (version >= 218) {
                this.getStrokeWidthAndColor(roi, hdr2Offset, scaleStrokeWidth);
            }
            roi.setPosition(position);
            if (channel > 0 || slice > 0 || frame > 0) {
                roi.setPosition(channel, slice, frame);
            }
            this.decodeOverlayOptions(roi, version, options, overlayLabelColor, overlayFontSize);
            if (version >= 224 && (props2 = this.getRoiProps()) != null) {
                roi.setProperties(props2);
            }
            if (version >= 228 && group > 0) {
                roi.setGroup(group);
            }
            return roi;
        }
        switch (type) {
            case 1: {
                roi = subPixelRect ? new Roi(xd, yd, widthd, heightd) : new Roi(left, top, width, height);
                int arcSize = this.getShort(54);
                if (arcSize <= 0) break;
                roi.setCornerDiameter(arcSize);
                break;
            }
            case 2: {
                if (subPixelRect) {
                    roi = new OvalRoi(xd, yd, widthd, heightd);
                    break;
                }
                roi = new OvalRoi(left, top, width, height);
                break;
            }
            case 3: {
                double x1 = this.getFloat(18);
                double y1 = this.getFloat(22);
                double x2 = this.getFloat(26);
                double y2 = this.getFloat(30);
                if (subtype == 2) {
                    int headSize;
                    roi = new Arrow(x1, y1, x2, y2);
                    ((Arrow)roi).setDoubleHeaded((options & 2) != 0);
                    ((Arrow)roi).setOutline((options & 4) != 0);
                    int style = this.getByte(52);
                    if (style >= 0 && style <= 4) {
                        ((Arrow)roi).setStyle(style);
                    }
                    if ((headSize = this.getByte(53)) < 0 || style > 30) break;
                    ((Arrow)roi).setHeadSize(headSize);
                    break;
                }
                roi = new Line(x1, y1, x2, y2);
                roi.setDrawOffset(drawOffset);
                break;
            }
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                int roiType;
                int i;
                if (n == 0 || n < 0) break;
                int[] x = new int[n];
                int[] y = new int[n];
                float[] xf = null;
                float[] yf = null;
                int base1 = 64;
                int base2 = base1 + 2 * n;
                for (i = 0; i < n; ++i) {
                    int ytmp;
                    int xtmp = this.getShort(base1 + i * 2);
                    if (xtmp < 0) {
                        xtmp = 0;
                    }
                    if ((ytmp = this.getShort(base2 + i * 2)) < 0) {
                        ytmp = 0;
                    }
                    x[i] = left + xtmp;
                    y[i] = top + ytmp;
                }
                if (subPixelResolution) {
                    xf = new float[n];
                    yf = new float[n];
                    base1 = 64 + 4 * n;
                    base2 = base1 + 4 * n;
                    for (i = 0; i < n; ++i) {
                        xf[i] = this.getFloat(base1 + i * 4);
                        yf[i] = this.getFloat(base2 + i * 4);
                    }
                }
                if (type == 10) {
                    roi = subPixelResolution ? new PointRoi(xf, yf, n) : new PointRoi(x, y, n);
                    if (version >= 226) {
                        ((PointRoi)roi).setPointType(this.getByte(52));
                        ((PointRoi)roi).setSize(this.getShort(34));
                    }
                    if ((options & 0x400) != 0 && !Prefs.noPointLabels) {
                        ((PointRoi)roi).setShowLabels(true);
                    }
                    if ((options & 0x1000) == 0) break;
                    ((PointRoi)roi).promptBeforeDeleting(true);
                    break;
                }
                if (type == 0) {
                    roiType = 2;
                } else if (type == 7) {
                    roiType = 3;
                    if (subtype == 3 || subtype == 5) {
                        double ex1 = this.getFloat(18);
                        double ey1 = this.getFloat(22);
                        double ex2 = this.getFloat(26);
                        double ey2 = this.getFloat(30);
                        double param = this.getFloat(52);
                        if (subtype == 5) {
                            roi = new RotatedRectRoi(ex1, ey1, ex2, ey2, param);
                            break;
                        }
                        roi = new EllipseRoi(ex1, ey1, ex2, ey2, param);
                        break;
                    }
                } else {
                    roiType = type == 8 ? 4 : (type == 5 ? 6 : (type == 4 ? 7 : (type == 9 ? 8 : 3)));
                }
                if (subPixelResolution) {
                    roi = new PolygonRoi(xf, yf, n, roiType);
                    roi.setDrawOffset(drawOffset);
                    break;
                }
                roi = new PolygonRoi(x, y, n, roiType);
                break;
            }
            default: {
                throw new IOException("Unrecognized ROI type: " + type);
            }
        }
        if (roi == null) {
            return null;
        }
        roi.setName(this.getRoiName());
        if (version >= 218) {
            boolean splineFit;
            this.getStrokeWidthAndColor(roi, hdr2Offset, scaleStrokeWidth);
            if (type == 10) {
                roi.setStrokeWidth(0.0f);
            }
            boolean bl = splineFit = (options & 1) != 0;
            if (splineFit && roi instanceof PolygonRoi) {
                ((PolygonRoi)roi).fitSpline();
            }
        }
        if (version >= 218 && subtype == 1) {
            roi = this.getTextRoi(roi, version);
        }
        if (version >= 221 && subtype == 4) {
            roi = this.getImageRoi(roi, imageOpacity, imageSize, options);
        }
        if (version >= 224 && (props = this.getRoiProps()) != null) {
            roi.setProperties(props);
        }
        if (version >= 227 && (counters = this.getPointCounters(n)) != null && roi instanceof PointRoi) {
            ((PointRoi)roi).setCounters(counters);
        }
        if (version >= 228 && group > 0) {
            roi.setGroup(group);
        }
        roi.setPosition(position);
        if (channel > 0 || slice > 0 || frame > 0) {
            roi.setPosition(channel, slice, frame);
        }
        this.decodeOverlayOptions(roi, version, options, overlayLabelColor, overlayFontSize);
        return roi;
    }

    void decodeOverlayOptions(Roi roi, int version, int options, int color, int fontSize) {
        boolean scalable;
        Overlay proto = new Overlay();
        proto.drawLabels((options & 8) != 0);
        proto.drawNames((options & 0x10) != 0);
        proto.drawBackgrounds((options & 0x20) != 0);
        if (version >= 220 && color != 0) {
            proto.setLabelColor(new Color(color));
        }
        boolean bold = (options & 0x40) != 0;
        boolean bl = scalable = (options & 0x800) != 0;
        if (fontSize > 0 || bold || scalable) {
            proto.setLabelFont(new Font("SansSerif", bold ? 1 : 0, fontSize), scalable);
        }
        roi.setPrototypeOverlay(proto);
    }

    void getStrokeWidthAndColor(Roi roi, int hdr2Offset, boolean scaleStrokeWidth) {
        int strokeColor;
        int fillColor;
        double strokeWidthD;
        double strokeWidth = this.getShort(34);
        if (hdr2Offset > 0 && (strokeWidthD = (double)this.getFloat(hdr2Offset + 36)) > 0.0) {
            strokeWidth = strokeWidthD;
        }
        if (strokeWidth > 0.0) {
            if (scaleStrokeWidth) {
                roi.setStrokeWidth(strokeWidth);
            } else {
                roi.setUnscalableStrokeWidth(strokeWidth);
            }
        }
        if ((fillColor = this.getInt(44)) != 0) {
            int alpha = fillColor >> 24 & 0xFF;
            roi.setFillColor(new Color(fillColor, alpha != 255));
        }
        if ((strokeColor = this.getInt(40)) != 0) {
            int alpha = strokeColor >> 24 & 0xFF;
            roi.setStrokeColor(new Color(strokeColor, alpha != 255));
        }
    }

    public Roi getShapeRoi() throws IOException {
        int type = this.getByte(6);
        if (type != 1) {
            throw new IllegalArgumentException("Invalid composite ROI type");
        }
        int top = this.getShort(8);
        int left = this.getShort(10);
        int bottom = this.getShort(12);
        int right = this.getShort(14);
        int width = right - left;
        int height = bottom - top;
        int n = this.getInt(36);
        ShapeRoi roi = null;
        float[] shapeArray = new float[n];
        int base = 64;
        for (int i = 0; i < n; ++i) {
            shapeArray[i] = this.getFloat(base);
            base += 4;
        }
        roi = new ShapeRoi(shapeArray);
        roi.setName(this.getRoiName());
        return roi;
    }

    Roi getTextRoi(Roi roi, int version) {
        int i;
        Rectangle r = roi.getBounds();
        int hdrSize = 64;
        int size = this.getInt(hdrSize);
        int styleAndJustification = this.getInt(hdrSize + 4);
        int style = styleAndJustification & 0xFF;
        int justification = styleAndJustification >> 8 & 3;
        boolean drawStringMode = (styleAndJustification & 0x400) != 0;
        int nameLength = this.getInt(hdrSize + 8);
        int textLength = this.getInt(hdrSize + 12);
        char[] name = new char[nameLength];
        char[] text = new char[textLength];
        for (i = 0; i < nameLength; ++i) {
            name[i] = (char)this.getShort(hdrSize + 16 + i * 2);
        }
        for (i = 0; i < textLength; ++i) {
            text[i] = (char)this.getShort(hdrSize + 16 + nameLength * 2 + i * 2);
        }
        double angle = version >= 225 ? (double)this.getFloat(hdrSize + 16 + nameLength * 2 + textLength * 2) : 0.0;
        Font font = new Font(new String(name), style, size);
        TextRoi roi2 = null;
        if (roi.subPixelResolution()) {
            Rectangle2D.Double fb = roi.getFloatBounds();
            roi2 = new TextRoi(((RectangularShape)fb).getX(), ((RectangularShape)fb).getY(), ((RectangularShape)fb).getWidth(), ((RectangularShape)fb).getHeight(), new String(text), font);
        } else {
            roi2 = new TextRoi(r.x, r.y, r.width, r.height, new String(text), font);
        }
        roi2.setStrokeColor(roi.getStrokeColor());
        roi2.setFillColor(roi.getFillColor());
        roi2.setName(this.getRoiName());
        roi2.setJustification(justification);
        roi2.setDrawStringMode(drawStringMode);
        roi2.setAngle(angle);
        return roi2;
    }

    Roi getImageRoi(Roi roi, int opacity, int size, int options) {
        if (size <= 0) {
            return roi;
        }
        Rectangle r = roi.getBounds();
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)this.getByte(64 + i);
        }
        ImagePlus imp = new Opener().deserialize(bytes);
        ImageRoi roi2 = new ImageRoi(r.x, r.y, imp.getProcessor());
        roi2.setOpacity((double)opacity / 255.0);
        if ((options & 0x200) != 0) {
            roi2.setZeroTransparent(true);
        }
        return roi2;
    }

    String getRoiName() {
        String fileName = this.name;
        int hdr2Offset = this.getInt(60);
        if (hdr2Offset == 0) {
            return fileName;
        }
        int offset = this.getInt(hdr2Offset + 16);
        int length = this.getInt(hdr2Offset + 20);
        if (offset == 0 || length == 0) {
            return fileName;
        }
        if (offset + length * 2 > this.size) {
            return fileName;
        }
        char[] name = new char[length];
        for (int i = 0; i < length; ++i) {
            name[i] = (char)this.getShort(offset + i * 2);
        }
        return new String(name);
    }

    String getRoiProps() {
        int hdr2Offset = this.getInt(60);
        if (hdr2Offset == 0) {
            return null;
        }
        int offset = this.getInt(hdr2Offset + 40);
        int length = this.getInt(hdr2Offset + 44);
        if (offset == 0 || length == 0) {
            return null;
        }
        if (offset + length * 2 > this.size) {
            return null;
        }
        char[] props = new char[length];
        for (int i = 0; i < length; ++i) {
            props[i] = (char)this.getShort(offset + i * 2);
        }
        return new String(props);
    }

    int[] getPointCounters(int n) {
        int hdr2Offset = this.getInt(60);
        if (hdr2Offset == 0) {
            return null;
        }
        int offset = this.getInt(hdr2Offset + 48);
        if (offset == 0) {
            return null;
        }
        if (offset + n * 4 > this.data.length) {
            return null;
        }
        int[] counters = new int[n];
        for (int i = 0; i < n; ++i) {
            counters[i] = this.getInt(offset + i * 4);
        }
        return counters;
    }

    int getByte(int base) {
        return this.data[base] & 0xFF;
    }

    int getShort(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        int n = (b0 << 8) + b1;
        if (n < -5000) {
            n = (b0 << 8) + b1;
        }
        return n;
    }

    int getUnsignedShort(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        return (b0 << 8) + b1;
    }

    int getInt(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        int b2 = this.data[base + 2] & 0xFF;
        int b3 = this.data[base + 3] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    float getFloat(int base) {
        return Float.intBitsToFloat(this.getInt(base));
    }

    public static Roi openFromByteArray(byte[] bytes) {
        Roi roi = null;
        if (bytes == null || bytes.length == 0) {
            return roi;
        }
        try {
            RoiDecoder decoder = new RoiDecoder(bytes, null);
            roi = decoder.getRoi();
        }
        catch (IOException e) {
            return null;
        }
        return roi;
    }
}

