/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.InstructionPrinter;
import javassist.bytecode.MethodInfo;
import javassist.expr.Cast;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.Handler;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import net.imagej.patcher.JavaAgent;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Utils;

class CodeHacker {
    private final ClassPool pool;
    protected final ClassLoader classLoader;
    private final Map<String, CtClass> handledClasses = new LinkedHashMap<String, CtClass>();
    private final boolean onlyLogExceptions;
    private static int verboseLevel = 0;

    public CodeHacker(ClassLoader classLoader, ClassPool classPool) {
        this.classLoader = classLoader;
        this.pool = classPool != null ? classPool : ClassPool.getDefault();
        this.pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        this.pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
        this.onlyLogExceptions = !Utils.stackTraceContains("junit.");
    }

    public CodeHacker(ClassLoader classLoader) {
        this(classLoader, null);
    }

    private void maybeThrow(IllegalArgumentException e) {
        if (!this.onlyLogExceptions) {
            throw e;
        }
        e.printStackTrace();
    }

    public void insertAtBottomOfMethod(String fullClass, String methodSig, String newCode) {
        try {
            this.getBehavior(fullClass, methodSig).insertAfter(newCode);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot modify method: " + methodSig, e));
        }
    }

    public void insertAtTopOfMethod(String fullClass, String methodSig, String newCode) {
        try {
            CtBehavior behavior = this.getBehavior(fullClass, methodSig);
            if (behavior instanceof CtConstructor) {
                ((CtConstructor)behavior).insertBeforeBody(newCode);
            } else {
                behavior.insertBefore(newCode);
            }
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot modify method: " + methodSig, e));
        }
    }

    public void insertNewMethod(String fullClass, String methodSig, String newCode) {
        CtClass classRef = this.getClass(fullClass);
        String methodBody = methodSig + " { " + newCode + " } ";
        try {
            CtMethod methodRef = CtNewMethod.make((String)methodBody, (CtClass)classRef);
            classRef.addMethod(methodRef);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot add method: " + methodSig, e));
        }
    }

    public void handleMightyMousePressed(String fullClass) {
        ExprEditor editor = new ExprEditor(){

            public void edit(MethodCall call) throws CannotCompileException {
                if (call.getMethodName().equals("isPopupTrigger")) {
                    call.replace("$_ = $0.isPopupTrigger() && $0.getButton() != 0;");
                }
            }
        };
        CtClass classRef = this.getClass(fullClass);
        for (String methodName : new String[]{"mousePressed", "mouseDragged"}) {
            try {
                CtMethod method = classRef.getMethod(methodName, "(Ljava/awt/event/MouseEvent;)V");
                method.instrument(editor);
            }
            catch (NotFoundException method) {
            }
            catch (Throwable e) {
                this.maybeThrow(new IllegalArgumentException("Cannot instrument method: " + methodName, e));
            }
        }
    }

    public void insertPrivateStaticField(String fullClass, Class<?> clazz, String name) {
        this.insertStaticField(fullClass, 2, clazz, name, null);
    }

    public void insertPublicStaticField(String fullClass, Class<?> clazz, String name, String initializer) {
        this.insertStaticField(fullClass, 1, clazz, name, initializer);
    }

    public void insertStaticField(String fullClass, int modifiers, Class<?> clazz, String name, String initializer) {
        CtClass classRef = this.getClass(fullClass);
        try {
            CtField field = new CtField(this.pool.get(clazz.getName()), name, classRef);
            field.setModifiers(modifiers | 8);
            classRef.addField(field);
            if (initializer != null) {
                this.addToClassInitializer(fullClass, name + " = " + initializer + ";");
            }
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot add field " + name + " to " + fullClass, e));
        }
    }

    public void addToClassInitializer(String fullClass, String code) {
        CtClass classRef = this.getClass(fullClass);
        try {
            CtConstructor method = classRef.getClassInitializer();
            if (method != null) {
                method.insertAfter(code);
            } else {
                method = CtNewConstructor.make((CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)code, (CtClass)classRef);
                method.getMethodInfo().setName("<clinit>");
                method.setModifiers(8);
                classRef.addConstructor(method);
            }
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot add " + code + " to class initializer of " + fullClass, e));
        }
    }

    public void addCatch(String fullClass, String methodSig, String exceptionClassName, String src) {
        try {
            CtBehavior method = this.getBehavior(fullClass, methodSig);
            method.addCatch(src, this.getClass(exceptionClassName), "$e");
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot add catch for exception of type'" + exceptionClassName + " in " + fullClass + "'s " + methodSig, e));
        }
    }

    public void insertAtTopOfExceptionHandlers(String fullClass, String methodSig, final String exceptionClassName, final String src) {
        try {
            CtBehavior method = this.getBehavior(fullClass, methodSig);
            new EagerExprEditor(){

                public void edit(Handler handler) throws CannotCompileException {
                    try {
                        if (handler.getType().getName().equals(exceptionClassName)) {
                            handler.insertBefore(src);
                            this.markEdited();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.instrument(method);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot edit exception handler for type'" + exceptionClassName + " in " + fullClass + "'s " + methodSig, e));
        }
    }

    protected void replaceAppNameInNew(String fullClass, String methodSig, final String newClassName, final int parameterIndex, final String replacement) {
        try {
            CtBehavior method = this.getBehavior(fullClass, methodSig);
            new EagerExprEditor(){

                public void edit(NewExpr expr) throws CannotCompileException {
                    if (expr.getClassName().equals(newClassName)) {
                        try {
                            CtClass[] parameterTypes = expr.getConstructor().getParameterTypes();
                            if (parameterTypes[parameterIndex - 1] != CodeHacker.this.getClass("java.lang.String")) {
                                CodeHacker.this.maybeThrow(new IllegalArgumentException("Parameter " + parameterIndex + " of " + expr.getConstructor() + " is not a String!"));
                                return;
                            }
                            String replace = CodeHacker.this.replaceAppName(parameterIndex, parameterTypes.length, replacement);
                            expr.replace("$_ = new " + newClassName + replace + ";");
                            this.markEdited();
                        }
                        catch (NotFoundException e) {
                            CodeHacker.this.maybeThrow(new IllegalArgumentException("Cannot find the parameters of the constructor of " + newClassName, e));
                        }
                    }
                }
            }.instrument(method);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot handle app name in " + fullClass + "'s " + methodSig, e));
        }
    }

    protected void replaceAppNameInCall(String fullClass, String methodSig, final String calledMethodName, final int parameterIndex, final String replacement) {
        try {
            CtBehavior method = this.getBehavior(fullClass, methodSig);
            new EagerExprEditor(){

                public void edit(MethodCall call) throws CannotCompileException {
                    if (call.getMethodName().equals(calledMethodName)) {
                        try {
                            CtClass[] parameterTypes;
                            boolean isSuper = call.isSuper();
                            CtClass[] ctClassArray = parameterTypes = isSuper ? ((ConstructorCall)call).getConstructor().getParameterTypes() : call.getMethod().getParameterTypes();
                            if (parameterTypes.length < parameterIndex) {
                                CodeHacker.this.maybeThrow(new IllegalArgumentException("Index " + parameterIndex + " is outside of " + call.getMethod() + "'s parameter list!"));
                                return;
                            }
                            if (parameterTypes[parameterIndex - 1] != CodeHacker.this.getClass("java.lang.String")) {
                                CodeHacker.this.maybeThrow(new IllegalArgumentException("Parameter " + parameterIndex + " of " + call.getMethod() + " is not a String!"));
                                return;
                            }
                            String replace = CodeHacker.this.replaceAppName(parameterIndex, parameterTypes.length, replacement);
                            call.replace((isSuper ? "" : "$0.") + calledMethodName + replace + ";");
                            this.markEdited();
                        }
                        catch (NotFoundException e) {
                            CodeHacker.this.maybeThrow(new IllegalArgumentException("Cannot find the parameters of the method " + calledMethodName, e));
                        }
                    }
                }

                public void edit(ConstructorCall call) throws CannotCompileException {
                    this.edit((MethodCall)call);
                }
            }.instrument(method);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot handle app name in " + fullClass + "'s " + methodSig, e));
        }
    }

    private String replaceAppName(int parameterIndex, int parameterCount, String replacement) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 1; i <= parameterCount; ++i) {
            if (i > 1) {
                builder.append(", ");
            }
            builder.append("$").append(i);
            if (i != parameterIndex) continue;
            builder.append(".replace(\"ImageJ\", " + replacement + ")");
        }
        builder.append(")");
        return builder.toString();
    }

    public void dontReturnOnNull(String fullClass, String methodSig) {
        CtBehavior behavior = this.getBehavior(fullClass, methodSig);
        MethodInfo info = behavior.getMethodInfo();
        CodeIterator iterator = info.getCodeAttribute().iterator();
        while (iterator.hasNext()) {
            try {
                int pos = iterator.next();
                int c = iterator.byteAt(pos);
                if (c != 199 || iterator.byteAt(pos + 3) != 177) continue;
                iterator.writeByte(87, pos++);
                iterator.writeByte(0, pos++);
                iterator.writeByte(0, pos++);
                iterator.writeByte(0, pos++);
                return;
            }
            catch (Throwable e) {
                this.maybeThrow(new IllegalArgumentException(e));
                return;
            }
        }
        this.maybeThrow(new IllegalArgumentException("Method " + methodSig + " in " + fullClass + " does not return on null"));
    }

    public void replaceWithStubMethods(String fullClass, String ... methodNames) {
        CtClass clazz = this.getClass(fullClass);
        HashSet<String> override = new HashSet<String>(Arrays.asList(methodNames));
        for (CtMethod method : clazz.getMethods()) {
            if (!override.contains(method.getName())) continue;
            try {
                CtMethod stub = CodeHacker.makeStubMethod(clazz, method);
                method.setBody(stub, null);
            }
            catch (Throwable e) {
                this.maybeThrow(new IllegalArgumentException("Cannot instrument method: " + method.getName(), e));
            }
        }
    }

    public void replaceSuperclassAndStubifyAWTMethods(String fullClass, String fullNewSuperclass) {
        CtClass clazz = this.getClass(fullClass);
        try {
            CtClass originalSuperclass = clazz.getSuperclass();
            clazz.setSuperclass(this.getClass(fullNewSuperclass));
            for (CtConstructor ctConstructor : clazz.getConstructors()) {
                ctConstructor.instrument(new ExprEditor(){

                    public void edit(ConstructorCall call) throws CannotCompileException {
                        if (call.getMethodName().equals("super")) {
                            call.replace("super();");
                        }
                    }
                });
            }
            this.letSuperclassMethodsOverride(clazz);
            for (CtConstructor ctConstructor : clazz.getMethods()) {
                if (ctConstructor.getDeclaringClass() != clazz || ctConstructor.getName().startsWith("narf") || !this.isAWTMethod((CtMethod)ctConstructor)) continue;
                CtMethod stub = CodeHacker.makeStubMethod(clazz, (CtMethod)ctConstructor);
                ctConstructor.setBody(stub, null);
            }
            this.addMissingMethods(clazz, originalSuperclass);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Could not replace superclass of " + fullClass + " with " + fullNewSuperclass, e));
        }
    }

    private boolean isAWTMethod(CtMethod method) throws NotFoundException {
        if (this.isAWTClass(method.getReturnType())) {
            return true;
        }
        for (CtClass type : method.getParameterTypes()) {
            if (!this.isAWTClass(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isAWTClass(CtClass clazz) {
        if (clazz == null) {
            return false;
        }
        String name = clazz.getName();
        return name != null && name.startsWith("java.awt.");
    }

    public void skipAWTInstantiations(String fullClass) {
        try {
            this.skipAWTInstantiations(this.getClass(fullClass));
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Could not skip AWT class instantiations in " + fullClass, e));
        }
    }

    public void overrideFieldWrite(String fullClass, String methodSig, final String fieldName, final String newCode) {
        try {
            CtBehavior method = this.getBehavior(fullClass, methodSig);
            new EagerExprEditor(){

                public void edit(FieldAccess access) throws CannotCompileException {
                    if (access.isWriter() && access.getFieldName().equals(fieldName)) {
                        access.replace(newCode);
                        this.markEdited();
                    }
                }
            }.instrument(method);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot override field access to " + fieldName + " in " + fullClass + "'s " + methodSig, e));
        }
    }

    public void replaceCallInMethod(String fullClass, String methodSig, String calledClass, String calledMethodName, String newCode) {
        this.replaceCallInMethod(fullClass, methodSig, calledClass, calledMethodName, newCode, -1);
    }

    public void replaceCallInMethod(String fullClass, String methodSig, final String calledClass, final String calledMethodName, final String newCode, final int onlyNth) {
        try {
            CtBehavior method = this.getBehavior(fullClass, methodSig);
            new EagerExprEditor(){
                private int counter = 0;
                private final boolean debug = false;

                public void edit(MethodCall call) throws CannotCompileException {
                    if (call.getMethodName().equals(calledMethodName) && call.getClassName().equals(calledClass)) {
                        if (onlyNth > 0 && ++this.counter != onlyNth) {
                            return;
                        }
                        call.replace(newCode);
                        this.markEdited();
                    }
                }

                public void edit(ConstructorCall call) throws CannotCompileException {
                    if (call.getMethodName().equals(calledMethodName) && call.getClassName().equals(calledClass)) {
                        if (onlyNth > 0 && ++this.counter != onlyNth) {
                            return;
                        }
                        call.replace(newCode);
                        this.markEdited();
                    }
                }

                public void edit(NewExpr expr) throws CannotCompileException {
                    if ("<init>".equals(calledMethodName) && expr.getClassName().equals(calledClass)) {
                        if (onlyNth > 0 && ++this.counter != onlyNth) {
                            return;
                        }
                        expr.replace(newCode);
                        this.markEdited();
                    }
                }
            }.instrument(method);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot handle replace call to " + calledMethodName + " in " + fullClass + "'s " + methodSig, e));
        }
    }

    public void guardCast(String fullClass, String methodSig, final String targetClass) {
        CtBehavior method = this.getBehavior(fullClass, methodSig);
        try {
            method.instrument(new ExprEditor(){

                public void edit(Cast cast) {
                    try {
                        if (cast.getType().getName().equals(targetClass)) {
                            cast.replace("if ($1 != null && $1 instanceof " + targetClass + ") {  $_ = (" + targetClass + ") $1;} else {  $_ = null;}");
                        }
                    }
                    catch (Exception e) {
                        CodeHacker.this.maybeThrow(new IllegalArgumentException("Cannot handle cast to " + targetClass, e));
                    }
                }
            });
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Cannot handle cast to " + targetClass + " in " + fullClass + "'s " + methodSig, e));
        }
    }

    public Class<?> loadClass(String fullClass) {
        CtClass classRef = this.getClass(fullClass);
        return this.loadClass(classRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(CtClass classRef) {
        try {
            Class clazz = classRef.toClass(this.classLoader, null);
            return clazz;
        }
        catch (CannotCompileException e) {
            if (e.getCause() != null && e.getCause() instanceof LinkageError) {
                throw CodeHacker.javaAgentHint("Cannot load class: " + classRef.getName() + " (loader: " + this.classLoader + ")", e.getCause());
            }
            System.err.println("Warning: Cannot load class: " + classRef.getName() + " into " + this.classLoader);
            e.printStackTrace();
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            classRef.freeze();
        }
    }

    static RuntimeException javaAgentHint(String message, Throwable cause) {
        URL url = Utils.getLocation(JavaAgent.class);
        String path = url != null && "file".equals(url.getProtocol()) && url.getPath().endsWith(".jar") ? url.getPath() : "/path/to/ij1-patcher.jar";
        return new RuntimeException(message + "\nIt appears that this class was already defined in the class loader!\nPlease make sure that you initialize the LegacyService before using\nany ImageJ 1.x class. You can do that by adding this static initializer:\n\n\tstatic {\n\t\tLegacyInjector.preinit();\n\t}\n\nTo debug this issue, start the JVM with the option:\n\n\t-javaagent:" + path + "\n\nTo enforce pre-initialization, start the JVM with the option:\n\n\t-javaagent:" + path + "=init\n", cause);
    }

    public void loadClasses() {
        try {
            JavaAgent.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Iterator<CtClass> iter = this.handledClasses.values().iterator();
        while (iter.hasNext()) {
            CtClass classRef = iter.next();
            if (!classRef.isFrozen() && classRef.isModified()) {
                this.loadClass(classRef);
            }
            iter.remove();
        }
    }

    Collection<CtClass> getPatchedClasses() {
        HashSet<CtClass> result = new HashSet<CtClass>();
        for (CtClass clazz : this.handledClasses.values()) {
            if (clazz.isFrozen() || !clazz.isModified()) continue;
            result.add(clazz);
        }
        return result;
    }

    CtClass getClass(String fullClass) {
        try {
            CtClass classRef = this.pool.get(fullClass);
            if (classRef.getClassPool() == this.pool) {
                this.handledClasses.put(classRef.getName(), classRef);
            }
            return classRef;
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such class: " + fullClass, e);
        }
    }

    private CtBehavior getBehavior(String fullClass, String methodSig) {
        if (methodSig.indexOf("<init>") < 0) {
            return this.getMethod(fullClass, methodSig);
        }
        return this.getConstructor(fullClass, methodSig);
    }

    private CtMethod getMethod(String fullClass, String methodSig) {
        CtClass cc = this.getClass(fullClass);
        String name = this.getMethodName(methodSig);
        String[] argTypes = this.getMethodArgTypes(methodSig);
        CtClass[] params = new CtClass[argTypes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getClass(argTypes[i]);
        }
        try {
            return cc.getDeclaredMethod(name, params);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such method: " + methodSig, e);
        }
    }

    private CtConstructor getConstructor(String fullClass, String constructorSig) {
        CtClass cc = this.getClass(fullClass);
        String[] argTypes = this.getMethodArgTypes(constructorSig);
        CtClass[] params = new CtClass[argTypes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getClass(argTypes[i]);
        }
        try {
            return cc.getDeclaredConstructor(params);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such method: " + constructorSig, e);
        }
    }

    private String getMethodName(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        int spaceIndex = methodSig.lastIndexOf(" ", parenIndex);
        return methodSig.substring(spaceIndex + 1, parenIndex);
    }

    private String[] getMethodArgTypes(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        String methodArgs = methodSig.substring(parenIndex + 1, methodSig.length() - 1);
        String[] args = methodArgs.equals("") ? new String[]{} : methodArgs.split(",");
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].trim().split(" ")[0];
        }
        return args;
    }

    public boolean hasField(String fullName, String fieldName) {
        CtClass clazz = this.getClass(fullName);
        try {
            return clazz.getField(fieldName) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean hasMethod(String fullClass, String methodSig) {
        try {
            return this.getBehavior(fullClass, methodSig) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean existsClass(String fullClass) {
        try {
            return this.pool.get(fullClass) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean hasSuperclass(String fullClass, String fullSuperclass) {
        try {
            CtClass clazz = this.getClass(fullClass);
            return fullSuperclass.equals(clazz.getSuperclass().getName());
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static CtMethod makeStubMethod(CtClass clazz, CtMethod original) throws CannotCompileException, NotFoundException {
        String prefix = "";
        if (verboseLevel > 0) {
            prefix = "System.err.println(\"Called " + original.getLongName() + "\\n\"";
            if (verboseLevel > 1) {
                prefix = prefix + "+ \"\\t(\" + fiji.Headless.toString($args) + \")\\n\"";
            }
            prefix = prefix + ");";
        }
        CtClass type = original.getReturnType();
        String body = "{" + prefix + (type == CtClass.voidType ? "" : "return " + CodeHacker.defaultReturnValue(type) + ";") + "}";
        CtClass[] types = original.getParameterTypes();
        return CtNewMethod.make((CtClass)type, (String)original.getName(), (CtClass[])types, (CtClass[])new CtClass[0], (String)body, (CtClass)clazz);
    }

    private static String defaultReturnValue(CtClass type) {
        if (type == CtClass.booleanType) {
            return "false";
        }
        if (type == CtClass.byteType) {
            return "(byte)0";
        }
        if (type == CtClass.charType) {
            return "'\u0000'";
        }
        if (type == CtClass.doubleType) {
            return "0.0";
        }
        if (type == CtClass.floatType) {
            return "0.0f";
        }
        if (type == CtClass.intType) {
            return "0";
        }
        if (type == CtClass.longType) {
            return "0l";
        }
        if (type == CtClass.shortType) {
            return "(short)0";
        }
        return "null";
    }

    private void addMissingMethods(CtClass fakeClass, CtClass originalClass) throws CannotCompileException, NotFoundException {
        if (verboseLevel > 0) {
            System.err.println("adding missing methods from " + originalClass.getName() + " to " + fakeClass.getName());
        }
        HashSet<String> available = new HashSet<String>();
        for (CtMethod method : fakeClass.getMethods()) {
            available.add(CodeHacker.stripPackage(method.getLongName()));
        }
        for (CtMethod original : originalClass.getDeclaredMethods()) {
            if (available.contains(CodeHacker.stripPackage(original.getLongName()))) {
                if (verboseLevel <= 1) continue;
                System.err.println("Skipping available method " + original);
                continue;
            }
            CtMethod method = CodeHacker.makeStubMethod(fakeClass, original);
            fakeClass.addMethod(method);
            if (verboseLevel <= 1) continue;
            System.err.println("adding missing method " + method);
        }
        HashSet<CtClass> availableInterfaces = new HashSet<CtClass>();
        for (CtClass iface : fakeClass.getInterfaces()) {
            availableInterfaces.add(iface);
        }
        for (CtClass iface : originalClass.getInterfaces()) {
            if (availableInterfaces.contains(iface)) continue;
            fakeClass.addInterface(iface);
        }
        CtClass superClass = originalClass.getSuperclass();
        if (superClass != null && !superClass.getName().equals("java.lang.Object")) {
            this.addMissingMethods(fakeClass, superClass);
        }
    }

    private void letSuperclassMethodsOverride(CtClass clazz) throws CannotCompileException, NotFoundException {
        for (CtMethod method : clazz.getSuperclass().getDeclaredMethods()) {
            CtMethod method2 = clazz.getMethod(method.getName(), method.getSignature());
            if (!method2.getDeclaringClass().equals(clazz)) continue;
            method2.setBody(method, null);
            method2.setName("narf" + method.getName());
        }
    }

    private static String stripPackage(String className) {
        int lastDot = -1;
        for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            if (c == '.' || c == '$') {
                lastDot = i;
                continue;
            }
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || i > lastDot + 1 && c >= '0' && c <= '9') continue;
            return className.substring(lastDot + 1);
        }
        return className.substring(lastDot + 1);
    }

    private void skipAWTInstantiations(CtClass clazz) throws CannotCompileException {
        clazz.instrument(new ExprEditor(){

            public void edit(ConstructorCall call) throws CannotCompileException {
                try {
                    if (call.getConstructor().getLongName().equals("ij.gui.GenericDialog(java.lang.String,java.awt.Frame)")) {
                        call.replace("super();");
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
            }

            public void edit(NewExpr expr) throws CannotCompileException {
                String name = expr.getClassName();
                if (name.startsWith("java.awt.Menu") || name.equals("java.awt.PopupMenu") || name.startsWith("java.awt.Checkbox") || name.equals("java.awt.Frame")) {
                    expr.replace("$_ = null;");
                } else if (expr.getClassName().equals("ij.gui.StackWindow")) {
                    expr.replace("$1.show(); $_ = null;");
                }
            }

            public void edit(MethodCall call) throws CannotCompileException {
                block14: {
                    String className = call.getClassName();
                    String methodName = call.getMethodName();
                    if (className.startsWith("java.awt.Menu") || className.equals("java.awt.PopupMenu") || className.startsWith("java.awt.Checkbox")) {
                        try {
                            CtClass type = call.getMethod().getReturnType();
                            if (type == CtClass.voidType) {
                                call.replace("");
                                break block14;
                            }
                            call.replace("$_ = " + CodeHacker.defaultReturnValue(type) + ";");
                        }
                        catch (NotFoundException e) {
                            e.printStackTrace();
                        }
                    } else if (methodName.equals("put") && className.equals("java.util.Properties")) {
                        call.replace("if ($1 != null && $2 != null) $_ = $0.put($1, $2);else $_ = null;");
                    } else if (methodName.equals("get") && className.equals("java.util.Properties")) {
                        call.replace("$_ = $1 != null ? $0.get($1) : null;");
                    } else if (className.equals("java.lang.Integer") && methodName.equals("intValue")) {
                        call.replace("$_ = $0 == null ? 0 : $0.intValue();");
                    } else if (methodName.equals("addTextListener")) {
                        call.replace("");
                    } else if (methodName.equals("elementAt")) {
                        call.replace("$_ = $0 == null ? null : $0.elementAt($$);");
                    }
                }
            }
        });
    }

    public void handleHTTPS(String fullClass, String methodSig) {
        try {
            CtBehavior method = this.getBehavior(fullClass, methodSig);
            new EagerExprEditor(){

                public void edit(MethodCall call) throws CannotCompileException {
                    try {
                        if (call.getMethodName().equals("startsWith") && "http://".equals(CodeHacker.this.getLastConstantArgument(call, 0))) {
                            call.replace("$_ = $0.startsWith($1) || $0.startsWith(\"https://\");");
                            this.markEdited();
                        }
                    }
                    catch (BadBytecode e) {
                        e.printStackTrace();
                    }
                }
            }.instrument(method);
        }
        catch (Throwable e) {
            this.maybeThrow(new IllegalArgumentException("Could not handle HTTPS in " + methodSig + " in " + fullClass));
        }
    }

    private String getLastConstantArgument(MethodCall call, int skip) throws BadBytecode {
        int pos;
        int[] indices = new int[skip + 1];
        int counter = 0;
        MethodInfo info = ((CtMethod)call.where()).getMethodInfo();
        CodeIterator iterator = info.getCodeAttribute().iterator();
        int currentPos = call.indexOfBytecode();
        while (iterator.hasNext() && (pos = iterator.next()) < currentPos) {
            switch (iterator.byteAt(pos)) {
                case 18: {
                    indices[counter++ % indices.length] = iterator.byteAt(pos + 1);
                    break;
                }
                case 19: {
                    indices[counter++ % indices.length] = iterator.u16bitAt(pos + 1);
                }
            }
        }
        if (counter < skip) {
            return null;
        }
        counter %= indices.length;
        if (skip > 0 && (counter -= skip) < 0) {
            counter += indices.length;
        }
        return info.getConstPool().getStringInfo(indices[counter]);
    }

    public void disassemble(String fullName, PrintStream out) {
        this.disassemble(fullName, out, false);
    }

    public void disassemble(String fullName, PrintStream out, boolean evenSuperclassMethods) {
        CtClass clazz = this.getClass(fullName);
        out.println("Class " + clazz.getName());
        for (CtConstructor ctConstructor : clazz.getConstructors()) {
            this.disassemble((CtBehavior)ctConstructor, out);
        }
        for (CtConstructor ctConstructor : clazz.getDeclaredMethods()) {
            if (!evenSuperclassMethods && !ctConstructor.getDeclaringClass().equals(clazz)) continue;
            this.disassemble((CtBehavior)ctConstructor, out);
        }
    }

    private void disassemble(CtBehavior method, PrintStream out) {
        out.println(method.getLongName());
        MethodInfo info = method.getMethodInfo2();
        ConstPool constPool = info.getConstPool();
        CodeAttribute code = info.getCodeAttribute();
        if (code == null) {
            return;
        }
        CodeIterator iterator = code.iterator();
        while (iterator.hasNext()) {
            int pos;
            try {
                pos = iterator.next();
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
            out.println(pos + ": " + InstructionPrinter.instructionString((CodeIterator)iterator, (int)pos, (ConstPool)constPool));
        }
        out.println("");
    }

    public void writeJar(File path) throws IOException {
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(path));
        DataOutputStream dataOut = new DataOutputStream(jar);
        for (CtClass clazz : this.handledClasses.values()) {
            if (!clazz.isModified() && !clazz.getName().startsWith("net.imagej.patcher.")) continue;
            ZipEntry entry = new ZipEntry(clazz.getName().replace('.', '/') + ".class");
            jar.putNextEntry(entry);
            clazz.getClassFile().write(dataOut);
            dataOut.flush();
        }
        jar.close();
    }

    public void writeJar(URL directory, File jarFile) throws IOException, NotFoundException {
        int prefixLength = directory.getPath().length();
        Collection<URL> urls = Utils.listContents(directory);
        byte[] buffer = new byte[16384];
        ZipOutputStream jar = new ZipOutputStream(new FileOutputStream(jarFile));
        DataOutputStream dataOut = new DataOutputStream(jar);
        for (URL url : urls) {
            String path = url.getPath().substring(prefixLength);
            ZipEntry entry = new ZipEntry(path);
            jar.putNextEntry(entry);
            if (path.endsWith(".class")) {
                String classname = path.substring(0, path.length() - 6).replace('/', '.');
                CtClass clazz = this.pool.get(classname);
                clazz.getClassFile().write(dataOut);
                this.handledClasses.remove(clazz);
            } else {
                int count;
                InputStream in = url.openStream();
                while ((count = in.read(buffer)) >= 0) {
                    dataOut.write(buffer, 0, count);
                }
                in.close();
            }
            dataOut.flush();
        }
        for (CtClass clazz : this.handledClasses.values()) {
            if (!clazz.isModified() && !clazz.getName().startsWith("net.imagej.patcher.")) continue;
            ZipEntry entry = new ZipEntry(clazz.getName().replace('.', '/') + ".class");
            jar.putNextEntry(entry);
            clazz.getClassFile().write(dataOut);
            dataOut.flush();
        }
        jar.close();
    }

    private void verify(CtClass clazz, PrintWriter output) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(stream);
            clazz.getClassFile().write(out);
            out.flush();
            out.close();
            this.verify(stream.toByteArray(), output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void verify(byte[] bytecode, PrintWriter out) {
        try {
            Collection<URL> urls = Utils.listContents(new File(System.getProperty("user.home"), "fiji/jars/").toURI().toURL());
            if (urls.size() == 0 && (urls = Utils.listContents(new File(System.getProperty("user.home"), "Fiji.app/jars/").toURI().toURL())).size() == 0) {
                urls = Utils.listContents(new File("/Applications/Fiji.app/jars/").toURI().toURL());
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
            Class<?> readerClass = null;
            Class<?> checkerClass = null;
            for (String prefix : new String[]{"org.", "jruby.", "org.jruby.org."}) {
                try {
                    readerClass = loader.loadClass(prefix + "objectweb.asm.ClassReader");
                    checkerClass = loader.loadClass(prefix + "objectweb.asm.util.CheckClassAdapter");
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            Constructor ctor = readerClass.getConstructor(bytecode.getClass());
            Object reader = ctor.newInstance(new Object[]{bytecode});
            Method verify = checkerClass.getMethod("verify", readerClass, Boolean.TYPE, PrintWriter.class);
            verify.invoke(null, reader, false, out);
        }
        catch (Throwable e) {
            Pattern pattern;
            Matcher matcher;
            if (e.getClass().getName().endsWith(".AnalyzerException") && (matcher = (pattern = Pattern.compile("Error at instruction (\\d+): Argument (\\d+): expected L([^ ,;]+);, but found L(.*);")).matcher(e.getMessage())).matches()) {
                CtClass clazz1 = this.getClass(matcher.group(3));
                CtClass clazz2 = this.getClass(matcher.group(4));
                try {
                    if (clazz2.subtypeOf(clazz1)) {
                        return;
                    }
                }
                catch (NotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
        }
    }

    protected void verify(PrintWriter out) {
        out.println("Verifying " + this.handledClasses.size() + " classes");
        for (CtClass clazz : this.handledClasses.values()) {
            out.println("Verifying class " + clazz.getName());
            out.flush();
            this.verify(clazz, out);
        }
    }

    private static void patch(boolean forceHeadless) {
        ClassLoader loader = CodeHacker.class.getClassLoader();
        new LegacyInjector().injectHooks(loader, forceHeadless);
    }

    public void commitClass(Class<?> clazz) {
        this.commitClass(clazz.getName());
    }

    public void commitClass(String clazz) {
        this.getClass(clazz);
    }

    public String getConstant(String clazz, String fieldName) throws NotFoundException {
        CtClass c = this.getClass(clazz);
        return (String)c.getField(fieldName).getConstantValue();
    }

    private static abstract class EagerExprEditor
    extends ExprEditor {
        private int count = 0;

        private EagerExprEditor() {
        }

        protected void markEdited() {
            ++this.count;
        }

        protected boolean wasSuccessful() {
            return this.count > 0;
        }

        public void instrument(CtBehavior behavior) throws CannotCompileException {
            this.count = 0;
            behavior.instrument((ExprEditor)this);
            if (!this.wasSuccessful()) {
                throw new CannotCompileException("No code replaced!");
            }
        }
    }
}

