/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.watchservice;

import com.barbarysoftware.watchservice.AbstractWatchService;
import com.barbarysoftware.watchservice.StandardWatchEventKind;
import com.barbarysoftware.watchservice.WatchEvent;
import com.barbarysoftware.watchservice.WatchKey;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractWatchKey
extends WatchKey {
    static final int MAX_EVENT_LIST_SIZE = 512;
    static final Event<Void> OVERFLOW_EVENT = new Event<Object>(StandardWatchEventKind.OVERFLOW, null);
    private final AbstractWatchService watcher;
    private State state;
    private List<WatchEvent<?>> events;

    protected AbstractWatchKey(AbstractWatchService watcher) {
        this.watcher = watcher;
        this.state = State.READY;
        this.events = new ArrayList();
    }

    final AbstractWatchService watcher() {
        return this.watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signal() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.READY) {
                this.state = State.SIGNALLED;
                this.watcher.enqueueKey(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void signalEvent(WatchEvent.Kind<?> kind, Object context) {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            int size = this.events.size();
            if (size > 1) {
                boolean isRepeat;
                WatchEvent<?> prev;
                if (size >= 512) {
                    kind = StandardWatchEventKind.OVERFLOW;
                    context = null;
                }
                if (kind == (prev = this.events.get(size - 1)).kind() && (isRepeat = context == null ? prev.context() == null : context.equals(prev.context()))) {
                    ((Event)prev).increment();
                    return;
                }
            }
            this.events.add(new Event<Object>(kind, context));
            this.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<WatchEvent<?>> pollEvents() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            List<WatchEvent<?>> result = this.events;
            this.events = new ArrayList();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean reset() {
        AbstractWatchKey abstractWatchKey = this;
        synchronized (abstractWatchKey) {
            if (this.state == State.SIGNALLED && this.isValid()) {
                if (this.events.isEmpty()) {
                    this.state = State.READY;
                } else {
                    this.watcher.enqueueKey(this);
                }
            }
            return this.isValid();
        }
    }

    private static class Event<T>
    extends WatchEvent<T> {
        private final WatchEvent.Kind<T> kind;
        private final T context;
        private int count;

        Event(WatchEvent.Kind<T> type, T context) {
            this.kind = type;
            this.context = context;
            this.count = 1;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this.kind;
        }

        @Override
        public T context() {
            return this.context;
        }

        @Override
        public int count() {
            return this.count;
        }

        void increment() {
            ++this.count;
        }
    }

    private static enum State {
        READY,
        SIGNALLED;

    }
}

