/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.watchservice;

import com.barbarysoftware.watchservice.AbstractWatchKey;
import com.barbarysoftware.watchservice.ClosedWatchServiceException;
import com.barbarysoftware.watchservice.WatchEvent;
import com.barbarysoftware.watchservice.WatchKey;
import com.barbarysoftware.watchservice.WatchService;
import com.barbarysoftware.watchservice.WatchableFile;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

abstract class AbstractWatchService
extends WatchService {
    private final LinkedBlockingDeque<WatchKey> pendingKeys = new LinkedBlockingDeque();
    private final WatchKey CLOSE_KEY = new AbstractWatchKey(null){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void cancel() {
        }
    };
    private volatile boolean closed;
    private final Object closeLock = new Object();

    protected AbstractWatchService() {
    }

    abstract WatchKey register(WatchableFile var1, WatchEvent.Kind<?>[] var2, WatchEvent.Modifier ... var3) throws IOException;

    final void enqueueKey(WatchKey key) {
        this.pendingKeys.offer(key);
    }

    private void checkOpen() {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
    }

    private void checkKey(WatchKey key) {
        if (key == this.CLOSE_KEY) {
            this.enqueueKey(key);
        }
        this.checkOpen();
    }

    @Override
    public final WatchKey poll() {
        this.checkOpen();
        WatchKey key = this.pendingKeys.poll();
        this.checkKey(key);
        return key;
    }

    @Override
    public final WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkOpen();
        WatchKey key = this.pendingKeys.poll(timeout, unit);
        this.checkKey(key);
        return key;
    }

    @Override
    public final WatchKey take() throws InterruptedException {
        this.checkOpen();
        WatchKey key = this.pendingKeys.take();
        this.checkKey(key);
        return key;
    }

    final boolean isOpen() {
        return !this.closed;
    }

    final Object closeLock() {
        return this.closeLock;
    }

    abstract void implClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.implClose();
            this.pendingKeys.clear();
            this.pendingKeys.offer(this.CLOSE_KEY);
        }
    }
}

