/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.watchservice;

import com.barbarysoftware.watchservice.StandardWatchEventKind;
import com.barbarysoftware.watchservice.WatchEvent;
import com.barbarysoftware.watchservice.WatchKey;
import com.barbarysoftware.watchservice.WatchService;
import com.barbarysoftware.watchservice.WatchableFile;
import java.io.File;
import java.io.IOException;

public class Demo {
    public static void main(String[] args) throws IOException, InterruptedException {
        WatchService watcher = WatchService.newWatchService();
        String home = System.getProperty("user.home");
        WatchableFile file1 = new WatchableFile(new File(home + "/Downloads"));
        WatchableFile file2 = new WatchableFile(new File(home + "/Documents"));
        file1.register(watcher, StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY);
        file2.register(watcher, StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY);
        Thread consumer = new Thread(Demo.createRunnable(watcher));
        consumer.start();
        System.out.printf("Watching for changes in %s and %s for 1 minute ...%n", file1.getFile(), file2.getFile());
        Thread.sleep(60000L);
        consumer.interrupt();
        watcher.close();
    }

    private static Runnable createRunnable(final WatchService watcher) {
        return new Runnable(){

            @Override
            public void run() {
                WatchKey key;
                boolean valid;
                do {
                    try {
                        key = watcher.take();
                    }
                    catch (InterruptedException x) {
                        return;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKind.OVERFLOW) continue;
                        WatchEvent<?> ev = event;
                        System.out.printf("Detected file system event: %s at %s%n", kind, ev.context());
                    }
                } while (valid = key.reset());
            }
        };
    }
}

