/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.watchservice;

import com.barbarysoftware.watchservice.AbstractWatchKey;
import com.barbarysoftware.watchservice.AbstractWatchService;
import com.barbarysoftware.watchservice.StandardWatchEventKind;
import com.barbarysoftware.watchservice.WatchEvent;
import java.util.concurrent.atomic.AtomicBoolean;

class MacOSXWatchKey
extends AbstractWatchKey {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final boolean reportCreateEvents;
    private final boolean reportModifyEvents;
    private final boolean reportDeleteEvents;

    public MacOSXWatchKey(AbstractWatchService macOSXWatchService, WatchEvent.Kind<?>[] events) {
        super(macOSXWatchService);
        boolean reportCreateEvents = false;
        boolean reportModifyEvents = false;
        boolean reportDeleteEvents = false;
        for (WatchEvent.Kind<?> event : events) {
            if (event == StandardWatchEventKind.ENTRY_CREATE) {
                reportCreateEvents = true;
                continue;
            }
            if (event == StandardWatchEventKind.ENTRY_MODIFY) {
                reportModifyEvents = true;
                continue;
            }
            if (event != StandardWatchEventKind.ENTRY_DELETE) continue;
            reportDeleteEvents = true;
        }
        this.reportCreateEvents = reportCreateEvents;
        this.reportDeleteEvents = reportDeleteEvents;
        this.reportModifyEvents = reportModifyEvents;
    }

    @Override
    public boolean isValid() {
        return !this.cancelled.get() && this.watcher().isOpen();
    }

    @Override
    public void cancel() {
        this.cancelled.set(true);
    }

    public boolean isReportCreateEvents() {
        return this.reportCreateEvents;
    }

    public boolean isReportModifyEvents() {
        return this.reportModifyEvents;
    }

    public boolean isReportDeleteEvents() {
        return this.reportDeleteEvents;
    }
}

