/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.wiseio;

import java.io.Closeable;
import java.io.IOException;
import net.incongru.wiseio.IO;
import net.incongru.wiseio.IONestedException;
import net.incongru.wiseio.IOOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosingIO<T extends Closeable>
implements IO<T> {
    private final T flow;
    private final IOOperation op;
    private boolean shouldClose = true;

    public ClosingIO(T flow, IOOperation op) {
        if (flow == null) {
            throw new IllegalArgumentException("Can't process a null flow.");
        }
        if (op == null) {
            throw new IllegalArgumentException("IOOperation can't process be null.");
        }
        this.flow = flow;
        this.op = op;
    }

    public IO<T> withoutClose() {
        this.shouldClose = false;
        return this;
    }

    @Override
    public void exec() throws IOException {
        this.exec(this.flow, this.op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec(T flow, IOOperation op) throws IOException {
        block5: {
            IOException processEx = null;
            try {
                op.op();
            }
            catch (IOException e) {
                processEx = e;
            }
            finally {
                e = this.cleanupAndProcessException(processEx, flow);
                if (e == null) break block5;
                throw e;
            }
        }
    }

    protected IOException cleanupAndProcessException(IOException e, T flow) {
        if (this.shouldClose) {
            try {
                flow.close();
            }
            catch (IOException closingEx) {
                e = e != null ? new IONestedException(e.getMessage() + "; an IOException was also thrown when closing: " + closingEx.getMessage(), e) : new IONestedException("Could not close: " + closingEx.getMessage(), closingEx);
            }
        }
        return e;
    }
}

