/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.wiseio;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import net.incongru.wiseio.ClosingIO;
import net.incongru.wiseio.IONestedException;
import net.incongru.wiseio.IOOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output<T extends Closeable & Flushable>
extends ClosingIO<T> {
    private boolean shouldFlushWhenSuccessful;
    private boolean shouldFlushInFinallyBlock;

    public Output(T flow, IOOperation op) {
        super(flow, op);
    }

    public Output<T> withFlush() {
        this.shouldFlushInFinallyBlock = true;
        return this;
    }

    public Output<T> withFlushWhenSuccessful() {
        this.shouldFlushWhenSuccessful = true;
        return this;
    }

    @Override
    protected void exec(T flow, IOOperation op) throws IOException {
        super.exec(flow, this.shouldFlushWhenSuccessful ? new Flusher(this, (Flushable)flow, op) : op);
    }

    @Override
    protected IOException cleanupAndProcessException(IOException e, T flow) {
        if (this.shouldFlushInFinallyBlock) {
            try {
                ((Flushable)flow).flush();
            }
            catch (IOException flushingEx) {
                e = e != null ? new IONestedException(e.getMessage() + "; an IOException was also thrown when flushing: " + flushingEx.getMessage(), e) : new IONestedException("Could not flush: " + flushingEx.getMessage(), flushingEx);
            }
        }
        return super.cleanupAndProcessException(e, flow);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Flusher<T extends Flushable>
    implements IOOperation {
        private final T flow;
        private final IOOperation op;
        final /* synthetic */ Output this$0;

        public Flusher(T flow, IOOperation op) {
            this.this$0 = var1_1;
            this.flow = flow;
            this.op = op;
        }

        @Override
        public void op() throws IOException {
            this.op.op();
            this.flow.flush();
        }
    }
}

