/*
 * Decompiled with CFR 0.152.
 */
package net.interfax.rest.client.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.interfax.rest.client.config.EnvironmentVariableLookup;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);
    private final Class<T> configClass;
    private final String configFileName;
    private final ObjectReader reader;
    private final StrSubstitutor substitutor;

    public ConfigLoader(Class<T> configClass, String configFileName) {
        this.configClass = configClass;
        this.configFileName = configFileName;
        this.reader = new ObjectMapper((JsonFactory)new YAMLFactory()).reader(configClass);
        this.substitutor = new StrSubstitutor((StrLookup)new EnvironmentVariableLookup());
    }

    public ConfigLoader(Class<T> configClass, String configFileName, StrLookup<Object> stringLookup) {
        this.configClass = configClass;
        this.configFileName = configFileName;
        this.reader = new ObjectMapper((JsonFactory)new YAMLFactory()).reader(configClass);
        this.substitutor = new StrSubstitutor(stringLookup);
    }

    public T getTestConfig() {
        try {
            LOGGER.info(String.format("Loading config from: %s", this.configFileName));
            String substitutedString = this.substitutor.replace(new String(ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(this.configFileName)), StandardCharsets.UTF_8));
            return (T)this.reader.readValue(substitutedString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }
}

