/*
 * Decompiled with CFR 0.152.
 */
package net.interfax.rest.client.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import net.interfax.rest.client.config.ClientConfig;
import net.interfax.rest.client.config.ClientCredentials;
import net.interfax.rest.client.config.ConfigLoader;
import net.interfax.rest.client.domain.DocumentUploadSessionOptions;
import net.interfax.rest.client.domain.GetUploadedDocumentsListOptions;
import net.interfax.rest.client.domain.SendFaxOptions;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public abstract class AbstractInterFAXClient {
    protected String username;
    protected String password;
    protected String scheme;
    protected String hostname;
    protected int port;
    protected String outboundFaxesEndpoint;
    protected String outboundFaxesCompletedEndpoint;
    protected String outboundFaxesRecordEndpoint;
    protected String outboundFaxImageEndpoint;
    protected String outboundFaxesCancelEndpoint;
    protected String outboundFaxesResendEndpoint;
    protected String outboundFaxesHideEndpoint;
    protected String outboundSearchEndpoint;
    protected String outboundDocumentsEndpoint;
    protected String accountsBalanceEndpoint;
    protected String inboundFaxesEndpoint;
    protected String inboundFaxesImageEndpoint;
    protected String inboundFaxesEmailsEndpoint;
    protected String inboundFaxesMarkEndpoint;
    protected String inboundFaxesResendEndpoint;

    protected URI getSendFaxUri(String faxNumber, Optional<SendFaxOptions> options) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setHost(this.hostname).setScheme(this.scheme).setPort(this.port).setPath(this.outboundFaxesEndpoint);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("faxNumber", faxNumber));
        if (options.isPresent()) {
            SendFaxOptions reqOptions = options.orElse(null);
            reqOptions.getContact().ifPresent(x -> params.add(new BasicNameValuePair("contact", x)));
            reqOptions.getCsid().ifPresent(x -> params.add(new BasicNameValuePair("csid", x)));
            reqOptions.getFitToPage().ifPresent(x -> params.add(new BasicNameValuePair("fitToPage", x)));
            reqOptions.getPageHeader().ifPresent(x -> params.add(new BasicNameValuePair("pageHeader", x)));
            reqOptions.getPageOrientation().ifPresent(x -> params.add(new BasicNameValuePair("pageOrientation", x)));
            reqOptions.getPageSize().ifPresent(x -> params.add(new BasicNameValuePair("pageSize", x)));
            reqOptions.getPostponeTime().ifPresent(x -> params.add(new BasicNameValuePair("postponeTime", x.toString())));
            reqOptions.getReference().ifPresent(x -> params.add(new BasicNameValuePair("reference", x)));
            reqOptions.getRendering().ifPresent(x -> params.add(new BasicNameValuePair("rendering", x)));
            reqOptions.getReplyAddress().ifPresent(x -> params.add(new BasicNameValuePair("replyAddress", x)));
            reqOptions.getResolution().ifPresent(x -> params.add(new BasicNameValuePair("resolution", x)));
            reqOptions.getRetriesToPerform().ifPresent(x -> params.add(new BasicNameValuePair("retriesToPerform", String.valueOf(x))));
        }
        uriBuilder.setParameters(params);
        return uriBuilder.build();
    }

    protected URI getOutboundDocumentsUri(File fileToUpload, Optional<DocumentUploadSessionOptions> options) {
        DocumentUploadSessionOptions reqOptions = options.orElse(null);
        UriBuilder outboundDocumentsUriBuilder = UriBuilder.fromPath((String)this.outboundDocumentsEndpoint).scheme(this.scheme).host(this.hostname).port(this.port).queryParam("size", new Object[]{options.isPresent() ? reqOptions.getSize().orElse(fileToUpload.length()).longValue() : fileToUpload.length()}).queryParam("name", new Object[]{options.isPresent() ? reqOptions.getName().orElse(fileToUpload.getName()) : fileToUpload.getName()});
        if (options.isPresent()) {
            reqOptions.getDisposition().ifPresent(x -> outboundDocumentsUriBuilder.queryParam("disposition", new Object[]{x.toString()}));
            reqOptions.getSharing().ifPresent(x -> outboundDocumentsUriBuilder.queryParam("sharing", new Object[]{x.toString()}));
        }
        return outboundDocumentsUriBuilder.build(new Object[0]);
    }

    protected URI getUploadedDocumentListUri(Optional<GetUploadedDocumentsListOptions> options) {
        GetUploadedDocumentsListOptions reqOptions = options.orElse(null);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.outboundDocumentsEndpoint).scheme(this.scheme).host(this.hostname).port(this.port);
        if (options.isPresent()) {
            reqOptions.getLimit().ifPresent(x -> uriBuilder.queryParam("limit", new Object[]{reqOptions.getLimit().get()}));
            reqOptions.getOffset().ifPresent(x -> uriBuilder.queryParam("offset", new Object[]{reqOptions.getOffset().get()}));
        }
        return uriBuilder.build(new Object[0]);
    }

    protected void initialiseCredentials() {
        ClientCredentials clientCredentials = new ConfigLoader<ClientCredentials>(ClientCredentials.class, "interfax-api-credentials.yaml").getTestConfig();
        this.username = clientCredentials.getUsername();
        this.password = clientCredentials.getPassword();
    }

    protected void readConfigAndInitializeEndpoints(ClientConfig clientConfig) {
        this.outboundFaxesEndpoint = clientConfig.getInterFAX().getOutboundFaxesEndpoint();
        this.outboundFaxesCompletedEndpoint = clientConfig.getInterFAX().getOutboundFaxesCompletedEndpoint();
        this.outboundFaxesRecordEndpoint = clientConfig.getInterFAX().getOutboundFaxesRecordEndpoint();
        this.outboundFaxImageEndpoint = clientConfig.getInterFAX().getOutboundFaxImageEndpoint();
        this.outboundFaxesCancelEndpoint = clientConfig.getInterFAX().getOutboundFaxesCancelEndpoint();
        this.outboundFaxesResendEndpoint = clientConfig.getInterFAX().getOutboundFaxesResendEndpoint();
        this.outboundFaxesHideEndpoint = clientConfig.getInterFAX().getOutboundFaxesHideEndpoint();
        this.outboundSearchEndpoint = clientConfig.getInterFAX().getOutboundSearchEndpoint();
        this.outboundDocumentsEndpoint = clientConfig.getInterFAX().getOutboundDocumentsEndpoint();
        this.accountsBalanceEndpoint = clientConfig.getInterFAX().getAccountsBalanceEndpoint();
        this.inboundFaxesEndpoint = clientConfig.getInterFAX().getInboundFaxesEndpoint();
        this.inboundFaxesImageEndpoint = clientConfig.getInterFAX().getInboundFaxesImageEndpoint();
        this.inboundFaxesEmailsEndpoint = clientConfig.getInterFAX().getInboundFaxesEmailsEndpoint();
        this.inboundFaxesMarkEndpoint = clientConfig.getInterFAX().getInboundFaxesMarkEndpoint();
        this.inboundFaxesResendEndpoint = clientConfig.getInterFAX().getInboundFaxesResendEndpoint();
    }
}

